/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_STRUCTS_H
#define VN_PROTOCOL_DRIVER_STRUCTS_H

#include "vn_protocol_driver_handles.h"

/*
 * These structs/unions/commands are not included
 *
 *   VkAllocationCallbacks
 */

/* struct VkExtent3D */

static inline size_t
vn_sizeof_VkExtent3D(const VkExtent3D *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->width);
    size += vn_sizeof_uint32_t(&val->height);
    size += vn_sizeof_uint32_t(&val->depth);
    return size;
}

static inline void
vn_encode_VkExtent3D(struct vn_cs_encoder *enc, const VkExtent3D *val)
{
    vn_encode_uint32_t(enc, &val->width);
    vn_encode_uint32_t(enc, &val->height);
    vn_encode_uint32_t(enc, &val->depth);
}

static inline void
vn_decode_VkExtent3D(struct vn_cs_decoder *dec, VkExtent3D *val)
{
    vn_decode_uint32_t(dec, &val->width);
    vn_decode_uint32_t(dec, &val->height);
    vn_decode_uint32_t(dec, &val->depth);
}

static inline size_t
vn_sizeof_VkExtent3D_partial(const VkExtent3D *val)
{
    size_t size = 0;
    /* skip val->width */
    /* skip val->height */
    /* skip val->depth */
    return size;
}

static inline void
vn_encode_VkExtent3D_partial(struct vn_cs_encoder *enc, const VkExtent3D *val)
{
    /* skip val->width */
    /* skip val->height */
    /* skip val->depth */
}

/* struct VkLayerProperties */

static inline size_t
vn_sizeof_VkLayerProperties(const VkLayerProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_array_size(VK_MAX_EXTENSION_NAME_SIZE);
    size += vn_sizeof_char_array(val->layerName, VK_MAX_EXTENSION_NAME_SIZE);
    size += vn_sizeof_uint32_t(&val->specVersion);
    size += vn_sizeof_uint32_t(&val->implementationVersion);
    size += vn_sizeof_array_size(VK_MAX_DESCRIPTION_SIZE);
    size += vn_sizeof_char_array(val->description, VK_MAX_DESCRIPTION_SIZE);
    return size;
}

static inline void
vn_decode_VkLayerProperties(struct vn_cs_decoder *dec, VkLayerProperties *val)
{
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_EXTENSION_NAME_SIZE);
        vn_decode_char_array(dec, val->layerName, array_size);
    }
    vn_decode_uint32_t(dec, &val->specVersion);
    vn_decode_uint32_t(dec, &val->implementationVersion);
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DESCRIPTION_SIZE);
        vn_decode_char_array(dec, val->description, array_size);
    }
}

static inline size_t
vn_sizeof_VkLayerProperties_partial(const VkLayerProperties *val)
{
    size_t size = 0;
    /* skip val->layerName */
    /* skip val->specVersion */
    /* skip val->implementationVersion */
    /* skip val->description */
    return size;
}

static inline void
vn_encode_VkLayerProperties_partial(struct vn_cs_encoder *enc, const VkLayerProperties *val)
{
    /* skip val->layerName */
    /* skip val->specVersion */
    /* skip val->implementationVersion */
    /* skip val->description */
}

/* struct VkExtensionProperties */

static inline size_t
vn_sizeof_VkExtensionProperties(const VkExtensionProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_array_size(VK_MAX_EXTENSION_NAME_SIZE);
    size += vn_sizeof_char_array(val->extensionName, VK_MAX_EXTENSION_NAME_SIZE);
    size += vn_sizeof_uint32_t(&val->specVersion);
    return size;
}

static inline void
vn_encode_VkExtensionProperties(struct vn_cs_encoder *enc, const VkExtensionProperties *val)
{
    vn_encode_array_size(enc, VK_MAX_EXTENSION_NAME_SIZE);
    vn_encode_char_array(enc, val->extensionName, VK_MAX_EXTENSION_NAME_SIZE);
    vn_encode_uint32_t(enc, &val->specVersion);
}

static inline void
vn_decode_VkExtensionProperties(struct vn_cs_decoder *dec, VkExtensionProperties *val)
{
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_EXTENSION_NAME_SIZE);
        vn_decode_char_array(dec, val->extensionName, array_size);
    }
    vn_decode_uint32_t(dec, &val->specVersion);
}

static inline size_t
vn_sizeof_VkExtensionProperties_partial(const VkExtensionProperties *val)
{
    size_t size = 0;
    /* skip val->extensionName */
    /* skip val->specVersion */
    return size;
}

static inline void
vn_encode_VkExtensionProperties_partial(struct vn_cs_encoder *enc, const VkExtensionProperties *val)
{
    /* skip val->extensionName */
    /* skip val->specVersion */
}

/* struct VkMemoryRequirements */

static inline size_t
vn_sizeof_VkMemoryRequirements(const VkMemoryRequirements *val)
{
    size_t size = 0;
    size += vn_sizeof_VkDeviceSize(&val->size);
    size += vn_sizeof_VkDeviceSize(&val->alignment);
    size += vn_sizeof_uint32_t(&val->memoryTypeBits);
    return size;
}

static inline void
vn_decode_VkMemoryRequirements(struct vn_cs_decoder *dec, VkMemoryRequirements *val)
{
    vn_decode_VkDeviceSize(dec, &val->size);
    vn_decode_VkDeviceSize(dec, &val->alignment);
    vn_decode_uint32_t(dec, &val->memoryTypeBits);
}

static inline size_t
vn_sizeof_VkMemoryRequirements_partial(const VkMemoryRequirements *val)
{
    size_t size = 0;
    /* skip val->size */
    /* skip val->alignment */
    /* skip val->memoryTypeBits */
    return size;
}

static inline void
vn_encode_VkMemoryRequirements_partial(struct vn_cs_encoder *enc, const VkMemoryRequirements *val)
{
    /* skip val->size */
    /* skip val->alignment */
    /* skip val->memoryTypeBits */
}

/* struct VkSparseImageFormatProperties */

static inline size_t
vn_sizeof_VkSparseImageFormatProperties(const VkSparseImageFormatProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->aspectMask);
    size += vn_sizeof_VkExtent3D(&val->imageGranularity);
    size += vn_sizeof_VkFlags(&val->flags);
    return size;
}

static inline void
vn_decode_VkSparseImageFormatProperties(struct vn_cs_decoder *dec, VkSparseImageFormatProperties *val)
{
    vn_decode_VkFlags(dec, &val->aspectMask);
    vn_decode_VkExtent3D(dec, &val->imageGranularity);
    vn_decode_VkFlags(dec, &val->flags);
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties_partial(const VkSparseImageFormatProperties *val)
{
    size_t size = 0;
    /* skip val->aspectMask */
    size += vn_sizeof_VkExtent3D_partial(&val->imageGranularity);
    /* skip val->flags */
    return size;
}

static inline void
vn_encode_VkSparseImageFormatProperties_partial(struct vn_cs_encoder *enc, const VkSparseImageFormatProperties *val)
{
    /* skip val->aspectMask */
    vn_encode_VkExtent3D_partial(enc, &val->imageGranularity);
    /* skip val->flags */
}

/* struct VkImageSubresource */

static inline size_t
vn_sizeof_VkImageSubresource(const VkImageSubresource *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->aspectMask);
    size += vn_sizeof_uint32_t(&val->mipLevel);
    size += vn_sizeof_uint32_t(&val->arrayLayer);
    return size;
}

static inline void
vn_encode_VkImageSubresource(struct vn_cs_encoder *enc, const VkImageSubresource *val)
{
    vn_encode_VkFlags(enc, &val->aspectMask);
    vn_encode_uint32_t(enc, &val->mipLevel);
    vn_encode_uint32_t(enc, &val->arrayLayer);
}

/* struct VkOffset3D */

static inline size_t
vn_sizeof_VkOffset3D(const VkOffset3D *val)
{
    size_t size = 0;
    size += vn_sizeof_int32_t(&val->x);
    size += vn_sizeof_int32_t(&val->y);
    size += vn_sizeof_int32_t(&val->z);
    return size;
}

static inline void
vn_encode_VkOffset3D(struct vn_cs_encoder *enc, const VkOffset3D *val)
{
    vn_encode_int32_t(enc, &val->x);
    vn_encode_int32_t(enc, &val->y);
    vn_encode_int32_t(enc, &val->z);
}

/* struct VkSemaphoreTypeCreateInfo chain */

static inline size_t
vn_sizeof_VkSemaphoreTypeCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSemaphoreTypeCreateInfo_self(const VkSemaphoreTypeCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSemaphoreType(&val->semaphoreType);
    size += vn_sizeof_uint64_t(&val->initialValue);
    return size;
}

static inline size_t
vn_sizeof_VkSemaphoreTypeCreateInfo(const VkSemaphoreTypeCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSemaphoreTypeCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkSemaphoreTypeCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkSemaphoreTypeCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSemaphoreTypeCreateInfo_self(struct vn_cs_encoder *enc, const VkSemaphoreTypeCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSemaphoreType(enc, &val->semaphoreType);
    vn_encode_uint64_t(enc, &val->initialValue);
}

static inline void
vn_encode_VkSemaphoreTypeCreateInfo(struct vn_cs_encoder *enc, const VkSemaphoreTypeCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO });
    vn_encode_VkSemaphoreTypeCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkSemaphoreTypeCreateInfo_self(enc, val);
}

/* struct VkImageFormatListCreateInfo chain */

static inline size_t
vn_sizeof_VkImageFormatListCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageFormatListCreateInfo_self(const VkImageFormatListCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->viewFormatCount);
    if (val->pViewFormats) {
        size += vn_sizeof_array_size(val->viewFormatCount);
        size += vn_sizeof_VkFormat_array(val->pViewFormats, val->viewFormatCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkImageFormatListCreateInfo(const VkImageFormatListCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageFormatListCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkImageFormatListCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkImageFormatListCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageFormatListCreateInfo_self(struct vn_cs_encoder *enc, const VkImageFormatListCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->viewFormatCount);
    if (val->pViewFormats) {
        vn_encode_array_size(enc, val->viewFormatCount);
        vn_encode_VkFormat_array(enc, val->pViewFormats, val->viewFormatCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkImageFormatListCreateInfo(struct vn_cs_encoder *enc, const VkImageFormatListCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO });
    vn_encode_VkImageFormatListCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkImageFormatListCreateInfo_self(enc, val);
}

/* struct VkImageStencilUsageCreateInfo chain */

static inline size_t
vn_sizeof_VkImageStencilUsageCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageStencilUsageCreateInfo_self(const VkImageStencilUsageCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->stencilUsage);
    return size;
}

static inline size_t
vn_sizeof_VkImageStencilUsageCreateInfo(const VkImageStencilUsageCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageStencilUsageCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkImageStencilUsageCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkImageStencilUsageCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageStencilUsageCreateInfo_self(struct vn_cs_encoder *enc, const VkImageStencilUsageCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->stencilUsage);
}

static inline void
vn_encode_VkImageStencilUsageCreateInfo(struct vn_cs_encoder *enc, const VkImageStencilUsageCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO });
    vn_encode_VkImageStencilUsageCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkImageStencilUsageCreateInfo_self(enc, val);
}

/* struct VkComponentMapping */

static inline size_t
vn_sizeof_VkComponentMapping(const VkComponentMapping *val)
{
    size_t size = 0;
    size += vn_sizeof_VkComponentSwizzle(&val->r);
    size += vn_sizeof_VkComponentSwizzle(&val->g);
    size += vn_sizeof_VkComponentSwizzle(&val->b);
    size += vn_sizeof_VkComponentSwizzle(&val->a);
    return size;
}

static inline void
vn_encode_VkComponentMapping(struct vn_cs_encoder *enc, const VkComponentMapping *val)
{
    vn_encode_VkComponentSwizzle(enc, &val->r);
    vn_encode_VkComponentSwizzle(enc, &val->g);
    vn_encode_VkComponentSwizzle(enc, &val->b);
    vn_encode_VkComponentSwizzle(enc, &val->a);
}

static inline void
vn_decode_VkComponentMapping(struct vn_cs_decoder *dec, VkComponentMapping *val)
{
    vn_decode_VkComponentSwizzle(dec, &val->r);
    vn_decode_VkComponentSwizzle(dec, &val->g);
    vn_decode_VkComponentSwizzle(dec, &val->b);
    vn_decode_VkComponentSwizzle(dec, &val->a);
}

static inline size_t
vn_sizeof_VkComponentMapping_partial(const VkComponentMapping *val)
{
    size_t size = 0;
    /* skip val->r */
    /* skip val->g */
    /* skip val->b */
    /* skip val->a */
    return size;
}

static inline void
vn_encode_VkComponentMapping_partial(struct vn_cs_encoder *enc, const VkComponentMapping *val)
{
    /* skip val->r */
    /* skip val->g */
    /* skip val->b */
    /* skip val->a */
}

/* struct VkImageSubresourceRange */

static inline size_t
vn_sizeof_VkImageSubresourceRange(const VkImageSubresourceRange *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->aspectMask);
    size += vn_sizeof_uint32_t(&val->baseMipLevel);
    size += vn_sizeof_uint32_t(&val->levelCount);
    size += vn_sizeof_uint32_t(&val->baseArrayLayer);
    size += vn_sizeof_uint32_t(&val->layerCount);
    return size;
}

static inline void
vn_encode_VkImageSubresourceRange(struct vn_cs_encoder *enc, const VkImageSubresourceRange *val)
{
    vn_encode_VkFlags(enc, &val->aspectMask);
    vn_encode_uint32_t(enc, &val->baseMipLevel);
    vn_encode_uint32_t(enc, &val->levelCount);
    vn_encode_uint32_t(enc, &val->baseArrayLayer);
    vn_encode_uint32_t(enc, &val->layerCount);
}

/* struct VkSamplerYcbcrConversionInfo chain */

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionInfo_self(const VkSamplerYcbcrConversionInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSamplerYcbcrConversion(&val->conversion);
    return size;
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionInfo(const VkSamplerYcbcrConversionInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSamplerYcbcrConversionInfo_pnext(val->pNext);
    size += vn_sizeof_VkSamplerYcbcrConversionInfo_self(val);

    return size;
}

static inline void
vn_encode_VkSamplerYcbcrConversionInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSamplerYcbcrConversionInfo_self(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSamplerYcbcrConversion(enc, &val->conversion);
}

static inline void
vn_encode_VkSamplerYcbcrConversionInfo(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO });
    vn_encode_VkSamplerYcbcrConversionInfo_pnext(enc, val->pNext);
    vn_encode_VkSamplerYcbcrConversionInfo_self(enc, val);
}

/* struct VkShaderModuleCreateInfo chain */

static inline size_t
vn_sizeof_VkShaderModuleCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkShaderModuleCreateInfo_self(const VkShaderModuleCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_size_t(&val->codeSize);
    if (val->pCode) {
        size += vn_sizeof_array_size(val->codeSize / 4);
        size += vn_sizeof_uint32_t_array(val->pCode, val->codeSize / 4);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkShaderModuleCreateInfo(const VkShaderModuleCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkShaderModuleCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkShaderModuleCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkShaderModuleCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkShaderModuleCreateInfo_self(struct vn_cs_encoder *enc, const VkShaderModuleCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_size_t(enc, &val->codeSize);
    if (val->pCode) {
        vn_encode_array_size(enc, val->codeSize / 4);
        vn_encode_uint32_t_array(enc, val->pCode, val->codeSize / 4);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkShaderModuleCreateInfo(struct vn_cs_encoder *enc, const VkShaderModuleCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO });
    vn_encode_VkShaderModuleCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkShaderModuleCreateInfo_self(enc, val);
}

/* struct VkViewport */

static inline size_t
vn_sizeof_VkViewport(const VkViewport *val)
{
    size_t size = 0;
    size += vn_sizeof_float(&val->x);
    size += vn_sizeof_float(&val->y);
    size += vn_sizeof_float(&val->width);
    size += vn_sizeof_float(&val->height);
    size += vn_sizeof_float(&val->minDepth);
    size += vn_sizeof_float(&val->maxDepth);
    return size;
}

static inline void
vn_encode_VkViewport(struct vn_cs_encoder *enc, const VkViewport *val)
{
    vn_encode_float(enc, &val->x);
    vn_encode_float(enc, &val->y);
    vn_encode_float(enc, &val->width);
    vn_encode_float(enc, &val->height);
    vn_encode_float(enc, &val->minDepth);
    vn_encode_float(enc, &val->maxDepth);
}

/* struct VkOffset2D */

static inline size_t
vn_sizeof_VkOffset2D(const VkOffset2D *val)
{
    size_t size = 0;
    size += vn_sizeof_int32_t(&val->x);
    size += vn_sizeof_int32_t(&val->y);
    return size;
}

static inline void
vn_encode_VkOffset2D(struct vn_cs_encoder *enc, const VkOffset2D *val)
{
    vn_encode_int32_t(enc, &val->x);
    vn_encode_int32_t(enc, &val->y);
}

static inline void
vn_decode_VkOffset2D(struct vn_cs_decoder *dec, VkOffset2D *val)
{
    vn_decode_int32_t(dec, &val->x);
    vn_decode_int32_t(dec, &val->y);
}

static inline size_t
vn_sizeof_VkOffset2D_partial(const VkOffset2D *val)
{
    size_t size = 0;
    /* skip val->x */
    /* skip val->y */
    return size;
}

static inline void
vn_encode_VkOffset2D_partial(struct vn_cs_encoder *enc, const VkOffset2D *val)
{
    /* skip val->x */
    /* skip val->y */
}

/* struct VkExtent2D */

static inline size_t
vn_sizeof_VkExtent2D(const VkExtent2D *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->width);
    size += vn_sizeof_uint32_t(&val->height);
    return size;
}

static inline void
vn_encode_VkExtent2D(struct vn_cs_encoder *enc, const VkExtent2D *val)
{
    vn_encode_uint32_t(enc, &val->width);
    vn_encode_uint32_t(enc, &val->height);
}

static inline void
vn_decode_VkExtent2D(struct vn_cs_decoder *dec, VkExtent2D *val)
{
    vn_decode_uint32_t(dec, &val->width);
    vn_decode_uint32_t(dec, &val->height);
}

static inline size_t
vn_sizeof_VkExtent2D_partial(const VkExtent2D *val)
{
    size_t size = 0;
    /* skip val->width */
    /* skip val->height */
    return size;
}

static inline void
vn_encode_VkExtent2D_partial(struct vn_cs_encoder *enc, const VkExtent2D *val)
{
    /* skip val->width */
    /* skip val->height */
}

/* struct VkRect2D */

static inline size_t
vn_sizeof_VkRect2D(const VkRect2D *val)
{
    size_t size = 0;
    size += vn_sizeof_VkOffset2D(&val->offset);
    size += vn_sizeof_VkExtent2D(&val->extent);
    return size;
}

static inline void
vn_encode_VkRect2D(struct vn_cs_encoder *enc, const VkRect2D *val)
{
    vn_encode_VkOffset2D(enc, &val->offset);
    vn_encode_VkExtent2D(enc, &val->extent);
}

static inline void
vn_decode_VkRect2D(struct vn_cs_decoder *dec, VkRect2D *val)
{
    vn_decode_VkOffset2D(dec, &val->offset);
    vn_decode_VkExtent2D(dec, &val->extent);
}

static inline size_t
vn_sizeof_VkRect2D_partial(const VkRect2D *val)
{
    size_t size = 0;
    size += vn_sizeof_VkOffset2D_partial(&val->offset);
    size += vn_sizeof_VkExtent2D_partial(&val->extent);
    return size;
}

static inline void
vn_encode_VkRect2D_partial(struct vn_cs_encoder *enc, const VkRect2D *val)
{
    vn_encode_VkOffset2D_partial(enc, &val->offset);
    vn_encode_VkExtent2D_partial(enc, &val->extent);
}

/* union VkClearColorValue */

static inline size_t
vn_sizeof_VkClearColorValue_tag(const VkClearColorValue *val, uint32_t tag)
{
    size_t size = vn_sizeof_uint32_t(&tag);
    switch (tag) {
    case 0:
        size += vn_sizeof_array_size(4);
    size += vn_sizeof_float_array(val->float32, 4);
        break;
    case 1:
        size += vn_sizeof_array_size(4);
    size += vn_sizeof_int32_t_array(val->int32, 4);
        break;
    case 2:
        size += vn_sizeof_array_size(4);
    size += vn_sizeof_uint32_t_array(val->uint32, 4);
        break;
    default:
        assert(false);
        break;
    }
    return size;
}

static inline size_t
vn_sizeof_VkClearColorValue(const VkClearColorValue *val)
{
    return vn_sizeof_VkClearColorValue_tag(val, 2);
}

static inline void
vn_encode_VkClearColorValue_tag(struct vn_cs_encoder *enc, const VkClearColorValue *val, uint32_t tag)
{
    vn_encode_uint32_t(enc, &tag);
    switch (tag) {
    case 0:
        vn_encode_array_size(enc, 4);
    vn_encode_float_array(enc, val->float32, 4);
        break;
    case 1:
        vn_encode_array_size(enc, 4);
    vn_encode_int32_t_array(enc, val->int32, 4);
        break;
    case 2:
        vn_encode_array_size(enc, 4);
    vn_encode_uint32_t_array(enc, val->uint32, 4);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_encode_VkClearColorValue(struct vn_cs_encoder *enc, const VkClearColorValue *val)
{
    vn_encode_VkClearColorValue_tag(enc, val, 2); /* union with default tag */
}

/* struct VkMutableDescriptorTypeListEXT */

static inline size_t
vn_sizeof_VkMutableDescriptorTypeListEXT(const VkMutableDescriptorTypeListEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->descriptorTypeCount);
    if (val->pDescriptorTypes) {
        size += vn_sizeof_array_size(val->descriptorTypeCount);
        size += vn_sizeof_VkDescriptorType_array(val->pDescriptorTypes, val->descriptorTypeCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline void
vn_encode_VkMutableDescriptorTypeListEXT(struct vn_cs_encoder *enc, const VkMutableDescriptorTypeListEXT *val)
{
    vn_encode_uint32_t(enc, &val->descriptorTypeCount);
    if (val->pDescriptorTypes) {
        vn_encode_array_size(enc, val->descriptorTypeCount);
        vn_encode_VkDescriptorType_array(enc, val->pDescriptorTypes, val->descriptorTypeCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

/* struct VkMutableDescriptorTypeCreateInfoEXT chain */

static inline size_t
vn_sizeof_VkMutableDescriptorTypeCreateInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMutableDescriptorTypeCreateInfoEXT_self(const VkMutableDescriptorTypeCreateInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->mutableDescriptorTypeListCount);
    if (val->pMutableDescriptorTypeLists) {
        size += vn_sizeof_array_size(val->mutableDescriptorTypeListCount);
        for (uint32_t i = 0; i < val->mutableDescriptorTypeListCount; i++)
            size += vn_sizeof_VkMutableDescriptorTypeListEXT(&val->pMutableDescriptorTypeLists[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkMutableDescriptorTypeCreateInfoEXT(const VkMutableDescriptorTypeCreateInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMutableDescriptorTypeCreateInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkMutableDescriptorTypeCreateInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkMutableDescriptorTypeCreateInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMutableDescriptorTypeCreateInfoEXT_self(struct vn_cs_encoder *enc, const VkMutableDescriptorTypeCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->mutableDescriptorTypeListCount);
    if (val->pMutableDescriptorTypeLists) {
        vn_encode_array_size(enc, val->mutableDescriptorTypeListCount);
        for (uint32_t i = 0; i < val->mutableDescriptorTypeListCount; i++)
            vn_encode_VkMutableDescriptorTypeListEXT(enc, &val->pMutableDescriptorTypeLists[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkMutableDescriptorTypeCreateInfoEXT(struct vn_cs_encoder *enc, const VkMutableDescriptorTypeCreateInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT });
    vn_encode_VkMutableDescriptorTypeCreateInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkMutableDescriptorTypeCreateInfoEXT_self(enc, val);
}

/* struct VkDescriptorImageInfo */

static inline size_t
vn_sizeof_VkDescriptorImageInfo(const VkDescriptorImageInfo *val)
{
    size_t size = 0;
    size += vn_sizeof_VkSampler(&val->sampler);
    size += vn_sizeof_VkImageView(&val->imageView);
    size += vn_sizeof_VkImageLayout(&val->imageLayout);
    return size;
}

static inline void
vn_encode_VkDescriptorImageInfo(struct vn_cs_encoder *enc, const VkDescriptorImageInfo *val)
{
    vn_encode_VkSampler(enc, &val->sampler);
    vn_encode_VkImageView(enc, &val->imageView);
    vn_encode_VkImageLayout(enc, &val->imageLayout);
}

/* struct VkDescriptorBufferInfo */

static inline size_t
vn_sizeof_VkDescriptorBufferInfo(const VkDescriptorBufferInfo *val)
{
    size_t size = 0;
    size += vn_sizeof_VkBuffer(&val->buffer);
    size += vn_sizeof_VkDeviceSize(&val->offset);
    size += vn_sizeof_VkDeviceSize(&val->range);
    return size;
}

static inline void
vn_encode_VkDescriptorBufferInfo(struct vn_cs_encoder *enc, const VkDescriptorBufferInfo *val)
{
    vn_encode_VkBuffer(enc, &val->buffer);
    vn_encode_VkDeviceSize(enc, &val->offset);
    vn_encode_VkDeviceSize(enc, &val->range);
}

/* struct VkWriteDescriptorSetInlineUniformBlock chain */

static inline size_t
vn_sizeof_VkWriteDescriptorSetInlineUniformBlock_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkWriteDescriptorSetInlineUniformBlock_self(const VkWriteDescriptorSetInlineUniformBlock *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->dataSize);
    if (val->pData) {
        size += vn_sizeof_array_size(val->dataSize);
        size += vn_sizeof_blob_array(val->pData, val->dataSize);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkWriteDescriptorSetInlineUniformBlock(const VkWriteDescriptorSetInlineUniformBlock *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkWriteDescriptorSetInlineUniformBlock_pnext(val->pNext);
    size += vn_sizeof_VkWriteDescriptorSetInlineUniformBlock_self(val);

    return size;
}

static inline void
vn_encode_VkWriteDescriptorSetInlineUniformBlock_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkWriteDescriptorSetInlineUniformBlock_self(struct vn_cs_encoder *enc, const VkWriteDescriptorSetInlineUniformBlock *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->dataSize);
    if (val->pData) {
        vn_encode_array_size(enc, val->dataSize);
        vn_encode_blob_array(enc, val->pData, val->dataSize);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkWriteDescriptorSetInlineUniformBlock(struct vn_cs_encoder *enc, const VkWriteDescriptorSetInlineUniformBlock *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK });
    vn_encode_VkWriteDescriptorSetInlineUniformBlock_pnext(enc, val->pNext);
    vn_encode_VkWriteDescriptorSetInlineUniformBlock_self(enc, val);
}

/* struct VkWriteDescriptorSet chain */

static inline size_t
vn_sizeof_VkWriteDescriptorSet_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkWriteDescriptorSet_pnext(pnext->pNext);
            size += vn_sizeof_VkWriteDescriptorSetInlineUniformBlock_self((const VkWriteDescriptorSetInlineUniformBlock *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkWriteDescriptorSet_self(const VkWriteDescriptorSet *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDescriptorSet(&val->dstSet);
    size += vn_sizeof_uint32_t(&val->dstBinding);
    size += vn_sizeof_uint32_t(&val->dstArrayElement);
    size += vn_sizeof_uint32_t(&val->descriptorCount);
    size += vn_sizeof_VkDescriptorType(&val->descriptorType);
    if (val->pImageInfo) {
        size += vn_sizeof_array_size(val->descriptorCount);
        for (uint32_t i = 0; i < val->descriptorCount; i++)
            size += vn_sizeof_VkDescriptorImageInfo(&val->pImageInfo[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    if (val->pBufferInfo) {
        size += vn_sizeof_array_size(val->descriptorCount);
        for (uint32_t i = 0; i < val->descriptorCount; i++)
            size += vn_sizeof_VkDescriptorBufferInfo(&val->pBufferInfo[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    if (val->pTexelBufferView) {
        size += vn_sizeof_array_size(val->descriptorCount);
        for (uint32_t i = 0; i < val->descriptorCount; i++)
            size += vn_sizeof_VkBufferView(&val->pTexelBufferView[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkWriteDescriptorSet(const VkWriteDescriptorSet *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkWriteDescriptorSet_pnext(val->pNext);
    size += vn_sizeof_VkWriteDescriptorSet_self(val);

    return size;
}

static inline void
vn_encode_VkWriteDescriptorSet_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkWriteDescriptorSet_pnext(enc, pnext->pNext);
            vn_encode_VkWriteDescriptorSetInlineUniformBlock_self(enc, (const VkWriteDescriptorSetInlineUniformBlock *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkWriteDescriptorSet_self(struct vn_cs_encoder *enc, const VkWriteDescriptorSet *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDescriptorSet(enc, &val->dstSet);
    vn_encode_uint32_t(enc, &val->dstBinding);
    vn_encode_uint32_t(enc, &val->dstArrayElement);
    vn_encode_uint32_t(enc, &val->descriptorCount);
    vn_encode_VkDescriptorType(enc, &val->descriptorType);
    if (val->pImageInfo) {
        vn_encode_array_size(enc, val->descriptorCount);
        for (uint32_t i = 0; i < val->descriptorCount; i++)
            vn_encode_VkDescriptorImageInfo(enc, &val->pImageInfo[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (val->pBufferInfo) {
        vn_encode_array_size(enc, val->descriptorCount);
        for (uint32_t i = 0; i < val->descriptorCount; i++)
            vn_encode_VkDescriptorBufferInfo(enc, &val->pBufferInfo[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (val->pTexelBufferView) {
        vn_encode_array_size(enc, val->descriptorCount);
        for (uint32_t i = 0; i < val->descriptorCount; i++)
            vn_encode_VkBufferView(enc, &val->pTexelBufferView[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkWriteDescriptorSet(struct vn_cs_encoder *enc, const VkWriteDescriptorSet *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET });
    vn_encode_VkWriteDescriptorSet_pnext(enc, val->pNext);
    vn_encode_VkWriteDescriptorSet_self(enc, val);
}

/* struct VkMemoryDedicatedRequirements chain */

static inline size_t
vn_sizeof_VkMemoryDedicatedRequirements_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryDedicatedRequirements_self(const VkMemoryDedicatedRequirements *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->prefersDedicatedAllocation);
    size += vn_sizeof_VkBool32(&val->requiresDedicatedAllocation);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryDedicatedRequirements(const VkMemoryDedicatedRequirements *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryDedicatedRequirements_pnext(val->pNext);
    size += vn_sizeof_VkMemoryDedicatedRequirements_self(val);

    return size;
}

static inline void
vn_decode_VkMemoryDedicatedRequirements_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkMemoryDedicatedRequirements_self(struct vn_cs_decoder *dec, VkMemoryDedicatedRequirements *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->prefersDedicatedAllocation);
    vn_decode_VkBool32(dec, &val->requiresDedicatedAllocation);
}

static inline void
vn_decode_VkMemoryDedicatedRequirements(struct vn_cs_decoder *dec, VkMemoryDedicatedRequirements *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS);

    assert(val->sType == stype);
    vn_decode_VkMemoryDedicatedRequirements_pnext(dec, val->pNext);
    vn_decode_VkMemoryDedicatedRequirements_self(dec, val);
}

static inline size_t
vn_sizeof_VkMemoryDedicatedRequirements_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryDedicatedRequirements_self_partial(const VkMemoryDedicatedRequirements *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->prefersDedicatedAllocation */
    /* skip val->requiresDedicatedAllocation */
    return size;
}

static inline size_t
vn_sizeof_VkMemoryDedicatedRequirements_partial(const VkMemoryDedicatedRequirements *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryDedicatedRequirements_pnext_partial(val->pNext);
    size += vn_sizeof_VkMemoryDedicatedRequirements_self_partial(val);

    return size;
}

static inline void
vn_encode_VkMemoryDedicatedRequirements_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryDedicatedRequirements_self_partial(struct vn_cs_encoder *enc, const VkMemoryDedicatedRequirements *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->prefersDedicatedAllocation */
    /* skip val->requiresDedicatedAllocation */
}

static inline void
vn_encode_VkMemoryDedicatedRequirements_partial(struct vn_cs_encoder *enc, const VkMemoryDedicatedRequirements *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS });
    vn_encode_VkMemoryDedicatedRequirements_pnext_partial(enc, val->pNext);
    vn_encode_VkMemoryDedicatedRequirements_self_partial(enc, val);
}

/* struct VkMemoryRequirements2 chain */

static inline size_t
vn_sizeof_VkMemoryRequirements2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkMemoryRequirements2_pnext(pnext->pNext);
            size += vn_sizeof_VkMemoryDedicatedRequirements_self((const VkMemoryDedicatedRequirements *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryRequirements2_self(const VkMemoryRequirements2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkMemoryRequirements(&val->memoryRequirements);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryRequirements2(const VkMemoryRequirements2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryRequirements2_pnext(val->pNext);
    size += vn_sizeof_VkMemoryRequirements2_self(val);

    return size;
}

static inline void
vn_decode_VkMemoryRequirements2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;

        pnext = pnext->pNext;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
        vn_decode_VkMemoryRequirements2_pnext(dec, pnext->pNext);
        vn_decode_VkMemoryDedicatedRequirements_self(dec, (VkMemoryDedicatedRequirements *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkMemoryRequirements2_self(struct vn_cs_decoder *dec, VkMemoryRequirements2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkMemoryRequirements(dec, &val->memoryRequirements);
}

static inline void
vn_decode_VkMemoryRequirements2(struct vn_cs_decoder *dec, VkMemoryRequirements2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2);

    assert(val->sType == stype);
    vn_decode_VkMemoryRequirements2_pnext(dec, val->pNext);
    vn_decode_VkMemoryRequirements2_self(dec, val);
}

static inline size_t
vn_sizeof_VkMemoryRequirements2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkMemoryRequirements2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkMemoryDedicatedRequirements_self_partial((const VkMemoryDedicatedRequirements *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryRequirements2_self_partial(const VkMemoryRequirements2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkMemoryRequirements_partial(&val->memoryRequirements);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryRequirements2_partial(const VkMemoryRequirements2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryRequirements2_pnext_partial(val->pNext);
    size += vn_sizeof_VkMemoryRequirements2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkMemoryRequirements2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkMemoryRequirements2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkMemoryDedicatedRequirements_self_partial(enc, (const VkMemoryDedicatedRequirements *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryRequirements2_self_partial(struct vn_cs_encoder *enc, const VkMemoryRequirements2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkMemoryRequirements_partial(enc, &val->memoryRequirements);
}

static inline void
vn_encode_VkMemoryRequirements2_partial(struct vn_cs_encoder *enc, const VkMemoryRequirements2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2 });
    vn_encode_VkMemoryRequirements2_pnext_partial(enc, val->pNext);
    vn_encode_VkMemoryRequirements2_self_partial(enc, val);
}

/* struct VkMemoryBarrier2 chain */

static inline size_t
vn_sizeof_VkMemoryBarrier2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryBarrier2_self(const VkMemoryBarrier2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags64(&val->srcStageMask);
    size += vn_sizeof_VkFlags64(&val->srcAccessMask);
    size += vn_sizeof_VkFlags64(&val->dstStageMask);
    size += vn_sizeof_VkFlags64(&val->dstAccessMask);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryBarrier2(const VkMemoryBarrier2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryBarrier2_pnext(val->pNext);
    size += vn_sizeof_VkMemoryBarrier2_self(val);

    return size;
}

static inline void
vn_encode_VkMemoryBarrier2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryBarrier2_self(struct vn_cs_encoder *enc, const VkMemoryBarrier2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags64(enc, &val->srcStageMask);
    vn_encode_VkFlags64(enc, &val->srcAccessMask);
    vn_encode_VkFlags64(enc, &val->dstStageMask);
    vn_encode_VkFlags64(enc, &val->dstAccessMask);
}

static inline void
vn_encode_VkMemoryBarrier2(struct vn_cs_encoder *enc, const VkMemoryBarrier2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_BARRIER_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_BARRIER_2 });
    vn_encode_VkMemoryBarrier2_pnext(enc, val->pNext);
    vn_encode_VkMemoryBarrier2_self(enc, val);
}

#endif /* VN_PROTOCOL_DRIVER_STRUCTS_H */
