#type_name:sdo_geometry
#package_name:sdo_geometry

CREATE OR REPLACE TYPE SDO_POINT_TYPE FORCE OID '300027' IS OBJECT (
 X NUMBER,
 Y NUMBER,
 Z NUMBER
 );
//

CREATE OR REPLACE TYPE SDO_ELEM_INFO_ARRAY FORCE OID '300029' AS VARRAY (1048576) of NUMBER;
//
CREATE OR REPLACE TYPE SDO_ORDINATE_ARRAY FORCE OID '300030' AS VARRAY (1048576) of NUMBER;
//
CREATE OR REPLACE TYPE SDO_GEOMETRY OID '300028' IS OBJECT (
 SDO_GTYPE NUMBER,
 SDO_SRID NUMBER,
 SDO_POINT SDO_POINT_TYPE,
 SDO_ELEM_INFO SDO_ELEM_INFO_ARRAY,
 SDO_ORDINATES SDO_ORDINATE_ARRAY,
 -- extraction functions
 MEMBER FUNCTION GET_WKB RETURN BLOB DETERMINISTIC,
 MEMBER FUNCTION GET_WKT RETURN CLOB DETERMINISTIC,
 MEMBER FUNCTION Get_GType RETURN NUMBER DETERMINISTIC,
 MEMBER FUNCTION ST_CoordDim RETURN NUMBER DETERMINISTIC,
 MEMBER FUNCTION Get_Dims RETURN NUMBER DETERMINISTIC,
 MEMBER FUNCTION ST_IsValid RETURN NUMBER DETERMINISTIC,
 MEMBER FUNCTION Get_GeoJson RETURN CLOB DETERMINISTIC,
 CONSTRUCTOR FUNCTION SDO_GEOMETRY(wkb IN BLOB, srid IN NUMBER DEFAULT NULL) RETURN SELF AS RESULT DETERMINISTIC,
 CONSTRUCTOR FUNCTION SDO_GEOMETRY(wkt IN CLOB, srid IN NUMBER DEFAULT NULL) RETURN SELF AS RESULT DETERMINISTIC,
 CONSTRUCTOR FUNCTION SDO_GEOMETRY(wkt IN VARCHAR2, srid IN NUMBER DEFAULT NULL) RETURN SELF AS RESULT DETERMINISTIC
);
//
