/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the CollectionRefResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CollectionRefResponse{}

// CollectionRefResponse A serializer for a Collection reference.
type CollectionRefResponse struct {
	Id string `json:"id"`
	Name string `json:"name"`
	// Returns link to a collection.
	Href *string `json:"href,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CollectionRefResponse CollectionRefResponse

// NewCollectionRefResponse instantiates a new CollectionRefResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCollectionRefResponse(id string, name string) *CollectionRefResponse {
	this := CollectionRefResponse{}
	this.Id = id
	this.Name = name
	return &this
}

// NewCollectionRefResponseWithDefaults instantiates a new CollectionRefResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCollectionRefResponseWithDefaults() *CollectionRefResponse {
	this := CollectionRefResponse{}
	return &this
}

// GetId returns the Id field value
func (o *CollectionRefResponse) GetId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *CollectionRefResponse) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *CollectionRefResponse) SetId(v string) {
	o.Id = v
}

// GetName returns the Name field value
func (o *CollectionRefResponse) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CollectionRefResponse) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CollectionRefResponse) SetName(v string) {
	o.Name = v
}

// GetHref returns the Href field value if set, zero value otherwise.
func (o *CollectionRefResponse) GetHref() string {
	if o == nil || IsNil(o.Href) {
		var ret string
		return ret
	}
	return *o.Href
}

// GetHrefOk returns a tuple with the Href field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CollectionRefResponse) GetHrefOk() (*string, bool) {
	if o == nil || IsNil(o.Href) {
		return nil, false
	}
	return o.Href, true
}

// HasHref returns a boolean if a field has been set.
func (o *CollectionRefResponse) HasHref() bool {
	if o != nil && !IsNil(o.Href) {
		return true
	}

	return false
}

// SetHref gets a reference to the given string and assigns it to the Href field.
func (o *CollectionRefResponse) SetHref(v string) {
	o.Href = &v
}

func (o CollectionRefResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CollectionRefResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["name"] = o.Name
	if !IsNil(o.Href) {
		toSerialize["href"] = o.Href
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CollectionRefResponse) UnmarshalJSON(bytes []byte) (err error) {
	varCollectionRefResponse := _CollectionRefResponse{}

	if err = json.Unmarshal(bytes, &varCollectionRefResponse); err == nil {
		*o = CollectionRefResponse(varCollectionRefResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "id")
		delete(additionalProperties, "name")
		delete(additionalProperties, "href")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCollectionRefResponse struct {
	value *CollectionRefResponse
	isSet bool
}

func (v NullableCollectionRefResponse) Get() *CollectionRefResponse {
	return v.value
}

func (v *NullableCollectionRefResponse) Set(val *CollectionRefResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableCollectionRefResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableCollectionRefResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCollectionRefResponse(val *CollectionRefResponse) *NullableCollectionRefResponse {
	return &NullableCollectionRefResponse{value: val, isSet: true}
}

func (v NullableCollectionRefResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCollectionRefResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


