// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"bytes"
	"fmt"
	"io"
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/internal/s3shared/arn"
	"github.com/aws/aws-sdk-go/private/checksum"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/rest"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opAbortMultipartUpload = "AbortMultipartUpload"

// AbortMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the AbortMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AbortMultipartUpload for more information on using the AbortMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AbortMultipartUploadRequest method.
//	req, resp := client.AbortMultipartUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUpload
func (c *S3) AbortMultipartUploadRequest(input *AbortMultipartUploadInput) (req *request.Request, output *AbortMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opAbortMultipartUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &AbortMultipartUploadInput{}
	}

	output = &AbortMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AbortMultipartUpload API operation for Amazon Simple Storage Service.
//
// This action aborts a multipart upload. After a multipart upload is aborted,
// no additional parts can be uploaded using that upload ID. The storage consumed
// by any previously uploaded parts will be freed. However, if any part uploads
// are currently in progress, those part uploads might or might not succeed.
// As a result, it might be necessary to abort a given multipart upload multiple
// times in order to completely free all storage consumed by all parts.
//
// To verify that all parts have been removed, so you don't get charged for
// the part storage, you should call the ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
// action and ensure that the parts list is empty.
//
// For information about permissions required to use the multipart upload, see
// Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// The following operations are related to AbortMultipartUpload:
//
//   - CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//   - UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//   - CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//   - ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//   - ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation AbortMultipartUpload for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeNoSuchUpload "NoSuchUpload"
//     The specified multipart upload does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUpload
func (c *S3) AbortMultipartUpload(input *AbortMultipartUploadInput) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	return out, req.Send()
}

// AbortMultipartUploadWithContext is the same as AbortMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See AbortMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) AbortMultipartUploadWithContext(ctx aws.Context, input *AbortMultipartUploadInput, opts ...request.Option) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCompleteMultipartUpload = "CompleteMultipartUpload"

// CompleteMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteMultipartUpload for more information on using the CompleteMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CompleteMultipartUploadRequest method.
//	req, resp := client.CompleteMultipartUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUpload
func (c *S3) CompleteMultipartUploadRequest(input *CompleteMultipartUploadInput) (req *request.Request, output *CompleteMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CompleteMultipartUploadInput{}
	}

	output = &CompleteMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CompleteMultipartUpload API operation for Amazon Simple Storage Service.
//
// Completes a multipart upload by assembling previously uploaded parts.
//
// You first initiate the multipart upload and then upload all parts using the
// UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
// operation. After successfully uploading all relevant parts of an upload,
// you call this action to complete the upload. Upon receiving this request,
// Amazon S3 concatenates all the parts in ascending order by part number to
// create a new object. In the Complete Multipart Upload request, you must provide
// the parts list. You must ensure that the parts list is complete. This action
// concatenates the parts that you provide in the list. For each part in the
// list, you must provide the part number and the ETag value, returned after
// that part was uploaded.
//
// Processing of a Complete Multipart Upload request could take several minutes
// to complete. After Amazon S3 begins processing the request, it sends an HTTP
// response header that specifies a 200 OK response. While processing is in
// progress, Amazon S3 periodically sends white space characters to keep the
// connection from timing out. Because a request could fail after the initial
// 200 OK response has been sent, it is important that you check the response
// body to determine whether the request succeeded.
//
// Note that if CompleteMultipartUpload fails, applications should be prepared
// to retry the failed requests. For more information, see Amazon S3 Error Best
// Practices (https://docs.aws.amazon.com/AmazonS3/latest/dev/ErrorBestPractices.html).
//
// You cannot use Content-Type: application/x-www-form-urlencoded with Complete
// Multipart Upload requests. Also, if you do not provide a Content-Type header,
// CompleteMultipartUpload returns a 200 OK response.
//
// For more information about multipart uploads, see Uploading Objects Using
// Multipart Upload (https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html).
//
// For information about permissions required to use the multipart upload API,
// see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// CompleteMultipartUpload has the following special errors:
//
//   - Error code: EntityTooSmall Description: Your proposed upload is smaller
//     than the minimum allowed object size. Each part must be at least 5 MB
//     in size, except the last part. 400 Bad Request
//
//   - Error code: InvalidPart Description: One or more of the specified parts
//     could not be found. The part might not have been uploaded, or the specified
//     entity tag might not have matched the part's entity tag. 400 Bad Request
//
//   - Error code: InvalidPartOrder Description: The list of parts was not
//     in ascending order. The parts list must be specified in order by part
//     number. 400 Bad Request
//
//   - Error code: NoSuchUpload Description: The specified multipart upload
//     does not exist. The upload ID might be invalid, or the multipart upload
//     might have been aborted or completed. 404 Not Found
//
// The following operations are related to CompleteMultipartUpload:
//
//   - CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//   - UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//   - AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//   - ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//   - ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CompleteMultipartUpload for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUpload
func (c *S3) CompleteMultipartUpload(input *CompleteMultipartUploadInput) (*CompleteMultipartUploadOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	return out, req.Send()
}

// CompleteMultipartUploadWithContext is the same as CompleteMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CompleteMultipartUploadWithContext(ctx aws.Context, input *CompleteMultipartUploadInput, opts ...request.Option) (*CompleteMultipartUploadOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyObject = "CopyObject"

// CopyObjectRequest generates a "aws/request.Request" representing the
// client's request for the CopyObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyObject for more information on using the CopyObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopyObjectRequest method.
//	req, resp := client.CopyObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObject
func (c *S3) CopyObjectRequest(input *CopyObjectInput) (req *request.Request, output *CopyObjectOutput) {
	op := &request.Operation{
		Name:       opCopyObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CopyObjectInput{}
	}

	output = &CopyObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyObject API operation for Amazon Simple Storage Service.
//
// Creates a copy of an object that is already stored in Amazon S3.
//
// You can store individual objects of up to 5 TB in Amazon S3. You create a
// copy of your object up to 5 GB in size in a single atomic action using this
// API. However, to copy an object greater than 5 GB, you must use the multipart
// upload Upload Part - Copy (UploadPartCopy) API. For more information, see
// Copy Object Using the REST Multipart Upload API (https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjctsUsingRESTMPUapi.html).
//
// All copy requests must be authenticated. Additionally, you must have read
// access to the source object and write access to the destination bucket. For
// more information, see REST Authentication (https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html).
// Both the Region that you want to copy the object from and the Region that
// you want to copy the object to must be enabled for your account.
//
// A copy request might return an error when Amazon S3 receives the copy request
// or while Amazon S3 is copying the files. If the error occurs before the copy
// action starts, you receive a standard Amazon S3 error. If the error occurs
// during the copy operation, the error response is embedded in the 200 OK response.
// This means that a 200 OK response can contain either a success or an error.
// Design your application to parse the contents of the response and handle
// it appropriately.
//
// If the copy is successful, you receive a response with information about
// the copied object.
//
// If the request is an HTTP 1.1 request, the response is chunk encoded. If
// it were not, it would not contain the content-length, and you would need
// to read the entire body.
//
// The copy request charge is based on the storage class and Region that you
// specify for the destination object. For pricing information, see Amazon S3
// pricing (http://aws.amazon.com/s3/pricing/).
//
// Amazon S3 transfer acceleration does not support cross-Region copies. If
// you request a cross-Region copy using a transfer acceleration endpoint, you
// get a 400 Bad Request error. For more information, see Transfer Acceleration
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html).
//
// # Metadata
//
// When copying an object, you can preserve all metadata (default) or specify
// new metadata. However, the ACL is not preserved and is set to private for
// the user making the request. To override the default ACL setting, specify
// a new ACL when generating a copy request. For more information, see Using
// ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html).
//
// To specify whether you want the object metadata copied from the source object
// or replaced with metadata provided in the request, you can optionally add
// the x-amz-metadata-directive header. When you grant permissions, you can
// use the s3:x-amz-metadata-directive condition key to enforce certain metadata
// behavior when objects are uploaded. For more information, see Specifying
// Conditions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html)
// in the Amazon S3 User Guide. For a complete list of Amazon S3-specific condition
// keys, see Actions, Resources, and Condition Keys for Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html).
//
// x-amz-copy-source-if Headers
//
// To only copy an object under certain conditions, such as whether the Etag
// matches or whether the object was modified before or after a specified date,
// use the following request parameters:
//
//   - x-amz-copy-source-if-match
//
//   - x-amz-copy-source-if-none-match
//
//   - x-amz-copy-source-if-unmodified-since
//
//   - x-amz-copy-source-if-modified-since
//
// If both the x-amz-copy-source-if-match and x-amz-copy-source-if-unmodified-since
// headers are present in the request and evaluate as follows, Amazon S3 returns
// 200 OK and copies the data:
//
//   - x-amz-copy-source-if-match condition evaluates to true
//
//   - x-amz-copy-source-if-unmodified-since condition evaluates to false
//
// If both the x-amz-copy-source-if-none-match and x-amz-copy-source-if-modified-since
// headers are present in the request and evaluate as follows, Amazon S3 returns
// the 412 Precondition Failed response code:
//
//   - x-amz-copy-source-if-none-match condition evaluates to false
//
//   - x-amz-copy-source-if-modified-since condition evaluates to true
//
// All headers with the x-amz- prefix, including x-amz-copy-source, must be
// signed.
//
// # Server-side encryption
//
// When you perform a CopyObject operation, you can optionally use the appropriate
// encryption-related headers to encrypt the object using server-side encryption
// with Amazon Web Services managed encryption keys (SSE-S3 or SSE-KMS) or a
// customer-provided encryption key. With server-side encryption, Amazon S3
// encrypts your data as it writes it to disks in its data centers and decrypts
// the data when you access it. For more information about server-side encryption,
// see Using Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html).
//
// If a target object uses SSE-KMS, you can enable an S3 Bucket Key for the
// object. For more information, see Amazon S3 Bucket Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html)
// in the Amazon S3 User Guide.
//
// # Access Control List (ACL)-Specific Request Headers
//
// When copying an object, you can optionally use headers to grant ACL-based
// permissions. By default, all objects are private. Only the owner has full
// access control. When adding a new object, you can grant permissions to individual
// Amazon Web Services accounts or to predefined groups defined by Amazon S3.
// These permissions are then added to the ACL on the object. For more information,
// see Access Control List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html)
// and Managing ACLs Using the REST API (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html).
//
// If the bucket that you're copying objects to uses the bucket owner enforced
// setting for S3 Object Ownership, ACLs are disabled and no longer affect permissions.
// Buckets that use this setting only accept PUT requests that don't specify
// an ACL or PUT requests that specify bucket owner full control ACLs, such
// as the bucket-owner-full-control canned ACL or an equivalent form of this
// ACL expressed in the XML format.
//
// For more information, see Controlling ownership of objects and disabling
// ACLs (https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html)
// in the Amazon S3 User Guide.
//
// If your bucket uses the bucket owner enforced setting for Object Ownership,
// all objects written to the bucket by any account will be owned by the bucket
// owner.
//
// # Checksums
//
// When copying an object, if it has a checksum, that checksum will be copied
// to the new object by default. When you copy the object over, you may optionally
// specify a different checksum algorithm to use with the x-amz-checksum-algorithm
// header.
//
// # Storage Class Options
//
// You can use the CopyObject action to change the storage class of an object
// that is already stored in Amazon S3 using the StorageClass parameter. For
// more information, see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html)
// in the Amazon S3 User Guide.
//
// # Versioning
//
// By default, x-amz-copy-source identifies the current version of an object
// to copy. If the current version is a delete marker, Amazon S3 behaves as
// if the object was deleted. To copy a different version, use the versionId
// subresource.
//
// If you enable versioning on the target bucket, Amazon S3 generates a unique
// version ID for the object being copied. This version ID is different from
// the version ID of the source object. Amazon S3 returns the version ID of
// the copied object in the x-amz-version-id response header in the response.
//
// If you do not enable versioning or suspend it on the target bucket, the version
// ID that Amazon S3 generates is always null.
//
// If the source object's storage class is GLACIER, you must restore a copy
// of this object before you can use it as a source object for the copy operation.
// For more information, see RestoreObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html).
//
// The following operations are related to CopyObject:
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
// For more information, see Copying Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjectsExamples.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CopyObject for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeObjectNotInActiveTierError "ObjectNotInActiveTierError"
//     The source object of the COPY action is not in the active tier and is only
//     stored in Amazon S3 Glacier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObject
func (c *S3) CopyObject(input *CopyObjectInput) (*CopyObjectOutput, error) {
	req, out := c.CopyObjectRequest(input)
	return out, req.Send()
}

// CopyObjectWithContext is the same as CopyObject with the addition of
// the ability to pass a context and additional request options.
//
// See CopyObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CopyObjectWithContext(ctx aws.Context, input *CopyObjectInput, opts ...request.Option) (*CopyObjectOutput, error) {
	req, out := c.CopyObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBucket = "CreateBucket"

// CreateBucketRequest generates a "aws/request.Request" representing the
// client's request for the CreateBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBucket for more information on using the CreateBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBucketRequest method.
//	req, resp := client.CreateBucketRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucket
func (c *S3) CreateBucketRequest(input *CreateBucketInput) (req *request.Request, output *CreateBucketOutput) {
	op := &request.Operation{
		Name:       opCreateBucket,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &CreateBucketInput{}
	}

	output = &CreateBucketOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBucket API operation for Amazon Simple Storage Service.
//
// Creates a new S3 bucket. To create a bucket, you must register with Amazon
// S3 and have a valid Amazon Web Services Access Key ID to authenticate requests.
// Anonymous requests are never allowed to create buckets. By creating the bucket,
// you become the bucket owner.
//
// Not every string is an acceptable bucket name. For information about bucket
// naming restrictions, see Bucket naming rules (https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
//
// If you want to create an Amazon S3 on Outposts bucket, see Create Bucket
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html).
//
// By default, the bucket is created in the US East (N. Virginia) Region. You
// can optionally specify a Region in the request body. You might choose a Region
// to optimize latency, minimize costs, or address regulatory requirements.
// For example, if you reside in Europe, you will probably find it advantageous
// to create buckets in the Europe (Ireland) Region. For more information, see
// Accessing a bucket (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro).
//
// If you send your create bucket request to the s3.amazonaws.com endpoint,
// the request goes to the us-east-1 Region. Accordingly, the signature calculations
// in Signature Version 4 must use us-east-1 as the Region, even if the location
// constraint in the request specifies another Region where the bucket is to
// be created. If you create a bucket in a Region other than US East (N. Virginia),
// your application must be able to handle 307 redirect. For more information,
// see Virtual hosting of buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html).
//
// Access control lists (ACLs)
//
// When creating a bucket using this operation, you can optionally configure
// the bucket ACL to specify the accounts or groups that should be granted specific
// permissions on the bucket.
//
// If your CreateBucket request sets bucket owner enforced for S3 Object Ownership
// and specifies a bucket ACL that provides access to an external Amazon Web
// Services account, your request fails with a 400 error and returns the InvalidBucketAclWithObjectOwnership
// error code. For more information, see Controlling object ownership (https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html)
// in the Amazon S3 User Guide.
//
// There are two ways to grant the appropriate permissions using the request
// headers.
//
//   - Specify a canned ACL using the x-amz-acl request header. Amazon S3 supports
//     a set of predefined ACLs, known as canned ACLs. Each canned ACL has a
//     predefined set of grantees and permissions. For more information, see
//     Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//   - Specify access permissions explicitly using the x-amz-grant-read, x-amz-grant-write,
//     x-amz-grant-read-acp, x-amz-grant-write-acp, and x-amz-grant-full-control
//     headers. These headers map to the set of permissions Amazon S3 supports
//     in an ACL. For more information, see Access control list (ACL) overview
//     (https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html).
//     You specify each grantee as a type=value pair, where the type is one of
//     the following: id – if the value specified is the canonical user ID
//     of an Amazon Web Services account uri – if you are granting permissions
//     to a predefined group emailAddress – if the value specified is the email
//     address of an Amazon Web Services account Using email addresses to specify
//     a grantee is only supported in the following Amazon Web Services Regions:
//     US East (N. Virginia) US West (N. California) US West (Oregon) Asia Pacific
//     (Singapore) Asia Pacific (Sydney) Asia Pacific (Tokyo) Europe (Ireland)
//     South America (São Paulo) For a list of all the Amazon S3 supported Regions
//     and endpoints, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
//     in the Amazon Web Services General Reference. For example, the following
//     x-amz-grant-read header grants the Amazon Web Services accounts identified
//     by account IDs permissions to read object data and its metadata: x-amz-grant-read:
//     id="11112222333", id="444455556666"
//
// You can use either a canned ACL or specify access permissions explicitly.
// You cannot do both.
//
// # Permissions
//
// In addition to s3:CreateBucket, the following permissions are required when
// your CreateBucket includes specific headers:
//
//   - ACLs - If your CreateBucket request specifies ACL permissions and the
//     ACL is public-read, public-read-write, authenticated-read, or if you specify
//     access permissions explicitly through any other ACL, both s3:CreateBucket
//     and s3:PutBucketAcl permissions are needed. If the ACL the CreateBucket
//     request is private or doesn't specify any ACLs, only s3:CreateBucket permission
//     is needed.
//
//   - Object Lock - If ObjectLockEnabledForBucket is set to true in your CreateBucket
//     request, s3:PutBucketObjectLockConfiguration and s3:PutBucketVersioning
//     permissions are required.
//
//   - S3 Object Ownership - If your CreateBucket request includes the the
//     x-amz-object-ownership header, s3:PutBucketOwnershipControls permission
//     is required.
//
// The following operations are related to CreateBucket:
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//   - DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CreateBucket for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeBucketAlreadyExists "BucketAlreadyExists"
//     The requested bucket name is not available. The bucket namespace is shared
//     by all users of the system. Select a different name and try again.
//
//   - ErrCodeBucketAlreadyOwnedByYou "BucketAlreadyOwnedByYou"
//     The bucket you tried to create already exists, and you own it. Amazon S3
//     returns this error in all Amazon Web Services Regions except in the North
//     Virginia Region. For legacy compatibility, if you re-create an existing bucket
//     that you already own in the North Virginia Region, Amazon S3 returns 200
//     OK and resets the bucket access control lists (ACLs).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucket
func (c *S3) CreateBucket(input *CreateBucketInput) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	return out, req.Send()
}

// CreateBucketWithContext is the same as CreateBucket with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CreateBucketWithContext(ctx aws.Context, input *CreateBucketInput, opts ...request.Option) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMultipartUpload = "CreateMultipartUpload"

// CreateMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMultipartUpload for more information on using the CreateMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMultipartUploadRequest method.
//	req, resp := client.CreateMultipartUploadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUpload
func (c *S3) CreateMultipartUploadRequest(input *CreateMultipartUploadInput) (req *request.Request, output *CreateMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCreateMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?uploads",
	}

	if input == nil {
		input = &CreateMultipartUploadInput{}
	}

	output = &CreateMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMultipartUpload API operation for Amazon Simple Storage Service.
//
// This action initiates a multipart upload and returns an upload ID. This upload
// ID is used to associate all of the parts in the specific multipart upload.
// You specify this upload ID in each of your subsequent upload part requests
// (see UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)).
// You also include this upload ID in the final request to either complete or
// abort the multipart upload request.
//
// For more information about multipart uploads, see Multipart Upload Overview
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html).
//
// If you have configured a lifecycle rule to abort incomplete multipart uploads,
// the upload must complete within the number of days specified in the bucket
// lifecycle configuration. Otherwise, the incomplete multipart upload becomes
// eligible for an abort action and Amazon S3 aborts the multipart upload. For
// more information, see Aborting Incomplete Multipart Uploads Using a Bucket
// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config).
//
// For information about the permissions required to use the multipart upload
// API, see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// For request signing, multipart upload is just a series of regular requests.
// You initiate a multipart upload, send one or more requests to upload parts,
// and then complete the multipart upload process. You sign each request individually.
// There is nothing special about signing multipart upload requests. For more
// information about signing, see Authenticating Requests (Amazon Web Services
// Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html).
//
// After you initiate a multipart upload and upload one or more parts, to stop
// being charged for storing the uploaded parts, you must either complete or
// abort the multipart upload. Amazon S3 frees up the space used to store the
// parts and stop charging you for storing them only after you either complete
// or abort a multipart upload.
//
// You can optionally request server-side encryption. For server-side encryption,
// Amazon S3 encrypts your data as it writes it to disks in its data centers
// and decrypts it when you access it. You can provide your own encryption key,
// or use Amazon Web Services KMS keys or Amazon S3-managed encryption keys.
// If you choose to provide your own encryption key, the request headers you
// provide in UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
// and UploadPartCopy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html)
// requests must match the headers you used in the request to initiate the upload
// by using CreateMultipartUpload.
//
// To perform a multipart upload with encryption using an Amazon Web Services
// KMS key, the requester must have permission to the kms:Decrypt and kms:GenerateDataKey*
// actions on the key. These permissions are required because Amazon S3 must
// decrypt and read data from the encrypted file parts before it completes the
// multipart upload. For more information, see Multipart upload API and permissions
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpuAndPermissions)
// in the Amazon S3 User Guide.
//
// If your Identity and Access Management (IAM) user or role is in the same
// Amazon Web Services account as the KMS key, then you must have these permissions
// on the key policy. If your IAM user or role belongs to a different account
// than the key, then you must have the permissions on both the key policy and
// your IAM user or role.
//
// For more information, see Protecting Data Using Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html).
//
// # Access Permissions
//
// When copying an object, you can optionally specify the accounts or groups
// that should be granted specific permissions on the new object. There are
// two ways to grant the permissions using the request headers:
//
//   - Specify a canned ACL with the x-amz-acl request header. For more information,
//     see Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//   - Specify access permissions explicitly with the x-amz-grant-read, x-amz-grant-read-acp,
//     x-amz-grant-write-acp, and x-amz-grant-full-control headers. These parameters
//     map to the set of permissions that Amazon S3 supports in an ACL. For more
//     information, see Access Control List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html).
//
// You can use either a canned ACL or specify access permissions explicitly.
// You cannot do both.
//
// # Server-Side- Encryption-Specific Request Headers
//
// You can optionally tell Amazon S3 to encrypt data at rest using server-side
// encryption. Server-side encryption is for data encryption at rest. Amazon
// S3 encrypts your data as it writes it to disks in its data centers and decrypts
// it when you access it. The option you use depends on whether you want to
// use Amazon Web Services managed encryption keys or provide your own encryption
// key.
//
//   - Use encryption keys managed by Amazon S3 or customer managed key stored
//     in Amazon Web Services Key Management Service (Amazon Web Services KMS)
//     – If you want Amazon Web Services to manage the keys used to encrypt
//     data, specify the following headers in the request. x-amz-server-side-encryption
//     x-amz-server-side-encryption-aws-kms-key-id x-amz-server-side-encryption-context
//     If you specify x-amz-server-side-encryption:aws:kms, but don't provide
//     x-amz-server-side-encryption-aws-kms-key-id, Amazon S3 uses the Amazon
//     Web Services managed key in Amazon Web Services KMS to protect the data.
//     All GET and PUT requests for an object protected by Amazon Web Services
//     KMS fail if you don't make them with SSL or by using SigV4. For more information
//     about server-side encryption with KMS key (SSE-KMS), see Protecting Data
//     Using Server-Side Encryption with KMS keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html).
//
//   - Use customer-provided encryption keys – If you want to manage your
//     own encryption keys, provide all the following headers in the request.
//     x-amz-server-side-encryption-customer-algorithm x-amz-server-side-encryption-customer-key
//     x-amz-server-side-encryption-customer-key-MD5 For more information about
//     server-side encryption with KMS keys (SSE-KMS), see Protecting Data Using
//     Server-Side Encryption with KMS keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html).
//
// # Access-Control-List (ACL)-Specific Request Headers
//
// You also can use the following access control–related headers with this
// operation. By default, all objects are private. Only the owner has full access
// control. When adding a new object, you can grant permissions to individual
// Amazon Web Services accounts or to predefined groups defined by Amazon S3.
// These permissions are then added to the access control list (ACL) on the
// object. For more information, see Using ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html).
// With this operation, you can grant access permissions using one of the following
// two methods:
//
//   - Specify a canned ACL (x-amz-acl) — Amazon S3 supports a set of predefined
//     ACLs, known as canned ACLs. Each canned ACL has a predefined set of grantees
//     and permissions. For more information, see Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//   - Specify access permissions explicitly — To explicitly grant access
//     permissions to specific Amazon Web Services accounts or groups, use the
//     following headers. Each header maps to specific permissions that Amazon
//     S3 supports in an ACL. For more information, see Access Control List (ACL)
//     Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html).
//     In the header, you specify a list of grantees who get the specific permission.
//     To grant permissions explicitly, use: x-amz-grant-read x-amz-grant-write
//     x-amz-grant-read-acp x-amz-grant-write-acp x-amz-grant-full-control You
//     specify each grantee as a type=value pair, where the type is one of the
//     following: id – if the value specified is the canonical user ID of an
//     Amazon Web Services account uri – if you are granting permissions to
//     a predefined group emailAddress – if the value specified is the email
//     address of an Amazon Web Services account Using email addresses to specify
//     a grantee is only supported in the following Amazon Web Services Regions:
//     US East (N. Virginia) US West (N. California) US West (Oregon) Asia Pacific
//     (Singapore) Asia Pacific (Sydney) Asia Pacific (Tokyo) Europe (Ireland)
//     South America (São Paulo) For a list of all the Amazon S3 supported Regions
//     and endpoints, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
//     in the Amazon Web Services General Reference. For example, the following
//     x-amz-grant-read header grants the Amazon Web Services accounts identified
//     by account IDs permissions to read object data and its metadata: x-amz-grant-read:
//     id="11112222333", id="444455556666"
//
// The following operations are related to CreateMultipartUpload:
//
//   - UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//   - CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//   - AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//   - ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//   - ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CreateMultipartUpload for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUpload
func (c *S3) CreateMultipartUpload(input *CreateMultipartUploadInput) (*CreateMultipartUploadOutput, error) {
	req, out := c.CreateMultipartUploadRequest(input)
	return out, req.Send()
}

// CreateMultipartUploadWithContext is the same as CreateMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CreateMultipartUploadWithContext(ctx aws.Context, input *CreateMultipartUploadInput, opts ...request.Option) (*CreateMultipartUploadOutput, error) {
	req, out := c.CreateMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucket = "DeleteBucket"

// DeleteBucketRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucket for more information on using the DeleteBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketRequest method.
//	req, resp := client.DeleteBucketRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucket
func (c *S3) DeleteBucketRequest(input *DeleteBucketInput) (req *request.Request, output *DeleteBucketOutput) {
	op := &request.Operation{
		Name:       opDeleteBucket,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &DeleteBucketInput{}
	}

	output = &DeleteBucketOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucket API operation for Amazon Simple Storage Service.
//
// Deletes the S3 bucket. All objects (including all object versions and delete
// markers) in the bucket must be deleted before the bucket itself can be deleted.
//
// Related Resources
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//   - DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucket for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucket
func (c *S3) DeleteBucket(input *DeleteBucketInput) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	return out, req.Send()
}

// DeleteBucketWithContext is the same as DeleteBucket with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketWithContext(ctx aws.Context, input *DeleteBucketInput, opts ...request.Option) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketAnalyticsConfiguration = "DeleteBucketAnalyticsConfiguration"

// DeleteBucketAnalyticsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketAnalyticsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketAnalyticsConfiguration for more information on using the DeleteBucketAnalyticsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketAnalyticsConfigurationRequest method.
//	req, resp := client.DeleteBucketAnalyticsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfiguration
func (c *S3) DeleteBucketAnalyticsConfigurationRequest(input *DeleteBucketAnalyticsConfigurationInput) (req *request.Request, output *DeleteBucketAnalyticsConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketAnalyticsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &DeleteBucketAnalyticsConfigurationInput{}
	}

	output = &DeleteBucketAnalyticsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketAnalyticsConfiguration API operation for Amazon Simple Storage Service.
//
// Deletes an analytics configuration for the bucket (specified by the analytics
// configuration ID).
//
// To use this operation, you must have permissions to perform the s3:PutAnalyticsConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// For information about the Amazon S3 analytics feature, see Amazon S3 Analytics
// – Storage Class Analysis (https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html).
//
// The following operations are related to DeleteBucketAnalyticsConfiguration:
//
//   - GetBucketAnalyticsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html)
//
//   - ListBucketAnalyticsConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html)
//
//   - PutBucketAnalyticsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketAnalyticsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfiguration
func (c *S3) DeleteBucketAnalyticsConfiguration(input *DeleteBucketAnalyticsConfigurationInput) (*DeleteBucketAnalyticsConfigurationOutput, error) {
	req, out := c.DeleteBucketAnalyticsConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBucketAnalyticsConfigurationWithContext is the same as DeleteBucketAnalyticsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketAnalyticsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketAnalyticsConfigurationWithContext(ctx aws.Context, input *DeleteBucketAnalyticsConfigurationInput, opts ...request.Option) (*DeleteBucketAnalyticsConfigurationOutput, error) {
	req, out := c.DeleteBucketAnalyticsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketCors = "DeleteBucketCors"

// DeleteBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketCors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketCors for more information on using the DeleteBucketCors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketCorsRequest method.
//	req, resp := client.DeleteBucketCorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCors
func (c *S3) DeleteBucketCorsRequest(input *DeleteBucketCorsInput) (req *request.Request, output *DeleteBucketCorsOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketCors,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &DeleteBucketCorsInput{}
	}

	output = &DeleteBucketCorsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketCors API operation for Amazon Simple Storage Service.
//
// Deletes the cors configuration information set for the bucket.
//
// To use this operation, you must have permission to perform the s3:PutBucketCORS
// action. The bucket owner has this permission by default and can grant this
// permission to others.
//
// For information about cors, see Enabling Cross-Origin Resource Sharing (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html)
// in the Amazon S3 User Guide.
//
// Related Resources:
//
//   - PutBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html)
//
//   - RESTOPTIONSobject (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketCors for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCors
func (c *S3) DeleteBucketCors(input *DeleteBucketCorsInput) (*DeleteBucketCorsOutput, error) {
	req, out := c.DeleteBucketCorsRequest(input)
	return out, req.Send()
}

// DeleteBucketCorsWithContext is the same as DeleteBucketCors with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketCors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketCorsWithContext(ctx aws.Context, input *DeleteBucketCorsInput, opts ...request.Option) (*DeleteBucketCorsOutput, error) {
	req, out := c.DeleteBucketCorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketEncryption = "DeleteBucketEncryption"

// DeleteBucketEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketEncryption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketEncryption for more information on using the DeleteBucketEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketEncryptionRequest method.
//	req, resp := client.DeleteBucketEncryptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryption
func (c *S3) DeleteBucketEncryptionRequest(input *DeleteBucketEncryptionInput) (req *request.Request, output *DeleteBucketEncryptionOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketEncryption,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?encryption",
	}

	if input == nil {
		input = &DeleteBucketEncryptionInput{}
	}

	output = &DeleteBucketEncryptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketEncryption API operation for Amazon Simple Storage Service.
//
// This implementation of the DELETE action removes default encryption from
// the bucket. For information about the Amazon S3 default encryption feature,
// see Amazon S3 Default Bucket Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html)
// in the Amazon S3 User Guide.
//
// To use this operation, you must have permissions to perform the s3:PutEncryptionConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html)
// in the Amazon S3 User Guide.
//
// Related Resources
//
//   - PutBucketEncryption (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html)
//
//   - GetBucketEncryption (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketEncryption for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryption
func (c *S3) DeleteBucketEncryption(input *DeleteBucketEncryptionInput) (*DeleteBucketEncryptionOutput, error) {
	req, out := c.DeleteBucketEncryptionRequest(input)
	return out, req.Send()
}

// DeleteBucketEncryptionWithContext is the same as DeleteBucketEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketEncryptionWithContext(ctx aws.Context, input *DeleteBucketEncryptionInput, opts ...request.Option) (*DeleteBucketEncryptionOutput, error) {
	req, out := c.DeleteBucketEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketIntelligentTieringConfiguration = "DeleteBucketIntelligentTieringConfiguration"

// DeleteBucketIntelligentTieringConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketIntelligentTieringConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketIntelligentTieringConfiguration for more information on using the DeleteBucketIntelligentTieringConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketIntelligentTieringConfigurationRequest method.
//	req, resp := client.DeleteBucketIntelligentTieringConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketIntelligentTieringConfiguration
func (c *S3) DeleteBucketIntelligentTieringConfigurationRequest(input *DeleteBucketIntelligentTieringConfigurationInput) (req *request.Request, output *DeleteBucketIntelligentTieringConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketIntelligentTieringConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?intelligent-tiering",
	}

	if input == nil {
		input = &DeleteBucketIntelligentTieringConfigurationInput{}
	}

	output = &DeleteBucketIntelligentTieringConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketIntelligentTieringConfiguration API operation for Amazon Simple Storage Service.
//
// Deletes the S3 Intelligent-Tiering configuration from the specified bucket.
//
// The S3 Intelligent-Tiering storage class is designed to optimize storage
// costs by automatically moving data to the most cost-effective storage access
// tier, without performance impact or operational overhead. S3 Intelligent-Tiering
// delivers automatic cost savings in three low latency and high throughput
// access tiers. To get the lowest storage cost on data that can be accessed
// in minutes to hours, you can choose to activate additional archiving capabilities.
//
// The S3 Intelligent-Tiering storage class is the ideal storage class for data
// with unknown, changing, or unpredictable access patterns, independent of
// object size or retention period. If the size of an object is less than 128
// KB, it is not monitored and not eligible for auto-tiering. Smaller objects
// can be stored, but they are always charged at the Frequent Access tier rates
// in the S3 Intelligent-Tiering storage class.
//
// For more information, see Storage class for automatically optimizing frequently
// and infrequently accessed objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access).
//
// Operations related to DeleteBucketIntelligentTieringConfiguration include:
//
//   - GetBucketIntelligentTieringConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html)
//
//   - PutBucketIntelligentTieringConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html)
//
//   - ListBucketIntelligentTieringConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketIntelligentTieringConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketIntelligentTieringConfiguration
func (c *S3) DeleteBucketIntelligentTieringConfiguration(input *DeleteBucketIntelligentTieringConfigurationInput) (*DeleteBucketIntelligentTieringConfigurationOutput, error) {
	req, out := c.DeleteBucketIntelligentTieringConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBucketIntelligentTieringConfigurationWithContext is the same as DeleteBucketIntelligentTieringConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketIntelligentTieringConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketIntelligentTieringConfigurationWithContext(ctx aws.Context, input *DeleteBucketIntelligentTieringConfigurationInput, opts ...request.Option) (*DeleteBucketIntelligentTieringConfigurationOutput, error) {
	req, out := c.DeleteBucketIntelligentTieringConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketInventoryConfiguration = "DeleteBucketInventoryConfiguration"

// DeleteBucketInventoryConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketInventoryConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketInventoryConfiguration for more information on using the DeleteBucketInventoryConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketInventoryConfigurationRequest method.
//	req, resp := client.DeleteBucketInventoryConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfiguration
func (c *S3) DeleteBucketInventoryConfigurationRequest(input *DeleteBucketInventoryConfigurationInput) (req *request.Request, output *DeleteBucketInventoryConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketInventoryConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &DeleteBucketInventoryConfigurationInput{}
	}

	output = &DeleteBucketInventoryConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketInventoryConfiguration API operation for Amazon Simple Storage Service.
//
// Deletes an inventory configuration (identified by the inventory ID) from
// the bucket.
//
// To use this operation, you must have permissions to perform the s3:PutInventoryConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// For information about the Amazon S3 inventory feature, see Amazon S3 Inventory
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html).
//
// Operations related to DeleteBucketInventoryConfiguration include:
//
//   - GetBucketInventoryConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html)
//
//   - PutBucketInventoryConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html)
//
//   - ListBucketInventoryConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketInventoryConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfiguration
func (c *S3) DeleteBucketInventoryConfiguration(input *DeleteBucketInventoryConfigurationInput) (*DeleteBucketInventoryConfigurationOutput, error) {
	req, out := c.DeleteBucketInventoryConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBucketInventoryConfigurationWithContext is the same as DeleteBucketInventoryConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketInventoryConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketInventoryConfigurationWithContext(ctx aws.Context, input *DeleteBucketInventoryConfigurationInput, opts ...request.Option) (*DeleteBucketInventoryConfigurationOutput, error) {
	req, out := c.DeleteBucketInventoryConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketLifecycle = "DeleteBucketLifecycle"

// DeleteBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketLifecycle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketLifecycle for more information on using the DeleteBucketLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketLifecycleRequest method.
//	req, resp := client.DeleteBucketLifecycleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycle
func (c *S3) DeleteBucketLifecycleRequest(input *DeleteBucketLifecycleInput) (req *request.Request, output *DeleteBucketLifecycleOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketLifecycle,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &DeleteBucketLifecycleInput{}
	}

	output = &DeleteBucketLifecycleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketLifecycle API operation for Amazon Simple Storage Service.
//
// Deletes the lifecycle configuration from the specified bucket. Amazon S3
// removes all the lifecycle configuration rules in the lifecycle subresource
// associated with the bucket. Your objects never expire, and Amazon S3 no longer
// automatically deletes any objects on the basis of rules contained in the
// deleted lifecycle configuration.
//
// To use this operation, you must have permission to perform the s3:PutLifecycleConfiguration
// action. By default, the bucket owner has this permission and the bucket owner
// can grant this permission to others.
//
// There is usually some time lag before lifecycle configuration deletion is
// fully propagated to all the Amazon S3 systems.
//
// For more information about the object expiration, see Elements to Describe
// Lifecycle Actions (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions).
//
// Related actions include:
//
//   - PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)
//
//   - GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketLifecycle for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycle
func (c *S3) DeleteBucketLifecycle(input *DeleteBucketLifecycleInput) (*DeleteBucketLifecycleOutput, error) {
	req, out := c.DeleteBucketLifecycleRequest(input)
	return out, req.Send()
}

// DeleteBucketLifecycleWithContext is the same as DeleteBucketLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketLifecycleWithContext(ctx aws.Context, input *DeleteBucketLifecycleInput, opts ...request.Option) (*DeleteBucketLifecycleOutput, error) {
	req, out := c.DeleteBucketLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketMetricsConfiguration = "DeleteBucketMetricsConfiguration"

// DeleteBucketMetricsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketMetricsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketMetricsConfiguration for more information on using the DeleteBucketMetricsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketMetricsConfigurationRequest method.
//	req, resp := client.DeleteBucketMetricsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfiguration
func (c *S3) DeleteBucketMetricsConfigurationRequest(input *DeleteBucketMetricsConfigurationInput) (req *request.Request, output *DeleteBucketMetricsConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketMetricsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &DeleteBucketMetricsConfigurationInput{}
	}

	output = &DeleteBucketMetricsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketMetricsConfiguration API operation for Amazon Simple Storage Service.
//
// Deletes a metrics configuration for the Amazon CloudWatch request metrics
// (specified by the metrics configuration ID) from the bucket. Note that this
// doesn't include the daily storage metrics.
//
// To use this operation, you must have permissions to perform the s3:PutMetricsConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// For information about CloudWatch request metrics for Amazon S3, see Monitoring
// Metrics with Amazon CloudWatch (https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html).
//
// The following operations are related to DeleteBucketMetricsConfiguration:
//
//   - GetBucketMetricsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html)
//
//   - PutBucketMetricsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html)
//
//   - ListBucketMetricsConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html)
//
//   - Monitoring Metrics with Amazon CloudWatch (https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketMetricsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfiguration
func (c *S3) DeleteBucketMetricsConfiguration(input *DeleteBucketMetricsConfigurationInput) (*DeleteBucketMetricsConfigurationOutput, error) {
	req, out := c.DeleteBucketMetricsConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBucketMetricsConfigurationWithContext is the same as DeleteBucketMetricsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketMetricsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketMetricsConfigurationWithContext(ctx aws.Context, input *DeleteBucketMetricsConfigurationInput, opts ...request.Option) (*DeleteBucketMetricsConfigurationOutput, error) {
	req, out := c.DeleteBucketMetricsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketOwnershipControls = "DeleteBucketOwnershipControls"

// DeleteBucketOwnershipControlsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketOwnershipControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketOwnershipControls for more information on using the DeleteBucketOwnershipControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketOwnershipControlsRequest method.
//	req, resp := client.DeleteBucketOwnershipControlsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketOwnershipControls
func (c *S3) DeleteBucketOwnershipControlsRequest(input *DeleteBucketOwnershipControlsInput) (req *request.Request, output *DeleteBucketOwnershipControlsOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketOwnershipControls,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?ownershipControls",
	}

	if input == nil {
		input = &DeleteBucketOwnershipControlsInput{}
	}

	output = &DeleteBucketOwnershipControlsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketOwnershipControls API operation for Amazon Simple Storage Service.
//
// Removes OwnershipControls for an Amazon S3 bucket. To use this operation,
// you must have the s3:PutBucketOwnershipControls permission. For more information
// about Amazon S3 permissions, see Specifying Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
//
// For information about Amazon S3 Object Ownership, see Using Object Ownership
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html).
//
// The following operations are related to DeleteBucketOwnershipControls:
//
//   - GetBucketOwnershipControls
//
//   - PutBucketOwnershipControls
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketOwnershipControls for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketOwnershipControls
func (c *S3) DeleteBucketOwnershipControls(input *DeleteBucketOwnershipControlsInput) (*DeleteBucketOwnershipControlsOutput, error) {
	req, out := c.DeleteBucketOwnershipControlsRequest(input)
	return out, req.Send()
}

// DeleteBucketOwnershipControlsWithContext is the same as DeleteBucketOwnershipControls with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketOwnershipControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketOwnershipControlsWithContext(ctx aws.Context, input *DeleteBucketOwnershipControlsInput, opts ...request.Option) (*DeleteBucketOwnershipControlsOutput, error) {
	req, out := c.DeleteBucketOwnershipControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketPolicy = "DeleteBucketPolicy"

// DeleteBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketPolicy for more information on using the DeleteBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketPolicyRequest method.
//	req, resp := client.DeleteBucketPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicy
func (c *S3) DeleteBucketPolicyRequest(input *DeleteBucketPolicyInput) (req *request.Request, output *DeleteBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &DeleteBucketPolicyInput{}
	}

	output = &DeleteBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketPolicy API operation for Amazon Simple Storage Service.
//
// This implementation of the DELETE action uses the policy subresource to delete
// the policy of a specified bucket. If you are using an identity other than
// the root user of the Amazon Web Services account that owns the bucket, the
// calling identity must have the DeleteBucketPolicy permissions on the specified
// bucket and belong to the bucket owner's account to use this operation.
//
// If you don't have DeleteBucketPolicy permissions, Amazon S3 returns a 403
// Access Denied error. If you have the correct permissions, but you're not
// using an identity that belongs to the bucket owner's account, Amazon S3 returns
// a 405 Method Not Allowed error.
//
// As a security precaution, the root user of the Amazon Web Services account
// that owns a bucket can always use this operation, even if the policy explicitly
// denies the root user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// UserPolicies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// The following operations are related to DeleteBucketPolicy
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//   - DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicy
func (c *S3) DeleteBucketPolicy(input *DeleteBucketPolicyInput) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	return out, req.Send()
}

// DeleteBucketPolicyWithContext is the same as DeleteBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketPolicyWithContext(ctx aws.Context, input *DeleteBucketPolicyInput, opts ...request.Option) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketReplication = "DeleteBucketReplication"

// DeleteBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketReplication for more information on using the DeleteBucketReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketReplicationRequest method.
//	req, resp := client.DeleteBucketReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplication
func (c *S3) DeleteBucketReplicationRequest(input *DeleteBucketReplicationInput) (req *request.Request, output *DeleteBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketReplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &DeleteBucketReplicationInput{}
	}

	output = &DeleteBucketReplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketReplication API operation for Amazon Simple Storage Service.
//
// Deletes the replication configuration from the bucket.
//
// To use this operation, you must have permissions to perform the s3:PutReplicationConfiguration
// action. The bucket owner has these permissions by default and can grant it
// to others. For more information about permissions, see Permissions Related
// to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// It can take a while for the deletion of a replication configuration to fully
// propagate.
//
// For information about replication configuration, see Replication (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html)
// in the Amazon S3 User Guide.
//
// The following operations are related to DeleteBucketReplication:
//
//   - PutBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html)
//
//   - GetBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketReplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplication
func (c *S3) DeleteBucketReplication(input *DeleteBucketReplicationInput) (*DeleteBucketReplicationOutput, error) {
	req, out := c.DeleteBucketReplicationRequest(input)
	return out, req.Send()
}

// DeleteBucketReplicationWithContext is the same as DeleteBucketReplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketReplicationWithContext(ctx aws.Context, input *DeleteBucketReplicationInput, opts ...request.Option) (*DeleteBucketReplicationOutput, error) {
	req, out := c.DeleteBucketReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketTagging = "DeleteBucketTagging"

// DeleteBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketTagging for more information on using the DeleteBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketTaggingRequest method.
//	req, resp := client.DeleteBucketTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTagging
func (c *S3) DeleteBucketTaggingRequest(input *DeleteBucketTaggingInput) (req *request.Request, output *DeleteBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &DeleteBucketTaggingInput{}
	}

	output = &DeleteBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketTagging API operation for Amazon Simple Storage Service.
//
// Deletes the tags from the bucket.
//
// To use this operation, you must have permission to perform the s3:PutBucketTagging
// action. By default, the bucket owner has this permission and can grant this
// permission to others.
//
// The following operations are related to DeleteBucketTagging:
//
//   - GetBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html)
//
//   - PutBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTagging
func (c *S3) DeleteBucketTagging(input *DeleteBucketTaggingInput) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	return out, req.Send()
}

// DeleteBucketTaggingWithContext is the same as DeleteBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketTaggingWithContext(ctx aws.Context, input *DeleteBucketTaggingInput, opts ...request.Option) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketWebsite = "DeleteBucketWebsite"

// DeleteBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketWebsite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketWebsite for more information on using the DeleteBucketWebsite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketWebsiteRequest method.
//	req, resp := client.DeleteBucketWebsiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsite
func (c *S3) DeleteBucketWebsiteRequest(input *DeleteBucketWebsiteInput) (req *request.Request, output *DeleteBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketWebsite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &DeleteBucketWebsiteInput{}
	}

	output = &DeleteBucketWebsiteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketWebsite API operation for Amazon Simple Storage Service.
//
// This action removes the website configuration for a bucket. Amazon S3 returns
// a 200 OK response upon successfully deleting a website configuration on the
// specified bucket. You will get a 200 OK response if the website configuration
// you are trying to delete does not exist on the bucket. Amazon S3 returns
// a 404 response if the bucket specified in the request does not exist.
//
// This DELETE action requires the S3:DeleteBucketWebsite permission. By default,
// only the bucket owner can delete the website configuration attached to a
// bucket. However, bucket owners can grant other users permission to delete
// the website configuration by writing a bucket policy granting them the S3:DeleteBucketWebsite
// permission.
//
// For more information about hosting websites, see Hosting Websites on Amazon
// S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
//
// The following operations are related to DeleteBucketWebsite:
//
//   - GetBucketWebsite (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketWebsite.html)
//
//   - PutBucketWebsite (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketWebsite for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsite
func (c *S3) DeleteBucketWebsite(input *DeleteBucketWebsiteInput) (*DeleteBucketWebsiteOutput, error) {
	req, out := c.DeleteBucketWebsiteRequest(input)
	return out, req.Send()
}

// DeleteBucketWebsiteWithContext is the same as DeleteBucketWebsite with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketWebsite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketWebsiteWithContext(ctx aws.Context, input *DeleteBucketWebsiteInput, opts ...request.Option) (*DeleteBucketWebsiteOutput, error) {
	req, out := c.DeleteBucketWebsiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObject = "DeleteObject"

// DeleteObjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObject for more information on using the DeleteObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteObjectRequest method.
//	req, resp := client.DeleteObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObject
func (c *S3) DeleteObjectRequest(input *DeleteObjectInput) (req *request.Request, output *DeleteObjectOutput) {
	op := &request.Operation{
		Name:       opDeleteObject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &DeleteObjectInput{}
	}

	output = &DeleteObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteObject API operation for Amazon Simple Storage Service.
//
// Removes the null version (if there is one) of an object and inserts a delete
// marker, which becomes the latest version of the object. If there isn't a
// null version, Amazon S3 does not remove any objects but will still respond
// that the command was successful.
//
// To remove a specific version, you must be the bucket owner and you must use
// the version Id subresource. Using this subresource permanently deletes the
// version. If the object deleted is a delete marker, Amazon S3 sets the response
// header, x-amz-delete-marker, to true.
//
// If the object you want to delete is in a bucket where the bucket versioning
// configuration is MFA Delete enabled, you must include the x-amz-mfa request
// header in the DELETE versionId request. Requests that include x-amz-mfa must
// use HTTPS.
//
// For more information about MFA Delete, see Using MFA Delete (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMFADelete.html).
// To see sample requests that use versioning, see Sample Request (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectDELETE.html#ExampleVersionObjectDelete).
//
// You can delete objects by explicitly calling DELETE Object or configure its
// lifecycle (PutBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html))
// to enable Amazon S3 to remove them for you. If you want to block users or
// accounts from removing or deleting objects from your bucket, you must deny
// them the s3:DeleteObject, s3:DeleteObjectVersion, and s3:PutLifeCycleConfiguration
// actions.
//
// The following action is related to DeleteObject:
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObject
func (c *S3) DeleteObject(input *DeleteObjectInput) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	return out, req.Send()
}

// DeleteObjectWithContext is the same as DeleteObject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteObjectWithContext(ctx aws.Context, input *DeleteObjectInput, opts ...request.Option) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObjectTagging = "DeleteObjectTagging"

// DeleteObjectTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObjectTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObjectTagging for more information on using the DeleteObjectTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteObjectTaggingRequest method.
//	req, resp := client.DeleteObjectTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTagging
func (c *S3) DeleteObjectTaggingRequest(input *DeleteObjectTaggingInput) (req *request.Request, output *DeleteObjectTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteObjectTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &DeleteObjectTaggingInput{}
	}

	output = &DeleteObjectTaggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteObjectTagging API operation for Amazon Simple Storage Service.
//
// Removes the entire tag set from the specified object. For more information
// about managing object tags, see Object Tagging (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html).
//
// To use this operation, you must have permission to perform the s3:DeleteObjectTagging
// action.
//
// To delete tags of a specific object version, add the versionId query parameter
// in the request. You will need permission for the s3:DeleteObjectVersionTagging
// action.
//
// The following operations are related to DeleteBucketMetricsConfiguration:
//
//   - PutObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html)
//
//   - GetObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObjectTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTagging
func (c *S3) DeleteObjectTagging(input *DeleteObjectTaggingInput) (*DeleteObjectTaggingOutput, error) {
	req, out := c.DeleteObjectTaggingRequest(input)
	return out, req.Send()
}

// DeleteObjectTaggingWithContext is the same as DeleteObjectTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObjectTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteObjectTaggingWithContext(ctx aws.Context, input *DeleteObjectTaggingInput, opts ...request.Option) (*DeleteObjectTaggingOutput, error) {
	req, out := c.DeleteObjectTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObjects = "DeleteObjects"

// DeleteObjectsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObjects for more information on using the DeleteObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteObjectsRequest method.
//	req, resp := client.DeleteObjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjects
func (c *S3) DeleteObjectsRequest(input *DeleteObjectsInput) (req *request.Request, output *DeleteObjectsOutput) {
	op := &request.Operation{
		Name:       opDeleteObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}?delete",
	}

	if input == nil {
		input = &DeleteObjectsInput{}
	}

	output = &DeleteObjectsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// DeleteObjects API operation for Amazon Simple Storage Service.
//
// This action enables you to delete multiple objects from a bucket using a
// single HTTP request. If you know the object keys that you want to delete,
// then this action provides a suitable alternative to sending individual delete
// requests, reducing per-request overhead.
//
// The request contains a list of up to 1000 keys that you want to delete. In
// the XML, you provide the object key names, and optionally, version IDs if
// you want to delete a specific version of the object from a versioning-enabled
// bucket. For each key, Amazon S3 performs a delete action and returns the
// result of that delete, success, or failure, in the response. Note that if
// the object specified in the request is not found, Amazon S3 returns the result
// as deleted.
//
// The action supports two modes for the response: verbose and quiet. By default,
// the action uses verbose mode in which the response includes the result of
// deletion of each key in your request. In quiet mode the response includes
// only keys where the delete action encountered an error. For a successful
// deletion, the action does not return any information about the delete in
// the response body.
//
// When performing this action on an MFA Delete enabled bucket, that attempts
// to delete any versioned objects, you must include an MFA token. If you do
// not provide one, the entire request will fail, even if there are non-versioned
// objects you are trying to delete. If you provide an invalid token, whether
// there are versioned keys in the request or not, the entire Multi-Object Delete
// request will fail. For information about MFA Delete, see MFA Delete (https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html#MultiFactorAuthenticationDelete).
//
// Finally, the Content-MD5 header is required for all Multi-Object Delete requests.
// Amazon S3 uses the header value to ensure that your request body has not
// been altered in transit.
//
// The following operations are related to DeleteObjects:
//
//   - CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//   - UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//   - CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//   - ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//   - AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObjects for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjects
func (c *S3) DeleteObjects(input *DeleteObjectsInput) (*DeleteObjectsOutput, error) {
	req, out := c.DeleteObjectsRequest(input)
	return out, req.Send()
}

// DeleteObjectsWithContext is the same as DeleteObjects with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteObjectsWithContext(ctx aws.Context, input *DeleteObjectsInput, opts ...request.Option) (*DeleteObjectsOutput, error) {
	req, out := c.DeleteObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublicAccessBlock = "DeletePublicAccessBlock"

// DeletePublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublicAccessBlock for more information on using the DeletePublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePublicAccessBlockRequest method.
//	req, resp := client.DeletePublicAccessBlockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletePublicAccessBlock
func (c *S3) DeletePublicAccessBlockRequest(input *DeletePublicAccessBlockInput) (req *request.Request, output *DeletePublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opDeletePublicAccessBlock,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?publicAccessBlock",
	}

	if input == nil {
		input = &DeletePublicAccessBlockInput{}
	}

	output = &DeletePublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePublicAccessBlock API operation for Amazon Simple Storage Service.
//
// Removes the PublicAccessBlock configuration for an Amazon S3 bucket. To use
// this operation, you must have the s3:PutBucketPublicAccessBlock permission.
// For more information about permissions, see Permissions Related to Bucket
// Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// The following operations are related to DeletePublicAccessBlock:
//
//   - Using Amazon S3 Block Public Access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
//
//   - GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html)
//
//   - PutPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html)
//
//   - GetBucketPolicyStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeletePublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletePublicAccessBlock
func (c *S3) DeletePublicAccessBlock(input *DeletePublicAccessBlockInput) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	return out, req.Send()
}

// DeletePublicAccessBlockWithContext is the same as DeletePublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeletePublicAccessBlockWithContext(ctx aws.Context, input *DeletePublicAccessBlockInput, opts ...request.Option) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketAccelerateConfiguration = "GetBucketAccelerateConfiguration"

// GetBucketAccelerateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAccelerateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketAccelerateConfiguration for more information on using the GetBucketAccelerateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketAccelerateConfigurationRequest method.
//	req, resp := client.GetBucketAccelerateConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfiguration
func (c *S3) GetBucketAccelerateConfigurationRequest(input *GetBucketAccelerateConfigurationInput) (req *request.Request, output *GetBucketAccelerateConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketAccelerateConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?accelerate",
	}

	if input == nil {
		input = &GetBucketAccelerateConfigurationInput{}
	}

	output = &GetBucketAccelerateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketAccelerateConfiguration API operation for Amazon Simple Storage Service.
//
// This implementation of the GET action uses the accelerate subresource to
// return the Transfer Acceleration state of a bucket, which is either Enabled
// or Suspended. Amazon S3 Transfer Acceleration is a bucket-level feature that
// enables you to perform faster data transfers to and from Amazon S3.
//
// To use this operation, you must have permission to perform the s3:GetAccelerateConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html)
// in the Amazon S3 User Guide.
//
// You set the Transfer Acceleration state of an existing bucket to Enabled
// or Suspended by using the PutBucketAccelerateConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html)
// operation.
//
// A GET accelerate request does not return a state value for a bucket that
// has no transfer acceleration state. A bucket has no Transfer Acceleration
// state if a state has never been set on the bucket.
//
// For more information about transfer acceleration, see Transfer Acceleration
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html)
// in the Amazon S3 User Guide.
//
// Related Resources
//
//   - PutBucketAccelerateConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketAccelerateConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfiguration
func (c *S3) GetBucketAccelerateConfiguration(input *GetBucketAccelerateConfigurationInput) (*GetBucketAccelerateConfigurationOutput, error) {
	req, out := c.GetBucketAccelerateConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketAccelerateConfigurationWithContext is the same as GetBucketAccelerateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketAccelerateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketAccelerateConfigurationWithContext(ctx aws.Context, input *GetBucketAccelerateConfigurationInput, opts ...request.Option) (*GetBucketAccelerateConfigurationOutput, error) {
	req, out := c.GetBucketAccelerateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketAcl = "GetBucketAcl"

// GetBucketAclRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketAcl for more information on using the GetBucketAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketAclRequest method.
//	req, resp := client.GetBucketAclRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAcl
func (c *S3) GetBucketAclRequest(input *GetBucketAclInput) (req *request.Request, output *GetBucketAclOutput) {
	op := &request.Operation{
		Name:       opGetBucketAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &GetBucketAclInput{}
	}

	output = &GetBucketAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketAcl API operation for Amazon Simple Storage Service.
//
// This implementation of the GET action uses the acl subresource to return
// the access control list (ACL) of a bucket. To use GET to return the ACL of
// the bucket, you must have READ_ACP access to the bucket. If READ_ACP permission
// is granted to the anonymous user, you can return the ACL of the bucket without
// using an authorization header.
//
// If your bucket uses the bucket owner enforced setting for S3 Object Ownership,
// requests to read ACLs are still supported and return the bucket-owner-full-control
// ACL with the owner being the account that created the bucket. For more information,
// see Controlling object ownership and disabling ACLs (https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html)
// in the Amazon S3 User Guide.
//
// Related Resources
//
//   - ListObjects (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAcl
func (c *S3) GetBucketAcl(input *GetBucketAclInput) (*GetBucketAclOutput, error) {
	req, out := c.GetBucketAclRequest(input)
	return out, req.Send()
}

// GetBucketAclWithContext is the same as GetBucketAcl with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketAclWithContext(ctx aws.Context, input *GetBucketAclInput, opts ...request.Option) (*GetBucketAclOutput, error) {
	req, out := c.GetBucketAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketAnalyticsConfiguration = "GetBucketAnalyticsConfiguration"

// GetBucketAnalyticsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAnalyticsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketAnalyticsConfiguration for more information on using the GetBucketAnalyticsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketAnalyticsConfigurationRequest method.
//	req, resp := client.GetBucketAnalyticsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfiguration
func (c *S3) GetBucketAnalyticsConfigurationRequest(input *GetBucketAnalyticsConfigurationInput) (req *request.Request, output *GetBucketAnalyticsConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketAnalyticsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &GetBucketAnalyticsConfigurationInput{}
	}

	output = &GetBucketAnalyticsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketAnalyticsConfiguration API operation for Amazon Simple Storage Service.
//
// This implementation of the GET action returns an analytics configuration
// (identified by the analytics configuration ID) from the bucket.
//
// To use this operation, you must have permissions to perform the s3:GetAnalyticsConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html)
// in the Amazon S3 User Guide.
//
// For information about Amazon S3 analytics feature, see Amazon S3 Analytics
// – Storage Class Analysis (https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html)
// in the Amazon S3 User Guide.
//
// Related Resources
//
//   - DeleteBucketAnalyticsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html)
//
//   - ListBucketAnalyticsConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html)
//
//   - PutBucketAnalyticsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketAnalyticsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfiguration
func (c *S3) GetBucketAnalyticsConfiguration(input *GetBucketAnalyticsConfigurationInput) (*GetBucketAnalyticsConfigurationOutput, error) {
	req, out := c.GetBucketAnalyticsConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketAnalyticsConfigurationWithContext is the same as GetBucketAnalyticsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketAnalyticsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketAnalyticsConfigurationWithContext(ctx aws.Context, input *GetBucketAnalyticsConfigurationInput, opts ...request.Option) (*GetBucketAnalyticsConfigurationOutput, error) {
	req, out := c.GetBucketAnalyticsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketCors = "GetBucketCors"

// GetBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketCors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketCors for more information on using the GetBucketCors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketCorsRequest method.
//	req, resp := client.GetBucketCorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCors
func (c *S3) GetBucketCorsRequest(input *GetBucketCorsInput) (req *request.Request, output *GetBucketCorsOutput) {
	op := &request.Operation{
		Name:       opGetBucketCors,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &GetBucketCorsInput{}
	}

	output = &GetBucketCorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketCors API operation for Amazon Simple Storage Service.
//
// Returns the Cross-Origin Resource Sharing (CORS) configuration information
// set for the bucket.
//
// To use this operation, you must have permission to perform the s3:GetBucketCORS
// action. By default, the bucket owner has this permission and can grant it
// to others.
//
// For more information about CORS, see Enabling Cross-Origin Resource Sharing
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html).
//
// The following operations are related to GetBucketCors:
//
//   - PutBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html)
//
//   - DeleteBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketCors for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCors
func (c *S3) GetBucketCors(input *GetBucketCorsInput) (*GetBucketCorsOutput, error) {
	req, out := c.GetBucketCorsRequest(input)
	return out, req.Send()
}

// GetBucketCorsWithContext is the same as GetBucketCors with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketCors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketCorsWithContext(ctx aws.Context, input *GetBucketCorsInput, opts ...request.Option) (*GetBucketCorsOutput, error) {
	req, out := c.GetBucketCorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketEncryption = "GetBucketEncryption"

// GetBucketEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketEncryption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketEncryption for more information on using the GetBucketEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketEncryptionRequest method.
//	req, resp := client.GetBucketEncryptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryption
func (c *S3) GetBucketEncryptionRequest(input *GetBucketEncryptionInput) (req *request.Request, output *GetBucketEncryptionOutput) {
	op := &request.Operation{
		Name:       opGetBucketEncryption,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?encryption",
	}

	if input == nil {
		input = &GetBucketEncryptionInput{}
	}

	output = &GetBucketEncryptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketEncryption API operation for Amazon Simple Storage Service.
//
// Returns the default encryption configuration for an Amazon S3 bucket. If
// the bucket does not have a default encryption configuration, GetBucketEncryption
// returns ServerSideEncryptionConfigurationNotFoundError.
//
// For information about the Amazon S3 default encryption feature, see Amazon
// S3 Default Bucket Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html).
//
// To use this operation, you must have permission to perform the s3:GetEncryptionConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// The following operations are related to GetBucketEncryption:
//
//   - PutBucketEncryption (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html)
//
//   - DeleteBucketEncryption (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketEncryption for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryption
func (c *S3) GetBucketEncryption(input *GetBucketEncryptionInput) (*GetBucketEncryptionOutput, error) {
	req, out := c.GetBucketEncryptionRequest(input)
	return out, req.Send()
}

// GetBucketEncryptionWithContext is the same as GetBucketEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketEncryptionWithContext(ctx aws.Context, input *GetBucketEncryptionInput, opts ...request.Option) (*GetBucketEncryptionOutput, error) {
	req, out := c.GetBucketEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketIntelligentTieringConfiguration = "GetBucketIntelligentTieringConfiguration"

// GetBucketIntelligentTieringConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketIntelligentTieringConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketIntelligentTieringConfiguration for more information on using the GetBucketIntelligentTieringConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketIntelligentTieringConfigurationRequest method.
//	req, resp := client.GetBucketIntelligentTieringConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketIntelligentTieringConfiguration
func (c *S3) GetBucketIntelligentTieringConfigurationRequest(input *GetBucketIntelligentTieringConfigurationInput) (req *request.Request, output *GetBucketIntelligentTieringConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketIntelligentTieringConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?intelligent-tiering",
	}

	if input == nil {
		input = &GetBucketIntelligentTieringConfigurationInput{}
	}

	output = &GetBucketIntelligentTieringConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketIntelligentTieringConfiguration API operation for Amazon Simple Storage Service.
//
// Gets the S3 Intelligent-Tiering configuration from the specified bucket.
//
// The S3 Intelligent-Tiering storage class is designed to optimize storage
// costs by automatically moving data to the most cost-effective storage access
// tier, without performance impact or operational overhead. S3 Intelligent-Tiering
// delivers automatic cost savings in three low latency and high throughput
// access tiers. To get the lowest storage cost on data that can be accessed
// in minutes to hours, you can choose to activate additional archiving capabilities.
//
// The S3 Intelligent-Tiering storage class is the ideal storage class for data
// with unknown, changing, or unpredictable access patterns, independent of
// object size or retention period. If the size of an object is less than 128
// KB, it is not monitored and not eligible for auto-tiering. Smaller objects
// can be stored, but they are always charged at the Frequent Access tier rates
// in the S3 Intelligent-Tiering storage class.
//
// For more information, see Storage class for automatically optimizing frequently
// and infrequently accessed objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access).
//
// Operations related to GetBucketIntelligentTieringConfiguration include:
//
//   - DeleteBucketIntelligentTieringConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html)
//
//   - PutBucketIntelligentTieringConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html)
//
//   - ListBucketIntelligentTieringConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketIntelligentTieringConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketIntelligentTieringConfiguration
func (c *S3) GetBucketIntelligentTieringConfiguration(input *GetBucketIntelligentTieringConfigurationInput) (*GetBucketIntelligentTieringConfigurationOutput, error) {
	req, out := c.GetBucketIntelligentTieringConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketIntelligentTieringConfigurationWithContext is the same as GetBucketIntelligentTieringConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketIntelligentTieringConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketIntelligentTieringConfigurationWithContext(ctx aws.Context, input *GetBucketIntelligentTieringConfigurationInput, opts ...request.Option) (*GetBucketIntelligentTieringConfigurationOutput, error) {
	req, out := c.GetBucketIntelligentTieringConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketInventoryConfiguration = "GetBucketInventoryConfiguration"

// GetBucketInventoryConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketInventoryConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketInventoryConfiguration for more information on using the GetBucketInventoryConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketInventoryConfigurationRequest method.
//	req, resp := client.GetBucketInventoryConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfiguration
func (c *S3) GetBucketInventoryConfigurationRequest(input *GetBucketInventoryConfigurationInput) (req *request.Request, output *GetBucketInventoryConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketInventoryConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &GetBucketInventoryConfigurationInput{}
	}

	output = &GetBucketInventoryConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketInventoryConfiguration API operation for Amazon Simple Storage Service.
//
// Returns an inventory configuration (identified by the inventory configuration
// ID) from the bucket.
//
// To use this operation, you must have permissions to perform the s3:GetInventoryConfiguration
// action. The bucket owner has this permission by default and can grant this
// permission to others. For more information about permissions, see Permissions
// Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// For information about the Amazon S3 inventory feature, see Amazon S3 Inventory
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html).
//
// The following operations are related to GetBucketInventoryConfiguration:
//
//   - DeleteBucketInventoryConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html)
//
//   - ListBucketInventoryConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html)
//
//   - PutBucketInventoryConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketInventoryConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfiguration
func (c *S3) GetBucketInventoryConfiguration(input *GetBucketInventoryConfigurationInput) (*GetBucketInventoryConfigurationOutput, error) {
	req, out := c.GetBucketInventoryConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketInventoryConfigurationWithContext is the same as GetBucketInventoryConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketInventoryConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketInventoryConfigurationWithContext(ctx aws.Context, input *GetBucketInventoryConfigurationInput, opts ...request.Option) (*GetBucketInventoryConfigurationOutput, error) {
	req, out := c.GetBucketInventoryConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLifecycle = "GetBucketLifecycle"

// GetBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLifecycle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLifecycle for more information on using the GetBucketLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketLifecycleRequest method.
//	req, resp := client.GetBucketLifecycleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycle
//
// Deprecated: GetBucketLifecycle has been deprecated
func (c *S3) GetBucketLifecycleRequest(input *GetBucketLifecycleInput) (req *request.Request, output *GetBucketLifecycleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetBucketLifecycle, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetBucketLifecycle,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleInput{}
	}

	output = &GetBucketLifecycleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLifecycle API operation for Amazon Simple Storage Service.
//
// For an updated version of this API, see GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html).
// If you configured a bucket lifecycle using the filter element, you should
// see the updated version of this topic. This topic is provided for backward
// compatibility.
//
// Returns the lifecycle configuration information set on the bucket. For information
// about lifecycle configuration, see Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html).
//
// To use this operation, you must have permission to perform the s3:GetLifecycleConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// GetBucketLifecycle has the following special error:
//
//   - Error code: NoSuchLifecycleConfiguration Description: The lifecycle
//     configuration does not exist. HTTP Status Code: 404 Not Found SOAP Fault
//     Code Prefix: Client
//
// The following operations are related to GetBucketLifecycle:
//
//   - GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html)
//
//   - PutBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html)
//
//   - DeleteBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLifecycle for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycle
//
// Deprecated: GetBucketLifecycle has been deprecated
func (c *S3) GetBucketLifecycle(input *GetBucketLifecycleInput) (*GetBucketLifecycleOutput, error) {
	req, out := c.GetBucketLifecycleRequest(input)
	return out, req.Send()
}

// GetBucketLifecycleWithContext is the same as GetBucketLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: GetBucketLifecycleWithContext has been deprecated
func (c *S3) GetBucketLifecycleWithContext(ctx aws.Context, input *GetBucketLifecycleInput, opts ...request.Option) (*GetBucketLifecycleOutput, error) {
	req, out := c.GetBucketLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLifecycleConfiguration = "GetBucketLifecycleConfiguration"

// GetBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLifecycleConfiguration for more information on using the GetBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketLifecycleConfigurationRequest method.
//	req, resp := client.GetBucketLifecycleConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfiguration
func (c *S3) GetBucketLifecycleConfigurationRequest(input *GetBucketLifecycleConfigurationInput) (req *request.Request, output *GetBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleConfigurationInput{}
	}

	output = &GetBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLifecycleConfiguration API operation for Amazon Simple Storage Service.
//
// Bucket lifecycle configuration now supports specifying a lifecycle rule using
// an object key name prefix, one or more object tags, or a combination of both.
// Accordingly, this section describes the latest API. The response describes
// the new filter element that you can use to specify a filter to select a subset
// of objects to which the rule applies. If you are using a previous version
// of the lifecycle configuration, it still works. For the earlier action, see
// GetBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html).
//
// Returns the lifecycle configuration information set on the bucket. For information
// about lifecycle configuration, see Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html).
//
// To use this operation, you must have permission to perform the s3:GetLifecycleConfiguration
// action. The bucket owner has this permission, by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// GetBucketLifecycleConfiguration has the following special error:
//
//   - Error code: NoSuchLifecycleConfiguration Description: The lifecycle
//     configuration does not exist. HTTP Status Code: 404 Not Found SOAP Fault
//     Code Prefix: Client
//
// The following operations are related to GetBucketLifecycleConfiguration:
//
//   - GetBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html)
//
//   - PutBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html)
//
//   - DeleteBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfiguration
func (c *S3) GetBucketLifecycleConfiguration(input *GetBucketLifecycleConfigurationInput) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketLifecycleConfigurationWithContext is the same as GetBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLifecycleConfigurationWithContext(ctx aws.Context, input *GetBucketLifecycleConfigurationInput, opts ...request.Option) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLocation = "GetBucketLocation"

// GetBucketLocationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLocation for more information on using the GetBucketLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketLocationRequest method.
//	req, resp := client.GetBucketLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocation
func (c *S3) GetBucketLocationRequest(input *GetBucketLocationInput) (req *request.Request, output *GetBucketLocationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?location",
	}

	if input == nil {
		input = &GetBucketLocationInput{}
	}

	output = &GetBucketLocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLocation API operation for Amazon Simple Storage Service.
//
// Returns the Region the bucket resides in. You set the bucket's Region using
// the LocationConstraint request parameter in a CreateBucket request. For more
// information, see CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html).
//
// To use this implementation of the operation, you must be the bucket owner.
//
// To use this API against an access point, provide the alias of the access
// point in place of the bucket name.
//
// The following operations are related to GetBucketLocation:
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocation
func (c *S3) GetBucketLocation(input *GetBucketLocationInput) (*GetBucketLocationOutput, error) {
	req, out := c.GetBucketLocationRequest(input)
	return out, req.Send()
}

// GetBucketLocationWithContext is the same as GetBucketLocation with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLocationWithContext(ctx aws.Context, input *GetBucketLocationInput, opts ...request.Option) (*GetBucketLocationOutput, error) {
	req, out := c.GetBucketLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLogging = "GetBucketLogging"

// GetBucketLoggingRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLogging for more information on using the GetBucketLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketLoggingRequest method.
//	req, resp := client.GetBucketLoggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLogging
func (c *S3) GetBucketLoggingRequest(input *GetBucketLoggingInput) (req *request.Request, output *GetBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketLogging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &GetBucketLoggingInput{}
	}

	output = &GetBucketLoggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLogging API operation for Amazon Simple Storage Service.
//
// Returns the logging status of a bucket and the permissions users have to
// view and modify that status. To use GET, you must be the bucket owner.
//
// The following operations are related to GetBucketLogging:
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//   - PutBucketLogging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLogging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLogging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLogging
func (c *S3) GetBucketLogging(input *GetBucketLoggingInput) (*GetBucketLoggingOutput, error) {
	req, out := c.GetBucketLoggingRequest(input)
	return out, req.Send()
}

// GetBucketLoggingWithContext is the same as GetBucketLogging with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLoggingWithContext(ctx aws.Context, input *GetBucketLoggingInput, opts ...request.Option) (*GetBucketLoggingOutput, error) {
	req, out := c.GetBucketLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketMetricsConfiguration = "GetBucketMetricsConfiguration"

// GetBucketMetricsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketMetricsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketMetricsConfiguration for more information on using the GetBucketMetricsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketMetricsConfigurationRequest method.
//	req, resp := client.GetBucketMetricsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfiguration
func (c *S3) GetBucketMetricsConfigurationRequest(input *GetBucketMetricsConfigurationInput) (req *request.Request, output *GetBucketMetricsConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketMetricsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &GetBucketMetricsConfigurationInput{}
	}

	output = &GetBucketMetricsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketMetricsConfiguration API operation for Amazon Simple Storage Service.
//
// Gets a metrics configuration (specified by the metrics configuration ID)
// from the bucket. Note that this doesn't include the daily storage metrics.
//
// To use this operation, you must have permissions to perform the s3:GetMetricsConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// For information about CloudWatch request metrics for Amazon S3, see Monitoring
// Metrics with Amazon CloudWatch (https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html).
//
// The following operations are related to GetBucketMetricsConfiguration:
//
//   - PutBucketMetricsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html)
//
//   - DeleteBucketMetricsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html)
//
//   - ListBucketMetricsConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html)
//
//   - Monitoring Metrics with Amazon CloudWatch (https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketMetricsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfiguration
func (c *S3) GetBucketMetricsConfiguration(input *GetBucketMetricsConfigurationInput) (*GetBucketMetricsConfigurationOutput, error) {
	req, out := c.GetBucketMetricsConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketMetricsConfigurationWithContext is the same as GetBucketMetricsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketMetricsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketMetricsConfigurationWithContext(ctx aws.Context, input *GetBucketMetricsConfigurationInput, opts ...request.Option) (*GetBucketMetricsConfigurationOutput, error) {
	req, out := c.GetBucketMetricsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketNotification = "GetBucketNotification"

// GetBucketNotificationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketNotification for more information on using the GetBucketNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketNotificationRequest method.
//	req, resp := client.GetBucketNotificationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotification
//
// Deprecated: GetBucketNotification has been deprecated
func (c *S3) GetBucketNotificationRequest(input *GetBucketNotificationConfigurationRequest) (req *request.Request, output *NotificationConfigurationDeprecated) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetBucketNotification, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetBucketNotification,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationRequest{}
	}

	output = &NotificationConfigurationDeprecated{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketNotification API operation for Amazon Simple Storage Service.
//
// No longer used, see GetBucketNotificationConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketNotification for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotification
//
// Deprecated: GetBucketNotification has been deprecated
func (c *S3) GetBucketNotification(input *GetBucketNotificationConfigurationRequest) (*NotificationConfigurationDeprecated, error) {
	req, out := c.GetBucketNotificationRequest(input)
	return out, req.Send()
}

// GetBucketNotificationWithContext is the same as GetBucketNotification with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: GetBucketNotificationWithContext has been deprecated
func (c *S3) GetBucketNotificationWithContext(ctx aws.Context, input *GetBucketNotificationConfigurationRequest, opts ...request.Option) (*NotificationConfigurationDeprecated, error) {
	req, out := c.GetBucketNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketNotificationConfiguration = "GetBucketNotificationConfiguration"

// GetBucketNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketNotificationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketNotificationConfiguration for more information on using the GetBucketNotificationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketNotificationConfigurationRequest method.
//	req, resp := client.GetBucketNotificationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotificationConfiguration
func (c *S3) GetBucketNotificationConfigurationRequest(input *GetBucketNotificationConfigurationRequest) (req *request.Request, output *NotificationConfiguration) {
	op := &request.Operation{
		Name:       opGetBucketNotificationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationRequest{}
	}

	output = &NotificationConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketNotificationConfiguration API operation for Amazon Simple Storage Service.
//
// Returns the notification configuration of a bucket.
//
// If notifications are not enabled on the bucket, the action returns an empty
// NotificationConfiguration element.
//
// By default, you must be the bucket owner to read the notification configuration
// of a bucket. However, the bucket owner can use a bucket policy to grant permission
// to other users to read this configuration with the s3:GetBucketNotification
// permission.
//
// For more information about setting and reading the notification configuration
// on a bucket, see Setting Up Notification of Bucket Events (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html).
// For more information about bucket policies, see Using Bucket Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// The following action is related to GetBucketNotification:
//
//   - PutBucketNotification (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketNotification.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketNotificationConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotificationConfiguration
func (c *S3) GetBucketNotificationConfiguration(input *GetBucketNotificationConfigurationRequest) (*NotificationConfiguration, error) {
	req, out := c.GetBucketNotificationConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketNotificationConfigurationWithContext is the same as GetBucketNotificationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketNotificationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketNotificationConfigurationWithContext(ctx aws.Context, input *GetBucketNotificationConfigurationRequest, opts ...request.Option) (*NotificationConfiguration, error) {
	req, out := c.GetBucketNotificationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketOwnershipControls = "GetBucketOwnershipControls"

// GetBucketOwnershipControlsRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketOwnershipControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketOwnershipControls for more information on using the GetBucketOwnershipControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketOwnershipControlsRequest method.
//	req, resp := client.GetBucketOwnershipControlsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketOwnershipControls
func (c *S3) GetBucketOwnershipControlsRequest(input *GetBucketOwnershipControlsInput) (req *request.Request, output *GetBucketOwnershipControlsOutput) {
	op := &request.Operation{
		Name:       opGetBucketOwnershipControls,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?ownershipControls",
	}

	if input == nil {
		input = &GetBucketOwnershipControlsInput{}
	}

	output = &GetBucketOwnershipControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketOwnershipControls API operation for Amazon Simple Storage Service.
//
// Retrieves OwnershipControls for an Amazon S3 bucket. To use this operation,
// you must have the s3:GetBucketOwnershipControls permission. For more information
// about Amazon S3 permissions, see Specifying permissions in a policy (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html).
//
// For information about Amazon S3 Object Ownership, see Using Object Ownership
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html).
//
// The following operations are related to GetBucketOwnershipControls:
//
//   - PutBucketOwnershipControls
//
//   - DeleteBucketOwnershipControls
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketOwnershipControls for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketOwnershipControls
func (c *S3) GetBucketOwnershipControls(input *GetBucketOwnershipControlsInput) (*GetBucketOwnershipControlsOutput, error) {
	req, out := c.GetBucketOwnershipControlsRequest(input)
	return out, req.Send()
}

// GetBucketOwnershipControlsWithContext is the same as GetBucketOwnershipControls with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketOwnershipControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketOwnershipControlsWithContext(ctx aws.Context, input *GetBucketOwnershipControlsInput, opts ...request.Option) (*GetBucketOwnershipControlsOutput, error) {
	req, out := c.GetBucketOwnershipControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketPolicy = "GetBucketPolicy"

// GetBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketPolicy for more information on using the GetBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketPolicyRequest method.
//	req, resp := client.GetBucketPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicy
func (c *S3) GetBucketPolicyRequest(input *GetBucketPolicyInput) (req *request.Request, output *GetBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opGetBucketPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &GetBucketPolicyInput{}
	}

	output = &GetBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketPolicy API operation for Amazon Simple Storage Service.
//
// Returns the policy of a specified bucket. If you are using an identity other
// than the root user of the Amazon Web Services account that owns the bucket,
// the calling identity must have the GetBucketPolicy permissions on the specified
// bucket and belong to the bucket owner's account in order to use this operation.
//
// If you don't have GetBucketPolicy permissions, Amazon S3 returns a 403 Access
// Denied error. If you have the correct permissions, but you're not using an
// identity that belongs to the bucket owner's account, Amazon S3 returns a
// 405 Method Not Allowed error.
//
// As a security precaution, the root user of the Amazon Web Services account
// that owns a bucket can always use this operation, even if the policy explicitly
// denies the root user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// User Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// The following action is related to GetBucketPolicy:
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicy
func (c *S3) GetBucketPolicy(input *GetBucketPolicyInput) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	return out, req.Send()
}

// GetBucketPolicyWithContext is the same as GetBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketPolicyWithContext(ctx aws.Context, input *GetBucketPolicyInput, opts ...request.Option) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketPolicyStatus = "GetBucketPolicyStatus"

// GetBucketPolicyStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketPolicyStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketPolicyStatus for more information on using the GetBucketPolicyStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketPolicyStatusRequest method.
//	req, resp := client.GetBucketPolicyStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyStatus
func (c *S3) GetBucketPolicyStatusRequest(input *GetBucketPolicyStatusInput) (req *request.Request, output *GetBucketPolicyStatusOutput) {
	op := &request.Operation{
		Name:       opGetBucketPolicyStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?policyStatus",
	}

	if input == nil {
		input = &GetBucketPolicyStatusInput{}
	}

	output = &GetBucketPolicyStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketPolicyStatus API operation for Amazon Simple Storage Service.
//
// Retrieves the policy status for an Amazon S3 bucket, indicating whether the
// bucket is public. In order to use this operation, you must have the s3:GetBucketPolicyStatus
// permission. For more information about Amazon S3 permissions, see Specifying
// Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
//
// For more information about when Amazon S3 considers a bucket public, see
// The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status).
//
// The following operations are related to GetBucketPolicyStatus:
//
//   - Using Amazon S3 Block Public Access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
//
//   - GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html)
//
//   - PutPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html)
//
//   - DeletePublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketPolicyStatus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyStatus
func (c *S3) GetBucketPolicyStatus(input *GetBucketPolicyStatusInput) (*GetBucketPolicyStatusOutput, error) {
	req, out := c.GetBucketPolicyStatusRequest(input)
	return out, req.Send()
}

// GetBucketPolicyStatusWithContext is the same as GetBucketPolicyStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketPolicyStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketPolicyStatusWithContext(ctx aws.Context, input *GetBucketPolicyStatusInput, opts ...request.Option) (*GetBucketPolicyStatusOutput, error) {
	req, out := c.GetBucketPolicyStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketReplication = "GetBucketReplication"

// GetBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketReplication for more information on using the GetBucketReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketReplicationRequest method.
//	req, resp := client.GetBucketReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplication
func (c *S3) GetBucketReplicationRequest(input *GetBucketReplicationInput) (req *request.Request, output *GetBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opGetBucketReplication,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &GetBucketReplicationInput{}
	}

	output = &GetBucketReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketReplication API operation for Amazon Simple Storage Service.
//
// Returns the replication configuration of a bucket.
//
// It can take a while to propagate the put or delete a replication configuration
// to all Amazon S3 systems. Therefore, a get request soon after put or delete
// can return a wrong result.
//
// For information about replication configuration, see Replication (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html)
// in the Amazon S3 User Guide.
//
// This action requires permissions for the s3:GetReplicationConfiguration action.
// For more information about permissions, see Using Bucket Policies and User
// Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// If you include the Filter element in a replication configuration, you must
// also include the DeleteMarkerReplication and Priority elements. The response
// also returns those elements.
//
// For information about GetBucketReplication errors, see List of replication-related
// error codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList)
//
// The following operations are related to GetBucketReplication:
//
//   - PutBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html)
//
//   - DeleteBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketReplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplication
func (c *S3) GetBucketReplication(input *GetBucketReplicationInput) (*GetBucketReplicationOutput, error) {
	req, out := c.GetBucketReplicationRequest(input)
	return out, req.Send()
}

// GetBucketReplicationWithContext is the same as GetBucketReplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketReplicationWithContext(ctx aws.Context, input *GetBucketReplicationInput, opts ...request.Option) (*GetBucketReplicationOutput, error) {
	req, out := c.GetBucketReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketRequestPayment = "GetBucketRequestPayment"

// GetBucketRequestPaymentRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketRequestPayment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketRequestPayment for more information on using the GetBucketRequestPayment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketRequestPaymentRequest method.
//	req, resp := client.GetBucketRequestPaymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPayment
func (c *S3) GetBucketRequestPaymentRequest(input *GetBucketRequestPaymentInput) (req *request.Request, output *GetBucketRequestPaymentOutput) {
	op := &request.Operation{
		Name:       opGetBucketRequestPayment,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &GetBucketRequestPaymentInput{}
	}

	output = &GetBucketRequestPaymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketRequestPayment API operation for Amazon Simple Storage Service.
//
// Returns the request payment configuration of a bucket. To use this version
// of the operation, you must be the bucket owner. For more information, see
// Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html).
//
// The following operations are related to GetBucketRequestPayment:
//
//   - ListObjects (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketRequestPayment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPayment
func (c *S3) GetBucketRequestPayment(input *GetBucketRequestPaymentInput) (*GetBucketRequestPaymentOutput, error) {
	req, out := c.GetBucketRequestPaymentRequest(input)
	return out, req.Send()
}

// GetBucketRequestPaymentWithContext is the same as GetBucketRequestPayment with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketRequestPayment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketRequestPaymentWithContext(ctx aws.Context, input *GetBucketRequestPaymentInput, opts ...request.Option) (*GetBucketRequestPaymentOutput, error) {
	req, out := c.GetBucketRequestPaymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketTagging = "GetBucketTagging"

// GetBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketTagging for more information on using the GetBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketTaggingRequest method.
//	req, resp := client.GetBucketTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTagging
func (c *S3) GetBucketTaggingRequest(input *GetBucketTaggingInput) (req *request.Request, output *GetBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &GetBucketTaggingInput{}
	}

	output = &GetBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketTagging API operation for Amazon Simple Storage Service.
//
// Returns the tag set associated with the bucket.
//
// To use this operation, you must have permission to perform the s3:GetBucketTagging
// action. By default, the bucket owner has this permission and can grant this
// permission to others.
//
// GetBucketTagging has the following special error:
//
//   - Error code: NoSuchTagSet Description: There is no tag set associated
//     with the bucket.
//
// The following operations are related to GetBucketTagging:
//
//   - PutBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html)
//
//   - DeleteBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTagging
func (c *S3) GetBucketTagging(input *GetBucketTaggingInput) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	return out, req.Send()
}

// GetBucketTaggingWithContext is the same as GetBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketTaggingWithContext(ctx aws.Context, input *GetBucketTaggingInput, opts ...request.Option) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketVersioning = "GetBucketVersioning"

// GetBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketVersioning operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketVersioning for more information on using the GetBucketVersioning
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketVersioningRequest method.
//	req, resp := client.GetBucketVersioningRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioning
func (c *S3) GetBucketVersioningRequest(input *GetBucketVersioningInput) (req *request.Request, output *GetBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opGetBucketVersioning,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &GetBucketVersioningInput{}
	}

	output = &GetBucketVersioningOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketVersioning API operation for Amazon Simple Storage Service.
//
// Returns the versioning state of a bucket.
//
// To retrieve the versioning state of a bucket, you must be the bucket owner.
//
// This implementation also returns the MFA Delete status of the versioning
// state. If the MFA Delete status is enabled, the bucket owner must use an
// authentication device to change the versioning state of the bucket.
//
// The following operations are related to GetBucketVersioning:
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//   - DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketVersioning for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioning
func (c *S3) GetBucketVersioning(input *GetBucketVersioningInput) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	return out, req.Send()
}

// GetBucketVersioningWithContext is the same as GetBucketVersioning with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketVersioning for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketVersioningWithContext(ctx aws.Context, input *GetBucketVersioningInput, opts ...request.Option) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketWebsite = "GetBucketWebsite"

// GetBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketWebsite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketWebsite for more information on using the GetBucketWebsite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketWebsiteRequest method.
//	req, resp := client.GetBucketWebsiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsite
func (c *S3) GetBucketWebsiteRequest(input *GetBucketWebsiteInput) (req *request.Request, output *GetBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opGetBucketWebsite,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &GetBucketWebsiteInput{}
	}

	output = &GetBucketWebsiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketWebsite API operation for Amazon Simple Storage Service.
//
// Returns the website configuration for a bucket. To host website on Amazon
// S3, you can configure a bucket as website by adding a website configuration.
// For more information about hosting websites, see Hosting Websites on Amazon
// S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
//
// This GET action requires the S3:GetBucketWebsite permission. By default,
// only the bucket owner can read the bucket website configuration. However,
// bucket owners can allow other users to read the website configuration by
// writing a bucket policy granting them the S3:GetBucketWebsite permission.
//
// The following operations are related to DeleteBucketWebsite:
//
//   - DeleteBucketWebsite (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketWebsite.html)
//
//   - PutBucketWebsite (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketWebsite for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsite
func (c *S3) GetBucketWebsite(input *GetBucketWebsiteInput) (*GetBucketWebsiteOutput, error) {
	req, out := c.GetBucketWebsiteRequest(input)
	return out, req.Send()
}

// GetBucketWebsiteWithContext is the same as GetBucketWebsite with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketWebsite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketWebsiteWithContext(ctx aws.Context, input *GetBucketWebsiteInput, opts ...request.Option) (*GetBucketWebsiteOutput, error) {
	req, out := c.GetBucketWebsiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObject = "GetObject"

// GetObjectRequest generates a "aws/request.Request" representing the
// client's request for the GetObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObject for more information on using the GetObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetObjectRequest method.
//	req, resp := client.GetObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObject
func (c *S3) GetObjectRequest(input *GetObjectInput) (req *request.Request, output *GetObjectOutput) {
	op := &request.Operation{
		Name:       opGetObject,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &GetObjectInput{}
	}

	output = &GetObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObject API operation for Amazon Simple Storage Service.
//
// Retrieves objects from Amazon S3. To use GET, you must have READ access to
// the object. If you grant READ access to the anonymous user, you can return
// the object without using an authorization header.
//
// An Amazon S3 bucket has no directory hierarchy such as you would find in
// a typical computer file system. You can, however, create a logical hierarchy
// by using object key names that imply a folder structure. For example, instead
// of naming an object sample.jpg, you can name it photos/2006/February/sample.jpg.
//
// To get an object from such a logical hierarchy, specify the full key name
// for the object in the GET operation. For a virtual hosted-style request example,
// if you have the object photos/2006/February/sample.jpg, specify the resource
// as /photos/2006/February/sample.jpg. For a path-style request example, if
// you have the object photos/2006/February/sample.jpg in the bucket named examplebucket,
// specify the resource as /examplebucket/photos/2006/February/sample.jpg. For
// more information about request types, see HTTP Host Header Bucket Specification
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket).
//
// For more information about returning the ACL of an object, see GetObjectAcl
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html).
//
// If the object you are retrieving is stored in the S3 Glacier or S3 Glacier
// Deep Archive storage class, or S3 Intelligent-Tiering Archive or S3 Intelligent-Tiering
// Deep Archive tiers, before you can retrieve the object you must first restore
// a copy using RestoreObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html).
// Otherwise, this action returns an InvalidObjectStateError error. For information
// about restoring archived objects, see Restoring Archived Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html).
//
// Encryption request headers, like x-amz-server-side-encryption, should not
// be sent for GET requests if your object uses server-side encryption with
// KMS keys (SSE-KMS) or server-side encryption with Amazon S3–managed encryption
// keys (SSE-S3). If your object does use these types of keys, you’ll get
// an HTTP 400 BadRequest error.
//
// If you encrypt an object by using server-side encryption with customer-provided
// encryption keys (SSE-C) when you store the object in Amazon S3, then when
// you GET the object, you must use the following headers:
//
//   - x-amz-server-side-encryption-customer-algorithm
//
//   - x-amz-server-side-encryption-customer-key
//
//   - x-amz-server-side-encryption-customer-key-MD5
//
// For more information about SSE-C, see Server-Side Encryption (Using Customer-Provided
// Encryption Keys) (https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html).
//
// Assuming you have the relevant permission to read object tags, the response
// also returns the x-amz-tagging-count header that provides the count of number
// of tags associated with the object. You can use GetObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html)
// to retrieve the tag set associated with an object.
//
// # Permissions
//
// You need the relevant read object (or version) permission for this operation.
// For more information, see Specifying Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
// If the object you request does not exist, the error Amazon S3 returns depends
// on whether you also have the s3:ListBucket permission.
//
//   - If you have the s3:ListBucket permission on the bucket, Amazon S3 will
//     return an HTTP status code 404 ("no such key") error.
//
//   - If you don’t have the s3:ListBucket permission, Amazon S3 will return
//     an HTTP status code 403 ("access denied") error.
//
// # Versioning
//
// By default, the GET action returns the current version of an object. To return
// a different version, use the versionId subresource.
//
//   - If you supply a versionId, you need the s3:GetObjectVersion permission
//     to access a specific version of an object. If you request a specific version,
//     you do not need to have the s3:GetObject permission.
//
//   - If the current version of the object is a delete marker, Amazon S3 behaves
//     as if the object was deleted and includes x-amz-delete-marker: true in
//     the response.
//
// For more information about versioning, see PutBucketVersioning (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html).
//
// # Overriding Response Header Values
//
// There are times when you want to override certain response header values
// in a GET response. For example, you might override the Content-Disposition
// response header value in your GET request.
//
// You can override values for a set of response headers using the following
// query parameters. These response header values are sent only on a successful
// request, that is, when status code 200 OK is returned. The set of headers
// you can override using these parameters is a subset of the headers that Amazon
// S3 accepts when you create an object. The response headers that you can override
// for the GET response are Content-Type, Content-Language, Expires, Cache-Control,
// Content-Disposition, and Content-Encoding. To override these header values
// in the GET response, you use the following request parameters.
//
// You must sign the request, either using an Authorization header or a presigned
// URL, when using these parameters. They cannot be used with an unsigned (anonymous)
// request.
//
//   - response-content-type
//
//   - response-content-language
//
//   - response-expires
//
//   - response-cache-control
//
//   - response-content-disposition
//
//   - response-content-encoding
//
// # Additional Considerations about Request Headers
//
// If both of the If-Match and If-Unmodified-Since headers are present in the
// request as follows: If-Match condition evaluates to true, and; If-Unmodified-Since
// condition evaluates to false; then, S3 returns 200 OK and the data requested.
//
// If both of the If-None-Match and If-Modified-Since headers are present in
// the request as follows:If-None-Match condition evaluates to false, and; If-Modified-Since
// condition evaluates to true; then, S3 returns 304 Not Modified response code.
//
// For more information about conditional requests, see RFC 7232 (https://tools.ietf.org/html/rfc7232).
//
// The following operations are related to GetObject:
//
//   - ListBuckets (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html)
//
//   - GetObjectAcl (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObject for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeNoSuchKey "NoSuchKey"
//     The specified key does not exist.
//
//   - ErrCodeInvalidObjectState "InvalidObjectState"
//     Object is archived and inaccessible until restored.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObject
func (c *S3) GetObject(input *GetObjectInput) (*GetObjectOutput, error) {
	req, out := c.GetObjectRequest(input)
	return out, req.Send()
}

// GetObjectWithContext is the same as GetObject with the addition of
// the ability to pass a context and additional request options.
//
// See GetObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectWithContext(ctx aws.Context, input *GetObjectInput, opts ...request.Option) (*GetObjectOutput, error) {
	req, out := c.GetObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectAcl = "GetObjectAcl"

// GetObjectAclRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectAcl for more information on using the GetObjectAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetObjectAclRequest method.
//	req, resp := client.GetObjectAclRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAcl
func (c *S3) GetObjectAclRequest(input *GetObjectAclInput) (req *request.Request, output *GetObjectAclOutput) {
	op := &request.Operation{
		Name:       opGetObjectAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &GetObjectAclInput{}
	}

	output = &GetObjectAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectAcl API operation for Amazon Simple Storage Service.
//
// Returns the access control list (ACL) of an object. To use this operation,
// you must have s3:GetObjectAcl permissions or READ_ACP access to the object.
// For more information, see Mapping of ACL permissions and access policy permissions
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#acl-access-policy-permission-mapping)
// in the Amazon S3 User Guide
//
// This action is not supported by Amazon S3 on Outposts.
//
// # Versioning
//
// By default, GET returns ACL information about the current version of an object.
// To return ACL information about a different version, use the versionId subresource.
//
// If your bucket uses the bucket owner enforced setting for S3 Object Ownership,
// requests to read ACLs are still supported and return the bucket-owner-full-control
// ACL with the owner being the account that created the bucket. For more information,
// see Controlling object ownership and disabling ACLs (https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html)
// in the Amazon S3 User Guide.
//
// The following operations are related to GetObjectAcl:
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - GetObjectAttributes (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html)
//
//   - DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectAcl for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeNoSuchKey "NoSuchKey"
//     The specified key does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAcl
func (c *S3) GetObjectAcl(input *GetObjectAclInput) (*GetObjectAclOutput, error) {
	req, out := c.GetObjectAclRequest(input)
	return out, req.Send()
}

// GetObjectAclWithContext is the same as GetObjectAcl with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectAclWithContext(ctx aws.Context, input *GetObjectAclInput, opts ...request.Option) (*GetObjectAclOutput, error) {
	req, out := c.GetObjectAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectAttributes = "GetObjectAttributes"

// GetObjectAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectAttributes for more information on using the GetObjectAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetObjectAttributesRequest method.
//	req, resp := client.GetObjectAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAttributes
func (c *S3) GetObjectAttributesRequest(input *GetObjectAttributesInput) (req *request.Request, output *GetObjectAttributesOutput) {
	op := &request.Operation{
		Name:       opGetObjectAttributes,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?attributes",
	}

	if input == nil {
		input = &GetObjectAttributesInput{}
	}

	output = &GetObjectAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectAttributes API operation for Amazon Simple Storage Service.
//
// Retrieves all the metadata from an object without returning the object itself.
// This action is useful if you're interested only in an object's metadata.
// To use GetObjectAttributes, you must have READ access to the object.
//
// GetObjectAttributes combines the functionality of GetObjectAcl, GetObjectLegalHold,
// GetObjectLockConfiguration, GetObjectRetention, GetObjectTagging, HeadObject,
// and ListParts. All of the data returned with each of those individual calls
// can be returned with a single call to GetObjectAttributes.
//
// If you encrypt an object by using server-side encryption with customer-provided
// encryption keys (SSE-C) when you store the object in Amazon S3, then when
// you retrieve the metadata from the object, you must use the following headers:
//
//   - x-amz-server-side-encryption-customer-algorithm
//
//   - x-amz-server-side-encryption-customer-key
//
//   - x-amz-server-side-encryption-customer-key-MD5
//
// For more information about SSE-C, see Server-Side Encryption (Using Customer-Provided
// Encryption Keys) (https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html)
// in the Amazon S3 User Guide.
//
//   - Encryption request headers, such as x-amz-server-side-encryption, should
//     not be sent for GET requests if your object uses server-side encryption
//     with Amazon Web Services KMS keys stored in Amazon Web Services Key Management
//     Service (SSE-KMS) or server-side encryption with Amazon S3 managed encryption
//     keys (SSE-S3). If your object does use these types of keys, you'll get
//     an HTTP 400 Bad Request error.
//
//   - The last modified property in this case is the creation date of the
//     object.
//
// Consider the following when using request headers:
//
//   - If both of the If-Match and If-Unmodified-Since headers are present
//     in the request as follows, then Amazon S3 returns the HTTP status code
//     200 OK and the data requested: If-Match condition evaluates to true. If-Unmodified-Since
//     condition evaluates to false.
//
//   - If both of the If-None-Match and If-Modified-Since headers are present
//     in the request as follows, then Amazon S3 returns the HTTP status code
//     304 Not Modified: If-None-Match condition evaluates to false. If-Modified-Since
//     condition evaluates to true.
//
// For more information about conditional requests, see RFC 7232 (https://tools.ietf.org/html/rfc7232).
//
// # Permissions
//
// The permissions that you need to use this operation depend on whether the
// bucket is versioned. If the bucket is versioned, you need both the s3:GetObjectVersion
// and s3:GetObjectVersionAttributes permissions for this operation. If the
// bucket is not versioned, you need the s3:GetObject and s3:GetObjectAttributes
// permissions. For more information, see Specifying Permissions in a Policy
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html)
// in the Amazon S3 User Guide. If the object that you request does not exist,
// the error Amazon S3 returns depends on whether you also have the s3:ListBucket
// permission.
//
//   - If you have the s3:ListBucket permission on the bucket, Amazon S3 returns
//     an HTTP status code 404 Not Found ("no such key") error.
//
//   - If you don't have the s3:ListBucket permission, Amazon S3 returns an
//     HTTP status code 403 Forbidden ("access denied") error.
//
// The following actions are related to GetObjectAttributes:
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - GetObjectAcl (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html)
//
//   - GetObjectLegalHold (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLegalHold.html)
//
//   - GetObjectLockConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLockConfiguration.html)
//
//   - GetObjectRetention (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectRetention.html)
//
//   - GetObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html)
//
//   - HeadObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_HeadObject.html)
//
//   - ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectAttributes for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeNoSuchKey "NoSuchKey"
//     The specified key does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAttributes
func (c *S3) GetObjectAttributes(input *GetObjectAttributesInput) (*GetObjectAttributesOutput, error) {
	req, out := c.GetObjectAttributesRequest(input)
	return out, req.Send()
}

// GetObjectAttributesWithContext is the same as GetObjectAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectAttributesWithContext(ctx aws.Context, input *GetObjectAttributesInput, opts ...request.Option) (*GetObjectAttributesOutput, error) {
	req, out := c.GetObjectAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectLegalHold = "GetObjectLegalHold"

// GetObjectLegalHoldRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectLegalHold operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectLegalHold for more information on using the GetObjectLegalHold
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetObjectLegalHoldRequest method.
//	req, resp := client.GetObjectLegalHoldRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLegalHold
func (c *S3) GetObjectLegalHoldRequest(input *GetObjectLegalHoldInput) (req *request.Request, output *GetObjectLegalHoldOutput) {
	op := &request.Operation{
		Name:       opGetObjectLegalHold,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?legal-hold",
	}

	if input == nil {
		input = &GetObjectLegalHoldInput{}
	}

	output = &GetObjectLegalHoldOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectLegalHold API operation for Amazon Simple Storage Service.
//
// Gets an object's current legal hold status. For more information, see Locking
// Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html).
//
// This action is not supported by Amazon S3 on Outposts.
//
// The following action is related to GetObjectLegalHold:
//
//   - GetObjectAttributes (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectLegalHold for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLegalHold
func (c *S3) GetObjectLegalHold(input *GetObjectLegalHoldInput) (*GetObjectLegalHoldOutput, error) {
	req, out := c.GetObjectLegalHoldRequest(input)
	return out, req.Send()
}

// GetObjectLegalHoldWithContext is the same as GetObjectLegalHold with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectLegalHold for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectLegalHoldWithContext(ctx aws.Context, input *GetObjectLegalHoldInput, opts ...request.Option) (*GetObjectLegalHoldOutput, error) {
	req, out := c.GetObjectLegalHoldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectLockConfiguration = "GetObjectLockConfiguration"

// GetObjectLockConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectLockConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectLockConfiguration for more information on using the GetObjectLockConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetObjectLockConfigurationRequest method.
//	req, resp := client.GetObjectLockConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLockConfiguration
func (c *S3) GetObjectLockConfigurationRequest(input *GetObjectLockConfigurationInput) (req *request.Request, output *GetObjectLockConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetObjectLockConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?object-lock",
	}

	if input == nil {
		input = &GetObjectLockConfigurationInput{}
	}

	output = &GetObjectLockConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectLockConfiguration API operation for Amazon Simple Storage Service.
//
// Gets the Object Lock configuration for a bucket. The rule specified in the
// Object Lock configuration will be applied by default to every new object
// placed in the specified bucket. For more information, see Locking Objects
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html).
//
// The following action is related to GetObjectLockConfiguration:
//
//   - GetObjectAttributes (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectLockConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectLockConfiguration
func (c *S3) GetObjectLockConfiguration(input *GetObjectLockConfigurationInput) (*GetObjectLockConfigurationOutput, error) {
	req, out := c.GetObjectLockConfigurationRequest(input)
	return out, req.Send()
}

// GetObjectLockConfigurationWithContext is the same as GetObjectLockConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectLockConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectLockConfigurationWithContext(ctx aws.Context, input *GetObjectLockConfigurationInput, opts ...request.Option) (*GetObjectLockConfigurationOutput, error) {
	req, out := c.GetObjectLockConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectRetention = "GetObjectRetention"

// GetObjectRetentionRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectRetention operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectRetention for more information on using the GetObjectRetention
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetObjectRetentionRequest method.
//	req, resp := client.GetObjectRetentionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectRetention
func (c *S3) GetObjectRetentionRequest(input *GetObjectRetentionInput) (req *request.Request, output *GetObjectRetentionOutput) {
	op := &request.Operation{
		Name:       opGetObjectRetention,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?retention",
	}

	if input == nil {
		input = &GetObjectRetentionInput{}
	}

	output = &GetObjectRetentionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectRetention API operation for Amazon Simple Storage Service.
//
// Retrieves an object's retention settings. For more information, see Locking
// Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html).
//
// This action is not supported by Amazon S3 on Outposts.
//
// The following action is related to GetObjectRetention:
//
//   - GetObjectAttributes (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectRetention for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectRetention
func (c *S3) GetObjectRetention(input *GetObjectRetentionInput) (*GetObjectRetentionOutput, error) {
	req, out := c.GetObjectRetentionRequest(input)
	return out, req.Send()
}

// GetObjectRetentionWithContext is the same as GetObjectRetention with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectRetention for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectRetentionWithContext(ctx aws.Context, input *GetObjectRetentionInput, opts ...request.Option) (*GetObjectRetentionOutput, error) {
	req, out := c.GetObjectRetentionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectTagging = "GetObjectTagging"

// GetObjectTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectTagging for more information on using the GetObjectTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetObjectTaggingRequest method.
//	req, resp := client.GetObjectTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTagging
func (c *S3) GetObjectTaggingRequest(input *GetObjectTaggingInput) (req *request.Request, output *GetObjectTaggingOutput) {
	op := &request.Operation{
		Name:       opGetObjectTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &GetObjectTaggingInput{}
	}

	output = &GetObjectTaggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectTagging API operation for Amazon Simple Storage Service.
//
// Returns the tag-set of an object. You send the GET request against the tagging
// subresource associated with the object.
//
// To use this operation, you must have permission to perform the s3:GetObjectTagging
// action. By default, the GET action returns information about current version
// of an object. For a versioned bucket, you can have multiple versions of an
// object in your bucket. To retrieve tags of any other version, use the versionId
// query parameter. You also need permission for the s3:GetObjectVersionTagging
// action.
//
// By default, the bucket owner has this permission and can grant this permission
// to others.
//
// For information about the Amazon S3 object tagging feature, see Object Tagging
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html).
//
// The following actions are related to GetObjectTagging:
//
//   - DeleteObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html)
//
//   - GetObjectAttributes (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html)
//
//   - PutObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTagging
func (c *S3) GetObjectTagging(input *GetObjectTaggingInput) (*GetObjectTaggingOutput, error) {
	req, out := c.GetObjectTaggingRequest(input)
	return out, req.Send()
}

// GetObjectTaggingWithContext is the same as GetObjectTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectTaggingWithContext(ctx aws.Context, input *GetObjectTaggingInput, opts ...request.Option) (*GetObjectTaggingOutput, error) {
	req, out := c.GetObjectTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectTorrent = "GetObjectTorrent"

// GetObjectTorrentRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectTorrent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectTorrent for more information on using the GetObjectTorrent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetObjectTorrentRequest method.
//	req, resp := client.GetObjectTorrentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrent
func (c *S3) GetObjectTorrentRequest(input *GetObjectTorrentInput) (req *request.Request, output *GetObjectTorrentOutput) {
	op := &request.Operation{
		Name:       opGetObjectTorrent,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?torrent",
	}

	if input == nil {
		input = &GetObjectTorrentInput{}
	}

	output = &GetObjectTorrentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectTorrent API operation for Amazon Simple Storage Service.
//
// Returns torrent files from a bucket. BitTorrent can save you bandwidth when
// you're distributing large files. For more information about BitTorrent, see
// Using BitTorrent with Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3Torrent.html).
//
// You can get torrent only for objects that are less than 5 GB in size, and
// that are not encrypted using server-side encryption with a customer-provided
// encryption key.
//
// To use GET, you must have READ access to the object.
//
// This action is not supported by Amazon S3 on Outposts.
//
// The following action is related to GetObjectTorrent:
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectTorrent for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrent
func (c *S3) GetObjectTorrent(input *GetObjectTorrentInput) (*GetObjectTorrentOutput, error) {
	req, out := c.GetObjectTorrentRequest(input)
	return out, req.Send()
}

// GetObjectTorrentWithContext is the same as GetObjectTorrent with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectTorrent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectTorrentWithContext(ctx aws.Context, input *GetObjectTorrentInput, opts ...request.Option) (*GetObjectTorrentOutput, error) {
	req, out := c.GetObjectTorrentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicAccessBlock = "GetPublicAccessBlock"

// GetPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicAccessBlock for more information on using the GetPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPublicAccessBlockRequest method.
//	req, resp := client.GetPublicAccessBlockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetPublicAccessBlock
func (c *S3) GetPublicAccessBlockRequest(input *GetPublicAccessBlockInput) (req *request.Request, output *GetPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opGetPublicAccessBlock,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?publicAccessBlock",
	}

	if input == nil {
		input = &GetPublicAccessBlockInput{}
	}

	output = &GetPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPublicAccessBlock API operation for Amazon Simple Storage Service.
//
// Retrieves the PublicAccessBlock configuration for an Amazon S3 bucket. To
// use this operation, you must have the s3:GetBucketPublicAccessBlock permission.
// For more information about Amazon S3 permissions, see Specifying Permissions
// in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
//
// When Amazon S3 evaluates the PublicAccessBlock configuration for a bucket
// or an object, it checks the PublicAccessBlock configuration for both the
// bucket (or the bucket that contains the object) and the bucket owner's account.
// If the PublicAccessBlock settings are different between the bucket and the
// account, Amazon S3 uses the most restrictive combination of the bucket-level
// and account-level settings.
//
// For more information about when Amazon S3 considers a bucket or an object
// public, see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status).
//
// The following operations are related to GetPublicAccessBlock:
//
//   - Using Amazon S3 Block Public Access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
//
//   - PutPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html)
//
//   - GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html)
//
//   - DeletePublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetPublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetPublicAccessBlock
func (c *S3) GetPublicAccessBlock(input *GetPublicAccessBlockInput) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	return out, req.Send()
}

// GetPublicAccessBlockWithContext is the same as GetPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetPublicAccessBlockWithContext(ctx aws.Context, input *GetPublicAccessBlockInput, opts ...request.Option) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opHeadBucket = "HeadBucket"

// HeadBucketRequest generates a "aws/request.Request" representing the
// client's request for the HeadBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See HeadBucket for more information on using the HeadBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the HeadBucketRequest method.
//	req, resp := client.HeadBucketRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucket
func (c *S3) HeadBucketRequest(input *HeadBucketInput) (req *request.Request, output *HeadBucketOutput) {
	op := &request.Operation{
		Name:       opHeadBucket,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &HeadBucketInput{}
	}

	output = &HeadBucketOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// HeadBucket API operation for Amazon Simple Storage Service.
//
// This action is useful to determine if a bucket exists and you have permission
// to access it. The action returns a 200 OK if the bucket exists and you have
// permission to access it.
//
// If the bucket does not exist or you do not have permission to access it,
// the HEAD request returns a generic 404 Not Found or 403 Forbidden code. A
// message body is not included, so you cannot determine the exception beyond
// these error codes.
//
// To use this operation, you must have permissions to perform the s3:ListBucket
// action. The bucket owner has this permission by default and can grant this
// permission to others. For more information about permissions, see Permissions
// Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// To use this API against an access point, you must provide the alias of the
// access point in place of the bucket name or specify the access point ARN.
// When using the access point ARN, you must direct requests to the access point
// hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
// When using the Amazon Web Services SDKs, you provide the ARN in place of
// the bucket name. For more information see, Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation HeadBucket for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeNoSuchBucket "NoSuchBucket"
//     The specified bucket does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucket
func (c *S3) HeadBucket(input *HeadBucketInput) (*HeadBucketOutput, error) {
	req, out := c.HeadBucketRequest(input)
	return out, req.Send()
}

// HeadBucketWithContext is the same as HeadBucket with the addition of
// the ability to pass a context and additional request options.
//
// See HeadBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) HeadBucketWithContext(ctx aws.Context, input *HeadBucketInput, opts ...request.Option) (*HeadBucketOutput, error) {
	req, out := c.HeadBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opHeadObject = "HeadObject"

// HeadObjectRequest generates a "aws/request.Request" representing the
// client's request for the HeadObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See HeadObject for more information on using the HeadObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the HeadObjectRequest method.
//	req, resp := client.HeadObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObject
func (c *S3) HeadObjectRequest(input *HeadObjectInput) (req *request.Request, output *HeadObjectOutput) {
	op := &request.Operation{
		Name:       opHeadObject,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &HeadObjectInput{}
	}

	output = &HeadObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// HeadObject API operation for Amazon Simple Storage Service.
//
// The HEAD action retrieves metadata from an object without returning the object
// itself. This action is useful if you're only interested in an object's metadata.
// To use HEAD, you must have READ access to the object.
//
// A HEAD request has the same options as a GET action on an object. The response
// is identical to the GET response except that there is no response body. Because
// of this, if the HEAD request generates an error, it returns a generic 404
// Not Found or 403 Forbidden code. It is not possible to retrieve the exact
// exception beyond these error codes.
//
// If you encrypt an object by using server-side encryption with customer-provided
// encryption keys (SSE-C) when you store the object in Amazon S3, then when
// you retrieve the metadata from the object, you must use the following headers:
//
//   - x-amz-server-side-encryption-customer-algorithm
//
//   - x-amz-server-side-encryption-customer-key
//
//   - x-amz-server-side-encryption-customer-key-MD5
//
// For more information about SSE-C, see Server-Side Encryption (Using Customer-Provided
// Encryption Keys) (https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html).
//
//   - Encryption request headers, like x-amz-server-side-encryption, should
//     not be sent for GET requests if your object uses server-side encryption
//     with KMS keys (SSE-KMS) or server-side encryption with Amazon S3–managed
//     encryption keys (SSE-S3). If your object does use these types of keys,
//     you’ll get an HTTP 400 BadRequest error.
//
//   - The last modified property in this case is the creation date of the
//     object.
//
// Request headers are limited to 8 KB in size. For more information, see Common
// Request Headers (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html).
//
// Consider the following when using request headers:
//
//   - Consideration 1 – If both of the If-Match and If-Unmodified-Since
//     headers are present in the request as follows: If-Match condition evaluates
//     to true, and; If-Unmodified-Since condition evaluates to false; Then Amazon
//     S3 returns 200 OK and the data requested.
//
//   - Consideration 2 – If both of the If-None-Match and If-Modified-Since
//     headers are present in the request as follows: If-None-Match condition
//     evaluates to false, and; If-Modified-Since condition evaluates to true;
//     Then Amazon S3 returns the 304 Not Modified response code.
//
// For more information about conditional requests, see RFC 7232 (https://tools.ietf.org/html/rfc7232).
//
// # Permissions
//
// You need the relevant read object (or version) permission for this operation.
// For more information, see Specifying Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
// If the object you request does not exist, the error Amazon S3 returns depends
// on whether you also have the s3:ListBucket permission.
//
//   - If you have the s3:ListBucket permission on the bucket, Amazon S3 returns
//     an HTTP status code 404 ("no such key") error.
//
//   - If you don’t have the s3:ListBucket permission, Amazon S3 returns
//     an HTTP status code 403 ("access denied") error.
//
// The following actions are related to HeadObject:
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - GetObjectAttributes (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html)
//
// See http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#RESTErrorResponses
// for more information on returned errors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation HeadObject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObject
func (c *S3) HeadObject(input *HeadObjectInput) (*HeadObjectOutput, error) {
	req, out := c.HeadObjectRequest(input)
	return out, req.Send()
}

// HeadObjectWithContext is the same as HeadObject with the addition of
// the ability to pass a context and additional request options.
//
// See HeadObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) HeadObjectWithContext(ctx aws.Context, input *HeadObjectInput, opts ...request.Option) (*HeadObjectOutput, error) {
	req, out := c.HeadObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBucketAnalyticsConfigurations = "ListBucketAnalyticsConfigurations"

// ListBucketAnalyticsConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBucketAnalyticsConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBucketAnalyticsConfigurations for more information on using the ListBucketAnalyticsConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBucketAnalyticsConfigurationsRequest method.
//	req, resp := client.ListBucketAnalyticsConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurations
func (c *S3) ListBucketAnalyticsConfigurationsRequest(input *ListBucketAnalyticsConfigurationsInput) (req *request.Request, output *ListBucketAnalyticsConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListBucketAnalyticsConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &ListBucketAnalyticsConfigurationsInput{}
	}

	output = &ListBucketAnalyticsConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBucketAnalyticsConfigurations API operation for Amazon Simple Storage Service.
//
// Lists the analytics configurations for the bucket. You can have up to 1,000
// analytics configurations per bucket.
//
// This action supports list pagination and does not return more than 100 configurations
// at a time. You should always check the IsTruncated element in the response.
// If there are no more configurations to list, IsTruncated is set to false.
// If there are more configurations to list, IsTruncated is set to true, and
// there will be a value in NextContinuationToken. You use the NextContinuationToken
// value to continue the pagination of the list by passing the value in continuation-token
// in the request to GET the next page.
//
// To use this operation, you must have permissions to perform the s3:GetAnalyticsConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// For information about Amazon S3 analytics feature, see Amazon S3 Analytics
// – Storage Class Analysis (https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html).
//
// The following operations are related to ListBucketAnalyticsConfigurations:
//
//   - GetBucketAnalyticsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html)
//
//   - DeleteBucketAnalyticsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html)
//
//   - PutBucketAnalyticsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBucketAnalyticsConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurations
func (c *S3) ListBucketAnalyticsConfigurations(input *ListBucketAnalyticsConfigurationsInput) (*ListBucketAnalyticsConfigurationsOutput, error) {
	req, out := c.ListBucketAnalyticsConfigurationsRequest(input)
	return out, req.Send()
}

// ListBucketAnalyticsConfigurationsWithContext is the same as ListBucketAnalyticsConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBucketAnalyticsConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketAnalyticsConfigurationsWithContext(ctx aws.Context, input *ListBucketAnalyticsConfigurationsInput, opts ...request.Option) (*ListBucketAnalyticsConfigurationsOutput, error) {
	req, out := c.ListBucketAnalyticsConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBucketIntelligentTieringConfigurations = "ListBucketIntelligentTieringConfigurations"

// ListBucketIntelligentTieringConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBucketIntelligentTieringConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBucketIntelligentTieringConfigurations for more information on using the ListBucketIntelligentTieringConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBucketIntelligentTieringConfigurationsRequest method.
//	req, resp := client.ListBucketIntelligentTieringConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketIntelligentTieringConfigurations
func (c *S3) ListBucketIntelligentTieringConfigurationsRequest(input *ListBucketIntelligentTieringConfigurationsInput) (req *request.Request, output *ListBucketIntelligentTieringConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListBucketIntelligentTieringConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?intelligent-tiering",
	}

	if input == nil {
		input = &ListBucketIntelligentTieringConfigurationsInput{}
	}

	output = &ListBucketIntelligentTieringConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBucketIntelligentTieringConfigurations API operation for Amazon Simple Storage Service.
//
// Lists the S3 Intelligent-Tiering configuration from the specified bucket.
//
// The S3 Intelligent-Tiering storage class is designed to optimize storage
// costs by automatically moving data to the most cost-effective storage access
// tier, without performance impact or operational overhead. S3 Intelligent-Tiering
// delivers automatic cost savings in three low latency and high throughput
// access tiers. To get the lowest storage cost on data that can be accessed
// in minutes to hours, you can choose to activate additional archiving capabilities.
//
// The S3 Intelligent-Tiering storage class is the ideal storage class for data
// with unknown, changing, or unpredictable access patterns, independent of
// object size or retention period. If the size of an object is less than 128
// KB, it is not monitored and not eligible for auto-tiering. Smaller objects
// can be stored, but they are always charged at the Frequent Access tier rates
// in the S3 Intelligent-Tiering storage class.
//
// For more information, see Storage class for automatically optimizing frequently
// and infrequently accessed objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access).
//
// Operations related to ListBucketIntelligentTieringConfigurations include:
//
//   - DeleteBucketIntelligentTieringConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html)
//
//   - PutBucketIntelligentTieringConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html)
//
//   - GetBucketIntelligentTieringConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBucketIntelligentTieringConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketIntelligentTieringConfigurations
func (c *S3) ListBucketIntelligentTieringConfigurations(input *ListBucketIntelligentTieringConfigurationsInput) (*ListBucketIntelligentTieringConfigurationsOutput, error) {
	req, out := c.ListBucketIntelligentTieringConfigurationsRequest(input)
	return out, req.Send()
}

// ListBucketIntelligentTieringConfigurationsWithContext is the same as ListBucketIntelligentTieringConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBucketIntelligentTieringConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketIntelligentTieringConfigurationsWithContext(ctx aws.Context, input *ListBucketIntelligentTieringConfigurationsInput, opts ...request.Option) (*ListBucketIntelligentTieringConfigurationsOutput, error) {
	req, out := c.ListBucketIntelligentTieringConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBucketInventoryConfigurations = "ListBucketInventoryConfigurations"

// ListBucketInventoryConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBucketInventoryConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBucketInventoryConfigurations for more information on using the ListBucketInventoryConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBucketInventoryConfigurationsRequest method.
//	req, resp := client.ListBucketInventoryConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurations
func (c *S3) ListBucketInventoryConfigurationsRequest(input *ListBucketInventoryConfigurationsInput) (req *request.Request, output *ListBucketInventoryConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListBucketInventoryConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &ListBucketInventoryConfigurationsInput{}
	}

	output = &ListBucketInventoryConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBucketInventoryConfigurations API operation for Amazon Simple Storage Service.
//
// Returns a list of inventory configurations for the bucket. You can have up
// to 1,000 analytics configurations per bucket.
//
// This action supports list pagination and does not return more than 100 configurations
// at a time. Always check the IsTruncated element in the response. If there
// are no more configurations to list, IsTruncated is set to false. If there
// are more configurations to list, IsTruncated is set to true, and there is
// a value in NextContinuationToken. You use the NextContinuationToken value
// to continue the pagination of the list by passing the value in continuation-token
// in the request to GET the next page.
//
// To use this operation, you must have permissions to perform the s3:GetInventoryConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// For information about the Amazon S3 inventory feature, see Amazon S3 Inventory
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html)
//
// The following operations are related to ListBucketInventoryConfigurations:
//
//   - GetBucketInventoryConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html)
//
//   - DeleteBucketInventoryConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html)
//
//   - PutBucketInventoryConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBucketInventoryConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurations
func (c *S3) ListBucketInventoryConfigurations(input *ListBucketInventoryConfigurationsInput) (*ListBucketInventoryConfigurationsOutput, error) {
	req, out := c.ListBucketInventoryConfigurationsRequest(input)
	return out, req.Send()
}

// ListBucketInventoryConfigurationsWithContext is the same as ListBucketInventoryConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBucketInventoryConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketInventoryConfigurationsWithContext(ctx aws.Context, input *ListBucketInventoryConfigurationsInput, opts ...request.Option) (*ListBucketInventoryConfigurationsOutput, error) {
	req, out := c.ListBucketInventoryConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBucketMetricsConfigurations = "ListBucketMetricsConfigurations"

// ListBucketMetricsConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBucketMetricsConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBucketMetricsConfigurations for more information on using the ListBucketMetricsConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBucketMetricsConfigurationsRequest method.
//	req, resp := client.ListBucketMetricsConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurations
func (c *S3) ListBucketMetricsConfigurationsRequest(input *ListBucketMetricsConfigurationsInput) (req *request.Request, output *ListBucketMetricsConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListBucketMetricsConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &ListBucketMetricsConfigurationsInput{}
	}

	output = &ListBucketMetricsConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBucketMetricsConfigurations API operation for Amazon Simple Storage Service.
//
// Lists the metrics configurations for the bucket. The metrics configurations
// are only for the request metrics of the bucket and do not provide information
// on daily storage metrics. You can have up to 1,000 configurations per bucket.
//
// This action supports list pagination and does not return more than 100 configurations
// at a time. Always check the IsTruncated element in the response. If there
// are no more configurations to list, IsTruncated is set to false. If there
// are more configurations to list, IsTruncated is set to true, and there is
// a value in NextContinuationToken. You use the NextContinuationToken value
// to continue the pagination of the list by passing the value in continuation-token
// in the request to GET the next page.
//
// To use this operation, you must have permissions to perform the s3:GetMetricsConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// For more information about metrics configurations and CloudWatch request
// metrics, see Monitoring Metrics with Amazon CloudWatch (https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html).
//
// The following operations are related to ListBucketMetricsConfigurations:
//
//   - PutBucketMetricsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html)
//
//   - GetBucketMetricsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html)
//
//   - DeleteBucketMetricsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBucketMetricsConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurations
func (c *S3) ListBucketMetricsConfigurations(input *ListBucketMetricsConfigurationsInput) (*ListBucketMetricsConfigurationsOutput, error) {
	req, out := c.ListBucketMetricsConfigurationsRequest(input)
	return out, req.Send()
}

// ListBucketMetricsConfigurationsWithContext is the same as ListBucketMetricsConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBucketMetricsConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketMetricsConfigurationsWithContext(ctx aws.Context, input *ListBucketMetricsConfigurationsInput, opts ...request.Option) (*ListBucketMetricsConfigurationsOutput, error) {
	req, out := c.ListBucketMetricsConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBuckets = "ListBuckets"

// ListBucketsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuckets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuckets for more information on using the ListBuckets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBucketsRequest method.
//	req, resp := client.ListBucketsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBuckets
func (c *S3) ListBucketsRequest(input *ListBucketsInput) (req *request.Request, output *ListBucketsOutput) {
	op := &request.Operation{
		Name:       opListBuckets,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBucketsInput{}
	}

	output = &ListBucketsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuckets API operation for Amazon Simple Storage Service.
//
// Returns a list of all buckets owned by the authenticated sender of the request.
// To use this operation, you must have the s3:ListAllMyBuckets permission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBuckets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBuckets
func (c *S3) ListBuckets(input *ListBucketsInput) (*ListBucketsOutput, error) {
	req, out := c.ListBucketsRequest(input)
	return out, req.Send()
}

// ListBucketsWithContext is the same as ListBuckets with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuckets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketsWithContext(ctx aws.Context, input *ListBucketsInput, opts ...request.Option) (*ListBucketsOutput, error) {
	req, out := c.ListBucketsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMultipartUploads = "ListMultipartUploads"

// ListMultipartUploadsRequest generates a "aws/request.Request" representing the
// client's request for the ListMultipartUploads operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultipartUploads for more information on using the ListMultipartUploads
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMultipartUploadsRequest method.
//	req, resp := client.ListMultipartUploadsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploads
func (c *S3) ListMultipartUploadsRequest(input *ListMultipartUploadsInput) (req *request.Request, output *ListMultipartUploadsOutput) {
	op := &request.Operation{
		Name:       opListMultipartUploads,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?uploads",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "UploadIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextUploadIdMarker"},
			LimitToken:      "MaxUploads",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListMultipartUploadsInput{}
	}

	output = &ListMultipartUploadsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMultipartUploads API operation for Amazon Simple Storage Service.
//
// This action lists in-progress multipart uploads. An in-progress multipart
// upload is a multipart upload that has been initiated using the Initiate Multipart
// Upload request, but has not yet been completed or aborted.
//
// This action returns at most 1,000 multipart uploads in the response. 1,000
// multipart uploads is the maximum number of uploads a response can include,
// which is also the default value. You can further limit the number of uploads
// in a response by specifying the max-uploads parameter in the response. If
// additional multipart uploads satisfy the list criteria, the response will
// contain an IsTruncated element with the value true. To list the additional
// multipart uploads, use the key-marker and upload-id-marker request parameters.
//
// In the response, the uploads are sorted by key. If your application has initiated
// more than one multipart upload using the same object key, then uploads in
// the response are first sorted by key. Additionally, uploads are sorted in
// ascending order within each key by the upload initiation time.
//
// For more information on multipart uploads, see Uploading Objects Using Multipart
// Upload (https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html).
//
// For information on permissions required to use the multipart upload API,
// see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// The following operations are related to ListMultipartUploads:
//
//   - CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//   - UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//   - CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//   - ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//   - AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListMultipartUploads for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploads
func (c *S3) ListMultipartUploads(input *ListMultipartUploadsInput) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	return out, req.Send()
}

// ListMultipartUploadsWithContext is the same as ListMultipartUploads with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultipartUploads for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListMultipartUploadsWithContext(ctx aws.Context, input *ListMultipartUploadsInput, opts ...request.Option) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultipartUploadsPages iterates over the pages of a ListMultipartUploads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultipartUploads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMultipartUploads operation.
//	pageNum := 0
//	err := client.ListMultipartUploadsPages(params,
//	    func(page *s3.ListMultipartUploadsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3) ListMultipartUploadsPages(input *ListMultipartUploadsInput, fn func(*ListMultipartUploadsOutput, bool) bool) error {
	return c.ListMultipartUploadsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultipartUploadsPagesWithContext same as ListMultipartUploadsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListMultipartUploadsPagesWithContext(ctx aws.Context, input *ListMultipartUploadsInput, fn func(*ListMultipartUploadsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultipartUploadsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultipartUploadsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMultipartUploadsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListObjectVersions = "ListObjectVersions"

// ListObjectVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectVersions for more information on using the ListObjectVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListObjectVersionsRequest method.
//	req, resp := client.ListObjectVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersions
func (c *S3) ListObjectVersionsRequest(input *ListObjectVersionsInput) (req *request.Request, output *ListObjectVersionsOutput) {
	op := &request.Operation{
		Name:       opListObjectVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "VersionIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextVersionIdMarker"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectVersionsInput{}
	}

	output = &ListObjectVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectVersions API operation for Amazon Simple Storage Service.
//
// Returns metadata about all versions of the objects in a bucket. You can also
// use request parameters as selection criteria to return metadata about a subset
// of all the object versions.
//
// To use this operation, you must have permissions to perform the s3:ListBucketVersions
// action. Be aware of the name difference.
//
// A 200 OK response can contain valid or invalid XML. Make sure to design your
// application to parse the contents of the response and handle it appropriately.
//
// To use this operation, you must have READ access to the bucket.
//
// This action is not supported by Amazon S3 on Outposts.
//
// The following operations are related to ListObjectVersions:
//
//   - ListObjectsV2 (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html)
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//   - DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjectVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersions
func (c *S3) ListObjectVersions(input *ListObjectVersionsInput) (*ListObjectVersionsOutput, error) {
	req, out := c.ListObjectVersionsRequest(input)
	return out, req.Send()
}

// ListObjectVersionsWithContext is the same as ListObjectVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectVersionsWithContext(ctx aws.Context, input *ListObjectVersionsInput, opts ...request.Option) (*ListObjectVersionsOutput, error) {
	req, out := c.ListObjectVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectVersionsPages iterates over the pages of a ListObjectVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListObjectVersions operation.
//	pageNum := 0
//	err := client.ListObjectVersionsPages(params,
//	    func(page *s3.ListObjectVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3) ListObjectVersionsPages(input *ListObjectVersionsInput, fn func(*ListObjectVersionsOutput, bool) bool) error {
	return c.ListObjectVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectVersionsPagesWithContext same as ListObjectVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectVersionsPagesWithContext(ctx aws.Context, input *ListObjectVersionsInput, fn func(*ListObjectVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListObjectVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListObjects = "ListObjects"

// ListObjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjects for more information on using the ListObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListObjectsRequest method.
//	req, resp := client.ListObjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjects
func (c *S3) ListObjectsRequest(input *ListObjectsInput) (req *request.Request, output *ListObjectsOutput) {
	op := &request.Operation{
		Name:       opListObjects,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker || Contents[-1].Key"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectsInput{}
	}

	output = &ListObjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjects API operation for Amazon Simple Storage Service.
//
// Returns some or all (up to 1,000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket. A 200 OK response can contain valid or invalid XML. Be sure
// to design your application to parse the contents of the response and handle
// it appropriately.
//
// This action has been revised. We recommend that you use the newer version,
// ListObjectsV2 (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html),
// when developing applications. For backward compatibility, Amazon S3 continues
// to support ListObjects.
//
// The following operations are related to ListObjects:
//
//   - ListObjectsV2 (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html)
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//   - ListBuckets (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjects for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeNoSuchBucket "NoSuchBucket"
//     The specified bucket does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjects
func (c *S3) ListObjects(input *ListObjectsInput) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	return out, req.Send()
}

// ListObjectsWithContext is the same as ListObjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsWithContext(ctx aws.Context, input *ListObjectsInput, opts ...request.Option) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectsPages iterates over the pages of a ListObjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListObjects operation.
//	pageNum := 0
//	err := client.ListObjectsPages(params,
//	    func(page *s3.ListObjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3) ListObjectsPages(input *ListObjectsInput, fn func(*ListObjectsOutput, bool) bool) error {
	return c.ListObjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectsPagesWithContext same as ListObjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsPagesWithContext(ctx aws.Context, input *ListObjectsInput, fn func(*ListObjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListObjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListObjectsV2 = "ListObjectsV2"

// ListObjectsV2Request generates a "aws/request.Request" representing the
// client's request for the ListObjectsV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectsV2 for more information on using the ListObjectsV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListObjectsV2Request method.
//	req, resp := client.ListObjectsV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2
func (c *S3) ListObjectsV2Request(input *ListObjectsV2Input) (req *request.Request, output *ListObjectsV2Output) {
	op := &request.Operation{
		Name:       opListObjectsV2,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?list-type=2",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ContinuationToken"},
			OutputTokens:    []string{"NextContinuationToken"},
			LimitToken:      "MaxKeys",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectsV2Input{}
	}

	output = &ListObjectsV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectsV2 API operation for Amazon Simple Storage Service.
//
// Returns some or all (up to 1,000) of the objects in a bucket with each request.
// You can use the request parameters as selection criteria to return a subset
// of the objects in a bucket. A 200 OK response can contain valid or invalid
// XML. Make sure to design your application to parse the contents of the response
// and handle it appropriately. Objects are returned sorted in an ascending
// order of the respective key names in the list. For more information about
// listing objects, see Listing object keys programmatically (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ListingKeysUsingAPIs.html)
//
// To use this operation, you must have READ access to the bucket.
//
// To use this action in an Identity and Access Management (IAM) policy, you
// must have permissions to perform the s3:ListBucket action. The bucket owner
// has this permission by default and can grant this permission to others. For
// more information about permissions, see Permissions Related to Bucket Subresource
// Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// This section describes the latest revision of this action. We recommend that
// you use this revised API for application development. For backward compatibility,
// Amazon S3 continues to support the prior version of this API, ListObjects
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html).
//
// To get a list of your buckets, see ListBuckets (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html).
//
// The following operations are related to ListObjectsV2:
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjectsV2 for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeNoSuchBucket "NoSuchBucket"
//     The specified bucket does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2
func (c *S3) ListObjectsV2(input *ListObjectsV2Input) (*ListObjectsV2Output, error) {
	req, out := c.ListObjectsV2Request(input)
	return out, req.Send()
}

// ListObjectsV2WithContext is the same as ListObjectsV2 with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectsV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsV2WithContext(ctx aws.Context, input *ListObjectsV2Input, opts ...request.Option) (*ListObjectsV2Output, error) {
	req, out := c.ListObjectsV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectsV2Pages iterates over the pages of a ListObjectsV2 operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectsV2 method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListObjectsV2 operation.
//	pageNum := 0
//	err := client.ListObjectsV2Pages(params,
//	    func(page *s3.ListObjectsV2Output, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3) ListObjectsV2Pages(input *ListObjectsV2Input, fn func(*ListObjectsV2Output, bool) bool) error {
	return c.ListObjectsV2PagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectsV2PagesWithContext same as ListObjectsV2Pages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsV2PagesWithContext(ctx aws.Context, input *ListObjectsV2Input, fn func(*ListObjectsV2Output, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectsV2Input
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectsV2Request(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListObjectsV2Output), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListParts = "ListParts"

// ListPartsRequest generates a "aws/request.Request" representing the
// client's request for the ListParts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParts for more information on using the ListParts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPartsRequest method.
//	req, resp := client.ListPartsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts
func (c *S3) ListPartsRequest(input *ListPartsInput) (req *request.Request, output *ListPartsOutput) {
	op := &request.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PartNumberMarker"},
			OutputTokens:    []string{"NextPartNumberMarker"},
			LimitToken:      "MaxParts",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	output = &ListPartsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParts API operation for Amazon Simple Storage Service.
//
// Lists the parts that have been uploaded for a specific multipart upload.
// This operation must include the upload ID, which you obtain by sending the
// initiate multipart upload request (see CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)).
// This request returns a maximum of 1,000 uploaded parts. The default number
// of parts returned is 1,000 parts. You can restrict the number of parts returned
// by specifying the max-parts request parameter. If your multipart upload consists
// of more than 1,000 parts, the response returns an IsTruncated field with
// the value of true, and a NextPartNumberMarker element. In subsequent ListParts
// requests you can include the part-number-marker query string parameter and
// set its value to the NextPartNumberMarker field value from the previous response.
//
// If the upload was created using a checksum algorithm, you will need to have
// permission to the kms:Decrypt action for the request to succeed.
//
// For more information on multipart uploads, see Uploading Objects Using Multipart
// Upload (https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html).
//
// For information on permissions required to use the multipart upload API,
// see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// The following operations are related to ListParts:
//
//   - CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//   - UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//   - CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//   - AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//   - GetObjectAttributes (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAttributes.html)
//
//   - ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListParts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts
func (c *S3) ListParts(input *ListPartsInput) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	return out, req.Send()
}

// ListPartsWithContext is the same as ListParts with the addition of
// the ability to pass a context and additional request options.
//
// See ListParts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListPartsWithContext(ctx aws.Context, input *ListPartsInput, opts ...request.Option) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPartsPages iterates over the pages of a ListParts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListParts operation.
//	pageNum := 0
//	err := client.ListPartsPages(params,
//	    func(page *s3.ListPartsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3) ListPartsPages(input *ListPartsInput, fn func(*ListPartsOutput, bool) bool) error {
	return c.ListPartsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPartsPagesWithContext same as ListPartsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListPartsPagesWithContext(ctx aws.Context, input *ListPartsInput, fn func(*ListPartsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPartsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPartsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPartsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutBucketAccelerateConfiguration = "PutBucketAccelerateConfiguration"

// PutBucketAccelerateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketAccelerateConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketAccelerateConfiguration for more information on using the PutBucketAccelerateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketAccelerateConfigurationRequest method.
//	req, resp := client.PutBucketAccelerateConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfiguration
func (c *S3) PutBucketAccelerateConfigurationRequest(input *PutBucketAccelerateConfigurationInput) (req *request.Request, output *PutBucketAccelerateConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketAccelerateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?accelerate",
	}

	if input == nil {
		input = &PutBucketAccelerateConfigurationInput{}
	}

	output = &PutBucketAccelerateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketAccelerateConfiguration API operation for Amazon Simple Storage Service.
//
// Sets the accelerate configuration of an existing bucket. Amazon S3 Transfer
// Acceleration is a bucket-level feature that enables you to perform faster
// data transfers to Amazon S3.
//
// To use this operation, you must have permission to perform the s3:PutAccelerateConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// The Transfer Acceleration state of a bucket can be set to one of the following
// two values:
//
//   - Enabled – Enables accelerated data transfers to the bucket.
//
//   - Suspended – Disables accelerated data transfers to the bucket.
//
// The GetBucketAccelerateConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html)
// action returns the transfer acceleration state of a bucket.
//
// After setting the Transfer Acceleration state of a bucket to Enabled, it
// might take up to thirty minutes before the data transfer rates to the bucket
// increase.
//
// The name of the bucket used for Transfer Acceleration must be DNS-compliant
// and must not contain periods (".").
//
// For more information about transfer acceleration, see Transfer Acceleration
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html).
//
// The following operations are related to PutBucketAccelerateConfiguration:
//
//   - GetBucketAccelerateConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html)
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketAccelerateConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfiguration
func (c *S3) PutBucketAccelerateConfiguration(input *PutBucketAccelerateConfigurationInput) (*PutBucketAccelerateConfigurationOutput, error) {
	req, out := c.PutBucketAccelerateConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketAccelerateConfigurationWithContext is the same as PutBucketAccelerateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketAccelerateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketAccelerateConfigurationWithContext(ctx aws.Context, input *PutBucketAccelerateConfigurationInput, opts ...request.Option) (*PutBucketAccelerateConfigurationOutput, error) {
	req, out := c.PutBucketAccelerateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketAcl = "PutBucketAcl"

// PutBucketAclRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketAcl for more information on using the PutBucketAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketAclRequest method.
//	req, resp := client.PutBucketAclRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAcl
func (c *S3) PutBucketAclRequest(input *PutBucketAclInput) (req *request.Request, output *PutBucketAclOutput) {
	op := &request.Operation{
		Name:       opPutBucketAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &PutBucketAclInput{}
	}

	output = &PutBucketAclOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketAcl API operation for Amazon Simple Storage Service.
//
// Sets the permissions on an existing bucket using access control lists (ACL).
// For more information, see Using ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html).
// To set the ACL of a bucket, you must have WRITE_ACP permission.
//
// You can use one of the following two ways to set a bucket's permissions:
//
//   - Specify the ACL in the request body
//
//   - Specify permissions using request headers
//
// You cannot specify access permission using both the body and the request
// headers.
//
// Depending on your application needs, you may choose to set the ACL on a bucket
// using either the request body or the headers. For example, if you have an
// existing application that updates a bucket ACL using the request body, then
// you can continue to use that approach.
//
// If your bucket uses the bucket owner enforced setting for S3 Object Ownership,
// ACLs are disabled and no longer affect permissions. You must use policies
// to grant access to your bucket and the objects in it. Requests to set ACLs
// or update ACLs fail and return the AccessControlListNotSupported error code.
// Requests to read ACLs are still supported. For more information, see Controlling
// object ownership (https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html)
// in the Amazon S3 User Guide.
//
// # Access Permissions
//
// You can set access permissions using one of the following methods:
//
//   - Specify a canned ACL with the x-amz-acl request header. Amazon S3 supports
//     a set of predefined ACLs, known as canned ACLs. Each canned ACL has a
//     predefined set of grantees and permissions. Specify the canned ACL name
//     as the value of x-amz-acl. If you use this header, you cannot use other
//     access control-specific headers in your request. For more information,
//     see Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//   - Specify access permissions explicitly with the x-amz-grant-read, x-amz-grant-read-acp,
//     x-amz-grant-write-acp, and x-amz-grant-full-control headers. When using
//     these headers, you specify explicit access permissions and grantees (Amazon
//     Web Services accounts or Amazon S3 groups) who will receive the permission.
//     If you use these ACL-specific headers, you cannot use the x-amz-acl header
//     to set a canned ACL. These parameters map to the set of permissions that
//     Amazon S3 supports in an ACL. For more information, see Access Control
//     List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html).
//     You specify each grantee as a type=value pair, where the type is one of
//     the following: id – if the value specified is the canonical user ID
//     of an Amazon Web Services account uri – if you are granting permissions
//     to a predefined group emailAddress – if the value specified is the email
//     address of an Amazon Web Services account Using email addresses to specify
//     a grantee is only supported in the following Amazon Web Services Regions:
//     US East (N. Virginia) US West (N. California) US West (Oregon) Asia Pacific
//     (Singapore) Asia Pacific (Sydney) Asia Pacific (Tokyo) Europe (Ireland)
//     South America (São Paulo) For a list of all the Amazon S3 supported Regions
//     and endpoints, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
//     in the Amazon Web Services General Reference. For example, the following
//     x-amz-grant-write header grants create, overwrite, and delete objects
//     permission to LogDelivery group predefined by Amazon S3 and two Amazon
//     Web Services accounts identified by their email addresses. x-amz-grant-write:
//     uri="http://acs.amazonaws.com/groups/s3/LogDelivery", id="111122223333",
//     id="555566667777"
//
// You can use either a canned ACL or specify access permissions explicitly.
// You cannot do both.
//
// # Grantee Values
//
// You can specify the person (grantee) to whom you're assigning access rights
// (using request elements) in the following ways:
//
//   - By the person's ID: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName>
//     </Grantee> DisplayName is optional and ignored in the request
//
//   - By URI: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>
//
//   - By Email address: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress>lt;/Grantee>
//     The grantee is resolved to the CanonicalUser and, in a response to a GET
//     Object acl request, appears as the CanonicalUser. Using email addresses
//     to specify a grantee is only supported in the following Amazon Web Services
//     Regions: US East (N. Virginia) US West (N. California) US West (Oregon)
//     Asia Pacific (Singapore) Asia Pacific (Sydney) Asia Pacific (Tokyo) Europe
//     (Ireland) South America (São Paulo) For a list of all the Amazon S3 supported
//     Regions and endpoints, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
//     in the Amazon Web Services General Reference.
//
// Related Resources
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//   - DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html)
//
//   - GetObjectAcl (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAcl
func (c *S3) PutBucketAcl(input *PutBucketAclInput) (*PutBucketAclOutput, error) {
	req, out := c.PutBucketAclRequest(input)
	return out, req.Send()
}

// PutBucketAclWithContext is the same as PutBucketAcl with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketAclWithContext(ctx aws.Context, input *PutBucketAclInput, opts ...request.Option) (*PutBucketAclOutput, error) {
	req, out := c.PutBucketAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketAnalyticsConfiguration = "PutBucketAnalyticsConfiguration"

// PutBucketAnalyticsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketAnalyticsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketAnalyticsConfiguration for more information on using the PutBucketAnalyticsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketAnalyticsConfigurationRequest method.
//	req, resp := client.PutBucketAnalyticsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfiguration
func (c *S3) PutBucketAnalyticsConfigurationRequest(input *PutBucketAnalyticsConfigurationInput) (req *request.Request, output *PutBucketAnalyticsConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketAnalyticsConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &PutBucketAnalyticsConfigurationInput{}
	}

	output = &PutBucketAnalyticsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketAnalyticsConfiguration API operation for Amazon Simple Storage Service.
//
// Sets an analytics configuration for the bucket (specified by the analytics
// configuration ID). You can have up to 1,000 analytics configurations per
// bucket.
//
// You can choose to have storage class analysis export analysis reports sent
// to a comma-separated values (CSV) flat file. See the DataExport request element.
// Reports are updated daily and are based on the object filters that you configure.
// When selecting data export, you specify a destination bucket and an optional
// destination prefix where the file is written. You can export the data to
// a destination bucket in a different account. However, the destination bucket
// must be in the same Region as the bucket that you are making the PUT analytics
// configuration to. For more information, see Amazon S3 Analytics – Storage
// Class Analysis (https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html).
//
// You must create a bucket policy on the destination bucket where the exported
// file is written to grant permissions to Amazon S3 to write objects to the
// bucket. For an example policy, see Granting Permissions for Amazon S3 Inventory
// and Storage Class Analysis (https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9).
//
// To use this operation, you must have permissions to perform the s3:PutAnalyticsConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// Special Errors
//
//   - HTTP Error: HTTP 400 Bad Request Code: InvalidArgument Cause: Invalid
//     argument.
//
//   - HTTP Error: HTTP 400 Bad Request Code: TooManyConfigurations Cause:
//     You are attempting to create a new configuration but have already reached
//     the 1,000-configuration limit.
//
//   - HTTP Error: HTTP 403 Forbidden Code: AccessDenied Cause: You are not
//     the owner of the specified bucket, or you do not have the s3:PutAnalyticsConfiguration
//     bucket permission to set the configuration on the bucket.
//
// Related Resources
//
//   - GetBucketAnalyticsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html)
//
//   - DeleteBucketAnalyticsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html)
//
//   - ListBucketAnalyticsConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketAnalyticsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfiguration
func (c *S3) PutBucketAnalyticsConfiguration(input *PutBucketAnalyticsConfigurationInput) (*PutBucketAnalyticsConfigurationOutput, error) {
	req, out := c.PutBucketAnalyticsConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketAnalyticsConfigurationWithContext is the same as PutBucketAnalyticsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketAnalyticsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketAnalyticsConfigurationWithContext(ctx aws.Context, input *PutBucketAnalyticsConfigurationInput, opts ...request.Option) (*PutBucketAnalyticsConfigurationOutput, error) {
	req, out := c.PutBucketAnalyticsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketCors = "PutBucketCors"

// PutBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketCors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketCors for more information on using the PutBucketCors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketCorsRequest method.
//	req, resp := client.PutBucketCorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCors
func (c *S3) PutBucketCorsRequest(input *PutBucketCorsInput) (req *request.Request, output *PutBucketCorsOutput) {
	op := &request.Operation{
		Name:       opPutBucketCors,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &PutBucketCorsInput{}
	}

	output = &PutBucketCorsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketCors API operation for Amazon Simple Storage Service.
//
// Sets the cors configuration for your bucket. If the configuration exists,
// Amazon S3 replaces it.
//
// To use this operation, you must be allowed to perform the s3:PutBucketCORS
// action. By default, the bucket owner has this permission and can grant it
// to others.
//
// You set this configuration on a bucket so that the bucket can service cross-origin
// requests. For example, you might want to enable a request whose origin is
// http://www.example.com to access your Amazon S3 bucket at my.example.bucket.com
// by using the browser's XMLHttpRequest capability.
//
// To enable cross-origin resource sharing (CORS) on a bucket, you add the cors
// subresource to the bucket. The cors subresource is an XML document in which
// you configure rules that identify origins and the HTTP methods that can be
// executed on your bucket. The document is limited to 64 KB in size.
//
// When Amazon S3 receives a cross-origin request (or a pre-flight OPTIONS request)
// against a bucket, it evaluates the cors configuration on the bucket and uses
// the first CORSRule rule that matches the incoming browser request to enable
// a cross-origin request. For a rule to match, the following conditions must
// be met:
//
//   - The request's Origin header must match AllowedOrigin elements.
//
//   - The request method (for example, GET, PUT, HEAD, and so on) or the Access-Control-Request-Method
//     header in case of a pre-flight OPTIONS request must be one of the AllowedMethod
//     elements.
//
//   - Every header specified in the Access-Control-Request-Headers request
//     header of a pre-flight request must match an AllowedHeader element.
//
// For more information about CORS, go to Enabling Cross-Origin Resource Sharing
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the Amazon
// S3 User Guide.
//
// Related Resources
//
//   - GetBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html)
//
//   - DeleteBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html)
//
//   - RESTOPTIONSobject (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketCors for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCors
func (c *S3) PutBucketCors(input *PutBucketCorsInput) (*PutBucketCorsOutput, error) {
	req, out := c.PutBucketCorsRequest(input)
	return out, req.Send()
}

// PutBucketCorsWithContext is the same as PutBucketCors with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketCors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketCorsWithContext(ctx aws.Context, input *PutBucketCorsInput, opts ...request.Option) (*PutBucketCorsOutput, error) {
	req, out := c.PutBucketCorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketEncryption = "PutBucketEncryption"

// PutBucketEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketEncryption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketEncryption for more information on using the PutBucketEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketEncryptionRequest method.
//	req, resp := client.PutBucketEncryptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryption
func (c *S3) PutBucketEncryptionRequest(input *PutBucketEncryptionInput) (req *request.Request, output *PutBucketEncryptionOutput) {
	op := &request.Operation{
		Name:       opPutBucketEncryption,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?encryption",
	}

	if input == nil {
		input = &PutBucketEncryptionInput{}
	}

	output = &PutBucketEncryptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketEncryption API operation for Amazon Simple Storage Service.
//
// This action uses the encryption subresource to configure default encryption
// and Amazon S3 Bucket Key for an existing bucket.
//
// Default encryption for a bucket can use server-side encryption with Amazon
// S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). If you specify
// default encryption using SSE-KMS, you can also configure Amazon S3 Bucket
// Key. When the default encryption is SSE-KMS, if you upload an object to the
// bucket and do not specify the KMS key to use for encryption, Amazon S3 uses
// the default Amazon Web Services managed KMS key for your account. For information
// about default encryption, see Amazon S3 default bucket encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html)
// in the Amazon S3 User Guide. For more information about S3 Bucket Keys, see
// Amazon S3 Bucket Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html)
// in the Amazon S3 User Guide.
//
// This action requires Amazon Web Services Signature Version 4. For more information,
// see Authenticating Requests (Amazon Web Services Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html).
//
// To use this operation, you must have permissions to perform the s3:PutEncryptionConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html)
// in the Amazon S3 User Guide.
//
// Related Resources
//
//   - GetBucketEncryption (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html)
//
//   - DeleteBucketEncryption (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketEncryption for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryption
func (c *S3) PutBucketEncryption(input *PutBucketEncryptionInput) (*PutBucketEncryptionOutput, error) {
	req, out := c.PutBucketEncryptionRequest(input)
	return out, req.Send()
}

// PutBucketEncryptionWithContext is the same as PutBucketEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketEncryptionWithContext(ctx aws.Context, input *PutBucketEncryptionInput, opts ...request.Option) (*PutBucketEncryptionOutput, error) {
	req, out := c.PutBucketEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketIntelligentTieringConfiguration = "PutBucketIntelligentTieringConfiguration"

// PutBucketIntelligentTieringConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketIntelligentTieringConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketIntelligentTieringConfiguration for more information on using the PutBucketIntelligentTieringConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketIntelligentTieringConfigurationRequest method.
//	req, resp := client.PutBucketIntelligentTieringConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketIntelligentTieringConfiguration
func (c *S3) PutBucketIntelligentTieringConfigurationRequest(input *PutBucketIntelligentTieringConfigurationInput) (req *request.Request, output *PutBucketIntelligentTieringConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketIntelligentTieringConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?intelligent-tiering",
	}

	if input == nil {
		input = &PutBucketIntelligentTieringConfigurationInput{}
	}

	output = &PutBucketIntelligentTieringConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketIntelligentTieringConfiguration API operation for Amazon Simple Storage Service.
//
// Puts a S3 Intelligent-Tiering configuration to the specified bucket. You
// can have up to 1,000 S3 Intelligent-Tiering configurations per bucket.
//
// The S3 Intelligent-Tiering storage class is designed to optimize storage
// costs by automatically moving data to the most cost-effective storage access
// tier, without performance impact or operational overhead. S3 Intelligent-Tiering
// delivers automatic cost savings in three low latency and high throughput
// access tiers. To get the lowest storage cost on data that can be accessed
// in minutes to hours, you can choose to activate additional archiving capabilities.
//
// The S3 Intelligent-Tiering storage class is the ideal storage class for data
// with unknown, changing, or unpredictable access patterns, independent of
// object size or retention period. If the size of an object is less than 128
// KB, it is not monitored and not eligible for auto-tiering. Smaller objects
// can be stored, but they are always charged at the Frequent Access tier rates
// in the S3 Intelligent-Tiering storage class.
//
// For more information, see Storage class for automatically optimizing frequently
// and infrequently accessed objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access).
//
// Operations related to PutBucketIntelligentTieringConfiguration include:
//
//   - DeleteBucketIntelligentTieringConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html)
//
//   - GetBucketIntelligentTieringConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html)
//
//   - ListBucketIntelligentTieringConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html)
//
// You only need S3 Intelligent-Tiering enabled on a bucket if you want to automatically
// move objects stored in the S3 Intelligent-Tiering storage class to the Archive
// Access or Deep Archive Access tier.
//
// Special Errors
//
//   - HTTP 400 Bad Request Error Code: InvalidArgument Cause: Invalid Argument
//
//   - HTTP 400 Bad Request Error Code: TooManyConfigurations Cause: You are
//     attempting to create a new configuration but have already reached the
//     1,000-configuration limit.
//
//   - HTTP 403 Forbidden Error Code: AccessDenied Cause: You are not the owner
//     of the specified bucket, or you do not have the s3:PutIntelligentTieringConfiguration
//     bucket permission to set the configuration on the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketIntelligentTieringConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketIntelligentTieringConfiguration
func (c *S3) PutBucketIntelligentTieringConfiguration(input *PutBucketIntelligentTieringConfigurationInput) (*PutBucketIntelligentTieringConfigurationOutput, error) {
	req, out := c.PutBucketIntelligentTieringConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketIntelligentTieringConfigurationWithContext is the same as PutBucketIntelligentTieringConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketIntelligentTieringConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketIntelligentTieringConfigurationWithContext(ctx aws.Context, input *PutBucketIntelligentTieringConfigurationInput, opts ...request.Option) (*PutBucketIntelligentTieringConfigurationOutput, error) {
	req, out := c.PutBucketIntelligentTieringConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketInventoryConfiguration = "PutBucketInventoryConfiguration"

// PutBucketInventoryConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketInventoryConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketInventoryConfiguration for more information on using the PutBucketInventoryConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketInventoryConfigurationRequest method.
//	req, resp := client.PutBucketInventoryConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfiguration
func (c *S3) PutBucketInventoryConfigurationRequest(input *PutBucketInventoryConfigurationInput) (req *request.Request, output *PutBucketInventoryConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketInventoryConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &PutBucketInventoryConfigurationInput{}
	}

	output = &PutBucketInventoryConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketInventoryConfiguration API operation for Amazon Simple Storage Service.
//
// This implementation of the PUT action adds an inventory configuration (identified
// by the inventory ID) to the bucket. You can have up to 1,000 inventory configurations
// per bucket.
//
// Amazon S3 inventory generates inventories of the objects in the bucket on
// a daily or weekly basis, and the results are published to a flat file. The
// bucket that is inventoried is called the source bucket, and the bucket where
// the inventory flat file is stored is called the destination bucket. The destination
// bucket must be in the same Amazon Web Services Region as the source bucket.
//
// When you configure an inventory for a source bucket, you specify the destination
// bucket where you want the inventory to be stored, and whether to generate
// the inventory daily or weekly. You can also configure what object metadata
// to include and whether to inventory all object versions or only current versions.
// For more information, see Amazon S3 Inventory (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html)
// in the Amazon S3 User Guide.
//
// You must create a bucket policy on the destination bucket to grant permissions
// to Amazon S3 to write objects to the bucket in the defined location. For
// an example policy, see Granting Permissions for Amazon S3 Inventory and Storage
// Class Analysis (https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9).
//
// To use this operation, you must have permissions to perform the s3:PutInventoryConfiguration
// action. The bucket owner has this permission by default and can grant this
// permission to others. For more information about permissions, see Permissions
// Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html)
// in the Amazon S3 User Guide.
//
// Special Errors
//
//   - HTTP 400 Bad Request Error Code: InvalidArgument Cause: Invalid Argument
//
//   - HTTP 400 Bad Request Error Code: TooManyConfigurations Cause: You are
//     attempting to create a new configuration but have already reached the
//     1,000-configuration limit.
//
//   - HTTP 403 Forbidden Error Code: AccessDenied Cause: You are not the owner
//     of the specified bucket, or you do not have the s3:PutInventoryConfiguration
//     bucket permission to set the configuration on the bucket.
//
// Related Resources
//
//   - GetBucketInventoryConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html)
//
//   - DeleteBucketInventoryConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html)
//
//   - ListBucketInventoryConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketInventoryConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfiguration
func (c *S3) PutBucketInventoryConfiguration(input *PutBucketInventoryConfigurationInput) (*PutBucketInventoryConfigurationOutput, error) {
	req, out := c.PutBucketInventoryConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketInventoryConfigurationWithContext is the same as PutBucketInventoryConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketInventoryConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketInventoryConfigurationWithContext(ctx aws.Context, input *PutBucketInventoryConfigurationInput, opts ...request.Option) (*PutBucketInventoryConfigurationOutput, error) {
	req, out := c.PutBucketInventoryConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLifecycle = "PutBucketLifecycle"

// PutBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLifecycle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLifecycle for more information on using the PutBucketLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketLifecycleRequest method.
//	req, resp := client.PutBucketLifecycleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycle
//
// Deprecated: PutBucketLifecycle has been deprecated
func (c *S3) PutBucketLifecycleRequest(input *PutBucketLifecycleInput) (req *request.Request, output *PutBucketLifecycleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutBucketLifecycle, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutBucketLifecycle,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleInput{}
	}

	output = &PutBucketLifecycleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketLifecycle API operation for Amazon Simple Storage Service.
//
// For an updated version of this API, see PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html).
// This version has been deprecated. Existing lifecycle configurations will
// work. For new lifecycle configurations, use the updated API.
//
// Creates a new lifecycle configuration for the bucket or replaces an existing
// lifecycle configuration. For information about lifecycle configuration, see
// Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// in the Amazon S3 User Guide.
//
// By default, all Amazon S3 resources, including buckets, objects, and related
// subresources (for example, lifecycle configuration and website configuration)
// are private. Only the resource owner, the Amazon Web Services account that
// created the resource, can access it. The resource owner can optionally grant
// access permissions to others by writing an access policy. For this operation,
// users must get the s3:PutLifecycleConfiguration permission.
//
// You can also explicitly deny permissions. Explicit denial also supersedes
// any other permissions. If you want to prevent users or accounts from removing
// or deleting objects from your bucket, you must deny them permissions for
// the following actions:
//
//   - s3:DeleteObject
//
//   - s3:DeleteObjectVersion
//
//   - s3:PutLifecycleConfiguration
//
// For more information about permissions, see Managing Access Permissions to
// your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html)
// in the Amazon S3 User Guide.
//
// For more examples of transitioning objects to storage classes such as STANDARD_IA
// or ONEZONE_IA, see Examples of Lifecycle Configuration (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#lifecycle-configuration-examples).
//
// Related Resources
//
//   - GetBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html)(Deprecated)
//
//   - GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html)
//
//   - RestoreObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html)
//
//   - By default, a resource owner—in this case, a bucket owner, which is
//     the Amazon Web Services account that created the bucket—can perform
//     any of the operations. A resource owner can also grant others permission
//     to perform the operation. For more information, see the following topics
//     in the Amazon S3 User Guide: Specifying Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html)
//     Managing Access Permissions to your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLifecycle for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycle
//
// Deprecated: PutBucketLifecycle has been deprecated
func (c *S3) PutBucketLifecycle(input *PutBucketLifecycleInput) (*PutBucketLifecycleOutput, error) {
	req, out := c.PutBucketLifecycleRequest(input)
	return out, req.Send()
}

// PutBucketLifecycleWithContext is the same as PutBucketLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: PutBucketLifecycleWithContext has been deprecated
func (c *S3) PutBucketLifecycleWithContext(ctx aws.Context, input *PutBucketLifecycleInput, opts ...request.Option) (*PutBucketLifecycleOutput, error) {
	req, out := c.PutBucketLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLifecycleConfiguration = "PutBucketLifecycleConfiguration"

// PutBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLifecycleConfiguration for more information on using the PutBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketLifecycleConfigurationRequest method.
//	req, resp := client.PutBucketLifecycleConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfiguration
func (c *S3) PutBucketLifecycleConfigurationRequest(input *PutBucketLifecycleConfigurationInput) (req *request.Request, output *PutBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleConfigurationInput{}
	}

	output = &PutBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketLifecycleConfiguration API operation for Amazon Simple Storage Service.
//
// Creates a new lifecycle configuration for the bucket or replaces an existing
// lifecycle configuration. Keep in mind that this will overwrite an existing
// lifecycle configuration, so if you want to retain any configuration details,
// they must be included in the new lifecycle configuration. For information
// about lifecycle configuration, see Managing your storage lifecycle (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html).
//
// Bucket lifecycle configuration now supports specifying a lifecycle rule using
// an object key name prefix, one or more object tags, or a combination of both.
// Accordingly, this section describes the latest API. The previous version
// of the API supported filtering based only on an object key name prefix, which
// is supported for backward compatibility. For the related API description,
// see PutBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html).
//
// # Rules
//
// You specify the lifecycle configuration in your request body. The lifecycle
// configuration is specified as XML consisting of one or more rules. An Amazon
// S3 Lifecycle configuration can have up to 1,000 rules. This limit is not
// adjustable. Each rule consists of the following:
//
//   - Filter identifying a subset of objects to which the rule applies. The
//     filter can be based on a key name prefix, object tags, or a combination
//     of both.
//
//   - Status whether the rule is in effect.
//
//   - One or more lifecycle transition and expiration actions that you want
//     Amazon S3 to perform on the objects identified by the filter. If the state
//     of your bucket is versioning-enabled or versioning-suspended, you can
//     have many versions of the same object (one current version and zero or
//     more noncurrent versions). Amazon S3 provides predefined actions that
//     you can specify for current and noncurrent object versions.
//
// For more information, see Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// and Lifecycle Configuration Elements (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html).
//
// # Permissions
//
// By default, all Amazon S3 resources are private, including buckets, objects,
// and related subresources (for example, lifecycle configuration and website
// configuration). Only the resource owner (that is, the Amazon Web Services
// account that created it) can access the resource. The resource owner can
// optionally grant access permissions to others by writing an access policy.
// For this operation, a user must get the s3:PutLifecycleConfiguration permission.
//
// You can also explicitly deny permissions. Explicit deny also supersedes any
// other permissions. If you want to block users or accounts from removing or
// deleting objects from your bucket, you must deny them permissions for the
// following actions:
//
//   - s3:DeleteObject
//
//   - s3:DeleteObjectVersion
//
//   - s3:PutLifecycleConfiguration
//
// For more information about permissions, see Managing Access Permissions to
// Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// The following are related to PutBucketLifecycleConfiguration:
//
//   - Examples of Lifecycle Configuration (https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-configuration-examples.html)
//
//   - GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html)
//
//   - DeleteBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfiguration
func (c *S3) PutBucketLifecycleConfiguration(input *PutBucketLifecycleConfigurationInput) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketLifecycleConfigurationWithContext is the same as PutBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketLifecycleConfigurationWithContext(ctx aws.Context, input *PutBucketLifecycleConfigurationInput, opts ...request.Option) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLogging = "PutBucketLogging"

// PutBucketLoggingRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLogging for more information on using the PutBucketLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketLoggingRequest method.
//	req, resp := client.PutBucketLoggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLogging
func (c *S3) PutBucketLoggingRequest(input *PutBucketLoggingInput) (req *request.Request, output *PutBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketLogging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &PutBucketLoggingInput{}
	}

	output = &PutBucketLoggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketLogging API operation for Amazon Simple Storage Service.
//
// Set the logging parameters for a bucket and to specify permissions for who
// can view and modify the logging parameters. All logs are saved to buckets
// in the same Amazon Web Services Region as the source bucket. To set the logging
// status of a bucket, you must be the bucket owner.
//
// The bucket owner is automatically granted FULL_CONTROL to all logs. You use
// the Grantee request element to grant access to other people. The Permissions
// request element specifies the kind of access the grantee has to the logs.
//
// If the target bucket for log delivery uses the bucket owner enforced setting
// for S3 Object Ownership, you can't use the Grantee request element to grant
// access to others. Permissions can only be granted using policies. For more
// information, see Permissions for server access log delivery (https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general)
// in the Amazon S3 User Guide.
//
// # Grantee Values
//
// You can specify the person (grantee) to whom you're assigning access rights
// (using request elements) in the following ways:
//
//   - By the person's ID: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName>
//     </Grantee> DisplayName is optional and ignored in the request.
//
//   - By Email address: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress></Grantee>
//     The grantee is resolved to the CanonicalUser and, in a response to a GET
//     Object acl request, appears as the CanonicalUser.
//
//   - By URI: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>
//
// To enable logging, you use LoggingEnabled and its children request elements.
// To disable logging, you use an empty BucketLoggingStatus request element:
//
// <BucketLoggingStatus xmlns="http://doc.s3.amazonaws.com/2006-03-01" />
//
// For more information about server access logging, see Server Access Logging
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerLogs.html) in
// the Amazon S3 User Guide.
//
// For more information about creating a bucket, see CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html).
// For more information about returning the logging status of a bucket, see
// GetBucketLogging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html).
//
// The following operations are related to PutBucketLogging:
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//   - DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html)
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//   - GetBucketLogging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLogging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLogging
func (c *S3) PutBucketLogging(input *PutBucketLoggingInput) (*PutBucketLoggingOutput, error) {
	req, out := c.PutBucketLoggingRequest(input)
	return out, req.Send()
}

// PutBucketLoggingWithContext is the same as PutBucketLogging with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketLoggingWithContext(ctx aws.Context, input *PutBucketLoggingInput, opts ...request.Option) (*PutBucketLoggingOutput, error) {
	req, out := c.PutBucketLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketMetricsConfiguration = "PutBucketMetricsConfiguration"

// PutBucketMetricsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketMetricsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketMetricsConfiguration for more information on using the PutBucketMetricsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketMetricsConfigurationRequest method.
//	req, resp := client.PutBucketMetricsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfiguration
func (c *S3) PutBucketMetricsConfigurationRequest(input *PutBucketMetricsConfigurationInput) (req *request.Request, output *PutBucketMetricsConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketMetricsConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &PutBucketMetricsConfigurationInput{}
	}

	output = &PutBucketMetricsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketMetricsConfiguration API operation for Amazon Simple Storage Service.
//
// Sets a metrics configuration (specified by the metrics configuration ID)
// for the bucket. You can have up to 1,000 metrics configurations per bucket.
// If you're updating an existing metrics configuration, note that this is a
// full replacement of the existing metrics configuration. If you don't include
// the elements you want to keep, they are erased.
//
// To use this operation, you must have permissions to perform the s3:PutMetricsConfiguration
// action. The bucket owner has this permission by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// For information about CloudWatch request metrics for Amazon S3, see Monitoring
// Metrics with Amazon CloudWatch (https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html).
//
// The following operations are related to PutBucketMetricsConfiguration:
//
//   - DeleteBucketMetricsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html)
//
//   - GetBucketMetricsConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html)
//
//   - ListBucketMetricsConfigurations (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html)
//
// GetBucketLifecycle has the following special error:
//
//   - Error code: TooManyConfigurations Description: You are attempting to
//     create a new configuration but have already reached the 1,000-configuration
//     limit. HTTP Status Code: HTTP 400 Bad Request
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketMetricsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfiguration
func (c *S3) PutBucketMetricsConfiguration(input *PutBucketMetricsConfigurationInput) (*PutBucketMetricsConfigurationOutput, error) {
	req, out := c.PutBucketMetricsConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketMetricsConfigurationWithContext is the same as PutBucketMetricsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketMetricsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketMetricsConfigurationWithContext(ctx aws.Context, input *PutBucketMetricsConfigurationInput, opts ...request.Option) (*PutBucketMetricsConfigurationOutput, error) {
	req, out := c.PutBucketMetricsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketNotification = "PutBucketNotification"

// PutBucketNotificationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketNotification for more information on using the PutBucketNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketNotificationRequest method.
//	req, resp := client.PutBucketNotificationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotification
//
// Deprecated: PutBucketNotification has been deprecated
func (c *S3) PutBucketNotificationRequest(input *PutBucketNotificationInput) (req *request.Request, output *PutBucketNotificationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutBucketNotification, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutBucketNotification,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationInput{}
	}

	output = &PutBucketNotificationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketNotification API operation for Amazon Simple Storage Service.
//
// No longer used, see the PutBucketNotificationConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketNotificationConfiguration.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketNotification for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotification
//
// Deprecated: PutBucketNotification has been deprecated
func (c *S3) PutBucketNotification(input *PutBucketNotificationInput) (*PutBucketNotificationOutput, error) {
	req, out := c.PutBucketNotificationRequest(input)
	return out, req.Send()
}

// PutBucketNotificationWithContext is the same as PutBucketNotification with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: PutBucketNotificationWithContext has been deprecated
func (c *S3) PutBucketNotificationWithContext(ctx aws.Context, input *PutBucketNotificationInput, opts ...request.Option) (*PutBucketNotificationOutput, error) {
	req, out := c.PutBucketNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketNotificationConfiguration = "PutBucketNotificationConfiguration"

// PutBucketNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketNotificationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketNotificationConfiguration for more information on using the PutBucketNotificationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketNotificationConfigurationRequest method.
//	req, resp := client.PutBucketNotificationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfiguration
func (c *S3) PutBucketNotificationConfigurationRequest(input *PutBucketNotificationConfigurationInput) (req *request.Request, output *PutBucketNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketNotificationConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationConfigurationInput{}
	}

	output = &PutBucketNotificationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketNotificationConfiguration API operation for Amazon Simple Storage Service.
//
// Enables notifications of specified events for a bucket. For more information
// about event notifications, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html).
//
// Using this API, you can replace an existing notification configuration. The
// configuration is an XML file that defines the event types that you want Amazon
// S3 to publish and the destination where you want Amazon S3 to publish an
// event notification when it detects an event of the specified type.
//
// By default, your bucket has no event notifications configured. That is, the
// notification configuration will be an empty NotificationConfiguration.
//
// <NotificationConfiguration>
//
// </NotificationConfiguration>
//
// This action replaces the existing notification configuration with the configuration
// you include in the request body.
//
// After Amazon S3 receives this request, it first verifies that any Amazon
// Simple Notification Service (Amazon SNS) or Amazon Simple Queue Service (Amazon
// SQS) destination exists, and that the bucket owner has permission to publish
// to it by sending a test notification. In the case of Lambda destinations,
// Amazon S3 verifies that the Lambda function permissions grant Amazon S3 permission
// to invoke the function from the Amazon S3 bucket. For more information, see
// Configuring Notifications for Amazon S3 Events (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html).
//
// You can disable notifications by adding the empty NotificationConfiguration
// element.
//
// For more information about the number of event notification configurations
// that you can create per bucket, see Amazon S3 service quotas (https://docs.aws.amazon.com/general/latest/gr/s3.html#limits_s3)
// in Amazon Web Services General Reference.
//
// By default, only the bucket owner can configure notifications on a bucket.
// However, bucket owners can use a bucket policy to grant permission to other
// users to set this configuration with s3:PutBucketNotification permission.
//
// The PUT notification is an atomic operation. For example, suppose your notification
// configuration includes SNS topic, SQS queue, and Lambda function configurations.
// When you send a PUT request with this configuration, Amazon S3 sends test
// messages to your SNS topic. If the message fails, the entire PUT action will
// fail, and Amazon S3 will not add the configuration to your bucket.
//
// # Responses
//
// If the configuration in the request body includes only one TopicConfiguration
// specifying only the s3:ReducedRedundancyLostObject event type, the response
// will also include the x-amz-sns-test-message-id header containing the message
// ID of the test notification sent to the topic.
//
// The following action is related to PutBucketNotificationConfiguration:
//
//   - GetBucketNotificationConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketNotificationConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfiguration
func (c *S3) PutBucketNotificationConfiguration(input *PutBucketNotificationConfigurationInput) (*PutBucketNotificationConfigurationOutput, error) {
	req, out := c.PutBucketNotificationConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketNotificationConfigurationWithContext is the same as PutBucketNotificationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketNotificationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketNotificationConfigurationWithContext(ctx aws.Context, input *PutBucketNotificationConfigurationInput, opts ...request.Option) (*PutBucketNotificationConfigurationOutput, error) {
	req, out := c.PutBucketNotificationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketOwnershipControls = "PutBucketOwnershipControls"

// PutBucketOwnershipControlsRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketOwnershipControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketOwnershipControls for more information on using the PutBucketOwnershipControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketOwnershipControlsRequest method.
//	req, resp := client.PutBucketOwnershipControlsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketOwnershipControls
func (c *S3) PutBucketOwnershipControlsRequest(input *PutBucketOwnershipControlsInput) (req *request.Request, output *PutBucketOwnershipControlsOutput) {
	op := &request.Operation{
		Name:       opPutBucketOwnershipControls,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?ownershipControls",
	}

	if input == nil {
		input = &PutBucketOwnershipControlsInput{}
	}

	output = &PutBucketOwnershipControlsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketOwnershipControls API operation for Amazon Simple Storage Service.
//
// Creates or modifies OwnershipControls for an Amazon S3 bucket. To use this
// operation, you must have the s3:PutBucketOwnershipControls permission. For
// more information about Amazon S3 permissions, see Specifying permissions
// in a policy (https://docs.aws.amazon.com/AmazonS3/latest/user-guide/using-with-s3-actions.html).
//
// For information about Amazon S3 Object Ownership, see Using object ownership
// (https://docs.aws.amazon.com/AmazonS3/latest/user-guide/about-object-ownership.html).
//
// The following operations are related to PutBucketOwnershipControls:
//
//   - GetBucketOwnershipControls
//
//   - DeleteBucketOwnershipControls
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketOwnershipControls for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketOwnershipControls
func (c *S3) PutBucketOwnershipControls(input *PutBucketOwnershipControlsInput) (*PutBucketOwnershipControlsOutput, error) {
	req, out := c.PutBucketOwnershipControlsRequest(input)
	return out, req.Send()
}

// PutBucketOwnershipControlsWithContext is the same as PutBucketOwnershipControls with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketOwnershipControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketOwnershipControlsWithContext(ctx aws.Context, input *PutBucketOwnershipControlsInput, opts ...request.Option) (*PutBucketOwnershipControlsOutput, error) {
	req, out := c.PutBucketOwnershipControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketPolicy = "PutBucketPolicy"

// PutBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketPolicy for more information on using the PutBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketPolicyRequest method.
//	req, resp := client.PutBucketPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicy
func (c *S3) PutBucketPolicyRequest(input *PutBucketPolicyInput) (req *request.Request, output *PutBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opPutBucketPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &PutBucketPolicyInput{}
	}

	output = &PutBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketPolicy API operation for Amazon Simple Storage Service.
//
// Applies an Amazon S3 bucket policy to an Amazon S3 bucket. If you are using
// an identity other than the root user of the Amazon Web Services account that
// owns the bucket, the calling identity must have the PutBucketPolicy permissions
// on the specified bucket and belong to the bucket owner's account in order
// to use this operation.
//
// If you don't have PutBucketPolicy permissions, Amazon S3 returns a 403 Access
// Denied error. If you have the correct permissions, but you're not using an
// identity that belongs to the bucket owner's account, Amazon S3 returns a
// 405 Method Not Allowed error.
//
// As a security precaution, the root user of the Amazon Web Services account
// that owns a bucket can always use this operation, even if the policy explicitly
// denies the root user the ability to perform this action.
//
// For more information, see Bucket policy examples (https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html).
//
// The following operations are related to PutBucketPolicy:
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//   - DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicy
func (c *S3) PutBucketPolicy(input *PutBucketPolicyInput) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	return out, req.Send()
}

// PutBucketPolicyWithContext is the same as PutBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketPolicyWithContext(ctx aws.Context, input *PutBucketPolicyInput, opts ...request.Option) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketReplication = "PutBucketReplication"

// PutBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketReplication for more information on using the PutBucketReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketReplicationRequest method.
//	req, resp := client.PutBucketReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplication
func (c *S3) PutBucketReplicationRequest(input *PutBucketReplicationInput) (req *request.Request, output *PutBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opPutBucketReplication,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &PutBucketReplicationInput{}
	}

	output = &PutBucketReplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketReplication API operation for Amazon Simple Storage Service.
//
// Creates a replication configuration or replaces an existing one. For more
// information, see Replication (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html)
// in the Amazon S3 User Guide.
//
// Specify the replication configuration in the request body. In the replication
// configuration, you provide the name of the destination bucket or buckets
// where you want Amazon S3 to replicate objects, the IAM role that Amazon S3
// can assume to replicate objects on your behalf, and other relevant information.
//
// A replication configuration must include at least one rule, and can contain
// a maximum of 1,000. Each rule identifies a subset of objects to replicate
// by filtering the objects in the source bucket. To choose additional subsets
// of objects to replicate, add a rule for each subset.
//
// To specify a subset of the objects in the source bucket to apply a replication
// rule to, add the Filter element as a child of the Rule element. You can filter
// objects based on an object key prefix, one or more object tags, or both.
// When you add the Filter element in the configuration, you must also add the
// following elements: DeleteMarkerReplication, Status, and Priority.
//
// If you are using an earlier version of the replication configuration, Amazon
// S3 handles replication of delete markers differently. For more information,
// see Backward Compatibility (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
//
// For information about enabling versioning on a bucket, see Using Versioning
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html).
//
// # Handling Replication of Encrypted Objects
//
// By default, Amazon S3 doesn't replicate objects that are stored at rest using
// server-side encryption with KMS keys. To replicate Amazon Web Services KMS-encrypted
// objects, add the following: SourceSelectionCriteria, SseKmsEncryptedObjects,
// Status, EncryptionConfiguration, and ReplicaKmsKeyID. For information about
// replication configuration, see Replicating Objects Created with SSE Using
// KMS keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-config-for-kms-objects.html).
//
// For information on PutBucketReplication errors, see List of replication-related
// error codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList)
//
// # Permissions
//
// To create a PutBucketReplication request, you must have s3:PutReplicationConfiguration
// permissions for the bucket.
//
// By default, a resource owner, in this case the Amazon Web Services account
// that created the bucket, can perform this operation. The resource owner can
// also grant others permissions to perform the operation. For more information
// about permissions, see Specifying Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// To perform this operation, the user or role performing the action must have
// the iam:PassRole (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html)
// permission.
//
// The following operations are related to PutBucketReplication:
//
//   - GetBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html)
//
//   - DeleteBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketReplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplication
func (c *S3) PutBucketReplication(input *PutBucketReplicationInput) (*PutBucketReplicationOutput, error) {
	req, out := c.PutBucketReplicationRequest(input)
	return out, req.Send()
}

// PutBucketReplicationWithContext is the same as PutBucketReplication with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketReplicationWithContext(ctx aws.Context, input *PutBucketReplicationInput, opts ...request.Option) (*PutBucketReplicationOutput, error) {
	req, out := c.PutBucketReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketRequestPayment = "PutBucketRequestPayment"

// PutBucketRequestPaymentRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketRequestPayment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketRequestPayment for more information on using the PutBucketRequestPayment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketRequestPaymentRequest method.
//	req, resp := client.PutBucketRequestPaymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPayment
func (c *S3) PutBucketRequestPaymentRequest(input *PutBucketRequestPaymentInput) (req *request.Request, output *PutBucketRequestPaymentOutput) {
	op := &request.Operation{
		Name:       opPutBucketRequestPayment,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &PutBucketRequestPaymentInput{}
	}

	output = &PutBucketRequestPaymentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketRequestPayment API operation for Amazon Simple Storage Service.
//
// Sets the request payment configuration for a bucket. By default, the bucket
// owner pays for downloads from the bucket. This configuration parameter enables
// the bucket owner (only) to specify that the person requesting the download
// will be charged for the download. For more information, see Requester Pays
// Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html).
//
// The following operations are related to PutBucketRequestPayment:
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//   - GetBucketRequestPayment (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketRequestPayment.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketRequestPayment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPayment
func (c *S3) PutBucketRequestPayment(input *PutBucketRequestPaymentInput) (*PutBucketRequestPaymentOutput, error) {
	req, out := c.PutBucketRequestPaymentRequest(input)
	return out, req.Send()
}

// PutBucketRequestPaymentWithContext is the same as PutBucketRequestPayment with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketRequestPayment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketRequestPaymentWithContext(ctx aws.Context, input *PutBucketRequestPaymentInput, opts ...request.Option) (*PutBucketRequestPaymentOutput, error) {
	req, out := c.PutBucketRequestPaymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketTagging = "PutBucketTagging"

// PutBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketTagging for more information on using the PutBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketTaggingRequest method.
//	req, resp := client.PutBucketTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTagging
func (c *S3) PutBucketTaggingRequest(input *PutBucketTaggingInput) (req *request.Request, output *PutBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &PutBucketTaggingInput{}
	}

	output = &PutBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketTagging API operation for Amazon Simple Storage Service.
//
// Sets the tags for a bucket.
//
// Use tags to organize your Amazon Web Services bill to reflect your own cost
// structure. To do this, sign up to get your Amazon Web Services account bill
// with tag key values included. Then, to see the cost of combined resources,
// organize your billing information according to resources with the same tag
// key values. For example, you can tag several resources with a specific application
// name, and then organize your billing information to see the total cost of
// that application across several services. For more information, see Cost
// Allocation and Tagging (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// and Using Cost Allocation in Amazon S3 Bucket Tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/CostAllocTagging.html).
//
// When this operation sets the tags for a bucket, it will overwrite any current
// tags the bucket already has. You cannot use this operation to add tags to
// an existing list of tags.
//
// To use this operation, you must have permissions to perform the s3:PutBucketTagging
// action. The bucket owner has this permission by default and can grant this
// permission to others. For more information about permissions, see Permissions
// Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// PutBucketTagging has the following special errors:
//
//   - Error code: InvalidTagError Description: The tag provided was not a
//     valid tag. This error can occur if the tag did not pass input validation.
//     For information about tag restrictions, see User-Defined Tag Restrictions
//     (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
//     and Amazon Web Services-Generated Cost Allocation Tag Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html).
//
//   - Error code: MalformedXMLError Description: The XML provided does not
//     match the schema.
//
//   - Error code: OperationAbortedError Description: A conflicting conditional
//     action is currently in progress against this resource. Please try again.
//
//   - Error code: InternalError Description: The service was unable to apply
//     the provided tag to the bucket.
//
// The following operations are related to PutBucketTagging:
//
//   - GetBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html)
//
//   - DeleteBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTagging
func (c *S3) PutBucketTagging(input *PutBucketTaggingInput) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	return out, req.Send()
}

// PutBucketTaggingWithContext is the same as PutBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketTaggingWithContext(ctx aws.Context, input *PutBucketTaggingInput, opts ...request.Option) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketVersioning = "PutBucketVersioning"

// PutBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketVersioning operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketVersioning for more information on using the PutBucketVersioning
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketVersioningRequest method.
//	req, resp := client.PutBucketVersioningRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioning
func (c *S3) PutBucketVersioningRequest(input *PutBucketVersioningInput) (req *request.Request, output *PutBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opPutBucketVersioning,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &PutBucketVersioningInput{}
	}

	output = &PutBucketVersioningOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketVersioning API operation for Amazon Simple Storage Service.
//
// Sets the versioning state of an existing bucket.
//
// You can set the versioning state with one of the following values:
//
// Enabled—Enables versioning for the objects in the bucket. All objects added
// to the bucket receive a unique version ID.
//
// Suspended—Disables versioning for the objects in the bucket. All objects
// added to the bucket receive the version ID null.
//
// If the versioning state has never been set on a bucket, it has no versioning
// state; a GetBucketVersioning (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html)
// request does not return a versioning state value.
//
// In order to enable MFA Delete, you must be the bucket owner. If you are the
// bucket owner and want to enable MFA Delete in the bucket versioning configuration,
// you must include the x-amz-mfa request header and the Status and the MfaDelete
// request elements in a request to set the versioning state of the bucket.
//
// If you have an object expiration lifecycle policy in your non-versioned bucket
// and you want to maintain the same permanent delete behavior when you enable
// versioning, you must add a noncurrent expiration policy. The noncurrent expiration
// lifecycle policy will manage the deletes of the noncurrent object versions
// in the version-enabled bucket. (A version-enabled bucket maintains one current
// and zero or more noncurrent object versions.) For more information, see Lifecycle
// and Versioning (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-and-other-bucket-config).
//
// Related Resources
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//   - DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html)
//
//   - GetBucketVersioning (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketVersioning for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioning
func (c *S3) PutBucketVersioning(input *PutBucketVersioningInput) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	return out, req.Send()
}

// PutBucketVersioningWithContext is the same as PutBucketVersioning with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketVersioning for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketVersioningWithContext(ctx aws.Context, input *PutBucketVersioningInput, opts ...request.Option) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketWebsite = "PutBucketWebsite"

// PutBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketWebsite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketWebsite for more information on using the PutBucketWebsite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketWebsiteRequest method.
//	req, resp := client.PutBucketWebsiteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsite
func (c *S3) PutBucketWebsiteRequest(input *PutBucketWebsiteInput) (req *request.Request, output *PutBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opPutBucketWebsite,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &PutBucketWebsiteInput{}
	}

	output = &PutBucketWebsiteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketWebsite API operation for Amazon Simple Storage Service.
//
// Sets the configuration of the website that is specified in the website subresource.
// To configure a bucket as a website, you can add this subresource on the bucket
// with website configuration information such as the file name of the index
// document and any redirect rules. For more information, see Hosting Websites
// on Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
//
// This PUT action requires the S3:PutBucketWebsite permission. By default,
// only the bucket owner can configure the website attached to a bucket; however,
// bucket owners can allow other users to set the website configuration by writing
// a bucket policy that grants them the S3:PutBucketWebsite permission.
//
// To redirect all website requests sent to the bucket's website endpoint, you
// add a website configuration with the following elements. Because all requests
// are sent to another website, you don't need to provide index document name
// for the bucket.
//
//   - WebsiteConfiguration
//
//   - RedirectAllRequestsTo
//
//   - HostName
//
//   - Protocol
//
// If you want granular control over redirects, you can use the following elements
// to add routing rules that describe conditions for redirecting requests and
// information about the redirect destination. In this case, the website configuration
// must provide an index document for the bucket, because some requests might
// not be redirected.
//
//   - WebsiteConfiguration
//
//   - IndexDocument
//
//   - Suffix
//
//   - ErrorDocument
//
//   - Key
//
//   - RoutingRules
//
//   - RoutingRule
//
//   - Condition
//
//   - HttpErrorCodeReturnedEquals
//
//   - KeyPrefixEquals
//
//   - Redirect
//
//   - Protocol
//
//   - HostName
//
//   - ReplaceKeyPrefixWith
//
//   - ReplaceKeyWith
//
//   - HttpRedirectCode
//
// Amazon S3 has a limitation of 50 routing rules per website configuration.
// If you require more than 50 routing rules, you can use object redirect. For
// more information, see Configuring an Object Redirect (https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketWebsite for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsite
func (c *S3) PutBucketWebsite(input *PutBucketWebsiteInput) (*PutBucketWebsiteOutput, error) {
	req, out := c.PutBucketWebsiteRequest(input)
	return out, req.Send()
}

// PutBucketWebsiteWithContext is the same as PutBucketWebsite with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketWebsite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketWebsiteWithContext(ctx aws.Context, input *PutBucketWebsiteInput, opts ...request.Option) (*PutBucketWebsiteOutput, error) {
	req, out := c.PutBucketWebsiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObject = "PutObject"

// PutObjectRequest generates a "aws/request.Request" representing the
// client's request for the PutObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObject for more information on using the PutObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutObjectRequest method.
//	req, resp := client.PutObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObject
func (c *S3) PutObjectRequest(input *PutObjectInput) (req *request.Request, output *PutObjectOutput) {
	op := &request.Operation{
		Name:       opPutObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &PutObjectInput{}
	}

	output = &PutObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutObject API operation for Amazon Simple Storage Service.
//
// Adds an object to a bucket. You must have WRITE permissions on a bucket to
// add an object to it.
//
// Amazon S3 never adds partial objects; if you receive a success response,
// Amazon S3 added the entire object to the bucket.
//
// Amazon S3 is a distributed system. If it receives multiple write requests
// for the same object simultaneously, it overwrites all but the last object
// written. Amazon S3 does not provide object locking; if you need this, make
// sure to build it into your application layer or use versioning instead.
//
// To ensure that data is not corrupted traversing the network, use the Content-MD5
// header. When you use this header, Amazon S3 checks the object against the
// provided MD5 value and, if they do not match, returns an error. Additionally,
// you can calculate the MD5 while putting an object to Amazon S3 and compare
// the returned ETag to the calculated MD5 value.
//
//   - To successfully complete the PutObject request, you must have the s3:PutObject
//     in your IAM permissions.
//
//   - To successfully change the objects acl of your PutObject request, you
//     must have the s3:PutObjectAcl in your IAM permissions.
//
//   - The Content-MD5 header is required for any request to upload an object
//     with a retention period configured using Amazon S3 Object Lock. For more
//     information about Amazon S3 Object Lock, see Amazon S3 Object Lock Overview
//     (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)
//     in the Amazon S3 User Guide.
//
// # Server-side Encryption
//
// You can optionally request server-side encryption. With server-side encryption,
// Amazon S3 encrypts your data as it writes it to disks in its data centers
// and decrypts the data when you access it. You have the option to provide
// your own encryption key or use Amazon Web Services managed encryption keys
// (SSE-S3 or SSE-KMS). For more information, see Using Server-Side Encryption
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html).
//
// If you request server-side encryption using Amazon Web Services Key Management
// Service (SSE-KMS), you can enable an S3 Bucket Key at the object-level. For
// more information, see Amazon S3 Bucket Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html)
// in the Amazon S3 User Guide.
//
// # Access Control List (ACL)-Specific Request Headers
//
// You can use headers to grant ACL- based permissions. By default, all objects
// are private. Only the owner has full access control. When adding a new object,
// you can grant permissions to individual Amazon Web Services accounts or to
// predefined groups defined by Amazon S3. These permissions are then added
// to the ACL on the object. For more information, see Access Control List (ACL)
// Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html)
// and Managing ACLs Using the REST API (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html).
//
// If the bucket that you're uploading objects to uses the bucket owner enforced
// setting for S3 Object Ownership, ACLs are disabled and no longer affect permissions.
// Buckets that use this setting only accept PUT requests that don't specify
// an ACL or PUT requests that specify bucket owner full control ACLs, such
// as the bucket-owner-full-control canned ACL or an equivalent form of this
// ACL expressed in the XML format. PUT requests that contain other ACLs (for
// example, custom grants to certain Amazon Web Services accounts) fail and
// return a 400 error with the error code AccessControlListNotSupported.
//
// For more information, see Controlling ownership of objects and disabling
// ACLs (https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html)
// in the Amazon S3 User Guide.
//
// If your bucket uses the bucket owner enforced setting for Object Ownership,
// all objects written to the bucket by any account will be owned by the bucket
// owner.
//
// # Storage Class Options
//
// By default, Amazon S3 uses the STANDARD Storage Class to store newly created
// objects. The STANDARD storage class provides high durability and high availability.
// Depending on performance needs, you can specify a different Storage Class.
// Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information,
// see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html)
// in the Amazon S3 User Guide.
//
// # Versioning
//
// If you enable versioning for a bucket, Amazon S3 automatically generates
// a unique version ID for the object being stored. Amazon S3 returns this ID
// in the response. When you enable versioning for a bucket, if Amazon S3 receives
// multiple write requests for the same object simultaneously, it stores all
// of the objects.
//
// For more information about versioning, see Adding Objects to Versioning Enabled
// Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html).
// For information about returning the versioning state of a bucket, see GetBucketVersioning
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html).
//
// Related Resources
//
//   - CopyObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html)
//
//   - DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObject
func (c *S3) PutObject(input *PutObjectInput) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	return out, req.Send()
}

// PutObjectWithContext is the same as PutObject with the addition of
// the ability to pass a context and additional request options.
//
// See PutObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectWithContext(ctx aws.Context, input *PutObjectInput, opts ...request.Option) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObjectAcl = "PutObjectAcl"

// PutObjectAclRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObjectAcl for more information on using the PutObjectAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutObjectAclRequest method.
//	req, resp := client.PutObjectAclRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAcl
func (c *S3) PutObjectAclRequest(input *PutObjectAclInput) (req *request.Request, output *PutObjectAclOutput) {
	op := &request.Operation{
		Name:       opPutObjectAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &PutObjectAclInput{}
	}

	output = &PutObjectAclOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutObjectAcl API operation for Amazon Simple Storage Service.
//
// Uses the acl subresource to set the access control list (ACL) permissions
// for a new or existing object in an S3 bucket. You must have WRITE_ACP permission
// to set the ACL of an object. For more information, see What permissions can
// I grant? (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions)
// in the Amazon S3 User Guide.
//
// This action is not supported by Amazon S3 on Outposts.
//
// Depending on your application needs, you can choose to set the ACL on an
// object using either the request body or the headers. For example, if you
// have an existing application that updates a bucket ACL using the request
// body, you can continue to use that approach. For more information, see Access
// Control List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html)
// in the Amazon S3 User Guide.
//
// If your bucket uses the bucket owner enforced setting for S3 Object Ownership,
// ACLs are disabled and no longer affect permissions. You must use policies
// to grant access to your bucket and the objects in it. Requests to set ACLs
// or update ACLs fail and return the AccessControlListNotSupported error code.
// Requests to read ACLs are still supported. For more information, see Controlling
// object ownership (https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html)
// in the Amazon S3 User Guide.
//
// # Access Permissions
//
// You can set access permissions using one of the following methods:
//
//   - Specify a canned ACL with the x-amz-acl request header. Amazon S3 supports
//     a set of predefined ACLs, known as canned ACLs. Each canned ACL has a
//     predefined set of grantees and permissions. Specify the canned ACL name
//     as the value of x-amz-acl. If you use this header, you cannot use other
//     access control-specific headers in your request. For more information,
//     see Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//   - Specify access permissions explicitly with the x-amz-grant-read, x-amz-grant-read-acp,
//     x-amz-grant-write-acp, and x-amz-grant-full-control headers. When using
//     these headers, you specify explicit access permissions and grantees (Amazon
//     Web Services accounts or Amazon S3 groups) who will receive the permission.
//     If you use these ACL-specific headers, you cannot use x-amz-acl header
//     to set a canned ACL. These parameters map to the set of permissions that
//     Amazon S3 supports in an ACL. For more information, see Access Control
//     List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html).
//     You specify each grantee as a type=value pair, where the type is one of
//     the following: id – if the value specified is the canonical user ID
//     of an Amazon Web Services account uri – if you are granting permissions
//     to a predefined group emailAddress – if the value specified is the email
//     address of an Amazon Web Services account Using email addresses to specify
//     a grantee is only supported in the following Amazon Web Services Regions:
//     US East (N. Virginia) US West (N. California) US West (Oregon) Asia Pacific
//     (Singapore) Asia Pacific (Sydney) Asia Pacific (Tokyo) Europe (Ireland)
//     South America (São Paulo) For a list of all the Amazon S3 supported Regions
//     and endpoints, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
//     in the Amazon Web Services General Reference. For example, the following
//     x-amz-grant-read header grants list objects permission to the two Amazon
//     Web Services accounts identified by their email addresses. x-amz-grant-read:
//     emailAddress="xyz@amazon.com", emailAddress="abc@amazon.com"
//
// You can use either a canned ACL or specify access permissions explicitly.
// You cannot do both.
//
// # Grantee Values
//
// You can specify the person (grantee) to whom you're assigning access rights
// (using request elements) in the following ways:
//
//   - By the person's ID: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName>
//     </Grantee> DisplayName is optional and ignored in the request.
//
//   - By URI: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>
//
//   - By Email address: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress>lt;/Grantee>
//     The grantee is resolved to the CanonicalUser and, in a response to a GET
//     Object acl request, appears as the CanonicalUser. Using email addresses
//     to specify a grantee is only supported in the following Amazon Web Services
//     Regions: US East (N. Virginia) US West (N. California) US West (Oregon)
//     Asia Pacific (Singapore) Asia Pacific (Sydney) Asia Pacific (Tokyo) Europe
//     (Ireland) South America (São Paulo) For a list of all the Amazon S3 supported
//     Regions and endpoints, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
//     in the Amazon Web Services General Reference.
//
// # Versioning
//
// The ACL of an object is set at the object version level. By default, PUT
// sets the ACL of the current version of an object. To set the ACL of a different
// version, use the versionId subresource.
//
// Related Resources
//
//   - CopyObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html)
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectAcl for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeNoSuchKey "NoSuchKey"
//     The specified key does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAcl
func (c *S3) PutObjectAcl(input *PutObjectAclInput) (*PutObjectAclOutput, error) {
	req, out := c.PutObjectAclRequest(input)
	return out, req.Send()
}

// PutObjectAclWithContext is the same as PutObjectAcl with the addition of
// the ability to pass a context and additional request options.
//
// See PutObjectAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectAclWithContext(ctx aws.Context, input *PutObjectAclInput, opts ...request.Option) (*PutObjectAclOutput, error) {
	req, out := c.PutObjectAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObjectLegalHold = "PutObjectLegalHold"

// PutObjectLegalHoldRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectLegalHold operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObjectLegalHold for more information on using the PutObjectLegalHold
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutObjectLegalHoldRequest method.
//	req, resp := client.PutObjectLegalHoldRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectLegalHold
func (c *S3) PutObjectLegalHoldRequest(input *PutObjectLegalHoldInput) (req *request.Request, output *PutObjectLegalHoldOutput) {
	op := &request.Operation{
		Name:       opPutObjectLegalHold,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?legal-hold",
	}

	if input == nil {
		input = &PutObjectLegalHoldInput{}
	}

	output = &PutObjectLegalHoldOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutObjectLegalHold API operation for Amazon Simple Storage Service.
//
// Applies a legal hold configuration to the specified object. For more information,
// see Locking Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html).
//
// This action is not supported by Amazon S3 on Outposts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectLegalHold for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectLegalHold
func (c *S3) PutObjectLegalHold(input *PutObjectLegalHoldInput) (*PutObjectLegalHoldOutput, error) {
	req, out := c.PutObjectLegalHoldRequest(input)
	return out, req.Send()
}

// PutObjectLegalHoldWithContext is the same as PutObjectLegalHold with the addition of
// the ability to pass a context and additional request options.
//
// See PutObjectLegalHold for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectLegalHoldWithContext(ctx aws.Context, input *PutObjectLegalHoldInput, opts ...request.Option) (*PutObjectLegalHoldOutput, error) {
	req, out := c.PutObjectLegalHoldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObjectLockConfiguration = "PutObjectLockConfiguration"

// PutObjectLockConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectLockConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObjectLockConfiguration for more information on using the PutObjectLockConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutObjectLockConfigurationRequest method.
//	req, resp := client.PutObjectLockConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectLockConfiguration
func (c *S3) PutObjectLockConfigurationRequest(input *PutObjectLockConfigurationInput) (req *request.Request, output *PutObjectLockConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutObjectLockConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?object-lock",
	}

	if input == nil {
		input = &PutObjectLockConfigurationInput{}
	}

	output = &PutObjectLockConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutObjectLockConfiguration API operation for Amazon Simple Storage Service.
//
// Places an Object Lock configuration on the specified bucket. The rule specified
// in the Object Lock configuration will be applied by default to every new
// object placed in the specified bucket. For more information, see Locking
// Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html).
//
//   - The DefaultRetention settings require both a mode and a period.
//
//   - The DefaultRetention period can be either Days or Years but you must
//     select one. You cannot specify Days and Years at the same time.
//
//   - You can only enable Object Lock for new buckets. If you want to turn
//     on Object Lock for an existing bucket, contact Amazon Web Services Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectLockConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectLockConfiguration
func (c *S3) PutObjectLockConfiguration(input *PutObjectLockConfigurationInput) (*PutObjectLockConfigurationOutput, error) {
	req, out := c.PutObjectLockConfigurationRequest(input)
	return out, req.Send()
}

// PutObjectLockConfigurationWithContext is the same as PutObjectLockConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutObjectLockConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectLockConfigurationWithContext(ctx aws.Context, input *PutObjectLockConfigurationInput, opts ...request.Option) (*PutObjectLockConfigurationOutput, error) {
	req, out := c.PutObjectLockConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObjectRetention = "PutObjectRetention"

// PutObjectRetentionRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectRetention operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObjectRetention for more information on using the PutObjectRetention
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutObjectRetentionRequest method.
//	req, resp := client.PutObjectRetentionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectRetention
func (c *S3) PutObjectRetentionRequest(input *PutObjectRetentionInput) (req *request.Request, output *PutObjectRetentionOutput) {
	op := &request.Operation{
		Name:       opPutObjectRetention,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?retention",
	}

	if input == nil {
		input = &PutObjectRetentionInput{}
	}

	output = &PutObjectRetentionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutObjectRetention API operation for Amazon Simple Storage Service.
//
// Places an Object Retention configuration on an object. For more information,
// see Locking Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html).
// Users or accounts require the s3:PutObjectRetention permission in order to
// place an Object Retention configuration on objects. Bypassing a Governance
// Retention configuration requires the s3:BypassGovernanceRetention permission.
//
// This action is not supported by Amazon S3 on Outposts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectRetention for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectRetention
func (c *S3) PutObjectRetention(input *PutObjectRetentionInput) (*PutObjectRetentionOutput, error) {
	req, out := c.PutObjectRetentionRequest(input)
	return out, req.Send()
}

// PutObjectRetentionWithContext is the same as PutObjectRetention with the addition of
// the ability to pass a context and additional request options.
//
// See PutObjectRetention for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectRetentionWithContext(ctx aws.Context, input *PutObjectRetentionInput, opts ...request.Option) (*PutObjectRetentionOutput, error) {
	req, out := c.PutObjectRetentionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObjectTagging = "PutObjectTagging"

// PutObjectTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObjectTagging for more information on using the PutObjectTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutObjectTaggingRequest method.
//	req, resp := client.PutObjectTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTagging
func (c *S3) PutObjectTaggingRequest(input *PutObjectTaggingInput) (req *request.Request, output *PutObjectTaggingOutput) {
	op := &request.Operation{
		Name:       opPutObjectTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &PutObjectTaggingInput{}
	}

	output = &PutObjectTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutObjectTagging API operation for Amazon Simple Storage Service.
//
// Sets the supplied tag-set to an object that already exists in a bucket.
//
// A tag is a key-value pair. You can associate tags with an object by sending
// a PUT request against the tagging subresource that is associated with the
// object. You can retrieve tags by sending a GET request. For more information,
// see GetObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html).
//
// For tagging-related restrictions related to characters and encodings, see
// Tag Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html).
// Note that Amazon S3 limits the maximum number of tags to 10 tags per object.
//
// To use this operation, you must have permission to perform the s3:PutObjectTagging
// action. By default, the bucket owner has this permission and can grant this
// permission to others.
//
// To put tags of any other version, use the versionId query parameter. You
// also need permission for the s3:PutObjectVersionTagging action.
//
// For information about the Amazon S3 object tagging feature, see Object Tagging
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html).
//
// Special Errors
//
//   - Code: InvalidTagError Cause: The tag provided was not a valid tag. This
//     error can occur if the tag did not pass input validation. For more information,
//     see Object Tagging (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html).
//
//   - Code: MalformedXMLError Cause: The XML provided does not match the schema.
//
//   - Code: OperationAbortedError Cause: A conflicting conditional action
//     is currently in progress against this resource. Please try again.
//
//   - Code: InternalError Cause: The service was unable to apply the provided
//     tag to the object.
//
// Related Resources
//
//   - GetObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html)
//
//   - DeleteObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTagging
func (c *S3) PutObjectTagging(input *PutObjectTaggingInput) (*PutObjectTaggingOutput, error) {
	req, out := c.PutObjectTaggingRequest(input)
	return out, req.Send()
}

// PutObjectTaggingWithContext is the same as PutObjectTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutObjectTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectTaggingWithContext(ctx aws.Context, input *PutObjectTaggingInput, opts ...request.Option) (*PutObjectTaggingOutput, error) {
	req, out := c.PutObjectTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPublicAccessBlock = "PutPublicAccessBlock"

// PutPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the PutPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPublicAccessBlock for more information on using the PutPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPublicAccessBlockRequest method.
//	req, resp := client.PutPublicAccessBlockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutPublicAccessBlock
func (c *S3) PutPublicAccessBlockRequest(input *PutPublicAccessBlockInput) (req *request.Request, output *PutPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opPutPublicAccessBlock,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?publicAccessBlock",
	}

	if input == nil {
		input = &PutPublicAccessBlockInput{}
	}

	output = &PutPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutPublicAccessBlock API operation for Amazon Simple Storage Service.
//
// Creates or modifies the PublicAccessBlock configuration for an Amazon S3
// bucket. To use this operation, you must have the s3:PutBucketPublicAccessBlock
// permission. For more information about Amazon S3 permissions, see Specifying
// Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
//
// When Amazon S3 evaluates the PublicAccessBlock configuration for a bucket
// or an object, it checks the PublicAccessBlock configuration for both the
// bucket (or the bucket that contains the object) and the bucket owner's account.
// If the PublicAccessBlock configurations are different between the bucket
// and the account, Amazon S3 uses the most restrictive combination of the bucket-level
// and account-level settings.
//
// For more information about when Amazon S3 considers a bucket or an object
// public, see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status).
//
// Related Resources
//
//   - GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html)
//
//   - DeletePublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html)
//
//   - GetBucketPolicyStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html)
//
//   - Using Amazon S3 Block Public Access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutPublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutPublicAccessBlock
func (c *S3) PutPublicAccessBlock(input *PutPublicAccessBlockInput) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	return out, req.Send()
}

// PutPublicAccessBlockWithContext is the same as PutPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See PutPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutPublicAccessBlockWithContext(ctx aws.Context, input *PutPublicAccessBlockInput, opts ...request.Option) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreObject = "RestoreObject"

// RestoreObjectRequest generates a "aws/request.Request" representing the
// client's request for the RestoreObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreObject for more information on using the RestoreObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreObjectRequest method.
//	req, resp := client.RestoreObjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject
func (c *S3) RestoreObjectRequest(input *RestoreObjectInput) (req *request.Request, output *RestoreObjectOutput) {
	op := &request.Operation{
		Name:       opRestoreObject,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?restore",
	}

	if input == nil {
		input = &RestoreObjectInput{}
	}

	output = &RestoreObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreObject API operation for Amazon Simple Storage Service.
//
// # Restores an archived copy of an object back into Amazon S3
//
// This action is not supported by Amazon S3 on Outposts.
//
// This action performs the following types of requests:
//
//   - select - Perform a select query on an archived object
//
//   - restore an archive - Restore an archived object
//
// To use this operation, you must have permissions to perform the s3:RestoreObject
// action. The bucket owner has this permission by default and can grant this
// permission to others. For more information about permissions, see Permissions
// Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html)
// in the Amazon S3 User Guide.
//
// # Querying Archives with Select Requests
//
// You use a select type of request to perform SQL queries on archived objects.
// The archived objects that are being queried by the select request must be
// formatted as uncompressed comma-separated values (CSV) files. You can run
// queries and custom analytics on your archived data without having to restore
// your data to a hotter Amazon S3 tier. For an overview about select requests,
// see Querying Archived Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/querying-glacier-archives.html)
// in the Amazon S3 User Guide.
//
// When making a select request, do the following:
//
//   - Define an output location for the select query's output. This must be
//     an Amazon S3 bucket in the same Amazon Web Services Region as the bucket
//     that contains the archive object that is being queried. The Amazon Web
//     Services account that initiates the job must have permissions to write
//     to the S3 bucket. You can specify the storage class and encryption for
//     the output objects stored in the bucket. For more information about output,
//     see Querying Archived Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/querying-glacier-archives.html)
//     in the Amazon S3 User Guide. For more information about the S3 structure
//     in the request body, see the following: PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//     Managing Access with ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html)
//     in the Amazon S3 User Guide Protecting Data Using Server-Side Encryption
//     (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html)
//     in the Amazon S3 User Guide
//
//   - Define the SQL expression for the SELECT type of restoration for your
//     query in the request body's SelectParameters structure. You can use expressions
//     like the following examples. The following expression returns all records
//     from the specified object. SELECT * FROM Object Assuming that you are
//     not using any headers for data stored in the object, you can specify columns
//     with positional headers. SELECT s._1, s._2 FROM Object s WHERE s._3 >
//     100 If you have headers and you set the fileHeaderInfo in the CSV structure
//     in the request body to USE, you can specify headers in the query. (If
//     you set the fileHeaderInfo field to IGNORE, the first row is skipped for
//     the query.) You cannot mix ordinal positions with header column names.
//     SELECT s.Id, s.FirstName, s.SSN FROM S3Object s
//
// For more information about using SQL with S3 Glacier Select restore, see
// SQL Reference for Amazon S3 Select and S3 Glacier Select (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html)
// in the Amazon S3 User Guide.
//
// When making a select request, you can also do the following:
//
//   - To expedite your queries, specify the Expedited tier. For more information
//     about tiers, see "Restoring Archives," later in this topic.
//
//   - Specify details about the data serialization format of both the input
//     object that is being queried and the serialization of the CSV-encoded
//     query results.
//
// The following are additional important facts about the select feature:
//
//   - The output results are new Amazon S3 objects. Unlike archive retrievals,
//     they are stored until explicitly deleted-manually or through a lifecycle
//     policy.
//
//   - You can issue more than one select request on the same Amazon S3 object.
//     Amazon S3 doesn't deduplicate requests, so avoid issuing duplicate requests.
//
//   - Amazon S3 accepts a select request even if the object has already been
//     restored. A select request doesn’t return error response 409.
//
// # Restoring objects
//
// Objects that you archive to the S3 Glacier or S3 Glacier Deep Archive storage
// class, and S3 Intelligent-Tiering Archive or S3 Intelligent-Tiering Deep
// Archive tiers are not accessible in real time. For objects in Archive Access
// or Deep Archive Access tiers you must first initiate a restore request, and
// then wait until the object is moved into the Frequent Access tier. For objects
// in S3 Glacier or S3 Glacier Deep Archive storage classes you must first initiate
// a restore request, and then wait until a temporary copy of the object is
// available. To access an archived object, you must restore the object for
// the duration (number of days) that you specify.
//
// To restore a specific object version, you can provide a version ID. If you
// don't provide a version ID, Amazon S3 restores the current version.
//
// When restoring an archived object (or using a select request), you can specify
// one of the following data access tier options in the Tier element of the
// request body:
//
//   - Expedited - Expedited retrievals allow you to quickly access your data
//     stored in the S3 Glacier storage class or S3 Intelligent-Tiering Archive
//     tier when occasional urgent requests for a subset of archives are required.
//     For all but the largest archived objects (250 MB+), data accessed using
//     Expedited retrievals is typically made available within 1–5 minutes.
//     Provisioned capacity ensures that retrieval capacity for Expedited retrievals
//     is available when you need it. Expedited retrievals and provisioned capacity
//     are not available for objects stored in the S3 Glacier Deep Archive storage
//     class or S3 Intelligent-Tiering Deep Archive tier.
//
//   - Standard - Standard retrievals allow you to access any of your archived
//     objects within several hours. This is the default option for retrieval
//     requests that do not specify the retrieval option. Standard retrievals
//     typically finish within 3–5 hours for objects stored in the S3 Glacier
//     storage class or S3 Intelligent-Tiering Archive tier. They typically finish
//     within 12 hours for objects stored in the S3 Glacier Deep Archive storage
//     class or S3 Intelligent-Tiering Deep Archive tier. Standard retrievals
//     are free for objects stored in S3 Intelligent-Tiering.
//
//   - Bulk - Bulk retrievals are the lowest-cost retrieval option in S3 Glacier,
//     enabling you to retrieve large amounts, even petabytes, of data inexpensively.
//     Bulk retrievals typically finish within 5–12 hours for objects stored
//     in the S3 Glacier storage class or S3 Intelligent-Tiering Archive tier.
//     They typically finish within 48 hours for objects stored in the S3 Glacier
//     Deep Archive storage class or S3 Intelligent-Tiering Deep Archive tier.
//     Bulk retrievals are free for objects stored in S3 Intelligent-Tiering.
//
// For more information about archive retrieval options and provisioned capacity
// for Expedited data access, see Restoring Archived Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html)
// in the Amazon S3 User Guide.
//
// You can use Amazon S3 restore speed upgrade to change the restore speed to
// a faster speed while it is in progress. For more information, see Upgrading
// the speed of an in-progress restore (https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html#restoring-objects-upgrade-tier.title.html)
// in the Amazon S3 User Guide.
//
// To get the status of object restoration, you can send a HEAD request. Operations
// return the x-amz-restore header, which provides information about the restoration
// status, in the response. You can use Amazon S3 event notifications to notify
// you when a restore is initiated or completed. For more information, see Configuring
// Amazon S3 Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
// in the Amazon S3 User Guide.
//
// After restoring an archived object, you can update the restoration period
// by reissuing the request with a new period. Amazon S3 updates the restoration
// period relative to the current time and charges only for the request-there
// are no data transfer charges. You cannot update the restoration period when
// Amazon S3 is actively processing your current restore request for the object.
//
// If your bucket has a lifecycle configuration with a rule that includes an
// expiration action, the object expiration overrides the life span that you
// specify in a restore request. For example, if you restore an object copy
// for 10 days, but the object is scheduled to expire in 3 days, Amazon S3 deletes
// the object in 3 days. For more information about lifecycle configuration,
// see PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)
// and Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// in Amazon S3 User Guide.
//
// # Responses
//
// A successful action returns either the 200 OK or 202 Accepted status code.
//
//   - If the object is not previously restored, then Amazon S3 returns 202
//     Accepted in the response.
//
//   - If the object is previously restored, Amazon S3 returns 200 OK in the
//     response.
//
// Special Errors
//
//   - Code: RestoreAlreadyInProgress Cause: Object restore is already in progress.
//     (This error does not apply to SELECT type requests.) HTTP Status Code:
//     409 Conflict SOAP Fault Code Prefix: Client
//
//   - Code: GlacierExpeditedRetrievalNotAvailable Cause: expedited retrievals
//     are currently not available. Try again later. (Returned if there is insufficient
//     capacity to process the Expedited request. This error applies only to
//     Expedited retrievals and not to S3 Standard or Bulk retrievals.) HTTP
//     Status Code: 503 SOAP Fault Code Prefix: N/A
//
// Related Resources
//
//   - PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)
//
//   - GetBucketNotificationConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html)
//
//   - SQL Reference for Amazon S3 Select and S3 Glacier Select (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html)
//     in the Amazon S3 User Guide
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation RestoreObject for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeObjectAlreadyInActiveTierError "ObjectAlreadyInActiveTierError"
//     This action is not allowed against this storage tier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject
func (c *S3) RestoreObject(input *RestoreObjectInput) (*RestoreObjectOutput, error) {
	req, out := c.RestoreObjectRequest(input)
	return out, req.Send()
}

// RestoreObjectWithContext is the same as RestoreObject with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) RestoreObjectWithContext(ctx aws.Context, input *RestoreObjectInput, opts ...request.Option) (*RestoreObjectOutput, error) {
	req, out := c.RestoreObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSelectObjectContent = "SelectObjectContent"

// SelectObjectContentRequest generates a "aws/request.Request" representing the
// client's request for the SelectObjectContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SelectObjectContent for more information on using the SelectObjectContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SelectObjectContentRequest method.
//	req, resp := client.SelectObjectContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SelectObjectContent
func (c *S3) SelectObjectContentRequest(input *SelectObjectContentInput) (req *request.Request, output *SelectObjectContentOutput) {
	op := &request.Operation{
		Name:       opSelectObjectContent,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?select&select-type=2",
	}

	if input == nil {
		input = &SelectObjectContentInput{}
	}

	output = &SelectObjectContentOutput{}
	req = c.newRequest(op, input, output)

	es := NewSelectObjectContentEventStream()
	req.Handlers.Unmarshal.PushBack(es.setStreamCloser)
	output.EventStream = es

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// SelectObjectContent API operation for Amazon Simple Storage Service.
//
// This action filters the contents of an Amazon S3 object based on a simple
// structured query language (SQL) statement. In the request, along with the
// SQL expression, you must also specify a data serialization format (JSON,
// CSV, or Apache Parquet) of the object. Amazon S3 uses this format to parse
// object data into records, and returns only records that match the specified
// SQL expression. You must also specify the data serialization format for the
// response.
//
// This action is not supported by Amazon S3 on Outposts.
//
// For more information about Amazon S3 Select, see Selecting Content from Objects
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/selecting-content-from-objects.html)
// and SELECT Command (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-glacier-select-sql-reference-select.html)
// in the Amazon S3 User Guide.
//
// For more information about using SQL with Amazon S3 Select, see SQL Reference
// for Amazon S3 Select and S3 Glacier Select (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html)
// in the Amazon S3 User Guide.
//
// # Permissions
//
// You must have s3:GetObject permission for this operation. Amazon S3 Select
// does not support anonymous access. For more information about permissions,
// see Specifying Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html)
// in the Amazon S3 User Guide.
//
// # Object Data Formats
//
// You can use Amazon S3 Select to query objects that have the following format
// properties:
//
//   - CSV, JSON, and Parquet - Objects must be in CSV, JSON, or Parquet format.
//
//   - UTF-8 - UTF-8 is the only encoding type Amazon S3 Select supports.
//
//   - GZIP or BZIP2 - CSV and JSON files can be compressed using GZIP or BZIP2.
//     GZIP and BZIP2 are the only compression formats that Amazon S3 Select
//     supports for CSV and JSON files. Amazon S3 Select supports columnar compression
//     for Parquet using GZIP or Snappy. Amazon S3 Select does not support whole-object
//     compression for Parquet objects.
//
//   - Server-side encryption - Amazon S3 Select supports querying objects
//     that are protected with server-side encryption. For objects that are encrypted
//     with customer-provided encryption keys (SSE-C), you must use HTTPS, and
//     you must use the headers that are documented in the GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html).
//     For more information about SSE-C, see Server-Side Encryption (Using Customer-Provided
//     Encryption Keys) (https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html)
//     in the Amazon S3 User Guide. For objects that are encrypted with Amazon
//     S3 managed encryption keys (SSE-S3) and Amazon Web Services KMS keys (SSE-KMS),
//     server-side encryption is handled transparently, so you don't need to
//     specify anything. For more information about server-side encryption, including
//     SSE-S3 and SSE-KMS, see Protecting Data Using Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html)
//     in the Amazon S3 User Guide.
//
// # Working with the Response Body
//
// Given the response size is unknown, Amazon S3 Select streams the response
// as a series of messages and includes a Transfer-Encoding header with chunked
// as its value in the response. For more information, see Appendix: SelectObjectContent
// Response (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTSelectObjectAppendix.html).
//
// # GetObject Support
//
// The SelectObjectContent action does not support the following GetObject functionality.
// For more information, see GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html).
//
//   - Range: Although you can specify a scan range for an Amazon S3 Select
//     request (see SelectObjectContentRequest - ScanRange (https://docs.aws.amazon.com/AmazonS3/latest/API/API_SelectObjectContent.html#AmazonS3-SelectObjectContent-request-ScanRange)
//     in the request parameters), you cannot specify the range of bytes of an
//     object to return.
//
//   - GLACIER, DEEP_ARCHIVE and REDUCED_REDUNDANCY storage classes: You cannot
//     specify the GLACIER, DEEP_ARCHIVE, or REDUCED_REDUNDANCY storage classes.
//     For more information, about storage classes see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#storage-class-intro)
//     in the Amazon S3 User Guide.
//
// # Special Errors
//
// For a list of special errors for this operation, see List of SELECT Object
// Content Error Codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#SelectObjectContentErrorCodeList)
//
// Related Resources
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html)
//
//   - PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation SelectObjectContent for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SelectObjectContent
func (c *S3) SelectObjectContent(input *SelectObjectContentInput) (*SelectObjectContentOutput, error) {
	req, out := c.SelectObjectContentRequest(input)
	return out, req.Send()
}

// SelectObjectContentWithContext is the same as SelectObjectContent with the addition of
// the ability to pass a context and additional request options.
//
// See SelectObjectContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) SelectObjectContentWithContext(ctx aws.Context, input *SelectObjectContentInput, opts ...request.Option) (*SelectObjectContentOutput, error) {
	req, out := c.SelectObjectContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error

// SelectObjectContentEventStream provides the event stream handling for the SelectObjectContent.
//
// For testing and mocking the event stream this type should be initialized via
// the NewSelectObjectContentEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type SelectObjectContentEventStream struct {

	// Reader is the EventStream reader for the SelectObjectContentEventStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader SelectObjectContentEventStreamReader

	outputReader io.ReadCloser

	// StreamCloser is the io.Closer for the EventStream connection. For HTTP
	// EventStream this is the response Body. The stream will be closed when
	// the Close method of the EventStream is called.
	StreamCloser io.Closer

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewSelectObjectContentEventStream initializes an SelectObjectContentEventStream.
// This function should only be used for testing and mocking the SelectObjectContentEventStream
// stream within your application.
//
// The Reader member must be set before reading events from the stream.
//
// The StreamCloser member should be set to the underlying io.Closer,
// (e.g. http.Response.Body), that will be closed when the stream Close method
// is called.
//
//	es := NewSelectObjectContentEventStream(func(o *SelectObjectContentEventStream){
//	    es.Reader = myMockStreamReader
//	    es.StreamCloser = myMockStreamCloser
//	})
func NewSelectObjectContentEventStream(opts ...func(*SelectObjectContentEventStream)) *SelectObjectContentEventStream {
	es := &SelectObjectContentEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *SelectObjectContentEventStream) setStreamCloser(r *request.Request) {
	es.StreamCloser = r.HTTPResponse.Body
}

func (es *SelectObjectContentEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *SelectObjectContentEventStream) waitStreamPartClose() {
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

// Events returns a channel to read events from.
//
// These events are:
//
//   - ContinuationEvent
//   - EndEvent
//   - ProgressEvent
//   - RecordsEvent
//   - StatsEvent
//   - SelectObjectContentEventStreamUnknownEvent
func (es *SelectObjectContentEventStream) Events() <-chan SelectObjectContentEventStreamEvent {
	return es.Reader.Events()
}

func (es *SelectObjectContentEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForSelectObjectContentEventStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadSelectObjectContentEventStream(eventReader)
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
func (es *SelectObjectContentEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *SelectObjectContentEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}

	es.StreamCloser.Close()
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *SelectObjectContentEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

const opUploadPart = "UploadPart"

// UploadPartRequest generates a "aws/request.Request" representing the
// client's request for the UploadPart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadPart for more information on using the UploadPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UploadPartRequest method.
//	req, resp := client.UploadPartRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPart
func (c *S3) UploadPartRequest(input *UploadPartInput) (req *request.Request, output *UploadPartOutput) {
	op := &request.Operation{
		Name:       opUploadPart,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartInput{}
	}

	output = &UploadPartOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadPart API operation for Amazon Simple Storage Service.
//
// Uploads a part in a multipart upload.
//
// In this operation, you provide part data in your request. However, you have
// an option to specify your existing Amazon S3 object as a data source for
// the part you are uploading. To upload a part from an existing object, you
// use the UploadPartCopy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html)
// operation.
//
// You must initiate a multipart upload (see CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html))
// before you can upload any part. In response to your initiate request, Amazon
// S3 returns an upload ID, a unique identifier, that you must include in your
// upload part request.
//
// Part numbers can be any number from 1 to 10,000, inclusive. A part number
// uniquely identifies a part and also defines its position within the object
// being created. If you upload a new part using the same part number that was
// used with a previous part, the previously uploaded part is overwritten.
//
// For information about maximum and minimum part sizes and other multipart
// upload specifications, see Multipart upload limits (https://docs.aws.amazon.com/AmazonS3/latest/userguide/qfacts.html)
// in the Amazon S3 User Guide.
//
// To ensure that data is not corrupted when traversing the network, specify
// the Content-MD5 header in the upload part request. Amazon S3 checks the part
// data against the provided MD5 value. If they do not match, Amazon S3 returns
// an error.
//
// If the upload request is signed with Signature Version 4, then Amazon Web
// Services S3 uses the x-amz-content-sha256 header as a checksum instead of
// Content-MD5. For more information see Authenticating Requests: Using the
// Authorization Header (Amazon Web Services Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-auth-using-authorization-header.html).
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
//
// For more information on multipart uploads, go to Multipart Upload Overview
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html) in the
// Amazon S3 User Guide .
//
// For information on the permissions required to use the multipart upload API,
// go to Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html)
// in the Amazon S3 User Guide.
//
// You can optionally request server-side encryption where Amazon S3 encrypts
// your data as it writes it to disks in its data centers and decrypts it for
// you when you access it. You have the option of providing your own encryption
// key, or you can use the Amazon Web Services managed encryption keys. If you
// choose to provide your own encryption key, the request headers you provide
// in the request must match the headers you used in the request to initiate
// the upload by using CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html).
// For more information, go to Using Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html)
// in the Amazon S3 User Guide.
//
// Server-side encryption is supported by the S3 Multipart Upload actions. Unless
// you are using a customer-provided encryption key, you don't need to specify
// the encryption parameters in each UploadPart request. Instead, you only need
// to specify the server-side encryption parameters in the initial Initiate
// Multipart request. For more information, see CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html).
//
// If you requested server-side encryption using a customer-provided encryption
// key in your initiate multipart upload request, you must provide identical
// encryption information in each part upload using the following headers.
//
//   - x-amz-server-side-encryption-customer-algorithm
//
//   - x-amz-server-side-encryption-customer-key
//
//   - x-amz-server-side-encryption-customer-key-MD5
//
// Special Errors
//
//   - Code: NoSuchUpload Cause: The specified multipart upload does not exist.
//     The upload ID might be invalid, or the multipart upload might have been
//     aborted or completed. HTTP Status Code: 404 Not Found SOAP Fault Code
//     Prefix: Client
//
// Related Resources
//
//   - CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//   - CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//   - AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//   - ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//   - ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation UploadPart for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPart
func (c *S3) UploadPart(input *UploadPartInput) (*UploadPartOutput, error) {
	req, out := c.UploadPartRequest(input)
	return out, req.Send()
}

// UploadPartWithContext is the same as UploadPart with the addition of
// the ability to pass a context and additional request options.
//
// See UploadPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) UploadPartWithContext(ctx aws.Context, input *UploadPartInput, opts ...request.Option) (*UploadPartOutput, error) {
	req, out := c.UploadPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadPartCopy = "UploadPartCopy"

// UploadPartCopyRequest generates a "aws/request.Request" representing the
// client's request for the UploadPartCopy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadPartCopy for more information on using the UploadPartCopy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UploadPartCopyRequest method.
//	req, resp := client.UploadPartCopyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopy
func (c *S3) UploadPartCopyRequest(input *UploadPartCopyInput) (req *request.Request, output *UploadPartCopyOutput) {
	op := &request.Operation{
		Name:       opUploadPartCopy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartCopyInput{}
	}

	output = &UploadPartCopyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadPartCopy API operation for Amazon Simple Storage Service.
//
// Uploads a part by copying data from an existing object as data source. You
// specify the data source by adding the request header x-amz-copy-source in
// your request and a byte range by adding the request header x-amz-copy-source-range
// in your request.
//
// For information about maximum and minimum part sizes and other multipart
// upload specifications, see Multipart upload limits (https://docs.aws.amazon.com/AmazonS3/latest/userguide/qfacts.html)
// in the Amazon S3 User Guide.
//
// Instead of using an existing object as part data, you might use the UploadPart
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html) action
// and provide data in your request.
//
// You must initiate a multipart upload before you can upload any part. In response
// to your initiate request. Amazon S3 returns a unique identifier, the upload
// ID, that you must include in your upload part request.
//
// For more information about using the UploadPartCopy operation, see the following:
//
//   - For conceptual information about multipart uploads, see Uploading Objects
//     Using Multipart Upload (https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html)
//     in the Amazon S3 User Guide.
//
//   - For information about permissions required to use the multipart upload
//     API, see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html)
//     in the Amazon S3 User Guide.
//
//   - For information about copying objects using a single atomic action vs.
//     a multipart upload, see Operations on Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectOperations.html)
//     in the Amazon S3 User Guide.
//
//   - For information about using server-side encryption with customer-provided
//     encryption keys with the UploadPartCopy operation, see CopyObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html)
//     and UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html).
//
// Note the following additional considerations about the request headers x-amz-copy-source-if-match,
// x-amz-copy-source-if-none-match, x-amz-copy-source-if-unmodified-since, and
// x-amz-copy-source-if-modified-since:
//
//   - Consideration 1 - If both of the x-amz-copy-source-if-match and x-amz-copy-source-if-unmodified-since
//     headers are present in the request as follows: x-amz-copy-source-if-match
//     condition evaluates to true, and; x-amz-copy-source-if-unmodified-since
//     condition evaluates to false; Amazon S3 returns 200 OK and copies the
//     data.
//
//   - Consideration 2 - If both of the x-amz-copy-source-if-none-match and
//     x-amz-copy-source-if-modified-since headers are present in the request
//     as follows: x-amz-copy-source-if-none-match condition evaluates to false,
//     and; x-amz-copy-source-if-modified-since condition evaluates to true;
//     Amazon S3 returns 412 Precondition Failed response code.
//
// # Versioning
//
// If your bucket has versioning enabled, you could have multiple versions of
// the same object. By default, x-amz-copy-source identifies the current version
// of the object to copy. If the current version is a delete marker and you
// don't specify a versionId in the x-amz-copy-source, Amazon S3 returns a 404
// error, because the object does not exist. If you specify versionId in the
// x-amz-copy-source and the versionId is a delete marker, Amazon S3 returns
// an HTTP 400 error, because you are not allowed to specify a delete marker
// as a version for the x-amz-copy-source.
//
// You can optionally specify a specific version of the source object to copy
// by adding the versionId subresource as shown in the following example:
//
// x-amz-copy-source: /bucket/object?versionId=version id
//
// Special Errors
//
//   - Code: NoSuchUpload Cause: The specified multipart upload does not exist.
//     The upload ID might be invalid, or the multipart upload might have been
//     aborted or completed. HTTP Status Code: 404 Not Found
//
//   - Code: InvalidRequest Cause: The specified copy source is not supported
//     as a byte-range copy source. HTTP Status Code: 400 Bad Request
//
// Related Resources
//
//   - CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//   - UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//   - CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//   - AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//   - ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//   - ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation UploadPartCopy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopy
func (c *S3) UploadPartCopy(input *UploadPartCopyInput) (*UploadPartCopyOutput, error) {
	req, out := c.UploadPartCopyRequest(input)
	return out, req.Send()
}

// UploadPartCopyWithContext is the same as UploadPartCopy with the addition of
// the ability to pass a context and additional request options.
//
// See UploadPartCopy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) UploadPartCopyWithContext(ctx aws.Context, input *UploadPartCopyInput, opts ...request.Option) (*UploadPartCopyOutput, error) {
	req, out := c.UploadPartCopyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opWriteGetObjectResponse = "WriteGetObjectResponse"

// WriteGetObjectResponseRequest generates a "aws/request.Request" representing the
// client's request for the WriteGetObjectResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See WriteGetObjectResponse for more information on using the WriteGetObjectResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the WriteGetObjectResponseRequest method.
//	req, resp := client.WriteGetObjectResponseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/WriteGetObjectResponse
func (c *S3) WriteGetObjectResponseRequest(input *WriteGetObjectResponseInput) (req *request.Request, output *WriteGetObjectResponseOutput) {
	op := &request.Operation{
		Name:       opWriteGetObjectResponse,
		HTTPMethod: "POST",
		HTTPPath:   "/WriteGetObjectResponse",
	}

	if input == nil {
		input = &WriteGetObjectResponseInput{}
	}

	output = &WriteGetObjectResponseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Sign.Remove(v4.SignRequestHandler)
	handler := v4.BuildNamedHandler("v4.CustomSignerHandler", v4.WithUnsignedPayload)
	req.Handlers.Sign.PushFrontNamed(handler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{RequestRoute}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// WriteGetObjectResponse API operation for Amazon Simple Storage Service.
//
// Passes transformed objects to a GetObject operation when using Object Lambda
// access points. For information about Object Lambda access points, see Transforming
// objects with Object Lambda access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html)
// in the Amazon S3 User Guide.
//
// This operation supports metadata that can be returned by GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html),
// in addition to RequestRoute, RequestToken, StatusCode, ErrorCode, and ErrorMessage.
// The GetObject response metadata is supported so that the WriteGetObjectResponse
// caller, typically an Lambda function, can provide the same metadata when
// it internally invokes GetObject. When WriteGetObjectResponse is called by
// a customer-owned Lambda function, the metadata returned to the end user GetObject
// call might differ from what Amazon S3 would normally return.
//
// You can include any number of metadata headers. When including a metadata
// header, it should be prefaced with x-amz-meta. For example, x-amz-meta-my-custom-header:
// MyCustomValue. The primary use case for this is to forward GetObject metadata.
//
// Amazon Web Services provides some prebuilt Lambda functions that you can
// use with S3 Object Lambda to detect and redact personally identifiable information
// (PII) and decompress S3 objects. These Lambda functions are available in
// the Amazon Web Services Serverless Application Repository, and can be selected
// through the Amazon Web Services Management Console when you create your Object
// Lambda access point.
//
// Example 1: PII Access Control - This Lambda function uses Amazon Comprehend,
// a natural language processing (NLP) service using machine learning to find
// insights and relationships in text. It automatically detects personally identifiable
// information (PII) such as names, addresses, dates, credit card numbers, and
// social security numbers from documents in your Amazon S3 bucket.
//
// Example 2: PII Redaction - This Lambda function uses Amazon Comprehend, a
// natural language processing (NLP) service using machine learning to find
// insights and relationships in text. It automatically redacts personally identifiable
// information (PII) such as names, addresses, dates, credit card numbers, and
// social security numbers from documents in your Amazon S3 bucket.
//
// Example 3: Decompression - The Lambda function S3ObjectLambdaDecompression,
// is equipped to decompress objects stored in S3 in one of six compressed file
// formats including bzip2, gzip, snappy, zlib, zstandard and ZIP.
//
// For information on how to view and use these functions, see Using Amazon
// Web Services built Lambda functions (https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-examples.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation WriteGetObjectResponse for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/WriteGetObjectResponse
func (c *S3) WriteGetObjectResponse(input *WriteGetObjectResponseInput) (*WriteGetObjectResponseOutput, error) {
	req, out := c.WriteGetObjectResponseRequest(input)
	return out, req.Send()
}

// WriteGetObjectResponseWithContext is the same as WriteGetObjectResponse with the addition of
// the ability to pass a context and additional request options.
//
// See WriteGetObjectResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) WriteGetObjectResponseWithContext(ctx aws.Context, input *WriteGetObjectResponseInput, opts ...request.Option) (*WriteGetObjectResponseOutput, error) {
	req, out := c.WriteGetObjectResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies the days since the initiation of an incomplete multipart upload
// that Amazon S3 will wait before permanently removing all parts of the upload.
// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config)
// in the Amazon S3 User Guide.
type AbortIncompleteMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days after which Amazon S3 aborts an incomplete multipart
	// upload.
	DaysAfterInitiation *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortIncompleteMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortIncompleteMultipartUpload) GoString() string {
	return s.String()
}

// SetDaysAfterInitiation sets the DaysAfterInitiation field's value.
func (s *AbortIncompleteMultipartUpload) SetDaysAfterInitiation(v int64) *AbortIncompleteMultipartUpload {
	s.DaysAfterInitiation = &v
	return s
}

type AbortMultipartUploadInput struct {
	_ struct{} `locationName:"AbortMultipartUploadRequest" type:"structure"`

	// The bucket name to which the upload was taking place.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Key of the object for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Upload ID that identifies the multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *AbortMultipartUploadInput) SetBucket(v string) *AbortMultipartUploadInput {
	s.Bucket = &v
	return s
}

func (s *AbortMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *AbortMultipartUploadInput) SetExpectedBucketOwner(v string) *AbortMultipartUploadInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *AbortMultipartUploadInput) SetKey(v string) *AbortMultipartUploadInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *AbortMultipartUploadInput) SetRequestPayer(v string) *AbortMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *AbortMultipartUploadInput) SetUploadId(v string) *AbortMultipartUploadInput {
	s.UploadId = &v
	return s
}

func (s *AbortMultipartUploadInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *AbortMultipartUploadInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s AbortMultipartUploadInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type AbortMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *AbortMultipartUploadOutput) SetRequestCharged(v string) *AbortMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// Configures the transfer acceleration state for an Amazon S3 bucket. For more
// information, see Amazon S3 Transfer Acceleration (https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html)
// in the Amazon S3 User Guide.
type AccelerateConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the transfer acceleration status of the bucket.
	Status *string `type:"string" enum:"BucketAccelerateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccelerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccelerateConfiguration) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AccelerateConfiguration) SetStatus(v string) *AccelerateConfiguration {
	s.Status = &v
	return s
}

// Contains the elements that set the ACL permissions for an object per grantee.
type AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	// Container for the bucket owner's display name and ID.
	Owner *Owner `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlPolicy"}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrants sets the Grants field's value.
func (s *AccessControlPolicy) SetGrants(v []*Grant) *AccessControlPolicy {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *AccessControlPolicy) SetOwner(v *Owner) *AccessControlPolicy {
	s.Owner = v
	return s
}

// A container for information about access control for replicas.
type AccessControlTranslation struct {
	_ struct{} `type:"structure"`

	// Specifies the replica ownership. For default and valid values, see PUT bucket
	// replication (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html)
	// in the Amazon S3 API Reference.
	//
	// Owner is a required field
	Owner *string `type:"string" required:"true" enum:"OwnerOverride"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlTranslation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlTranslation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlTranslation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlTranslation"}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOwner sets the Owner field's value.
func (s *AccessControlTranslation) SetOwner(v string) *AccessControlTranslation {
	s.Owner = &v
	return s
}

// A conjunction (logical AND) of predicates, which is used in evaluating a
// metrics filter. The operator must have at least two predicates in any combination,
// and an object must match all of the predicates for the filter to apply.
type AnalyticsAndOperator struct {
	_ struct{} `type:"structure"`

	// The prefix to use when evaluating an AND predicate: The prefix that an object
	// must have to be included in the metrics results.
	Prefix *string `type:"string"`

	// The list of tags to use when evaluating an AND predicate.
	Tags []*Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsAndOperator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrefix sets the Prefix field's value.
func (s *AnalyticsAndOperator) SetPrefix(v string) *AnalyticsAndOperator {
	s.Prefix = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AnalyticsAndOperator) SetTags(v []*Tag) *AnalyticsAndOperator {
	s.Tags = v
	return s
}

// Specifies the configuration and any analyses for the analytics filter of
// an Amazon S3 bucket.
type AnalyticsConfiguration struct {
	_ struct{} `type:"structure"`

	// The filter used to describe a set of objects for analyses. A filter must
	// have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator).
	// If no filter is provided, all objects will be considered in any analysis.
	Filter *AnalyticsFilter `type:"structure"`

	// The ID that identifies the analytics configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Contains data related to access patterns to be collected and made available
	// to analyze the tradeoffs between different storage classes.
	//
	// StorageClassAnalysis is a required field
	StorageClassAnalysis *StorageClassAnalysis `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsConfiguration"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.StorageClassAnalysis == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageClassAnalysis"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.StorageClassAnalysis != nil {
		if err := s.StorageClassAnalysis.Validate(); err != nil {
			invalidParams.AddNested("StorageClassAnalysis", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *AnalyticsConfiguration) SetFilter(v *AnalyticsFilter) *AnalyticsConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *AnalyticsConfiguration) SetId(v string) *AnalyticsConfiguration {
	s.Id = &v
	return s
}

// SetStorageClassAnalysis sets the StorageClassAnalysis field's value.
func (s *AnalyticsConfiguration) SetStorageClassAnalysis(v *StorageClassAnalysis) *AnalyticsConfiguration {
	s.StorageClassAnalysis = v
	return s
}

// Where to publish the analytics results.
type AnalyticsExportDestination struct {
	_ struct{} `type:"structure"`

	// A destination signifying output to an S3 bucket.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *AnalyticsS3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsExportDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsExportDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsExportDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsExportDestination"}
	if s.S3BucketDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketDestination sets the S3BucketDestination field's value.
func (s *AnalyticsExportDestination) SetS3BucketDestination(v *AnalyticsS3BucketDestination) *AnalyticsExportDestination {
	s.S3BucketDestination = v
	return s
}

// The filter used to describe a set of objects for analyses. A filter must
// have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator).
// If no filter is provided, all objects will be considered in any analysis.
type AnalyticsFilter struct {
	_ struct{} `type:"structure"`

	// A conjunction (logical AND) of predicates, which is used in evaluating an
	// analytics filter. The operator must have at least two predicates.
	And *AnalyticsAndOperator `type:"structure"`

	// The prefix to use when evaluating an analytics filter.
	Prefix *string `type:"string"`

	// The tag to use when evaluating an analytics filter.
	Tag *Tag `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(request.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnd sets the And field's value.
func (s *AnalyticsFilter) SetAnd(v *AnalyticsAndOperator) *AnalyticsFilter {
	s.And = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *AnalyticsFilter) SetPrefix(v string) *AnalyticsFilter {
	s.Prefix = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *AnalyticsFilter) SetTag(v *Tag) *AnalyticsFilter {
	s.Tag = v
	return s
}

// Contains information about where to publish the analytics results.
type AnalyticsS3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bucket to which data is exported.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The account ID that owns the destination S3 bucket. If no account ID is provided,
	// the owner is not validated before exporting data.
	//
	// Although this value is optional, we strongly recommend that you set it to
	// help prevent problems if the destination bucket ownership changes.
	BucketAccountId *string `type:"string"`

	// Specifies the file format used when exporting data to Amazon S3.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"AnalyticsS3ExportFileFormat"`

	// The prefix to use when exporting data. The prefix is prepended to all results.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsS3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyticsS3BucketDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsS3BucketDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsS3BucketDestination"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *AnalyticsS3BucketDestination) SetBucket(v string) *AnalyticsS3BucketDestination {
	s.Bucket = &v
	return s
}

func (s *AnalyticsS3BucketDestination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBucketAccountId sets the BucketAccountId field's value.
func (s *AnalyticsS3BucketDestination) SetBucketAccountId(v string) *AnalyticsS3BucketDestination {
	s.BucketAccountId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *AnalyticsS3BucketDestination) SetFormat(v string) *AnalyticsS3BucketDestination {
	s.Format = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *AnalyticsS3BucketDestination) SetPrefix(v string) *AnalyticsS3BucketDestination {
	s.Prefix = &v
	return s
}

// In terms of implementation, a Bucket is a resource. An Amazon S3 bucket name
// is globally unique, and the namespace is shared by all Amazon Web Services
// accounts.
type Bucket struct {
	_ struct{} `type:"structure"`

	// Date the bucket was created. This date can change when making changes to
	// your bucket, such as editing its bucket policy.
	CreationDate *time.Time `type:"timestamp"`

	// The name of the bucket.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Bucket) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *Bucket) SetCreationDate(v time.Time) *Bucket {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Bucket) SetName(v string) *Bucket {
	s.Name = &v
	return s
}

// Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
// For more information, see Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// in the Amazon S3 User Guide.
type BucketLifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// A lifecycle rule for individual objects in an Amazon S3 bucket.
	//
	// Rules is a required field
	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BucketLifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BucketLifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLifecycleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketLifecycleConfiguration"}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *BucketLifecycleConfiguration) SetRules(v []*LifecycleRule) *BucketLifecycleConfiguration {
	s.Rules = v
	return s
}

// Container for logging status information.
type BucketLoggingStatus struct {
	_ struct{} `type:"structure"`

	// Describes where logs are stored and the prefix that Amazon S3 assigns to
	// all log object keys for a bucket. For more information, see PUT Bucket logging
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html)
	// in the Amazon S3 API Reference.
	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BucketLoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BucketLoggingStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLoggingStatus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketLoggingStatus"}
	if s.LoggingEnabled != nil {
		if err := s.LoggingEnabled.Validate(); err != nil {
			invalidParams.AddNested("LoggingEnabled", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *BucketLoggingStatus) SetLoggingEnabled(v *LoggingEnabled) *BucketLoggingStatus {
	s.LoggingEnabled = v
	return s
}

// Describes the cross-origin access configuration for objects in an Amazon
// S3 bucket. For more information, see Enabling Cross-Origin Resource Sharing
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the Amazon
// S3 User Guide.
type CORSConfiguration struct {
	_ struct{} `type:"structure"`

	// A set of origins and methods (cross-origin access that you want to allow).
	// You can add up to 100 rules to the configuration.
	//
	// CORSRules is a required field
	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CORSConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CORSConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CORSConfiguration"}
	if s.CORSRules == nil {
		invalidParams.Add(request.NewErrParamRequired("CORSRules"))
	}
	if s.CORSRules != nil {
		for i, v := range s.CORSRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CORSRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCORSRules sets the CORSRules field's value.
func (s *CORSConfiguration) SetCORSRules(v []*CORSRule) *CORSConfiguration {
	s.CORSRules = v
	return s
}

// Specifies a cross-origin access rule for an Amazon S3 bucket.
type CORSRule struct {
	_ struct{} `type:"structure"`

	// Headers that are specified in the Access-Control-Request-Headers header.
	// These headers are allowed in a preflight OPTIONS request. In response to
	// any preflight OPTIONS request, Amazon S3 returns any requested headers that
	// are allowed.
	AllowedHeaders []*string `locationName:"AllowedHeader" type:"list" flattened:"true"`

	// An HTTP method that you allow the origin to execute. Valid values are GET,
	// PUT, HEAD, POST, and DELETE.
	//
	// AllowedMethods is a required field
	AllowedMethods []*string `locationName:"AllowedMethod" type:"list" flattened:"true" required:"true"`

	// One or more origins you want customers to be able to access the bucket from.
	//
	// AllowedOrigins is a required field
	AllowedOrigins []*string `locationName:"AllowedOrigin" type:"list" flattened:"true" required:"true"`

	// One or more headers in the response that you want customers to be able to
	// access from their applications (for example, from a JavaScript XMLHttpRequest
	// object).
	ExposeHeaders []*string `locationName:"ExposeHeader" type:"list" flattened:"true"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// The time in seconds that your browser is to cache the preflight response
	// for the specified resource.
	MaxAgeSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CORSRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CORSRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CORSRule"}
	if s.AllowedMethods == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedMethods"))
	}
	if s.AllowedOrigins == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedOrigins"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedHeaders sets the AllowedHeaders field's value.
func (s *CORSRule) SetAllowedHeaders(v []*string) *CORSRule {
	s.AllowedHeaders = v
	return s
}

// SetAllowedMethods sets the AllowedMethods field's value.
func (s *CORSRule) SetAllowedMethods(v []*string) *CORSRule {
	s.AllowedMethods = v
	return s
}

// SetAllowedOrigins sets the AllowedOrigins field's value.
func (s *CORSRule) SetAllowedOrigins(v []*string) *CORSRule {
	s.AllowedOrigins = v
	return s
}

// SetExposeHeaders sets the ExposeHeaders field's value.
func (s *CORSRule) SetExposeHeaders(v []*string) *CORSRule {
	s.ExposeHeaders = v
	return s
}

// SetID sets the ID field's value.
func (s *CORSRule) SetID(v string) *CORSRule {
	s.ID = &v
	return s
}

// SetMaxAgeSeconds sets the MaxAgeSeconds field's value.
func (s *CORSRule) SetMaxAgeSeconds(v int64) *CORSRule {
	s.MaxAgeSeconds = &v
	return s
}

// Describes how an uncompressed comma-separated values (CSV)-formatted input
// object is formatted.
type CSVInput struct {
	_ struct{} `type:"structure"`

	// Specifies that CSV field values may contain quoted record delimiters and
	// such records should be allowed. Default value is FALSE. Setting this value
	// to TRUE may lower performance.
	AllowQuotedRecordDelimiter *bool `type:"boolean"`

	// A single character used to indicate that a row should be ignored when the
	// character is present at the start of that row. You can specify any character
	// to indicate a comment line.
	Comments *string `type:"string"`

	// A single character used to separate individual fields in a record. You can
	// specify an arbitrary delimiter.
	FieldDelimiter *string `type:"string"`

	// Describes the first line of input. Valid values are:
	//
	//    * NONE: First line is not a header.
	//
	//    * IGNORE: First line is a header, but you can't use the header values
	//    to indicate the column in an expression. You can use column position (such
	//    as _1, _2, …) to indicate the column (SELECT s._1 FROM OBJECT s).
	//
	//    * Use: First line is a header, and you can use the header value to identify
	//    a column in an expression (SELECT "name" FROM OBJECT).
	FileHeaderInfo *string `type:"string" enum:"FileHeaderInfo"`

	// A single character used for escaping when the field delimiter is part of
	// the value. For example, if the value is a, b, Amazon S3 wraps this field
	// value in quotation marks, as follows: " a , b ".
	//
	// Type: String
	//
	// Default: "
	//
	// Ancestors: CSV
	QuoteCharacter *string `type:"string"`

	// A single character used for escaping the quotation mark character inside
	// an already escaped value. For example, the value """ a , b """ is parsed
	// as " a , b ".
	QuoteEscapeCharacter *string `type:"string"`

	// A single character used to separate individual records in the input. Instead
	// of the default value, you can specify an arbitrary delimiter.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CSVInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CSVInput) GoString() string {
	return s.String()
}

// SetAllowQuotedRecordDelimiter sets the AllowQuotedRecordDelimiter field's value.
func (s *CSVInput) SetAllowQuotedRecordDelimiter(v bool) *CSVInput {
	s.AllowQuotedRecordDelimiter = &v
	return s
}

// SetComments sets the Comments field's value.
func (s *CSVInput) SetComments(v string) *CSVInput {
	s.Comments = &v
	return s
}

// SetFieldDelimiter sets the FieldDelimiter field's value.
func (s *CSVInput) SetFieldDelimiter(v string) *CSVInput {
	s.FieldDelimiter = &v
	return s
}

// SetFileHeaderInfo sets the FileHeaderInfo field's value.
func (s *CSVInput) SetFileHeaderInfo(v string) *CSVInput {
	s.FileHeaderInfo = &v
	return s
}

// SetQuoteCharacter sets the QuoteCharacter field's value.
func (s *CSVInput) SetQuoteCharacter(v string) *CSVInput {
	s.QuoteCharacter = &v
	return s
}

// SetQuoteEscapeCharacter sets the QuoteEscapeCharacter field's value.
func (s *CSVInput) SetQuoteEscapeCharacter(v string) *CSVInput {
	s.QuoteEscapeCharacter = &v
	return s
}

// SetRecordDelimiter sets the RecordDelimiter field's value.
func (s *CSVInput) SetRecordDelimiter(v string) *CSVInput {
	s.RecordDelimiter = &v
	return s
}

// Describes how uncompressed comma-separated values (CSV)-formatted results
// are formatted.
type CSVOutput struct {
	_ struct{} `type:"structure"`

	// The value used to separate individual fields in a record. You can specify
	// an arbitrary delimiter.
	FieldDelimiter *string `type:"string"`

	// A single character used for escaping when the field delimiter is part of
	// the value. For example, if the value is a, b, Amazon S3 wraps this field
	// value in quotation marks, as follows: " a , b ".
	QuoteCharacter *string `type:"string"`

	// The single character used for escaping the quote character inside an already
	// escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// Indicates whether to use quotation marks around output fields.
	//
	//    * ALWAYS: Always use quotation marks for output fields.
	//
	//    * ASNEEDED: Use quotation marks for output fields when needed.
	QuoteFields *string `type:"string" enum:"QuoteFields"`

	// A single character used to separate individual records in the output. Instead
	// of the default value, you can specify an arbitrary delimiter.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CSVOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CSVOutput) GoString() string {
	return s.String()
}

// SetFieldDelimiter sets the FieldDelimiter field's value.
func (s *CSVOutput) SetFieldDelimiter(v string) *CSVOutput {
	s.FieldDelimiter = &v
	return s
}

// SetQuoteCharacter sets the QuoteCharacter field's value.
func (s *CSVOutput) SetQuoteCharacter(v string) *CSVOutput {
	s.QuoteCharacter = &v
	return s
}

// SetQuoteEscapeCharacter sets the QuoteEscapeCharacter field's value.
func (s *CSVOutput) SetQuoteEscapeCharacter(v string) *CSVOutput {
	s.QuoteEscapeCharacter = &v
	return s
}

// SetQuoteFields sets the QuoteFields field's value.
func (s *CSVOutput) SetQuoteFields(v string) *CSVOutput {
	s.QuoteFields = &v
	return s
}

// SetRecordDelimiter sets the RecordDelimiter field's value.
func (s *CSVOutput) SetRecordDelimiter(v string) *CSVOutput {
	s.RecordDelimiter = &v
	return s
}

// Contains all the possible checksum or digest values for an object.
type Checksum struct {
	_ struct{} `type:"structure"`

	// The base64-encoded, 32-bit CRC32 checksum of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32 *string `type:"string"`

	// The base64-encoded, 32-bit CRC32C checksum of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32C *string `type:"string"`

	// The base64-encoded, 160-bit SHA-1 digest of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA1 *string `type:"string"`

	// The base64-encoded, 256-bit SHA-256 digest of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA256 *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Checksum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Checksum) GoString() string {
	return s.String()
}

// SetChecksumCRC32 sets the ChecksumCRC32 field's value.
func (s *Checksum) SetChecksumCRC32(v string) *Checksum {
	s.ChecksumCRC32 = &v
	return s
}

// SetChecksumCRC32C sets the ChecksumCRC32C field's value.
func (s *Checksum) SetChecksumCRC32C(v string) *Checksum {
	s.ChecksumCRC32C = &v
	return s
}

// SetChecksumSHA1 sets the ChecksumSHA1 field's value.
func (s *Checksum) SetChecksumSHA1(v string) *Checksum {
	s.ChecksumSHA1 = &v
	return s
}

// SetChecksumSHA256 sets the ChecksumSHA256 field's value.
func (s *Checksum) SetChecksumSHA256(v string) *Checksum {
	s.ChecksumSHA256 = &v
	return s
}

// Container for specifying the Lambda notification configuration.
type CloudFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// Lambda cloud function ARN that Amazon S3 can invoke when it detects events
	// of the specified type.
	CloudFunction *string `type:"string"`

	// The bucket event for which to send notifications.
	//
	// Deprecated: Event has been deprecated
	Event *string `deprecated:"true" type:"string" enum:"Event"`

	// Bucket events for which to send notifications.
	Events []*string `locationName:"Event" type:"list" flattened:"true" enum:"Event"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// The role supporting the invocation of the Lambda function
	InvocationRole *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFunctionConfiguration) GoString() string {
	return s.String()
}

// SetCloudFunction sets the CloudFunction field's value.
func (s *CloudFunctionConfiguration) SetCloudFunction(v string) *CloudFunctionConfiguration {
	s.CloudFunction = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *CloudFunctionConfiguration) SetEvent(v string) *CloudFunctionConfiguration {
	s.Event = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *CloudFunctionConfiguration) SetEvents(v []*string) *CloudFunctionConfiguration {
	s.Events = v
	return s
}

// SetId sets the Id field's value.
func (s *CloudFunctionConfiguration) SetId(v string) *CloudFunctionConfiguration {
	s.Id = &v
	return s
}

// SetInvocationRole sets the InvocationRole field's value.
func (s *CloudFunctionConfiguration) SetInvocationRole(v string) *CloudFunctionConfiguration {
	s.InvocationRole = &v
	return s
}

// Container for all (if there are any) keys between Prefix and the next occurrence
// of the string specified by a delimiter. CommonPrefixes lists keys that act
// like subdirectories in the directory specified by Prefix. For example, if
// the prefix is notes/ and the delimiter is a slash (/) as in notes/summer/july,
// the common prefix is notes/summer/.
type CommonPrefix struct {
	_ struct{} `type:"structure"`

	// Container for the specified common prefix.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommonPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommonPrefix) GoString() string {
	return s.String()
}

// SetPrefix sets the Prefix field's value.
func (s *CommonPrefix) SetPrefix(v string) *CommonPrefix {
	s.Prefix = &v
	return s
}

type CompleteMultipartUploadInput struct {
	_ struct{} `locationName:"CompleteMultipartUploadRequest" type:"structure" payload:"MultipartUpload"`

	// Name of the bucket to which the multipart upload was initiated.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// This header can be used as a data integrity check to verify that the data
	// received is the same data that was originally sent. This header specifies
	// the base64-encoded, 32-bit CRC32 checksum of the object. For more information,
	// see Checking object integrity (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
	// in the Amazon S3 User Guide.
	ChecksumCRC32 *string `location:"header" locationName:"x-amz-checksum-crc32" type:"string"`

	// This header can be used as a data integrity check to verify that the data
	// received is the same data that was originally sent. This header specifies
	// the base64-encoded, 32-bit CRC32C checksum of the object. For more information,
	// see Checking object integrity (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
	// in the Amazon S3 User Guide.
	ChecksumCRC32C *string `location:"header" locationName:"x-amz-checksum-crc32c" type:"string"`

	// This header can be used as a data integrity check to verify that the data
	// received is the same data that was originally sent. This header specifies
	// the base64-encoded, 160-bit SHA-1 digest of the object. For more information,
	// see Checking object integrity (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
	// in the Amazon S3 User Guide.
	ChecksumSHA1 *string `location:"header" locationName:"x-amz-checksum-sha1" type:"string"`

	// This header can be used as a data integrity check to verify that the data
	// received is the same data that was originally sent. This header specifies
	// the base64-encoded, 256-bit SHA-256 digest of the object. For more information,
	// see Checking object integrity (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
	// in the Amazon S3 User Guide.
	ChecksumSHA256 *string `location:"header" locationName:"x-amz-checksum-sha256" type:"string"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Object key for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The container for the multipart upload request information.
	MultipartUpload *CompletedMultipartUpload `locationName:"CompleteMultipartUpload" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// The server-side encryption (SSE) algorithm used to encrypt the object. This
	// parameter is needed only when the object was created using a checksum algorithm.
	// For more information, see Protecting data using SSE-C keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html)
	// in the Amazon S3 User Guide.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// The server-side encryption (SSE) customer managed key. This parameter is
	// needed only when the object was created using a checksum algorithm. For more
	// information, see Protecting data using SSE-C keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html)
	// in the Amazon S3 User Guide.
	//
	// SSECustomerKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CompleteMultipartUploadInput's
	// String and GoString methods.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// The MD5 server-side encryption (SSE) customer managed key. This parameter
	// is needed only when the object was created using a checksum algorithm. For
	// more information, see Protecting data using SSE-C keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html)
	// in the Amazon S3 User Guide.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// ID for the initiated multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *CompleteMultipartUploadInput) SetBucket(v string) *CompleteMultipartUploadInput {
	s.Bucket = &v
	return s
}

func (s *CompleteMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetChecksumCRC32 sets the ChecksumCRC32 field's value.
func (s *CompleteMultipartUploadInput) SetChecksumCRC32(v string) *CompleteMultipartUploadInput {
	s.ChecksumCRC32 = &v
	return s
}

// SetChecksumCRC32C sets the ChecksumCRC32C field's value.
func (s *CompleteMultipartUploadInput) SetChecksumCRC32C(v string) *CompleteMultipartUploadInput {
	s.ChecksumCRC32C = &v
	return s
}

// SetChecksumSHA1 sets the ChecksumSHA1 field's value.
func (s *CompleteMultipartUploadInput) SetChecksumSHA1(v string) *CompleteMultipartUploadInput {
	s.ChecksumSHA1 = &v
	return s
}

// SetChecksumSHA256 sets the ChecksumSHA256 field's value.
func (s *CompleteMultipartUploadInput) SetChecksumSHA256(v string) *CompleteMultipartUploadInput {
	s.ChecksumSHA256 = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *CompleteMultipartUploadInput) SetExpectedBucketOwner(v string) *CompleteMultipartUploadInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CompleteMultipartUploadInput) SetKey(v string) *CompleteMultipartUploadInput {
	s.Key = &v
	return s
}

// SetMultipartUpload sets the MultipartUpload field's value.
func (s *CompleteMultipartUploadInput) SetMultipartUpload(v *CompletedMultipartUpload) *CompleteMultipartUploadInput {
	s.MultipartUpload = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CompleteMultipartUploadInput) SetRequestPayer(v string) *CompleteMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CompleteMultipartUploadInput) SetSSECustomerAlgorithm(v string) *CompleteMultipartUploadInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *CompleteMultipartUploadInput) SetSSECustomerKey(v string) *CompleteMultipartUploadInput {
	s.SSECustomerKey = &v
	return s
}

func (s *CompleteMultipartUploadInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CompleteMultipartUploadInput) SetSSECustomerKeyMD5(v string) *CompleteMultipartUploadInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteMultipartUploadInput) SetUploadId(v string) *CompleteMultipartUploadInput {
	s.UploadId = &v
	return s
}

func (s *CompleteMultipartUploadInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *CompleteMultipartUploadInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s CompleteMultipartUploadInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type CompleteMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket that contains the newly created object. Does not return
	// the access point ARN or access point alias if used.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	Bucket *string `type:"string"`

	// Indicates whether the multipart upload uses an S3 Bucket Key for server-side
	// encryption with Amazon Web Services KMS (SSE-KMS).
	BucketKeyEnabled *bool `location:"header" locationName:"x-amz-server-side-encryption-bucket-key-enabled" type:"boolean"`

	// The base64-encoded, 32-bit CRC32 checksum of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32 *string `type:"string"`

	// The base64-encoded, 32-bit CRC32C checksum of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32C *string `type:"string"`

	// The base64-encoded, 160-bit SHA-1 digest of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA1 *string `type:"string"`

	// The base64-encoded, 256-bit SHA-256 digest of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA256 *string `type:"string"`

	// Entity tag that identifies the newly created object's data. Objects with
	// different object data will have different entity tags. The entity tag is
	// an opaque string. The entity tag may or may not be an MD5 digest of the object
	// data. If the entity tag is not an MD5 digest of the object data, it will
	// contain one or more nonhexadecimal characters and/or will consist of less
	// than 32 or more than 32 hexadecimal digits. For more information about how
	// the entity tag is calculated, see Checking object integrity (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
	// in the Amazon S3 User Guide.
	ETag *string `type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL-encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The object key of the newly created object.
	Key *string `min:"1" type:"string"`

	// The URI that identifies the newly created object.
	Location *string `type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If present, specifies the ID of the Amazon Web Services Key Management Service
	// (Amazon Web Services KMS) symmetric customer managed key that was used for
	// the object.
	//
	// SSEKMSKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CompleteMultipartUploadOutput's
	// String and GoString methods.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// If you specified server-side encryption either with an Amazon S3-managed
	// encryption key or an Amazon Web Services KMS key in your initiate multipart
	// upload request, the response includes this header. It confirms the encryption
	// algorithm that Amazon S3 used to encrypt the object.
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version ID of the newly created object, in case the bucket has versioning
	// turned on.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *CompleteMultipartUploadOutput) SetBucket(v string) *CompleteMultipartUploadOutput {
	s.Bucket = &v
	return s
}

func (s *CompleteMultipartUploadOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBucketKeyEnabled sets the BucketKeyEnabled field's value.
func (s *CompleteMultipartUploadOutput) SetBucketKeyEnabled(v bool) *CompleteMultipartUploadOutput {
	s.BucketKeyEnabled = &v
	return s
}

// SetChecksumCRC32 sets the ChecksumCRC32 field's value.
func (s *CompleteMultipartUploadOutput) SetChecksumCRC32(v string) *CompleteMultipartUploadOutput {
	s.ChecksumCRC32 = &v
	return s
}

// SetChecksumCRC32C sets the ChecksumCRC32C field's value.
func (s *CompleteMultipartUploadOutput) SetChecksumCRC32C(v string) *CompleteMultipartUploadOutput {
	s.ChecksumCRC32C = &v
	return s
}

// SetChecksumSHA1 sets the ChecksumSHA1 field's value.
func (s *CompleteMultipartUploadOutput) SetChecksumSHA1(v string) *CompleteMultipartUploadOutput {
	s.ChecksumSHA1 = &v
	return s
}

// SetChecksumSHA256 sets the ChecksumSHA256 field's value.
func (s *CompleteMultipartUploadOutput) SetChecksumSHA256(v string) *CompleteMultipartUploadOutput {
	s.ChecksumSHA256 = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *CompleteMultipartUploadOutput) SetETag(v string) *CompleteMultipartUploadOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *CompleteMultipartUploadOutput) SetExpiration(v string) *CompleteMultipartUploadOutput {
	s.Expiration = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CompleteMultipartUploadOutput) SetKey(v string) *CompleteMultipartUploadOutput {
	s.Key = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CompleteMultipartUploadOutput) SetLocation(v string) *CompleteMultipartUploadOutput {
	s.Location = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CompleteMultipartUploadOutput) SetRequestCharged(v string) *CompleteMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CompleteMultipartUploadOutput) SetSSEKMSKeyId(v string) *CompleteMultipartUploadOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CompleteMultipartUploadOutput) SetServerSideEncryption(v string) *CompleteMultipartUploadOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CompleteMultipartUploadOutput) SetVersionId(v string) *CompleteMultipartUploadOutput {
	s.VersionId = &v
	return s
}

// The container for the completed multipart upload details.
type CompletedMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Array of CompletedPart data types.
	//
	// If you do not supply a valid Part with your request, the service sends back
	// an HTTP 400 response.
	Parts []*CompletedPart `locationName:"Part" type:"list" flattened:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompletedMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompletedMultipartUpload) GoString() string {
	return s.String()
}

// SetParts sets the Parts field's value.
func (s *CompletedMultipartUpload) SetParts(v []*CompletedPart) *CompletedMultipartUpload {
	s.Parts = v
	return s
}

// Details of the parts that were uploaded.
type CompletedPart struct {
	_ struct{} `type:"structure"`

	// The base64-encoded, 32-bit CRC32 checksum of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32 *string `type:"string"`

	// The base64-encoded, 32-bit CRC32C checksum of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32C *string `type:"string"`

	// The base64-encoded, 160-bit SHA-1 digest of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA1 *string `type:"string"`

	// The base64-encoded, 256-bit SHA-256 digest of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA256 *string `type:"string"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Part number that identifies the part. This is a positive integer between
	// 1 and 10,000.
	PartNumber *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompletedPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompletedPart) GoString() string {
	return s.String()
}

// SetChecksumCRC32 sets the ChecksumCRC32 field's value.
func (s *CompletedPart) SetChecksumCRC32(v string) *CompletedPart {
	s.ChecksumCRC32 = &v
	return s
}

// SetChecksumCRC32C sets the ChecksumCRC32C field's value.
func (s *CompletedPart) SetChecksumCRC32C(v string) *CompletedPart {
	s.ChecksumCRC32C = &v
	return s
}

// SetChecksumSHA1 sets the ChecksumSHA1 field's value.
func (s *CompletedPart) SetChecksumSHA1(v string) *CompletedPart {
	s.ChecksumSHA1 = &v
	return s
}

// SetChecksumSHA256 sets the ChecksumSHA256 field's value.
func (s *CompletedPart) SetChecksumSHA256(v string) *CompletedPart {
	s.ChecksumSHA256 = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *CompletedPart) SetETag(v string) *CompletedPart {
	s.ETag = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *CompletedPart) SetPartNumber(v int64) *CompletedPart {
	s.PartNumber = &v
	return s
}

// A container for describing a condition that must be met for the specified
// redirect to apply. For example, 1. If request is for pages in the /docs folder,
// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
// redirect request to another host where you might process the error.
type Condition struct {
	_ struct{} `type:"structure"`

	// The HTTP error code when the redirect is applied. In the event of an error,
	// if the error code equals this value, then the specified redirect is applied.
	// Required when parent element Condition is specified and sibling KeyPrefixEquals
	// is not specified. If both are specified, then both must be true for the redirect
	// to be applied.
	HttpErrorCodeReturnedEquals *string `type:"string"`

	// The object key name prefix when the redirect is applied. For example, to
	// redirect requests for ExamplePage.html, the key prefix will be ExamplePage.html.
	// To redirect request for all pages with the prefix docs/, the key prefix will
	// be /docs, which identifies all objects in the docs/ folder. Required when
	// the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals
	// is not specified. If both conditions are specified, both must be true for
	// the redirect to be applied.
	//
	// Replacement must be made for object keys containing special characters (such
	// as carriage returns) when using XML requests. For more information, see XML
	// related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	KeyPrefixEquals *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) GoString() string {
	return s.String()
}

// SetHttpErrorCodeReturnedEquals sets the HttpErrorCodeReturnedEquals field's value.
func (s *Condition) SetHttpErrorCodeReturnedEquals(v string) *Condition {
	s.HttpErrorCodeReturnedEquals = &v
	return s
}

// SetKeyPrefixEquals sets the KeyPrefixEquals field's value.
func (s *Condition) SetKeyPrefixEquals(v string) *Condition {
	s.KeyPrefixEquals = &v
	return s
}

type ContinuationEvent struct {
	_ struct{} `locationName:"ContinuationEvent" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContinuationEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContinuationEvent) GoString() string {
	return s.String()
}

// The ContinuationEvent is and event in the SelectObjectContentEventStream group of events.
func (s *ContinuationEvent) eventSelectObjectContentEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ContinuationEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ContinuationEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ContinuationEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	return msg, err
}

type CopyObjectInput struct {
	_ struct{} `locationName:"CopyObjectRequest" type:"structure"`

	// The canned ACL to apply to the object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// The name of the destination bucket.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption
	// with server-side encryption using AWS KMS (SSE-KMS). Setting this header
	// to true causes Amazon S3 to use an S3 Bucket Key for object encryption with
	// SSE-KMS.
	//
	// Specifying this header with a COPY action doesn’t affect bucket-level settings
	// for S3 Bucket Key.
	BucketKeyEnabled *bool `location:"header" locationName:"x-amz-server-side-encryption-bucket-key-enabled" type:"boolean"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Indicates the algorithm you want Amazon S3 to use to create the checksum
	// for the object. For more information, see Checking object integrity (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
	// in the Amazon S3 User Guide.
	ChecksumAlgorithm *string `location:"header" locationName:"x-amz-checksum-algorithm" type:"string" enum:"ChecksumAlgorithm"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies the source object for the copy operation. You specify the value
	// in one of two formats, depending on whether you want to access the source
	// object through an access point (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html):
	//
	//    * For objects not accessed through an access point, specify the name of
	//    the source bucket and the key of the source object, separated by a slash
	//    (/). For example, to copy the object reports/january.pdf from the bucket
	//    awsexamplebucket, use awsexamplebucket/reports/january.pdf. The value
	//    must be URL-encoded.
	//
	//    * For objects accessed through access points, specify the Amazon Resource
	//    Name (ARN) of the object as accessed through the access point, in the
	//    format arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>.
	//    For example, to copy the object reports/january.pdf through access point
	//    my-access-point owned by account 123456789012 in Region us-west-2, use
	//    the URL encoding of arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf.
	//    The value must be URL encoded. Amazon S3 supports copy operations using
	//    access points only when the source and destination buckets are in the
	//    same Amazon Web Services Region. Alternatively, for objects accessed through
	//    Amazon S3 on Outposts, specify the ARN of the object as accessed in the
	//    format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>.
	//    For example, to copy the object reports/january.pdf through outpost my-outpost
	//    owned by account 123456789012 in Region us-west-2, use the URL encoding
	//    of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf.
	//    The value must be URL-encoded.
	//
	// To copy a specific version of an object, append ?versionId=<version-id> to
	// the value (for example, awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893).
	// If you don't specify a version ID, Amazon S3 copies the latest version of
	// the source object.
	//
	// CopySource is a required field
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp"`

	// Specifies the algorithm to use when decrypting the source object (for example,
	// AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	//
	// CopySourceSSECustomerKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CopyObjectInput's
	// String and GoString methods.
	CopySourceSSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// The account ID of the expected destination bucket owner. If the destination
	// bucket is owned by a different account, the request fails with the HTTP status
	// code 403 Forbidden (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The account ID of the expected source bucket owner. If the source bucket
	// is owned by a different account, the request fails with the HTTP status code
	// 403 Forbidden (access denied).
	ExpectedSourceBucketOwner *string `location:"header" locationName:"x-amz-source-expected-bucket-owner" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// The key of the destination object.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Specifies whether the metadata is copied from the source object or replaced
	// with metadata provided in the request.
	MetadataDirective *string `location:"header" locationName:"x-amz-metadata-directive" type:"string" enum:"MetadataDirective"`

	// Specifies whether you want to apply a legal hold to the copied object.
	ObjectLockLegalHoldStatus *string `location:"header" locationName:"x-amz-object-lock-legal-hold" type:"string" enum:"ObjectLockLegalHoldStatus"`

	// The Object Lock mode that you want to apply to the copied object.
	ObjectLockMode *string `location:"header" locationName:"x-amz-object-lock-mode" type:"string" enum:"ObjectLockMode"`

	// The date and time when you want the copied object's Object Lock to expire.
	ObjectLockRetainUntilDate *time.Time `location:"header" locationName:"x-amz-object-lock-retain-until-date" type:"timestamp" timestampFormat:"iso8601"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	//
	// SSECustomerKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CopyObjectInput's
	// String and GoString methods.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the Amazon Web Services KMS Encryption Context to use for object
	// encryption. The value of this header is a base64-encoded UTF-8 string holding
	// JSON with the encryption context key-value pairs.
	//
	// SSEKMSEncryptionContext is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CopyObjectInput's
	// String and GoString methods.
	SSEKMSEncryptionContext *string `location:"header" locationName:"x-amz-server-side-encryption-context" type:"string" sensitive:"true"`

	// Specifies the Amazon Web Services KMS key ID to use for object encryption.
	// All GET and PUT requests for an object protected by Amazon Web Services KMS
	// will fail if not made via SSL or using SigV4. For information about configuring
	// using any of the officially supported Amazon Web Services SDKs and Amazon
	// Web Services CLI, see Specifying the Signature Version in Request Authentication
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version)
	// in the Amazon S3 User Guide.
	//
	// SSEKMSKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CopyObjectInput's
	// String and GoString methods.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// By default, Amazon S3 uses the STANDARD Storage Class to store newly created
	// objects. The STANDARD storage class provides high durability and high availability.
	// Depending on performance needs, you can specify a different Storage Class.
	// Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information,
	// see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html)
	// in the Amazon S3 User Guide.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The tag-set for the object destination object this value must be used in
	// conjunction with the TaggingDirective. The tag-set must be encoded as URL
	// Query parameters.
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// Specifies whether the object tag-set are copied from the source object or
	// replaced with tag-set provided in the request.
	TaggingDirective *string `location:"header" locationName:"x-amz-tagging-directive" type:"string" enum:"TaggingDirective"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.CopySource == nil {
		invalidParams.Add(request.NewErrParamRequired("CopySource"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CopyObjectInput) SetACL(v string) *CopyObjectInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CopyObjectInput) SetBucket(v string) *CopyObjectInput {
	s.Bucket = &v
	return s
}

func (s *CopyObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBucketKeyEnabled sets the BucketKeyEnabled field's value.
func (s *CopyObjectInput) SetBucketKeyEnabled(v bool) *CopyObjectInput {
	s.BucketKeyEnabled = &v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *CopyObjectInput) SetCacheControl(v string) *CopyObjectInput {
	s.CacheControl = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *CopyObjectInput) SetChecksumAlgorithm(v string) *CopyObjectInput {
	s.ChecksumAlgorithm = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *CopyObjectInput) SetContentDisposition(v string) *CopyObjectInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *CopyObjectInput) SetContentEncoding(v string) *CopyObjectInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *CopyObjectInput) SetContentLanguage(v string) *CopyObjectInput {
	s.ContentLanguage = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CopyObjectInput) SetContentType(v string) *CopyObjectInput {
	s.ContentType = &v
	return s
}

// SetCopySource sets the CopySource field's value.
func (s *CopyObjectInput) SetCopySource(v string) *CopyObjectInput {
	s.CopySource = &v
	return s
}

// SetCopySourceIfMatch sets the CopySourceIfMatch field's value.
func (s *CopyObjectInput) SetCopySourceIfMatch(v string) *CopyObjectInput {
	s.CopySourceIfMatch = &v
	return s
}

// SetCopySourceIfModifiedSince sets the CopySourceIfModifiedSince field's value.
func (s *CopyObjectInput) SetCopySourceIfModifiedSince(v time.Time) *CopyObjectInput {
	s.CopySourceIfModifiedSince = &v
	return s
}

// SetCopySourceIfNoneMatch sets the CopySourceIfNoneMatch field's value.
func (s *CopyObjectInput) SetCopySourceIfNoneMatch(v string) *CopyObjectInput {
	s.CopySourceIfNoneMatch = &v
	return s
}

// SetCopySourceIfUnmodifiedSince sets the CopySourceIfUnmodifiedSince field's value.
func (s *CopyObjectInput) SetCopySourceIfUnmodifiedSince(v time.Time) *CopyObjectInput {
	s.CopySourceIfUnmodifiedSince = &v
	return s
}

// SetCopySourceSSECustomerAlgorithm sets the CopySourceSSECustomerAlgorithm field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerAlgorithm(v string) *CopyObjectInput {
	s.CopySourceSSECustomerAlgorithm = &v
	return s
}

// SetCopySourceSSECustomerKey sets the CopySourceSSECustomerKey field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerKey(v string) *CopyObjectInput {
	s.CopySourceSSECustomerKey = &v
	return s
}

func (s *CopyObjectInput) getCopySourceSSECustomerKey() (v string) {
	if s.CopySourceSSECustomerKey == nil {
		return v
	}
	return *s.CopySourceSSECustomerKey
}

// SetCopySourceSSECustomerKeyMD5 sets the CopySourceSSECustomerKeyMD5 field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerKeyMD5(v string) *CopyObjectInput {
	s.CopySourceSSECustomerKeyMD5 = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *CopyObjectInput) SetExpectedBucketOwner(v string) *CopyObjectInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetExpectedSourceBucketOwner sets the ExpectedSourceBucketOwner field's value.
func (s *CopyObjectInput) SetExpectedSourceBucketOwner(v string) *CopyObjectInput {
	s.ExpectedSourceBucketOwner = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *CopyObjectInput) SetExpires(v time.Time) *CopyObjectInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CopyObjectInput) SetGrantFullControl(v string) *CopyObjectInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CopyObjectInput) SetGrantRead(v string) *CopyObjectInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CopyObjectInput) SetGrantReadACP(v string) *CopyObjectInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CopyObjectInput) SetGrantWriteACP(v string) *CopyObjectInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CopyObjectInput) SetKey(v string) *CopyObjectInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CopyObjectInput) SetMetadata(v map[string]*string) *CopyObjectInput {
	s.Metadata = v
	return s
}

// SetMetadataDirective sets the MetadataDirective field's value.
func (s *CopyObjectInput) SetMetadataDirective(v string) *CopyObjectInput {
	s.MetadataDirective = &v
	return s
}

// SetObjectLockLegalHoldStatus sets the ObjectLockLegalHoldStatus field's value.
func (s *CopyObjectInput) SetObjectLockLegalHoldStatus(v string) *CopyObjectInput {
	s.ObjectLockLegalHoldStatus = &v
	return s
}

// SetObjectLockMode sets the ObjectLockMode field's value.
func (s *CopyObjectInput) SetObjectLockMode(v string) *CopyObjectInput {
	s.ObjectLockMode = &v
	return s
}

// SetObjectLockRetainUntilDate sets the ObjectLockRetainUntilDate field's value.
func (s *CopyObjectInput) SetObjectLockRetainUntilDate(v time.Time) *CopyObjectInput {
	s.ObjectLockRetainUntilDate = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CopyObjectInput) SetRequestPayer(v string) *CopyObjectInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CopyObjectInput) SetSSECustomerAlgorithm(v string) *CopyObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *CopyObjectInput) SetSSECustomerKey(v string) *CopyObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *CopyObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CopyObjectInput) SetSSECustomerKeyMD5(v string) *CopyObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSEncryptionContext sets the SSEKMSEncryptionContext field's value.
func (s *CopyObjectInput) SetSSEKMSEncryptionContext(v string) *CopyObjectInput {
	s.SSEKMSEncryptionContext = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CopyObjectInput) SetSSEKMSKeyId(v string) *CopyObjectInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CopyObjectInput) SetServerSideEncryption(v string) *CopyObjectInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *CopyObjectInput) SetStorageClass(v string) *CopyObjectInput {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *CopyObjectInput) SetTagging(v string) *CopyObjectInput {
	s.Tagging = &v
	return s
}

// SetTaggingDirective sets the TaggingDirective field's value.
func (s *CopyObjectInput) SetTaggingDirective(v string) *CopyObjectInput {
	s.TaggingDirective = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *CopyObjectInput) SetWebsiteRedirectLocation(v string) *CopyObjectInput {
	s.WebsiteRedirectLocation = &v
	return s
}

func (s *CopyObjectInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *CopyObjectInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s CopyObjectInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type CopyObjectOutput struct {
	_ struct{} `type:"structure" payload:"CopyObjectResult"`

	// Indicates whether the copied object uses an S3 Bucket Key for server-side
	// encryption with Amazon Web Services KMS (SSE-KMS).
	BucketKeyEnabled *bool `location:"header" locationName:"x-amz-server-side-encryption-bucket-key-enabled" type:"boolean"`

	// Container for all response elements.
	CopyObjectResult *CopyObjectResult `type:"structure"`

	// Version of the copied object in the destination bucket.
	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If the object expiration is configured, the response includes this header.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the Amazon Web Services KMS Encryption Context to use
	// for object encryption. The value of this header is a base64-encoded UTF-8
	// string holding JSON with the encryption context key-value pairs.
	//
	// SSEKMSEncryptionContext is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CopyObjectOutput's
	// String and GoString methods.
	SSEKMSEncryptionContext *string `location:"header" locationName:"x-amz-server-side-encryption-context" type:"string" sensitive:"true"`

	// If present, specifies the ID of the Amazon Web Services Key Management Service
	// (Amazon Web Services KMS) symmetric customer managed key that was used for
	// the object.
	//
	// SSEKMSKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CopyObjectOutput's
	// String and GoString methods.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version ID of the newly created copy.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyObjectOutput) GoString() string {
	return s.String()
}

// SetBucketKeyEnabled sets the BucketKeyEnabled field's value.
func (s *CopyObjectOutput) SetBucketKeyEnabled(v bool) *CopyObjectOutput {
	s.BucketKeyEnabled = &v
	return s
}

// SetCopyObjectResult sets the CopyObjectResult field's value.
func (s *CopyObjectOutput) SetCopyObjectResult(v *CopyObjectResult) *CopyObjectOutput {
	s.CopyObjectResult = v
	return s
}

// SetCopySourceVersionId sets the CopySourceVersionId field's value.
func (s *CopyObjectOutput) SetCopySourceVersionId(v string) *CopyObjectOutput {
	s.CopySourceVersionId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *CopyObjectOutput) SetExpiration(v string) *CopyObjectOutput {
	s.Expiration = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CopyObjectOutput) SetRequestCharged(v string) *CopyObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CopyObjectOutput) SetSSECustomerAlgorithm(v string) *CopyObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CopyObjectOutput) SetSSECustomerKeyMD5(v string) *CopyObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSEncryptionContext sets the SSEKMSEncryptionContext field's value.
func (s *CopyObjectOutput) SetSSEKMSEncryptionContext(v string) *CopyObjectOutput {
	s.SSEKMSEncryptionContext = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CopyObjectOutput) SetSSEKMSKeyId(v string) *CopyObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CopyObjectOutput) SetServerSideEncryption(v string) *CopyObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CopyObjectOutput) SetVersionId(v string) *CopyObjectOutput {
	s.VersionId = &v
	return s
}

// Container for all response elements.
type CopyObjectResult struct {
	_ struct{} `type:"structure"`

	// The base64-encoded, 32-bit CRC32 checksum of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32 *string `type:"string"`

	// The base64-encoded, 32-bit CRC32C checksum of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32C *string `type:"string"`

	// The base64-encoded, 160-bit SHA-1 digest of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA1 *string `type:"string"`

	// The base64-encoded, 256-bit SHA-256 digest of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA256 *string `type:"string"`

	// Returns the ETag of the new object. The ETag reflects only changes to the
	// contents of an object, not its metadata.
	ETag *string `type:"string"`

	// Creation date of the object.
	LastModified *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyObjectResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyObjectResult) GoString() string {
	return s.String()
}

// SetChecksumCRC32 sets the ChecksumCRC32 field's value.
func (s *CopyObjectResult) SetChecksumCRC32(v string) *CopyObjectResult {
	s.ChecksumCRC32 = &v
	return s
}

// SetChecksumCRC32C sets the ChecksumCRC32C field's value.
func (s *CopyObjectResult) SetChecksumCRC32C(v string) *CopyObjectResult {
	s.ChecksumCRC32C = &v
	return s
}

// SetChecksumSHA1 sets the ChecksumSHA1 field's value.
func (s *CopyObjectResult) SetChecksumSHA1(v string) *CopyObjectResult {
	s.ChecksumSHA1 = &v
	return s
}

// SetChecksumSHA256 sets the ChecksumSHA256 field's value.
func (s *CopyObjectResult) SetChecksumSHA256(v string) *CopyObjectResult {
	s.ChecksumSHA256 = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *CopyObjectResult) SetETag(v string) *CopyObjectResult {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CopyObjectResult) SetLastModified(v time.Time) *CopyObjectResult {
	s.LastModified = &v
	return s
}

// Container for all response elements.
type CopyPartResult struct {
	_ struct{} `type:"structure"`

	// The base64-encoded, 32-bit CRC32 checksum of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32 *string `type:"string"`

	// The base64-encoded, 32-bit CRC32C checksum of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32C *string `type:"string"`

	// The base64-encoded, 160-bit SHA-1 digest of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA1 *string `type:"string"`

	// The base64-encoded, 256-bit SHA-256 digest of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA256 *string `type:"string"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// Date and time at which the object was uploaded.
	LastModified *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyPartResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyPartResult) GoString() string {
	return s.String()
}

// SetChecksumCRC32 sets the ChecksumCRC32 field's value.
func (s *CopyPartResult) SetChecksumCRC32(v string) *CopyPartResult {
	s.ChecksumCRC32 = &v
	return s
}

// SetChecksumCRC32C sets the ChecksumCRC32C field's value.
func (s *CopyPartResult) SetChecksumCRC32C(v string) *CopyPartResult {
	s.ChecksumCRC32C = &v
	return s
}

// SetChecksumSHA1 sets the ChecksumSHA1 field's value.
func (s *CopyPartResult) SetChecksumSHA1(v string) *CopyPartResult {
	s.ChecksumSHA1 = &v
	return s
}

// SetChecksumSHA256 sets the ChecksumSHA256 field's value.
func (s *CopyPartResult) SetChecksumSHA256(v string) *CopyPartResult {
	s.ChecksumSHA256 = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *CopyPartResult) SetETag(v string) *CopyPartResult {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CopyPartResult) SetLastModified(v time.Time) *CopyPartResult {
	s.LastModified = &v
	return s
}

// The configuration information for the bucket.
type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the Region where the bucket will be created. If you don't specify
	// a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1).
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketConfiguration) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *CreateBucketConfiguration) SetLocationConstraint(v string) *CreateBucketConfiguration {
	s.LocationConstraint = &v
	return s
}

type CreateBucketInput struct {
	_ struct{} `locationName:"CreateBucketRequest" type:"structure" payload:"CreateBucketConfiguration"`

	// The canned ACL to apply to the bucket.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	// The name of the bucket to create.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The configuration information for the bucket.
	CreateBucketConfiguration *CreateBucketConfiguration `locationName:"CreateBucketConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create new objects in the bucket.
	//
	// For the bucket and object owners of existing objects, also allows deletions
	// and overwrites of those objects.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Specifies whether you want S3 Object Lock to be enabled for the new bucket.
	ObjectLockEnabledForBucket *bool `location:"header" locationName:"x-amz-bucket-object-lock-enabled" type:"boolean"`

	// The container element for object ownership for a bucket's ownership controls.
	//
	// BucketOwnerPreferred - Objects uploaded to the bucket change ownership to
	// the bucket owner if the objects are uploaded with the bucket-owner-full-control
	// canned ACL.
	//
	// ObjectWriter - The uploading account will own the object if the object is
	// uploaded with the bucket-owner-full-control canned ACL.
	//
	// BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer
	// affect permissions. The bucket owner automatically owns and has full control
	// over every object in the bucket. The bucket only accepts PUT requests that
	// don't specify an ACL or bucket owner full control ACLs, such as the bucket-owner-full-control
	// canned ACL or an equivalent form of this ACL expressed in the XML format.
	ObjectOwnership *string `location:"header" locationName:"x-amz-object-ownership" type:"string" enum:"ObjectOwnership"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateBucketInput) SetACL(v string) *CreateBucketInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateBucketInput) SetBucket(v string) *CreateBucketInput {
	s.Bucket = &v
	return s
}

func (s *CreateBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCreateBucketConfiguration sets the CreateBucketConfiguration field's value.
func (s *CreateBucketInput) SetCreateBucketConfiguration(v *CreateBucketConfiguration) *CreateBucketInput {
	s.CreateBucketConfiguration = v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateBucketInput) SetGrantFullControl(v string) *CreateBucketInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateBucketInput) SetGrantRead(v string) *CreateBucketInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateBucketInput) SetGrantReadACP(v string) *CreateBucketInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *CreateBucketInput) SetGrantWrite(v string) *CreateBucketInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateBucketInput) SetGrantWriteACP(v string) *CreateBucketInput {
	s.GrantWriteACP = &v
	return s
}

// SetObjectLockEnabledForBucket sets the ObjectLockEnabledForBucket field's value.
func (s *CreateBucketInput) SetObjectLockEnabledForBucket(v bool) *CreateBucketInput {
	s.ObjectLockEnabledForBucket = &v
	return s
}

// SetObjectOwnership sets the ObjectOwnership field's value.
func (s *CreateBucketInput) SetObjectOwnership(v string) *CreateBucketInput {
	s.ObjectOwnership = &v
	return s
}

type CreateBucketOutput struct {
	_ struct{} `type:"structure"`

	// A forward slash followed by the name of the bucket.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateBucketOutput) SetLocation(v string) *CreateBucketOutput {
	s.Location = &v
	return s
}

type CreateMultipartUploadInput struct {
	_ struct{} `locationName:"CreateMultipartUploadRequest" type:"structure"`

	// The canned ACL to apply to the object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// The name of the bucket to which to initiate the upload
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption
	// with server-side encryption using AWS KMS (SSE-KMS). Setting this header
	// to true causes Amazon S3 to use an S3 Bucket Key for object encryption with
	// SSE-KMS.
	//
	// Specifying this header with an object action doesn’t affect bucket-level
	// settings for S3 Bucket Key.
	BucketKeyEnabled *bool `location:"header" locationName:"x-amz-server-side-encryption-bucket-key-enabled" type:"boolean"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Indicates the algorithm you want Amazon S3 to use to create the checksum
	// for the object. For more information, see Checking object integrity (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
	// in the Amazon S3 User Guide.
	ChecksumAlgorithm *string `location:"header" locationName:"x-amz-checksum-algorithm" type:"string" enum:"ChecksumAlgorithm"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Object key for which the multipart upload is to be initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Specifies whether you want to apply a legal hold to the uploaded object.
	ObjectLockLegalHoldStatus *string `location:"header" locationName:"x-amz-object-lock-legal-hold" type:"string" enum:"ObjectLockLegalHoldStatus"`

	// Specifies the Object Lock mode that you want to apply to the uploaded object.
	ObjectLockMode *string `location:"header" locationName:"x-amz-object-lock-mode" type:"string" enum:"ObjectLockMode"`

	// Specifies the date and time when you want the Object Lock to expire.
	ObjectLockRetainUntilDate *time.Time `location:"header" locationName:"x-amz-object-lock-retain-until-date" type:"timestamp" timestampFormat:"iso8601"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	//
	// SSECustomerKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMultipartUploadInput's
	// String and GoString methods.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the Amazon Web Services KMS Encryption Context to use for object
	// encryption. The value of this header is a base64-encoded UTF-8 string holding
	// JSON with the encryption context key-value pairs.
	//
	// SSEKMSEncryptionContext is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMultipartUploadInput's
	// String and GoString methods.
	SSEKMSEncryptionContext *string `location:"header" locationName:"x-amz-server-side-encryption-context" type:"string" sensitive:"true"`

	// Specifies the ID of the symmetric customer managed key to use for object
	// encryption. All GET and PUT requests for an object protected by Amazon Web
	// Services KMS will fail if not made via SSL or using SigV4. For information
	// about configuring using any of the officially supported Amazon Web Services
	// SDKs and Amazon Web Services CLI, see Specifying the Signature Version in
	// Request Authentication (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version)
	// in the Amazon S3 User Guide.
	//
	// SSEKMSKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMultipartUploadInput's
	// String and GoString methods.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// By default, Amazon S3 uses the STANDARD Storage Class to store newly created
	// objects. The STANDARD storage class provides high durability and high availability.
	// Depending on performance needs, you can specify a different Storage Class.
	// Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information,
	// see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html)
	// in the Amazon S3 User Guide.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The tag-set for the object. The tag-set must be encoded as URL Query parameters.
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateMultipartUploadInput) SetACL(v string) *CreateMultipartUploadInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateMultipartUploadInput) SetBucket(v string) *CreateMultipartUploadInput {
	s.Bucket = &v
	return s
}

func (s *CreateMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBucketKeyEnabled sets the BucketKeyEnabled field's value.
func (s *CreateMultipartUploadInput) SetBucketKeyEnabled(v bool) *CreateMultipartUploadInput {
	s.BucketKeyEnabled = &v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *CreateMultipartUploadInput) SetCacheControl(v string) *CreateMultipartUploadInput {
	s.CacheControl = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *CreateMultipartUploadInput) SetChecksumAlgorithm(v string) *CreateMultipartUploadInput {
	s.ChecksumAlgorithm = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *CreateMultipartUploadInput) SetContentDisposition(v string) *CreateMultipartUploadInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *CreateMultipartUploadInput) SetContentEncoding(v string) *CreateMultipartUploadInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *CreateMultipartUploadInput) SetContentLanguage(v string) *CreateMultipartUploadInput {
	s.ContentLanguage = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CreateMultipartUploadInput) SetContentType(v string) *CreateMultipartUploadInput {
	s.ContentType = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *CreateMultipartUploadInput) SetExpectedBucketOwner(v string) *CreateMultipartUploadInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *CreateMultipartUploadInput) SetExpires(v time.Time) *CreateMultipartUploadInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateMultipartUploadInput) SetGrantFullControl(v string) *CreateMultipartUploadInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateMultipartUploadInput) SetGrantRead(v string) *CreateMultipartUploadInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateMultipartUploadInput) SetGrantReadACP(v string) *CreateMultipartUploadInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateMultipartUploadInput) SetGrantWriteACP(v string) *CreateMultipartUploadInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CreateMultipartUploadInput) SetKey(v string) *CreateMultipartUploadInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateMultipartUploadInput) SetMetadata(v map[string]*string) *CreateMultipartUploadInput {
	s.Metadata = v
	return s
}

// SetObjectLockLegalHoldStatus sets the ObjectLockLegalHoldStatus field's value.
func (s *CreateMultipartUploadInput) SetObjectLockLegalHoldStatus(v string) *CreateMultipartUploadInput {
	s.ObjectLockLegalHoldStatus = &v
	return s
}

// SetObjectLockMode sets the ObjectLockMode field's value.
func (s *CreateMultipartUploadInput) SetObjectLockMode(v string) *CreateMultipartUploadInput {
	s.ObjectLockMode = &v
	return s
}

// SetObjectLockRetainUntilDate sets the ObjectLockRetainUntilDate field's value.
func (s *CreateMultipartUploadInput) SetObjectLockRetainUntilDate(v time.Time) *CreateMultipartUploadInput {
	s.ObjectLockRetainUntilDate = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CreateMultipartUploadInput) SetRequestPayer(v string) *CreateMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerAlgorithm(v string) *CreateMultipartUploadInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerKey(v string) *CreateMultipartUploadInput {
	s.SSECustomerKey = &v
	return s
}

func (s *CreateMultipartUploadInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerKeyMD5(v string) *CreateMultipartUploadInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSEncryptionContext sets the SSEKMSEncryptionContext field's value.
func (s *CreateMultipartUploadInput) SetSSEKMSEncryptionContext(v string) *CreateMultipartUploadInput {
	s.SSEKMSEncryptionContext = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CreateMultipartUploadInput) SetSSEKMSKeyId(v string) *CreateMultipartUploadInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CreateMultipartUploadInput) SetServerSideEncryption(v string) *CreateMultipartUploadInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *CreateMultipartUploadInput) SetStorageClass(v string) *CreateMultipartUploadInput {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *CreateMultipartUploadInput) SetTagging(v string) *CreateMultipartUploadInput {
	s.Tagging = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *CreateMultipartUploadInput) SetWebsiteRedirectLocation(v string) *CreateMultipartUploadInput {
	s.WebsiteRedirectLocation = &v
	return s
}

func (s *CreateMultipartUploadInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *CreateMultipartUploadInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s CreateMultipartUploadInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type CreateMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// If the bucket has a lifecycle rule configured with an action to abort incomplete
	// multipart uploads and the prefix in the lifecycle rule matches the object
	// name in the request, the response includes this header. The header indicates
	// when the initiated multipart upload becomes eligible for an abort operation.
	// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
	// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config).
	//
	// The response also includes the x-amz-abort-rule-id header that provides the
	// ID of the lifecycle configuration rule that defines this action.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp"`

	// This header is returned along with the x-amz-abort-date header. It identifies
	// the applicable lifecycle configuration rule that defines the action to abort
	// incomplete multipart uploads.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// The name of the bucket to which the multipart upload was initiated. Does
	// not return the access point ARN or access point alias if used.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	Bucket *string `locationName:"Bucket" type:"string"`

	// Indicates whether the multipart upload uses an S3 Bucket Key for server-side
	// encryption with Amazon Web Services KMS (SSE-KMS).
	BucketKeyEnabled *bool `location:"header" locationName:"x-amz-server-side-encryption-bucket-key-enabled" type:"boolean"`

	// The algorithm that was used to create a checksum of the object.
	ChecksumAlgorithm *string `location:"header" locationName:"x-amz-checksum-algorithm" type:"string" enum:"ChecksumAlgorithm"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the Amazon Web Services KMS Encryption Context to use
	// for object encryption. The value of this header is a base64-encoded UTF-8
	// string holding JSON with the encryption context key-value pairs.
	//
	// SSEKMSEncryptionContext is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMultipartUploadOutput's
	// String and GoString methods.
	SSEKMSEncryptionContext *string `location:"header" locationName:"x-amz-server-side-encryption-context" type:"string" sensitive:"true"`

	// If present, specifies the ID of the Amazon Web Services Key Management Service
	// (Amazon Web Services KMS) symmetric customer managed key that was used for
	// the object.
	//
	// SSEKMSKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMultipartUploadOutput's
	// String and GoString methods.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// ID for the initiated multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetAbortDate sets the AbortDate field's value.
func (s *CreateMultipartUploadOutput) SetAbortDate(v time.Time) *CreateMultipartUploadOutput {
	s.AbortDate = &v
	return s
}

// SetAbortRuleId sets the AbortRuleId field's value.
func (s *CreateMultipartUploadOutput) SetAbortRuleId(v string) *CreateMultipartUploadOutput {
	s.AbortRuleId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateMultipartUploadOutput) SetBucket(v string) *CreateMultipartUploadOutput {
	s.Bucket = &v
	return s
}

func (s *CreateMultipartUploadOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBucketKeyEnabled sets the BucketKeyEnabled field's value.
func (s *CreateMultipartUploadOutput) SetBucketKeyEnabled(v bool) *CreateMultipartUploadOutput {
	s.BucketKeyEnabled = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *CreateMultipartUploadOutput) SetChecksumAlgorithm(v string) *CreateMultipartUploadOutput {
	s.ChecksumAlgorithm = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CreateMultipartUploadOutput) SetKey(v string) *CreateMultipartUploadOutput {
	s.Key = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CreateMultipartUploadOutput) SetRequestCharged(v string) *CreateMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CreateMultipartUploadOutput) SetSSECustomerAlgorithm(v string) *CreateMultipartUploadOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CreateMultipartUploadOutput) SetSSECustomerKeyMD5(v string) *CreateMultipartUploadOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSEncryptionContext sets the SSEKMSEncryptionContext field's value.
func (s *CreateMultipartUploadOutput) SetSSEKMSEncryptionContext(v string) *CreateMultipartUploadOutput {
	s.SSEKMSEncryptionContext = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CreateMultipartUploadOutput) SetSSEKMSKeyId(v string) *CreateMultipartUploadOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CreateMultipartUploadOutput) SetServerSideEncryption(v string) *CreateMultipartUploadOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CreateMultipartUploadOutput) SetUploadId(v string) *CreateMultipartUploadOutput {
	s.UploadId = &v
	return s
}

// The container element for specifying the default Object Lock retention settings
// for new objects placed in the specified bucket.
//
//   - The DefaultRetention settings require both a mode and a period.
//
//   - The DefaultRetention period can be either Days or Years but you must
//     select one. You cannot specify Days and Years at the same time.
type DefaultRetention struct {
	_ struct{} `type:"structure"`

	// The number of days that you want to specify for the default retention period.
	// Must be used with Mode.
	Days *int64 `type:"integer"`

	// The default Object Lock retention mode you want to apply to new objects placed
	// in the specified bucket. Must be used with either Days or Years.
	Mode *string `type:"string" enum:"ObjectLockRetentionMode"`

	// The number of years that you want to specify for the default retention period.
	// Must be used with Mode.
	Years *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultRetention) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultRetention) GoString() string {
	return s.String()
}

// SetDays sets the Days field's value.
func (s *DefaultRetention) SetDays(v int64) *DefaultRetention {
	s.Days = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *DefaultRetention) SetMode(v string) *DefaultRetention {
	s.Mode = &v
	return s
}

// SetYears sets the Years field's value.
func (s *DefaultRetention) SetYears(v int64) *DefaultRetention {
	s.Years = &v
	return s
}

// Container for the objects to delete.
type Delete struct {
	_ struct{} `type:"structure"`

	// The objects to delete.
	//
	// Objects is a required field
	Objects []*ObjectIdentifier `locationName:"Object" type:"list" flattened:"true" required:"true"`

	// Element to enable quiet mode for the request. When you add this element,
	// you must set its value to true.
	Quiet *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Delete) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Delete) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Delete"}
	if s.Objects == nil {
		invalidParams.Add(request.NewErrParamRequired("Objects"))
	}
	if s.Objects != nil {
		for i, v := range s.Objects {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Objects", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjects sets the Objects field's value.
func (s *Delete) SetObjects(v []*ObjectIdentifier) *Delete {
	s.Objects = v
	return s
}

// SetQuiet sets the Quiet field's value.
func (s *Delete) SetQuiet(v bool) *Delete {
	s.Quiet = &v
	return s
}

type DeleteBucketAnalyticsConfigurationInput struct {
	_ struct{} `locationName:"DeleteBucketAnalyticsConfigurationRequest" type:"structure"`

	// The name of the bucket from which an analytics configuration is deleted.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The ID that identifies the analytics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketAnalyticsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketAnalyticsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketAnalyticsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketAnalyticsConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketAnalyticsConfigurationInput) SetBucket(v string) *DeleteBucketAnalyticsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketAnalyticsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketAnalyticsConfigurationInput) SetExpectedBucketOwner(v string) *DeleteBucketAnalyticsConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteBucketAnalyticsConfigurationInput) SetId(v string) *DeleteBucketAnalyticsConfigurationInput {
	s.Id = &v
	return s
}

func (s *DeleteBucketAnalyticsConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketAnalyticsConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketAnalyticsConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketAnalyticsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketAnalyticsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketAnalyticsConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteBucketCorsInput struct {
	_ struct{} `locationName:"DeleteBucketCorsRequest" type:"structure"`

	// Specifies the bucket whose cors configuration is being deleted.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketCorsInput) SetBucket(v string) *DeleteBucketCorsInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketCorsInput) SetExpectedBucketOwner(v string) *DeleteBucketCorsInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeleteBucketCorsInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketCorsInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketCorsInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketCorsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketCorsOutput) GoString() string {
	return s.String()
}

type DeleteBucketEncryptionInput struct {
	_ struct{} `locationName:"DeleteBucketEncryptionRequest" type:"structure"`

	// The name of the bucket containing the server-side encryption configuration
	// to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketEncryptionInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketEncryptionInput) SetBucket(v string) *DeleteBucketEncryptionInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketEncryptionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketEncryptionInput) SetExpectedBucketOwner(v string) *DeleteBucketEncryptionInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeleteBucketEncryptionInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketEncryptionInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketEncryptionInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketEncryptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketEncryptionOutput) GoString() string {
	return s.String()
}

type DeleteBucketInput struct {
	_ struct{} `locationName:"DeleteBucketRequest" type:"structure"`

	// Specifies the bucket being deleted.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketInput) SetBucket(v string) *DeleteBucketInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketInput) SetExpectedBucketOwner(v string) *DeleteBucketInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeleteBucketInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketIntelligentTieringConfigurationInput struct {
	_ struct{} `locationName:"DeleteBucketIntelligentTieringConfigurationRequest" type:"structure"`

	// The name of the Amazon S3 bucket whose configuration you want to modify or
	// retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the S3 Intelligent-Tiering configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketIntelligentTieringConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketIntelligentTieringConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketIntelligentTieringConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketIntelligentTieringConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketIntelligentTieringConfigurationInput) SetBucket(v string) *DeleteBucketIntelligentTieringConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketIntelligentTieringConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *DeleteBucketIntelligentTieringConfigurationInput) SetId(v string) *DeleteBucketIntelligentTieringConfigurationInput {
	s.Id = &v
	return s
}

func (s *DeleteBucketIntelligentTieringConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketIntelligentTieringConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketIntelligentTieringConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketIntelligentTieringConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketIntelligentTieringConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketIntelligentTieringConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteBucketInventoryConfigurationInput struct {
	_ struct{} `locationName:"DeleteBucketInventoryConfigurationRequest" type:"structure"`

	// The name of the bucket containing the inventory configuration to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketInventoryConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInventoryConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketInventoryConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketInventoryConfigurationInput) SetBucket(v string) *DeleteBucketInventoryConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketInventoryConfigurationInput) SetExpectedBucketOwner(v string) *DeleteBucketInventoryConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteBucketInventoryConfigurationInput) SetId(v string) *DeleteBucketInventoryConfigurationInput {
	s.Id = &v
	return s
}

func (s *DeleteBucketInventoryConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketInventoryConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketInventoryConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketInventoryConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteBucketLifecycleInput struct {
	_ struct{} `locationName:"DeleteBucketLifecycleRequest" type:"structure"`

	// The bucket name of the lifecycle to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketLifecycleInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketLifecycleInput) SetBucket(v string) *DeleteBucketLifecycleInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketLifecycleInput) SetExpectedBucketOwner(v string) *DeleteBucketLifecycleInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeleteBucketLifecycleInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketLifecycleInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketLifecycleInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketLifecycleOutput) GoString() string {
	return s.String()
}

type DeleteBucketMetricsConfigurationInput struct {
	_ struct{} `locationName:"DeleteBucketMetricsConfigurationRequest" type:"structure"`

	// The name of the bucket containing the metrics configuration to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketMetricsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketMetricsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketMetricsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketMetricsConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketMetricsConfigurationInput) SetBucket(v string) *DeleteBucketMetricsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketMetricsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketMetricsConfigurationInput) SetExpectedBucketOwner(v string) *DeleteBucketMetricsConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteBucketMetricsConfigurationInput) SetId(v string) *DeleteBucketMetricsConfigurationInput {
	s.Id = &v
	return s
}

func (s *DeleteBucketMetricsConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketMetricsConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketMetricsConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketMetricsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketMetricsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketMetricsConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketOutput) GoString() string {
	return s.String()
}

type DeleteBucketOwnershipControlsInput struct {
	_ struct{} `locationName:"DeleteBucketOwnershipControlsRequest" type:"structure"`

	// The Amazon S3 bucket whose OwnershipControls you want to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketOwnershipControlsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketOwnershipControlsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketOwnershipControlsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketOwnershipControlsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketOwnershipControlsInput) SetBucket(v string) *DeleteBucketOwnershipControlsInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketOwnershipControlsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketOwnershipControlsInput) SetExpectedBucketOwner(v string) *DeleteBucketOwnershipControlsInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeleteBucketOwnershipControlsInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketOwnershipControlsInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketOwnershipControlsInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketOwnershipControlsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketOwnershipControlsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketOwnershipControlsOutput) GoString() string {
	return s.String()
}

type DeleteBucketPolicyInput struct {
	_ struct{} `locationName:"DeleteBucketPolicyRequest" type:"structure"`

	// The bucket name.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketPolicyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketPolicyInput) SetBucket(v string) *DeleteBucketPolicyInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketPolicyInput) SetExpectedBucketOwner(v string) *DeleteBucketPolicyInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeleteBucketPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketPolicyInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketPolicyOutput) GoString() string {
	return s.String()
}

type DeleteBucketReplicationInput struct {
	_ struct{} `locationName:"DeleteBucketReplicationRequest" type:"structure"`

	// The bucket name.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketReplicationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketReplicationInput) SetBucket(v string) *DeleteBucketReplicationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketReplicationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketReplicationInput) SetExpectedBucketOwner(v string) *DeleteBucketReplicationInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeleteBucketReplicationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketReplicationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketReplicationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketReplicationOutput) GoString() string {
	return s.String()
}

type DeleteBucketTaggingInput struct {
	_ struct{} `locationName:"DeleteBucketTaggingRequest" type:"structure"`

	// The bucket that has the tag set to be removed.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketTaggingInput) SetBucket(v string) *DeleteBucketTaggingInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketTaggingInput) SetExpectedBucketOwner(v string) *DeleteBucketTaggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeleteBucketTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketTaggingOutput) GoString() string {
	return s.String()
}

type DeleteBucketWebsiteInput struct {
	_ struct{} `locationName:"DeleteBucketWebsiteRequest" type:"structure"`

	// The bucket name for which you want to remove the website configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketWebsiteInput) SetBucket(v string) *DeleteBucketWebsiteInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketWebsiteInput) SetExpectedBucketOwner(v string) *DeleteBucketWebsiteInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeleteBucketWebsiteInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketWebsiteInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketWebsiteInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketWebsiteOutput) GoString() string {
	return s.String()
}

// Information about the delete marker.
type DeleteMarkerEntry struct {
	_ struct{} `type:"structure"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp"`

	// The account that created the delete marker.>
	Owner *Owner `type:"structure"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMarkerEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMarkerEntry) GoString() string {
	return s.String()
}

// SetIsLatest sets the IsLatest field's value.
func (s *DeleteMarkerEntry) SetIsLatest(v bool) *DeleteMarkerEntry {
	s.IsLatest = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteMarkerEntry) SetKey(v string) *DeleteMarkerEntry {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DeleteMarkerEntry) SetLastModified(v time.Time) *DeleteMarkerEntry {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DeleteMarkerEntry) SetOwner(v *Owner) *DeleteMarkerEntry {
	s.Owner = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteMarkerEntry) SetVersionId(v string) *DeleteMarkerEntry {
	s.VersionId = &v
	return s
}

// Specifies whether Amazon S3 replicates delete markers. If you specify a Filter
// in your replication configuration, you must also include a DeleteMarkerReplication
// element. If your Filter includes a Tag element, the DeleteMarkerReplication
// Status must be set to Disabled, because Amazon S3 does not support replicating
// delete markers for tag-based rules. For an example configuration, see Basic
// Rule Configuration (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config).
//
// For more information about delete marker replication, see Basic Rule Configuration
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html).
//
// If you are using an earlier version of the replication configuration, Amazon
// S3 handles replication of delete markers differently. For more information,
// see Backward Compatibility (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
type DeleteMarkerReplication struct {
	_ struct{} `type:"structure"`

	// Indicates whether to replicate delete markers.
	//
	// Indicates whether to replicate delete markers.
	Status *string `type:"string" enum:"DeleteMarkerReplicationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMarkerReplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMarkerReplication) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteMarkerReplication) SetStatus(v string) *DeleteMarkerReplication {
	s.Status = &v
	return s
}

type DeleteObjectInput struct {
	_ struct{} `locationName:"DeleteObjectRequest" type:"structure"`

	// The bucket name of the bucket containing the object.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Indicates whether S3 Object Lock should bypass Governance-mode restrictions
	// to process this operation. To use this header, you must have the s3:BypassGovernanceRetention
	// permission.
	BypassGovernanceRetention *bool `location:"header" locationName:"x-amz-bypass-governance-retention" type:"boolean"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Key name of the object to delete.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device. Required to
	// permanently delete a versioned object if versioning is configured with MFA
	// delete enabled.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectInput) SetBucket(v string) *DeleteObjectInput {
	s.Bucket = &v
	return s
}

func (s *DeleteObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBypassGovernanceRetention sets the BypassGovernanceRetention field's value.
func (s *DeleteObjectInput) SetBypassGovernanceRetention(v bool) *DeleteObjectInput {
	s.BypassGovernanceRetention = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteObjectInput) SetExpectedBucketOwner(v string) *DeleteObjectInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteObjectInput) SetKey(v string) *DeleteObjectInput {
	s.Key = &v
	return s
}

// SetMFA sets the MFA field's value.
func (s *DeleteObjectInput) SetMFA(v string) *DeleteObjectInput {
	s.MFA = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *DeleteObjectInput) SetRequestPayer(v string) *DeleteObjectInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectInput) SetVersionId(v string) *DeleteObjectInput {
	s.VersionId = &v
	return s
}

func (s *DeleteObjectInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteObjectInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteObjectInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteObjectOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the versioned object that was permanently deleted was (true)
	// or was not (false) a delete marker.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Returns the version ID of the delete marker created as a result of the DELETE
	// operation.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectOutput) GoString() string {
	return s.String()
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *DeleteObjectOutput) SetDeleteMarker(v bool) *DeleteObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *DeleteObjectOutput) SetRequestCharged(v string) *DeleteObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectOutput) SetVersionId(v string) *DeleteObjectOutput {
	s.VersionId = &v
	return s
}

type DeleteObjectTaggingInput struct {
	_ struct{} `locationName:"DeleteObjectTaggingRequest" type:"structure"`

	// The bucket name containing the objects from which to remove the tags.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The key that identifies the object in the bucket from which to remove all
	// tags.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The versionId of the object that the tag-set will be removed from.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectTaggingInput) SetBucket(v string) *DeleteObjectTaggingInput {
	s.Bucket = &v
	return s
}

func (s *DeleteObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteObjectTaggingInput) SetExpectedBucketOwner(v string) *DeleteObjectTaggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteObjectTaggingInput) SetKey(v string) *DeleteObjectTaggingInput {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectTaggingInput) SetVersionId(v string) *DeleteObjectTaggingInput {
	s.VersionId = &v
	return s
}

func (s *DeleteObjectTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteObjectTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteObjectTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The versionId of the object the tag-set was removed from.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectTaggingOutput) GoString() string {
	return s.String()
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectTaggingOutput) SetVersionId(v string) *DeleteObjectTaggingOutput {
	s.VersionId = &v
	return s
}

type DeleteObjectsInput struct {
	_ struct{} `locationName:"DeleteObjectsRequest" type:"structure" payload:"Delete"`

	// The bucket name containing the objects to delete.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies whether you want to delete this object even if it has a Governance-type
	// Object Lock in place. To use this header, you must have the s3:BypassGovernanceRetention
	// permission.
	BypassGovernanceRetention *bool `location:"header" locationName:"x-amz-bypass-governance-retention" type:"boolean"`

	// Indicates the algorithm used to create the checksum for the object when using
	// the SDK. This header will not provide any additional functionality if not
	// using the SDK. When sending this header, there must be a corresponding x-amz-checksum
	// or x-amz-trailer header sent. Otherwise, Amazon S3 fails the request with
	// the HTTP status code 400 Bad Request. For more information, see Checking
	// object integrity (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
	// in the Amazon S3 User Guide.
	//
	// If you provide an individual checksum, Amazon S3 ignores any provided ChecksumAlgorithm
	// parameter.
	//
	// This checksum algorithm must be the same for all parts and it match the checksum
	// value supplied in the CreateMultipartUpload request.
	//
	// The AWS SDK for Go v1 does not support automatic computing request payload
	// checksum. This feature is available in the AWS SDK for Go v2. If a value
	// is specified for this parameter, the matching algorithm's checksum member
	// must be populated with the algorithm's checksum of the request payload.
	//
	// The SDK will automatically compute the Content-MD5 checksum for this operation.
	// The AWS SDK for Go v2 allows you to configure alternative checksum algorithm
	// to be used.
	ChecksumAlgorithm *string `location:"header" locationName:"x-amz-sdk-checksum-algorithm" type:"string" enum:"ChecksumAlgorithm"`

	// Container for the request.
	//
	// Delete is a required field
	Delete *Delete `locationName:"Delete" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device. Required to
	// permanently delete a versioned object if versioning is configured with MFA
	// delete enabled.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Delete == nil {
		invalidParams.Add(request.NewErrParamRequired("Delete"))
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectsInput) SetBucket(v string) *DeleteObjectsInput {
	s.Bucket = &v
	return s
}

func (s *DeleteObjectsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBypassGovernanceRetention sets the BypassGovernanceRetention field's value.
func (s *DeleteObjectsInput) SetBypassGovernanceRetention(v bool) *DeleteObjectsInput {
	s.BypassGovernanceRetention = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *DeleteObjectsInput) SetChecksumAlgorithm(v string) *DeleteObjectsInput {
	s.ChecksumAlgorithm = &v
	return s
}

// SetDelete sets the Delete field's value.
func (s *DeleteObjectsInput) SetDelete(v *Delete) *DeleteObjectsInput {
	s.Delete = v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteObjectsInput) SetExpectedBucketOwner(v string) *DeleteObjectsInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetMFA sets the MFA field's value.
func (s *DeleteObjectsInput) SetMFA(v string) *DeleteObjectsInput {
	s.MFA = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *DeleteObjectsInput) SetRequestPayer(v string) *DeleteObjectsInput {
	s.RequestPayer = &v
	return s
}

func (s *DeleteObjectsInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteObjectsInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteObjectsInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeleteObjectsOutput struct {
	_ struct{} `type:"structure"`

	// Container element for a successful delete. It identifies the object that
	// was successfully deleted.
	Deleted []*DeletedObject `type:"list" flattened:"true"`

	// Container for a failed delete action that describes the object that Amazon
	// S3 attempted to delete and the error it encountered.
	Errors []*Error `locationName:"Error" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteObjectsOutput) GoString() string {
	return s.String()
}

// SetDeleted sets the Deleted field's value.
func (s *DeleteObjectsOutput) SetDeleted(v []*DeletedObject) *DeleteObjectsOutput {
	s.Deleted = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *DeleteObjectsOutput) SetErrors(v []*Error) *DeleteObjectsOutput {
	s.Errors = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *DeleteObjectsOutput) SetRequestCharged(v string) *DeleteObjectsOutput {
	s.RequestCharged = &v
	return s
}

type DeletePublicAccessBlockInput struct {
	_ struct{} `locationName:"DeletePublicAccessBlockRequest" type:"structure"`

	// The Amazon S3 bucket whose PublicAccessBlock configuration you want to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePublicAccessBlockInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeletePublicAccessBlockInput) SetBucket(v string) *DeletePublicAccessBlockInput {
	s.Bucket = &v
	return s
}

func (s *DeletePublicAccessBlockInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeletePublicAccessBlockInput) SetExpectedBucketOwner(v string) *DeletePublicAccessBlockInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *DeletePublicAccessBlockInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeletePublicAccessBlockInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeletePublicAccessBlockInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type DeletePublicAccessBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicAccessBlockOutput) GoString() string {
	return s.String()
}

// Information about the deleted object.
type DeletedObject struct {
	_ struct{} `type:"structure"`

	// Specifies whether the versioned object that was permanently deleted was (true)
	// or was not (false) a delete marker. In a simple DELETE, this header indicates
	// whether (true) or not (false) a delete marker was created.
	DeleteMarker *bool `type:"boolean"`

	// The version ID of the delete marker created as a result of the DELETE operation.
	// If you delete a specific object version, the value returned by this header
	// is the version ID of the object version deleted.
	DeleteMarkerVersionId *string `type:"string"`

	// The name of the deleted object.
	Key *string `min:"1" type:"string"`

	// The version ID of the deleted object.
	VersionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletedObject) GoString() string {
	return s.String()
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *DeletedObject) SetDeleteMarker(v bool) *DeletedObject {
	s.DeleteMarker = &v
	return s
}

// SetDeleteMarkerVersionId sets the DeleteMarkerVersionId field's value.
func (s *DeletedObject) SetDeleteMarkerVersionId(v string) *DeletedObject {
	s.DeleteMarkerVersionId = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeletedObject) SetKey(v string) *DeletedObject {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeletedObject) SetVersionId(v string) *DeletedObject {
	s.VersionId = &v
	return s
}

// Specifies information about where to publish analysis or configuration results
// for an Amazon S3 bucket and S3 Replication Time Control (S3 RTC).
type Destination struct {
	_ struct{} `type:"structure"`

	// Specify this only in a cross-account scenario (where source and destination
	// bucket owners are not the same), and you want to change replica ownership
	// to the Amazon Web Services account that owns the destination bucket. If this
	// is not specified in the replication configuration, the replicas are owned
	// by same Amazon Web Services account that owns the source object.
	AccessControlTranslation *AccessControlTranslation `type:"structure"`

	// Destination bucket owner account ID. In a cross-account scenario, if you
	// direct Amazon S3 to change replica ownership to the Amazon Web Services account
	// that owns the destination bucket by specifying the AccessControlTranslation
	// property, this is the account ID of the destination bucket owner. For more
	// information, see Replication Additional Configuration: Changing the Replica
	// Owner (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-change-owner.html)
	// in the Amazon S3 User Guide.
	Account *string `type:"string"`

	// The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to
	// store the results.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// A container that provides information about encryption. If SourceSelectionCriteria
	// is specified, you must specify this element.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// A container specifying replication metrics-related settings enabling replication
	// metrics and events.
	Metrics *Metrics `type:"structure"`

	// A container specifying S3 Replication Time Control (S3 RTC), including whether
	// S3 RTC is enabled and the time when all objects and operations on objects
	// must be replicated. Must be specified together with a Metrics block.
	ReplicationTime *ReplicationTime `type:"structure"`

	// The storage class to use when replicating objects, such as S3 Standard or
	// reduced redundancy. By default, Amazon S3 uses the storage class of the source
	// object to create the object replica.
	//
	// For valid values, see the StorageClass element of the PUT Bucket replication
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html)
	// action in the Amazon S3 API Reference.
	StorageClass *string `type:"string" enum:"StorageClass"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Destination"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.AccessControlTranslation != nil {
		if err := s.AccessControlTranslation.Validate(); err != nil {
			invalidParams.AddNested("AccessControlTranslation", err.(request.ErrInvalidParams))
		}
	}
	if s.Metrics != nil {
		if err := s.Metrics.Validate(); err != nil {
			invalidParams.AddNested("Metrics", err.(request.ErrInvalidParams))
		}
	}
	if s.ReplicationTime != nil {
		if err := s.ReplicationTime.Validate(); err != nil {
			invalidParams.AddNested("ReplicationTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlTranslation sets the AccessControlTranslation field's value.
func (s *Destination) SetAccessControlTranslation(v *AccessControlTranslation) *Destination {
	s.AccessControlTranslation = v
	return s
}

// SetAccount sets the Account field's value.
func (s *Destination) SetAccount(v string) *Destination {
	s.Account = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *Destination) SetBucket(v string) *Destination {
	s.Bucket = &v
	return s
}

func (s *Destination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *Destination) SetEncryptionConfiguration(v *EncryptionConfiguration) *Destination {
	s.EncryptionConfiguration = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *Destination) SetMetrics(v *Metrics) *Destination {
	s.Metrics = v
	return s
}

// SetReplicationTime sets the ReplicationTime field's value.
func (s *Destination) SetReplicationTime(v *ReplicationTime) *Destination {
	s.ReplicationTime = v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Destination) SetStorageClass(v string) *Destination {
	s.StorageClass = &v
	return s
}

// Contains the type of server-side encryption used.
type Encryption struct {
	_ struct{} `type:"structure"`

	// The server-side encryption algorithm used when storing job results in Amazon
	// S3 (for example, AES256, aws:kms).
	//
	// EncryptionType is a required field
	EncryptionType *string `type:"string" required:"true" enum:"ServerSideEncryption"`

	// If the encryption type is aws:kms, this optional value can be used to specify
	// the encryption context for the restore results.
	KMSContext *string `type:"string"`

	// If the encryption type is aws:kms, this optional value specifies the ID of
	// the symmetric customer managed key to use for encryption of job results.
	// Amazon S3 only supports symmetric keys. For more information, see Using symmetric
	// and asymmetric keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	// in the Amazon Web Services Key Management Service Developer Guide.
	//
	// KMSKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Encryption's
	// String and GoString methods.
	KMSKeyId *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Encryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Encryption"}
	if s.EncryptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *Encryption) SetEncryptionType(v string) *Encryption {
	s.EncryptionType = &v
	return s
}

// SetKMSContext sets the KMSContext field's value.
func (s *Encryption) SetKMSContext(v string) *Encryption {
	s.KMSContext = &v
	return s
}

// SetKMSKeyId sets the KMSKeyId field's value.
func (s *Encryption) SetKMSKeyId(v string) *Encryption {
	s.KMSKeyId = &v
	return s
}

// Specifies encryption-related information for an Amazon S3 bucket that is
// a destination for replicated objects.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the ID (Key ARN or Alias ARN) of the customer managed Amazon Web
	// Services KMS key stored in Amazon Web Services Key Management Service (KMS)
	// for the destination bucket. Amazon S3 uses this key to encrypt replica objects.
	// Amazon S3 only supports symmetric, customer managed KMS keys. For more information,
	// see Using symmetric and asymmetric keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	// in the Amazon Web Services Key Management Service Developer Guide.
	ReplicaKmsKeyID *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// SetReplicaKmsKeyID sets the ReplicaKmsKeyID field's value.
func (s *EncryptionConfiguration) SetReplicaKmsKeyID(v string) *EncryptionConfiguration {
	s.ReplicaKmsKeyID = &v
	return s
}

// A message that indicates the request is complete and no more messages will
// be sent. You should not assume that the request is complete until the client
// receives an EndEvent.
type EndEvent struct {
	_ struct{} `locationName:"EndEvent" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndEvent) GoString() string {
	return s.String()
}

// The EndEvent is and event in the SelectObjectContentEventStream group of events.
func (s *EndEvent) eventSelectObjectContentEventStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the EndEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *EndEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *EndEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	return msg, err
}

// Container for all error elements.
type Error struct {
	_ struct{} `type:"structure"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// Amazon S3 error codes
	//
	//    * Code: AccessDenied Description: Access Denied HTTP Status Code: 403
	//    Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: AccountProblem Description: There is a problem with your Amazon
	//    Web Services account that prevents the action from completing successfully.
	//    Contact Amazon Web Services Support for further assistance. HTTP Status
	//    Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: AllAccessDisabled Description: All access to this Amazon S3 resource
	//    has been disabled. Contact Amazon Web Services Support for further assistance.
	//    HTTP Status Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: AmbiguousGrantByEmailAddress Description: The email address you
	//    provided is associated with more than one account. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: AuthorizationHeaderMalformed Description: The authorization header
	//    you provided is invalid. HTTP Status Code: 400 Bad Request HTTP Status
	//    Code: N/A
	//
	//    * Code: BadDigest Description: The Content-MD5 you specified did not match
	//    what we received. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: BucketAlreadyExists Description: The requested bucket name is
	//    not available. The bucket namespace is shared by all users of the system.
	//    Please select a different name and try again. HTTP Status Code: 409 Conflict
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: BucketAlreadyOwnedByYou Description: The bucket you tried to create
	//    already exists, and you own it. Amazon S3 returns this error in all Amazon
	//    Web Services Regions except in the North Virginia Region. For legacy compatibility,
	//    if you re-create an existing bucket that you already own in the North
	//    Virginia Region, Amazon S3 returns 200 OK and resets the bucket access
	//    control lists (ACLs). Code: 409 Conflict (in all Regions except the North
	//    Virginia Region) SOAP Fault Code Prefix: Client
	//
	//    * Code: BucketNotEmpty Description: The bucket you tried to delete is
	//    not empty. HTTP Status Code: 409 Conflict SOAP Fault Code Prefix: Client
	//
	//    * Code: CredentialsNotSupported Description: This request does not support
	//    credentials. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: CrossLocationLoggingProhibited Description: Cross-location logging
	//    not allowed. Buckets in one geographic location cannot log information
	//    to a bucket in another location. HTTP Status Code: 403 Forbidden SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: EntityTooSmall Description: Your proposed upload is smaller than
	//    the minimum allowed object size. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: EntityTooLarge Description: Your proposed upload exceeds the maximum
	//    allowed object size. HTTP Status Code: 400 Bad Request SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: ExpiredToken Description: The provided token has expired. HTTP
	//    Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: IllegalVersioningConfigurationException Description: Indicates
	//    that the versioning configuration specified in the request is invalid.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: IncompleteBody Description: You did not provide the number of
	//    bytes specified by the Content-Length HTTP header HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: IncorrectNumberOfFilesInPostRequest Description: POST requires
	//    exactly one file upload per request. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: InlineDataTooLarge Description: Inline data exceeds the maximum
	//    allowed size. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InternalError Description: We encountered an internal error. Please
	//    try again. HTTP Status Code: 500 Internal Server Error SOAP Fault Code
	//    Prefix: Server
	//
	//    * Code: InvalidAccessKeyId Description: The Amazon Web Services access
	//    key ID you provided does not exist in our records. HTTP Status Code: 403
	//    Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidAddressingHeader Description: You must specify the Anonymous
	//    role. HTTP Status Code: N/A SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidArgument Description: Invalid Argument HTTP Status Code:
	//    400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidBucketName Description: The specified bucket is not valid.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidBucketState Description: The request is not valid with
	//    the current state of the bucket. HTTP Status Code: 409 Conflict SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: InvalidDigest Description: The Content-MD5 you specified is not
	//    valid. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidEncryptionAlgorithmError Description: The encryption request
	//    you specified is not valid. The valid value is AES256. HTTP Status Code:
	//    400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidLocationConstraint Description: The specified location
	//    constraint is not valid. For more information about Regions, see How to
	//    Select a Region for Your Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro).
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidObjectState Description: The action is not valid for the
	//    current state of the object. HTTP Status Code: 403 Forbidden SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: InvalidPart Description: One or more of the specified parts could
	//    not be found. The part might not have been uploaded, or the specified
	//    entity tag might not have matched the part's entity tag. HTTP Status Code:
	//    400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidPartOrder Description: The list of parts was not in ascending
	//    order. Parts list must be specified in order by part number. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidPayer Description: All access to this object has been disabled.
	//    Please contact Amazon Web Services Support for further assistance. HTTP
	//    Status Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidPolicyDocument Description: The content of the form does
	//    not meet the conditions specified in the policy document. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidRange Description: The requested range cannot be satisfied.
	//    HTTP Status Code: 416 Requested Range Not Satisfiable SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: InvalidRequest Description: Please use AWS4-HMAC-SHA256. HTTP
	//    Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: SOAP requests must be made over an
	//    HTTPS connection. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration is
	//    not supported for buckets with non-DNS compliant names. HTTP Status Code:
	//    400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration is
	//    not supported for buckets with periods (.) in their names. HTTP Status
	//    Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Accelerate endpoint
	//    only supports virtual style requests. HTTP Status Code: 400 Bad Request
	//    Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Accelerate is not
	//    configured on this bucket. HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Accelerate is disabled
	//    on this bucket. HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration is
	//    not supported on this bucket. Contact Amazon Web Services Support for
	//    more information. HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration cannot
	//    be enabled on this bucket. Contact Amazon Web Services Support for more
	//    information. HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidSecurity Description: The provided security credentials
	//    are not valid. HTTP Status Code: 403 Forbidden SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InvalidSOAPRequest Description: The SOAP request body is invalid.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidStorageClass Description: The storage class you specified
	//    is not valid. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InvalidTargetBucketForLogging Description: The target bucket for
	//    logging does not exist, is not owned by you, or does not have the appropriate
	//    grants for the log-delivery group. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: InvalidToken Description: The provided token is malformed or otherwise
	//    invalid. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidURI Description: Couldn't parse the specified URI. HTTP
	//    Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: KeyTooLongError Description: Your key is too long. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MalformedACLError Description: The XML you provided was not well-formed
	//    or did not validate against our published schema. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MalformedPOSTRequest Description: The body of your POST request
	//    is not well-formed multipart/form-data. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: MalformedXML Description: This happens when the user sends malformed
	//    XML (XML that doesn't conform to the published XSD) for the configuration.
	//    The error message is, "The XML you provided was not well-formed or did
	//    not validate against our published schema." HTTP Status Code: 400 Bad
	//    Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MaxMessageLengthExceeded Description: Your request was too big.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MaxPostPreDataLengthExceededError Description: Your POST request
	//    fields preceding the upload file were too large. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MetadataTooLarge Description: Your metadata headers exceed the
	//    maximum allowed metadata size. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: MethodNotAllowed Description: The specified method is not allowed
	//    against this resource. HTTP Status Code: 405 Method Not Allowed SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: MissingAttachment Description: A SOAP attachment was expected,
	//    but none were found. HTTP Status Code: N/A SOAP Fault Code Prefix: Client
	//
	//    * Code: MissingContentLength Description: You must provide the Content-Length
	//    HTTP header. HTTP Status Code: 411 Length Required SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: MissingRequestBodyError Description: This happens when the user
	//    sends an empty XML document as a request. The error message is, "Request
	//    body is empty." HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: MissingSecurityElement Description: The SOAP 1.1 request is missing
	//    a security element. HTTP Status Code: 400 Bad Request SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: MissingSecurityHeader Description: Your request is missing a required
	//    header. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: NoLoggingStatusForKey Description: There is no such thing as a
	//    logging status subresource for a key. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: NoSuchBucket Description: The specified bucket does not exist.
	//    HTTP Status Code: 404 Not Found SOAP Fault Code Prefix: Client
	//
	//    * Code: NoSuchBucketPolicy Description: The specified bucket does not
	//    have a bucket policy. HTTP Status Code: 404 Not Found SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: NoSuchKey Description: The specified key does not exist. HTTP
	//    Status Code: 404 Not Found SOAP Fault Code Prefix: Client
	//
	//    * Code: NoSuchLifecycleConfiguration Description: The lifecycle configuration
	//    does not exist. HTTP Status Code: 404 Not Found SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: NoSuchUpload Description: The specified multipart upload does
	//    not exist. The upload ID might be invalid, or the multipart upload might
	//    have been aborted or completed. HTTP Status Code: 404 Not Found SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: NoSuchVersion Description: Indicates that the version ID specified
	//    in the request does not match an existing version. HTTP Status Code: 404
	//    Not Found SOAP Fault Code Prefix: Client
	//
	//    * Code: NotImplemented Description: A header you provided implies functionality
	//    that is not implemented. HTTP Status Code: 501 Not Implemented SOAP Fault
	//    Code Prefix: Server
	//
	//    * Code: NotSignedUp Description: Your account is not signed up for the
	//    Amazon S3 service. You must sign up before you can use Amazon S3. You
	//    can sign up at the following URL: Amazon S3 (http://aws.amazon.com/s3)
	//    HTTP Status Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: OperationAborted Description: A conflicting conditional action
	//    is currently in progress against this resource. Try again. HTTP Status
	//    Code: 409 Conflict SOAP Fault Code Prefix: Client
	//
	//    * Code: PermanentRedirect Description: The bucket you are attempting to
	//    access must be addressed using the specified endpoint. Send all future
	//    requests to this endpoint. HTTP Status Code: 301 Moved Permanently SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: PreconditionFailed Description: At least one of the preconditions
	//    you specified did not hold. HTTP Status Code: 412 Precondition Failed
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: Redirect Description: Temporary redirect. HTTP Status Code: 307
	//    Moved Temporarily SOAP Fault Code Prefix: Client
	//
	//    * Code: RestoreAlreadyInProgress Description: Object restore is already
	//    in progress. HTTP Status Code: 409 Conflict SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestIsNotMultiPartContent Description: Bucket POST must be
	//    of the enclosure-type multipart/form-data. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestTimeout Description: Your socket connection to the server
	//    was not read from or written to within the timeout period. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestTimeTooSkewed Description: The difference between the request
	//    time and the server's time is too large. HTTP Status Code: 403 Forbidden
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestTorrentOfBucketError Description: Requesting the torrent
	//    file of a bucket is not permitted. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: SignatureDoesNotMatch Description: The request signature we calculated
	//    does not match the signature you provided. Check your Amazon Web Services
	//    secret access key and signing method. For more information, see REST Authentication
	//    (https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html)
	//    and SOAP Authentication (https://docs.aws.amazon.com/AmazonS3/latest/dev/SOAPAuthentication.html)
	//    for details. HTTP Status Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: ServiceUnavailable Description: Reduce your request rate. HTTP
	//    Status Code: 503 Service Unavailable SOAP Fault Code Prefix: Server
	//
	//    * Code: SlowDown Description: Reduce your request rate. HTTP Status Code:
	//    503 Slow Down SOAP Fault Code Prefix: Server
	//
	//    * Code: TemporaryRedirect Description: You are being redirected to the
	//    bucket while DNS updates. HTTP Status Code: 307 Moved Temporarily SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: TokenRefreshRequired Description: The provided token must be refreshed.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: TooManyBuckets Description: You have attempted to create more
	//    buckets than allowed. HTTP Status Code: 400 Bad Request SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: UnexpectedContent Description: This request does not support content.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: UnresolvableGrantByEmailAddress Description: The email address
	//    you provided does not match any account on record. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: UserKeyMustBeSpecified Description: The bucket POST must contain
	//    the specified field name. If it is specified, check the order of the fields.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	Code *string `type:"string"`

	// The error key.
	Key *string `min:"1" type:"string"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message *string `type:"string"`

	// The version ID of the error.
	VersionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Error) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *Error) SetCode(v string) *Error {
	s.Code = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Error) SetKey(v string) *Error {
	s.Key = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Error) SetMessage(v string) *Error {
	s.Message = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *Error) SetVersionId(v string) *Error {
	s.VersionId = &v
	return s
}

// The error information.
type ErrorDocument struct {
	_ struct{} `type:"structure"`

	// The object key name to use when a 4XX class error occurs.
	//
	// Replacement must be made for object keys containing special characters (such
	// as carriage returns) when using XML requests. For more information, see XML
	// related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ErrorDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ErrorDocument"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ErrorDocument) SetKey(v string) *ErrorDocument {
	s.Key = &v
	return s
}

// A container for specifying the configuration for Amazon EventBridge.
type EventBridgeConfiguration struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeConfiguration) GoString() string {
	return s.String()
}

// Optional configuration to replicate existing source bucket objects. For more
// information, see Replicating Existing Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-what-is-isnot-replicated.html#existing-object-replication)
// in the Amazon S3 User Guide.
type ExistingObjectReplication struct {
	_ struct{} `type:"structure"`

	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExistingObjectReplicationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExistingObjectReplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExistingObjectReplication) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExistingObjectReplication) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExistingObjectReplication"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *ExistingObjectReplication) SetStatus(v string) *ExistingObjectReplication {
	s.Status = &v
	return s
}

// Specifies the Amazon S3 object key name to filter on and whether to filter
// on the suffix or prefix of the key name.
type FilterRule struct {
	_ struct{} `type:"structure"`

	// The object key name prefix or suffix identifying one or more objects to which
	// the filtering rule applies. The maximum length is 1,024 characters. Overlapping
	// prefixes and suffixes are not supported. For more information, see Configuring
	// Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon S3 User Guide.
	Name *string `type:"string" enum:"FilterRuleName"`

	// The value that the filter searches for in object key names.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterRule) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FilterRule) SetName(v string) *FilterRule {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FilterRule) SetValue(v string) *FilterRule {
	s.Value = &v
	return s
}

type GetBucketAccelerateConfigurationInput struct {
	_ struct{} `locationName:"GetBucketAccelerateConfigurationRequest" type:"structure"`

	// The name of the bucket for which the accelerate configuration is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAccelerateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAccelerateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAccelerateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAccelerateConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketAccelerateConfigurationInput) SetBucket(v string) *GetBucketAccelerateConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketAccelerateConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketAccelerateConfigurationInput) SetExpectedBucketOwner(v string) *GetBucketAccelerateConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketAccelerateConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketAccelerateConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketAccelerateConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketAccelerateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The accelerate configuration of the bucket.
	Status *string `type:"string" enum:"BucketAccelerateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAccelerateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAccelerateConfigurationOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetBucketAccelerateConfigurationOutput) SetStatus(v string) *GetBucketAccelerateConfigurationOutput {
	s.Status = &v
	return s
}

type GetBucketAclInput struct {
	_ struct{} `locationName:"GetBucketAclRequest" type:"structure"`

	// Specifies the S3 bucket whose ACL is being requested.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketAclInput) SetBucket(v string) *GetBucketAclInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketAclInput) SetExpectedBucketOwner(v string) *GetBucketAclInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketAclInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketAclInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketAclInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	// Container for the bucket owner's display name and ID.
	Owner *Owner `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAclOutput) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *GetBucketAclOutput) SetGrants(v []*Grant) *GetBucketAclOutput {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetBucketAclOutput) SetOwner(v *Owner) *GetBucketAclOutput {
	s.Owner = v
	return s
}

type GetBucketAnalyticsConfigurationInput struct {
	_ struct{} `locationName:"GetBucketAnalyticsConfigurationRequest" type:"structure"`

	// The name of the bucket from which an analytics configuration is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The ID that identifies the analytics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAnalyticsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAnalyticsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAnalyticsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAnalyticsConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketAnalyticsConfigurationInput) SetBucket(v string) *GetBucketAnalyticsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketAnalyticsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketAnalyticsConfigurationInput) SetExpectedBucketOwner(v string) *GetBucketAnalyticsConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetBucketAnalyticsConfigurationInput) SetId(v string) *GetBucketAnalyticsConfigurationInput {
	s.Id = &v
	return s
}

func (s *GetBucketAnalyticsConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketAnalyticsConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketAnalyticsConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketAnalyticsConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"AnalyticsConfiguration"`

	// The configuration and any analyses for the analytics filter.
	AnalyticsConfiguration *AnalyticsConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAnalyticsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketAnalyticsConfigurationOutput) GoString() string {
	return s.String()
}

// SetAnalyticsConfiguration sets the AnalyticsConfiguration field's value.
func (s *GetBucketAnalyticsConfigurationOutput) SetAnalyticsConfiguration(v *AnalyticsConfiguration) *GetBucketAnalyticsConfigurationOutput {
	s.AnalyticsConfiguration = v
	return s
}

type GetBucketCorsInput struct {
	_ struct{} `locationName:"GetBucketCorsRequest" type:"structure"`

	// The bucket name for which to get the cors configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketCorsInput) SetBucket(v string) *GetBucketCorsInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketCorsInput) SetExpectedBucketOwner(v string) *GetBucketCorsInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketCorsInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketCorsInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketCorsInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketCorsOutput struct {
	_ struct{} `type:"structure"`

	// A set of origins and methods (cross-origin access that you want to allow).
	// You can add up to 100 rules to the configuration.
	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketCorsOutput) GoString() string {
	return s.String()
}

// SetCORSRules sets the CORSRules field's value.
func (s *GetBucketCorsOutput) SetCORSRules(v []*CORSRule) *GetBucketCorsOutput {
	s.CORSRules = v
	return s
}

type GetBucketEncryptionInput struct {
	_ struct{} `locationName:"GetBucketEncryptionRequest" type:"structure"`

	// The name of the bucket from which the server-side encryption configuration
	// is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketEncryptionInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketEncryptionInput) SetBucket(v string) *GetBucketEncryptionInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketEncryptionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketEncryptionInput) SetExpectedBucketOwner(v string) *GetBucketEncryptionInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketEncryptionInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketEncryptionInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketEncryptionInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketEncryptionOutput struct {
	_ struct{} `type:"structure" payload:"ServerSideEncryptionConfiguration"`

	// Specifies the default server-side-encryption configuration.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketEncryptionOutput) GoString() string {
	return s.String()
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *GetBucketEncryptionOutput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *GetBucketEncryptionOutput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

type GetBucketIntelligentTieringConfigurationInput struct {
	_ struct{} `locationName:"GetBucketIntelligentTieringConfigurationRequest" type:"structure"`

	// The name of the Amazon S3 bucket whose configuration you want to modify or
	// retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the S3 Intelligent-Tiering configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketIntelligentTieringConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketIntelligentTieringConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketIntelligentTieringConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketIntelligentTieringConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketIntelligentTieringConfigurationInput) SetBucket(v string) *GetBucketIntelligentTieringConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketIntelligentTieringConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *GetBucketIntelligentTieringConfigurationInput) SetId(v string) *GetBucketIntelligentTieringConfigurationInput {
	s.Id = &v
	return s
}

func (s *GetBucketIntelligentTieringConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketIntelligentTieringConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketIntelligentTieringConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketIntelligentTieringConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"IntelligentTieringConfiguration"`

	// Container for S3 Intelligent-Tiering configuration.
	IntelligentTieringConfiguration *IntelligentTieringConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketIntelligentTieringConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketIntelligentTieringConfigurationOutput) GoString() string {
	return s.String()
}

// SetIntelligentTieringConfiguration sets the IntelligentTieringConfiguration field's value.
func (s *GetBucketIntelligentTieringConfigurationOutput) SetIntelligentTieringConfiguration(v *IntelligentTieringConfiguration) *GetBucketIntelligentTieringConfigurationOutput {
	s.IntelligentTieringConfiguration = v
	return s
}

type GetBucketInventoryConfigurationInput struct {
	_ struct{} `locationName:"GetBucketInventoryConfigurationRequest" type:"structure"`

	// The name of the bucket containing the inventory configuration to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketInventoryConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketInventoryConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketInventoryConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketInventoryConfigurationInput) SetBucket(v string) *GetBucketInventoryConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketInventoryConfigurationInput) SetExpectedBucketOwner(v string) *GetBucketInventoryConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetBucketInventoryConfigurationInput) SetId(v string) *GetBucketInventoryConfigurationInput {
	s.Id = &v
	return s
}

func (s *GetBucketInventoryConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketInventoryConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketInventoryConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"InventoryConfiguration"`

	// Specifies the inventory configuration.
	InventoryConfiguration *InventoryConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketInventoryConfigurationOutput) GoString() string {
	return s.String()
}

// SetInventoryConfiguration sets the InventoryConfiguration field's value.
func (s *GetBucketInventoryConfigurationOutput) SetInventoryConfiguration(v *InventoryConfiguration) *GetBucketInventoryConfigurationOutput {
	s.InventoryConfiguration = v
	return s
}

type GetBucketLifecycleConfigurationInput struct {
	_ struct{} `locationName:"GetBucketLifecycleConfigurationRequest" type:"structure"`

	// The name of the bucket for which to get the lifecycle information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLifecycleConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLifecycleConfigurationInput) SetBucket(v string) *GetBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLifecycleConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketLifecycleConfigurationInput) SetExpectedBucketOwner(v string) *GetBucketLifecycleConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketLifecycleConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketLifecycleConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketLifecycleConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Container for a lifecycle rule.
	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *GetBucketLifecycleConfigurationOutput) SetRules(v []*LifecycleRule) *GetBucketLifecycleConfigurationOutput {
	s.Rules = v
	return s
}

type GetBucketLifecycleInput struct {
	_ struct{} `locationName:"GetBucketLifecycleRequest" type:"structure"`

	// The name of the bucket for which to get the lifecycle information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLifecycleInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLifecycleInput) SetBucket(v string) *GetBucketLifecycleInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketLifecycleInput) SetExpectedBucketOwner(v string) *GetBucketLifecycleInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketLifecycleInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketLifecycleInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketLifecycleInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`

	// Container for a lifecycle rule.
	Rules []*Rule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *GetBucketLifecycleOutput) SetRules(v []*Rule) *GetBucketLifecycleOutput {
	s.Rules = v
	return s
}

type GetBucketLocationInput struct {
	_ struct{} `locationName:"GetBucketLocationRequest" type:"structure"`

	// The name of the bucket for which to get the location.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLocationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLocationInput) SetBucket(v string) *GetBucketLocationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLocationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketLocationInput) SetExpectedBucketOwner(v string) *GetBucketLocationInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketLocationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketLocationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketLocationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketLocationOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Region where the bucket resides. For a list of all the Amazon
	// S3 supported location constraints by Region, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region).
	// Buckets in Region us-east-1 have a LocationConstraint of null.
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLocationOutput) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *GetBucketLocationOutput) SetLocationConstraint(v string) *GetBucketLocationOutput {
	s.LocationConstraint = &v
	return s
}

type GetBucketLoggingInput struct {
	_ struct{} `locationName:"GetBucketLoggingRequest" type:"structure"`

	// The bucket name for which to get the logging information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLoggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLoggingInput) SetBucket(v string) *GetBucketLoggingInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLoggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketLoggingInput) SetExpectedBucketOwner(v string) *GetBucketLoggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketLoggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketLoggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketLoggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketLoggingOutput struct {
	_ struct{} `type:"structure"`

	// Describes where logs are stored and the prefix that Amazon S3 assigns to
	// all log object keys for a bucket. For more information, see PUT Bucket logging
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html)
	// in the Amazon S3 API Reference.
	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLoggingOutput) GoString() string {
	return s.String()
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *GetBucketLoggingOutput) SetLoggingEnabled(v *LoggingEnabled) *GetBucketLoggingOutput {
	s.LoggingEnabled = v
	return s
}

type GetBucketMetricsConfigurationInput struct {
	_ struct{} `locationName:"GetBucketMetricsConfigurationRequest" type:"structure"`

	// The name of the bucket containing the metrics configuration to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketMetricsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketMetricsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketMetricsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketMetricsConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketMetricsConfigurationInput) SetBucket(v string) *GetBucketMetricsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketMetricsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketMetricsConfigurationInput) SetExpectedBucketOwner(v string) *GetBucketMetricsConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetBucketMetricsConfigurationInput) SetId(v string) *GetBucketMetricsConfigurationInput {
	s.Id = &v
	return s
}

func (s *GetBucketMetricsConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketMetricsConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketMetricsConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketMetricsConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"MetricsConfiguration"`

	// Specifies the metrics configuration.
	MetricsConfiguration *MetricsConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketMetricsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketMetricsConfigurationOutput) GoString() string {
	return s.String()
}

// SetMetricsConfiguration sets the MetricsConfiguration field's value.
func (s *GetBucketMetricsConfigurationOutput) SetMetricsConfiguration(v *MetricsConfiguration) *GetBucketMetricsConfigurationOutput {
	s.MetricsConfiguration = v
	return s
}

type GetBucketNotificationConfigurationRequest struct {
	_ struct{} `locationName:"GetBucketNotificationConfigurationRequest" type:"structure"`

	// The name of the bucket for which to get the notification configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketNotificationConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketNotificationConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketNotificationConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketNotificationConfigurationRequest"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketNotificationConfigurationRequest) SetBucket(v string) *GetBucketNotificationConfigurationRequest {
	s.Bucket = &v
	return s
}

func (s *GetBucketNotificationConfigurationRequest) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketNotificationConfigurationRequest) SetExpectedBucketOwner(v string) *GetBucketNotificationConfigurationRequest {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketNotificationConfigurationRequest) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketNotificationConfigurationRequest) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketNotificationConfigurationRequest) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketOwnershipControlsInput struct {
	_ struct{} `locationName:"GetBucketOwnershipControlsRequest" type:"structure"`

	// The name of the Amazon S3 bucket whose OwnershipControls you want to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketOwnershipControlsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketOwnershipControlsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketOwnershipControlsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketOwnershipControlsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketOwnershipControlsInput) SetBucket(v string) *GetBucketOwnershipControlsInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketOwnershipControlsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketOwnershipControlsInput) SetExpectedBucketOwner(v string) *GetBucketOwnershipControlsInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketOwnershipControlsInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketOwnershipControlsInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketOwnershipControlsInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketOwnershipControlsOutput struct {
	_ struct{} `type:"structure" payload:"OwnershipControls"`

	// The OwnershipControls (BucketOwnerEnforced, BucketOwnerPreferred, or ObjectWriter)
	// currently in effect for this Amazon S3 bucket.
	OwnershipControls *OwnershipControls `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketOwnershipControlsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketOwnershipControlsOutput) GoString() string {
	return s.String()
}

// SetOwnershipControls sets the OwnershipControls field's value.
func (s *GetBucketOwnershipControlsOutput) SetOwnershipControls(v *OwnershipControls) *GetBucketOwnershipControlsOutput {
	s.OwnershipControls = v
	return s
}

type GetBucketPolicyInput struct {
	_ struct{} `locationName:"GetBucketPolicyRequest" type:"structure"`

	// The bucket name for which to get the bucket policy.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketPolicyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketPolicyInput) SetBucket(v string) *GetBucketPolicyInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketPolicyInput) SetExpectedBucketOwner(v string) *GetBucketPolicyInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketPolicyInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketPolicyOutput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// The bucket policy as a JSON document.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetBucketPolicyOutput) SetPolicy(v string) *GetBucketPolicyOutput {
	s.Policy = &v
	return s
}

type GetBucketPolicyStatusInput struct {
	_ struct{} `locationName:"GetBucketPolicyStatusRequest" type:"structure"`

	// The name of the Amazon S3 bucket whose policy status you want to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketPolicyStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketPolicyStatusInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketPolicyStatusInput) SetBucket(v string) *GetBucketPolicyStatusInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketPolicyStatusInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketPolicyStatusInput) SetExpectedBucketOwner(v string) *GetBucketPolicyStatusInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketPolicyStatusInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketPolicyStatusInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketPolicyStatusInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketPolicyStatusOutput struct {
	_ struct{} `type:"structure" payload:"PolicyStatus"`

	// The policy status for the specified bucket.
	PolicyStatus *PolicyStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyStatusOutput) GoString() string {
	return s.String()
}

// SetPolicyStatus sets the PolicyStatus field's value.
func (s *GetBucketPolicyStatusOutput) SetPolicyStatus(v *PolicyStatus) *GetBucketPolicyStatusOutput {
	s.PolicyStatus = v
	return s
}

type GetBucketReplicationInput struct {
	_ struct{} `locationName:"GetBucketReplicationRequest" type:"structure"`

	// The bucket name for which to get the replication information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketReplicationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketReplicationInput) SetBucket(v string) *GetBucketReplicationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketReplicationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketReplicationInput) SetExpectedBucketOwner(v string) *GetBucketReplicationInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketReplicationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketReplicationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketReplicationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketReplicationOutput struct {
	_ struct{} `type:"structure" payload:"ReplicationConfiguration"`

	// A container for replication rules. You can add up to 1,000 rules. The maximum
	// size of a replication configuration is 2 MB.
	ReplicationConfiguration *ReplicationConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketReplicationOutput) GoString() string {
	return s.String()
}

// SetReplicationConfiguration sets the ReplicationConfiguration field's value.
func (s *GetBucketReplicationOutput) SetReplicationConfiguration(v *ReplicationConfiguration) *GetBucketReplicationOutput {
	s.ReplicationConfiguration = v
	return s
}

type GetBucketRequestPaymentInput struct {
	_ struct{} `locationName:"GetBucketRequestPaymentRequest" type:"structure"`

	// The name of the bucket for which to get the payment request configuration
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketRequestPaymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketRequestPaymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketRequestPaymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketRequestPaymentInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketRequestPaymentInput) SetBucket(v string) *GetBucketRequestPaymentInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketRequestPaymentInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketRequestPaymentInput) SetExpectedBucketOwner(v string) *GetBucketRequestPaymentInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketRequestPaymentInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketRequestPaymentInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketRequestPaymentInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketRequestPaymentOutput struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	Payer *string `type:"string" enum:"Payer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketRequestPaymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketRequestPaymentOutput) GoString() string {
	return s.String()
}

// SetPayer sets the Payer field's value.
func (s *GetBucketRequestPaymentOutput) SetPayer(v string) *GetBucketRequestPaymentOutput {
	s.Payer = &v
	return s
}

type GetBucketTaggingInput struct {
	_ struct{} `locationName:"GetBucketTaggingRequest" type:"structure"`

	// The name of the bucket for which to get the tagging information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketTaggingInput) SetBucket(v string) *GetBucketTaggingInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketTaggingInput) SetExpectedBucketOwner(v string) *GetBucketTaggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketTaggingOutput struct {
	_ struct{} `type:"structure"`

	// Contains the tag set.
	//
	// TagSet is a required field
	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketTaggingOutput) GoString() string {
	return s.String()
}

// SetTagSet sets the TagSet field's value.
func (s *GetBucketTaggingOutput) SetTagSet(v []*Tag) *GetBucketTaggingOutput {
	s.TagSet = v
	return s
}

type GetBucketVersioningInput struct {
	_ struct{} `locationName:"GetBucketVersioningRequest" type:"structure"`

	// The name of the bucket for which to get the versioning information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketVersioningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketVersioningInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketVersioningInput) SetBucket(v string) *GetBucketVersioningInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketVersioningInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketVersioningInput) SetExpectedBucketOwner(v string) *GetBucketVersioningInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketVersioningInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketVersioningInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketVersioningInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketVersioningOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADeleteStatus"`

	// The versioning state of the bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketVersioningOutput) GoString() string {
	return s.String()
}

// SetMFADelete sets the MFADelete field's value.
func (s *GetBucketVersioningOutput) SetMFADelete(v string) *GetBucketVersioningOutput {
	s.MFADelete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBucketVersioningOutput) SetStatus(v string) *GetBucketVersioningOutput {
	s.Status = &v
	return s
}

type GetBucketWebsiteInput struct {
	_ struct{} `locationName:"GetBucketWebsiteRequest" type:"structure"`

	// The bucket name for which to get the website configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketWebsiteInput) SetBucket(v string) *GetBucketWebsiteInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketWebsiteInput) SetExpectedBucketOwner(v string) *GetBucketWebsiteInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetBucketWebsiteInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketWebsiteInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketWebsiteInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`

	// The object key name of the website error document to use for 4XX class errors.
	ErrorDocument *ErrorDocument `type:"structure"`

	// The name of the index document for the website (for example index.html).
	IndexDocument *IndexDocument `type:"structure"`

	// Specifies the redirect behavior of all requests to a website endpoint of
	// an Amazon S3 bucket.
	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	// Rules that define when a redirect is applied and the redirect behavior.
	RoutingRules []*RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketWebsiteOutput) GoString() string {
	return s.String()
}

// SetErrorDocument sets the ErrorDocument field's value.
func (s *GetBucketWebsiteOutput) SetErrorDocument(v *ErrorDocument) *GetBucketWebsiteOutput {
	s.ErrorDocument = v
	return s
}

// SetIndexDocument sets the IndexDocument field's value.
func (s *GetBucketWebsiteOutput) SetIndexDocument(v *IndexDocument) *GetBucketWebsiteOutput {
	s.IndexDocument = v
	return s
}

// SetRedirectAllRequestsTo sets the RedirectAllRequestsTo field's value.
func (s *GetBucketWebsiteOutput) SetRedirectAllRequestsTo(v *RedirectAllRequestsTo) *GetBucketWebsiteOutput {
	s.RedirectAllRequestsTo = v
	return s
}

// SetRoutingRules sets the RoutingRules field's value.
func (s *GetBucketWebsiteOutput) SetRoutingRules(v []*RoutingRule) *GetBucketWebsiteOutput {
	s.RoutingRules = v
	return s
}

type GetObjectAclInput struct {
	_ struct{} `locationName:"GetObjectAclRequest" type:"structure"`

	// The bucket name that contains the object for which to get the ACL information.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The key of the object for which to get the ACL information.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectAclInput) SetBucket(v string) *GetObjectAclInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectAclInput) SetExpectedBucketOwner(v string) *GetObjectAclInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectAclInput) SetKey(v string) *GetObjectAclInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectAclInput) SetRequestPayer(v string) *GetObjectAclInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectAclInput) SetVersionId(v string) *GetObjectAclInput {
	s.VersionId = &v
	return s
}

func (s *GetObjectAclInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetObjectAclInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetObjectAclInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	// Container for the bucket owner's display name and ID.
	Owner *Owner `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAclOutput) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *GetObjectAclOutput) SetGrants(v []*Grant) *GetObjectAclOutput {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetObjectAclOutput) SetOwner(v *Owner) *GetObjectAclOutput {
	s.Owner = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectAclOutput) SetRequestCharged(v string) *GetObjectAclOutput {
	s.RequestCharged = &v
	return s
}

type GetObjectAttributesInput struct {
	_ struct{} `locationName:"GetObjectAttributesRequest" type:"structure"`

	// The name of the bucket that contains the object.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The object key.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Sets the maximum number of parts to return.
	MaxParts *int64 `location:"header" locationName:"x-amz-max-parts" type:"integer"`

	// An XML header that specifies the fields at the root level that you want returned
	// in the response. Fields that you do not specify are not returned.
	//
	// ObjectAttributes is a required field
	ObjectAttributes []*string `location:"header" locationName:"x-amz-object-attributes" type:"list" required:"true" enum:"ObjectAttributes"`

	// Specifies the part after which listing should begin. Only parts with higher
	// part numbers will be listed.
	PartNumberMarker *int64 `location:"header" locationName:"x-amz-part-number-marker" type:"integer"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use when encrypting the object (for example, AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	//
	// SSECustomerKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetObjectAttributesInput's
	// String and GoString methods.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// The version ID used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectAttributesInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.ObjectAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectAttributes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectAttributesInput) SetBucket(v string) *GetObjectAttributesInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectAttributesInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectAttributesInput) SetExpectedBucketOwner(v string) *GetObjectAttributesInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectAttributesInput) SetKey(v string) *GetObjectAttributesInput {
	s.Key = &v
	return s
}

// SetMaxParts sets the MaxParts field's value.
func (s *GetObjectAttributesInput) SetMaxParts(v int64) *GetObjectAttributesInput {
	s.MaxParts = &v
	return s
}

// SetObjectAttributes sets the ObjectAttributes field's value.
func (s *GetObjectAttributesInput) SetObjectAttributes(v []*string) *GetObjectAttributesInput {
	s.ObjectAttributes = v
	return s
}

// SetPartNumberMarker sets the PartNumberMarker field's value.
func (s *GetObjectAttributesInput) SetPartNumberMarker(v int64) *GetObjectAttributesInput {
	s.PartNumberMarker = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectAttributesInput) SetRequestPayer(v string) *GetObjectAttributesInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *GetObjectAttributesInput) SetSSECustomerAlgorithm(v string) *GetObjectAttributesInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *GetObjectAttributesInput) SetSSECustomerKey(v string) *GetObjectAttributesInput {
	s.SSECustomerKey = &v
	return s
}

func (s *GetObjectAttributesInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *GetObjectAttributesInput) SetSSECustomerKeyMD5(v string) *GetObjectAttributesInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectAttributesInput) SetVersionId(v string) *GetObjectAttributesInput {
	s.VersionId = &v
	return s
}

func (s *GetObjectAttributesInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetObjectAttributesInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetObjectAttributesInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetObjectAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The checksum or digest of the object.
	Checksum *Checksum `type:"structure"`

	// Specifies whether the object retrieved was (true) or was not (false) a delete
	// marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL.
	ETag *string `type:"string"`

	// The creation date of the object.
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp"`

	// A collection of parts associated with a multipart upload.
	ObjectParts *GetObjectAttributesParts `type:"structure"`

	// The size of the object in bytes.
	ObjectSize *int64 `type:"long"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Provides the storage class information of the object. Amazon S3 returns this
	// header for all objects except for S3 Standard storage class objects.
	//
	// For more information, see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html).
	StorageClass *string `type:"string" enum:"StorageClass"`

	// The version ID of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAttributesOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *GetObjectAttributesOutput) SetChecksum(v *Checksum) *GetObjectAttributesOutput {
	s.Checksum = v
	return s
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *GetObjectAttributesOutput) SetDeleteMarker(v bool) *GetObjectAttributesOutput {
	s.DeleteMarker = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetObjectAttributesOutput) SetETag(v string) *GetObjectAttributesOutput {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetObjectAttributesOutput) SetLastModified(v time.Time) *GetObjectAttributesOutput {
	s.LastModified = &v
	return s
}

// SetObjectParts sets the ObjectParts field's value.
func (s *GetObjectAttributesOutput) SetObjectParts(v *GetObjectAttributesParts) *GetObjectAttributesOutput {
	s.ObjectParts = v
	return s
}

// SetObjectSize sets the ObjectSize field's value.
func (s *GetObjectAttributesOutput) SetObjectSize(v int64) *GetObjectAttributesOutput {
	s.ObjectSize = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectAttributesOutput) SetRequestCharged(v string) *GetObjectAttributesOutput {
	s.RequestCharged = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *GetObjectAttributesOutput) SetStorageClass(v string) *GetObjectAttributesOutput {
	s.StorageClass = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectAttributesOutput) SetVersionId(v string) *GetObjectAttributesOutput {
	s.VersionId = &v
	return s
}

// A collection of parts associated with a multipart upload.
type GetObjectAttributesParts struct {
	_ struct{} `type:"structure"`

	// Indicates whether the returned list of parts is truncated. A value of true
	// indicates that the list was truncated. A list can be truncated if the number
	// of parts exceeds the limit returned in the MaxParts element.
	IsTruncated *bool `type:"boolean"`

	// The maximum number of parts allowed in the response.
	MaxParts *int64 `type:"integer"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the PartNumberMarker request parameter in
	// a subsequent request.
	NextPartNumberMarker *int64 `type:"integer"`

	// The marker for the current part.
	PartNumberMarker *int64 `type:"integer"`

	// A container for elements related to a particular part. A response can contain
	// zero or more Parts elements.
	Parts []*ObjectPart `locationName:"Part" type:"list" flattened:"true"`

	// The total number of parts.
	TotalPartsCount *int64 `locationName:"PartsCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAttributesParts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectAttributesParts) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *GetObjectAttributesParts) SetIsTruncated(v bool) *GetObjectAttributesParts {
	s.IsTruncated = &v
	return s
}

// SetMaxParts sets the MaxParts field's value.
func (s *GetObjectAttributesParts) SetMaxParts(v int64) *GetObjectAttributesParts {
	s.MaxParts = &v
	return s
}

// SetNextPartNumberMarker sets the NextPartNumberMarker field's value.
func (s *GetObjectAttributesParts) SetNextPartNumberMarker(v int64) *GetObjectAttributesParts {
	s.NextPartNumberMarker = &v
	return s
}

// SetPartNumberMarker sets the PartNumberMarker field's value.
func (s *GetObjectAttributesParts) SetPartNumberMarker(v int64) *GetObjectAttributesParts {
	s.PartNumberMarker = &v
	return s
}

// SetParts sets the Parts field's value.
func (s *GetObjectAttributesParts) SetParts(v []*ObjectPart) *GetObjectAttributesParts {
	s.Parts = v
	return s
}

// SetTotalPartsCount sets the TotalPartsCount field's value.
func (s *GetObjectAttributesParts) SetTotalPartsCount(v int64) *GetObjectAttributesParts {
	s.TotalPartsCount = &v
	return s
}

type GetObjectInput struct {
	_ struct{} `locationName:"GetObjectRequest" type:"structure"`

	// The bucket name containing the object.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using an Object Lambda access point the hostname takes the form AccessPointName-AccountId.s3-object-lambda.Region.amazonaws.com.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// To retrieve the checksum, this mode must be enabled.
	//
	// The AWS SDK for Go v1 does not support automatic response payload checksum
	// validation. This feature is available in the AWS SDK for Go v2.
	ChecksumMode *string `location:"header" locationName:"x-amz-checksum-mode" type:"string" enum:"ChecksumMode"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Return the object only if its entity tag (ETag) is the same as the one specified;
	// otherwise, return a 412 (precondition failed) error.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time;
	// otherwise, return a 304 (not modified) error.
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified; otherwise, return a 304 (not modified) error.
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time;
	// otherwise, return a 412 (precondition failed) error.
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp"`

	// Key of the object to get.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified.
	// Useful for downloading just a part of an object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, see https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35
	// (https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35).
	//
	// Amazon S3 doesn't support retrieving multiple ranges of data per GET request.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Sets the Cache-Control header of the response.
	ResponseCacheControl *string `location:"querystring" locationName:"response-cache-control" type:"string"`

	// Sets the Content-Disposition header of the response
	ResponseContentDisposition *string `location:"querystring" locationName:"response-content-disposition" type:"string"`

	// Sets the Content-Encoding header of the response.
	ResponseContentEncoding *string `location:"querystring" locationName:"response-content-encoding" type:"string"`

	// Sets the Content-Language header of the response.
	ResponseContentLanguage *string `location:"querystring" locationName:"response-content-language" type:"string"`

	// Sets the Content-Type header of the response.
	ResponseContentType *string `location:"querystring" locationName:"response-content-type" type:"string"`

	// Sets the Expires header of the response.
	ResponseExpires *time.Time `location:"querystring" locationName:"response-expires" type:"timestamp" timestampFormat:"rfc822"`

	// Specifies the algorithm to use to when decrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 used to encrypt
	// the data. This value is used to decrypt the object when recovering it and
	// must match the one used when storing the data. The key must be appropriate
	// for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	//
	// SSECustomerKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetObjectInput's
	// String and GoString methods.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectInput) SetBucket(v string) *GetObjectInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetChecksumMode sets the ChecksumMode field's value.
func (s *GetObjectInput) SetChecksumMode(v string) *GetObjectInput {
	s.ChecksumMode = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectInput) SetExpectedBucketOwner(v string) *GetObjectInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *GetObjectInput) SetIfMatch(v string) *GetObjectInput {
	s.IfMatch = &v
	return s
}

// SetIfModifiedSince sets the IfModifiedSince field's value.
func (s *GetObjectInput) SetIfModifiedSince(v time.Time) *GetObjectInput {
	s.IfModifiedSince = &v
	return s
}

// SetIfNoneMatch sets the IfNoneMatch field's value.
func (s *GetObjectInput) SetIfNoneMatch(v string) *GetObjectInput {
	s.IfNoneMatch = &v
	return s
}

// SetIfUnmodifiedSince sets the IfUnmodifiedSince field's value.
func (s *GetObjectInput) SetIfUnmodifiedSince(v time.Time) *GetObjectInput {
	s.IfUnmodifiedSince = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectInput) SetKey(v string) *GetObjectInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *GetObjectInput) SetPartNumber(v int64) *GetObjectInput {
	s.PartNumber = &v
	return s
}

// SetRange sets the Range field's value.
func (s *GetObjectInput) SetRange(v string) *GetObjectInput {
	s.Range = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectInput) SetRequestPayer(v string) *GetObjectInput {
	s.RequestPayer = &v
	return s
}

// SetResponseCacheControl sets the ResponseCacheControl field's value.
func (s *GetObjectInput) SetResponseCacheControl(v string) *GetObjectInput {
	s.ResponseCacheControl = &v
	return s
}

// SetResponseContentDisposition sets the ResponseContentDisposition field's value.
func (s *GetObjectInput) SetResponseContentDisposition(v string) *GetObjectInput {
	s.ResponseContentDisposition = &v
	return s
}

// SetResponseContentEncoding sets the ResponseContentEncoding field's value.
func (s *GetObjectInput) SetResponseContentEncoding(v string) *GetObjectInput {
	s.ResponseContentEncoding = &v
	return s
}

// SetResponseContentLanguage sets the ResponseContentLanguage field's value.
func (s *GetObjectInput) SetResponseContentLanguage(v string) *GetObjectInput {
	s.ResponseContentLanguage = &v
	return s
}

// SetResponseContentType sets the ResponseContentType field's value.
func (s *GetObjectInput) SetResponseContentType(v string) *GetObjectInput {
	s.ResponseContentType = &v
	return s
}

// SetResponseExpires sets the ResponseExpires field's value.
func (s *GetObjectInput) SetResponseExpires(v time.Time) *GetObjectInput {
	s.ResponseExpires = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *GetObjectInput) SetSSECustomerAlgorithm(v string) *GetObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *GetObjectInput) SetSSECustomerKey(v string) *GetObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *GetObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *GetObjectInput) SetSSECustomerKeyMD5(v string) *GetObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectInput) SetVersionId(v string) *GetObjectInput {
	s.VersionId = &v
	return s
}

func (s *GetObjectInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetObjectInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetObjectInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetObjectLegalHoldInput struct {
	_ struct{} `locationName:"GetObjectLegalHoldRequest" type:"structure"`

	// The bucket name containing the object whose legal hold status you want to
	// retrieve.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The key name for the object whose legal hold status you want to retrieve.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// The version ID of the object whose legal hold status you want to retrieve.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectLegalHoldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectLegalHoldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectLegalHoldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectLegalHoldInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectLegalHoldInput) SetBucket(v string) *GetObjectLegalHoldInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectLegalHoldInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectLegalHoldInput) SetExpectedBucketOwner(v string) *GetObjectLegalHoldInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectLegalHoldInput) SetKey(v string) *GetObjectLegalHoldInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectLegalHoldInput) SetRequestPayer(v string) *GetObjectLegalHoldInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectLegalHoldInput) SetVersionId(v string) *GetObjectLegalHoldInput {
	s.VersionId = &v
	return s
}

func (s *GetObjectLegalHoldInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetObjectLegalHoldInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetObjectLegalHoldInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetObjectLegalHoldOutput struct {
	_ struct{} `type:"structure" payload:"LegalHold"`

	// The current legal hold status for the specified object.
	LegalHold *ObjectLockLegalHold `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectLegalHoldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectLegalHoldOutput) GoString() string {
	return s.String()
}

// SetLegalHold sets the LegalHold field's value.
func (s *GetObjectLegalHoldOutput) SetLegalHold(v *ObjectLockLegalHold) *GetObjectLegalHoldOutput {
	s.LegalHold = v
	return s
}

type GetObjectLockConfigurationInput struct {
	_ struct{} `locationName:"GetObjectLockConfigurationRequest" type:"structure"`

	// The bucket whose Object Lock configuration you want to retrieve.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectLockConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectLockConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectLockConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectLockConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectLockConfigurationInput) SetBucket(v string) *GetObjectLockConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectLockConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectLockConfigurationInput) SetExpectedBucketOwner(v string) *GetObjectLockConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetObjectLockConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetObjectLockConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetObjectLockConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetObjectLockConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"ObjectLockConfiguration"`

	// The specified bucket's Object Lock configuration.
	ObjectLockConfiguration *ObjectLockConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectLockConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectLockConfigurationOutput) GoString() string {
	return s.String()
}

// SetObjectLockConfiguration sets the ObjectLockConfiguration field's value.
func (s *GetObjectLockConfigurationOutput) SetObjectLockConfiguration(v *ObjectLockConfiguration) *GetObjectLockConfigurationOutput {
	s.ObjectLockConfiguration = v
	return s
}

type GetObjectOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// Indicates that a range of bytes was specified.
	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Object data.
	Body io.ReadCloser `type:"blob"`

	// Indicates whether the object uses an S3 Bucket Key for server-side encryption
	// with Amazon Web Services KMS (SSE-KMS).
	BucketKeyEnabled *bool `location:"header" locationName:"x-amz-server-side-encryption-bucket-key-enabled" type:"boolean"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// The base64-encoded, 32-bit CRC32 checksum of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32 *string `location:"header" locationName:"x-amz-checksum-crc32" type:"string"`

	// The base64-encoded, 32-bit CRC32C checksum of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32C *string `location:"header" locationName:"x-amz-checksum-crc32c" type:"string"`

	// The base64-encoded, 160-bit SHA-1 digest of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA1 *string `location:"header" locationName:"x-amz-checksum-sha1" type:"string"`

	// The base64-encoded, 256-bit SHA-256 digest of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA256 *string `location:"header" locationName:"x-amz-checksum-sha256" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The portion of the object returned in the response.
	ContentRange *string `location:"header" locationName:"Content-Range" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An entity tag (ETag) is an opaque identifier assigned by a web server to
	// a specific version of a resource found at a URL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key-value pairs
	// providing object expiration information. The value of the rule-id is URL-encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	// Creation date of the object.
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp"`

	// A map of metadata to store with the object in S3.
	//
	// By default unmarshaled keys are written as a map keys in following canonicalized format:
	// the first letter and any letter following a hyphen will be capitalized, and the rest as lowercase.
	// Set `aws.Config.LowerCaseHeaderMaps` to `true` to write unmarshaled keys to the map as lowercase.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	// Indicates whether this object has an active legal hold. This field is only
	// returned if you have permission to view an object's legal hold status.
	ObjectLockLegalHoldStatus *string `location:"header" locationName:"x-amz-object-lock-legal-hold" type:"string" enum:"ObjectLockLegalHoldStatus"`

	// The Object Lock mode currently in place for this object.
	ObjectLockMode *string `location:"header" locationName:"x-amz-object-lock-mode" type:"string" enum:"ObjectLockMode"`

	// The date and time when this object's Object Lock will expire.
	ObjectLockRetainUntilDate *time.Time `location:"header" locationName:"x-amz-object-lock-retain-until-date" type:"timestamp" timestampFormat:"iso8601"`

	// The count of parts this object has. This value is only returned if you specify
	// partNumber in your request and the object was uploaded as a multipart upload.
	PartsCount *int64 `location:"header" locationName:"x-amz-mp-parts-count" type:"integer"`

	// Amazon S3 can return this if your request involves a bucket that is either
	// a source or destination in a replication rule.
	ReplicationStatus *string `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"ReplicationStatus"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Provides information about object restoration action and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the Amazon Web Services Key Management Service
	// (Amazon Web Services KMS) symmetric customer managed key that was used for
	// the object.
	//
	// SSEKMSKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetObjectOutput's
	// String and GoString methods.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Provides storage class information of the object. Amazon S3 returns this
	// header for all objects except for S3 Standard storage class objects.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The number of tags, if any, on the object.
	TagCount *int64 `location:"header" locationName:"x-amz-tagging-count" type:"integer"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectOutput) GoString() string {
	return s.String()
}

// SetAcceptRanges sets the AcceptRanges field's value.
func (s *GetObjectOutput) SetAcceptRanges(v string) *GetObjectOutput {
	s.AcceptRanges = &v
	return s
}

// SetBody sets the Body field's value.
func (s *GetObjectOutput) SetBody(v io.ReadCloser) *GetObjectOutput {
	s.Body = v
	return s
}

// SetBucketKeyEnabled sets the BucketKeyEnabled field's value.
func (s *GetObjectOutput) SetBucketKeyEnabled(v bool) *GetObjectOutput {
	s.BucketKeyEnabled = &v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *GetObjectOutput) SetCacheControl(v string) *GetObjectOutput {
	s.CacheControl = &v
	return s
}

// SetChecksumCRC32 sets the ChecksumCRC32 field's value.
func (s *GetObjectOutput) SetChecksumCRC32(v string) *GetObjectOutput {
	s.ChecksumCRC32 = &v
	return s
}

// SetChecksumCRC32C sets the ChecksumCRC32C field's value.
func (s *GetObjectOutput) SetChecksumCRC32C(v string) *GetObjectOutput {
	s.ChecksumCRC32C = &v
	return s
}

// SetChecksumSHA1 sets the ChecksumSHA1 field's value.
func (s *GetObjectOutput) SetChecksumSHA1(v string) *GetObjectOutput {
	s.ChecksumSHA1 = &v
	return s
}

// SetChecksumSHA256 sets the ChecksumSHA256 field's value.
func (s *GetObjectOutput) SetChecksumSHA256(v string) *GetObjectOutput {
	s.ChecksumSHA256 = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *GetObjectOutput) SetContentDisposition(v string) *GetObjectOutput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *GetObjectOutput) SetContentEncoding(v string) *GetObjectOutput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *GetObjectOutput) SetContentLanguage(v string) *GetObjectOutput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *GetObjectOutput) SetContentLength(v int64) *GetObjectOutput {
	s.ContentLength = &v
	return s
}

// SetContentRange sets the ContentRange field's value.
func (s *GetObjectOutput) SetContentRange(v string) *GetObjectOutput {
	s.ContentRange = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetObjectOutput) SetContentType(v string) *GetObjectOutput {
	s.ContentType = &v
	return s
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *GetObjectOutput) SetDeleteMarker(v bool) *GetObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetObjectOutput) SetETag(v string) *GetObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *GetObjectOutput) SetExpiration(v string) *GetObjectOutput {
	s.Expiration = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *GetObjectOutput) SetExpires(v string) *GetObjectOutput {
	s.Expires = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetObjectOutput) SetLastModified(v time.Time) *GetObjectOutput {
	s.LastModified = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetObjectOutput) SetMetadata(v map[string]*string) *GetObjectOutput {
	s.Metadata = v
	return s
}

// SetMissingMeta sets the MissingMeta field's value.
func (s *GetObjectOutput) SetMissingMeta(v int64) *GetObjectOutput {
	s.MissingMeta = &v
	return s
}

// SetObjectLockLegalHoldStatus sets the ObjectLockLegalHoldStatus field's value.
func (s *GetObjectOutput) SetObjectLockLegalHoldStatus(v string) *GetObjectOutput {
	s.ObjectLockLegalHoldStatus = &v
	return s
}

// SetObjectLockMode sets the ObjectLockMode field's value.
func (s *GetObjectOutput) SetObjectLockMode(v string) *GetObjectOutput {
	s.ObjectLockMode = &v
	return s
}

// SetObjectLockRetainUntilDate sets the ObjectLockRetainUntilDate field's value.
func (s *GetObjectOutput) SetObjectLockRetainUntilDate(v time.Time) *GetObjectOutput {
	s.ObjectLockRetainUntilDate = &v
	return s
}

// SetPartsCount sets the PartsCount field's value.
func (s *GetObjectOutput) SetPartsCount(v int64) *GetObjectOutput {
	s.PartsCount = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *GetObjectOutput) SetReplicationStatus(v string) *GetObjectOutput {
	s.ReplicationStatus = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectOutput) SetRequestCharged(v string) *GetObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetRestore sets the Restore field's value.
func (s *GetObjectOutput) SetRestore(v string) *GetObjectOutput {
	s.Restore = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *GetObjectOutput) SetSSECustomerAlgorithm(v string) *GetObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *GetObjectOutput) SetSSECustomerKeyMD5(v string) *GetObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *GetObjectOutput) SetSSEKMSKeyId(v string) *GetObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *GetObjectOutput) SetServerSideEncryption(v string) *GetObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *GetObjectOutput) SetStorageClass(v string) *GetObjectOutput {
	s.StorageClass = &v
	return s
}

// SetTagCount sets the TagCount field's value.
func (s *GetObjectOutput) SetTagCount(v int64) *GetObjectOutput {
	s.TagCount = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectOutput) SetVersionId(v string) *GetObjectOutput {
	s.VersionId = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *GetObjectOutput) SetWebsiteRedirectLocation(v string) *GetObjectOutput {
	s.WebsiteRedirectLocation = &v
	return s
}

type GetObjectRetentionInput struct {
	_ struct{} `locationName:"GetObjectRetentionRequest" type:"structure"`

	// The bucket name containing the object whose retention settings you want to
	// retrieve.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The key name for the object whose retention settings you want to retrieve.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// The version ID for the object whose retention settings you want to retrieve.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectRetentionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectRetentionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectRetentionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectRetentionInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectRetentionInput) SetBucket(v string) *GetObjectRetentionInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectRetentionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectRetentionInput) SetExpectedBucketOwner(v string) *GetObjectRetentionInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectRetentionInput) SetKey(v string) *GetObjectRetentionInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectRetentionInput) SetRequestPayer(v string) *GetObjectRetentionInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectRetentionInput) SetVersionId(v string) *GetObjectRetentionInput {
	s.VersionId = &v
	return s
}

func (s *GetObjectRetentionInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetObjectRetentionInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetObjectRetentionInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetObjectRetentionOutput struct {
	_ struct{} `type:"structure" payload:"Retention"`

	// The container element for an object's retention settings.
	Retention *ObjectLockRetention `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectRetentionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectRetentionOutput) GoString() string {
	return s.String()
}

// SetRetention sets the Retention field's value.
func (s *GetObjectRetentionOutput) SetRetention(v *ObjectLockRetention) *GetObjectRetentionOutput {
	s.Retention = v
	return s
}

type GetObjectTaggingInput struct {
	_ struct{} `locationName:"GetObjectTaggingRequest" type:"structure"`

	// The bucket name containing the object for which to get the tagging information.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Object key for which to get the tagging information.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// The versionId of the object for which to get the tagging information.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectTaggingInput) SetBucket(v string) *GetObjectTaggingInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectTaggingInput) SetExpectedBucketOwner(v string) *GetObjectTaggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectTaggingInput) SetKey(v string) *GetObjectTaggingInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectTaggingInput) SetRequestPayer(v string) *GetObjectTaggingInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectTaggingInput) SetVersionId(v string) *GetObjectTaggingInput {
	s.VersionId = &v
	return s
}

func (s *GetObjectTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetObjectTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetObjectTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	// Contains the tag set.
	//
	// TagSet is a required field
	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`

	// The versionId of the object for which you got the tagging information.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectTaggingOutput) GoString() string {
	return s.String()
}

// SetTagSet sets the TagSet field's value.
func (s *GetObjectTaggingOutput) SetTagSet(v []*Tag) *GetObjectTaggingOutput {
	s.TagSet = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectTaggingOutput) SetVersionId(v string) *GetObjectTaggingOutput {
	s.VersionId = &v
	return s
}

type GetObjectTorrentInput struct {
	_ struct{} `locationName:"GetObjectTorrentRequest" type:"structure"`

	// The name of the bucket containing the object for which to get the torrent
	// files.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The object key for which to get the information.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectTorrentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectTorrentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectTorrentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectTorrentInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectTorrentInput) SetBucket(v string) *GetObjectTorrentInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectTorrentInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectTorrentInput) SetExpectedBucketOwner(v string) *GetObjectTorrentInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectTorrentInput) SetKey(v string) *GetObjectTorrentInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectTorrentInput) SetRequestPayer(v string) *GetObjectTorrentInput {
	s.RequestPayer = &v
	return s
}

func (s *GetObjectTorrentInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetObjectTorrentInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetObjectTorrentInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetObjectTorrentOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// A Bencoded dictionary as defined by the BitTorrent specification
	Body io.ReadCloser `type:"blob"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectTorrentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetObjectTorrentOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *GetObjectTorrentOutput) SetBody(v io.ReadCloser) *GetObjectTorrentOutput {
	s.Body = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectTorrentOutput) SetRequestCharged(v string) *GetObjectTorrentOutput {
	s.RequestCharged = &v
	return s
}

type GetPublicAccessBlockInput struct {
	_ struct{} `locationName:"GetPublicAccessBlockRequest" type:"structure"`

	// The name of the Amazon S3 bucket whose PublicAccessBlock configuration you
	// want to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicAccessBlockInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetPublicAccessBlockInput) SetBucket(v string) *GetPublicAccessBlockInput {
	s.Bucket = &v
	return s
}

func (s *GetPublicAccessBlockInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetPublicAccessBlockInput) SetExpectedBucketOwner(v string) *GetPublicAccessBlockInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *GetPublicAccessBlockInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetPublicAccessBlockInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetPublicAccessBlockInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type GetPublicAccessBlockOutput struct {
	_ struct{} `type:"structure" payload:"PublicAccessBlockConfiguration"`

	// The PublicAccessBlock configuration currently in effect for this Amazon S3
	// bucket.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicAccessBlockOutput) GoString() string {
	return s.String()
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *GetPublicAccessBlockOutput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *GetPublicAccessBlockOutput {
	s.PublicAccessBlockConfiguration = v
	return s
}

// Container for S3 Glacier job parameters.
type GlacierJobParameters struct {
	_ struct{} `type:"structure"`

	// Retrieval tier at which the restore will be processed.
	//
	// Tier is a required field
	Tier *string `type:"string" required:"true" enum:"Tier"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlacierJobParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlacierJobParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlacierJobParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlacierJobParameters"}
	if s.Tier == nil {
		invalidParams.Add(request.NewErrParamRequired("Tier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTier sets the Tier field's value.
func (s *GlacierJobParameters) SetTier(v string) *GlacierJobParameters {
	s.Tier = &v
	return s
}

// Container for grant information.
type Grant struct {
	_ struct{} `type:"structure"`

	// The person being granted permissions.
	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Specifies the permission given to the grantee.
	Permission *string `type:"string" enum:"Permission"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Grant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *Grant) SetGrantee(v *Grantee) *Grant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *Grant) SetPermission(v string) *Grant {
	s.Permission = &v
	return s
}

// Container for the person being granted permissions.
type Grantee struct {
	_ struct{} `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	//
	// Using email addresses to specify a grantee is only supported in the following
	// Amazon Web Services Regions:
	//
	//    * US East (N. Virginia)
	//
	//    * US West (N. California)
	//
	//    * US West (Oregon)
	//
	//    * Asia Pacific (Singapore)
	//
	//    * Asia Pacific (Sydney)
	//
	//    * Asia Pacific (Tokyo)
	//
	//    * Europe (Ireland)
	//
	//    * South America (São Paulo)
	//
	// For a list of all the Amazon S3 supported Regions and endpoints, see Regions
	// and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
	// in the Amazon Web Services General Reference.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	//
	// Type is a required field
	Type *string `locationName:"xsi:type" type:"string" xmlAttribute:"true" required:"true" enum:"Type"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Grantee) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grantee) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grantee"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *Grantee) SetDisplayName(v string) *Grantee {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Grantee) SetEmailAddress(v string) *Grantee {
	s.EmailAddress = &v
	return s
}

// SetID sets the ID field's value.
func (s *Grantee) SetID(v string) *Grantee {
	s.ID = &v
	return s
}

// SetType sets the Type field's value.
func (s *Grantee) SetType(v string) *Grantee {
	s.Type = &v
	return s
}

// SetURI sets the URI field's value.
func (s *Grantee) SetURI(v string) *Grantee {
	s.URI = &v
	return s
}

type HeadBucketInput struct {
	_ struct{} `locationName:"HeadBucketRequest" type:"structure"`

	// The bucket name.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeadBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeadBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeadBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *HeadBucketInput) SetBucket(v string) *HeadBucketInput {
	s.Bucket = &v
	return s
}

func (s *HeadBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *HeadBucketInput) SetExpectedBucketOwner(v string) *HeadBucketInput {
	s.ExpectedBucketOwner = &v
	return s
}

func (s *HeadBucketInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *HeadBucketInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s HeadBucketInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type HeadBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeadBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeadBucketOutput) GoString() string {
	return s.String()
}

type HeadObjectInput struct {
	_ struct{} `locationName:"HeadObjectRequest" type:"structure"`

	// The name of the bucket containing the object.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the Amazon Web Services
	// SDKs, you provide the access point ARN in place of the bucket name. For more
	// information about access point ARNs, see Using access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action with S3 on Outposts through the Amazon Web Services SDKs,
	// you provide the Outposts bucket ARN in place of the bucket name. For more
	// information about S3 on Outposts ARNs, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// To retrieve the checksum, this parameter must be enabled.
	//
	// In addition, if you enable ChecksumMode and the object is encrypted with
	// Amazon Web Services Key Management Service (Amazon Web Services KMS), you
	// must have permission to use the kms:Decrypt action for the request to succeed.
	ChecksumMode *string `location:"header" locationName:"x-amz-checksum-mode" type:"string" enum:"ChecksumMode"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request fails with the HTTP status code 403 Forbidden
	// (access denied).
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Return the object only if its entity tag (ETag) is the same as the one specified;
	// otherwise, return a 412 (precondition failed) error.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time;
	// otherwise, return a 304 (not modified) error.
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified; otherwise, return a 304 (not modified) error.
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time;
	// otherwise, return a 412 (precondition failed) error.
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp"`

	// The object key.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified.
	// Useful querying about the size of the part and the number of parts in this
	// object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Because HeadObject returns only the metadata for an object, this parameter
	// has no effect.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from Requester Pays buckets, see Downloading Objects
	// in Requester Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 User Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	//
	// SSECustomerKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by HeadObjectInput's
	// String and GoString methods.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeadObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HeadObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeadObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *HeadObjectInput) SetBucket(v string) *HeadObjectInput {
	s.Bucket = &v
	return s
}

func (s *HeadObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetChecksumMode sets the ChecksumMode field's value.
func (s *HeadObjectInput) SetChecksumMode(v string) *HeadObjectInput {
	s.ChecksumMode = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *HeadObjectInput) SetExpectedBucketOwner(v string) *HeadObjectInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *HeadObjectInput) SetIfMatch(v string) *HeadObjectInput {
	s.IfMatch = &v
	return s
}

// SetIfModifiedSince sets the IfModifiedSince field's value.
func (s *HeadObjectInput) SetIfModifiedSince(v time.Time) *HeadObjectInput {
	s.IfModifiedSince = &v
	return s
}

// SetIfNoneMatch sets the IfNoneMatch field's value.
func (s *HeadObjectInput) SetIfNoneMatch(v string) *HeadObjectInput {
	s.IfNoneMatch = &v
	return s
}

// SetIfUnmodifiedSince sets the IfUnmodifiedSince field's value.
func (s *HeadObjectInput) SetIfUnmodifiedSince(v time.Time) *HeadObjectInput {
	s.IfUnmodifiedSince = &v
	return s
}

// SetKey sets the Key field's value.
func (s *HeadObjectInput) SetKey(v string) *HeadObjectInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *HeadObjectInput) SetPartNumber(v int64) *HeadObjectInput {
	s.PartNumber = &v
	return s
}

// SetRange sets the Range field's value.
func (s *HeadObjectInput) SetRange(v string) *HeadObjectInput {
	s.Range = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *HeadObjectInput) SetRequestPayer(v string) *HeadObjectInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *HeadObjectInput) SetSSECustomerAlgorithm(v string) *HeadObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *HeadObjectInput) SetSSECustomerKey(v string) *HeadObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *HeadObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *HeadObjectInput) SetSSECustomerKeyMD5(v string) *HeadObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *HeadObjectInput) SetVersionId(v string) *HeadObjectInput {
	s.VersionId = &v
	return s
}

func (s *HeadObjectInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *HeadObjectInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s HeadObjectInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

type HeadObjectOutput struct {
	_ struct{} `type:"structure"`

	// Indicates that a range of bytes was specified.
	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// The archive state of the head object.
	ArchiveStatus *string `location:"header" locationName:"x-amz-archive-status" type:"string" enum:"ArchiveStatus"`

	// Indicates whether the object uses an S3 Bucket Key for server-side encryption
	// with Amazon Web Services KMS (SSE-KMS).
	BucketKeyEnabled *bool `location:"header" locationName:"x-amz-server-side-encryption-bucket-key-enabled" type:"boolean"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// The base64-encoded, 32-bit CRC32 checksum of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32 *string `location:"header" locationName:"x-amz-checksum-crc32" type:"string"`

	// The base64-encoded, 32-bit CRC32C checksum of the object. This will only
	// be present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumCRC32C *string `location:"header" locationName:"x-amz-checksum-crc32c" type:"string"`

	// The base64-encoded, 160-bit SHA-1 digest of the object. This will only be
	// present if it was uploaded with the object. With multipart uploads, this
	// may not be a checksum value of the object. For more information about how
	// checksums are calculated with multipart uploads, see Checking object integrity
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html#large-object-checksums)
	// in the Amazon S3 User Guide.
	ChecksumSHA1 *string `location:"header" locationName:"x-amz-checksum-sha1" type:"string"`

	// The base64-encoded, 256-bit SHA-256 digest of the object. This will only
	// be p