/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.IServant;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceUnrevoke
implements IServant {
    public static Logger logger = LoggerFactory.getLogger(ServiceUnrevoke.class);
    private CAService mService;

    public ServiceUnrevoke(CAService service) {
        this.mService = service;
    }

    @Override
    public boolean service(Request request) throws EBaseException {
        boolean sendStatus = true;
        BigInteger[] oldSerialNo = request.getExtDataInBigIntegerArray("OLD_SERIALS");
        if (oldSerialNo == null || oldSerialNo.length < 1) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_UNREVOKE_MISSING_SERIAL", (Object[])new Object[0]));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_SERIAL_NUMBER", (String[])new String[0]));
        }
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository cr = engine.getCertificateRepository();
        String[] svcerrors = null;
        boolean needOldCerts = false;
        X509CertImpl[] oldCerts = request.getExtDataInCertArray("OLD_CERTS");
        if (oldCerts == null || oldCerts.length < 1) {
            needOldCerts = true;
            oldCerts = new X509CertImpl[oldSerialNo.length];
        }
        for (int i = 0; i < oldSerialNo.length; ++i) {
            try {
                if (oldSerialNo[i].compareTo(new BigInteger("0")) < 0) {
                    logger.error(CMS.getLogMessage((String)"CMSCORE_CA_UNREVOKE_MISSING_SERIAL", (Object[])new Object[0]));
                    throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_SERIAL_NUMBER", (String[])new String[0]));
                }
                if (needOldCerts) {
                    CertRecord certRec = cr.readCertificateRecord(oldSerialNo[i]);
                    oldCerts[i] = certRec.getCertificate();
                }
                this.mService.unrevokeCert(oldSerialNo[i], request.getRequestId().toString());
                continue;
            }
            catch (ECAException e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_UNREVOKE_FAILED", (Object[])new Object[]{oldSerialNo[i].toString(), request.getRequestId().toString()}), (Throwable)e);
                if (svcerrors == null) {
                    svcerrors = new String[oldSerialNo.length];
                }
                svcerrors[i] = e.toString();
            }
        }
        if (CAService.mCLAConnector != null) {
            request.setRequestType("uncert4crl");
            sendStatus = CAService.mCLAConnector.send(request);
            if (sendStatus && request.getExtDataInString("Error") != null) {
                request.setExtData("Result", Request.RES_SUCCESS);
                request.deleteExtData("Error");
            } else {
                request.setExtData("Result", Request.RES_ERROR);
                request.setExtData("Error", (Throwable)new ECAException(CMS.getUserMessage((String)"CMS_CA_SEND_CLA_REQUEST", (String[])new String[0])));
                return sendStatus;
            }
        }
        if (needOldCerts) {
            request.setExtData("OLD_CERTS", oldCerts);
        }
        if (svcerrors != null) {
            request.setExtData("serviceErrors", svcerrors);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_UNREVOKE_FAILED", (String[])new String[0]));
        }
        return sendStatus;
    }
}

