/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.CAEnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityKeyIdentifierExtDefault
extends CAEnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(AuthorityKeyIdentifierExtDefault.class);
    public static final String VAL_CRITICAL = "critical";
    public static final String VAL_KEY_ID = "keyid";

    public AuthorityKeyIdentifierExtDefault() {
        this.addValueName(VAL_CRITICAL);
        this.addValueName(VAL_KEY_ID);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_CRITICAL)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_KEY_ID)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_ID", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (!name.equals(VAL_CRITICAL) && !name.equals(VAL_KEY_ID)) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (info == null) {
            return null;
        }
        AuthorityKeyIdentifierExtension ext = (AuthorityKeyIdentifierExtension)this.getExtension(PKIXExtensions.AuthorityKey_Id.toString(), info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                logger.error("AuthorityKeyIdentifierExtDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals(VAL_CRITICAL)) {
            ext = (AuthorityKeyIdentifierExtension)this.getExtension(PKIXExtensions.AuthorityKey_Id.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_KEY_ID)) {
            ext = (AuthorityKeyIdentifierExtension)this.getExtension(PKIXExtensions.AuthorityKey_Id.toString(), info);
            if (ext == null) {
                return "";
            }
            KeyIdentifier kid = null;
            try {
                kid = (KeyIdentifier)ext.get("key_id");
            }
            catch (IOException e) {
                logger.warn("AuthorityKeyIdentifierExtDefault: " + e.getMessage(), (Throwable)e);
            }
            if (kid == null) {
                return "";
            }
            return this.toHexString(kid.getIdentifier());
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_AKI_EXT", (String[])new String[0]);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        AuthorityKeyIdentifierExtension ext;
        try {
            String localKey = this.getConfig("localKey");
            KeyIdentifier kid = null;
            if (localKey != null && localKey.equals("true")) {
                kid = this.getKeyIdentifier(info);
            } else {
                String authorityID = request.getExtDataInString("req_authority_id");
                X509CertImpl signingCert = this.getSigningCert(authorityID);
                kid = this.getCAKeyIdentifier(signingCert);
            }
            ext = this.createExtension(kid);
        }
        catch (Exception e) {
            throw new EProfileException((Throwable)e);
        }
        if (ext == null) {
            throw new EProfileException("Could not instantiate AuthorityKeyIdentifier extension.");
        }
        this.addExtension(PKIXExtensions.AuthorityKey_Id.toString(), (Extension)ext, info);
    }

    public AuthorityKeyIdentifierExtension createExtension(KeyIdentifier kid) throws EBaseException {
        if (kid == null) {
            return null;
        }
        AuthorityKeyIdentifierExtension ext = null;
        try {
            ext = new AuthorityKeyIdentifierExtension(false, kid, null, null);
        }
        catch (IOException e) {
            logger.warn("AuthorityKeyIdentifierExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

