/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.base.IAttrSet;
import com.netscape.certsrv.pattern.Pattern;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.UUID;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectAltNameExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(SubjectAltNameExtDefault.class);
    public static final String CONFIG_CRITICAL = "subjAltNameExtCritical";
    public static final String CONFIG_NUM_GNS = "subjAltNameNumGNs";
    public static final String CONFIG_GN_ENABLE = "subjAltExtGNEnable_";
    public static final String CONFIG_TYPE = "subjAltExtType_";
    public static final String CONFIG_PATTERN = "subjAltExtPattern_";
    public static final String CONFIG_SOURCE = "subjAltExtSource_";
    public static final String CONFIG_SOURCE_UUID4 = "UUID4";
    public static final String CONFIG_SAN_REQ_PATTERN_PREFIX = "$request.req_san_pattern_";
    public static final String VAL_CRITICAL = "subjAltNameExtCritical";
    public static final String VAL_GENERAL_NAMES = "subjAltNames";
    private static final String GN_ENABLE = "Enable";
    private static final String GN_TYPE = "Pattern Type";
    private static final String GN_PATTERN = "Pattern";
    private static final int DEF_NUM_GN = 1;
    private static final int MAX_NUM_GN = 100;

    protected int getNumGNs() {
        int num = 1;
        String numGNs = this.getConfig(CONFIG_NUM_GNS);
        if (numGNs != null) {
            try {
                num = Integer.parseInt(numGNs);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (num >= 100) {
            num = 1;
        }
        return num;
    }

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.refreshConfigAndValueNames();
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        int num = 0;
        if (name.equals(CONFIG_NUM_GNS)) {
            try {
                num = Integer.parseInt(value);
                if (num >= 100 || num < 0) {
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_GNS}));
                }
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_GNS}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public Enumeration<String> getConfigNames() {
        this.refreshConfigAndValueNames();
        return super.getConfigNames();
    }

    @Override
    protected void refreshConfigAndValueNames() {
        super.refreshConfigAndValueNames();
        this.addValueName("subjAltNameExtCritical");
        this.addValueName(VAL_GENERAL_NAMES);
        this.addConfigName("subjAltNameExtCritical");
        int num = this.getNumGNs();
        this.addConfigName(CONFIG_NUM_GNS);
        for (int i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_TYPE + i);
            this.addConfigName(CONFIG_PATTERN + i);
            this.addConfigName(CONFIG_GN_ENABLE + i);
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("subjAltNameExtCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_TYPE)) {
            return new Descriptor("choice", "RFC822Name,DNSName,DirectoryName,EDIPartyName,URIName,IPAddress,OIDName,OtherName", "RFC822Name", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_ALT_NAME_TYPE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_PATTERN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_ALT_NAME_PATTERN", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_GN_ENABLE)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_GN_ENABLE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_NUM_GNS)) {
            return new Descriptor("integer", null, "1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_GNS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("subjAltNameExtCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_GENERAL_NAMES)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_GENERAL_NAMES", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            SubjectAlternativeNameExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("subjAltNameExtCritical")) {
                ext = (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                boolean critical = Boolean.valueOf(value);
                ext.setCritical(critical);
            } else if (name.equals(VAL_GENERAL_NAMES)) {
                ext = (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                if (value.equals("")) {
                    this.deleteExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), info);
                    return;
                }
                GeneralNames gn = new GeneralNames();
                StringTokenizer st = new StringTokenizer(value, "\r\n");
                while (st.hasMoreTokens()) {
                    GeneralNameInterface n;
                    String gname = st.nextToken();
                    logger.debug("SubjectAltNameExtDefault: setValue GN:" + gname);
                    if (!this.isGeneralNameValid(gname) || (n = this.parseGeneralName(gname)) == null) continue;
                    if (!n.validSingle()) {
                        throw new EPropertyException("Not valid for Subject Alternative Name: " + gname);
                    }
                    gn.addElement((Object)n);
                }
                if (gn.size() == 0) {
                    logger.debug("GN size is zero");
                    this.deleteExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), info);
                    return;
                }
                logger.debug("GN size is non zero (" + gn.size() + ")");
                ext.set("subject_name", (Object)gn);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), (Extension)ext, info);
        }
        catch (Exception e) {
            logger.error("SubjectAltNameExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        try {
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            SubjectAlternativeNameExtension ext = (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), info);
            if (ext == null) {
                try {
                    this.populate(null, info);
                }
                catch (EProfileException e) {
                    throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                }
            }
            if (name.equals("subjAltNameExtCritical")) {
                ext = (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                return ext.isCritical() ? "true" : "false";
            }
            if (name.equals(VAL_GENERAL_NAMES)) {
                ext = (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                GeneralNames names = (GeneralNames)ext.get("subject_name");
                StringBuffer sb = new StringBuffer();
                Enumeration e = names.elements();
                while (e.hasMoreElements()) {
                    GeneralNameInterface gn = (GeneralNameInterface)e.nextElement();
                    if (!sb.toString().equals("")) {
                        sb.append("\r\n");
                    }
                    sb.append(this.toGeneralNameString(gn));
                    logger.debug("SubjectAltNameExtDefault: getValue append GN:" + this.toGeneralNameString(gn));
                }
                return sb.toString();
            }
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (IOException e) {
            logger.warn("SubjectAltNameExtDefault: getValue " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getText(Locale locale) {
        StringBuffer sb = new StringBuffer();
        int num = this.getNumGNs();
        for (int i = 0; i < num; ++i) {
            sb.append("Record #");
            sb.append(i);
            sb.append("{");
            sb.append("Pattern:");
            sb.append(this.getConfig(CONFIG_PATTERN + i));
            sb.append(",");
            sb.append("Pattern Type:");
            sb.append(this.getConfig(CONFIG_TYPE + i));
            sb.append(",");
            sb.append("Enable:");
            sb.append(this.getConfig(CONFIG_GN_ENABLE + i));
            sb.append("}");
        }
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_SUBJECT_ALT_NAME_EXT", (String[])new String[]{this.getConfig("subjAltNameExtCritical"), sb.toString()});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        SubjectAlternativeNameExtension ext = null;
        try {
            ext = this.createExtension(request);
        }
        catch (IOException e) {
            logger.warn("SubjectAltNameExtDefault: populate " + e.getMessage(), (Throwable)e);
        }
        if (ext != null) {
            this.addExtension(PKIXExtensions.SubjectAlternativeName_Id.toString(), (Extension)ext, info);
        } else {
            logger.warn("SubjectAltNameExtDefault: populate sees no extension.  get out");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubjectAlternativeNameExtension createExtension(Request request) throws IOException, EProfileException {
        SubjectAlternativeNameExtension ext = null;
        int num = this.getNumGNs();
        boolean critical = Boolean.valueOf(this.getConfig("subjAltNameExtCritical"));
        GeneralNames gn = new GeneralNames();
        int count = 0;
        for (int i = 0; i < num; ++i) {
            String gtype;
            String gname;
            block14: {
                String type;
                String pattern;
                block12: {
                    block13: {
                        String enable = this.getConfig(CONFIG_GN_ENABLE + i);
                        if (enable == null || !enable.equals("true")) continue;
                        logger.debug("SubjectAltNameExtDefault: createExtension i=" + i);
                        pattern = this.getConfig(CONFIG_PATTERN + i);
                        if (pattern == null || pattern.equals("")) {
                            pattern = " ";
                        }
                        if (pattern.equals("")) continue;
                        logger.debug("SubjectAltNameExtDefault: createExtension() pattern=" + pattern);
                        gname = "";
                        gtype = "";
                        String source = this.getConfig(CONFIG_SOURCE + i);
                        type = this.getConfig(CONFIG_TYPE + i);
                        if (source == null || source.equals("")) break block12;
                        if (!type.equalsIgnoreCase("OtherName")) break block13;
                        logger.debug("SubjectAlternativeNameExtension: using " + source + " as gn");
                        if (source.equals(CONFIG_SOURCE_UUID4)) {
                            UUID randUUID = UUID.randomUUID();
                            if (request != null) {
                                gname = this.mapPattern(randUUID.toString(), request, pattern);
                            }
                            break block14;
                        } else {
                            logger.warn("SubjectAltNameExtDefault: createExtension - unsupported server-generated type: " + source + ". Supported: UUID4");
                            continue;
                        }
                    }
                    logger.warn("SubjectAltNameExtDefault: createExtension - source is only supported for subjAltExtType OtherName");
                    continue;
                }
                if (request != null) {
                    gname = this.mapPattern(request, pattern);
                    gtype = this.mapPattern(request, type);
                }
            }
            if (gname.equals("") || gname.startsWith(CONFIG_SAN_REQ_PATTERN_PREFIX)) {
                logger.warn("SubjectAltNameExtDefault: gname is empty,not added.");
                continue;
            }
            logger.debug("SubjectAltNameExtDefault: createExtension got gname=" + gname + " with type=" + gtype);
            GeneralNameInterface n = this.parseGeneralName(gtype + ":" + gname);
            logger.debug("adding gname: " + gname);
            if (n != null) {
                if (!n.validSingle()) {
                    throw new EProfileException("Not valid for Subject Alternative Name: " + gtype + ":" + gname);
                }
                logger.debug("SubjectAlternativeNameExtension: n not null");
                gn.addElement((Object)n);
                ++count;
                continue;
            }
            logger.warn("SubjectAlternativeNameExtension: n null");
        }
        if (count == 0) {
            logger.debug("count is 0");
            return ext;
        }
        try {
            ext = new SubjectAlternativeNameExtension();
        }
        catch (Exception e) {
            logger.error("SubjectAltNameExtDefault: " + e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
        ext.set("subject_name", (Object)gn);
        ext.setCritical(critical);
        return ext;
    }

    @Override
    public String mapPattern(Request request, String pattern) throws IOException {
        Pattern p = new Pattern(pattern);
        IAttrSet attrSet = null;
        if (request != null) {
            attrSet = request.asIAttrSet();
        }
        return p.substitute("request", attrSet);
    }

    public String mapPattern(String val, Request request, String pattern) throws IOException {
        Pattern p = new Pattern(pattern);
        IAttrSet attrSet = null;
        if (request != null) {
            attrSet = request.asIAttrSet();
        }
        try {
            attrSet.set("source", (Object)val);
        }
        catch (Exception e) {
            logger.warn("SubjectAlternativeNameExtension: mapPattern source " + e.getMessage(), (Throwable)e);
        }
        return p.substitute("server", attrSet);
    }
}

