/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneRedirect
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(CloneRedirect.class);
    private static final long serialVersionUID = 3217967115281965166L;
    private static final String PROP_REDIRECT_URL = "masterURL";
    private static final String TPL_FILE = "cloneRedirect.template";
    private String mNewUrl = null;
    private String mFormPath = null;
    private CertificateAuthority mCA = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/" + this.mAuthority.getId() + "/cloneRedirect.template";
        if (this.mAuthority instanceof CertificateAuthority) {
            this.mCA = (CertificateAuthority)this.mAuthority;
            CAConfig authConfig = this.mCA.getConfigStore();
            if (authConfig != null) {
                try {
                    this.mNewUrl = authConfig.getString(PROP_REDIRECT_URL, "*** master URL unavailable, check your configuration ***");
                }
                catch (EBaseException eBaseException) {
                    // empty catch block
                }
            }
        }
        if (this.mAuthority instanceof CertificateAuthority) {
            this.mCA = (CertificateAuthority)this.mAuthority;
        }
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
        logger.debug("CloneRedirect: " + CMS.getLogMessage((String)"ADMIN_SRVLT_ADD_MASTER_URL", (Object[])new Object[]{this.mNewUrl}));
        header.addStringValue(PROP_REDIRECT_URL, this.mNewUrl);
        try {
            ServletOutputStream out = resp.getOutputStream();
            String xmlOutput = req.getParameter("xml");
            if (xmlOutput != null && xmlOutput.equals("true")) {
                this.outputXML(resp, argSet);
            } else {
                resp.setContentType("text/html");
                form.renderOutput((OutputStream)out, argSet);
                cmsReq.setStatus(CMSRequest.SUCCESS);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
    }
}

