/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.json.JSONObject;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caGetSubsystemCert", urlPatterns={"/admin/ca/getSubsystemCert"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="ID", value="caGetSubsystemCert"), @WebInitParam(name="resourceID", value="certServer.ee.certificate"), @WebInitParam(name="interface", value="ee")})
public class GetSubsystemCert
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetSubsystemCert.class);
    private static final long serialVersionUID = -5720342238234153488L;
    private static final String SUCCESS = "0";

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        Object nickname = "";
        try {
            nickname = cs.getString("ca.subsystem.nickname", "");
            String tokenname = cs.getString("ca.subsystem.tokenname", "");
            if (!CryptoUtil.isInternalToken((String)tokenname)) {
                nickname = tokenname + ":" + (String)nickname;
            }
        }
        catch (Exception tokenname) {
            // empty catch block
        }
        logger.debug("GetSubsystemCert process: nickname=" + (String)nickname);
        String s = "";
        try {
            CryptoManager cm = CryptoManager.getInstance();
            X509Certificate cert = cm.findCertByNickname((String)nickname);
            if (cert == null) {
                logger.warn("GetSubsystemCert process: subsystem cert is null");
                this.outputError(httpResp, "Error: Failed to get subsystem certificate.");
                return;
            }
            byte[] bytes = cert.getEncoded();
            s = CryptoUtil.normalizeCertStr((String)CryptoUtil.base64Encode((byte[])bytes));
        }
        catch (Exception e) {
            logger.warn("GetSubsystemCert process: exception: " + e.getMessage(), (Throwable)e);
        }
        try {
            JSONObject jsonObj = new JSONObject();
            ObjectNode responseNode = jsonObj.getMapper().createObjectNode();
            responseNode.put("Status", SUCCESS);
            responseNode.put("Cert", s);
            jsonObj.getRootNode().set("Response", (JsonNode)responseNode);
            this.outputResult(httpResp, "application/json", jsonObj.toByteArray());
        }
        catch (Exception e) {
            logger.warn("Failed to send the output: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage((String)lang), UserInfo.getUserCountry((String)lang));
        return locale;
    }
}

