/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.key.KeyClient;
import com.netscape.certsrv.key.KeyInfo;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.kra.KRAKeyCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyShowCLI.class);
    public KRAKeyCLI keyCLI;

    public KRAKeyShowCLI(KRAKeyCLI keyCLI) {
        super("show", "Get key", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Key ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "clientKeyID", true, "Unique client key identifier.");
        option.setArgName("Client Key Identifier");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        KeyInfo keyInfo;
        String[] cmdArgs = cmd.getArgs();
        String clientKeyId = cmd.getOptionValue("clientKeyID");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        KeyClient keyClient = this.keyCLI.getKeyClient();
        if (cmdArgs.length == 1) {
            KeyId keyId = new KeyId(cmdArgs[0]);
            keyInfo = keyClient.getKeyInfo(keyId);
        } else if (clientKeyId != null) {
            keyInfo = keyClient.getActiveKeyInfo(clientKeyId);
        } else {
            throw new Exception("Missing Key ID or Client Key ID.");
        }
        KRAKeyCLI.printKeyInfo(keyInfo);
    }
}

