/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.est;

import com.netscape.cms.realm.RealmCommon;
import com.netscape.cms.realm.RealmConfig;
import com.netscape.cms.tomcat.ProxyRealm;
import com.netscape.cmscore.apps.CMS;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import java.util.Properties;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.LifecycleBase;
import org.apache.tomcat.util.IntrospectionUtils;
import org.dogtagpki.est.ESTBackend;
import org.dogtagpki.est.ESTBackendConfig;
import org.dogtagpki.est.ESTRequestAuthorizer;
import org.dogtagpki.est.ESTRequestAuthorizerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESTEngine {
    private static Logger logger = LoggerFactory.getLogger(ESTEngine.class);
    private static ESTEngine INSTANCE;
    private String id;
    private Realm realm;
    private ESTBackend backend;
    private ESTRequestAuthorizer requestAuthorizer;

    public static ESTEngine getInstance() {
        return INSTANCE;
    }

    public ESTEngine() {
        INSTANCE = this;
    }

    public ESTBackend getBackend() {
        return this.backend;
    }

    public ESTRequestAuthorizer getRequestAuthorizer() {
        return this.requestAuthorizer;
    }

    public void start(String contextPath) throws Throwable {
        logger.info("Starting EST engine");
        String contextPathDirName = "".equals(contextPath) ? "ROOT" : contextPath.substring(1);
        String instanceDir = CMS.getInstanceDir();
        String serverConfDir = instanceDir + File.separator + "conf";
        String estConfDir = serverConfDir + File.separator + contextPathDirName;
        logger.info("EST configuration directory: " + estConfDir);
        this.initBackend(estConfDir + File.separator + "backend.conf");
        this.initRequestAuthorizer(estConfDir + File.separator + "authorizer.conf");
        this.initRealm(estConfDir + File.separator + "realm.conf");
        logger.info("EST engine started");
    }

    public void stop() throws Throwable {
        logger.info("Stopping EST engine");
        if (this.backend != null) {
            this.backend.stop();
        }
        if (this.requestAuthorizer != null) {
            this.requestAuthorizer.stop();
        }
        if (this.realm != null) {
            if (this.realm instanceof RealmCommon) {
                ((RealmCommon)this.realm).stop();
            } else if (this.realm instanceof LifecycleBase) {
                ((LifecycleBase)this.realm).stop();
            }
        }
        logger.info("EST engine stopped");
    }

    private void initBackend(String filename) throws Throwable {
        File file = new File(filename);
        if (!file.exists()) {
            throw new RuntimeException("Missing backend configuration file " + filename);
        }
        logger.info("Loading EST backend config from " + filename);
        Properties props = new Properties();
        try (FileReader reader = new FileReader(file);){
            props.load(reader);
        }
        ESTBackendConfig config = ESTBackendConfig.fromProperties(props);
        logger.info("Initializing EST backend");
        String className = config.getClassName();
        Class<?> backendClass = Class.forName(className);
        this.backend = (ESTBackend)backendClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.backend.setConfig(config);
        this.backend.start();
    }

    private void initRequestAuthorizer(String filename) throws Throwable {
        File file = new File(filename);
        if (!file.exists()) {
            throw new RuntimeException("Missing request authorizer configuration file " + filename);
        }
        logger.info("Loading EST request authorizer config from " + filename);
        Properties props = new Properties();
        try (FileReader reader = new FileReader(file);){
            props.load(reader);
        }
        ESTRequestAuthorizerConfig config = ESTRequestAuthorizerConfig.fromProperties(props);
        logger.info("Initializing EST request authorizer");
        String className = config.getClassName();
        Class<?> clazz = Class.forName(className);
        this.requestAuthorizer = (ESTRequestAuthorizer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.requestAuthorizer.setConfig(config);
        this.requestAuthorizer.start();
    }

    private void initRealm(String filename) throws Throwable {
        RealmConfig realmConfig = null;
        File realmConfigFile = new File(filename);
        if (realmConfigFile.exists()) {
            logger.info("Loading EST realm config from " + realmConfigFile);
            Properties props = new Properties();
            try (FileReader reader = new FileReader(realmConfigFile);){
                props.load(reader);
            }
            realmConfig = RealmConfig.fromProperties((Properties)props);
        } else {
            logger.info("Loading default realm config");
            realmConfig = new RealmConfig();
        }
        logger.info("Initializing EST realm");
        String className = realmConfig.getClassName();
        if (className == null) {
            throw new RuntimeException("File " + filename + " misses 'class' property");
        }
        Class<?> realmClass = Class.forName(className);
        this.realm = (Realm)realmClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ProxyRealm.registerRealm((String)this.id, (Realm)this.realm);
        if (this.realm instanceof RealmCommon) {
            ((RealmCommon)this.realm).setConfig(realmConfig);
        } else if (this.realm instanceof RealmBase) {
            for (Map.Entry entry : realmConfig.getParameters().entrySet()) {
                boolean result = IntrospectionUtils.setProperty((Object)this.realm, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
                if (result) continue;
                throw new RuntimeException("Failed to set Realm property '" + (String)entry.getKey() + "'.");
            }
        }
        if (this.realm instanceof RealmCommon) {
            ((RealmCommon)this.realm).start();
        } else if (this.realm instanceof LifecycleBase) {
            ((LifecycleBase)this.realm).start();
        }
    }

    public void setId(String id) {
        this.id = id;
    }
}

