/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.est;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.dogtagpki.est.ESTEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ESTWebListener
implements ServletContextListener {
    public static final Logger logger = LoggerFactory.getLogger(ESTWebListener.class);

    public ESTEngine createEngine() {
        return new ESTEngine();
    }

    public void contextInitialized(ServletContextEvent event) {
        String path = event.getServletContext().getContextPath();
        String id = "".equals(path) ? "ROOT" : path.substring(1);
        ESTEngine engine = this.createEngine();
        engine.setId(id);
        try {
            engine.start(event.getServletContext().getContextPath());
        }
        catch (Throwable e) {
            logger.error("Unable to start EST engine: " + e.getMessage(), e);
            throw new RuntimeException("Unable to start EST engine: " + e.getMessage(), e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            ESTEngine.getInstance().stop();
        }
        catch (Throwable e) {
            logger.error("Unable to stop EST engine: " + e.getMessage(), e);
            throw new RuntimeException("Unable to stop EST engine: " + e.getMessage(), e);
        }
    }
}

