/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.validator;

import org.dogtagpki.acme.ACMEAuthorization;
import org.dogtagpki.acme.ACMEChallenge;
import org.dogtagpki.acme.ValidationResult;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.validator.ACMEValidatorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ACMEValidator {
    public static Logger logger = LoggerFactory.getLogger(ACMEValidator.class);
    protected String name;
    protected String type;
    protected ACMEValidatorConfig config;

    public ACMEValidator(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ACMEValidatorConfig getConfig() {
        return this.config;
    }

    public void setConfig(ACMEValidatorConfig config) {
        this.config = config;
    }

    public void init() throws Exception {
    }

    public void close() throws Exception {
    }

    public ACMEChallenge createChallenge(String authzID, String token) throws Exception {
        ACMEEngine engine = ACMEEngine.getInstance();
        String challengeID = engine.randomAlphanumeric(10);
        logger.info("Creating " + this.name + " challenge: " + challengeID);
        ACMEChallenge challenge = new ACMEChallenge();
        challenge.setID(challengeID);
        challenge.setAuthzID(authzID);
        challenge.setType(this.type);
        challenge.setToken(token);
        challenge.setStatus("pending");
        return challenge;
    }

    public abstract ValidationResult validateChallenge(ACMEAuthorization var1, ACMEChallenge var2);
}

