/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.security;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.certsrv.security.SigningUnitConfig;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SigningUnit {
    public static Logger logger = LoggerFactory.getLogger(SigningUnit.class);
    protected CryptoManager mManager;
    protected CryptoToken mToken;
    protected PublicKey mPubk;
    protected PrivateKey mPrivk;
    protected X509Certificate mCert;
    protected X509CertImpl mCertImpl;
    protected CertificateChain certChain;
    protected String mNickname;
    protected boolean mInited;
    protected SigningUnitConfig mConfig;
    protected String mDefSigningAlgname;
    protected SignatureAlgorithm mDefSigningAlgorithm;

    public String getNickname() {
        return this.mNickname;
    }

    public String getNewNickName() throws EBaseException {
        return this.mConfig.getNewNickname();
    }

    public void setNewNickName(String name) {
        this.mConfig.setNewNickname(name);
    }

    public X509Certificate getCert() {
        return this.mCert;
    }

    public X509CertImpl getCertImpl() {
        return this.mCertImpl;
    }

    public void buildCertChain() throws NotInitializedException, CertificateException, TokenException {
        logger.info("SigningUnit: cert chain:");
        CryptoManager manager = CryptoManager.getInstance();
        X509Certificate[] chain = manager.buildCertificateChain(this.mCert);
        java.security.cert.X509Certificate[] certs = new java.security.cert.X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            certs[i] = new X509CertImpl(chain[i].getEncoded());
            logger.info("SigningUnit: - " + certs[i].getSubjectDN());
        }
        this.certChain = new CertificateChain(certs);
    }

    public CertificateChain getCertChain() {
        return this.certChain;
    }

    public abstract byte[] sign(byte[] var1, String var2) throws Exception;

    public abstract boolean verify(byte[] var1, byte[] var2, String var3) throws Exception;

    public SignatureAlgorithm getDefaultSignatureAlgorithm() {
        return this.mDefSigningAlgorithm;
    }

    public String getDefaultAlgorithm() {
        return this.mDefSigningAlgname;
    }

    public void setDefaultAlgorithm(String algorithm) throws EBaseException {
        this.mConfig.setDefaultSigningAlgorithm(algorithm);
        this.mDefSigningAlgname = algorithm;
        logger.info("Default signing algorithm is set to " + algorithm);
    }

    public String[] getAllAlgorithms() throws EBaseException {
        byte[] bytes = this.mPubk.getEncoded();
        X509Key key = new X509Key();
        try {
            key.decode(bytes);
        }
        catch (InvalidKeyException e) {
            String message = "Invalid signing key encoding: " + e.getMessage();
            throw new EBaseException(message, (Throwable)e);
        }
        boolean isDSA = key.getAlgorithmId().getOID().equals(AlgorithmId.DSA_oid);
        return isDSA ? AlgorithmId.DSA_SIGNING_ALGORITHMS : AlgorithmId.ALL_SIGNING_ALGORITHMS;
    }

    public String getTokenName() throws EBaseException {
        return this.mConfig.getTokenName();
    }

    public abstract void updateConfig(String var1, String var2);

    public SignatureAlgorithm checkSigningAlgorithmFromName(String algname) throws EBaseException {
        try {
            SignatureAlgorithm sigalg = Cert.mapAlgorithmToJss((String)algname);
            if (sigalg == null) {
                throw new ECAException("Signing algorithm not supported: " + algname);
            }
            Signature signer = this.mToken.getSignatureContext(sigalg);
            signer.initSign(this.mPrivk);
            return sigalg;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ECAException("Signing algorithm not supported: " + algname + ": " + e.getMessage(), (Throwable)e);
        }
        catch (TokenException e) {
            throw new ECAException("Signing algorithm not supported: " + algname + ": " + e.getMessage(), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new ECAException("Signing algorithm not supported: " + algname + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public PublicKey getPublicKey() {
        return this.mPubk;
    }

    public PrivateKey getPrivateKey() {
        return this.mPrivk;
    }
}

