/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotDefined;
import com.netscape.certsrv.dbs.EDBException;
import com.netscape.certsrv.dbs.EDBNotAvailException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.dbs.BigIntegerMapper;
import com.netscape.cmscore.dbs.ByteArrayMapper;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.DBRegistry;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DateMapper;
import com.netscape.cmscore.dbs.LDAPRegistry;
import com.netscape.cmscore.dbs.LDAPSession;
import com.netscape.cmscore.dbs.LongMapper;
import com.netscape.cmscore.dbs.MetaInfoMapper;
import com.netscape.cmscore.dbs.ObjectStreamMapper;
import com.netscape.cmscore.dbs.RepositoryRecord;
import com.netscape.cmscore.dbs.RevocationInfoMapper;
import com.netscape.cmscore.dbs.StringMapper;
import com.netscape.cmscore.dbs.X509CertImplMapper;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmsutil.password.PasswordStore;
import java.math.BigInteger;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSubsystem {
    public static final Logger logger = LoggerFactory.getLogger(DBSubsystem.class);
    public static final String ID = "dbs";
    public static final String PROP_NEXT_RANGE = "nextRange";
    public static final Set<String> DEFAULT_EXCLUDED_LDAP_ATTRS = Set.of("req_x509info", "publickey", "req_extensions", "cert_request", "req_archive_options", "req_key");
    protected CMSEngine engine;
    protected EngineConfig engineConfig;
    private DatabaseConfig mDBConfig;
    private LDAPConfig ldapConfig;
    private LdapBoundConnFactory mLdapConnFactory;
    private DBRegistry mRegistry;
    private String mBaseDN;
    private boolean mEnableSerialMgmt;
    protected Set<String> excludedLdapAttrs;

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public void setEngineConfig(EngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    public String getId() {
        return ID;
    }

    public void setId(String id) throws EBaseException {
        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_OPERATION", new String[0]));
    }

    public boolean enableSerialNumberRecovery() {
        try {
            return this.mDBConfig.getEnableSerialNumberRecovery();
        }
        catch (EBaseException e) {
            return true;
        }
    }

    public boolean getEnableSerialMgmt() {
        return this.mEnableSerialMgmt;
    }

    public void setEnableSerialMgmt(boolean v) throws EBaseException {
        if (v) {
            logger.debug("DBSubsystem: Enabling Serial Number Management");
        } else {
            logger.debug("DBSubsystem: Disabling Serial Number Management");
        }
        this.mDBConfig.setEnableSerialManagement(v);
        this.engineConfig.commit(false);
        this.mEnableSerialMgmt = v;
    }

    public void setNextSerialConfig(BigInteger serial) throws EBaseException {
        logger.info("DBSubsystem: Setting next serial number: 0x" + serial.toString(16));
        this.mDBConfig.setNextSerialNumber(serial.toString(16));
    }

    public Set<String> getExcludedLdapAttr() {
        return this.excludedLdapAttrs;
    }

    public void configureExcludedLdapAttrs() throws EBaseException {
        String id = this.engineConfig.getType().toLowerCase();
        if (!id.equals("ca") && !id.equals("kra")) {
            return;
        }
        logger.info("DBSubsystem: Configuring excluded LDAP attributes");
        boolean enabled = this.engineConfig.getBoolean("excludedLdapAttrs.enabled", false);
        logger.debug("DBSubsystem: excludedLdapAttrs.enabled: " + enabled);
        if (!enabled) {
            return;
        }
        String attrs = this.engineConfig.getString("excludedLdapAttrs.attrs", "");
        logger.debug("DBSubsystem: excludedLdapAttrs.attrs: " + attrs);
        this.excludedLdapAttrs = attrs.equals("") ? DEFAULT_EXCLUDED_LDAP_ATTRS : Set.of(attrs.split(","));
    }

    public void init(DatabaseConfig dbConfig, LDAPConfig ldapConfig, PKISocketConfig socketConfig, PasswordStore passwordStore) throws EBaseException {
        this.mDBConfig = dbConfig;
        this.ldapConfig = ldapConfig;
        try {
            this.mBaseDN = ldapConfig.getBaseDN();
            this.mEnableSerialMgmt = this.mDBConfig.getEnableSerialManagement();
            logger.debug("DBSubsystem: init()  mEnableSerialMgmt=" + this.mEnableSerialMgmt);
            this.mRegistry = new LDAPRegistry();
            this.mRegistry.init(null);
            this.mLdapConnFactory = new LdapBoundConnFactory("DBSubsystem", true);
            this.mLdapConnFactory.setCMSEngine(this.engine);
        }
        catch (EBaseException e) {
            logger.error("DBSubsystem: initialization failed: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            LDAPConfig tmpConfig = (LDAPConfig)ldapConfig.clone();
            tmpConfig.setBaseDN(this.mBaseDN);
            this.mLdapConnFactory.init(socketConfig, tmpConfig, passwordStore);
        }
        catch (EPropertyNotDefined e) {
            logger.error("DBSubsystem: initialization failed: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ELdapServerDownException e) {
            logger.error("DBSubsystem: initialization failed: " + e.getMessage(), (Throwable)e);
            throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]), (Throwable)e);
        }
        catch (ELdapException e) {
            logger.error("DBSubsystem: initialization failed: " + e.getMessage(), (Throwable)e);
            throw new EDBException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_ERROR", e.toString()), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.error("DBSubsystem: initialization failed: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            DBRegistry reg = this.getRegistry();
            String[] certRecordOC = new String[]{"top", "certificateRecord"};
            if (!reg.isObjectClassRegistered(CertRecord.class.getName())) {
                reg.registerObjectClass(CertRecord.class.getName(), certRecordOC);
            }
            if (!reg.isAttributeRegistered("certRecordId")) {
                reg.registerAttribute("certRecordId", new BigIntegerMapper("serialno"));
            }
            if (!reg.isAttributeRegistered("certMetaInfo")) {
                reg.registerAttribute("certMetaInfo", new MetaInfoMapper("metaInfo"));
            }
            if (!reg.isAttributeRegistered("certRevoInfo")) {
                reg.registerAttribute("certRevoInfo", new RevocationInfoMapper());
            }
            if (!reg.isAttributeRegistered("x509cert")) {
                reg.registerAttribute("x509cert", new X509CertImplMapper());
            }
            if (!reg.isAttributeRegistered("certStatus")) {
                reg.registerAttribute("certStatus", new StringMapper("certStatus"));
            }
            if (!reg.isAttributeRegistered("certAutoRenew")) {
                reg.registerAttribute("certAutoRenew", new StringMapper("autoRenew"));
            }
            if (!reg.isAttributeRegistered("certCreateTime")) {
                reg.registerAttribute("certCreateTime", new DateMapper("dateOfCreate"));
            }
            if (!reg.isAttributeRegistered("certModifyTime")) {
                reg.registerAttribute("certModifyTime", new DateMapper("dateOfModify"));
            }
            if (!reg.isAttributeRegistered("certIssuedBy")) {
                reg.registerAttribute("certIssuedBy", new StringMapper("issuedBy"));
            }
            if (!reg.isAttributeRegistered("certRevokedBy")) {
                reg.registerAttribute("certRevokedBy", new StringMapper("revokedBy"));
            }
            if (!reg.isAttributeRegistered("certRevokedOn")) {
                reg.registerAttribute("certRevokedOn", new DateMapper("revokedOn"));
            }
            if (!reg.isAttributeRegistered("notAfter")) {
                reg.registerAttribute("notAfter", new DateMapper("notAfter"));
            }
            if (!reg.isAttributeRegistered("notBefore")) {
                reg.registerAttribute("notBefore", new DateMapper("notBefore"));
            }
            String[] crlRecordOC = new String[]{"top", "crlIssuingPointRecord"};
            reg.registerObjectClass(CRLIssuingPointRecord.class.getName(), crlRecordOC);
            reg.registerAttribute("id", new StringMapper("cn"));
            reg.registerAttribute("crlNumber", new BigIntegerMapper("crlNumber"));
            reg.registerAttribute("deltaNumber", new BigIntegerMapper("deltaNumber"));
            reg.registerAttribute("crlSize", new LongMapper("crlSize"));
            reg.registerAttribute("deltaSize", new LongMapper("deltaSize"));
            reg.registerAttribute("thisUpdate", new DateMapper("thisUpdate"));
            reg.registerAttribute("nextUpdate", new DateMapper("nextUpdate"));
            reg.registerAttribute("firstUnsaved", new StringMapper("firstUnsaved"));
            reg.registerAttribute("certificaterevocationlist", new ByteArrayMapper("certificateRevocationList"));
            reg.registerAttribute("deltaRevocationList", new ByteArrayMapper("deltaRevocationList"));
            reg.registerAttribute("cACertificate", new ByteArrayMapper("cACertificate"));
            reg.registerAttribute("crlCache", new ObjectStreamMapper("crlCache"));
            reg.registerAttribute("revokedCerts", new ObjectStreamMapper("revokedCerts"));
            reg.registerAttribute("unrevokedCerts", new ObjectStreamMapper("unrevokedCerts"));
            reg.registerAttribute("expiredCerts", new ObjectStreamMapper("expiredCerts"));
            boolean registered = reg.isObjectClassRegistered(RepositoryRecord.class.getName());
            logger.debug("registered: " + registered);
            if (!registered) {
                String[] repRecordOC = new String[]{"top", "repository"};
                reg.registerObjectClass(RepositoryRecord.class.getName(), repRecordOC);
            }
            if (!reg.isAttributeRegistered("serialNo")) {
                reg.registerAttribute("serialNo", new BigIntegerMapper("serialno"));
            }
            if (!reg.isAttributeRegistered("publishingStatus")) {
                reg.registerAttribute("publishingStatus", new StringMapper("publishingStatus"));
            }
            if (!reg.isAttributeRegistered("description")) {
                reg.registerAttribute("description", new StringMapper("description"));
            }
        }
        catch (EBaseException e) {
            logger.error("DBSubsystem: initialization failed: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        this.configureExcludedLdapAttrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEntryAttribute(String dn, String attrName, String defaultValue, String errorValue) {
        LDAPConnection conn = null;
        String attrValue = null;
        try {
            LDAPAttribute attr;
            conn = this.mLdapConnFactory.getConn();
            String[] attrs = new String[]{attrName};
            LDAPEntry entry = conn.read(dn, attrs);
            attrValue = entry != null ? ((attr = entry.getAttribute(attrName)) != null ? (String)attr.getStringValues().nextElement() : defaultValue) : errorValue;
        }
        catch (LDAPException e) {
            logger.warn("DBSubsystem: getEntryAttribute  LDAPException  code=" + e.getLDAPResultCode());
            if (e.getLDAPResultCode() == 32) {
                attrValue = defaultValue;
            }
        }
        catch (Exception e) {
            logger.warn("DBSubsystem: getEntryAttribute. Unable to retrieve '" + attrName + "': " + e);
            attrValue = errorValue;
        }
        finally {
            try {
                if (conn != null && this.mLdapConnFactory != null) {
                    logger.debug("Releasing ldap connection");
                    this.mLdapConnFactory.returnConn(conn);
                }
            }
            catch (Exception e) {
                logger.warn("Error releasing the ldap connection: " + e.getMessage(), (Throwable)e);
            }
        }
        logger.debug("DBSubsystem: getEntryAttribute:  dn=" + dn + "  attr=" + attrName + ":" + attrValue + ";");
        return attrValue;
    }

    public LDAPConfig getLDAPConfig() {
        return this.ldapConfig;
    }

    public DatabaseConfig getDBConfigStore() {
        return this.mDBConfig;
    }

    public String getBaseDN() {
        return this.mBaseDN;
    }

    public LdapConnInfo getLdapConnInfo() {
        if (this.mLdapConnFactory != null) {
            return this.mLdapConnFactory.getConnInfo();
        }
        return null;
    }

    public LdapAuthInfo getLdapAuthInfo() {
        if (this.mLdapConnFactory != null) {
            return this.mLdapConnFactory.getAuthInfo();
        }
        return null;
    }

    public void shutdown() {
        try {
            if (this.mLdapConnFactory != null) {
                this.mLdapConnFactory.shutdown();
            }
        }
        catch (ELdapException e) {
            logger.warn("DBSubsystem: " + CMS.getLogMessage("OPERATION_ERROR", e.toString()), (Throwable)e);
        }
        if (this.mRegistry != null) {
            this.mRegistry.shutdown();
        }
    }

    public DBRegistry getRegistry() {
        return this.mRegistry;
    }

    public DBSSession createSession() throws EDBException {
        LDAPConnection conn = null;
        try {
            conn = this.mLdapConnFactory.getConn();
            String schemaAdded = this.mDBConfig.getNewSchemaEntryAdded();
            if (schemaAdded.equals("")) {
                LDAPSchema dirSchema = new LDAPSchema();
                dirSchema.fetchSchema(conn);
                LDAPAttributeSchema userType = dirSchema.getAttribute("usertype");
                if (userType == null) {
                    userType = new LDAPAttributeSchema("usertype", "usertype-oid", "Distinguish whether the user is administrator, agent or subsystem.", 1, false);
                    userType.add(conn);
                }
                dirSchema.fetchSchema(conn);
                LDAPObjectClassSchema newObjClass = dirSchema.getObjectClass("cmsuser");
                String[] requiredAttrs = new String[]{"usertype"};
                String[] optionalAttrs = new String[]{};
                if (newObjClass == null) {
                    newObjClass = new LDAPObjectClassSchema("cmsuser", "cmsuser-oid", "top", "CMS User", requiredAttrs, optionalAttrs);
                    newObjClass.add(conn);
                }
                this.mDBConfig.setNewSchemaEntryAdded("true");
                this.engineConfig.commit(false);
            }
        }
        catch (ELdapException e) {
            if (e instanceof ELdapServerDownException) {
                throw new EDBNotAvailException(CMS.getUserMessage("CMS_DBS_INTERNAL_DIR_UNAVAILABLE", new String[0]));
            }
            logger.error("DBSubsystem: " + CMS.getLogMessage("CMSCORE_DBS_CONN_ERROR", e.toString()), (Throwable)e);
            throw new EDBException(CMS.getUserMessage("CMS_DBS_CONNECT_LDAP_FAILED", e.toString()));
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() != 20) {
                logger.error("DBSubsystem: " + CMS.getLogMessage("CMSCORE_DBS_SCHEMA_ERROR", e.toString()), (Throwable)e);
                throw new EDBException(CMS.getUserMessage("CMS_DBS_ADD_ENTRY_FAILED", e.toString()));
            }
        }
        catch (EBaseException e) {
            logger.warn("DBSubsystem: " + CMS.getLogMessage("CMSCORE_DBS_CONF_ERROR", e.toString()), (Throwable)e);
        }
        return new LDAPSession(this, conn);
    }

    public void returnConn(LDAPConnection conn) {
        this.mLdapConnFactory.returnConn(conn);
    }
}

