/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.tps.token.TokenStatus;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.cms.CARemoteRequestHandler;
import org.dogtagpki.server.tps.cms.CARevokeCertResponse;
import org.dogtagpki.server.tps.dbs.TPSCertRecord;
import org.dogtagpki.server.tps.dbs.TokenCertStatus;
import org.dogtagpki.server.tps.dbs.TokenRecord;
import org.dogtagpki.server.tps.main.ExternalRegCertToRecover;
import org.dogtagpki.tps.main.TPSException;
import org.dogtagpki.tps.msg.EndOpMsg;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenDB {
    public static Logger logger = LoggerFactory.getLogger(TokenDB.class);
    private TPSSubsystem tps;

    public TokenDB(TPSSubsystem tps) throws EBaseException {
        if (tps == null) {
            String msg = "TokenDB.TokenDB: tps cannot be null";
            logger.error(msg);
            throw new EBaseException(msg);
        }
        this.tps = tps;
    }

    public boolean isTransitionAllowed(TokenRecord tokenRecord, TokenStatus newState) throws Exception {
        boolean result = false;
        TokenStatus currentTokenStatus = tokenRecord.getTokenStatus();
        logger.debug("TokenRecord.isTransitionAllowed(): current status: " + currentTokenStatus);
        Collection<TokenStatus> nextStatuses = this.tps.getUINextTokenStates(tokenRecord);
        logger.debug("TokenRecord.isTransitionAllowed(): allowed next statuses: " + nextStatuses);
        if (!nextStatuses.contains(newState)) {
            logger.debug("TokenRecord.isTransitionAllowed(): next status not allowed: " + newState);
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    public void tdbActivity(String op, TokenRecord tokenRecord, String ip, String msg, String result) {
        try {
            this.tps.activityDatabase.log(ip, tokenRecord != null ? tokenRecord.getId() : null, op, result, msg, tokenRecord != null ? tokenRecord.getUserID() : null, tokenRecord != null ? tokenRecord.getType() : null);
        }
        catch (Exception e) {
            logger.warn(msg + "; tokendb activity logging failure: " + e.getMessage(), (Throwable)e);
        }
    }

    public void tdbActivity(String op, TokenRecord tokenRecord, String ip, String msg, String result, String uid) {
        try {
            this.tps.activityDatabase.log(ip, tokenRecord != null ? tokenRecord.getId() : null, op, result, msg, uid, tokenRecord != null ? tokenRecord.getType() : null);
        }
        catch (Exception e) {
            logger.warn(msg + "; tokendb activity logging failure: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isTokenPresent(String cuid) {
        boolean present = false;
        try {
            this.tps.tokenDatabase.getRecord(cuid);
            present = true;
        }
        catch (Exception e) {
            logger.warn("TokenDB.isTokenPresent: token entry not found: " + e.getMessage(), (Throwable)e);
            present = false;
        }
        return present;
    }

    public TokenRecord tdbGetTokenEntry(String cuid) throws Exception {
        return (TokenRecord)this.tps.tokenDatabase.getRecord(cuid);
    }

    public ArrayList<TokenRecord> tdbFindTokenRecordsByUID(String uid) throws Exception {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("userID", uid);
        Iterator records = this.tps.tokenDatabase.findRecords(null, attributes).iterator();
        ArrayList<TokenRecord> tokenRecords = new ArrayList<TokenRecord>();
        while (records.hasNext()) {
            TokenRecord tokenRecord = (TokenRecord)((Object)records.next());
            tokenRecords.add(tokenRecord);
        }
        return tokenRecords;
    }

    public void tdbHasActiveToken(String userid) throws Exception {
        if (userid == null) {
            throw new Exception("TokenDB.tdbhasActiveToken: uerid null");
        }
        ArrayList<TokenRecord> tokens = this.tdbFindTokenRecordsByUID(userid);
        boolean foundActive = false;
        for (TokenRecord tokenRecord : tokens) {
            if (!tokenRecord.getTokenStatus().equals((Object)TokenStatus.ACTIVE)) continue;
            foundActive = true;
        }
        if (!foundActive) {
            throw new Exception("TokenDB.tdbhasActiveToken: active token not found");
        }
    }

    public void tdbHasOtherActiveToken(String userid, String cuid) throws Exception {
        if (userid == null || cuid == null) {
            throw new Exception("TokenDB.tdbhasOtherActiveToken: uerid null, or cuid is null");
        }
        ArrayList<TokenRecord> tokens = this.tdbFindTokenRecordsByUID(userid);
        boolean foundActive = false;
        for (TokenRecord tokenRecord : tokens) {
            if (!tokenRecord.getTokenStatus().equals((Object)TokenStatus.ACTIVE) || tokenRecord.getId().equalsIgnoreCase(cuid)) continue;
            foundActive = true;
        }
        if (!foundActive) {
            throw new Exception("TokenDB.tdbhasActiveToken: active token not found");
        }
    }

    public void tdbAddTokenEntry(TokenRecord tokenRecord, TokenStatus status) throws Exception {
        String method = "TokenDB.tdbAddTokenEntry: ";
        tokenRecord.setTokenStatus(status);
        this.tps.tokenDatabase.addRecord(tokenRecord.getId(), tokenRecord);
        logger.debug("{}Added tokenRecord.", (Object)method);
    }

    public void tdbUpdateTokenEntry(TokenRecord tokenRecord) throws Exception {
        TokenRecord existingTokenRecord;
        String method = "TokenDB.tdbUpdateTokenEntry:";
        String id = tokenRecord.getId();
        try {
            existingTokenRecord = (TokenRecord)this.tps.tokenDatabase.getRecord(id);
        }
        catch (EDBRecordNotFoundException e) {
            String logMsg = method + e.getMessage();
            logger.error(logMsg, (Throwable)e);
            throw new TPSException(logMsg);
        }
        logger.debug(method + " token entry found; Modifying with status: " + tokenRecord.getTokenStatus());
        tokenRecord.setCreateTimestamp(existingTokenRecord.getCreateTimestamp());
        this.tps.tokenDatabase.updateRecord(id, tokenRecord);
    }

    public void tdbAddCertificatesForCUID(String cuid, ArrayList<TPSCertRecord> certs) throws TPSException {
        String method = "TokenDB.tdbAddCertificatesForCUID: ";
        logger.debug(method + "begins");
        boolean tokenExist = this.isTokenPresent(cuid);
        if (!tokenExist) {
            logger.error(method + " token not found: " + cuid);
            throw new TPSException(method + " token " + cuid + " does not exist");
        }
        logger.debug(method + " found token " + cuid);
        logger.debug(method + " number of certs to update:" + certs.size());
        class CnIssuerPair {
            public final String cn;
            public final String issuer;

            public CnIssuerPair(String _cn, String _issuer) {
                this.cn = _cn;
                this.issuer = _issuer;
            }

            public String toString() {
                return "(cn=" + this.cn + ", issuerCn=" + this.issuer + ")";
            }
        }
        ArrayList<CnIssuerPair> cnIssuerPairsRemaining = new ArrayList<CnIssuerPair>(certs.size());
        for (TPSCertRecord cert : certs) {
            String cn = cert.getId();
            String issuerCn = cert.getIssuedBy();
            cnIssuerPairsRemaining.add(new CnIssuerPair(cn, issuerCn));
        }
        boolean testAddCertsFailure = false;
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSEngineConfig configStore = engine.getConfig();
            String config = "op.enroll.testAddCertsToDBFailure";
            testAddCertsFailure = configStore.getBoolean(config, false);
        }
        catch (Exception e) {
            testAddCertsFailure = false;
        }
        try {
            int count = 0;
            for (TPSCertRecord cert : certs) {
                try {
                    if (!this.isCertOnToken(cert, cuid)) {
                        logger.debug(method + " adding cert with serial: " + cert.getSerialNumber());
                        if (count > 0 && testAddCertsFailure) {
                            throw new Exception(method + ": Failed to add certificate to token db, as part of a test of failure condition.");
                        }
                        this.tps.certDatabase.addRecord(cert.getId(), cert);
                    } else {
                        logger.debug(method + "retain and skip adding with serial:" + cert.getSerialNumber());
                    }
                    cnIssuerPairsRemaining.removeIf(p -> p.cn == cert.getId() && p.issuer == cert.getIssuedBy());
                    ++count;
                }
                catch (Exception e) {
                    logger.warn(method + "Exception after isCertOnToken call: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            String subjectDn = certs.get(0).getSubject();
            String logMsg = method + ": Failed to add or verify the following certs for [" + subjectDn + "] in the Certificate DB: ";
            for (CnIssuerPair pair : cnIssuerPairsRemaining) {
                logMsg = logMsg + pair + "; ";
            }
            throw new TPSException(logMsg);
        }
    }

    public Collection<TPSCertRecord> tdbGetCertRecordsByCUID(String cuid) throws TPSException {
        if (cuid == null) {
            throw new TPSException("TokenDB.tdbGetCertificatesByCUID: cuid null");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("tokenID", cuid);
        try {
            return this.tps.certDatabase.findRecords(null, attributes);
        }
        catch (Exception e) {
            logger.error("TokenDB.tdbGetCertificatesByCUID:" + e.getMessage(), (Throwable)e);
            throw new TPSException((Throwable)e);
        }
    }

    public ArrayList<TPSCertRecord> tdbGetCertRecordsByCert(String serial, String issuer) throws TPSException {
        Iterator records;
        String method = "TokenDB.tdbGetCertRecordsByCert:";
        if (serial == null) {
            throw new TPSException(method + " serial null");
        }
        if (issuer == null) {
            throw new TPSException(method + " issuer null");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("serialNumber", serial);
        attributes.put("issuedBy", issuer);
        ArrayList<TPSCertRecord> certRecords = new ArrayList<TPSCertRecord>();
        try {
            records = this.tps.certDatabase.findRecords(null, attributes).iterator();
        }
        catch (Exception e) {
            logger.error(method + e.getMessage(), (Throwable)e);
            throw new TPSException(e.getMessage(), (Throwable)e);
        }
        while (records.hasNext()) {
            TPSCertRecord certRecord = (TPSCertRecord)((Object)records.next());
            certRecords.add(certRecord);
        }
        return certRecords;
    }

    public TPSCertRecord tdbGetOrigCertRecord(X509CertImpl cert) {
        String method = "TokenDB.tdbGetCertTokenOrigin: ";
        TPSCertRecord result = null;
        String serialNumber = null;
        String issuedBy = null;
        if (cert == null) {
            logger.warn(method + "input param cert null");
            return null;
        }
        try {
            BigInteger serial_BigInt = cert.getSerialNumber();
            String hexSerial = serial_BigInt.toString(16);
            serialNumber = "0x" + hexSerial;
            issuedBy = cert.getIssuerName().toString();
        }
        catch (Exception e) {
            logger.error(method + ":" + e.getMessage(), (Throwable)e);
            return null;
        }
        ArrayList<TPSCertRecord> certRecords = null;
        try {
            certRecords = this.tdbGetCertRecordsByCert(serialNumber, issuedBy);
        }
        catch (TPSException e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
            return null;
        }
        for (TPSCertRecord certRec : certRecords) {
            String tokenID = certRec.getTokenID();
            String origin = certRec.getOrigin();
            if (tokenID == null || origin == null || !tokenID.equalsIgnoreCase(origin)) continue;
            logger.debug(method + "found original cert record");
            result = certRec;
        }
        return result;
    }

    private boolean isCertOnToken(TPSCertRecord cert, String cuid) {
        Iterator records;
        String method = "TokenDB: isCertOnToken: ";
        boolean result = false;
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("tokenID", cuid);
        if (cert == null) {
            logger.warn(method + "input param cert null");
            return false;
        }
        if (cuid == null) {
            logger.warn(method + "input param cuid null");
            return false;
        }
        logger.debug(method + "begins - cert serial = " + cert.getSerialNumber() + "; token cuid = " + cuid);
        try {
            records = this.tps.certDatabase.findRecords(null, attributes).iterator();
        }
        catch (Exception e) {
            logger.warn(method + ":" + e.getMessage(), (Throwable)e);
            return false;
        }
        if (!records.hasNext()) {
            logger.warn(method + "no cert records currently exist on token");
            return false;
        }
        while (records.hasNext()) {
            TPSCertRecord certRecord = (TPSCertRecord)((Object)records.next());
            if (!certRecord.getTokenID().equalsIgnoreCase(cuid) || !certRecord.getSerialNumber().equalsIgnoreCase(cert.getSerialNumber())) continue;
            logger.debug(method + "cert exists on token; serial: " + cert.getSerialNumber());
            result = true;
            break;
        }
        return result;
    }

    public void tdbRemoveCertificatesByCUID(String cuid) throws Exception {
        this.tdbRemoveCertificatesByCUID(cuid, null);
    }

    public void tdbRemoveCertificatesByCUID(String cuid, ArrayList<ExternalRegCertToRecover> erCertsToRecover) throws Exception {
        Iterator records;
        String method = "TokenDB.tdbRemoveCertificatesByCUID";
        if (cuid == null) {
            throw new Exception(method + ": cuid null");
        }
        logger.debug(method + ": begins for cuid =" + cuid);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("tokenID", cuid);
        try {
            records = this.tps.certDatabase.findRecords(null, attributes).iterator();
        }
        catch (Exception e) {
            logger.error(method + ":" + e.getMessage(), (Throwable)e);
            throw new Exception(method + ":" + e);
        }
        while (records.hasNext()) {
            TPSCertRecord certRecord = (TPSCertRecord)((Object)records.next());
            if (certRecord.getTokenID().equalsIgnoreCase(cuid)) {
                boolean isCertRetained = false;
                if (erCertsToRecover != null) {
                    isCertRetained = this.isCertRetained(certRecord.getSerialNumberInBigInteger(), erCertsToRecover);
                }
                if (!isCertRetained) {
                    this.tps.certDatabase.removeRecord(certRecord.getId());
                    logger.debug(method + ":cert removed:" + certRecord.getId());
                    continue;
                }
                logger.debug(method + ":cert retained:" + certRecord.getId());
                continue;
            }
            logger.debug(method + ": record not matched:" + certRecord.getTokenID());
        }
        logger.debug(method + ": done");
    }

    private boolean isCertRetained(BigInteger certSerial, ArrayList<ExternalRegCertToRecover> erCertsToRecover) {
        String method = "TokenDB.isCertRetained: ";
        boolean result = false;
        if (erCertsToRecover == null) {
            logger.warn(method + "input param erCertsToRecover null");
            return false;
        }
        if (certSerial == null) {
            logger.warn(method + "input param certSerial null");
            return false;
        }
        for (ExternalRegCertToRecover certToRecover : erCertsToRecover) {
            if (certToRecover == null || certSerial.compareTo(certToRecover.getSerial()) != 0 || !certToRecover.getIsRetainable()) continue;
            result = true;
            break;
        }
        return result;
    }

    public void revokeCertsByCUID(String cuid, String tokenReason, String ipAddress, String remoteUser) throws Exception {
        String method = "TPStokendb.revokeCertsByCUID";
        logger.debug(method + ": called");
        if (cuid == null) {
            throw new TPSException(method + ": cuid null");
        }
        this.revokeCertsByCUID(true, cuid, tokenReason, ipAddress, remoteUser);
    }

    public void unRevokeCertsByCUID(String cuid, String ipAddress, String remoteUser) throws Exception {
        String method = "TPStokendb.unRevokeCertsByCUID";
        logger.debug(method + ": called");
        if (cuid == null) {
            throw new TPSException(method + ": cuid null");
        }
        this.revokeCertsByCUID(false, cuid, null, ipAddress, remoteUser);
    }

    private boolean isLastActiveSharedCert(String serial, String issuer, String cuid) throws TPSException {
        String method = "TokenDB.isLastActiveSharedCert";
        String msg = "";
        if (serial == null) {
            msg = "input param serial null";
            throw new TPSException(method + msg);
        }
        if (issuer == null) {
            msg = "input param issuer null";
            throw new TPSException(method + msg);
        }
        if (cuid == null) {
            msg = "input param cuid null";
            throw new TPSException(method + msg);
        }
        logger.debug(method + "begins for cuid = " + cuid);
        ArrayList<TPSCertRecord> certRecords = this.tps.getTokendb().tdbGetCertRecordsByCert(serial, issuer);
        for (TPSCertRecord cert : certRecords) {
            logger.debug(method + "found cert record for cuid = " + cert.getTokenID() + ", cert status = " + cert.getStatus());
            if (cert.getTokenID().equals(cuid)) continue;
            TokenRecord tokenRecord = null;
            try {
                tokenRecord = this.tdbGetTokenEntry(cert.getTokenID());
            }
            catch (Exception e) {
                throw new TPSException("error getting token entry for: " + cert.getTokenID() + ": " + e.getMessage(), (Throwable)e);
            }
            if (tokenRecord.getTokenStatus() == TokenStatus.ACTIVE) {
                logger.warn(method + "token " + cert.getTokenID() + " contains the cert and has status: " + tokenRecord.getTokenStatus() + "... returning false");
                return false;
            }
            logger.debug(method + "token " + cert.getTokenID() + " status: " + tokenRecord.getTokenStatus());
        }
        logger.debug(method + "returning true");
        return true;
    }

    private void revokeCert(TokenRecord tokenRecord, TPSCertRecord cert, String tokenReason, String ipAddress, String remoteUser) throws Exception {
        String method = "TokenDB.revokeCert";
        logger.debug(method + "begins: tokenReason=" + tokenReason);
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSEngineConfig configStore = engine.getConfig();
            String config = "op.enroll." + cert.getType() + ".keyGen." + cert.getKeyType() + ".ca.conn";
            logger.debug(method + ":  getting config: " + config);
            String connID = configStore.getString(config);
            RevocationReason revokeReason = RevocationReason.UNSPECIFIED;
            this.checkShouldRevoke(tokenRecord, cert, tokenReason, ipAddress, remoteUser);
            String logMsg = "certificate to be revoked:" + cert.getSerialNumber();
            logger.debug(method + ": " + logMsg);
            config = "op.enroll." + cert.getType() + ".keyGen." + cert.getKeyType() + ".recovery." + tokenReason + ".revokeCert.reason";
            logger.debug(method + ":  getting config: " + config);
            int reasonInt = configStore.getInteger(config, 0);
            revokeReason = RevocationReason.valueOf((int)reasonInt);
            CARemoteRequestHandler caRH = new CARemoteRequestHandler(connID);
            BigInteger bInt = cert.getSerialNumberInBigInteger();
            String serialStr = bInt.toString();
            logger.debug(method + ": found cert hex serial: " + cert.getSerialNumber() + " dec serial: " + serialStr);
            CARevokeCertResponse response = caRH.revokeCertificate(true, serialStr, cert.getCertificate(), revokeReason);
            logger.debug(method + ": response status: " + response.getStatus());
            if (revokeReason == RevocationReason.CERTIFICATE_HOLD) {
                this.updateCertsStatus(cert.getSerialNumber(), cert.getIssuedBy(), TokenCertStatus.ONHOLD.toString());
            } else {
                this.updateCertsStatus(cert.getSerialNumber(), cert.getIssuedBy(), TokenCertStatus.REVOKED.toString());
            }
            logMsg = "certificate revoked: " + cert.getSerialNumber();
            logger.debug(method + ": " + logMsg);
            this.tdbActivity("cert_revocation", tokenRecord, ipAddress, logMsg, "success", remoteUser);
        }
        catch (TPSException e) {
            String logMsg = "certificate not revoked: " + cert.getSerialNumber() + ": " + e;
            logger.debug(method + ": " + logMsg);
            if (e.getStatus() == EndOpMsg.TPSStatus.STATUS_NO_ERROR) {
                this.tdbActivity("token_modify", tokenRecord, ipAddress, e.getMessage(), "success", remoteUser);
                return;
            }
            this.tdbActivity("cert_revocation", tokenRecord, ipAddress, e.getMessage(), "failure", remoteUser);
            throw e;
        }
    }

    private void unrevokeCert(TokenRecord tokenRecord, TPSCertRecord cert, String tokenReason, String ipAddress, String remoteUser) throws Exception {
        String method = "TokenDB.unrevokeCert";
        TPSEngine engine = TPSEngine.getInstance();
        try {
            TPSEngineConfig configStore = engine.getConfig();
            String config = "op.enroll." + cert.getType() + ".keyGen." + cert.getKeyType() + ".ca.conn";
            String connID = configStore.getString(config);
            RevocationReason revokeReason = RevocationReason.UNSPECIFIED;
            Object logMsg = "called to unrevoke";
            logger.debug(method + ": " + (String)logMsg);
            if (!cert.getStatus().equalsIgnoreCase(TokenCertStatus.ONHOLD.toString())) {
                logMsg = "certificate record current status is not revoked_on_hold; cannot unrevoke";
                logger.warn(method + ": " + (String)logMsg);
                return;
            }
            CARemoteRequestHandler caRH = new CARemoteRequestHandler(connID);
            BigInteger bInt = cert.getSerialNumberInBigInteger();
            String serialStr = bInt.toString();
            logger.debug(method + ": found cert hex serial: " + cert.getSerialNumber() + " dec serial: " + serialStr);
            CARevokeCertResponse response = caRH.revokeCertificate(false, serialStr, cert.getCertificate(), revokeReason);
            logger.debug(method + ": response status: " + response.getStatus());
            this.updateCertsStatus(cert.getSerialNumber(), cert.getIssuedBy(), TokenCertStatus.ACTIVE.toString());
            logMsg = "certificate unrevoked: " + cert.getSerialNumber();
            logger.debug(method + ": " + (String)logMsg);
            this.tdbActivity("cert_restoration", tokenRecord, ipAddress, (String)logMsg, "success", remoteUser);
        }
        catch (Exception e) {
            String logMsg = "certificate not unrevoked: " + cert.getSerialNumber() + " : " + e.getMessage();
            logger.warn(method + ": " + logMsg, (Throwable)e);
            this.tdbActivity("cert_restoration", tokenRecord, ipAddress, e.getMessage(), "failure", remoteUser);
            throw e;
        }
    }

    private void checkShouldRevoke(TokenRecord tokenRecord, TPSCertRecord cert, String tokenReason, String ipAddress, String remoteUser) throws Exception {
        String method = "TokenDB.checkShouldRevoke:";
        Object msg = "";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        if (cert == null) {
            throw new TPSException("Missing token certificate");
        }
        if (cert.getStatus().equalsIgnoreCase(TokenCertStatus.REVOKED.toString())) {
            String existingTokenReason = tokenRecord.getReason();
            if (existingTokenReason != null && existingTokenReason.equals(tokenReason) || existingTokenReason == null && tokenReason == null) {
                throw new TPSException(method + "certificate " + cert.getSerialNumber() + " already revoked and reason has not changed.");
            }
            logger.debug(method + "Cert " + cert.getSerialNumber() + " already revoked, but reason has changed, so revoking again.");
            logger.debug(method + "Previous reason was: " + (existingTokenReason == null ? "(null)" : existingTokenReason));
            logger.debug(method + "New reason is: " + (tokenReason == null ? "(null)" : tokenReason));
        }
        logger.debug(method + "begins: ");
        String tokenType = cert.getType();
        String keyType = cert.getKeyType();
        String config = "op.enroll." + tokenType + ".keyGen." + keyType + ".recovery." + tokenReason + ".revokeCert";
        logger.debug(method + "getting config:" + config);
        boolean revokeCerts = configStore.getBoolean(config, true);
        if (!revokeCerts) {
            throw new TPSException("certificate revocation (serial " + cert.getSerialNumber() + ") not enabled for tokenType: " + tokenType + ", keyType: " + keyType + ", state: " + tokenReason, EndOpMsg.TPSStatus.STATUS_NO_ERROR);
        }
        config = "op.enroll." + tokenType + ".keyGen." + keyType + ".recovery." + tokenReason + ".revokeExpiredCerts";
        logger.debug(method + "getting config:" + config);
        boolean revokeExpiredCerts = configStore.getBoolean(config, true);
        if (!revokeExpiredCerts) {
            Date notBefore = cert.getValidNotBefore();
            Date now = new Date();
            Date notAfter = cert.getValidNotAfter();
            if (now.after(notAfter)) {
                throw new TPSException("revocation not enabled for expired cert: " + cert.getSerialNumber(), EndOpMsg.TPSStatus.STATUS_NO_ERROR);
            }
            if (now.before(notBefore)) {
                throw new TPSException("revocation not enabled for cert that is not yet valid: " + cert.getSerialNumber(), EndOpMsg.TPSStatus.STATUS_NO_ERROR);
            }
        }
        config = "op.enroll." + tokenType + ".keyGen." + keyType + ".recovery." + tokenReason + ".holdRevocationUntilLastCredential";
        logger.debug(method + "getting config:" + config);
        boolean holdRevocation = configStore.getBoolean(config, false);
        if (holdRevocation && !this.isLastActiveSharedCert(cert.getSerialNumber(), cert.getIssuedBy(), tokenRecord.getId())) {
            msg = "revocation not permitted as certificate " + cert.getSerialNumber() + " is shared by another active token";
            logger.error(method + " holdRevocationUntilLastCredential true; " + (String)msg);
            throw new TPSException((String)msg, EndOpMsg.TPSStatus.STATUS_NO_ERROR);
        }
        logger.debug(method + "revocation allowed.");
    }

    private void revokeCertsByCUID(boolean isRevoke, String cuid, String tokenReason, String ipAddress, String remoteUser) throws Exception {
        String method = "TokenDB.revokeCertsByCUID";
        if (cuid == null) {
            String logMsg = "Missing token CUID";
            logger.error(method + ": " + logMsg);
            throw new TPSException(logMsg);
        }
        logger.debug(method + "begins: with tokenReason=" + tokenReason);
        TokenRecord tokenRecord = this.tdbGetTokenEntry(cuid);
        Collection<TPSCertRecord> certRecords = this.tps.getTokendb().tdbGetCertRecordsByCUID(cuid);
        if (!(tokenReason == null || tokenReason.equalsIgnoreCase("onHold") || tokenReason.equalsIgnoreCase("destroyed") || tokenReason.equalsIgnoreCase("keyCompromise") || tokenReason.equalsIgnoreCase("terminated"))) {
            String logMsg = "unknown tokenRecord lost reason:" + tokenReason;
            logger.error(method + ":" + logMsg);
            throw new Exception(method + ":" + logMsg);
        }
        for (TPSCertRecord cert : certRecords) {
            if (isRevoke) {
                this.revokeCert(tokenRecord, cert, tokenReason, ipAddress, remoteUser);
                continue;
            }
            this.unrevokeCert(tokenRecord, cert, tokenReason, ipAddress, remoteUser);
        }
    }

    public void updateCertsStatus(String serial, String issuer, String status) throws Exception {
        ArrayList<TPSCertRecord> certRecords = this.tps.getTokendb().tdbGetCertRecordsByCert(serial, issuer);
        for (TPSCertRecord certRecord : certRecords) {
            certRecord.setStatus(status);
            this.tps.certDatabase.updateRecord(certRecord.getId(), certRecord);
        }
    }

    public void tdbAddCertEntry(TPSCertRecord certRecord, String status) throws Exception {
        certRecord.setStatus(status);
        this.tps.certDatabase.addRecord(certRecord.getId(), certRecord);
    }

    public void tdbUpdateCertEntry(TPSCertRecord certRecord) throws Exception {
        TPSCertRecord existingCertRecord;
        String method = "TokenDB.tdbUpdateCertEntry";
        String id = certRecord.getId();
        try {
            existingCertRecord = (TPSCertRecord)this.tps.certDatabase.getRecord(id);
        }
        catch (Exception e) {
            logger.warn(method + ": token entry not found; Adding: " + e.getMessage(), (Throwable)e);
            this.tdbAddCertEntry(certRecord, certRecord.getStatus());
            return;
        }
        logger.debug(method + ": cert entry found; Modifying with status: " + certRecord.getStatus());
        certRecord.setCreateTime(existingCertRecord.getCreateTime());
        this.tps.certDatabase.updateRecord(id, certRecord);
    }
}

