/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tomcat;

import javax.net.ssl.SSLSession;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.jsse.JSSESupport;
import org.dogtagpki.tomcat.JSSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSSImplementation
extends SSLImplementation {
    public static final Logger logger = LoggerFactory.getLogger(JSSImplementation.class);

    public JSSImplementation() {
        logger.debug("JSSImplementation: instance created");
    }

    public SSLSupport getSSLSupport(SSLSession session) {
        logger.debug("JSSImplementation.getSSLSupport()");
        return new JSSESupport(session, null);
    }

    public SSLUtil getSSLUtil(SSLHostConfigCertificate cert) {
        logger.debug("JSSImplementation: getSSLUtil()");
        logger.debug("JSSImplementation: key alias: {}", (Object)cert.getCertificateKeyAlias());
        logger.debug("JSSImplementation: keystore provider: {}", (Object)cert.getCertificateKeystoreProvider());
        SSLHostConfig hostConfig = cert.getSSLHostConfig();
        logger.debug("JSSImplementation: key manager alg: {}", (Object)hostConfig.getKeyManagerAlgorithm());
        logger.debug("JSSImplementation: truststore alg: {}", (Object)hostConfig.getTruststoreAlgorithm());
        logger.debug("JSSImplementation: truststore provider: {}", (Object)hostConfig.getTruststoreProvider());
        return new JSSUtil(cert);
    }

    public boolean isAlpnSupported() {
        return false;
    }
}

