/*
    Copyright (C) 1998 Lars Knoll (knoll@mpi-hd.mpg.de)
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>
    Copyright (C) 2006 Samuel Weinig (sam.weinig@gmail.com)
    Copyright (C) 2004-2017 Apple Inc. All rights reserved.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "CachedResource.h"
#include "FrameLoaderTypes.h"

namespace WebCore {

class FrameLoader;
class StyleSheetContents;
class TextResourceDecoder;

struct CSSParserContext;

class CachedCSSStyleSheet final : public CachedResource {
public:
    CachedCSSStyleSheet(CachedResourceRequest&&, PAL::SessionID, const CookieJar*);
    virtual ~CachedCSSStyleSheet();

    enum class MIMETypeCheckHint { Strict, Lax };
    const String sheetText(MIMETypeCheckHint = MIMETypeCheckHint::Strict, bool* hasValidMIMEType = nullptr, bool* hasHTTPStatusOK = nullptr) const;

    RefPtr<StyleSheetContents> restoreParsedStyleSheet(const CSSParserContext&, CachePolicy, FrameLoader&);
    void saveParsedStyleSheet(Ref<StyleSheetContents>&&);

    bool mimeTypeAllowedByNosniff() const;

private:
    String responseMIMEType() const;
    bool canUseSheet(MIMETypeCheckHint, bool* hasValidMIMEType, bool* hasHTTPStatusOK) const;
    bool mayTryReplaceEncodedData() const final { return true; }
    Ref<TextResourceDecoder> protectedDecoder() const;

    void didAddClient(CachedResourceClient&) final;

    void setEncoding(const String&) final;
    ASCIILiteral encoding() const final;
    const TextResourceDecoder* textResourceDecoder() const final { return m_decoder.ptr(); }
    void finishLoading(const FragmentedSharedBuffer*, const NetworkLoadMetrics&) final;
    void destroyDecodedData() final;

    void setBodyDataFrom(const CachedResource&) final;

    void checkNotify(const NetworkLoadMetrics&, LoadWillContinueInAnotherProcess = LoadWillContinueInAnotherProcess::No) final;

    Ref<TextResourceDecoder> m_decoder;
    String m_decodedSheetText;

    RefPtr<StyleSheetContents> m_parsedStyleSheetCache;
};

} // namespace WebCore

SPECIALIZE_TYPE_TRAITS_CACHED_RESOURCE(CachedCSSStyleSheet, CachedResource::Type::CSSStyleSheet)
