// Copyright (c) 2009-present, Alibaba Cloud All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//	http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package i18n

import (
	"os"
	"strings"
)

type LanguageCode string

const (
	Zh = LanguageCode("zh")
	En = LanguageCode("en")
)

func getLanguageFromEnv() string {
	lang := os.Getenv("LANG")
	if strings.HasPrefix(lang, "zh_CN") {
		return "zh"
	} else {
		return "en"
	}
}

var language = getLanguageFromEnv()

func SetLanguage(lang string) {
	language = lang
}

func GetLanguage() string {
	return language
}
