# Pull Requests Tagging

If you need to tag folks on an issue or PR, you will generally want to tag the owners (not the lead) for [area](#areas) to which the change or issue is closest to. For areas which are large and can be operating system or architecture specific it's better to tag owners of [OS](#operating-systems) or [Architecture](#architectures).

## Areas

Note: Editing this file doesn't update the mapping used by the `@msftbot` issue notification bot to tag owners. Some area owners prefer not to get those notifications. To update those notifications, contact any one of `@danmoseley`, `@jeffschw`, `@marek-safar`, `@ericstj`, `@karelz`, or `@jeffhandley`; they have permissions to update [`msftbot` configuration](https://portal.fabricbot.ms/bot/?repo=dotnet/runtime). If you're a community member interested in these notifications, you won't appear in this table but we can add you to notifications - just let us know.

| Area                                           | Lead          | Owners (area experts to tag in PR's and issues)     | Notes                                                                                                                                                                                                                                                                                     |
|------------------------------------------------|---------------|-----------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| area-AssemblyLoader-coreclr                    | @agocke       | @agocke @vitek-karas  @vsadov                       |                                                                                                                                                                                                                                                                                           |
| area-AssemblyLoader-mono                       | @SamMonoRT    | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-Build-mono                                | @steveisok    | @akoeplinger                                        |                                                                                                                                                                                                                                                                                           |
| area-Codeflow                                  | @dotnet/dnr-codeflow    | @dotnet/dnr-codeflow                      |    Used for automated PR's that ingest code from other repos                                                                                                                                                                                                                              |
| area-Codegen-AOT-mono                          | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CodeGen-coreclr                           | @JulieLeeMSFT | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-Codegen-Interpreter-mono                  | @SamMonoRT    | @BrzVlad                                            |                                                                                                                                                                                                                                                                                           |
| area-Codegen-JIT-mono                          | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-Codegen-LLVM-mono                         | @SamMonoRT    | @imhameed                                           |                                                                                                                                                                                                                                                                                           |
| area-Codegen-meta-mono                         | @SamMonoRT    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CoreLib-mono                              | @steveisok    | @vargaz                                             |                                                                                                                                                                                                                                                                                           |
| area-CrossGen/NGEN-coreclr                     | @mangod9      | @dotnet/crossgen-contrib                            |                                                                                                                                                                                                                                                                                           |
| area-crossgen2-coreclr                         | @mangod9      | @trylek @dotnet/crossgen-contrib                    |                                                                                                                                                                                                                                                                                           |
| area-Debugger-mono                             | @lewing       | @thaystg  @radical                                  |                                                                                                                                                                                                                                                                                           |
| area-DependencyModel                           | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       | Consultants: @eerhardt <ul><li>Microsoft.Extensions.DependencyModel</li></ul>                                                                                                                                                                                                             |
| area-Diagnostics-coreclr                       | @tommcdon     | @tommcdon                                           |                                                                                                                                                                                                                                                                                           |
| area-EnC-mono                                  | @marek-safar  | @lambdageek                                         | Hot Reload on WebAssembly, Android, iOS, etc                                                                                                                                                                                                                                              |
| area-ExceptionHandling-coreclr                 | @mangod9      | @janvorli                                           |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Caching                        | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-Extensions-Configuration                  | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-Extensions-DependencyInjection            | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-Extensions-FileSystem                     | @jeffhandley  | @adamsitnik @carlossanlop @jozkee                   | Consultants: @eerhardt @GrabYourPitchforks                                                                                                                                                                                                                                                |
| area-Extensions-Hosting                        | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-Extensions-HttpClientFactory              | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Logging                        | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-Extensions-Options                        | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-Extensions-Primitives                     | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-GC-coreclr                                | @mangod9      | @Maoni0                                             |                                                                                                                                                                                                                                                                                           |
| area-GC-mono                                   | @SamMonoRT    | @BrzVlad                                            |                                                                                                                                                                                                                                                                                           |
| area-Host                                      | @agocke       | @jeffschwMSFT @vitek-karas  @vsadov                 | Issues with dotnet.exe including bootstrapping, framework detection, hostfxr.dll and hostpolicy.dll                                                                                                                                                                                       |
| area-HostModel                                 | @agocke       | @vitek-karas                                        |                                                                                                                                                                                                                                                                                           |
| area-ILTools-coreclr                           | @JulieLeeMSFT | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-ILVerification                            | @JulieLeeMSFT | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure                            | @ericstj      | @Anipik @ViktorHofer @jeffschwMSFT @dleeapho        |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-coreclr                    | @agocke       | @jeffschwMSFT @trylek                               |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-installer                  | @dleeapho     | @dleeapho @NikolaMilosavljevic                      |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-libraries                  | @ericstj      | @Anipik @ViktorHofer                                | Covers:<ul><li>Packaging</li><li>Build and test infra for libraries in dotnet/runtime repo</li><li>VS integration</li></ul><br/>                                                                                                                                                          |
| area-Infrastructure-mono                       | @steveisok    | @directhex                                          |                                                                                                                                                                                                                                                                                           |
| area-Interop-coreclr                           | @jeffschwMSFT | @jeffschwMSFT @AaronRobinsonMSFT                    |                                                                                                                                                                                                                                                                                           |
| area-Interop-mono                              | @marek-safar  | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-Meta                                      | @jeffhandley  | @buyaa-n @joperezr @krwq                            | Issues without clear association to any specific API/contract, e.g. <ul><li>new contract proposals</li><li>cross-cutting code/test pattern changes (e.g. FxCop failures)</li><li>project-wide docs</li></ul><br/>                                                                         |
| area-Microsoft.CSharp                          | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-Microsoft.Extensions                      | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-Microsoft.VisualBasic                     | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-Microsoft.Win32                           | @ericstj      | @Anipik @ViktorHofer                                | Including System.Windows.Extensions                                                                                                                                                                                                                                                       |
| area-PAL-coreclr                               | @mangod9      | @janvorli                                           |                                                                                                                                                                                                                                                                                           |
| area-PAL-libraries                             | @jeffhandley  | @bartonjs @GrabYourPitchforks                       |                                                                                                                                                                                                                                                                                           |
| area-Performance-mono                          | @SamMonoRT    | @SamMonoRT                                          |                                                                                                                                                                                                                                                                                           |
| area-R2RDump-coreclr                           | @mangod9      | @trylek                                             |                                                                                                                                                                                                                                                                                           |
| area-ReadyToRun-coreclr                        | @mangod9      | @trylek                                             |                                                                                                                                                                                                                                                                                           |
| area-Serialization                             | @HongGit      | @StephenMolloy @HongGit                             | Packages:<ul><li>System.Runtime.Serialization.Xml</li><li>System.Runtime.Serialization.Json</li><li>System.Private.DataContractSerialization</li><li>System.Xml.XmlSerializer</li></ul> Excluded:<ul><li>System.Runtime.Serialization.Formatters</li></ul>                                |
| area-Setup                                     | @dleeapho     | @NikolaMilosavljevic @dleeapho                      | Distro-specific (Linux, Mac and Windows) setup packages and msi files                                                                                                                                                                                                                     |
| area-Single-File                               | @agocke       | @vitek-karas @vsadov                                |                                                                                                                                                                                                                                                                                           |
| area-Snap                                      | @dleeapho     | @dleeapho @leecow @MichaelSimons                    |                                                                                                                                                                                                                                                                                           |
| area-System.Buffers                            | @jeffhandley  | @pgovind @tannergooding                             | Consultants: @GrabYourPitchforks                                                                                                                                                                                                                                                          |
| area-System.CodeDom                            | @jeffhandley  | @buyaa-n @joperezr @krwq                            |                                                                                                                                                                                                                                                                                           |
| area-System.Collections                        | @ericstj      | @eiriktsarpalis @layomia                            | Excluded:<ul><li>System.Array -> System.Runtime</li></ul> Consultants: @steveharter @GrabYourPitchForks                                                                                                                                                                                   |
| area-System.ComponentModel                     | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       |                                                                                                                                                                                                                                                                                           |
| area-System.ComponentModel.Composition         | @jeffhandley  | @buyaa-n @joperezr @krwq                            | Consultants: @steveharter                                                                                                                                                                                                                                                                 |
| area-System.ComponentModel.DataAnnotations     | @ajcvickers   | @lajones @ajcvickers                                | Included:<ul><li>System.ComponentModel.Annotations</li></ul>                                                                                                                                                                                                                              |
| area-System.Composition                        | @jeffhandley  | @buyaa-n @joperezr @krwq                            | Consultants: @steveharter                                                                                                                                                                                                                                                                 |
| area-System.Configuration                      | @jeffhandley  | @buyaa-n @joperezr @krwq                            | Consultants: @steveharter                                                                                                                                                                                                                                                                 |
| area-System.Console                            | @jeffhandley  | @adamsitnik @carlossanlop @jozkee                   | Consultants: @GrabYourPitchForks                                                                                                                                                                                                                                                          |
| area-System.Data                               | @ajcvickers   | @ajcvickers @cheenamalhotra @david-engel            | <ul><li>Odbc, OleDb - @saurabh500</li></ul>                                                                                                                                                                                                                                               |
| area-System.Data.Odbc                          | @ajcvickers   | @ajcvickers                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Data.OleDB                         | @ajcvickers   | @ajcvickers                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Data.SqlClient                     | @David-Engel  | @cheenamalhotra @david-engel @karinazhou @JRahnama  | Archived component - limited churn/contributions (see https://devblogs.microsoft.com/dotnet/introducing-the-new-microsoftdatasqlclient/)                                                                                                                                                  |
| area-System.Diagnostics                        | @tommcdon     | @tommcdon                                           |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics-coreclr                | @tommcdon     | @tommcdon                                           |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics-mono                   | @lewing       | @thaystg  @radical                                  |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Activity               | @tommcdon     | @tarekgh                                            |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.EventLog               | @ericstj      | @Anipik @ViktorHofer                                |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Metric                 | @tommcdon     | @noahfalk                                           |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.PerformanceCounter     | @ericstj      | @Anipik @ViktorHofer                                |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Process                | @jeffhandley  | @adamsitnik @carlossanlop @jozkee                   |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Tracing                | @tommcdon     | @noahfalk @tommcdon @Anipik @ViktorHofer @tarekgh   | Included: <ul><li>System.Diagnostics.DiagnosticSource</li><li>System.Diagnostics.TraceSource</li></ul>                                                                                                                                                                                    |
| area-System.Diagnostics.TraceSource            | @ericstj      | @Anipik @ViktorHofer                                |                                                                                                                                                                                                                                                                                           |
| area-System.DirectoryServices                  | @jeffhandley  | @buyaa-n @joperezr @krwq                            | Consultants: @tquerec @josephisenhour                                                                                                                                                                                                                                                     |
| area-System.Drawing                            | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       |                                                                                                                                                                                                                                                                                           |
| area-System.Dynamic.Runtime                    | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-System.Formats.Asn1                       | @jeffhandley  | @bartonjs @GrabYourPitchforks                       |                                                                                                                                                                                                                                                                                           |
| area-System.Formats.Cbor                       | @ericstj      | @eiriktsarpalis @layomia                            | Consultants: @bartonjs @GrabYourPitchForks                                                                                                                                                                                                                                                |
| area-System.Globalization                      | @ericstj      | @maryamariyan @michaelgsharp @safern @tarekgh       |                                                                                                                                                                                                                                                                                           |
| area-System.IO                                 | @jeffhandley  | @adamsitnik @carlossanlop @jozkee                   |                                                                                                                                                                                                                                                                                           |
| area-System.IO.Compression                     | @jeffhandley  | @adamsitnik @carlossanlop @jozkee                   | Consultants: @ericstj <ul><li>Also includes System.IO.Packaging</li></ul>                                                                                                                                                                                                                 |
| area-System.IO.Pipelines                       | @kevinpi      | @davidfowl @halter73 @jkotalik                      |                                                                                                                                                                                                                                                                                           |
| area-System.Linq                               | @ericstj      | @eiriktsarpalis @layomia                            | Consultants: @steveharter                                                                                                                                                                                                                                                                 |
| area-System.Linq.Expressions                   | @jaredpar     | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-System.Linq.Parallel                      | @jeffhandley  | @adamsitnik @carlossanlop @jozkee                   | Consultants: @stephentoub @kouvel                                                                                                                                                                                                                                                         |
| area-System.Management                         | @ericstj      | @Anipik @ViktorHofer                                | WMI                                                                                                                                                                                                                                                                                       |
| area-System.Memory                             | @jeffhandley  | @adamsitnik @carlossanlop @jozkee                   | Consultants: @GrabYourPitchforks                                                                                                                                                                                                                                                          |
| area-System.Net                                | @karelz       | @dotnet/ncl                                         | Included:<ul><li>System.Uri</li></ul>                                                                                                                                                                                                                                                     |
| area-System.Net.Http                           | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Quic                           | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Security                       | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Sockets                        | @karelz       | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Numerics                           | @jeffhandley  | @pgovind @tannergooding                             |                                                                                                                                                                                                                                                                                           |
| area-System.Numerics.Tensors                   | @jeffhandley  | @pgovind @tannergooding                             |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection                         | @jeffhandley  | @buyaa-n @joperezr @krwq @steveharter               | Consultants: @GrabYourPitchforks                                                                                                                                                                                                                                                          |
| area-System.Reflection-mono                    | @SamMonoRT    | @lambdageek                                         | MonoVM-specific reflection and reflection-emit issues                                                                                                                                                                                                                                     |
| area-System.Reflection.Emit                    | @jeffhandley  | @buyaa-n @joperezr @krwq @steveharter               | Consultants: @GrabYourPitchforks                                                                                                                                                                                                                                                          |
| area-System.Reflection.Metadata                | @jeffhandley  | @buyaa-n @joperezr @krwq @steveharter               | Consultants: @GrabYourPitchforks @tmat                                                                                                                                                                                                                                                    |
| area-System.Resources                          | @jeffhandley  | @buyaa-n @joperezr @krwq                            |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime                            | @jeffhandley  | @pgovind @tannergooding                             | Consultants: @bartonjs<br />Included:<ul><li>System.Runtime.Serialization.Formatters</li><li>System.Runtime.InteropServices.RuntimeInfo</li><li>System.Array</li></ul>Excluded:<ul><li>Path -> System.IO</li><li>StopWatch -> System.Diagnostics</li><li>Uri -> System.Net</li><li>WebUtility -> System.Net</li></ul> |
| area-System.Runtime.Caching                    | @HongGit      | @StephenMolloy @HongGit                             |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.CompilerServices           | @jeffhandley  | @buyaa-n @joperezr @krwq                            | Consultants: @steveharter                                                                                                                                                                                                                                                                 |
| area-System.Runtime.InteropServices            | @jeffschwMSFT | @AaronRobinsonMSFT @jkoritzinsky                    | Excluded:<ul><li>System.Runtime.InteropServices.RuntimeInfo</li></ul>                                                                                                                                                                                                                     |
| area-System.Runtime.InteropServices.JavaScript | @lewing       | @kjpou1                                             |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.Intrinsics                 | @jeffhandley  | @pgovind @tannergooding @echesakovMSFT              |                                                                                                                                                                                                                                                                                           |
| area-System.Security                           | @jeffhandley  | @bartonjs @GrabYourPitchforks                       |                                                                                                                                                                                                                                                                                           |
| area-System.ServiceModel                       | @HongGit      | @HongGit @mconnew                                   | Repo: https://github.com/dotnet/WCF<br>Packages:<ul><li>System.ServiceModel.Primitives</li><li>System.ServiceModel.Http</li><li>System.ServiceModel.NetTcp</li><li>System.ServiceModel.Duplex</li><li>System.ServiceModel.Security</li></ul>                                              |
| area-System.ServiceModel.Syndication           | @HongGit      | @StephenMolloy @HongGit                             |                                                                                                                                                                                                                                                                                           |
| area-System.ServiceProcess                     | @ericstj      | @Anipik @ViktorHofer                                |                                                                                                                                                                                                                                                                                           |
| area-System.Speech                             | @danmoseley   | @danmoseley                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Encoding                      | @ericstj      | @eiriktsarpalis @layomia                            | Consultants: @GrabYourPitchforks                                                                                                                                                                                                                                                          |
| area-System.Text.Encodings.Web                 | @ericstj      | @eiriktsarpalis @layomia                            | Consultants: @GrabYourPitchforks                                                                                                                                                                                                                                                          |
| area-System.Text.Json                          | @ericstj      | @eiriktsarpalis @layomia @steveharter               |                                                                                                                                                                                                                                                                                           |
| area-System.Text.RegularExpressions            | @jeffhandley  | @pgovind @tannergooding                             | Consultants: @eerhardt @stephentoub                                                                                                                                                                                                                                                       |
| area-System.Threading                          | @mangod9      | @kouvel                                             |                                                                                                                                                                                                                                                                                           |
| area-System.Threading.Channels                 | @jeffhandley  | @adamsitnik @carlossanlop @jozkee                   | Consultants: @stephentoub                                                                                                                                                                                                                                                                 |
| area-System.Threading.Tasks                    | @jeffhandley  | @adamsitnik @carlossanlop @jozkee                   | Consultants: @stephentoub                                                                                                                                                                                                                                                                 |
| area-System.Transactions                       | @HongGit      | @HongGit                                            |                                                                                                                                                                                                                                                                                           |
| area-System.Xml                                | @jeffhandley  | @buyaa-n @joperezr @krwq                            | Consultants: @steveharter                                                                                                                                                                                                                                                                 |
| area-Threading-mono                            | @SamMonoRT    | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-TieredCompilation-coreclr                 | @mangod9      | @kouvel                                             |                                                                                                                                                                                                                                                                                           |
| area-Tracing-coreclr                           | @tommcdon     | @sywhang @josalem                                   |                                                                                                                                                                                                                                                                                           |
| area-Tracing-mono                              | @steveisok    | @lateralusX                                         |                                                                                                                                                                                                                                                                                           |
| area-TypeSystem-coreclr                        | @mangod9      | @davidwrighton @MichalStrehovsky @janvorli @mangod9 |                                                                                                                                                                                                                                                                                           |
| area-UWP                                       | @tommcdon     | @jashook                                            | UWP-specific issues including Microsoft.NETCore.UniversalWindowsPlatform and Microsoft.Net.UWPCoreRuntimeSdk                                                                                                                                                                              |
| area-VM-coreclr                                | @mangod9      | @mangod9                                            |                                                                                                                                                                                                                                                                                           |
| area-VM-meta-mono                              | @SamMonoRT    | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |

## Operating Systems

| Operating System | Lead          | Owners (area experts to tag in PR's and issues)     | Description  |
|------------------|---------------|-----------------------------------------------------|--------------|
| os-alpine        |               |                                                     |              |
| os-android       | @steveisok    | @akoeplinger                                        |              |
| os-freebsd       |               |                                                     |              |
| os-mac-os-x      |               |                                                     |              |
| os-maccatalyst   | @steveisok    |                                                     |              |
| os-ios           | @steveisok    | @vargaz                                             |              |
| os-tvos          | @steveisok    | @vargaz                                             |              |

## Architectures

| Architecture     | Lead          | Owners (area experts to tag in PR's and issues)     | Description  |
|------------------|---------------|-----------------------------------------------------|--------------|
| arch-wasm        | @lewing       | @lewing @BrzVlad                                    |              |

