// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using Microsoft.Win32.SafeHandles;
using System;
using System.Runtime.InteropServices;

internal static partial class Interop
{
    internal static partial class Advapi32
    {
        [DllImport(Interop.Libraries.Advapi32, SetLastError = true)]
        internal static extern bool DuplicateTokenEx(
            SafeAccessTokenHandle hExistingToken,
            uint dwDesiredAccess,
            IntPtr lpTokenAttributes,   // LPSECURITY_ATTRIBUTES
            uint ImpersonationLevel,
            uint TokenType,
            ref SafeAccessTokenHandle phNewToken);
    }
}
