// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["CompareGreaterThanScalar.Vector64.UInt64"] = CompareGreaterThanScalar_Vector64_UInt64,
                ["CompareGreaterThanOrEqual.Vector128.Double"] = CompareGreaterThanOrEqual_Vector128_Double,
                ["CompareGreaterThanOrEqual.Vector128.Int64"] = CompareGreaterThanOrEqual_Vector128_Int64,
                ["CompareGreaterThanOrEqual.Vector128.UInt64"] = CompareGreaterThanOrEqual_Vector128_UInt64,
                ["CompareGreaterThanOrEqualScalar.Vector64.Double"] = CompareGreaterThanOrEqualScalar_Vector64_Double,
                ["CompareGreaterThanOrEqualScalar.Vector64.Int64"] = CompareGreaterThanOrEqualScalar_Vector64_Int64,
                ["CompareGreaterThanOrEqualScalar.Vector64.Single"] = CompareGreaterThanOrEqualScalar_Vector64_Single,
                ["CompareGreaterThanOrEqualScalar.Vector64.UInt64"] = CompareGreaterThanOrEqualScalar_Vector64_UInt64,
                ["CompareLessThan.Vector128.Double"] = CompareLessThan_Vector128_Double,
                ["CompareLessThan.Vector128.Int64"] = CompareLessThan_Vector128_Int64,
                ["CompareLessThan.Vector128.UInt64"] = CompareLessThan_Vector128_UInt64,
                ["CompareLessThanScalar.Vector64.Double"] = CompareLessThanScalar_Vector64_Double,
                ["CompareLessThanScalar.Vector64.Int64"] = CompareLessThanScalar_Vector64_Int64,
                ["CompareLessThanScalar.Vector64.Single"] = CompareLessThanScalar_Vector64_Single,
                ["CompareLessThanScalar.Vector64.UInt64"] = CompareLessThanScalar_Vector64_UInt64,
                ["CompareLessThanOrEqual.Vector128.Double"] = CompareLessThanOrEqual_Vector128_Double,
                ["CompareLessThanOrEqual.Vector128.Int64"] = CompareLessThanOrEqual_Vector128_Int64,
                ["CompareLessThanOrEqual.Vector128.UInt64"] = CompareLessThanOrEqual_Vector128_UInt64,
                ["CompareLessThanOrEqualScalar.Vector64.Double"] = CompareLessThanOrEqualScalar_Vector64_Double,
                ["CompareLessThanOrEqualScalar.Vector64.Int64"] = CompareLessThanOrEqualScalar_Vector64_Int64,
                ["CompareLessThanOrEqualScalar.Vector64.Single"] = CompareLessThanOrEqualScalar_Vector64_Single,
                ["CompareLessThanOrEqualScalar.Vector64.UInt64"] = CompareLessThanOrEqualScalar_Vector64_UInt64,
                ["CompareTest.Vector128.Double"] = CompareTest_Vector128_Double,
                ["CompareTest.Vector128.Int64"] = CompareTest_Vector128_Int64,
                ["CompareTest.Vector128.UInt64"] = CompareTest_Vector128_UInt64,
                ["CompareTestScalar.Vector64.Double"] = CompareTestScalar_Vector64_Double,
                ["CompareTestScalar.Vector64.Int64"] = CompareTestScalar_Vector64_Int64,
                ["CompareTestScalar.Vector64.UInt64"] = CompareTestScalar_Vector64_UInt64,
                ["ConvertToDouble.Vector64.Single"] = ConvertToDouble_Vector64_Single,
                ["ConvertToDouble.Vector128.Int64"] = ConvertToDouble_Vector128_Int64,
                ["ConvertToDouble.Vector128.UInt64"] = ConvertToDouble_Vector128_UInt64,
                ["ConvertToDoubleScalar.Vector64.Int64"] = ConvertToDoubleScalar_Vector64_Int64,
                ["ConvertToDoubleScalar.Vector64.UInt64"] = ConvertToDoubleScalar_Vector64_UInt64,
                ["ConvertToDoubleUpper.Vector128.Single"] = ConvertToDoubleUpper_Vector128_Single,
                ["ConvertToInt64RoundAwayFromZero.Vector128.Double"] = ConvertToInt64RoundAwayFromZero_Vector128_Double,
                ["ConvertToInt64RoundAwayFromZeroScalar.Vector64.Double"] = ConvertToInt64RoundAwayFromZeroScalar_Vector64_Double,
                ["ConvertToInt64RoundToEven.Vector128.Double"] = ConvertToInt64RoundToEven_Vector128_Double,
                ["ConvertToInt64RoundToEvenScalar.Vector64.Double"] = ConvertToInt64RoundToEvenScalar_Vector64_Double,
                ["ConvertToInt64RoundToNegativeInfinity.Vector128.Double"] = ConvertToInt64RoundToNegativeInfinity_Vector128_Double,
                ["ConvertToInt64RoundToNegativeInfinityScalar.Vector64.Double"] = ConvertToInt64RoundToNegativeInfinityScalar_Vector64_Double,
                ["ConvertToInt64RoundToPositiveInfinity.Vector128.Double"] = ConvertToInt64RoundToPositiveInfinity_Vector128_Double,
                ["ConvertToInt64RoundToPositiveInfinityScalar.Vector64.Double"] = ConvertToInt64RoundToPositiveInfinityScalar_Vector64_Double,
                ["ConvertToInt64RoundToZero.Vector128.Double"] = ConvertToInt64RoundToZero_Vector128_Double,
                ["ConvertToInt64RoundToZeroScalar.Vector64.Double"] = ConvertToInt64RoundToZeroScalar_Vector64_Double,
                ["ConvertToSingleLower.Vector64.Single"] = ConvertToSingleLower_Vector64_Single,
                ["ConvertToSingleRoundToOddLower.Vector64.Single"] = ConvertToSingleRoundToOddLower_Vector64_Single,
                ["ConvertToSingleRoundToOddUpper.Vector128.Single"] = ConvertToSingleRoundToOddUpper_Vector128_Single,
                ["ConvertToSingleUpper.Vector128.Single"] = ConvertToSingleUpper_Vector128_Single,
                ["ConvertToUInt64RoundAwayFromZero.Vector128.Double"] = ConvertToUInt64RoundAwayFromZero_Vector128_Double,
                ["ConvertToUInt64RoundAwayFromZeroScalar.Vector64.Double"] = ConvertToUInt64RoundAwayFromZeroScalar_Vector64_Double,
                ["ConvertToUInt64RoundToEven.Vector128.Double"] = ConvertToUInt64RoundToEven_Vector128_Double,
                ["ConvertToUInt64RoundToEvenScalar.Vector64.Double"] = ConvertToUInt64RoundToEvenScalar_Vector64_Double,
                ["ConvertToUInt64RoundToNegativeInfinity.Vector128.Double"] = ConvertToUInt64RoundToNegativeInfinity_Vector128_Double,
                ["ConvertToUInt64RoundToNegativeInfinityScalar.Vector64.Double"] = ConvertToUInt64RoundToNegativeInfinityScalar_Vector64_Double,
                ["ConvertToUInt64RoundToPositiveInfinity.Vector128.Double"] = ConvertToUInt64RoundToPositiveInfinity_Vector128_Double,
                ["ConvertToUInt64RoundToPositiveInfinityScalar.Vector64.Double"] = ConvertToUInt64RoundToPositiveInfinityScalar_Vector64_Double,
                ["ConvertToUInt64RoundToZero.Vector128.Double"] = ConvertToUInt64RoundToZero_Vector128_Double,
                ["ConvertToUInt64RoundToZeroScalar.Vector64.Double"] = ConvertToUInt64RoundToZeroScalar_Vector64_Double,
                ["Divide.Vector64.Single"] = Divide_Vector64_Single,
                ["Divide.Vector128.Double"] = Divide_Vector128_Double,
                ["Divide.Vector128.Single"] = Divide_Vector128_Single,
                ["DuplicateSelectedScalarToVector128.V128.Double.1"] = DuplicateSelectedScalarToVector128_V128_Double_1,
                ["DuplicateSelectedScalarToVector128.V128.Int64.1"] = DuplicateSelectedScalarToVector128_V128_Int64_1,
                ["DuplicateSelectedScalarToVector128.V128.UInt64.1"] = DuplicateSelectedScalarToVector128_V128_UInt64_1,
                ["DuplicateToVector128.Double"] = DuplicateToVector128_Double,
                ["DuplicateToVector128.Double.31"] = DuplicateToVector128_Double_31,
                ["DuplicateToVector128.Int64"] = DuplicateToVector128_Int64,
                ["DuplicateToVector128.Int64.31"] = DuplicateToVector128_Int64_31,
                ["DuplicateToVector128.UInt64"] = DuplicateToVector128_UInt64,
                ["DuplicateToVector128.UInt64.31"] = DuplicateToVector128_UInt64_31,
                ["ExtractNarrowingSaturateScalar.Vector64.Byte"] = ExtractNarrowingSaturateScalar_Vector64_Byte,
                ["ExtractNarrowingSaturateScalar.Vector64.Int16"] = ExtractNarrowingSaturateScalar_Vector64_Int16,
                ["ExtractNarrowingSaturateScalar.Vector64.Int32"] = ExtractNarrowingSaturateScalar_Vector64_Int32,
                ["ExtractNarrowingSaturateScalar.Vector64.SByte"] = ExtractNarrowingSaturateScalar_Vector64_SByte,
                ["ExtractNarrowingSaturateScalar.Vector64.UInt16"] = ExtractNarrowingSaturateScalar_Vector64_UInt16,
                ["ExtractNarrowingSaturateScalar.Vector64.UInt32"] = ExtractNarrowingSaturateScalar_Vector64_UInt32,
                ["ExtractNarrowingSaturateUnsignedScalar.Vector64.Byte"] = ExtractNarrowingSaturateUnsignedScalar_Vector64_Byte,
                ["ExtractNarrowingSaturateUnsignedScalar.Vector64.UInt16"] = ExtractNarrowingSaturateUnsignedScalar_Vector64_UInt16,
                ["ExtractNarrowingSaturateUnsignedScalar.Vector64.UInt32"] = ExtractNarrowingSaturateUnsignedScalar_Vector64_UInt32,
                ["Floor.Vector128.Double"] = Floor_Vector128_Double,
                ["FusedMultiplyAdd.Vector128.Double"] = FusedMultiplyAdd_Vector128_Double,
                ["FusedMultiplyAddByScalar.Vector64.Single"] = FusedMultiplyAddByScalar_Vector64_Single,
                ["FusedMultiplyAddByScalar.Vector128.Double"] = FusedMultiplyAddByScalar_Vector128_Double,
                ["FusedMultiplyAddByScalar.Vector128.Single"] = FusedMultiplyAddByScalar_Vector128_Single,
                ["FusedMultiplyAddBySelectedScalar.Vector64.Single.Vector64.Single.1"] = FusedMultiplyAddBySelectedScalar_Vector64_Single_Vector64_Single_1,
                ["FusedMultiplyAddBySelectedScalar.Vector64.Single.Vector128.Single.3"] = FusedMultiplyAddBySelectedScalar_Vector64_Single_Vector128_Single_3,
                ["FusedMultiplyAddBySelectedScalar.Vector128.Double.Vector128.Double.1"] = FusedMultiplyAddBySelectedScalar_Vector128_Double_Vector128_Double_1,
                ["FusedMultiplyAddBySelectedScalar.Vector128.Single.Vector64.Single.1"] = FusedMultiplyAddBySelectedScalar_Vector128_Single_Vector64_Single_1,
                ["FusedMultiplyAddBySelectedScalar.Vector128.Single.Vector128.Single.3"] = FusedMultiplyAddBySelectedScalar_Vector128_Single_Vector128_Single_3,
                ["FusedMultiplyAddScalarBySelectedScalar.Vector64.Double.Vector128.Double.1"] = FusedMultiplyAddScalarBySelectedScalar_Vector64_Double_Vector128_Double_1,
                ["FusedMultiplyAddScalarBySelectedScalar.Vector64.Single.Vector64.Single.1"] = FusedMultiplyAddScalarBySelectedScalar_Vector64_Single_Vector64_Single_1,
                ["FusedMultiplyAddScalarBySelectedScalar.Vector64.Single.Vector128.Single.3"] = FusedMultiplyAddScalarBySelectedScalar_Vector64_Single_Vector128_Single_3,
                ["FusedMultiplySubtract.Vector128.Double"] = FusedMultiplySubtract_Vector128_Double,
                ["FusedMultiplySubtractByScalar.Vector64.Single"] = FusedMultiplySubtractByScalar_Vector64_Single,
                ["FusedMultiplySubtractByScalar.Vector128.Double"] = FusedMultiplySubtractByScalar_Vector128_Double,
                ["FusedMultiplySubtractByScalar.Vector128.Single"] = FusedMultiplySubtractByScalar_Vector128_Single,
                ["FusedMultiplySubtractBySelectedScalar.Vector64.Single.Vector64.Single.1"] = FusedMultiplySubtractBySelectedScalar_Vector64_Single_Vector64_Single_1,
                ["FusedMultiplySubtractBySelectedScalar.Vector64.Single.Vector128.Single.3"] = FusedMultiplySubtractBySelectedScalar_Vector64_Single_Vector128_Single_3,
                ["FusedMultiplySubtractBySelectedScalar.Vector128.Double.Vector128.Double.1"] = FusedMultiplySubtractBySelectedScalar_Vector128_Double_Vector128_Double_1,
                ["FusedMultiplySubtractBySelectedScalar.Vector128.Single.Vector64.Single.1"] = FusedMultiplySubtractBySelectedScalar_Vector128_Single_Vector64_Single_1,
            };
        }
    }
}
