// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["FusedMultiplySubtractBySelectedScalar.Vector128.Single.Vector128.Single.3"] = FusedMultiplySubtractBySelectedScalar_Vector128_Single_Vector128_Single_3,
                ["FusedMultiplySubtractScalarBySelectedScalar.Vector64.Double.Vector128.Double.1"] = FusedMultiplySubtractScalarBySelectedScalar_Vector64_Double_Vector128_Double_1,
                ["FusedMultiplySubtractScalarBySelectedScalar.Vector64.Single.Vector64.Single.1"] = FusedMultiplySubtractScalarBySelectedScalar_Vector64_Single_Vector64_Single_1,
                ["FusedMultiplySubtractScalarBySelectedScalar.Vector64.Single.Vector128.Single.3"] = FusedMultiplySubtractScalarBySelectedScalar_Vector64_Single_Vector128_Single_3,
                ["InsertSelectedScalar.Vector64.Byte.7.Vector64.Byte.7"] = InsertSelectedScalar_Vector64_Byte_7_Vector64_Byte_7,
                ["InsertSelectedScalar.Vector64.Byte.7.Vector128.Byte.15"] = InsertSelectedScalar_Vector64_Byte_7_Vector128_Byte_15,
                ["InsertSelectedScalar.Vector64.Int16.3.Vector64.Int16.3"] = InsertSelectedScalar_Vector64_Int16_3_Vector64_Int16_3,
                ["InsertSelectedScalar.Vector64.Int16.3.Vector128.Int16.7"] = InsertSelectedScalar_Vector64_Int16_3_Vector128_Int16_7,
                ["InsertSelectedScalar.Vector64.Int32.1.Vector64.Int32.1"] = InsertSelectedScalar_Vector64_Int32_1_Vector64_Int32_1,
                ["InsertSelectedScalar.Vector64.Int32.1.Vector128.Int32.3"] = InsertSelectedScalar_Vector64_Int32_1_Vector128_Int32_3,
                ["InsertSelectedScalar.Vector64.SByte.7.Vector64.SByte.7"] = InsertSelectedScalar_Vector64_SByte_7_Vector64_SByte_7,
                ["InsertSelectedScalar.Vector64.SByte.7.Vector128.SByte.15"] = InsertSelectedScalar_Vector64_SByte_7_Vector128_SByte_15,
                ["InsertSelectedScalar.Vector64.Single.1.Vector64.Single.1"] = InsertSelectedScalar_Vector64_Single_1_Vector64_Single_1,
                ["InsertSelectedScalar.Vector64.Single.1.Vector128.Single.3"] = InsertSelectedScalar_Vector64_Single_1_Vector128_Single_3,
                ["InsertSelectedScalar.Vector64.UInt16.3.Vector64.UInt16.3"] = InsertSelectedScalar_Vector64_UInt16_3_Vector64_UInt16_3,
                ["InsertSelectedScalar.Vector64.UInt16.3.Vector128.UInt16.7"] = InsertSelectedScalar_Vector64_UInt16_3_Vector128_UInt16_7,
                ["InsertSelectedScalar.Vector64.UInt32.1.Vector64.UInt32.1"] = InsertSelectedScalar_Vector64_UInt32_1_Vector64_UInt32_1,
                ["InsertSelectedScalar.Vector64.UInt32.1.Vector128.UInt32.3"] = InsertSelectedScalar_Vector64_UInt32_1_Vector128_UInt32_3,
                ["InsertSelectedScalar.Vector128.Byte.15.Vector64.Byte.7"] = InsertSelectedScalar_Vector128_Byte_15_Vector64_Byte_7,
                ["InsertSelectedScalar.Vector128.Byte.15.Vector128.Byte.15"] = InsertSelectedScalar_Vector128_Byte_15_Vector128_Byte_15,
                ["InsertSelectedScalar.Vector128.Double.1.Vector128.Double.1"] = InsertSelectedScalar_Vector128_Double_1_Vector128_Double_1,
                ["InsertSelectedScalar.Vector128.Int16.7.Vector64.Int16.3"] = InsertSelectedScalar_Vector128_Int16_7_Vector64_Int16_3,
                ["InsertSelectedScalar.Vector128.Int16.7.Vector128.Int16.7"] = InsertSelectedScalar_Vector128_Int16_7_Vector128_Int16_7,
                ["InsertSelectedScalar.Vector128.Int32.3.Vector64.Int32.1"] = InsertSelectedScalar_Vector128_Int32_3_Vector64_Int32_1,
                ["InsertSelectedScalar.Vector128.Int32.3.Vector128.Int32.3"] = InsertSelectedScalar_Vector128_Int32_3_Vector128_Int32_3,
                ["InsertSelectedScalar.Vector128.Int64.1.Vector128.Int64.1"] = InsertSelectedScalar_Vector128_Int64_1_Vector128_Int64_1,
                ["InsertSelectedScalar.Vector128.SByte.15.Vector64.SByte.7"] = InsertSelectedScalar_Vector128_SByte_15_Vector64_SByte_7,
                ["InsertSelectedScalar.Vector128.SByte.15.Vector128.SByte.15"] = InsertSelectedScalar_Vector128_SByte_15_Vector128_SByte_15,
                ["InsertSelectedScalar.Vector128.Single.3.Vector64.Single.1"] = InsertSelectedScalar_Vector128_Single_3_Vector64_Single_1,
                ["InsertSelectedScalar.Vector128.Single.3.Vector128.Single.3"] = InsertSelectedScalar_Vector128_Single_3_Vector128_Single_3,
                ["InsertSelectedScalar.Vector128.UInt16.7.Vector64.UInt16.3"] = InsertSelectedScalar_Vector128_UInt16_7_Vector64_UInt16_3,
                ["InsertSelectedScalar.Vector128.UInt16.7.Vector128.UInt16.7"] = InsertSelectedScalar_Vector128_UInt16_7_Vector128_UInt16_7,
                ["InsertSelectedScalar.Vector128.UInt32.3.Vector64.UInt32.1"] = InsertSelectedScalar_Vector128_UInt32_3_Vector64_UInt32_1,
                ["InsertSelectedScalar.Vector128.UInt32.3.Vector128.UInt32.3"] = InsertSelectedScalar_Vector128_UInt32_3_Vector128_UInt32_3,
                ["InsertSelectedScalar.Vector128.UInt64.1.Vector128.UInt64.1"] = InsertSelectedScalar_Vector128_UInt64_1_Vector128_UInt64_1,
                ["LoadAndReplicateToVector128.Double"] = LoadAndReplicateToVector128_Double,
                ["LoadAndReplicateToVector128.Int64"] = LoadAndReplicateToVector128_Int64,
                ["LoadAndReplicateToVector128.UInt64"] = LoadAndReplicateToVector128_UInt64,
                ["Max.Vector128.Double"] = Max_Vector128_Double,
                ["MaxAcross.Vector64.Byte"] = MaxAcross_Vector64_Byte,
                ["MaxAcross.Vector64.Int16"] = MaxAcross_Vector64_Int16,
                ["MaxAcross.Vector64.SByte"] = MaxAcross_Vector64_SByte,
                ["MaxAcross.Vector64.UInt16"] = MaxAcross_Vector64_UInt16,
                ["MaxAcross.Vector128.Byte"] = MaxAcross_Vector128_Byte,
                ["MaxAcross.Vector128.Int16"] = MaxAcross_Vector128_Int16,
                ["MaxAcross.Vector128.Int32"] = MaxAcross_Vector128_Int32,
                ["MaxAcross.Vector128.SByte"] = MaxAcross_Vector128_SByte,
                ["MaxAcross.Vector128.Single"] = MaxAcross_Vector128_Single,
                ["MaxAcross.Vector128.UInt16"] = MaxAcross_Vector128_UInt16,
                ["MaxAcross.Vector128.UInt32"] = MaxAcross_Vector128_UInt32,
                ["MaxNumber.Vector128.Double"] = MaxNumber_Vector128_Double,
                ["MaxNumberAcross.Vector128.Single"] = MaxNumberAcross_Vector128_Single,
                ["MaxNumberPairwise.Vector64.Single"] = MaxNumberPairwise_Vector64_Single,
                ["MaxNumberPairwise.Vector128.Double"] = MaxNumberPairwise_Vector128_Double,
                ["MaxNumberPairwise.Vector128.Single"] = MaxNumberPairwise_Vector128_Single,
                ["MaxNumberPairwiseScalar.Vector64.Single"] = MaxNumberPairwiseScalar_Vector64_Single,
                ["MaxNumberPairwiseScalar.Vector128.Double"] = MaxNumberPairwiseScalar_Vector128_Double,
                ["MaxPairwise.Vector128.Byte"] = MaxPairwise_Vector128_Byte,
                ["MaxPairwise.Vector128.Double"] = MaxPairwise_Vector128_Double,
                ["MaxPairwise.Vector128.Int16"] = MaxPairwise_Vector128_Int16,
                ["MaxPairwise.Vector128.Int32"] = MaxPairwise_Vector128_Int32,
                ["MaxPairwise.Vector128.SByte"] = MaxPairwise_Vector128_SByte,
                ["MaxPairwise.Vector128.Single"] = MaxPairwise_Vector128_Single,
                ["MaxPairwise.Vector128.UInt16"] = MaxPairwise_Vector128_UInt16,
                ["MaxPairwise.Vector128.UInt32"] = MaxPairwise_Vector128_UInt32,
                ["MaxPairwiseScalar.Vector64.Single"] = MaxPairwiseScalar_Vector64_Single,
                ["MaxPairwiseScalar.Vector128.Double"] = MaxPairwiseScalar_Vector128_Double,
                ["MaxScalar.Vector64.Double"] = MaxScalar_Vector64_Double,
                ["MaxScalar.Vector64.Single"] = MaxScalar_Vector64_Single,
                ["Min.Vector128.Double"] = Min_Vector128_Double,
                ["MinAcross.Vector64.Byte"] = MinAcross_Vector64_Byte,
                ["MinAcross.Vector64.Int16"] = MinAcross_Vector64_Int16,
                ["MinAcross.Vector64.SByte"] = MinAcross_Vector64_SByte,
                ["MinAcross.Vector64.UInt16"] = MinAcross_Vector64_UInt16,
                ["MinAcross.Vector128.Byte"] = MinAcross_Vector128_Byte,
                ["MinAcross.Vector128.Int16"] = MinAcross_Vector128_Int16,
                ["MinAcross.Vector128.Int32"] = MinAcross_Vector128_Int32,
                ["MinAcross.Vector128.SByte"] = MinAcross_Vector128_SByte,
                ["MinAcross.Vector128.Single"] = MinAcross_Vector128_Single,
                ["MinAcross.Vector128.UInt16"] = MinAcross_Vector128_UInt16,
                ["MinAcross.Vector128.UInt32"] = MinAcross_Vector128_UInt32,
                ["MinNumber.Vector128.Double"] = MinNumber_Vector128_Double,
                ["MinNumberAcross.Vector128.Single"] = MinNumberAcross_Vector128_Single,
                ["MinNumberPairwise.Vector64.Single"] = MinNumberPairwise_Vector64_Single,
                ["MinNumberPairwise.Vector128.Double"] = MinNumberPairwise_Vector128_Double,
                ["MinNumberPairwise.Vector128.Single"] = MinNumberPairwise_Vector128_Single,
                ["MinNumberPairwiseScalar.Vector64.Single"] = MinNumberPairwiseScalar_Vector64_Single,
                ["MinNumberPairwiseScalar.Vector128.Double"] = MinNumberPairwiseScalar_Vector128_Double,
                ["MinPairwise.Vector128.Byte"] = MinPairwise_Vector128_Byte,
                ["MinPairwise.Vector128.Double"] = MinPairwise_Vector128_Double,
                ["MinPairwise.Vector128.Int16"] = MinPairwise_Vector128_Int16,
                ["MinPairwise.Vector128.Int32"] = MinPairwise_Vector128_Int32,
                ["MinPairwise.Vector128.SByte"] = MinPairwise_Vector128_SByte,
                ["MinPairwise.Vector128.Single"] = MinPairwise_Vector128_Single,
                ["MinPairwise.Vector128.UInt16"] = MinPairwise_Vector128_UInt16,
                ["MinPairwise.Vector128.UInt32"] = MinPairwise_Vector128_UInt32,
                ["MinPairwiseScalar.Vector64.Single"] = MinPairwiseScalar_Vector64_Single,
                ["MinPairwiseScalar.Vector128.Double"] = MinPairwiseScalar_Vector128_Double,
                ["MinScalar.Vector64.Double"] = MinScalar_Vector64_Double,
                ["MinScalar.Vector64.Single"] = MinScalar_Vector64_Single,
            };
        }
    }
}
