// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["Not.Vector128.Int64"] = Not_Vector128_Int64,
                ["Not.Vector128.SByte"] = Not_Vector128_SByte,
                ["Not.Vector128.Single"] = Not_Vector128_Single,
                ["Not.Vector128.UInt16"] = Not_Vector128_UInt16,
                ["Not.Vector128.UInt32"] = Not_Vector128_UInt32,
                ["Not.Vector128.UInt64"] = Not_Vector128_UInt64,
                ["Or.Vector64.Byte"] = Or_Vector64_Byte,
                ["Or.Vector64.Double"] = Or_Vector64_Double,
                ["Or.Vector64.Int16"] = Or_Vector64_Int16,
                ["Or.Vector64.Int32"] = Or_Vector64_Int32,
                ["Or.Vector64.Int64"] = Or_Vector64_Int64,
                ["Or.Vector64.SByte"] = Or_Vector64_SByte,
                ["Or.Vector64.Single"] = Or_Vector64_Single,
                ["Or.Vector64.UInt16"] = Or_Vector64_UInt16,
                ["Or.Vector64.UInt32"] = Or_Vector64_UInt32,
                ["Or.Vector64.UInt64"] = Or_Vector64_UInt64,
                ["Or.Vector128.Byte"] = Or_Vector128_Byte,
                ["Or.Vector128.Double"] = Or_Vector128_Double,
                ["Or.Vector128.Int16"] = Or_Vector128_Int16,
                ["Or.Vector128.Int32"] = Or_Vector128_Int32,
                ["Or.Vector128.Int64"] = Or_Vector128_Int64,
                ["Or.Vector128.SByte"] = Or_Vector128_SByte,
                ["Or.Vector128.Single"] = Or_Vector128_Single,
                ["Or.Vector128.UInt16"] = Or_Vector128_UInt16,
                ["Or.Vector128.UInt32"] = Or_Vector128_UInt32,
                ["Or.Vector128.UInt64"] = Or_Vector128_UInt64,
                ["OrNot.Vector64.Byte"] = OrNot_Vector64_Byte,
                ["OrNot.Vector64.Double"] = OrNot_Vector64_Double,
                ["OrNot.Vector64.Int16"] = OrNot_Vector64_Int16,
                ["OrNot.Vector64.Int32"] = OrNot_Vector64_Int32,
                ["OrNot.Vector64.Int64"] = OrNot_Vector64_Int64,
                ["OrNot.Vector64.SByte"] = OrNot_Vector64_SByte,
                ["OrNot.Vector64.Single"] = OrNot_Vector64_Single,
                ["OrNot.Vector64.UInt16"] = OrNot_Vector64_UInt16,
                ["OrNot.Vector64.UInt32"] = OrNot_Vector64_UInt32,
                ["OrNot.Vector64.UInt64"] = OrNot_Vector64_UInt64,
                ["OrNot.Vector128.Byte"] = OrNot_Vector128_Byte,
                ["OrNot.Vector128.Double"] = OrNot_Vector128_Double,
                ["OrNot.Vector128.Int16"] = OrNot_Vector128_Int16,
                ["OrNot.Vector128.Int32"] = OrNot_Vector128_Int32,
                ["OrNot.Vector128.Int64"] = OrNot_Vector128_Int64,
                ["OrNot.Vector128.SByte"] = OrNot_Vector128_SByte,
                ["OrNot.Vector128.Single"] = OrNot_Vector128_Single,
                ["OrNot.Vector128.UInt16"] = OrNot_Vector128_UInt16,
                ["OrNot.Vector128.UInt32"] = OrNot_Vector128_UInt32,
                ["OrNot.Vector128.UInt64"] = OrNot_Vector128_UInt64,
                ["PolynomialMultiply.Vector64.Byte"] = PolynomialMultiply_Vector64_Byte,
                ["PolynomialMultiply.Vector64.SByte"] = PolynomialMultiply_Vector64_SByte,
                ["PolynomialMultiply.Vector128.Byte"] = PolynomialMultiply_Vector128_Byte,
                ["PolynomialMultiply.Vector128.SByte"] = PolynomialMultiply_Vector128_SByte,
                ["PolynomialMultiplyWideningLower.Vector64.Byte"] = PolynomialMultiplyWideningLower_Vector64_Byte,
                ["PolynomialMultiplyWideningLower.Vector64.SByte"] = PolynomialMultiplyWideningLower_Vector64_SByte,
                ["PolynomialMultiplyWideningUpper.Vector128.Byte"] = PolynomialMultiplyWideningUpper_Vector128_Byte,
                ["PolynomialMultiplyWideningUpper.Vector128.SByte"] = PolynomialMultiplyWideningUpper_Vector128_SByte,
                ["PopCount.Vector64.Byte"] = PopCount_Vector64_Byte,
                ["PopCount.Vector64.SByte"] = PopCount_Vector64_SByte,
                ["PopCount.Vector128.Byte"] = PopCount_Vector128_Byte,
                ["PopCount.Vector128.SByte"] = PopCount_Vector128_SByte,
                ["ReciprocalEstimate.Vector64.Single"] = ReciprocalEstimate_Vector64_Single,
                ["ReciprocalEstimate.Vector64.UInt32"] = ReciprocalEstimate_Vector64_UInt32,
                ["ReciprocalEstimate.Vector128.Single"] = ReciprocalEstimate_Vector128_Single,
                ["ReciprocalEstimate.Vector128.UInt32"] = ReciprocalEstimate_Vector128_UInt32,
                ["ReciprocalSquareRootEstimate.Vector64.Single"] = ReciprocalSquareRootEstimate_Vector64_Single,
                ["ReciprocalSquareRootEstimate.Vector64.UInt32"] = ReciprocalSquareRootEstimate_Vector64_UInt32,
                ["ReciprocalSquareRootEstimate.Vector128.Single"] = ReciprocalSquareRootEstimate_Vector128_Single,
                ["ReciprocalSquareRootEstimate.Vector128.UInt32"] = ReciprocalSquareRootEstimate_Vector128_UInt32,
                ["ReciprocalSquareRootStep.Vector64.Single"] = ReciprocalSquareRootStep_Vector64_Single,
                ["ReciprocalSquareRootStep.Vector128.Single"] = ReciprocalSquareRootStep_Vector128_Single,
                ["ReciprocalStep.Vector64.Single"] = ReciprocalStep_Vector64_Single,
                ["ReciprocalStep.Vector128.Single"] = ReciprocalStep_Vector128_Single,
                ["ReverseElement16.Vector64.Int32"] = ReverseElement16_Vector64_Int32,
                ["ReverseElement16.Vector64.Int64"] = ReverseElement16_Vector64_Int64,
                ["ReverseElement16.Vector64.UInt32"] = ReverseElement16_Vector64_UInt32,
                ["ReverseElement16.Vector64.UInt64"] = ReverseElement16_Vector64_UInt64,
                ["ReverseElement16.Vector128.Int32"] = ReverseElement16_Vector128_Int32,
                ["ReverseElement16.Vector128.Int64"] = ReverseElement16_Vector128_Int64,
                ["ReverseElement16.Vector128.UInt32"] = ReverseElement16_Vector128_UInt32,
                ["ReverseElement16.Vector128.UInt64"] = ReverseElement16_Vector128_UInt64,
                ["ReverseElement32.Vector64.Int64"] = ReverseElement32_Vector64_Int64,
                ["ReverseElement32.Vector64.UInt64"] = ReverseElement32_Vector64_UInt64,
                ["ReverseElement32.Vector128.Int64"] = ReverseElement32_Vector128_Int64,
                ["ReverseElement32.Vector128.UInt64"] = ReverseElement32_Vector128_UInt64,
                ["ReverseElement8.Vector64.Int16"] = ReverseElement8_Vector64_Int16,
                ["ReverseElement8.Vector64.Int32"] = ReverseElement8_Vector64_Int32,
                ["ReverseElement8.Vector64.Int64"] = ReverseElement8_Vector64_Int64,
                ["ReverseElement8.Vector64.UInt16"] = ReverseElement8_Vector64_UInt16,
                ["ReverseElement8.Vector64.UInt32"] = ReverseElement8_Vector64_UInt32,
                ["ReverseElement8.Vector64.UInt64"] = ReverseElement8_Vector64_UInt64,
                ["ReverseElement8.Vector128.Int16"] = ReverseElement8_Vector128_Int16,
                ["ReverseElement8.Vector128.Int32"] = ReverseElement8_Vector128_Int32,
                ["ReverseElement8.Vector128.Int64"] = ReverseElement8_Vector128_Int64,
                ["ReverseElement8.Vector128.UInt16"] = ReverseElement8_Vector128_UInt16,
                ["ReverseElement8.Vector128.UInt32"] = ReverseElement8_Vector128_UInt32,
                ["ReverseElement8.Vector128.UInt64"] = ReverseElement8_Vector128_UInt64,
                ["RoundAwayFromZero.Vector64.Single"] = RoundAwayFromZero_Vector64_Single,
                ["RoundAwayFromZero.Vector128.Single"] = RoundAwayFromZero_Vector128_Single,
                ["RoundAwayFromZeroScalar.Vector64.Double"] = RoundAwayFromZeroScalar_Vector64_Double,
                ["RoundAwayFromZeroScalar.Vector64.Single"] = RoundAwayFromZeroScalar_Vector64_Single,
                ["RoundToNearest.Vector64.Single"] = RoundToNearest_Vector64_Single,
                ["RoundToNearest.Vector128.Single"] = RoundToNearest_Vector128_Single,
            };
        }
    }
}
