// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["And.Vector128.Double"] = And_Vector128_Double,
                ["And.Vector128.Int16"] = And_Vector128_Int16,
                ["And.Vector128.Int32"] = And_Vector128_Int32,
                ["And.Vector128.Int64"] = And_Vector128_Int64,
                ["And.Vector128.SByte"] = And_Vector128_SByte,
                ["And.Vector128.Single"] = And_Vector128_Single,
                ["And.Vector128.UInt16"] = And_Vector128_UInt16,
                ["And.Vector128.UInt32"] = And_Vector128_UInt32,
                ["And.Vector128.UInt64"] = And_Vector128_UInt64,
                ["BitwiseClear.Vector64.Byte"] = BitwiseClear_Vector64_Byte,
                ["BitwiseClear.Vector64.Double"] = BitwiseClear_Vector64_Double,
                ["BitwiseClear.Vector64.Int16"] = BitwiseClear_Vector64_Int16,
                ["BitwiseClear.Vector64.Int32"] = BitwiseClear_Vector64_Int32,
                ["BitwiseClear.Vector64.Int64"] = BitwiseClear_Vector64_Int64,
                ["BitwiseClear.Vector64.SByte"] = BitwiseClear_Vector64_SByte,
                ["BitwiseClear.Vector64.Single"] = BitwiseClear_Vector64_Single,
                ["BitwiseClear.Vector64.UInt16"] = BitwiseClear_Vector64_UInt16,
                ["BitwiseClear.Vector64.UInt32"] = BitwiseClear_Vector64_UInt32,
                ["BitwiseClear.Vector64.UInt64"] = BitwiseClear_Vector64_UInt64,
                ["BitwiseClear.Vector128.Byte"] = BitwiseClear_Vector128_Byte,
                ["BitwiseClear.Vector128.Double"] = BitwiseClear_Vector128_Double,
                ["BitwiseClear.Vector128.Int16"] = BitwiseClear_Vector128_Int16,
                ["BitwiseClear.Vector128.Int32"] = BitwiseClear_Vector128_Int32,
                ["BitwiseClear.Vector128.Int64"] = BitwiseClear_Vector128_Int64,
                ["BitwiseClear.Vector128.SByte"] = BitwiseClear_Vector128_SByte,
                ["BitwiseClear.Vector128.Single"] = BitwiseClear_Vector128_Single,
                ["BitwiseClear.Vector128.UInt16"] = BitwiseClear_Vector128_UInt16,
                ["BitwiseClear.Vector128.UInt32"] = BitwiseClear_Vector128_UInt32,
                ["BitwiseClear.Vector128.UInt64"] = BitwiseClear_Vector128_UInt64,
                ["BitwiseSelect.Vector64.Byte"] = BitwiseSelect_Vector64_Byte,
                ["BitwiseSelect.Vector64.Double"] = BitwiseSelect_Vector64_Double,
                ["BitwiseSelect.Vector64.Int16"] = BitwiseSelect_Vector64_Int16,
                ["BitwiseSelect.Vector64.Int32"] = BitwiseSelect_Vector64_Int32,
                ["BitwiseSelect.Vector64.Int64"] = BitwiseSelect_Vector64_Int64,
                ["BitwiseSelect.Vector64.SByte"] = BitwiseSelect_Vector64_SByte,
                ["BitwiseSelect.Vector64.Single"] = BitwiseSelect_Vector64_Single,
                ["BitwiseSelect.Vector64.UInt16"] = BitwiseSelect_Vector64_UInt16,
                ["BitwiseSelect.Vector64.UInt32"] = BitwiseSelect_Vector64_UInt32,
                ["BitwiseSelect.Vector64.UInt64"] = BitwiseSelect_Vector64_UInt64,
                ["BitwiseSelect.Vector128.Byte"] = BitwiseSelect_Vector128_Byte,
                ["BitwiseSelect.Vector128.Double"] = BitwiseSelect_Vector128_Double,
                ["BitwiseSelect.Vector128.Int16"] = BitwiseSelect_Vector128_Int16,
                ["BitwiseSelect.Vector128.Int32"] = BitwiseSelect_Vector128_Int32,
                ["BitwiseSelect.Vector128.Int64"] = BitwiseSelect_Vector128_Int64,
                ["BitwiseSelect.Vector128.SByte"] = BitwiseSelect_Vector128_SByte,
                ["BitwiseSelect.Vector128.Single"] = BitwiseSelect_Vector128_Single,
                ["BitwiseSelect.Vector128.UInt16"] = BitwiseSelect_Vector128_UInt16,
                ["BitwiseSelect.Vector128.UInt32"] = BitwiseSelect_Vector128_UInt32,
                ["BitwiseSelect.Vector128.UInt64"] = BitwiseSelect_Vector128_UInt64,
                ["Ceiling.Vector64.Single"] = Ceiling_Vector64_Single,
                ["Ceiling.Vector128.Single"] = Ceiling_Vector128_Single,
                ["CeilingScalar.Vector64.Double"] = CeilingScalar_Vector64_Double,
                ["CeilingScalar.Vector64.Single"] = CeilingScalar_Vector64_Single,
                ["CompareEqual.Vector64.Byte"] = CompareEqual_Vector64_Byte,
                ["CompareEqual.Vector64.Int16"] = CompareEqual_Vector64_Int16,
                ["CompareEqual.Vector64.Int32"] = CompareEqual_Vector64_Int32,
                ["CompareEqual.Vector64.SByte"] = CompareEqual_Vector64_SByte,
                ["CompareEqual.Vector64.Single"] = CompareEqual_Vector64_Single,
                ["CompareEqual.Vector64.UInt16"] = CompareEqual_Vector64_UInt16,
                ["CompareEqual.Vector64.UInt32"] = CompareEqual_Vector64_UInt32,
                ["CompareEqual.Vector128.Byte"] = CompareEqual_Vector128_Byte,
                ["CompareEqual.Vector128.Int16"] = CompareEqual_Vector128_Int16,
                ["CompareEqual.Vector128.Int32"] = CompareEqual_Vector128_Int32,
                ["CompareEqual.Vector128.SByte"] = CompareEqual_Vector128_SByte,
                ["CompareEqual.Vector128.Single"] = CompareEqual_Vector128_Single,
                ["CompareEqual.Vector128.UInt16"] = CompareEqual_Vector128_UInt16,
                ["CompareEqual.Vector128.UInt32"] = CompareEqual_Vector128_UInt32,
                ["CompareGreaterThan.Vector64.Byte"] = CompareGreaterThan_Vector64_Byte,
                ["CompareGreaterThan.Vector64.Int16"] = CompareGreaterThan_Vector64_Int16,
                ["CompareGreaterThan.Vector64.Int32"] = CompareGreaterThan_Vector64_Int32,
                ["CompareGreaterThan.Vector64.SByte"] = CompareGreaterThan_Vector64_SByte,
                ["CompareGreaterThan.Vector64.Single"] = CompareGreaterThan_Vector64_Single,
                ["CompareGreaterThan.Vector64.UInt16"] = CompareGreaterThan_Vector64_UInt16,
                ["CompareGreaterThan.Vector64.UInt32"] = CompareGreaterThan_Vector64_UInt32,
                ["CompareGreaterThan.Vector128.Byte"] = CompareGreaterThan_Vector128_Byte,
                ["CompareGreaterThan.Vector128.Int16"] = CompareGreaterThan_Vector128_Int16,
                ["CompareGreaterThan.Vector128.Int32"] = CompareGreaterThan_Vector128_Int32,
                ["CompareGreaterThan.Vector128.SByte"] = CompareGreaterThan_Vector128_SByte,
                ["CompareGreaterThan.Vector128.Single"] = CompareGreaterThan_Vector128_Single,
                ["CompareGreaterThan.Vector128.UInt16"] = CompareGreaterThan_Vector128_UInt16,
                ["CompareGreaterThan.Vector128.UInt32"] = CompareGreaterThan_Vector128_UInt32,
                ["CompareGreaterThanOrEqual.Vector64.Byte"] = CompareGreaterThanOrEqual_Vector64_Byte,
                ["CompareGreaterThanOrEqual.Vector64.Int16"] = CompareGreaterThanOrEqual_Vector64_Int16,
                ["CompareGreaterThanOrEqual.Vector64.Int32"] = CompareGreaterThanOrEqual_Vector64_Int32,
                ["CompareGreaterThanOrEqual.Vector64.SByte"] = CompareGreaterThanOrEqual_Vector64_SByte,
                ["CompareGreaterThanOrEqual.Vector64.Single"] = CompareGreaterThanOrEqual_Vector64_Single,
                ["CompareGreaterThanOrEqual.Vector64.UInt16"] = CompareGreaterThanOrEqual_Vector64_UInt16,
                ["CompareGreaterThanOrEqual.Vector64.UInt32"] = CompareGreaterThanOrEqual_Vector64_UInt32,
                ["CompareGreaterThanOrEqual.Vector128.Byte"] = CompareGreaterThanOrEqual_Vector128_Byte,
                ["CompareGreaterThanOrEqual.Vector128.Int16"] = CompareGreaterThanOrEqual_Vector128_Int16,
                ["CompareGreaterThanOrEqual.Vector128.Int32"] = CompareGreaterThanOrEqual_Vector128_Int32,
                ["CompareGreaterThanOrEqual.Vector128.SByte"] = CompareGreaterThanOrEqual_Vector128_SByte,
                ["CompareGreaterThanOrEqual.Vector128.Single"] = CompareGreaterThanOrEqual_Vector128_Single,
                ["CompareGreaterThanOrEqual.Vector128.UInt16"] = CompareGreaterThanOrEqual_Vector128_UInt16,
                ["CompareGreaterThanOrEqual.Vector128.UInt32"] = CompareGreaterThanOrEqual_Vector128_UInt32,
                ["CompareLessThan.Vector64.Byte"] = CompareLessThan_Vector64_Byte,
                ["CompareLessThan.Vector64.Int16"] = CompareLessThan_Vector64_Int16,
                ["CompareLessThan.Vector64.Int32"] = CompareLessThan_Vector64_Int32,
                ["CompareLessThan.Vector64.SByte"] = CompareLessThan_Vector64_SByte,
                ["CompareLessThan.Vector64.Single"] = CompareLessThan_Vector64_Single,
            };
        }
    }
}
