// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["DuplicateSelectedScalarToVector128.Vector128.Single.2"] = DuplicateSelectedScalarToVector128_Vector128_Single_2,
                ["DuplicateSelectedScalarToVector128.Vector128.UInt16.4"] = DuplicateSelectedScalarToVector128_Vector128_UInt16_4,
                ["DuplicateSelectedScalarToVector128.Vector128.UInt32.2"] = DuplicateSelectedScalarToVector128_Vector128_UInt32_2,
                ["DuplicateToVector64.Byte"] = DuplicateToVector64_Byte,
                ["DuplicateToVector64.Byte.31"] = DuplicateToVector64_Byte_31,
                ["DuplicateToVector64.Int16"] = DuplicateToVector64_Int16,
                ["DuplicateToVector64.Int16.31"] = DuplicateToVector64_Int16_31,
                ["DuplicateToVector64.Int32"] = DuplicateToVector64_Int32,
                ["DuplicateToVector64.Int32.31"] = DuplicateToVector64_Int32_31,
                ["DuplicateToVector64.SByte"] = DuplicateToVector64_SByte,
                ["DuplicateToVector64.SByte.31"] = DuplicateToVector64_SByte_31,
                ["DuplicateToVector64.Single"] = DuplicateToVector64_Single,
                ["DuplicateToVector64.Single.31"] = DuplicateToVector64_Single_31,
                ["DuplicateToVector64.UInt16"] = DuplicateToVector64_UInt16,
                ["DuplicateToVector64.UInt16.31"] = DuplicateToVector64_UInt16_31,
                ["DuplicateToVector64.UInt32"] = DuplicateToVector64_UInt32,
                ["DuplicateToVector64.UInt32.31"] = DuplicateToVector64_UInt32_31,
                ["DuplicateToVector128.Byte"] = DuplicateToVector128_Byte,
                ["DuplicateToVector128.Byte.31"] = DuplicateToVector128_Byte_31,
                ["DuplicateToVector128.Int16"] = DuplicateToVector128_Int16,
                ["DuplicateToVector128.Int16.31"] = DuplicateToVector128_Int16_31,
                ["DuplicateToVector128.Int32"] = DuplicateToVector128_Int32,
                ["DuplicateToVector128.Int32.31"] = DuplicateToVector128_Int32_31,
                ["DuplicateToVector128.SByte"] = DuplicateToVector128_SByte,
                ["DuplicateToVector128.SByte.31"] = DuplicateToVector128_SByte_31,
                ["DuplicateToVector128.Single"] = DuplicateToVector128_Single,
                ["DuplicateToVector128.Single.31"] = DuplicateToVector128_Single_31,
                ["DuplicateToVector128.UInt16"] = DuplicateToVector128_UInt16,
                ["DuplicateToVector128.UInt16.31"] = DuplicateToVector128_UInt16_31,
                ["DuplicateToVector128.UInt32"] = DuplicateToVector128_UInt32,
                ["DuplicateToVector128.UInt32.31"] = DuplicateToVector128_UInt32_31,
                ["Extract.Vector64.Byte.1"] = Extract_Vector64_Byte_1,
                ["Extract.Vector64.Int16.1"] = Extract_Vector64_Int16_1,
                ["Extract.Vector64.Int32.1"] = Extract_Vector64_Int32_1,
                ["Extract.Vector64.SByte.1"] = Extract_Vector64_SByte_1,
                ["Extract.Vector64.Single.1"] = Extract_Vector64_Single_1,
                ["Extract.Vector64.UInt16.1"] = Extract_Vector64_UInt16_1,
                ["Extract.Vector64.UInt32.1"] = Extract_Vector64_UInt32_1,
                ["Extract.Vector128.Byte.1"] = Extract_Vector128_Byte_1,
                ["Extract.Vector128.Double.1"] = Extract_Vector128_Double_1,
                ["Extract.Vector128.Int16.1"] = Extract_Vector128_Int16_1,
                ["Extract.Vector128.Int32.1"] = Extract_Vector128_Int32_1,
                ["Extract.Vector128.Int64.1"] = Extract_Vector128_Int64_1,
                ["Extract.Vector128.SByte.1"] = Extract_Vector128_SByte_1,
                ["Extract.Vector128.Single.1"] = Extract_Vector128_Single_1,
                ["Extract.Vector128.UInt16.1"] = Extract_Vector128_UInt16_1,
                ["Extract.Vector128.UInt32.1"] = Extract_Vector128_UInt32_1,
                ["Extract.Vector128.UInt64.1"] = Extract_Vector128_UInt64_1,
                ["ExtractNarrowingLower.Vector64.Byte"] = ExtractNarrowingLower_Vector64_Byte,
                ["ExtractNarrowingLower.Vector64.Int16"] = ExtractNarrowingLower_Vector64_Int16,
                ["ExtractNarrowingLower.Vector64.Int32"] = ExtractNarrowingLower_Vector64_Int32,
                ["ExtractNarrowingLower.Vector64.SByte"] = ExtractNarrowingLower_Vector64_SByte,
                ["ExtractNarrowingLower.Vector64.UInt16"] = ExtractNarrowingLower_Vector64_UInt16,
                ["ExtractNarrowingLower.Vector64.UInt32"] = ExtractNarrowingLower_Vector64_UInt32,
                ["ExtractNarrowingSaturateLower.Vector64.Byte"] = ExtractNarrowingSaturateLower_Vector64_Byte,
                ["ExtractNarrowingSaturateLower.Vector64.Int16"] = ExtractNarrowingSaturateLower_Vector64_Int16,
                ["ExtractNarrowingSaturateLower.Vector64.Int32"] = ExtractNarrowingSaturateLower_Vector64_Int32,
                ["ExtractNarrowingSaturateLower.Vector64.SByte"] = ExtractNarrowingSaturateLower_Vector64_SByte,
                ["ExtractNarrowingSaturateLower.Vector64.UInt16"] = ExtractNarrowingSaturateLower_Vector64_UInt16,
                ["ExtractNarrowingSaturateLower.Vector64.UInt32"] = ExtractNarrowingSaturateLower_Vector64_UInt32,
                ["ExtractNarrowingSaturateUnsignedLower.Vector64.Byte"] = ExtractNarrowingSaturateUnsignedLower_Vector64_Byte,
                ["ExtractNarrowingSaturateUnsignedLower.Vector64.UInt16"] = ExtractNarrowingSaturateUnsignedLower_Vector64_UInt16,
                ["ExtractNarrowingSaturateUnsignedLower.Vector64.UInt32"] = ExtractNarrowingSaturateUnsignedLower_Vector64_UInt32,
                ["ExtractNarrowingSaturateUnsignedUpper.Vector128.Byte"] = ExtractNarrowingSaturateUnsignedUpper_Vector128_Byte,
                ["ExtractNarrowingSaturateUnsignedUpper.Vector128.UInt16"] = ExtractNarrowingSaturateUnsignedUpper_Vector128_UInt16,
                ["ExtractNarrowingSaturateUnsignedUpper.Vector128.UInt32"] = ExtractNarrowingSaturateUnsignedUpper_Vector128_UInt32,
                ["ExtractNarrowingSaturateUpper.Vector128.Byte"] = ExtractNarrowingSaturateUpper_Vector128_Byte,
                ["ExtractNarrowingSaturateUpper.Vector128.Int16"] = ExtractNarrowingSaturateUpper_Vector128_Int16,
                ["ExtractNarrowingSaturateUpper.Vector128.Int32"] = ExtractNarrowingSaturateUpper_Vector128_Int32,
                ["ExtractNarrowingSaturateUpper.Vector128.SByte"] = ExtractNarrowingSaturateUpper_Vector128_SByte,
                ["ExtractNarrowingSaturateUpper.Vector128.UInt16"] = ExtractNarrowingSaturateUpper_Vector128_UInt16,
                ["ExtractNarrowingSaturateUpper.Vector128.UInt32"] = ExtractNarrowingSaturateUpper_Vector128_UInt32,
                ["ExtractNarrowingUpper.Vector128.Byte"] = ExtractNarrowingUpper_Vector128_Byte,
                ["ExtractNarrowingUpper.Vector128.Int16"] = ExtractNarrowingUpper_Vector128_Int16,
                ["ExtractNarrowingUpper.Vector128.Int32"] = ExtractNarrowingUpper_Vector128_Int32,
                ["ExtractNarrowingUpper.Vector128.SByte"] = ExtractNarrowingUpper_Vector128_SByte,
                ["ExtractNarrowingUpper.Vector128.UInt16"] = ExtractNarrowingUpper_Vector128_UInt16,
                ["ExtractNarrowingUpper.Vector128.UInt32"] = ExtractNarrowingUpper_Vector128_UInt32,
                ["ExtractVector64.Byte.1"] = ExtractVector64_Byte_1,
                ["ExtractVector64.Int16.1"] = ExtractVector64_Int16_1,
                ["ExtractVector64.Int32.1"] = ExtractVector64_Int32_1,
                ["ExtractVector64.SByte.1"] = ExtractVector64_SByte_1,
                ["ExtractVector64.Single.1"] = ExtractVector64_Single_1,
                ["ExtractVector64.UInt16.1"] = ExtractVector64_UInt16_1,
                ["ExtractVector64.UInt32.1"] = ExtractVector64_UInt32_1,
                ["ExtractVector128.Byte.1"] = ExtractVector128_Byte_1,
                ["ExtractVector128.Double.1"] = ExtractVector128_Double_1,
                ["ExtractVector128.Int16.1"] = ExtractVector128_Int16_1,
                ["ExtractVector128.Int32.1"] = ExtractVector128_Int32_1,
                ["ExtractVector128.Int64.1"] = ExtractVector128_Int64_1,
                ["ExtractVector128.SByte.1"] = ExtractVector128_SByte_1,
                ["ExtractVector128.Single.1"] = ExtractVector128_Single_1,
                ["ExtractVector128.UInt16.1"] = ExtractVector128_UInt16_1,
                ["ExtractVector128.UInt32.1"] = ExtractVector128_UInt32_1,
                ["ExtractVector128.UInt64.1"] = ExtractVector128_UInt64_1,
                ["Floor.Vector64.Single"] = Floor_Vector64_Single,
                ["Floor.Vector128.Single"] = Floor_Vector128_Single,
                ["FloorScalar.Vector64.Double"] = FloorScalar_Vector64_Double,
                ["FloorScalar.Vector64.Single"] = FloorScalar_Vector64_Single,
                ["FusedAddHalving.Vector64.Byte"] = FusedAddHalving_Vector64_Byte,
            };
        }
    }
}
