// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.General
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["Vector64BooleanZero"] = Vector64BooleanZero,
                ["Vector64BooleanAllBitsSet"] = Vector64BooleanAllBitsSet,
                ["Vector64BooleanAsGeneric_Boolean"] = Vector64BooleanAsGeneric_Boolean,
                ["Vector64ByteAsGeneric_Boolean"] = Vector64ByteAsGeneric_Boolean,
                ["Vector64DoubleAsGeneric_Boolean"] = Vector64DoubleAsGeneric_Boolean,
                ["Vector64Int16AsGeneric_Boolean"] = Vector64Int16AsGeneric_Boolean,
                ["Vector64Int32AsGeneric_Boolean"] = Vector64Int32AsGeneric_Boolean,
                ["Vector64Int64AsGeneric_Boolean"] = Vector64Int64AsGeneric_Boolean,
                ["Vector64SByteAsGeneric_Boolean"] = Vector64SByteAsGeneric_Boolean,
                ["Vector64SingleAsGeneric_Boolean"] = Vector64SingleAsGeneric_Boolean,
                ["Vector64UInt16AsGeneric_Boolean"] = Vector64UInt16AsGeneric_Boolean,
                ["Vector64UInt32AsGeneric_Boolean"] = Vector64UInt32AsGeneric_Boolean,
                ["Vector64UInt64AsGeneric_Boolean"] = Vector64UInt64AsGeneric_Boolean,
                ["Vector64BooleanAsGeneric_Byte"] = Vector64BooleanAsGeneric_Byte,
                ["Vector64BooleanAsGeneric_Double"] = Vector64BooleanAsGeneric_Double,
                ["Vector64BooleanAsGeneric_Int16"] = Vector64BooleanAsGeneric_Int16,
                ["Vector64BooleanAsGeneric_Int32"] = Vector64BooleanAsGeneric_Int32,
                ["Vector64BooleanAsGeneric_Int64"] = Vector64BooleanAsGeneric_Int64,
                ["Vector64BooleanAsGeneric_SByte"] = Vector64BooleanAsGeneric_SByte,
                ["Vector64BooleanAsGeneric_Single"] = Vector64BooleanAsGeneric_Single,
                ["Vector64BooleanAsGeneric_UInt16"] = Vector64BooleanAsGeneric_UInt16,
                ["Vector64BooleanAsGeneric_UInt32"] = Vector64BooleanAsGeneric_UInt32,
                ["Vector64BooleanAsGeneric_UInt64"] = Vector64BooleanAsGeneric_UInt64,
                ["Vector64BooleanAsByte"] = Vector64BooleanAsByte,
                ["Vector64BooleanAsDouble"] = Vector64BooleanAsDouble,
                ["Vector64BooleanAsInt16"] = Vector64BooleanAsInt16,
                ["Vector64BooleanAsInt32"] = Vector64BooleanAsInt32,
                ["Vector64BooleanAsInt64"] = Vector64BooleanAsInt64,
                ["Vector64BooleanAsSByte"] = Vector64BooleanAsSByte,
                ["Vector64BooleanAsSingle"] = Vector64BooleanAsSingle,
                ["Vector64BooleanAsUInt16"] = Vector64BooleanAsUInt16,
                ["Vector64BooleanAsUInt32"] = Vector64BooleanAsUInt32,
                ["Vector64BooleanAsUInt64"] = Vector64BooleanAsUInt64,
                ["Vector64BooleanGetElementNegativeOne"] = Vector64BooleanGetElementNegativeOne,
                ["Vector64BooleanGetElement0"] = Vector64BooleanGetElement0,
                ["Vector64BooleanGetElementMaxValue"] = Vector64BooleanGetElementMaxValue,
                ["Vector64BooleanWithElementNegativeOne"] = Vector64BooleanWithElementNegativeOne,
                ["Vector64BooleanWithElement0"] = Vector64BooleanWithElement0,
                ["Vector64BooleanWithElementMaxValue"] = Vector64BooleanWithElementMaxValue,
                ["Vector64BooleanToScalar"] = Vector64BooleanToScalar,
                ["Vector64BooleanToVector128"] = Vector64BooleanToVector128,
                ["Vector64BooleanToVector128Unsafe"] = Vector64BooleanToVector128Unsafe,
                ["Vector64BooleanToString"] = Vector64BooleanToString,
                ["Vector64NIntZero"] = Vector64NIntZero,
                ["Vector64NIntAllBitsSet"] = Vector64NIntAllBitsSet,
                ["Vector64NIntAsGeneric_NInt"] = Vector64NIntAsGeneric_NInt,
                ["Vector64ByteAsGeneric_NInt"] = Vector64ByteAsGeneric_NInt,
                ["Vector64DoubleAsGeneric_NInt"] = Vector64DoubleAsGeneric_NInt,
                ["Vector64Int16AsGeneric_NInt"] = Vector64Int16AsGeneric_NInt,
                ["Vector64Int32AsGeneric_NInt"] = Vector64Int32AsGeneric_NInt,
                ["Vector64Int64AsGeneric_NInt"] = Vector64Int64AsGeneric_NInt,
                ["Vector64SByteAsGeneric_NInt"] = Vector64SByteAsGeneric_NInt,
                ["Vector64SingleAsGeneric_NInt"] = Vector64SingleAsGeneric_NInt,
                ["Vector64UInt16AsGeneric_NInt"] = Vector64UInt16AsGeneric_NInt,
                ["Vector64UInt32AsGeneric_NInt"] = Vector64UInt32AsGeneric_NInt,
                ["Vector64UInt64AsGeneric_NInt"] = Vector64UInt64AsGeneric_NInt,
                ["Vector64NIntAsGeneric_Byte"] = Vector64NIntAsGeneric_Byte,
                ["Vector64NIntAsGeneric_Double"] = Vector64NIntAsGeneric_Double,
                ["Vector64NIntAsGeneric_Int16"] = Vector64NIntAsGeneric_Int16,
                ["Vector64NIntAsGeneric_Int32"] = Vector64NIntAsGeneric_Int32,
                ["Vector64NIntAsGeneric_Int64"] = Vector64NIntAsGeneric_Int64,
                ["Vector64NIntAsGeneric_SByte"] = Vector64NIntAsGeneric_SByte,
                ["Vector64NIntAsGeneric_Single"] = Vector64NIntAsGeneric_Single,
                ["Vector64NIntAsGeneric_UInt16"] = Vector64NIntAsGeneric_UInt16,
                ["Vector64NIntAsGeneric_UInt32"] = Vector64NIntAsGeneric_UInt32,
                ["Vector64NIntAsGeneric_UInt64"] = Vector64NIntAsGeneric_UInt64,
                ["Vector64NIntAsByte"] = Vector64NIntAsByte,
                ["Vector64NIntAsDouble"] = Vector64NIntAsDouble,
                ["Vector64NIntAsInt16"] = Vector64NIntAsInt16,
                ["Vector64NIntAsInt32"] = Vector64NIntAsInt32,
                ["Vector64NIntAsInt64"] = Vector64NIntAsInt64,
                ["Vector64NIntAsSByte"] = Vector64NIntAsSByte,
                ["Vector64NIntAsSingle"] = Vector64NIntAsSingle,
                ["Vector64NIntAsUInt16"] = Vector64NIntAsUInt16,
                ["Vector64NIntAsUInt32"] = Vector64NIntAsUInt32,
                ["Vector64NIntAsUInt64"] = Vector64NIntAsUInt64,
                ["Vector64NIntGetElementNegativeOne"] = Vector64NIntGetElementNegativeOne,
                ["Vector64NIntGetElement0"] = Vector64NIntGetElement0,
                ["Vector64NIntGetElementMaxValue"] = Vector64NIntGetElementMaxValue,
                ["Vector64NIntWithElementNegativeOne"] = Vector64NIntWithElementNegativeOne,
                ["Vector64NIntWithElement0"] = Vector64NIntWithElement0,
                ["Vector64NIntWithElementMaxValue"] = Vector64NIntWithElementMaxValue,
                ["Vector64NIntToScalar"] = Vector64NIntToScalar,
                ["Vector64NIntToVector128"] = Vector64NIntToVector128,
                ["Vector64NIntToVector128Unsafe"] = Vector64NIntToVector128Unsafe,
                ["Vector64NIntToString"] = Vector64NIntToString,
                ["Vector64NUIntZero"] = Vector64NUIntZero,
                ["Vector64NUIntAllBitsSet"] = Vector64NUIntAllBitsSet,
                ["Vector64NUIntAsGeneric_NUInt"] = Vector64NUIntAsGeneric_NUInt,
                ["Vector64ByteAsGeneric_NUInt"] = Vector64ByteAsGeneric_NUInt,
                ["Vector64DoubleAsGeneric_NUInt"] = Vector64DoubleAsGeneric_NUInt,
                ["Vector64Int16AsGeneric_NUInt"] = Vector64Int16AsGeneric_NUInt,
                ["Vector64Int32AsGeneric_NUInt"] = Vector64Int32AsGeneric_NUInt,
                ["Vector64Int64AsGeneric_NUInt"] = Vector64Int64AsGeneric_NUInt,
                ["Vector64SByteAsGeneric_NUInt"] = Vector64SByteAsGeneric_NUInt,
                ["Vector64SingleAsGeneric_NUInt"] = Vector64SingleAsGeneric_NUInt,
                ["Vector64UInt16AsGeneric_NUInt"] = Vector64UInt16AsGeneric_NUInt,
                ["Vector64UInt32AsGeneric_NUInt"] = Vector64UInt32AsGeneric_NUInt,
                ["Vector64UInt64AsGeneric_NUInt"] = Vector64UInt64AsGeneric_NUInt,
                ["Vector64NUIntAsGeneric_Byte"] = Vector64NUIntAsGeneric_Byte,
                ["Vector64NUIntAsGeneric_Double"] = Vector64NUIntAsGeneric_Double,
                ["Vector64NUIntAsGeneric_Int16"] = Vector64NUIntAsGeneric_Int16,
                ["Vector64NUIntAsGeneric_Int32"] = Vector64NUIntAsGeneric_Int32,
                ["Vector64NUIntAsGeneric_Int64"] = Vector64NUIntAsGeneric_Int64,
                ["Vector64NUIntAsGeneric_SByte"] = Vector64NUIntAsGeneric_SByte,
                ["Vector64NUIntAsGeneric_Single"] = Vector64NUIntAsGeneric_Single,
                ["Vector64NUIntAsGeneric_UInt16"] = Vector64NUIntAsGeneric_UInt16,
                ["Vector64NUIntAsGeneric_UInt32"] = Vector64NUIntAsGeneric_UInt32,
                ["Vector64NUIntAsGeneric_UInt64"] = Vector64NUIntAsGeneric_UInt64,
                ["Vector64NUIntAsByte"] = Vector64NUIntAsByte,
                ["Vector64NUIntAsDouble"] = Vector64NUIntAsDouble,
                ["Vector64NUIntAsInt16"] = Vector64NUIntAsInt16,
                ["Vector64NUIntAsInt32"] = Vector64NUIntAsInt32,
                ["Vector64NUIntAsInt64"] = Vector64NUIntAsInt64,
                ["Vector64NUIntAsSByte"] = Vector64NUIntAsSByte,
                ["Vector64NUIntAsSingle"] = Vector64NUIntAsSingle,
                ["Vector64NUIntAsUInt16"] = Vector64NUIntAsUInt16,
                ["Vector64NUIntAsUInt32"] = Vector64NUIntAsUInt32,
                ["Vector64NUIntAsUInt64"] = Vector64NUIntAsUInt64,
                ["Vector64NUIntGetElementNegativeOne"] = Vector64NUIntGetElementNegativeOne,
                ["Vector64NUIntGetElement0"] = Vector64NUIntGetElement0,
                ["Vector64NUIntGetElementMaxValue"] = Vector64NUIntGetElementMaxValue,
                ["Vector64NUIntWithElementNegativeOne"] = Vector64NUIntWithElementNegativeOne,
                ["Vector64NUIntWithElement0"] = Vector64NUIntWithElement0,
                ["Vector64NUIntWithElementMaxValue"] = Vector64NUIntWithElementMaxValue,
                ["Vector64NUIntToScalar"] = Vector64NUIntToScalar,
                ["Vector64NUIntToVector128"] = Vector64NUIntToVector128,
                ["Vector64NUIntToVector128Unsafe"] = Vector64NUIntToVector128Unsafe,
                ["Vector64NUIntToString"] = Vector64NUIntToString,
                ["Vector128BooleanZero"] = Vector128BooleanZero,
                ["Vector128BooleanAllBitsSet"] = Vector128BooleanAllBitsSet,
                ["Vector128BooleanAsGeneric_Boolean"] = Vector128BooleanAsGeneric_Boolean,
                ["Vector128ByteAsGeneric_Boolean"] = Vector128ByteAsGeneric_Boolean,
                ["Vector128DoubleAsGeneric_Boolean"] = Vector128DoubleAsGeneric_Boolean,
                ["Vector128Int16AsGeneric_Boolean"] = Vector128Int16AsGeneric_Boolean,
                ["Vector128Int32AsGeneric_Boolean"] = Vector128Int32AsGeneric_Boolean,
                ["Vector128Int64AsGeneric_Boolean"] = Vector128Int64AsGeneric_Boolean,
                ["Vector128SByteAsGeneric_Boolean"] = Vector128SByteAsGeneric_Boolean,
                ["Vector128SingleAsGeneric_Boolean"] = Vector128SingleAsGeneric_Boolean,
                ["Vector128UInt16AsGeneric_Boolean"] = Vector128UInt16AsGeneric_Boolean,
                ["Vector128UInt32AsGeneric_Boolean"] = Vector128UInt32AsGeneric_Boolean,
                ["Vector128UInt64AsGeneric_Boolean"] = Vector128UInt64AsGeneric_Boolean,
                ["Vector128BooleanAsGeneric_Byte"] = Vector128BooleanAsGeneric_Byte,
                ["Vector128BooleanAsGeneric_Double"] = Vector128BooleanAsGeneric_Double,
                ["Vector128BooleanAsGeneric_Int16"] = Vector128BooleanAsGeneric_Int16,
                ["Vector128BooleanAsGeneric_Int32"] = Vector128BooleanAsGeneric_Int32,
                ["Vector128BooleanAsGeneric_Int64"] = Vector128BooleanAsGeneric_Int64,
                ["Vector128BooleanAsGeneric_SByte"] = Vector128BooleanAsGeneric_SByte,
                ["Vector128BooleanAsGeneric_Single"] = Vector128BooleanAsGeneric_Single,
                ["Vector128BooleanAsGeneric_UInt16"] = Vector128BooleanAsGeneric_UInt16,
                ["Vector128BooleanAsGeneric_UInt32"] = Vector128BooleanAsGeneric_UInt32,
                ["Vector128BooleanAsGeneric_UInt64"] = Vector128BooleanAsGeneric_UInt64,
                ["Vector128BooleanAsByte"] = Vector128BooleanAsByte,
                ["Vector128BooleanAsDouble"] = Vector128BooleanAsDouble,
                ["Vector128BooleanAsInt16"] = Vector128BooleanAsInt16,
                ["Vector128BooleanAsInt32"] = Vector128BooleanAsInt32,
                ["Vector128BooleanAsInt64"] = Vector128BooleanAsInt64,
                ["Vector128BooleanAsSByte"] = Vector128BooleanAsSByte,
                ["Vector128BooleanAsSingle"] = Vector128BooleanAsSingle,
                ["Vector128BooleanAsUInt16"] = Vector128BooleanAsUInt16,
                ["Vector128BooleanAsUInt32"] = Vector128BooleanAsUInt32,
                ["Vector128BooleanAsUInt64"] = Vector128BooleanAsUInt64,
                ["Vector128BooleanGetElementNegativeOne"] = Vector128BooleanGetElementNegativeOne,
                ["Vector128BooleanGetElement0"] = Vector128BooleanGetElement0,
                ["Vector128BooleanGetElementMaxValue"] = Vector128BooleanGetElementMaxValue,
                ["Vector128BooleanWithElementNegativeOne"] = Vector128BooleanWithElementNegativeOne,
                ["Vector128BooleanWithElement0"] = Vector128BooleanWithElement0,
                ["Vector128BooleanWithElementMaxValue"] = Vector128BooleanWithElementMaxValue,
                ["Vector128BooleanGetLower"] = Vector128BooleanGetLower,
                ["Vector128BooleanWithLower"] = Vector128BooleanWithLower,
                ["Vector128BooleanGetUpper"] = Vector128BooleanGetUpper,
                ["Vector128BooleanWithUpper"] = Vector128BooleanWithUpper,
                ["Vector128BooleanToScalar"] = Vector128BooleanToScalar,
                ["Vector128BooleanToVector256"] = Vector128BooleanToVector256,
                ["Vector128BooleanToVector256Unsafe"] = Vector128BooleanToVector256Unsafe,
                ["Vector128BooleanToString"] = Vector128BooleanToString,
                ["Vector128NIntZero"] = Vector128NIntZero,
                ["Vector128NIntAllBitsSet"] = Vector128NIntAllBitsSet,
                ["Vector128NIntAsGeneric_NInt"] = Vector128NIntAsGeneric_NInt,
                ["Vector128ByteAsGeneric_NInt"] = Vector128ByteAsGeneric_NInt,
                ["Vector128DoubleAsGeneric_NInt"] = Vector128DoubleAsGeneric_NInt,
                ["Vector128Int16AsGeneric_NInt"] = Vector128Int16AsGeneric_NInt,
                ["Vector128Int32AsGeneric_NInt"] = Vector128Int32AsGeneric_NInt,
                ["Vector128Int64AsGeneric_NInt"] = Vector128Int64AsGeneric_NInt,
                ["Vector128SByteAsGeneric_NInt"] = Vector128SByteAsGeneric_NInt,
                ["Vector128SingleAsGeneric_NInt"] = Vector128SingleAsGeneric_NInt,
                ["Vector128UInt16AsGeneric_NInt"] = Vector128UInt16AsGeneric_NInt,
                ["Vector128UInt32AsGeneric_NInt"] = Vector128UInt32AsGeneric_NInt,
                ["Vector128UInt64AsGeneric_NInt"] = Vector128UInt64AsGeneric_NInt,
                ["Vector128NIntAsGeneric_Byte"] = Vector128NIntAsGeneric_Byte,
                ["Vector128NIntAsGeneric_Double"] = Vector128NIntAsGeneric_Double,
                ["Vector128NIntAsGeneric_Int16"] = Vector128NIntAsGeneric_Int16,
                ["Vector128NIntAsGeneric_Int32"] = Vector128NIntAsGeneric_Int32,
                ["Vector128NIntAsGeneric_Int64"] = Vector128NIntAsGeneric_Int64,
                ["Vector128NIntAsGeneric_SByte"] = Vector128NIntAsGeneric_SByte,
                ["Vector128NIntAsGeneric_Single"] = Vector128NIntAsGeneric_Single,
                ["Vector128NIntAsGeneric_UInt16"] = Vector128NIntAsGeneric_UInt16,
                ["Vector128NIntAsGeneric_UInt32"] = Vector128NIntAsGeneric_UInt32,
                ["Vector128NIntAsGeneric_UInt64"] = Vector128NIntAsGeneric_UInt64,
                ["Vector128NIntAsByte"] = Vector128NIntAsByte,
                ["Vector128NIntAsDouble"] = Vector128NIntAsDouble,
                ["Vector128NIntAsInt16"] = Vector128NIntAsInt16,
                ["Vector128NIntAsInt32"] = Vector128NIntAsInt32,
                ["Vector128NIntAsInt64"] = Vector128NIntAsInt64,
                ["Vector128NIntAsSByte"] = Vector128NIntAsSByte,
                ["Vector128NIntAsSingle"] = Vector128NIntAsSingle,
                ["Vector128NIntAsUInt16"] = Vector128NIntAsUInt16,
                ["Vector128NIntAsUInt32"] = Vector128NIntAsUInt32,
                ["Vector128NIntAsUInt64"] = Vector128NIntAsUInt64,
                ["Vector128NIntGetElementNegativeOne"] = Vector128NIntGetElementNegativeOne,
                ["Vector128NIntGetElement0"] = Vector128NIntGetElement0,
                ["Vector128NIntGetElementMaxValue"] = Vector128NIntGetElementMaxValue,
                ["Vector128NIntWithElementNegativeOne"] = Vector128NIntWithElementNegativeOne,
                ["Vector128NIntWithElement0"] = Vector128NIntWithElement0,
                ["Vector128NIntWithElementMaxValue"] = Vector128NIntWithElementMaxValue,
                ["Vector128NIntGetLower"] = Vector128NIntGetLower,
                ["Vector128NIntWithLower"] = Vector128NIntWithLower,
                ["Vector128NIntGetUpper"] = Vector128NIntGetUpper,
                ["Vector128NIntWithUpper"] = Vector128NIntWithUpper,
                ["Vector128NIntToScalar"] = Vector128NIntToScalar,
                ["Vector128NIntToVector256"] = Vector128NIntToVector256,
                ["Vector128NIntToVector256Unsafe"] = Vector128NIntToVector256Unsafe,
                ["Vector128NIntToString"] = Vector128NIntToString,
                ["Vector128NUIntZero"] = Vector128NUIntZero,
                ["Vector128NUIntAllBitsSet"] = Vector128NUIntAllBitsSet,
                ["Vector128NUIntAsGeneric_NUInt"] = Vector128NUIntAsGeneric_NUInt,
                ["Vector128ByteAsGeneric_NUInt"] = Vector128ByteAsGeneric_NUInt,
                ["Vector128DoubleAsGeneric_NUInt"] = Vector128DoubleAsGeneric_NUInt,
                ["Vector128Int16AsGeneric_NUInt"] = Vector128Int16AsGeneric_NUInt,
                ["Vector128Int32AsGeneric_NUInt"] = Vector128Int32AsGeneric_NUInt,
                ["Vector128Int64AsGeneric_NUInt"] = Vector128Int64AsGeneric_NUInt,
                ["Vector128SByteAsGeneric_NUInt"] = Vector128SByteAsGeneric_NUInt,
                ["Vector128SingleAsGeneric_NUInt"] = Vector128SingleAsGeneric_NUInt,
                ["Vector128UInt16AsGeneric_NUInt"] = Vector128UInt16AsGeneric_NUInt,
                ["Vector128UInt32AsGeneric_NUInt"] = Vector128UInt32AsGeneric_NUInt,
                ["Vector128UInt64AsGeneric_NUInt"] = Vector128UInt64AsGeneric_NUInt,
                ["Vector128NUIntAsGeneric_Byte"] = Vector128NUIntAsGeneric_Byte,
                ["Vector128NUIntAsGeneric_Double"] = Vector128NUIntAsGeneric_Double,
                ["Vector128NUIntAsGeneric_Int16"] = Vector128NUIntAsGeneric_Int16,
                ["Vector128NUIntAsGeneric_Int32"] = Vector128NUIntAsGeneric_Int32,
                ["Vector128NUIntAsGeneric_Int64"] = Vector128NUIntAsGeneric_Int64,
                ["Vector128NUIntAsGeneric_SByte"] = Vector128NUIntAsGeneric_SByte,
                ["Vector128NUIntAsGeneric_Single"] = Vector128NUIntAsGeneric_Single,
                ["Vector128NUIntAsGeneric_UInt16"] = Vector128NUIntAsGeneric_UInt16,
                ["Vector128NUIntAsGeneric_UInt32"] = Vector128NUIntAsGeneric_UInt32,
                ["Vector128NUIntAsGeneric_UInt64"] = Vector128NUIntAsGeneric_UInt64,
                ["Vector128NUIntAsByte"] = Vector128NUIntAsByte,
                ["Vector128NUIntAsDouble"] = Vector128NUIntAsDouble,
                ["Vector128NUIntAsInt16"] = Vector128NUIntAsInt16,
                ["Vector128NUIntAsInt32"] = Vector128NUIntAsInt32,
                ["Vector128NUIntAsInt64"] = Vector128NUIntAsInt64,
                ["Vector128NUIntAsSByte"] = Vector128NUIntAsSByte,
                ["Vector128NUIntAsSingle"] = Vector128NUIntAsSingle,
                ["Vector128NUIntAsUInt16"] = Vector128NUIntAsUInt16,
                ["Vector128NUIntAsUInt32"] = Vector128NUIntAsUInt32,
                ["Vector128NUIntAsUInt64"] = Vector128NUIntAsUInt64,
                ["Vector128NUIntGetElementNegativeOne"] = Vector128NUIntGetElementNegativeOne,
                ["Vector128NUIntGetElement0"] = Vector128NUIntGetElement0,
                ["Vector128NUIntGetElementMaxValue"] = Vector128NUIntGetElementMaxValue,
                ["Vector128NUIntWithElementNegativeOne"] = Vector128NUIntWithElementNegativeOne,
                ["Vector128NUIntWithElement0"] = Vector128NUIntWithElement0,
                ["Vector128NUIntWithElementMaxValue"] = Vector128NUIntWithElementMaxValue,
                ["Vector128NUIntGetLower"] = Vector128NUIntGetLower,
                ["Vector128NUIntWithLower"] = Vector128NUIntWithLower,
                ["Vector128NUIntGetUpper"] = Vector128NUIntGetUpper,
                ["Vector128NUIntWithUpper"] = Vector128NUIntWithUpper,
                ["Vector128NUIntToScalar"] = Vector128NUIntToScalar,
                ["Vector128NUIntToVector256"] = Vector128NUIntToVector256,
                ["Vector128NUIntToVector256Unsafe"] = Vector128NUIntToVector256Unsafe,
                ["Vector128NUIntToString"] = Vector128NUIntToString,
                ["Vector256BooleanZero"] = Vector256BooleanZero,
                ["Vector256BooleanAllBitsSet"] = Vector256BooleanAllBitsSet,
                ["Vector256BooleanAsGeneric_Boolean"] = Vector256BooleanAsGeneric_Boolean,
                ["Vector256ByteAsGeneric_Boolean"] = Vector256ByteAsGeneric_Boolean,
                ["Vector256DoubleAsGeneric_Boolean"] = Vector256DoubleAsGeneric_Boolean,
                ["Vector256Int16AsGeneric_Boolean"] = Vector256Int16AsGeneric_Boolean,
                ["Vector256Int32AsGeneric_Boolean"] = Vector256Int32AsGeneric_Boolean,
                ["Vector256Int64AsGeneric_Boolean"] = Vector256Int64AsGeneric_Boolean,
                ["Vector256SByteAsGeneric_Boolean"] = Vector256SByteAsGeneric_Boolean,
                ["Vector256SingleAsGeneric_Boolean"] = Vector256SingleAsGeneric_Boolean,
                ["Vector256UInt16AsGeneric_Boolean"] = Vector256UInt16AsGeneric_Boolean,
                ["Vector256UInt32AsGeneric_Boolean"] = Vector256UInt32AsGeneric_Boolean,
                ["Vector256UInt64AsGeneric_Boolean"] = Vector256UInt64AsGeneric_Boolean,
                ["Vector256BooleanAsGeneric_Byte"] = Vector256BooleanAsGeneric_Byte,
                ["Vector256BooleanAsGeneric_Double"] = Vector256BooleanAsGeneric_Double,
                ["Vector256BooleanAsGeneric_Int16"] = Vector256BooleanAsGeneric_Int16,
                ["Vector256BooleanAsGeneric_Int32"] = Vector256BooleanAsGeneric_Int32,
                ["Vector256BooleanAsGeneric_Int64"] = Vector256BooleanAsGeneric_Int64,
                ["Vector256BooleanAsGeneric_SByte"] = Vector256BooleanAsGeneric_SByte,
                ["Vector256BooleanAsGeneric_Single"] = Vector256BooleanAsGeneric_Single,
                ["Vector256BooleanAsGeneric_UInt16"] = Vector256BooleanAsGeneric_UInt16,
                ["Vector256BooleanAsGeneric_UInt32"] = Vector256BooleanAsGeneric_UInt32,
                ["Vector256BooleanAsGeneric_UInt64"] = Vector256BooleanAsGeneric_UInt64,
                ["Vector256BooleanAsByte"] = Vector256BooleanAsByte,
                ["Vector256BooleanAsDouble"] = Vector256BooleanAsDouble,
                ["Vector256BooleanAsInt16"] = Vector256BooleanAsInt16,
                ["Vector256BooleanAsInt32"] = Vector256BooleanAsInt32,
                ["Vector256BooleanAsInt64"] = Vector256BooleanAsInt64,
                ["Vector256BooleanAsSByte"] = Vector256BooleanAsSByte,
                ["Vector256BooleanAsSingle"] = Vector256BooleanAsSingle,
                ["Vector256BooleanAsUInt16"] = Vector256BooleanAsUInt16,
                ["Vector256BooleanAsUInt32"] = Vector256BooleanAsUInt32,
                ["Vector256BooleanAsUInt64"] = Vector256BooleanAsUInt64,
                ["Vector256BooleanGetElementNegativeOne"] = Vector256BooleanGetElementNegativeOne,
                ["Vector256BooleanGetElement0"] = Vector256BooleanGetElement0,
                ["Vector256BooleanGetElementMaxValue"] = Vector256BooleanGetElementMaxValue,
                ["Vector256BooleanWithElementNegativeOne"] = Vector256BooleanWithElementNegativeOne,
                ["Vector256BooleanWithElement0"] = Vector256BooleanWithElement0,
                ["Vector256BooleanWithElementMaxValue"] = Vector256BooleanWithElementMaxValue,
                ["Vector256BooleanGetLower"] = Vector256BooleanGetLower,
                ["Vector256BooleanWithLower"] = Vector256BooleanWithLower,
                ["Vector256BooleanGetUpper"] = Vector256BooleanGetUpper,
                ["Vector256BooleanWithUpper"] = Vector256BooleanWithUpper,
                ["Vector256BooleanToScalar"] = Vector256BooleanToScalar,
                ["Vector256BooleanToString"] = Vector256BooleanToString,
                ["Vector256NIntZero"] = Vector256NIntZero,
                ["Vector256NIntAllBitsSet"] = Vector256NIntAllBitsSet,
                ["Vector256NIntAsGeneric_NInt"] = Vector256NIntAsGeneric_NInt,
                ["Vector256ByteAsGeneric_NInt"] = Vector256ByteAsGeneric_NInt,
                ["Vector256DoubleAsGeneric_NInt"] = Vector256DoubleAsGeneric_NInt,
                ["Vector256Int16AsGeneric_NInt"] = Vector256Int16AsGeneric_NInt,
                ["Vector256Int32AsGeneric_NInt"] = Vector256Int32AsGeneric_NInt,
                ["Vector256Int64AsGeneric_NInt"] = Vector256Int64AsGeneric_NInt,
                ["Vector256SByteAsGeneric_NInt"] = Vector256SByteAsGeneric_NInt,
                ["Vector256SingleAsGeneric_NInt"] = Vector256SingleAsGeneric_NInt,
                ["Vector256UInt16AsGeneric_NInt"] = Vector256UInt16AsGeneric_NInt,
                ["Vector256UInt32AsGeneric_NInt"] = Vector256UInt32AsGeneric_NInt,
                ["Vector256UInt64AsGeneric_NInt"] = Vector256UInt64AsGeneric_NInt,
                ["Vector256NIntAsGeneric_Byte"] = Vector256NIntAsGeneric_Byte,
                ["Vector256NIntAsGeneric_Double"] = Vector256NIntAsGeneric_Double,
                ["Vector256NIntAsGeneric_Int16"] = Vector256NIntAsGeneric_Int16,
                ["Vector256NIntAsGeneric_Int32"] = Vector256NIntAsGeneric_Int32,
                ["Vector256NIntAsGeneric_Int64"] = Vector256NIntAsGeneric_Int64,
                ["Vector256NIntAsGeneric_SByte"] = Vector256NIntAsGeneric_SByte,
                ["Vector256NIntAsGeneric_Single"] = Vector256NIntAsGeneric_Single,
                ["Vector256NIntAsGeneric_UInt16"] = Vector256NIntAsGeneric_UInt16,
                ["Vector256NIntAsGeneric_UInt32"] = Vector256NIntAsGeneric_UInt32,
                ["Vector256NIntAsGeneric_UInt64"] = Vector256NIntAsGeneric_UInt64,
                ["Vector256NIntAsByte"] = Vector256NIntAsByte,
                ["Vector256NIntAsDouble"] = Vector256NIntAsDouble,
                ["Vector256NIntAsInt16"] = Vector256NIntAsInt16,
                ["Vector256NIntAsInt32"] = Vector256NIntAsInt32,
                ["Vector256NIntAsInt64"] = Vector256NIntAsInt64,
                ["Vector256NIntAsSByte"] = Vector256NIntAsSByte,
                ["Vector256NIntAsSingle"] = Vector256NIntAsSingle,
                ["Vector256NIntAsUInt16"] = Vector256NIntAsUInt16,
                ["Vector256NIntAsUInt32"] = Vector256NIntAsUInt32,
                ["Vector256NIntAsUInt64"] = Vector256NIntAsUInt64,
                ["Vector256NIntGetElementNegativeOne"] = Vector256NIntGetElementNegativeOne,
                ["Vector256NIntGetElement0"] = Vector256NIntGetElement0,
                ["Vector256NIntGetElementMaxValue"] = Vector256NIntGetElementMaxValue,
                ["Vector256NIntWithElementNegativeOne"] = Vector256NIntWithElementNegativeOne,
                ["Vector256NIntWithElement0"] = Vector256NIntWithElement0,
                ["Vector256NIntWithElementMaxValue"] = Vector256NIntWithElementMaxValue,
                ["Vector256NIntGetLower"] = Vector256NIntGetLower,
                ["Vector256NIntWithLower"] = Vector256NIntWithLower,
                ["Vector256NIntGetUpper"] = Vector256NIntGetUpper,
                ["Vector256NIntWithUpper"] = Vector256NIntWithUpper,
                ["Vector256NIntToScalar"] = Vector256NIntToScalar,
                ["Vector256NIntToString"] = Vector256NIntToString,
                ["Vector256NUIntZero"] = Vector256NUIntZero,
                ["Vector256NUIntAllBitsSet"] = Vector256NUIntAllBitsSet,
                ["Vector256NUIntAsGeneric_NUInt"] = Vector256NUIntAsGeneric_NUInt,
                ["Vector256ByteAsGeneric_NUInt"] = Vector256ByteAsGeneric_NUInt,
                ["Vector256DoubleAsGeneric_NUInt"] = Vector256DoubleAsGeneric_NUInt,
                ["Vector256Int16AsGeneric_NUInt"] = Vector256Int16AsGeneric_NUInt,
                ["Vector256Int32AsGeneric_NUInt"] = Vector256Int32AsGeneric_NUInt,
                ["Vector256Int64AsGeneric_NUInt"] = Vector256Int64AsGeneric_NUInt,
                ["Vector256SByteAsGeneric_NUInt"] = Vector256SByteAsGeneric_NUInt,
                ["Vector256SingleAsGeneric_NUInt"] = Vector256SingleAsGeneric_NUInt,
                ["Vector256UInt16AsGeneric_NUInt"] = Vector256UInt16AsGeneric_NUInt,
                ["Vector256UInt32AsGeneric_NUInt"] = Vector256UInt32AsGeneric_NUInt,
                ["Vector256UInt64AsGeneric_NUInt"] = Vector256UInt64AsGeneric_NUInt,
                ["Vector256NUIntAsGeneric_Byte"] = Vector256NUIntAsGeneric_Byte,
                ["Vector256NUIntAsGeneric_Double"] = Vector256NUIntAsGeneric_Double,
                ["Vector256NUIntAsGeneric_Int16"] = Vector256NUIntAsGeneric_Int16,
                ["Vector256NUIntAsGeneric_Int32"] = Vector256NUIntAsGeneric_Int32,
                ["Vector256NUIntAsGeneric_Int64"] = Vector256NUIntAsGeneric_Int64,
                ["Vector256NUIntAsGeneric_SByte"] = Vector256NUIntAsGeneric_SByte,
                ["Vector256NUIntAsGeneric_Single"] = Vector256NUIntAsGeneric_Single,
                ["Vector256NUIntAsGeneric_UInt16"] = Vector256NUIntAsGeneric_UInt16,
                ["Vector256NUIntAsGeneric_UInt32"] = Vector256NUIntAsGeneric_UInt32,
                ["Vector256NUIntAsGeneric_UInt64"] = Vector256NUIntAsGeneric_UInt64,
                ["Vector256NUIntAsByte"] = Vector256NUIntAsByte,
                ["Vector256NUIntAsDouble"] = Vector256NUIntAsDouble,
                ["Vector256NUIntAsInt16"] = Vector256NUIntAsInt16,
                ["Vector256NUIntAsInt32"] = Vector256NUIntAsInt32,
                ["Vector256NUIntAsInt64"] = Vector256NUIntAsInt64,
                ["Vector256NUIntAsSByte"] = Vector256NUIntAsSByte,
                ["Vector256NUIntAsSingle"] = Vector256NUIntAsSingle,
                ["Vector256NUIntAsUInt16"] = Vector256NUIntAsUInt16,
                ["Vector256NUIntAsUInt32"] = Vector256NUIntAsUInt32,
                ["Vector256NUIntAsUInt64"] = Vector256NUIntAsUInt64,
                ["Vector256NUIntGetElementNegativeOne"] = Vector256NUIntGetElementNegativeOne,
                ["Vector256NUIntGetElement0"] = Vector256NUIntGetElement0,
                ["Vector256NUIntGetElementMaxValue"] = Vector256NUIntGetElementMaxValue,
                ["Vector256NUIntWithElementNegativeOne"] = Vector256NUIntWithElementNegativeOne,
                ["Vector256NUIntWithElement0"] = Vector256NUIntWithElement0,
                ["Vector256NUIntWithElementMaxValue"] = Vector256NUIntWithElementMaxValue,
                ["Vector256NUIntGetLower"] = Vector256NUIntGetLower,
                ["Vector256NUIntWithLower"] = Vector256NUIntWithLower,
                ["Vector256NUIntGetUpper"] = Vector256NUIntGetUpper,
                ["Vector256NUIntWithUpper"] = Vector256NUIntWithUpper,
                ["Vector256NUIntToScalar"] = Vector256NUIntToScalar,
                ["Vector256NUIntToString"] = Vector256NUIntToString,
            };
        }
    }
}
