// SPDX-License-Identifier: GPL-2.0
#ifndef __SKE_H
#define __SKE_H

#include <stdint.h>

struct skcipher_ctx {
	uint32_t flags; /* SYNC/ASYNC flags temporary */
	uint32_t reqsize;

	struct skcipher_alg *alg;
	void *__ctx[];
};

struct skcipher_req;
typedef void (*skcipher_completion_t)(struct skcipher_req *req, int err);

struct skcipher_req {
	unsigned int cryptlen;
	unsigned char *iv;

	unsigned char *src;
	unsigned char *dst;

	skcipher_completion_t complete;
	void *data;

	struct skcipher_ctx *ctx;
	void *__req[];
};

struct skcipher_alg {
	const char *name;
	int (*setkey)(struct skcipher_ctx *ctx, const uint8_t *key,
		      uint32_t keylen);
	int (*encrypt)(struct skcipher_req *req);
	int (*decrypt)(struct skcipher_req *req);
	int (*init)(struct skcipher_ctx *ctx);
	void (*exit)(struct skcipher_ctx *ctx);
	uint32_t blocksize;
	uint32_t ivsize;
	uint32_t ctxsize;
	uint32_t min_keysize;
	uint32_t max_keysize;
};

struct skcipher_alg_entry {
	struct skcipher_alg *alg;
	struct skcipher_alg_entry *next;
};

static inline void crypto_inc(uint8_t *a, uint32_t size)
{
	uint8_t *b = (a + size);
	uint8_t c;

	for (; size; size--) {
		c = *--b + 1;
		*b = c;
		if (c)
			break;
	}
}

static inline int verify_skcipher_des_key(struct skcipher_ctx *ctx, const uint8_t *key)
{
	return 0;
}
static inline int verify_skcipher_des3_key(struct skcipher_ctx *ctx, const uint8_t *key)
{
	return 0;
}
static inline int xts_verify_key(struct skcipher_ctx *ctx, const uint8_t *key, uint32_t keylen)
{
	return 0;
}

struct skcipher_ctx *skcipher_alloc_ctx(const char *alg_name, uint32_t flag);
void skcipher_free_ctx(struct skcipher_ctx *ctx);
struct skcipher_req *skcipher_alloc_req(struct skcipher_ctx *ctx);
void skcipher_free_req(struct skcipher_req *req);
int skcipher_setkey(struct skcipher_ctx *ctx, const unsigned char *key, unsigned int keylen);
void skcipher_req_set_callback(struct skcipher_req *req,
			       skcipher_completion_t complete, void *data);
void skcipher_set_req(struct skcipher_req *req, unsigned char *src, unsigned char *dst,
		      unsigned int cryptlen, unsigned char *iv);
int skcipher_encrypt(struct skcipher_req *req);
int skcipher_decrypt(struct skcipher_req *req);
void skcipher_register_algs(void);
void skcipher_unregister_algs(void);

#endif
