// Code generated by interstellar. DO NOT EDIT.
// Compatible with leonis RTL tag 0710

#ifndef NBL_IPRO_H
#define NBL_IPRO_H 1

#include <linux/types.h>

#define NBL_IPRO_BASE (0x00B04000)

#define NBL_IPRO_INT_STATUS_ADDR  (0xb04000)
#define NBL_IPRO_INT_STATUS_DEPTH (1)
#define NBL_IPRO_INT_STATUS_WIDTH (32)
#define NBL_IPRO_INT_STATUS_DWLEN (1)
union ipro_int_status_u {
	struct ipro_int_status {
		u32 fatal_err:1;         /* [0] Default:0x0 RWC */
		u32 fifo_uflw_err:1;     /* [1] Default:0x0 RWC */
		u32 fifo_dflw_err:1;     /* [2] Default:0x0 RWC */
		u32 cif_err:1;           /* [3] Default:0x0 RWC */
		u32 input_err:1;         /* [4] Default:0x0 RWC */
		u32 cfg_err:1;           /* [5] Default:0x0 RWC */
		u32 data_ucor_err:1;     /* [6] Default:0x0 RWC */
		u32 rsv:25;              /* [31:7] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_INT_STATUS_DWLEN];
} __packed;

#define NBL_IPRO_INT_MASK_ADDR  (0xb04004)
#define NBL_IPRO_INT_MASK_DEPTH (1)
#define NBL_IPRO_INT_MASK_WIDTH (32)
#define NBL_IPRO_INT_MASK_DWLEN (1)
union ipro_int_mask_u {
	struct ipro_int_mask {
		u32 fatal_err:1;         /* [0] Default:0x0 RW */
		u32 fifo_uflw_err:1;     /* [1] Default:0x0 RW */
		u32 fifo_dflw_err:1;     /* [2] Default:0x0 RW */
		u32 cif_err:1;           /* [3] Default:0x0 RW */
		u32 input_err:1;         /* [4] Default:0x0 RW */
		u32 cfg_err:1;           /* [5] Default:0x0 RW */
		u32 data_ucor_err:1;     /* [6] Default:0x0 RW */
		u32 rsv:25;              /* [31:7] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_INT_MASK_DWLEN];
} __packed;

#define NBL_IPRO_INT_SET_ADDR  (0xb04008)
#define NBL_IPRO_INT_SET_DEPTH (1)
#define NBL_IPRO_INT_SET_WIDTH (32)
#define NBL_IPRO_INT_SET_DWLEN (1)
union ipro_int_set_u {
	struct ipro_int_set {
		u32 fatal_err:1;         /* [0] Default:0x0 WO */
		u32 fifo_uflw_err:1;     /* [1] Default:0x0 WO */
		u32 fifo_dflw_err:1;     /* [2] Default:0x0 WO */
		u32 cif_err:1;           /* [3] Default:0x0 WO */
		u32 input_err:1;         /* [4] Default:0x0 WO */
		u32 cfg_err:1;           /* [5] Default:0x0 WO */
		u32 data_ucor_err:1;     /* [6] Default:0x0 WO */
		u32 rsv:25;              /* [31:7] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_INT_SET_DWLEN];
} __packed;

#define NBL_IPRO_INIT_DONE_ADDR  (0xb0400c)
#define NBL_IPRO_INIT_DONE_DEPTH (1)
#define NBL_IPRO_INIT_DONE_WIDTH (32)
#define NBL_IPRO_INIT_DONE_DWLEN (1)
union ipro_init_done_u {
	struct ipro_init_done {
		u32 done:1;              /* [0] Default:0x0 RO */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_INIT_DONE_DWLEN];
} __packed;

#define NBL_IPRO_CIF_ERR_INFO_ADDR  (0xb04040)
#define NBL_IPRO_CIF_ERR_INFO_DEPTH (1)
#define NBL_IPRO_CIF_ERR_INFO_WIDTH (32)
#define NBL_IPRO_CIF_ERR_INFO_DWLEN (1)
union ipro_cif_err_info_u {
	struct ipro_cif_err_info {
		u32 addr:30;             /* [29:0] Default:0x0 RO */
		u32 wr_err:1;            /* [30] Default:0x0 RO */
		u32 ucor_err:1;          /* [31] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_CIF_ERR_INFO_DWLEN];
} __packed;

#define NBL_IPRO_INPUT_ERR_INFO_ADDR  (0xb04048)
#define NBL_IPRO_INPUT_ERR_INFO_DEPTH (1)
#define NBL_IPRO_INPUT_ERR_INFO_WIDTH (32)
#define NBL_IPRO_INPUT_ERR_INFO_DWLEN (1)
union ipro_input_err_info_u {
	struct ipro_input_err_info {
		u32 id:2;                /* [1:0] Default:0x0 RO */
		u32 rsv:30;              /* [31:2] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_INPUT_ERR_INFO_DWLEN];
} __packed;

#define NBL_IPRO_CFG_ERR_INFO_ADDR  (0xb04050)
#define NBL_IPRO_CFG_ERR_INFO_DEPTH (1)
#define NBL_IPRO_CFG_ERR_INFO_WIDTH (32)
#define NBL_IPRO_CFG_ERR_INFO_DWLEN (1)
union ipro_cfg_err_info_u {
	struct ipro_cfg_err_info {
		u32 id:2;                /* [1:0] Default:0x0 RO */
		u32 rsv:30;              /* [31:2] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_CFG_ERR_INFO_DWLEN];
} __packed;

#define NBL_IPRO_CAR_CTRL_ADDR  (0xb04100)
#define NBL_IPRO_CAR_CTRL_DEPTH (1)
#define NBL_IPRO_CAR_CTRL_WIDTH (32)
#define NBL_IPRO_CAR_CTRL_DWLEN (1)
union ipro_car_ctrl_u {
	struct ipro_car_ctrl {
		u32 sctr_car:1;          /* [0] Default:0x1 RW */
		u32 rctr_car:1;          /* [1] Default:0x1 RW */
		u32 rc_car:1;            /* [2] Default:0x1 RW */
		u32 tbl_rc_car:1;        /* [3] Default:0x1 RW */
		u32 rsv:28;              /* [31:4] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_CAR_CTRL_DWLEN];
} __packed;

#define NBL_IPRO_INIT_START_ADDR  (0xb04180)
#define NBL_IPRO_INIT_START_DEPTH (1)
#define NBL_IPRO_INIT_START_WIDTH (32)
#define NBL_IPRO_INIT_START_DWLEN (1)
union ipro_init_start_u {
	struct ipro_init_start {
		u32 init_start:1;        /* [0] Default:0x0 WO */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_INIT_START_DWLEN];
} __packed;

#define NBL_IPRO_CREDIT_TOKEN_ADDR  (0xb041c0)
#define NBL_IPRO_CREDIT_TOKEN_DEPTH (1)
#define NBL_IPRO_CREDIT_TOKEN_WIDTH (32)
#define NBL_IPRO_CREDIT_TOKEN_DWLEN (1)
union ipro_credit_token_u {
	struct ipro_credit_token {
		u32 up_token_num:8;      /* [7:0] Default:0x80 RW */
		u32 down_token_num:8;    /* [15:8] Default:0x80 RW */
		u32 up_init_vld:1;       /* [16] Default:0x0 WO */
		u32 down_init_vld:1;     /* [17] Default:0x0 WO */
		u32 rsv:14;              /* [31:18] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_CREDIT_TOKEN_DWLEN];
} __packed;

#define NBL_IPRO_AM_SET_FLAG_ADDR  (0xb041e0)
#define NBL_IPRO_AM_SET_FLAG_DEPTH (1)
#define NBL_IPRO_AM_SET_FLAG_WIDTH (32)
#define NBL_IPRO_AM_SET_FLAG_DWLEN (1)
union ipro_am_set_flag_u {
	struct ipro_am_set_flag {
		u32 set_flag:32;         /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_AM_SET_FLAG_DWLEN];
} __packed;

#define NBL_IPRO_AM_CLEAR_FLAG_ADDR  (0xb041e4)
#define NBL_IPRO_AM_CLEAR_FLAG_DEPTH (1)
#define NBL_IPRO_AM_CLEAR_FLAG_WIDTH (32)
#define NBL_IPRO_AM_CLEAR_FLAG_DWLEN (1)
union ipro_am_clear_flag_u {
	struct ipro_am_clear_flag {
		u32 clear_flag:32;       /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_AM_CLEAR_FLAG_DWLEN];
} __packed;

#define NBL_IPRO_FLAG_OFFSET_0_ADDR  (0xb04200)
#define NBL_IPRO_FLAG_OFFSET_0_DEPTH (1)
#define NBL_IPRO_FLAG_OFFSET_0_WIDTH (32)
#define NBL_IPRO_FLAG_OFFSET_0_DWLEN (1)
union ipro_flag_offset_0_u {
	struct ipro_flag_offset_0 {
		u32 dir_offset_en:1;     /* [0] Default:0x1 RW */
		u32 dir_offset:5;        /* [5:1] Default:0x00 RW */
		u32 rsv1:2;              /* [7:6] Default:0x0 RO */
		u32 phy_flow_offset_en:1; /* [8] Default:0x1 RW */
		u32 phy_flow_offset:5;   /* [13:9] Default:0xb RW */
		u32 rsv:18;              /* [31:14] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_FLAG_OFFSET_0_DWLEN];
} __packed;

#define NBL_IPRO_DROP_NXT_STAGE_ADDR  (0xb04210)
#define NBL_IPRO_DROP_NXT_STAGE_DEPTH (1)
#define NBL_IPRO_DROP_NXT_STAGE_WIDTH (32)
#define NBL_IPRO_DROP_NXT_STAGE_DWLEN (1)
union ipro_drop_nxt_stage_u {
	struct ipro_drop_nxt_stage {
		u32 stage:4;             /* [3:0] Default:0xf RW */
		u32 rsv:28;              /* [31:4] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_DROP_NXT_STAGE_DWLEN];
} __packed;

#define NBL_IPRO_FWD_ACTION_PRI_ADDR  (0xb04220)
#define NBL_IPRO_FWD_ACTION_PRI_DEPTH (1)
#define NBL_IPRO_FWD_ACTION_PRI_WIDTH (32)
#define NBL_IPRO_FWD_ACTION_PRI_DWLEN (1)
union ipro_fwd_action_pri_u {
	struct ipro_fwd_action_pri {
		u32 dqueue:2;            /* [1:0] Default:0x0 RW */
		u32 set_dport:2;         /* [3:2] Default:0x0 RW */
		u32 rsv:28;              /* [31:4] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_FWD_ACTION_PRI_DWLEN];
} __packed;

#define NBL_IPRO_MTU_CHECK_CTRL_ADDR  (0xb0427c)
#define NBL_IPRO_MTU_CHECK_CTRL_DEPTH (1)
#define NBL_IPRO_MTU_CHECK_CTRL_WIDTH (32)
#define NBL_IPRO_MTU_CHECK_CTRL_DWLEN (1)
union ipro_mtu_check_ctrl_u {
	struct ipro_mtu_check_ctrl {
		u32 set_dport:16;        /* [15:0] Default:0xFFFF RW */
		u32 set_dport_pri:2;     /* [17:16] Default:0x3 RW */
		u32 proc_done:1;         /* [18] Default:0x1 RW */
		u32 rsv:13;              /* [31:19] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MTU_CHECK_CTRL_DWLEN];
} __packed;

#define NBL_IPRO_MTU_SEL_ADDR  (0xb04280)
#define NBL_IPRO_MTU_SEL_DEPTH (8)
#define NBL_IPRO_MTU_SEL_WIDTH (32)
#define NBL_IPRO_MTU_SEL_DWLEN (1)
union ipro_mtu_sel_u {
	struct ipro_mtu_sel {
		u32 mtu_1:16;            /* [15:0] Default:0x0 RW */
		u32 mtu_0:16;            /* [31:16] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MTU_SEL_DWLEN];
} __packed;
#define NBL_IPRO_MTU_SEL_REG(r) (NBL_IPRO_MTU_SEL_ADDR + \
		(NBL_IPRO_MTU_SEL_DWLEN * 4) * (r))

#define NBL_IPRO_UDL_PKT_FLT_DMAC_ADDR  (0xb04300)
#define NBL_IPRO_UDL_PKT_FLT_DMAC_DEPTH (16)
#define NBL_IPRO_UDL_PKT_FLT_DMAC_WIDTH (64)
#define NBL_IPRO_UDL_PKT_FLT_DMAC_DWLEN (2)
union ipro_udl_pkt_flt_dmac_u {
	struct ipro_udl_pkt_flt_dmac {
		u32 dmac_l:32;           /* [47:0] Default:0x0 RW */
		u32 dmac_h:16;           /* [47:0] Default:0x0 RW */
		u32 rsv:16;              /* [63:48] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_UDL_PKT_FLT_DMAC_DWLEN];
} __packed;
#define NBL_IPRO_UDL_PKT_FLT_DMAC_REG(r) (NBL_IPRO_UDL_PKT_FLT_DMAC_ADDR + \
		(NBL_IPRO_UDL_PKT_FLT_DMAC_DWLEN * 4) * (r))

#define NBL_IPRO_UDL_PKT_FLT_VLAN_ADDR  (0xb04380)
#define NBL_IPRO_UDL_PKT_FLT_VLAN_DEPTH (16)
#define NBL_IPRO_UDL_PKT_FLT_VLAN_WIDTH (32)
#define NBL_IPRO_UDL_PKT_FLT_VLAN_DWLEN (1)
union ipro_udl_pkt_flt_vlan_u {
	struct ipro_udl_pkt_flt_vlan {
		u32 vlan_0:12;           /* [11:0] Default:0x0 RW */
		u32 vlan_1:12;           /* [23:12] Default:0x0 RW */
		u32 vlan_layer:2;        /* [25:24] Default:0x0 RW */
		u32 rsv:6;               /* [31:26] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_UDL_PKT_FLT_VLAN_DWLEN];
} __packed;
#define NBL_IPRO_UDL_PKT_FLT_VLAN_REG(r) (NBL_IPRO_UDL_PKT_FLT_VLAN_ADDR + \
		(NBL_IPRO_UDL_PKT_FLT_VLAN_DWLEN * 4) * (r))

#define NBL_IPRO_UDL_PKT_FLT_CTRL_ADDR  (0xb043c0)
#define NBL_IPRO_UDL_PKT_FLT_CTRL_DEPTH (1)
#define NBL_IPRO_UDL_PKT_FLT_CTRL_WIDTH (32)
#define NBL_IPRO_UDL_PKT_FLT_CTRL_DWLEN (1)
union ipro_udl_pkt_flt_ctrl_u {
	struct ipro_udl_pkt_flt_ctrl {
		u32 vld:16;              /* [15:0] Default:0x0 RW */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_UDL_PKT_FLT_CTRL_DWLEN];
} __packed;

#define NBL_IPRO_UDL_PKT_FLT_ACTION_ADDR  (0xb043c4)
#define NBL_IPRO_UDL_PKT_FLT_ACTION_DEPTH (1)
#define NBL_IPRO_UDL_PKT_FLT_ACTION_WIDTH (32)
#define NBL_IPRO_UDL_PKT_FLT_ACTION_DWLEN (1)
union ipro_udl_pkt_flt_action_u {
	struct ipro_udl_pkt_flt_action {
		u32 dqueue:11;           /* [10:0] Default:0x0 RW */
		u32 dqueue_en:1;         /* [11] Default:0x0 RW */
		u32 rsv:2;               /* [13:12] Default:0x0 RO */
		u32 proc_done:1;         /* [14] Default:0x0 RW */
		u32 set_dport_en:1;      /* [15] Default:0x0 RW */
		u32 set_dport:16;        /* [31:16] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_UDL_PKT_FLT_ACTION_DWLEN];
} __packed;

#define NBL_IPRO_ANTI_FAKE_ADDR_ERRCODE_ADDR  (0xb043e0)
#define NBL_IPRO_ANTI_FAKE_ADDR_ERRCODE_DEPTH (1)
#define NBL_IPRO_ANTI_FAKE_ADDR_ERRCODE_WIDTH (32)
#define NBL_IPRO_ANTI_FAKE_ADDR_ERRCODE_DWLEN (1)
union ipro_anti_fake_addr_errcode_u {
	struct ipro_anti_fake_addr_errcode {
		u32 num:4;               /* [3:0] Default:0xA RW */
		u32 rsv:28;              /* [31:4] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_ANTI_FAKE_ADDR_ERRCODE_DWLEN];
} __packed;

#define NBL_IPRO_ANTI_FAKE_ADDR_ACTION_ADDR  (0xb043e4)
#define NBL_IPRO_ANTI_FAKE_ADDR_ACTION_DEPTH (1)
#define NBL_IPRO_ANTI_FAKE_ADDR_ACTION_WIDTH (32)
#define NBL_IPRO_ANTI_FAKE_ADDR_ACTION_DWLEN (1)
union ipro_anti_fake_addr_action_u {
	struct ipro_anti_fake_addr_action {
		u32 dqueue:11;           /* [10:0] Default:0x0 RW */
		u32 dqueue_en:1;         /* [11] Default:0x0 RW */
		u32 rsv:2;               /* [13:12] Default:0x0 RO */
		u32 proc_done:1;         /* [14] Default:0x1 RW */
		u32 set_dport_en:1;      /* [15] Default:0x1 RW */
		u32 set_dport:16;        /* [31:16] Default:0xFFFF RW */
	} __packed info;
	u32 data[NBL_IPRO_ANTI_FAKE_ADDR_ACTION_DWLEN];
} __packed;

#define NBL_IPRO_VLAN_NUM_CHK_ERRCODE_ADDR  (0xb043f0)
#define NBL_IPRO_VLAN_NUM_CHK_ERRCODE_DEPTH (1)
#define NBL_IPRO_VLAN_NUM_CHK_ERRCODE_WIDTH (32)
#define NBL_IPRO_VLAN_NUM_CHK_ERRCODE_DWLEN (1)
union ipro_vlan_num_chk_errcode_u {
	struct ipro_vlan_num_chk_errcode {
		u32 num:4;               /* [3:0] Default:0x1 RW */
		u32 rsv:28;              /* [31:4] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_VLAN_NUM_CHK_ERRCODE_DWLEN];
} __packed;

#define NBL_IPRO_VLAN_NUM_CHK_ACTION_ADDR  (0xb043f4)
#define NBL_IPRO_VLAN_NUM_CHK_ACTION_DEPTH (1)
#define NBL_IPRO_VLAN_NUM_CHK_ACTION_WIDTH (32)
#define NBL_IPRO_VLAN_NUM_CHK_ACTION_DWLEN (1)
union ipro_vlan_num_chk_action_u {
	struct ipro_vlan_num_chk_action {
		u32 dqueue:11;           /* [10:0] Default:0x0 RW */
		u32 dqueue_en:1;         /* [11] Default:0x0 RW */
		u32 rsv:2;               /* [13:12] Default:0x0 RO */
		u32 proc_done:1;         /* [14] Default:0x1 RW */
		u32 set_dport_en:1;      /* [15] Default:0x1 RW */
		u32 set_dport:16;        /* [31:16] Default:0xFFFF RW */
	} __packed info;
	u32 data[NBL_IPRO_VLAN_NUM_CHK_ACTION_DWLEN];
} __packed;

#define NBL_IPRO_TCP_STATE_PROBE_ADDR  (0xb04400)
#define NBL_IPRO_TCP_STATE_PROBE_DEPTH (1)
#define NBL_IPRO_TCP_STATE_PROBE_WIDTH (32)
#define NBL_IPRO_TCP_STATE_PROBE_DWLEN (1)
union ipro_tcp_state_probe_u {
	struct ipro_tcp_state_probe {
		u32 up_chk_en:1;         /* [0] Default:0x0 RW */
		u32 dn_chk_en:1;         /* [1] Default:0x0 RW */
		u32 rsv:14;              /* [15:2] Default:0x0 RO */
		u32 up_bitmap:8;         /* [23:16] Default:0x0 RW */
		u32 dn_bitmap:8;         /* [31:24] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_TCP_STATE_PROBE_DWLEN];
} __packed;

#define NBL_IPRO_TCP_STATE_UP_ACTION_ADDR  (0xb04404)
#define NBL_IPRO_TCP_STATE_UP_ACTION_DEPTH (1)
#define NBL_IPRO_TCP_STATE_UP_ACTION_WIDTH (32)
#define NBL_IPRO_TCP_STATE_UP_ACTION_DWLEN (1)
union ipro_tcp_state_up_action_u {
	struct ipro_tcp_state_up_action {
		u32 dqueue:11;           /* [10:0] Default:0x0 RW */
		u32 dqueue_en:1;         /* [11] Default:0x0 RW */
		u32 rsv:2;               /* [13:12] Default:0x0 RO */
		u32 proc_done:1;         /* [14] Default:0x0 RW */
		u32 set_dport_en:1;      /* [15] Default:0x0 RW */
		u32 set_dport:16;        /* [31:16] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_TCP_STATE_UP_ACTION_DWLEN];
} __packed;

#define NBL_IPRO_TCP_STATE_DN_ACTION_ADDR  (0xb04408)
#define NBL_IPRO_TCP_STATE_DN_ACTION_DEPTH (1)
#define NBL_IPRO_TCP_STATE_DN_ACTION_WIDTH (32)
#define NBL_IPRO_TCP_STATE_DN_ACTION_DWLEN (1)
union ipro_tcp_state_dn_action_u {
	struct ipro_tcp_state_dn_action {
		u32 dqueue:11;           /* [10:0] Default:0x0 RW */
		u32 dqueue_en:1;         /* [11] Default:0x0 RW */
		u32 rsv:2;               /* [13:12] Default:0x0 RO */
		u32 proc_done:1;         /* [14] Default:0x0 RW */
		u32 set_dport_en:1;      /* [15] Default:0x0 RW */
		u32 set_dport:16;        /* [31:16] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_TCP_STATE_DN_ACTION_DWLEN];
} __packed;

#define NBL_IPRO_FWD_ACTION_ID_ADDR  (0xb04440)
#define NBL_IPRO_FWD_ACTION_ID_DEPTH (1)
#define NBL_IPRO_FWD_ACTION_ID_WIDTH (32)
#define NBL_IPRO_FWD_ACTION_ID_DWLEN (1)
union ipro_fwd_action_id_u {
	struct ipro_fwd_action_id {
		u32 mirror_index:6;      /* [5:0] Default:0x8 RW */
		u32 dport:6;             /* [11:6] Default:0x9 RW */
		u32 dqueue:6;            /* [17:12] Default:0xA RW */
		u32 car:6;               /* [23:18] Default:0x5 RW */
		u32 rsv:8;               /* [31:24] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_FWD_ACTION_ID_DWLEN];
} __packed;

#define NBL_IPRO_PED_ACTION_ID_ADDR  (0xb04448)
#define NBL_IPRO_PED_ACTION_ID_DEPTH (1)
#define NBL_IPRO_PED_ACTION_ID_WIDTH (32)
#define NBL_IPRO_PED_ACTION_ID_DWLEN (1)
union ipro_ped_action_id_u {
	struct ipro_ped_action_id {
		u32 encap:6;             /* [5:0] Default:0x2E RW */
		u32 decap:6;             /* [11:6] Default:0x2F RW */
		u32 rsv:20;              /* [31:12] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_PED_ACTION_ID_DWLEN];
} __packed;

#define NBL_IPRO_MNG_HIT_ACTION_ADDR  (0xb04510)
#define NBL_IPRO_MNG_HIT_ACTION_DEPTH (8)
#define NBL_IPRO_MNG_HIT_ACTION_WIDTH (32)
#define NBL_IPRO_MNG_HIT_ACTION_DWLEN (1)
union ipro_mng_hit_action_u {
	struct ipro_mng_hit_action {
		u32 data:24;             /* [23:0] Default:0x0 RW */
		u32 rsv:8;               /* [31:24] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_HIT_ACTION_DWLEN];
} __packed;
#define NBL_IPRO_MNG_HIT_ACTION_REG(r) (NBL_IPRO_MNG_HIT_ACTION_ADDR + \
		(NBL_IPRO_MNG_HIT_ACTION_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_DECISION_FLT_0_ADDR  (0xb04530)
#define NBL_IPRO_MNG_DECISION_FLT_0_DEPTH (4)
#define NBL_IPRO_MNG_DECISION_FLT_0_WIDTH (32)
#define NBL_IPRO_MNG_DECISION_FLT_0_DWLEN (1)
union ipro_mng_decision_flt_0_u {
	struct ipro_mng_decision_flt_0 {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 pkt_len_and:1;       /* [1] Default:0x0 RW */
		u32 flow_ctrl_and:1;     /* [2] Default:0x0 RW */
		u32 ncsi_and:1;          /* [3] Default:0x0 RW */
		u32 eth_id:2;            /* [5:4] Default:0x0 RW */
		u32 rsv:26;              /* [31:6] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_DECISION_FLT_0_DWLEN];
} __packed;
#define NBL_IPRO_MNG_DECISION_FLT_0_REG(r) (NBL_IPRO_MNG_DECISION_FLT_0_ADDR + \
		(NBL_IPRO_MNG_DECISION_FLT_0_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_DECISION_FLT_1_ADDR  (0xb04540)
#define NBL_IPRO_MNG_DECISION_FLT_1_DEPTH (4)
#define NBL_IPRO_MNG_DECISION_FLT_1_WIDTH (32)
#define NBL_IPRO_MNG_DECISION_FLT_1_DWLEN (1)
union ipro_mng_decision_flt_1_u {
	struct ipro_mng_decision_flt_1 {
		u32 dmac_and:4;          /* [3:0] Default:0x0 RW */
		u32 brcast_and:1;        /* [4] Default:0x0 RW */
		u32 mulcast_and:1;       /* [5] Default:0x0 RW */
		u32 vlan_and:8;          /* [13:6] Default:0x0 RW */
		u32 ipv4_dip_and:4;      /* [17:14] Default:0x0 RW */
		u32 ipv6_dip_and:4;      /* [21:18] Default:0x0 RW */
		u32 ethertype_and:4;     /* [25:22] Default:0x0 RW */
		u32 brcast_or:1;         /* [26] Default:0x0 RW */
		u32 icmpv4_or:1;         /* [27] Default:0x0 RW */
		u32 mld_or:4;            /* [31:28] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_DECISION_FLT_1_DWLEN];
} __packed;
#define NBL_IPRO_MNG_DECISION_FLT_1_REG(r) (NBL_IPRO_MNG_DECISION_FLT_1_ADDR + \
		(NBL_IPRO_MNG_DECISION_FLT_1_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_DECISION_FLT_2_ADDR  (0xb04550)
#define NBL_IPRO_MNG_DECISION_FLT_2_DEPTH (4)
#define NBL_IPRO_MNG_DECISION_FLT_2_WIDTH (32)
#define NBL_IPRO_MNG_DECISION_FLT_2_DWLEN (1)
union ipro_mng_decision_flt_2_u {
	struct ipro_mng_decision_flt_2 {
		u32 neighbor_or:4;       /* [3:0] Default:0x0 RW */
		u32 port_or:16;          /* [19:4] Default:0x0 RW */
		u32 ethertype_or:4;      /* [23:20] Default:0x0 RW */
		u32 arp_rsp_or:2;        /* [25:24] Default:0x0 RW */
		u32 arp_req_or:2;        /* [27:26] Default:0x0 RW */
		u32 dmac_or:4;           /* [31:28] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_DECISION_FLT_2_DWLEN];
} __packed;
#define NBL_IPRO_MNG_DECISION_FLT_2_REG(r) (NBL_IPRO_MNG_DECISION_FLT_2_ADDR + \
		(NBL_IPRO_MNG_DECISION_FLT_2_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_DMAC_FLT_0_ADDR  (0xb04560)
#define NBL_IPRO_MNG_DMAC_FLT_0_DEPTH (4)
#define NBL_IPRO_MNG_DMAC_FLT_0_WIDTH (32)
#define NBL_IPRO_MNG_DMAC_FLT_0_DWLEN (1)
union ipro_mng_dmac_flt_0_u {
	struct ipro_mng_dmac_flt_0 {
		u32 data:16;             /* [15:0] Default:0x0 RW */
		u32 en:1;                /* [16] Default:0x0 RW */
		u32 rsv:15;              /* [31:17] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_DMAC_FLT_0_DWLEN];
} __packed;
#define NBL_IPRO_MNG_DMAC_FLT_0_REG(r) (NBL_IPRO_MNG_DMAC_FLT_0_ADDR + \
		(NBL_IPRO_MNG_DMAC_FLT_0_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_DMAC_FLT_1_ADDR  (0xb04570)
#define NBL_IPRO_MNG_DMAC_FLT_1_DEPTH (4)
#define NBL_IPRO_MNG_DMAC_FLT_1_WIDTH (32)
#define NBL_IPRO_MNG_DMAC_FLT_1_DWLEN (1)
union ipro_mng_dmac_flt_1_u {
	struct ipro_mng_dmac_flt_1 {
		u32 data:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_DMAC_FLT_1_DWLEN];
} __packed;
#define NBL_IPRO_MNG_DMAC_FLT_1_REG(r) (NBL_IPRO_MNG_DMAC_FLT_1_ADDR + \
		(NBL_IPRO_MNG_DMAC_FLT_1_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_VLAN_FLT_ADDR  (0xb04580)
#define NBL_IPRO_MNG_VLAN_FLT_DEPTH (8)
#define NBL_IPRO_MNG_VLAN_FLT_WIDTH (32)
#define NBL_IPRO_MNG_VLAN_FLT_DWLEN (1)
union ipro_mng_vlan_flt_u {
	struct ipro_mng_vlan_flt {
		u32 data:12;             /* [11:0] Default:0x0 RW */
		u32 sel:1;               /* [12] Default:0x0 RW */
		u32 nontag:1;            /* [13] Default:0x0 RW */
		u32 en:1;                /* [14] Default:0x0 RW */
		u32 rsv:17;              /* [31:15] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_VLAN_FLT_DWLEN];
} __packed;
#define NBL_IPRO_MNG_VLAN_FLT_REG(r) (NBL_IPRO_MNG_VLAN_FLT_ADDR + \
		(NBL_IPRO_MNG_VLAN_FLT_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_ETHERTYPE_FLT_ADDR  (0xb045a0)
#define NBL_IPRO_MNG_ETHERTYPE_FLT_DEPTH (4)
#define NBL_IPRO_MNG_ETHERTYPE_FLT_WIDTH (32)
#define NBL_IPRO_MNG_ETHERTYPE_FLT_DWLEN (1)
union ipro_mng_ethertype_flt_u {
	struct ipro_mng_ethertype_flt {
		u32 data:16;             /* [15:0] Default:0x0 RW */
		u32 en:1;                /* [16] Default:0x0 RW */
		u32 rsv:15;              /* [31:17] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_ETHERTYPE_FLT_DWLEN];
} __packed;
#define NBL_IPRO_MNG_ETHERTYPE_FLT_REG(r) (NBL_IPRO_MNG_ETHERTYPE_FLT_ADDR + \
		(NBL_IPRO_MNG_ETHERTYPE_FLT_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_IPV4_FLT_0_ADDR  (0xb045b0)
#define NBL_IPRO_MNG_IPV4_FLT_0_DEPTH (4)
#define NBL_IPRO_MNG_IPV4_FLT_0_WIDTH (32)
#define NBL_IPRO_MNG_IPV4_FLT_0_DWLEN (1)
union ipro_mng_ipv4_flt_0_u {
	struct ipro_mng_ipv4_flt_0 {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_IPV4_FLT_0_DWLEN];
} __packed;
#define NBL_IPRO_MNG_IPV4_FLT_0_REG(r) (NBL_IPRO_MNG_IPV4_FLT_0_ADDR + \
		(NBL_IPRO_MNG_IPV4_FLT_0_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_IPV4_FLT_1_ADDR  (0xb045c0)
#define NBL_IPRO_MNG_IPV4_FLT_1_DEPTH (4)
#define NBL_IPRO_MNG_IPV4_FLT_1_WIDTH (32)
#define NBL_IPRO_MNG_IPV4_FLT_1_DWLEN (1)
union ipro_mng_ipv4_flt_1_u {
	struct ipro_mng_ipv4_flt_1 {
		u32 data:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_IPV4_FLT_1_DWLEN];
} __packed;
#define NBL_IPRO_MNG_IPV4_FLT_1_REG(r) (NBL_IPRO_MNG_IPV4_FLT_1_ADDR + \
		(NBL_IPRO_MNG_IPV4_FLT_1_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_IPV6_FLT_0_ADDR  (0xb04600)
#define NBL_IPRO_MNG_IPV6_FLT_0_DEPTH (4)
#define NBL_IPRO_MNG_IPV6_FLT_0_WIDTH (32)
#define NBL_IPRO_MNG_IPV6_FLT_0_DWLEN (1)
union ipro_mng_ipv6_flt_0_u {
	struct ipro_mng_ipv6_flt_0 {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:15;              /* [15:1] Default:0x0 RO */
		u32 mask:16;             /* [31:16] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_IPV6_FLT_0_DWLEN];
} __packed;
#define NBL_IPRO_MNG_IPV6_FLT_0_REG(r) (NBL_IPRO_MNG_IPV6_FLT_0_ADDR + \
		(NBL_IPRO_MNG_IPV6_FLT_0_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_IPV6_FLT_1_ADDR  (0xb04610)
#define NBL_IPRO_MNG_IPV6_FLT_1_DEPTH (4)
#define NBL_IPRO_MNG_IPV6_FLT_1_WIDTH (32)
#define NBL_IPRO_MNG_IPV6_FLT_1_DWLEN (1)
union ipro_mng_ipv6_flt_1_u {
	struct ipro_mng_ipv6_flt_1 {
		u32 data:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_IPV6_FLT_1_DWLEN];
} __packed;
#define NBL_IPRO_MNG_IPV6_FLT_1_REG(r) (NBL_IPRO_MNG_IPV6_FLT_1_ADDR + \
		(NBL_IPRO_MNG_IPV6_FLT_1_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_IPV6_FLT_2_ADDR  (0xb04620)
#define NBL_IPRO_MNG_IPV6_FLT_2_DEPTH (4)
#define NBL_IPRO_MNG_IPV6_FLT_2_WIDTH (32)
#define NBL_IPRO_MNG_IPV6_FLT_2_DWLEN (1)
union ipro_mng_ipv6_flt_2_u {
	struct ipro_mng_ipv6_flt_2 {
		u32 data:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_IPV6_FLT_2_DWLEN];
} __packed;
#define NBL_IPRO_MNG_IPV6_FLT_2_REG(r) (NBL_IPRO_MNG_IPV6_FLT_2_ADDR + \
		(NBL_IPRO_MNG_IPV6_FLT_2_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_IPV6_FLT_3_ADDR  (0xb04630)
#define NBL_IPRO_MNG_IPV6_FLT_3_DEPTH (4)
#define NBL_IPRO_MNG_IPV6_FLT_3_WIDTH (32)
#define NBL_IPRO_MNG_IPV6_FLT_3_DWLEN (1)
union ipro_mng_ipv6_flt_3_u {
	struct ipro_mng_ipv6_flt_3 {
		u32 data:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_IPV6_FLT_3_DWLEN];
} __packed;
#define NBL_IPRO_MNG_IPV6_FLT_3_REG(r) (NBL_IPRO_MNG_IPV6_FLT_3_ADDR + \
		(NBL_IPRO_MNG_IPV6_FLT_3_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_IPV6_FLT_4_ADDR  (0xb04640)
#define NBL_IPRO_MNG_IPV6_FLT_4_DEPTH (4)
#define NBL_IPRO_MNG_IPV6_FLT_4_WIDTH (32)
#define NBL_IPRO_MNG_IPV6_FLT_4_DWLEN (1)
union ipro_mng_ipv6_flt_4_u {
	struct ipro_mng_ipv6_flt_4 {
		u32 data:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_IPV6_FLT_4_DWLEN];
} __packed;
#define NBL_IPRO_MNG_IPV6_FLT_4_REG(r) (NBL_IPRO_MNG_IPV6_FLT_4_ADDR + \
		(NBL_IPRO_MNG_IPV6_FLT_4_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_PORT_FLT_ADDR  (0xb04650)
#define NBL_IPRO_MNG_PORT_FLT_DEPTH (16)
#define NBL_IPRO_MNG_PORT_FLT_WIDTH (32)
#define NBL_IPRO_MNG_PORT_FLT_DWLEN (1)
union ipro_mng_port_flt_u {
	struct ipro_mng_port_flt {
		u32 data:16;             /* [15:0] Default:0x0 RW */
		u32 en:1;                /* [16] Default:0x0 RW */
		u32 mode:1;              /* [17] Default:0x0 RW */
		u32 tcp:1;               /* [18] Default:0x0 RW */
		u32 udp:1;               /* [19] Default:0x0 RW */
		u32 rsv:12;              /* [31:20] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_PORT_FLT_DWLEN];
} __packed;
#define NBL_IPRO_MNG_PORT_FLT_REG(r) (NBL_IPRO_MNG_PORT_FLT_ADDR + \
		(NBL_IPRO_MNG_PORT_FLT_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_ARP_REQ_FLT_0_ADDR  (0xb04690)
#define NBL_IPRO_MNG_ARP_REQ_FLT_0_DEPTH (2)
#define NBL_IPRO_MNG_ARP_REQ_FLT_0_WIDTH (32)
#define NBL_IPRO_MNG_ARP_REQ_FLT_0_DWLEN (1)
union ipro_mng_arp_req_flt_0_u {
	struct ipro_mng_arp_req_flt_0 {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:15;              /* [15:1] Default:0x0 RO */
		u32 op:16;               /* [31:16] Default:0x1 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_ARP_REQ_FLT_0_DWLEN];
} __packed;
#define NBL_IPRO_MNG_ARP_REQ_FLT_0_REG(r) (NBL_IPRO_MNG_ARP_REQ_FLT_0_ADDR + \
		(NBL_IPRO_MNG_ARP_REQ_FLT_0_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_ARP_REQ_FLT_1_ADDR  (0xb046a0)
#define NBL_IPRO_MNG_ARP_REQ_FLT_1_DEPTH (2)
#define NBL_IPRO_MNG_ARP_REQ_FLT_1_WIDTH (32)
#define NBL_IPRO_MNG_ARP_REQ_FLT_1_DWLEN (1)
union ipro_mng_arp_req_flt_1_u {
	struct ipro_mng_arp_req_flt_1 {
		u32 data:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_ARP_REQ_FLT_1_DWLEN];
} __packed;
#define NBL_IPRO_MNG_ARP_REQ_FLT_1_REG(r) (NBL_IPRO_MNG_ARP_REQ_FLT_1_ADDR + \
		(NBL_IPRO_MNG_ARP_REQ_FLT_1_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_ARP_RSP_FLT_0_ADDR  (0xb046b0)
#define NBL_IPRO_MNG_ARP_RSP_FLT_0_DEPTH (2)
#define NBL_IPRO_MNG_ARP_RSP_FLT_0_WIDTH (32)
#define NBL_IPRO_MNG_ARP_RSP_FLT_0_DWLEN (1)
union ipro_mng_arp_rsp_flt_0_u {
	struct ipro_mng_arp_rsp_flt_0 {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:15;              /* [15:1] Default:0x0 RO */
		u32 op:16;               /* [31:16] Default:0x2 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_ARP_RSP_FLT_0_DWLEN];
} __packed;
#define NBL_IPRO_MNG_ARP_RSP_FLT_0_REG(r) (NBL_IPRO_MNG_ARP_RSP_FLT_0_ADDR + \
		(NBL_IPRO_MNG_ARP_RSP_FLT_0_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_ARP_RSP_FLT_1_ADDR  (0xb046c0)
#define NBL_IPRO_MNG_ARP_RSP_FLT_1_DEPTH (2)
#define NBL_IPRO_MNG_ARP_RSP_FLT_1_WIDTH (32)
#define NBL_IPRO_MNG_ARP_RSP_FLT_1_DWLEN (1)
union ipro_mng_arp_rsp_flt_1_u {
	struct ipro_mng_arp_rsp_flt_1 {
		u32 data:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_MNG_ARP_RSP_FLT_1_DWLEN];
} __packed;
#define NBL_IPRO_MNG_ARP_RSP_FLT_1_REG(r) (NBL_IPRO_MNG_ARP_RSP_FLT_1_ADDR + \
		(NBL_IPRO_MNG_ARP_RSP_FLT_1_DWLEN * 4) * (r))

#define NBL_IPRO_MNG_NEIGHBOR_FLT_86_ADDR  (0xb046d0)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_86_DEPTH (1)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_86_WIDTH (32)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_86_DWLEN (1)
union ipro_mng_neighbor_flt_86_u {
	struct ipro_mng_neighbor_flt_86 {
		u32 data:8;              /* [7:0] Default:0x86 RW */
		u32 en:1;                /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_NEIGHBOR_FLT_86_DWLEN];
} __packed;

#define NBL_IPRO_MNG_NEIGHBOR_FLT_87_ADDR  (0xb046d4)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_87_DEPTH (1)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_87_WIDTH (32)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_87_DWLEN (1)
union ipro_mng_neighbor_flt_87_u {
	struct ipro_mng_neighbor_flt_87 {
		u32 data:8;              /* [7:0] Default:0x87 RW */
		u32 en:1;                /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_NEIGHBOR_FLT_87_DWLEN];
} __packed;

#define NBL_IPRO_MNG_NEIGHBOR_FLT_88_ADDR  (0xb046d8)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_88_DEPTH (1)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_88_WIDTH (32)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_88_DWLEN (1)
union ipro_mng_neighbor_flt_88_u {
	struct ipro_mng_neighbor_flt_88 {
		u32 data:8;              /* [7:0] Default:0x88 RW */
		u32 en:1;                /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_NEIGHBOR_FLT_88_DWLEN];
} __packed;

#define NBL_IPRO_MNG_NEIGHBOR_FLT_89_ADDR  (0xb046dc)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_89_DEPTH (1)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_89_WIDTH (32)
#define NBL_IPRO_MNG_NEIGHBOR_FLT_89_DWLEN (1)
union ipro_mng_neighbor_flt_89_u {
	struct ipro_mng_neighbor_flt_89 {
		u32 data:8;              /* [7:0] Default:0x89 RW */
		u32 en:1;                /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_NEIGHBOR_FLT_89_DWLEN];
} __packed;

#define NBL_IPRO_MNG_MLD_FLT_82_ADDR  (0xb046e0)
#define NBL_IPRO_MNG_MLD_FLT_82_DEPTH (1)
#define NBL_IPRO_MNG_MLD_FLT_82_WIDTH (32)
#define NBL_IPRO_MNG_MLD_FLT_82_DWLEN (1)
union ipro_mng_mld_flt_82_u {
	struct ipro_mng_mld_flt_82 {
		u32 data:8;              /* [7:0] Default:0x82 RW */
		u32 en:1;                /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_MLD_FLT_82_DWLEN];
} __packed;

#define NBL_IPRO_MNG_MLD_FLT_83_ADDR  (0xb046e4)
#define NBL_IPRO_MNG_MLD_FLT_83_DEPTH (1)
#define NBL_IPRO_MNG_MLD_FLT_83_WIDTH (32)
#define NBL_IPRO_MNG_MLD_FLT_83_DWLEN (1)
union ipro_mng_mld_flt_83_u {
	struct ipro_mng_mld_flt_83 {
		u32 data:8;              /* [7:0] Default:0x83 RW */
		u32 en:1;                /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_MLD_FLT_83_DWLEN];
} __packed;

#define NBL_IPRO_MNG_MLD_FLT_84_ADDR  (0xb046e8)
#define NBL_IPRO_MNG_MLD_FLT_84_DEPTH (1)
#define NBL_IPRO_MNG_MLD_FLT_84_WIDTH (32)
#define NBL_IPRO_MNG_MLD_FLT_84_DWLEN (1)
union ipro_mng_mld_flt_84_u {
	struct ipro_mng_mld_flt_84 {
		u32 data:8;              /* [7:0] Default:0x84 RW */
		u32 en:1;                /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_MLD_FLT_84_DWLEN];
} __packed;

#define NBL_IPRO_MNG_MLD_FLT_8F_ADDR  (0xb046ec)
#define NBL_IPRO_MNG_MLD_FLT_8F_DEPTH (1)
#define NBL_IPRO_MNG_MLD_FLT_8F_WIDTH (32)
#define NBL_IPRO_MNG_MLD_FLT_8F_DWLEN (1)
union ipro_mng_mld_flt_8f_u {
	struct ipro_mng_mld_flt_8f {
		u32 data:8;              /* [7:0] Default:0x8f RW */
		u32 en:1;                /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_MLD_FLT_8F_DWLEN];
} __packed;

#define NBL_IPRO_MNG_ICMPV4_FLT_ADDR  (0xb046f0)
#define NBL_IPRO_MNG_ICMPV4_FLT_DEPTH (1)
#define NBL_IPRO_MNG_ICMPV4_FLT_WIDTH (32)
#define NBL_IPRO_MNG_ICMPV4_FLT_DWLEN (1)
union ipro_mng_icmpv4_flt_u {
	struct ipro_mng_icmpv4_flt {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_ICMPV4_FLT_DWLEN];
} __packed;

#define NBL_IPRO_MNG_BRCAST_FLT_ADDR  (0xb04700)
#define NBL_IPRO_MNG_BRCAST_FLT_DEPTH (1)
#define NBL_IPRO_MNG_BRCAST_FLT_WIDTH (32)
#define NBL_IPRO_MNG_BRCAST_FLT_DWLEN (1)
union ipro_mng_brcast_flt_u {
	struct ipro_mng_brcast_flt {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_BRCAST_FLT_DWLEN];
} __packed;

#define NBL_IPRO_MNG_MULCAST_FLT_ADDR  (0xb04704)
#define NBL_IPRO_MNG_MULCAST_FLT_DEPTH (1)
#define NBL_IPRO_MNG_MULCAST_FLT_WIDTH (32)
#define NBL_IPRO_MNG_MULCAST_FLT_DWLEN (1)
union ipro_mng_mulcast_flt_u {
	struct ipro_mng_mulcast_flt {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_MULCAST_FLT_DWLEN];
} __packed;

#define NBL_IPRO_MNG_FLOW_CTRL_FLT_ADDR  (0xb04710)
#define NBL_IPRO_MNG_FLOW_CTRL_FLT_DEPTH (1)
#define NBL_IPRO_MNG_FLOW_CTRL_FLT_WIDTH (32)
#define NBL_IPRO_MNG_FLOW_CTRL_FLT_DWLEN (1)
union ipro_mng_flow_ctrl_flt_u {
	struct ipro_mng_flow_ctrl_flt {
		u32 data:16;             /* [15:0] Default:0x8808 RW */
		u32 en:1;                /* [16] Default:0x0 RW */
		u32 bow:1;               /* [17] Default:0x0 RW */
		u32 rsv:14;              /* [31:18] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_FLOW_CTRL_FLT_DWLEN];
} __packed;

#define NBL_IPRO_MNG_NCSI_FLT_ADDR  (0xb04714)
#define NBL_IPRO_MNG_NCSI_FLT_DEPTH (1)
#define NBL_IPRO_MNG_NCSI_FLT_WIDTH (32)
#define NBL_IPRO_MNG_NCSI_FLT_DWLEN (1)
union ipro_mng_ncsi_flt_u {
	struct ipro_mng_ncsi_flt {
		u32 data:16;             /* [15:0] Default:0x88F8 RW */
		u32 en:1;                /* [16] Default:0x0 RW */
		u32 bow:1;               /* [17] Default:0x1 RW */
		u32 rsv:14;              /* [31:18] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_NCSI_FLT_DWLEN];
} __packed;

#define NBL_IPRO_MNG_PKT_LEN_FLT_ADDR  (0xb04720)
#define NBL_IPRO_MNG_PKT_LEN_FLT_DEPTH (1)
#define NBL_IPRO_MNG_PKT_LEN_FLT_WIDTH (32)
#define NBL_IPRO_MNG_PKT_LEN_FLT_DWLEN (1)
union ipro_mng_pkt_len_flt_u {
	struct ipro_mng_pkt_len_flt {
		u32 max:16;              /* [15:0] Default:0x800 RW */
		u32 en:1;                /* [16] Default:0x0 RW */
		u32 rsv:15;              /* [31:17] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_PKT_LEN_FLT_DWLEN];
} __packed;

#define NBL_IPRO_FLOW_STOP_ADDR  (0xb04810)
#define NBL_IPRO_FLOW_STOP_DEPTH (1)
#define NBL_IPRO_FLOW_STOP_WIDTH (32)
#define NBL_IPRO_FLOW_STOP_DWLEN (1)
union ipro_flow_stop_u {
	struct ipro_flow_stop {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_FLOW_STOP_DWLEN];
} __packed;

#define NBL_IPRO_TOKEN_NUM_ADDR  (0xb04814)
#define NBL_IPRO_TOKEN_NUM_DEPTH (1)
#define NBL_IPRO_TOKEN_NUM_WIDTH (32)
#define NBL_IPRO_TOKEN_NUM_DWLEN (1)
union ipro_token_num_u {
	struct ipro_token_num {
		u32 dn_cnt:8;            /* [7:0] Default:0x80 RO */
		u32 up_cnt:8;            /* [15:8] Default:0x80 RO */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_TOKEN_NUM_DWLEN];
} __packed;

#define NBL_IPRO_BYPASS_ADDR  (0xb04818)
#define NBL_IPRO_BYPASS_DEPTH (1)
#define NBL_IPRO_BYPASS_WIDTH (32)
#define NBL_IPRO_BYPASS_DWLEN (1)
union ipro_bypass_u {
	struct ipro_bypass {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_BYPASS_DWLEN];
} __packed;

#define NBL_IPRO_RR_REQ_MASK_ADDR  (0xb0481c)
#define NBL_IPRO_RR_REQ_MASK_DEPTH (1)
#define NBL_IPRO_RR_REQ_MASK_WIDTH (32)
#define NBL_IPRO_RR_REQ_MASK_DWLEN (1)
union ipro_rr_req_mask_u {
	struct ipro_rr_req_mask {
		u32 dn:1;                /* [0] Default:0x0 RW */
		u32 up:1;                /* [1] Default:0x0 RW */
		u32 rsv:30;              /* [31:2] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_RR_REQ_MASK_DWLEN];
} __packed;

#define NBL_IPRO_BP_STATE_ADDR  (0xb04828)
#define NBL_IPRO_BP_STATE_DEPTH (1)
#define NBL_IPRO_BP_STATE_WIDTH (32)
#define NBL_IPRO_BP_STATE_DWLEN (1)
union ipro_bp_state_u {
	struct ipro_bp_state {
		u32 pp_up_link_fc:1;     /* [0] Default:0x0 RO */
		u32 pp_dn_link_fc:1;     /* [1] Default:0x0 RO */
		u32 pp_up_creadit:1;     /* [2] Default:0x0 RO */
		u32 pp_dn_creadit:1;     /* [3] Default:0x0 RO */
		u32 mcc_up_creadit:1;    /* [4] Default:0x0 RO */
		u32 mcc_dn_creadit:1;    /* [5] Default:0x0 RO */
		u32 pp_rdy:1;            /* [6] Default:0x1 RO */
		u32 dn_rdy:1;            /* [7] Default:0x1 RO */
		u32 up_rdy:1;            /* [8] Default:0x1 RO */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_BP_STATE_DWLEN];
} __packed;

#define NBL_IPRO_BP_HISTORY_ADDR  (0xb0482c)
#define NBL_IPRO_BP_HISTORY_DEPTH (1)
#define NBL_IPRO_BP_HISTORY_WIDTH (32)
#define NBL_IPRO_BP_HISTORY_DWLEN (1)
union ipro_bp_history_u {
	struct ipro_bp_history {
		u32 pp_rdy:1;            /* [0] Default:0x0 RC */
		u32 dn_rdy:1;            /* [1] Default:0x0 RC */
		u32 up_rdy:1;            /* [2] Default:0x0 RC */
		u32 rsv:29;              /* [31:3] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_BP_HISTORY_DWLEN];
} __packed;

#define NBL_IPRO_ERRCODE_TBL_DROP_ADDR  (0xb0486c)
#define NBL_IPRO_ERRCODE_TBL_DROP_DEPTH (1)
#define NBL_IPRO_ERRCODE_TBL_DROP_WIDTH (32)
#define NBL_IPRO_ERRCODE_TBL_DROP_DWLEN (1)
union ipro_errcode_tbl_drop_u {
	struct ipro_errcode_tbl_drop {
		u32 cnt:16;              /* [15:0] Default:0x0 SCTR */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_ERRCODE_TBL_DROP_DWLEN];
} __packed;

#define NBL_IPRO_SPORT_TBL_DROP_ADDR  (0xb04870)
#define NBL_IPRO_SPORT_TBL_DROP_DEPTH (1)
#define NBL_IPRO_SPORT_TBL_DROP_WIDTH (32)
#define NBL_IPRO_SPORT_TBL_DROP_DWLEN (1)
union ipro_sport_tbl_drop_u {
	struct ipro_sport_tbl_drop {
		u32 cnt:16;              /* [15:0] Default:0x0 SCTR */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_SPORT_TBL_DROP_DWLEN];
} __packed;

#define NBL_IPRO_PTYPE_TBL_DROP_ADDR  (0xb04874)
#define NBL_IPRO_PTYPE_TBL_DROP_DEPTH (1)
#define NBL_IPRO_PTYPE_TBL_DROP_WIDTH (32)
#define NBL_IPRO_PTYPE_TBL_DROP_DWLEN (1)
union ipro_ptype_tbl_drop_u {
	struct ipro_ptype_tbl_drop {
		u32 cnt:16;              /* [15:0] Default:0x0 SCTR */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_PTYPE_TBL_DROP_DWLEN];
} __packed;

#define NBL_IPRO_UDL_DROP_ADDR  (0xb04878)
#define NBL_IPRO_UDL_DROP_DEPTH (1)
#define NBL_IPRO_UDL_DROP_WIDTH (32)
#define NBL_IPRO_UDL_DROP_DWLEN (1)
union ipro_udl_drop_u {
	struct ipro_udl_drop {
		u32 cnt:16;              /* [15:0] Default:0x0 SCTR */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_UDL_DROP_DWLEN];
} __packed;

#define NBL_IPRO_ANTIFAKE_DROP_ADDR  (0xb0487c)
#define NBL_IPRO_ANTIFAKE_DROP_DEPTH (1)
#define NBL_IPRO_ANTIFAKE_DROP_WIDTH (32)
#define NBL_IPRO_ANTIFAKE_DROP_DWLEN (1)
union ipro_antifake_drop_u {
	struct ipro_antifake_drop {
		u32 cnt:16;              /* [15:0] Default:0x0 SCTR */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_ANTIFAKE_DROP_DWLEN];
} __packed;

#define NBL_IPRO_VLAN_NUM_DROP_ADDR  (0xb04880)
#define NBL_IPRO_VLAN_NUM_DROP_DEPTH (1)
#define NBL_IPRO_VLAN_NUM_DROP_WIDTH (32)
#define NBL_IPRO_VLAN_NUM_DROP_DWLEN (1)
union ipro_vlan_num_drop_u {
	struct ipro_vlan_num_drop {
		u32 cnt:16;              /* [15:0] Default:0x0 SCTR */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_VLAN_NUM_DROP_DWLEN];
} __packed;

#define NBL_IPRO_TCP_STATE_DROP_ADDR  (0xb04884)
#define NBL_IPRO_TCP_STATE_DROP_DEPTH (1)
#define NBL_IPRO_TCP_STATE_DROP_WIDTH (32)
#define NBL_IPRO_TCP_STATE_DROP_DWLEN (1)
union ipro_tcp_state_drop_u {
	struct ipro_tcp_state_drop {
		u32 cnt:16;              /* [15:0] Default:0x0 SCTR */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_TCP_STATE_DROP_DWLEN];
} __packed;

#define NBL_IPRO_RAM_ERR_DROP_ADDR  (0xb04888)
#define NBL_IPRO_RAM_ERR_DROP_DEPTH (1)
#define NBL_IPRO_RAM_ERR_DROP_WIDTH (32)
#define NBL_IPRO_RAM_ERR_DROP_DWLEN (1)
union ipro_ram_err_drop_u {
	struct ipro_ram_err_drop {
		u32 cnt:16;              /* [15:0] Default:0x0 SCTR */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_RAM_ERR_DROP_DWLEN];
} __packed;

#define NBL_IPRO_KG_MISS_ADDR  (0xb0488c)
#define NBL_IPRO_KG_MISS_DEPTH (1)
#define NBL_IPRO_KG_MISS_WIDTH (32)
#define NBL_IPRO_KG_MISS_DWLEN (1)
union ipro_kg_miss_u {
	struct ipro_kg_miss {
		u32 drop_cnt:16;         /* [15:0] Default:0x0 SCTR */
		u32 cnt:16;              /* [31:16] Default:0x0 SCTR */
	} __packed info;
	u32 data[NBL_IPRO_KG_MISS_DWLEN];
} __packed;

#define NBL_IPRO_MNG_DROP_ADDR  (0xb04890)
#define NBL_IPRO_MNG_DROP_DEPTH (1)
#define NBL_IPRO_MNG_DROP_WIDTH (32)
#define NBL_IPRO_MNG_DROP_DWLEN (1)
union ipro_mng_drop_u {
	struct ipro_mng_drop {
		u32 cnt:16;              /* [15:0] Default:0x0 SCTR */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_MNG_DROP_DWLEN];
} __packed;

#define NBL_IPRO_MTU_CHECK_DROP_ADDR  (0xb04900)
#define NBL_IPRO_MTU_CHECK_DROP_DEPTH (256)
#define NBL_IPRO_MTU_CHECK_DROP_WIDTH (32)
#define NBL_IPRO_MTU_CHECK_DROP_DWLEN (1)
union ipro_mtu_check_drop_u {
	struct ipro_mtu_check_drop {
		u32 vsi_3:8;             /* [7:0] Default:0x0 SCTR */
		u32 vsi_2:8;             /* [15:8] Default:0x0 SCTR */
		u32 vsi_1:8;             /* [23:16] Default:0x0 SCTR */
		u32 vsi_0:8;             /* [31:24] Default:0x0 SCTR */
	} __packed info;
	u32 data[NBL_IPRO_MTU_CHECK_DROP_DWLEN];
} __packed;
#define NBL_IPRO_MTU_CHECK_DROP_REG(r) (NBL_IPRO_MTU_CHECK_DROP_ADDR + \
		(NBL_IPRO_MTU_CHECK_DROP_DWLEN * 4) * (r))

#define NBL_IPRO_LAST_QUEUE_RAM_ERR_ADDR  (0xb04d08)
#define NBL_IPRO_LAST_QUEUE_RAM_ERR_DEPTH (1)
#define NBL_IPRO_LAST_QUEUE_RAM_ERR_WIDTH (32)
#define NBL_IPRO_LAST_QUEUE_RAM_ERR_DWLEN (1)
union ipro_last_queue_ram_err_u {
	struct ipro_last_queue_ram_err {
		u32 info:32;             /* [31:0] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_LAST_QUEUE_RAM_ERR_DWLEN];
} __packed;

#define NBL_IPRO_LAST_DN_SRC_PORT_RAM_ERR_ADDR  (0xb04d0c)
#define NBL_IPRO_LAST_DN_SRC_PORT_RAM_ERR_DEPTH (1)
#define NBL_IPRO_LAST_DN_SRC_PORT_RAM_ERR_WIDTH (32)
#define NBL_IPRO_LAST_DN_SRC_PORT_RAM_ERR_DWLEN (1)
union ipro_last_dn_src_port_ram_err_u {
	struct ipro_last_dn_src_port_ram_err {
		u32 info:32;             /* [31:0] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_LAST_DN_SRC_PORT_RAM_ERR_DWLEN];
} __packed;

#define NBL_IPRO_LAST_UP_SRC_PORT_RAM_ERR_ADDR  (0xb04d10)
#define NBL_IPRO_LAST_UP_SRC_PORT_RAM_ERR_DEPTH (1)
#define NBL_IPRO_LAST_UP_SRC_PORT_RAM_ERR_WIDTH (32)
#define NBL_IPRO_LAST_UP_SRC_PORT_RAM_ERR_DWLEN (1)
union ipro_last_up_src_port_ram_err_u {
	struct ipro_last_up_src_port_ram_err {
		u32 info:32;             /* [31:0] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_LAST_UP_SRC_PORT_RAM_ERR_DWLEN];
} __packed;

#define NBL_IPRO_LAST_DN_PTYPE_RAM_ERR_ADDR  (0xb04d14)
#define NBL_IPRO_LAST_DN_PTYPE_RAM_ERR_DEPTH (1)
#define NBL_IPRO_LAST_DN_PTYPE_RAM_ERR_WIDTH (32)
#define NBL_IPRO_LAST_DN_PTYPE_RAM_ERR_DWLEN (1)
union ipro_last_dn_ptype_ram_err_u {
	struct ipro_last_dn_ptype_ram_err {
		u32 info:32;             /* [31:0] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_LAST_DN_PTYPE_RAM_ERR_DWLEN];
} __packed;

#define NBL_IPRO_LAST_UP_PTYPE_RAM_ERR_ADDR  (0xb04d18)
#define NBL_IPRO_LAST_UP_PTYPE_RAM_ERR_DEPTH (1)
#define NBL_IPRO_LAST_UP_PTYPE_RAM_ERR_WIDTH (32)
#define NBL_IPRO_LAST_UP_PTYPE_RAM_ERR_DWLEN (1)
union ipro_last_up_ptype_ram_err_u {
	struct ipro_last_up_ptype_ram_err {
		u32 info:32;             /* [31:0] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_LAST_UP_PTYPE_RAM_ERR_DWLEN];
} __packed;

#define NBL_IPRO_LAST_KG_PROF_RAM_ERR_ADDR  (0xb04d20)
#define NBL_IPRO_LAST_KG_PROF_RAM_ERR_DEPTH (1)
#define NBL_IPRO_LAST_KG_PROF_RAM_ERR_WIDTH (32)
#define NBL_IPRO_LAST_KG_PROF_RAM_ERR_DWLEN (1)
union ipro_last_kg_prof_ram_err_u {
	struct ipro_last_kg_prof_ram_err {
		u32 info:32;             /* [31:0] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_LAST_KG_PROF_RAM_ERR_DWLEN];
} __packed;

#define NBL_IPRO_LAST_ERRCODE_RAM_ERR_ADDR  (0xb04d28)
#define NBL_IPRO_LAST_ERRCODE_RAM_ERR_DEPTH (1)
#define NBL_IPRO_LAST_ERRCODE_RAM_ERR_WIDTH (32)
#define NBL_IPRO_LAST_ERRCODE_RAM_ERR_DWLEN (1)
union ipro_last_errcode_ram_err_u {
	struct ipro_last_errcode_ram_err {
		u32 info:32;             /* [31:0] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_LAST_ERRCODE_RAM_ERR_DWLEN];
} __packed;

#define NBL_IPRO_IN_PKT_CAP_EN_ADDR  (0xb04dfc)
#define NBL_IPRO_IN_PKT_CAP_EN_DEPTH (1)
#define NBL_IPRO_IN_PKT_CAP_EN_WIDTH (32)
#define NBL_IPRO_IN_PKT_CAP_EN_DWLEN (1)
union ipro_in_pkt_cap_en_u {
	struct ipro_in_pkt_cap_en {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_IN_PKT_CAP_EN_DWLEN];
} __packed;

#define NBL_IPRO_IN_PKT_CAP_ADDR  (0xb04e00)
#define NBL_IPRO_IN_PKT_CAP_DEPTH (64)
#define NBL_IPRO_IN_PKT_CAP_WIDTH (32)
#define NBL_IPRO_IN_PKT_CAP_DWLEN (1)
union ipro_in_pkt_cap_u {
	struct ipro_in_pkt_cap {
		u32 data:32;             /* [31:0] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_IN_PKT_CAP_DWLEN];
} __packed;
#define NBL_IPRO_IN_PKT_CAP_REG(r) (NBL_IPRO_IN_PKT_CAP_ADDR + \
		(NBL_IPRO_IN_PKT_CAP_DWLEN * 4) * (r))

#define NBL_IPRO_ERRCODE_TBL_ADDR  (0xb05000)
#define NBL_IPRO_ERRCODE_TBL_DEPTH (16)
#define NBL_IPRO_ERRCODE_TBL_WIDTH (64)
#define NBL_IPRO_ERRCODE_TBL_DWLEN (2)
union ipro_errcode_tbl_u {
	struct ipro_errcode_tbl {
		u32 dqueue:11;           /* [10:0] Default:0x0 RW */
		u32 dqueue_en:1;         /* [11] Default:0x0 RW */
		u32 dqueue_pri:2;        /* [13:12] Default:0x0 RW */
		u32 set_dport_pri:2;     /* [15:14] Default:0x0 RW */
		u32 set_dport:16;        /* [31:16] Default:0x0 RW */
		u32 set_dport_en:1;      /* [32] Default:0x0 RW */
		u32 proc_done:1;         /* [33] Default:0x0 RW */
		u32 vld:1;               /* [34] Default:0x0 RW */
		u32 rsv:29;              /* [63:35] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_ERRCODE_TBL_DWLEN];
} __packed;
#define NBL_IPRO_ERRCODE_TBL_REG(r) (NBL_IPRO_ERRCODE_TBL_ADDR + \
		(NBL_IPRO_ERRCODE_TBL_DWLEN * 4) * (r))

#define NBL_IPRO_DN_PTYPE_TBL_ADDR  (0xb06000)
#define NBL_IPRO_DN_PTYPE_TBL_DEPTH (256)
#define NBL_IPRO_DN_PTYPE_TBL_WIDTH (64)
#define NBL_IPRO_DN_PTYPE_TBL_DWLEN (2)
union ipro_dn_ptype_tbl_u {
	struct ipro_dn_ptype_tbl {
		u32 dn_entry_vld:1;      /* [0] Default:0x0 RW */
		u32 dn_mirror_en:1;      /* [1] Default:0x0 RW */
		u32 dn_mirror_pri:2;     /* [3:2] Default:0x0 RW */
		u32 dn_mirror_id:4;      /* [7:4] Default:0x0 RW */
		u32 dn_encap_en:1;       /* [8] Default:0x0 RW */
		u32 dn_encap_pri:2;      /* [10:9] Default:0x0 RW */
		u32 dn_encap_index:13;   /* [23:11] Default:0x0 RW */
		u32 not_used_0:6;        /* [29:24] Default:0x0 RW */
		u32 proc_done:1;         /* [30] Default:0x0 RW */
		u32 set_dport_en:1;      /* [31] Default:0x0 RW */
		u32 set_dport:16;        /* [47:32] Default:0x0 RW */
		u32 set_dport_pri:2;     /* [49:48] Default:0x0 RW */
		u32 dqueue_pri:2;        /* [51:50] Default:0x0 RW */
		u32 dqueue:11;           /* [62:52] Default:0x0 RW */
		u32 dqueue_en:1;         /* [63] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_DN_PTYPE_TBL_DWLEN];
} __packed;
#define NBL_IPRO_DN_PTYPE_TBL_REG(r) (NBL_IPRO_DN_PTYPE_TBL_ADDR + \
		(NBL_IPRO_DN_PTYPE_TBL_DWLEN * 4) * (r))

#define NBL_IPRO_UP_PTYPE_TBL_ADDR  (0xb06800)
#define NBL_IPRO_UP_PTYPE_TBL_DEPTH (256)
#define NBL_IPRO_UP_PTYPE_TBL_WIDTH (64)
#define NBL_IPRO_UP_PTYPE_TBL_DWLEN (2)
union ipro_up_ptype_tbl_u {
	struct ipro_up_ptype_tbl {
		u32 up_entry_vld:1;      /* [0] Default:0x0 RW */
		u32 up_mirror_en:1;      /* [1] Default:0x0 RW */
		u32 up_mirror_pri:2;     /* [3:2] Default:0x0 RW */
		u32 up_mirror_id:4;      /* [7:4] Default:0x0 RW */
		u32 up_decap_en:1;       /* [8] Default:0x0 RW */
		u32 up_decap_pri:2;      /* [10:9] Default:0x0 RW */
		u32 not_used_1:19;       /* [29:11] Default:0x0 RW */
		u32 proc_done:1;         /* [30] Default:0x0 RW */
		u32 set_dport_en:1;      /* [31] Default:0x0 RW */
		u32 set_dport:16;        /* [47:32] Default:0x0 RW */
		u32 set_dport_pri:2;     /* [49:48] Default:0x0 RW */
		u32 dqueue_pri:2;        /* [51:50] Default:0x0 RW */
		u32 dqueue:11;           /* [62:52] Default:0x0 RW */
		u32 dqueue_en:1;         /* [63] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_IPRO_UP_PTYPE_TBL_DWLEN];
} __packed;
#define NBL_IPRO_UP_PTYPE_TBL_REG(r) (NBL_IPRO_UP_PTYPE_TBL_ADDR + \
		(NBL_IPRO_UP_PTYPE_TBL_DWLEN * 4) * (r))

#define NBL_IPRO_QUEUE_TBL_ADDR  (0xb08000)
#define NBL_IPRO_QUEUE_TBL_DEPTH (2048)
#define NBL_IPRO_QUEUE_TBL_WIDTH (32)
#define NBL_IPRO_QUEUE_TBL_DWLEN (1)
union ipro_queue_tbl_u {
	struct ipro_queue_tbl {
		u32 vsi:10;              /* [9:0] Default:0x0 RW */
		u32 vsi_en:1;            /* [10] Default:0x0 RW */
		u32 rsv:21;              /* [31:11] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_QUEUE_TBL_DWLEN];
} __packed;
#define NBL_IPRO_QUEUE_TBL_REG(r) (NBL_IPRO_QUEUE_TBL_ADDR + \
		(NBL_IPRO_QUEUE_TBL_DWLEN * 4) * (r))

#define NBL_IPRO_UP_SRC_PORT_TBL_ADDR  (0xb0b000)
#define NBL_IPRO_UP_SRC_PORT_TBL_DEPTH (4)
#define NBL_IPRO_UP_SRC_PORT_TBL_WIDTH (64)
#define NBL_IPRO_UP_SRC_PORT_TBL_DWLEN (2)
union ipro_up_src_port_tbl_u {
	struct ipro_up_src_port_tbl {
		u32 entry_vld:1;         /* [0] Default:0x0 RW */
		u32 vlan_layer_num_0:2;  /* [2:1] Default:0x0 RW */
		u32 vlan_layer_num_1:2;  /* [4:3] Default:0x0 RW */
		u32 lag_vld:1;           /* [5] Default:0x0 RW */
		u32 lag_id:2;            /* [7:6] Default:0x0 RW */
		u32 phy_flow:1;          /* [8] Default:0x0 RW */
		u32 mirror_en:1;         /* [9] Default:0x0 RW */
		u32 mirror_pr:2;         /* [11:10] Default:0x0 RW */
		u32 mirror_id:4;         /* [15:12] Default:0x0 RW */
		u32 dqueue_pri:2;        /* [17:16] Default:0x0 RW */
		u32 set_dport_pri:2;     /* [19:18] Default:0x0 RW */
		u32 dqueue:11;           /* [30:20] Default:0x0 RW */
		u32 dqueue_en:1;         /* [31] Default:0x0 RW */
		u32 set_dport:16;        /* [47:32] Default:0x0 RW */
		u32 set_dport_en:1;      /* [48] Default:0x0 RW */
		u32 proc_done:1;         /* [49] Default:0x0 RW */
		u32 car_en:1;            /* [50] Default:0x0 RW */
		u32 car_pr:2;            /* [52:51] Default:0x0 RW */
		u32 car_id:10;           /* [62:53] Default:0x0 RW */
		u32 rsv:1;               /* [63] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_UP_SRC_PORT_TBL_DWLEN];
} __packed;
#define NBL_IPRO_UP_SRC_PORT_TBL_REG(r) (NBL_IPRO_UP_SRC_PORT_TBL_ADDR + \
		(NBL_IPRO_UP_SRC_PORT_TBL_DWLEN * 4) * (r))

#define NBL_IPRO_DN_SRC_PORT_TBL_ADDR  (0xb0c000)
#define NBL_IPRO_DN_SRC_PORT_TBL_DEPTH (1024)
#define NBL_IPRO_DN_SRC_PORT_TBL_WIDTH (128)
#define NBL_IPRO_DN_SRC_PORT_TBL_DWLEN (4)
union ipro_dn_src_port_tbl_u {
	struct ipro_dn_src_port_tbl {
		u32 entry_vld:1;         /* [0] Default:0x0 RW */
		u32 mirror_en:1;         /* [1] Default:0x0 RW */
		u32 mirror_pr:2;         /* [3:2] Default:0x0 RW */
		u32 mirror_id:4;         /* [7:4] Default:0x0 RW */
		u32 vlan_layer_num_1:2;  /* [9:8] Default:0x0 RW */
		u32 phy_flow:1;          /* [10] Default:0x0 RW */
		u32 mtu_sel:4;           /* [14:11] Default:0x0 RW */
		u32 addr_check_en:1;     /* [15] Default:0x0 RW */
		u32 smac_l:32;           /* [63:16] Default:0x0 RW */
		u32 smac_h:16;           /* [63:16] Default:0x0 RW */
		u32 dqueue:11;           /* [74:64] Default:0x0 RW */
		u32 dqueue_en:1;         /* [75] Default:0x0 RW */
		u32 dqueue_pri:2;        /* [77:76] Default:0x0 RW */
		u32 set_dport_pri:2;     /* [79:78] Default:0x0 RW */
		u32 set_dport:16;        /* [95:80] Default:0x0 RW */
		u32 set_dport_en:1;      /* [96] Default:0x0 RW */
		u32 proc_done:1;         /* [97] Default:0x0 RW */
		u32 not_used_1:2;        /* [99:98] Default:0x0 RW */
		u32 rsv:28;              /* [127:100] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_IPRO_DN_SRC_PORT_TBL_DWLEN];
} __packed;
#define NBL_IPRO_DN_SRC_PORT_TBL_REG(r) (NBL_IPRO_DN_SRC_PORT_TBL_ADDR + \
		(NBL_IPRO_DN_SRC_PORT_TBL_DWLEN * 4) * (r))

#endif
