; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -o - %s -mtriple=arm64-apple-ios7.0 | FileCheck %s

define i64 @test0() {
; CHECK-LABEL: test0:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x0, xzr
; CHECK-NEXT:    ret
; Not produced by move wide instructions, but good to make sure we can return 0 anyway:
  ret i64 0
}

define i64 @test1() {
; CHECK-LABEL: test1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w0, #1
; CHECK-NEXT:    ret
  ret i64 1
}

define i64 @test2() {
; CHECK-LABEL: test2:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w0, #65535
; CHECK-NEXT:    ret
  ret i64 65535
}

define i64 @test3() {
; CHECK-LABEL: test3:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w0, #65536
; CHECK-NEXT:    ret
  ret i64 65536
}

define i64 @test4() {
; CHECK-LABEL: test4:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w0, #-65536
; CHECK-NEXT:    ret
  ret i64 4294901760
}

define i64 @test5() {
; CHECK-LABEL: test5:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x0, #4294967296
; CHECK-NEXT:    ret
  ret i64 4294967296
}

define i64 @test6() {
; CHECK-LABEL: test6:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x0, #281470681743360
; CHECK-NEXT:    ret
  ret i64 281470681743360
}

define i64 @test7() {
; CHECK-LABEL: test7:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x0, #281474976710656
; CHECK-NEXT:    ret
  ret i64 281474976710656
}

; A 32-bit MOVN can generate some 64-bit patterns that a 64-bit one
; couldn't. Useful even for i64
define i64 @test8() {
; CHECK-LABEL: test8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w0, #-60876
; CHECK-NEXT:    ret
  ret i64 4294906420
}

define i64 @test9() {
; CHECK-LABEL: test9:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x0, #-1
; CHECK-NEXT:    ret
  ret i64 -1
}

define i64 @test10() {
; CHECK-LABEL: test10:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x0, #-3989504001
; CHECK-NEXT:    ret
  ret i64 18446744069720047615
}

; For reasonably legitimate reasons returning an i32 results in the
; selection of an i64 constant, so we need a different idiom to test that selection
@var32 = global i32 0

define void @test11() {
; CHECK-LABEL: test11:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    adrp x8, _var32@PAGE
; CHECK-NEXT:    str wzr, [x8, _var32@PAGEOFF]
; CHECK-NEXT:    ret
  store i32 0, ptr @var32
  ret void
}

define void @test12() {
; CHECK-LABEL: test12:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    adrp x8, _var32@PAGE
; CHECK-NEXT:    mov w9, #1
; CHECK-NEXT:    str w9, [x8, _var32@PAGEOFF]
; CHECK-NEXT:    ret
  store i32 1, ptr @var32
  ret void
}

define void @test13() {
; CHECK-LABEL: test13:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    adrp x8, _var32@PAGE
; CHECK-NEXT:    mov w9, #65535
; CHECK-NEXT:    str w9, [x8, _var32@PAGEOFF]
; CHECK-NEXT:    ret
  store i32 65535, ptr @var32
  ret void
}

define void @test14() {
; CHECK-LABEL: test14:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    adrp x8, _var32@PAGE
; CHECK-NEXT:    mov w9, #65536
; CHECK-NEXT:    str w9, [x8, _var32@PAGEOFF]
; CHECK-NEXT:    ret
  store i32 65536, ptr @var32
  ret void
}

define void @test15() {
; CHECK-LABEL: test15:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    adrp x8, _var32@PAGE
; CHECK-NEXT:    mov w9, #-65536
; CHECK-NEXT:    str w9, [x8, _var32@PAGEOFF]
; CHECK-NEXT:    ret
  store i32 4294901760, ptr @var32
  ret void
}

define void @test16() {
; CHECK-LABEL: test16:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    adrp x8, _var32@PAGE
; CHECK-NEXT:    mov w9, #-1
; CHECK-NEXT:    str w9, [x8, _var32@PAGEOFF]
; CHECK-NEXT:    ret
  store i32 -1, ptr @var32
  ret void
}

define i64 @test17() {
; CHECK-LABEL: test17:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x0, #-3
; CHECK-NEXT:    ret

  ; Mustn't MOVN w0 here.
  ret i64 -3
}
