/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUsageExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(KeyUsageExtDefault.class);
    public static final String CONFIG_CRITICAL = "keyUsageCritical";
    public static final String CONFIG_DIGITAL_SIGNATURE = "keyUsageDigitalSignature";
    public static final String CONFIG_NON_REPUDIATION = "keyUsageNonRepudiation";
    public static final String CONFIG_KEY_ENCIPHERMENT = "keyUsageKeyEncipherment";
    public static final String CONFIG_DATA_ENCIPHERMENT = "keyUsageDataEncipherment";
    public static final String CONFIG_KEY_AGREEMENT = "keyUsageKeyAgreement";
    public static final String CONFIG_KEY_CERTSIGN = "keyUsageKeyCertSign";
    public static final String CONFIG_CRL_SIGN = "keyUsageCrlSign";
    public static final String CONFIG_ENCIPHER_ONLY = "keyUsageEncipherOnly";
    public static final String CONFIG_DECIPHER_ONLY = "keyUsageDecipherOnly";
    public static final String VAL_CRITICAL = "keyUsageCritical";
    public static final String VAL_DIGITAL_SIGNATURE = "keyUsageDigitalSignature";
    public static final String VAL_NON_REPUDIATION = "keyUsageNonRepudiation";
    public static final String VAL_KEY_ENCIPHERMENT = "keyUsageKeyEncipherment";
    public static final String VAL_DATA_ENCIPHERMENT = "keyUsageDataEncipherment";
    public static final String VAL_KEY_AGREEMENT = "keyUsageKeyAgreement";
    public static final String VAL_KEY_CERTSIGN = "keyUsageKeyCertSign";
    public static final String VAL_CRL_SIGN = "keyUsageCrlSign";
    public static final String VAL_ENCIPHER_ONLY = "keyUsageEncipherOnly";
    public static final String VAL_DECIPHER_ONLY = "keyUsageDecipherOnly";

    public KeyUsageExtDefault() {
        this.addValueName("keyUsageCritical");
        this.addValueName("keyUsageDigitalSignature");
        this.addValueName("keyUsageNonRepudiation");
        this.addValueName("keyUsageKeyEncipherment");
        this.addValueName("keyUsageDataEncipherment");
        this.addValueName("keyUsageKeyAgreement");
        this.addValueName("keyUsageKeyCertSign");
        this.addValueName("keyUsageCrlSign");
        this.addValueName("keyUsageEncipherOnly");
        this.addValueName("keyUsageDecipherOnly");
        this.addConfigName("keyUsageCritical");
        this.addConfigName("keyUsageDigitalSignature");
        this.addConfigName("keyUsageNonRepudiation");
        this.addConfigName("keyUsageKeyEncipherment");
        this.addConfigName("keyUsageDataEncipherment");
        this.addConfigName("keyUsageKeyAgreement");
        this.addConfigName("keyUsageKeyCertSign");
        this.addConfigName("keyUsageCrlSign");
        this.addConfigName("keyUsageEncipherOnly");
        this.addConfigName("keyUsageDecipherOnly");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("keyUsageCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("keyUsageDigitalSignature")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DIGITAL_SIGNATURE", (String[])new String[0]));
        }
        if (name.equals("keyUsageNonRepudiation")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NON_REPUDIATION", (String[])new String[0]));
        }
        if (name.equals("keyUsageKeyEncipherment")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_ENCIPHERMENT", (String[])new String[0]));
        }
        if (name.equals("keyUsageDataEncipherment")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DATA_ENCIPHERMENT", (String[])new String[0]));
        }
        if (name.equals("keyUsageKeyAgreement")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_AGREEMENT", (String[])new String[0]));
        }
        if (name.equals("keyUsageKeyCertSign")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_CERTSIGN", (String[])new String[0]));
        }
        if (name.equals("keyUsageCrlSign")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRL_SIGN", (String[])new String[0]));
        }
        if (name.equals("keyUsageEncipherOnly")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENCIPHER_ONLY", (String[])new String[0]));
        }
        if (name.equals("keyUsageDecipherOnly")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DECIPHER_ONLY", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("keyUsageCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("keyUsageDigitalSignature")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DIGITAL_SIGNATURE", (String[])new String[0]));
        }
        if (name.equals("keyUsageNonRepudiation")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NON_REPUDIATION", (String[])new String[0]));
        }
        if (name.equals("keyUsageKeyEncipherment")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_ENCIPHERMENT", (String[])new String[0]));
        }
        if (name.equals("keyUsageDataEncipherment")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DATA_ENCIPHERMENT", (String[])new String[0]));
        }
        if (name.equals("keyUsageKeyAgreement")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_AGREEMENT", (String[])new String[0]));
        }
        if (name.equals("keyUsageKeyCertSign")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_CERTSIGN", (String[])new String[0]));
        }
        if (name.equals("keyUsageCrlSign")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRL_SIGN", (String[])new String[0]));
        }
        if (name.equals("keyUsageEncipherOnly")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENCIPHER_ONLY", (String[])new String[0]));
        }
        if (name.equals("keyUsageDecipherOnly")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DECIPHER_ONLY", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            KeyUsageExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("keyUsageCritical")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals("keyUsageDigitalSignature")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("digital_signature", (Object)val);
            } else if (name.equals("keyUsageNonRepudiation")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("non_repudiation", (Object)val);
            } else if (name.equals("keyUsageKeyEncipherment")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("key_encipherment", (Object)val);
            } else if (name.equals("keyUsageDataEncipherment")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("data_encipherment", (Object)val);
            } else if (name.equals("keyUsageKeyAgreement")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("key_agreement", (Object)val);
            } else if (name.equals("keyUsageKeyCertSign")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("key_certsign", (Object)val);
            } else if (name.equals("keyUsageCrlSign")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("crl_sign", (Object)val);
            } else if (name.equals("keyUsageEncipherOnly")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("encipher_only", (Object)val);
            } else if (name.equals("keyUsageDecipherOnly")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("decipher_only", (Object)val);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(PKIXExtensions.KeyUsage_Id.toString(), (Extension)ext, info);
        }
        catch (IOException e) {
            logger.error("KeyUsageExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (EProfileException e) {
            logger.error("KeyUsageExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        try {
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            KeyUsageExtension ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
            if (ext == null) {
                try {
                    this.populate(null, info);
                }
                catch (EProfileException e) {
                    throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                }
            }
            if (name.equals("keyUsageCritical")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                return ext.isCritical() ? "true" : "false";
            }
            if (name.equals("keyUsageDigitalSignature")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("digital_signature");
                return val.toString();
            }
            if (name.equals("keyUsageNonRepudiation")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("non_repudiation");
                return val.toString();
            }
            if (name.equals("keyUsageKeyEncipherment")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("key_encipherment");
                return val.toString();
            }
            if (name.equals("keyUsageDataEncipherment")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("data_encipherment");
                return val.toString();
            }
            if (name.equals("keyUsageKeyAgreement")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("key_agreement");
                return val.toString();
            }
            if (name.equals("keyUsageKeyCertSign")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("key_certsign");
                return val.toString();
            }
            if (name.equals("keyUsageCrlSign")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("crl_sign");
                return val.toString();
            }
            if (name.equals("keyUsageEncipherOnly")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("encipher_only");
                return val.toString();
            }
            if (name.equals("keyUsageDecipherOnly")) {
                ext = (KeyUsageExtension)this.getExtension(PKIXExtensions.KeyUsage_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("decipher_only");
                return val.toString();
            }
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (IOException e) {
            logger.error("KeyUsageExtDefault: getValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("keyUsageCritical"), this.getConfig("keyUsageDigitalSignature"), this.getConfig("keyUsageNonRepudiation"), this.getConfig("keyUsageKeyEncipherment"), this.getConfig("keyUsageDataEncipherment"), this.getConfig("keyUsageKeyAgreement"), this.getConfig("keyUsageKeyCertSign"), this.getConfig("keyUsageCrlSign"), this.getConfig("keyUsageEncipherOnly"), this.getConfig("keyUsageDecipherOnly")};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_KEY_USAGE_EXT", (String[])params);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        KeyUsageExtension ext = this.createKeyUsageExtension();
        this.addExtension(PKIXExtensions.KeyUsage_Id.toString(), (Extension)ext, info);
    }

    public KeyUsageExtension createKeyUsageExtension() {
        KeyUsageExtension ext = null;
        boolean[] bits = new boolean[9];
        boolean critical = this.getConfigBoolean("keyUsageCritical");
        bits[0] = this.getConfigBoolean("keyUsageDigitalSignature");
        bits[1] = this.getConfigBoolean("keyUsageNonRepudiation");
        bits[2] = this.getConfigBoolean("keyUsageKeyEncipherment");
        bits[3] = this.getConfigBoolean("keyUsageDataEncipherment");
        bits[4] = this.getConfigBoolean("keyUsageKeyAgreement");
        bits[5] = this.getConfigBoolean("keyUsageKeyCertSign");
        bits[6] = this.getConfigBoolean("keyUsageCrlSign");
        bits[7] = this.getConfigBoolean("keyUsageEncipherOnly");
        bits[8] = this.getConfigBoolean("keyUsageDecipherOnly");
        try {
            ext = new KeyUsageExtension(critical, bits);
        }
        catch (Exception e) {
            logger.warn("KeyUsageExtDefault: createKeyUsageExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

