/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.input;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.ProofOfPossession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrollInput
extends ProfileInput {
    public static Logger logger = LoggerFactory.getLogger(EnrollInput.class);
    protected ConfigStore mConfig;
    protected Vector<String> mValueNames = new Vector();
    protected Vector<String> mConfigNames = new Vector();
    protected Profile mProfile = null;

    @Override
    public void init(Profile profile, ConfigStore config) throws EProfileException {
        this.mConfig = config;
        this.mProfile = profile;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    @Override
    public abstract void populate(Map<String, String> var1, Request var2) throws Exception;

    @Override
    public abstract String getName(Locale var1);

    @Override
    public abstract String getText(Locale var1);

    @Override
    public abstract IDescriptor getValueDescriptor(Locale var1, String var2);

    public void addValueName(String name) {
        this.mValueNames.addElement(name);
    }

    @Override
    public Enumeration<String> getValueNames() {
        return this.mValueNames.elements();
    }

    public void addConfigName(String name) {
        this.mConfigNames.addElement(name);
    }

    public Enumeration<String> getConfigNames() {
        return this.mConfigNames.elements();
    }

    public void setConfig(String name, String value) throws EPropertyException {
        if (this.mConfig.getSubStore("params") != null) {
            this.mConfig.getSubStore("params").putString(name, value);
        }
    }

    public String getConfig(String name) {
        try {
            if (this.mConfig == null) {
                return null;
            }
            if (this.mConfig.getSubStore("params") != null) {
                return this.mConfig.getSubStore("params").getString(name);
            }
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        return "";
    }

    public String getDefaultConfig(String name) {
        return null;
    }

    @Override
    public String getValue(String name, Locale locale, Request request) throws EProfileException {
        return request.getExtDataInString(name);
    }

    @Override
    public void setValue(String name, Locale locale, Request request, String value) throws EPropertyException {
        request.setExtData(name, value);
    }

    public Locale getLocale(Request request) {
        Locale locale = null;
        String language = request.getExtDataInString("req_locale");
        if (language != null) {
            locale = new Locale(language);
        }
        return locale;
    }

    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        return null;
    }

    public void verifyPOP(Locale locale, CertReqMsg certReqMsg) throws EProfileException {
        String method = "EnrollInput: verifyPOP: ";
        logger.debug("EnrollInput ::in verifyPOP");
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        if (!certReqMsg.hasPop()) {
            logger.debug(method + "CertReqMsg has not POP, return");
            return;
        }
        ProofOfPossession pop = certReqMsg.getPop();
        ProofOfPossession.Type popType = pop.getType();
        if (popType != ProofOfPossession.SIGNATURE) {
            logger.debug(method + "not POP SIGNATURE, return");
            return;
        }
        CAEngineConfig cs = engine.getConfig();
        try {
            if (cs.getBoolean("cms.skipPOPVerify", false)) {
                logger.debug(method + "skipPOPVerify on, return");
                return;
            }
            logger.debug("POP verification begins:");
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken verifyToken = null;
            String tokenName = cs.getString("ca.requestVerify.token", "internal");
            if (CryptoUtil.isInternalToken((String)tokenName)) {
                logger.debug(method + "POP verification using internal token");
                certReqMsg.verify();
            } else {
                logger.debug(method + "POP verification using token:" + tokenName);
                verifyToken = CryptoUtil.getCryptoToken((String)tokenName);
                certReqMsg.verify(verifyToken);
            }
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", (Object[])new Object[]{auditSubjectID, "Success", "method=" + method});
            auditor.log(auditMessage);
        }
        catch (Exception e) {
            logger.error(method + "Failed POP verify! " + e.getMessage(), (Throwable)e);
            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_PROOF_OF_POSSESSION_3", (Object[])new Object[]{auditSubjectID, "Failure", method + e.toString()});
            auditor.log(auditMessage);
            throw new EProfileException(CMS.getUserMessage((Locale)locale, (String)"CMS_POP_VERIFICATION_ERROR", (String[])new String[0]));
        }
    }

    protected String auditSubjectID() {
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        subjectID = auditContext != null ? ((subjectID = (String)auditContext.get((Object)"userid")) != null ? subjectID.trim() : "$NonRoleUser$") : "$Unidentified$";
        return subjectID;
    }
}

