/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.PrivateKeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyUsagePeriodExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(PrivateKeyUsagePeriodExt.class);
    private static final String PROP_NOT_BEFORE = "notBefore";
    private static final String PROP_NOT_AFTER = "notAfter";
    protected static final String PROP_IS_CRITICAL = "critical";
    private static final long defDuration = 15552000000L;
    private static final String DATE_PATTERN = "MM/dd/yyyy";
    static SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
    private static Date now = new Date();
    private static Date six_months = new Date(now.getTime() + 15552000000L);
    public static final String DEFAULT_NOT_BEFORE = formatter.format(now);
    public static final String DEFAULT_NOT_AFTER = formatter.format(six_months);
    public static final boolean DEFAULT_CRITICALITY = false;
    protected String mNotBefore;
    protected String mNotAfter;
    protected boolean mCritical;
    private static Vector<String> defaultParams;

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"critical;boolean;RFC 2459 recommendation: The profile recommends against the use of this extension. CAs conforming to the profile MUST NOT generate certs with critical private key usage period extensions.", "notBefore;string; Date before which the Private Key is invalid.", "notAfter;string; Date after which the Private Key is invalid.", "HELP_TOKEN;configuration-policyrules-privatekeyusageperiod", "HELP_TEXT;Adds (deprecated) Private Key Usage Period Extension. Defined in RFC 2459 (4.2.1.4)"};
        return params;
    }

    public PrivateKeyUsagePeriodExt() {
        this.NAME = "PrivateKeyUsagePeriodExt";
        this.DESC = "Sets Private Key Usage Extension for a certificate";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        try {
            this.mNotBefore = config.getString(PROP_NOT_BEFORE, null);
            this.mNotAfter = config.getString(PROP_NOT_AFTER, null);
            this.mCritical = config.getBoolean(PROP_IS_CRITICAL, false);
            formatter.format(formatter.parse(this.mNotBefore.trim()));
            formatter.format(formatter.parse(this.mNotAfter.trim()));
        }
        catch (Exception e) {
            Object[] params = new Object[]{this.getInstanceName(), e};
            throw new EPolicyException(CMS.getUserMessage((String)"CMS_POLICY_INVALID_POLICY_CONFIG", (String[])new String[0]), params);
        }
    }

    public PolicyResult apply(Request req) {
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        CertificateExtensions extensions = null;
        PrivateKeyUsageExtension ext = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (extensions == null) {
            extensions = new CertificateExtensions();
        } else {
            try {
                extensions.delete("PrivateKeyUsage");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            ext = new PrivateKeyUsageExtension(formatter.parse(this.mNotBefore), formatter.parse(this.mNotAfter));
            certInfo.set("version", (Object)new CertificateVersion(2));
            extensions.set("PrivateKeyUsage", (Object)ext);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            logger.error(CMS.getLogMessage((String)"POLICY_ERROR_CREATE_PRIVATE_KEY_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_SUBJECT_KEY_ID_ERROR", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        return PolicyResult.ACCEPTED;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        params.addElement("critical=" + this.mCritical);
        params.addElement("notBefore=" + this.mNotBefore);
        params.addElement("notAfter=" + this.mNotAfter);
        return params;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("critical=false");
        defParams.addElement("notBefore=" + DEFAULT_NOT_BEFORE);
        defParams.addElement("notAfter=" + DEFAULT_NOT_AFTER);
        return defParams;
    }

    static {
        formatter.setLenient(false);
        defaultParams = new Vector();
        defaultParams.addElement("critical=false");
        defaultParams.addElement("notBefore=" + DEFAULT_NOT_BEFORE);
        defaultParams.addElement("notAfter=" + DEFAULT_NOT_AFTER);
    }
}

