/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.account;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.base.RESTMessage;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Account
extends RESTMessage {
    String id;
    @JsonProperty(value="FullName")
    String fullName;
    @JsonProperty(value="Email")
    String email;
    @JsonProperty(value="Roles")
    Collection<String> roles = new TreeSet<String>();

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Collection<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Collection<String> roles) {
        this.roles.clear();
        this.roles.addAll(roles);
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Account other = (Account)obj;
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
    }

    @Override
    public Element toDOM(Document document) {
        Element accountElement = document.createElement("Account");
        accountElement.setAttribute("id", this.id);
        this.toDOM(document, accountElement);
        if (this.fullName != null) {
            Element fullNameElement = document.createElement("FullName");
            fullNameElement.appendChild(document.createTextNode(this.fullName));
            accountElement.appendChild(fullNameElement);
        }
        if (this.email != null) {
            Element emailElement = document.createElement("Email");
            emailElement.appendChild(document.createTextNode(this.email));
            accountElement.appendChild(emailElement);
        }
        if (!this.roles.isEmpty()) {
            Element rolesElement = document.createElement("Roles");
            accountElement.appendChild(rolesElement);
            for (String role : this.roles) {
                Element roleElement = document.createElement("Role");
                roleElement.appendChild(document.createTextNode(role));
                rolesElement.appendChild(roleElement);
            }
        }
        return accountElement;
    }

    public static Account fromDOM(Element accountElement) {
        NodeList roleList;
        int length;
        NodeList emailList;
        Account account = new Account();
        String id = accountElement.getAttribute("id");
        account.setID(id);
        Account.fromDOM(accountElement, account);
        NodeList fullNameList = accountElement.getElementsByTagName("FullName");
        if (fullNameList.getLength() > 0) {
            String value = fullNameList.item(0).getTextContent();
            account.setFullName(value);
        }
        if ((emailList = accountElement.getElementsByTagName("Email")).getLength() > 0) {
            String email = emailList.item(0).getTextContent();
            account.setEmail(email);
        }
        if ((length = (roleList = accountElement.getElementsByTagName("Role")).getLength()) > 0) {
            for (int i = 0; i < length; ++i) {
                String role = roleList.item(i).getTextContent();
                account.addRole(role);
            }
        }
        return account;
    }

    @Override
    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element accountElement = this.toDOM(document);
        document.appendChild(accountElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static Account fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element accountElement = document.getDocumentElement();
        return Account.fromDOM(accountElement);
    }

    @Override
    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

