/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.client;

import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKICertificateApprovalCallback;
import com.netscape.certsrv.client.PKIConnection;
import com.netscape.certsrv.util.CryptoProvider;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.dogtagpki.common.Info;
import org.dogtagpki.common.InfoClient;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIClient
implements AutoCloseable {
    public static Logger logger = LoggerFactory.getLogger(PKIClient.class);
    public static final String[] MESSAGE_FORMATS = new String[]{"json", "xml"};
    public ClientConfig config;
    public PKIConnection connection;
    public MediaType messageFormat;
    public CryptoProvider crypto;
    public InfoClient infoClient;
    public Info info;
    Collection<Integer> rejectedCertStatuses = new HashSet<Integer>();
    Collection<Integer> ignoredCertStatuses = new HashSet<Integer>();
    Collection<Integer> statuses = new HashSet<Integer>();

    public PKIClient(ClientConfig config) throws Exception {
        this(config, null, null);
    }

    public PKIClient(ClientConfig config, CryptoProvider crypto) throws Exception {
        this(config, crypto, null);
    }

    public PKIClient(ClientConfig config, CryptoProvider crypto, SSLCertificateApprovalCallback callback) throws Exception {
        this.config = config;
        this.crypto = crypto;
        this.connection = new PKIConnection(config);
        if (callback == null) {
            callback = new PKICertificateApprovalCallback(this);
        }
        this.connection.setCallback(callback);
        String messageFormat = config.getMessageFormat();
        if (messageFormat == null) {
            messageFormat = MESSAGE_FORMATS[0];
        }
        if (!Arrays.asList(MESSAGE_FORMATS).contains(messageFormat)) {
            throw new Error("Unsupported message format: " + messageFormat);
        }
        this.messageFormat = MediaType.valueOf((String)("application/" + messageFormat));
    }

    public MediaType getMessageFormat() {
        return this.messageFormat;
    }

    public String getSubsystem() {
        return this.config.getSubsystem();
    }

    public Object marshall(Object request) throws Exception {
        block5: {
            Class<?> clazz = request.getClass();
            try {
                if (MediaType.APPLICATION_XML_TYPE.isCompatible(this.messageFormat)) {
                    Method method = clazz.getMethod("toXML", new Class[0]);
                    request = method.invoke(request, new Object[0]);
                    break block5;
                }
                if (MediaType.APPLICATION_JSON_TYPE.isCompatible(this.messageFormat)) {
                    Method method = clazz.getMethod("toJSON", new Class[0]);
                    request = method.invoke(request, new Object[0]);
                    break block5;
                }
                throw new Exception("Unsupported request format: " + this.messageFormat);
            }
            catch (NoSuchMethodException e) {
                logger.info("PKIClient: " + clazz.getSimpleName() + " has no custom mapping for " + this.messageFormat);
            }
            catch (Exception e) {
                logger.error("PKIClient: Unable to marshall request: " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T unmarshall(Response response, Class<T> clazz) throws Exception {
        MediaType responseFormat = response.getMediaType();
        try {
            if (MediaType.APPLICATION_XML_TYPE.isCompatible(responseFormat)) {
                Method method = clazz.getMethod("fromXML", String.class);
                String xml = (String)response.readEntity(String.class);
                return (T)method.invoke(null, xml);
            }
            if (!MediaType.APPLICATION_JSON_TYPE.isCompatible(responseFormat)) return (T)response.readEntity(clazz);
        }
        catch (NoSuchMethodException e) {
            logger.info("PKIClient: " + clazz.getSimpleName() + " has no custom mapping for " + responseFormat);
            return (T)response.readEntity(clazz);
        }
        catch (Exception e) {
            logger.error("PKIClient: Unable to unmarshall response: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return (T)response.readEntity(clazz);
    }

    public void handleErrorResponse(Response response) throws Exception {
        MediaType contentType = response.getMediaType();
        if (!MediaType.APPLICATION_XML_TYPE.isCompatible(contentType) && !MediaType.APPLICATION_JSON_TYPE.isCompatible(contentType)) {
            Response.StatusType status = response.getStatusInfo();
            throw new PKIException(status.getStatusCode(), status.getReasonPhrase());
        }
        PKIException.Data data = this.unmarshall(response, PKIException.Data.class);
        String className = data.getClassName();
        Class<PKIException> exceptionClass = Class.forName(className).asSubclass(PKIException.class);
        Constructor<PKIException> constructor = exceptionClass.getConstructor(PKIException.Data.class);
        throw constructor.newInstance(data);
    }

    public <T> Entity<T> entity(T object) throws Exception {
        return Entity.entity(object, (MediaType)this.messageFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getEntity(Response response, Class<T> clazz) throws Exception {
        try {
            Response.Status.Family family = response.getStatusInfo().getFamily();
            if (family.equals((Object)Response.Status.Family.CLIENT_ERROR) || family.equals((Object)Response.Status.Family.SERVER_ERROR)) {
                this.handleErrorResponse(response);
                T t = null;
                return t;
            }
            if (!response.hasEntity()) {
                T t = null;
                return t;
            }
            T t = this.unmarshall(response, clazz);
            return t;
        }
        finally {
            response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getEntity(Response response, GenericType<T> clazz) throws Exception {
        try {
            Response.Status.Family family = response.getStatusInfo().getFamily();
            if (family.equals((Object)Response.Status.Family.CLIENT_ERROR) || family.equals((Object)Response.Status.Family.SERVER_ERROR)) {
                this.handleErrorResponse(response);
                T t = null;
                return t;
            }
            if (!response.hasEntity()) {
                T t = null;
                return t;
            }
            Object object = response.readEntity(clazz);
            return (T)object;
        }
        finally {
            response.close();
        }
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public CryptoProvider getCrypto() {
        return this.crypto;
    }

    public void setCrypto(CryptoProvider crypto) {
        this.crypto = crypto;
    }

    public PKIConnection getConnection() {
        return this.connection;
    }

    public WebTarget target(String path, Map<String, Object> params) {
        WebTarget target = this.connection.target(path);
        if (params != null) {
            for (String name : params.keySet()) {
                Object value = params.get(name);
                if (value == null) continue;
                target = target.queryParam(name, new Object[]{value});
            }
        }
        return target;
    }

    public <T> T get(String path, Class<T> responseType) throws Exception {
        return this.get(path, null, responseType);
    }

    public <T> T get(String path, Map<String, Object> params, Class<T> responseType) throws Exception {
        WebTarget target = this.target(path, params);
        Response response = target.request().get();
        return this.getEntity(response, responseType);
    }

    public <T> T get(String path, Map<String, Object> params, GenericType<T> responseType) throws Exception {
        WebTarget target = this.target(path, params);
        Response response = target.request().get();
        return this.getEntity(response, responseType);
    }

    public <T> T post(String path, Class<T> responseType) throws Exception {
        return this.post(path, (Map<String, Object>)null, responseType);
    }

    public <T> T post(String path, Map<String, Object> params, Class<T> responseType) throws Exception {
        return this.post(path, params, null, responseType);
    }

    public <T> T post(String path, Map<String, Object> params, Entity<?> entity, Class<T> responseType) throws Exception {
        WebTarget target = this.target(path, params);
        Response response = target.request().post(entity);
        return this.getEntity(response, responseType);
    }

    public <T> T post(String path, MultivaluedMap<String, String> content, Class<T> responseType) throws Exception {
        WebTarget target = this.connection.target(path);
        Response response = target.request().post(Entity.form(content));
        return this.getEntity(response, responseType);
    }

    public <T> T put(String path, Map<String, Object> params, Entity<?> entity, Class<T> responseType) throws Exception {
        WebTarget target = this.target(path, params);
        Response response = target.request().put(entity);
        return this.getEntity(response, responseType);
    }

    public <T> T patch(String path, Map<String, Object> params, Entity<?> entity, Class<T> responseType) throws Exception {
        WebTarget target = this.target(path, params);
        Response response = target.request().method("PATCH", entity);
        return this.getEntity(response, responseType);
    }

    public <T> T delete(String path, Class<T> responseType) throws Exception {
        Response response = this.connection.target(path).request().delete();
        return this.getEntity(response, responseType);
    }

    public <T> T delete(String path, Map<String, Object> params, Class<T> responseType) throws Exception {
        WebTarget target = this.target(path, params);
        Response response = target.request().delete();
        return this.getEntity(response, responseType);
    }

    public Info getInfo() throws Exception {
        if (this.infoClient == null) {
            this.infoClient = new InfoClient(this);
            this.info = this.infoClient.getInfo();
        }
        return this.info;
    }

    public void addRejectedCertStatus(Integer rejectedCertStatus) {
        this.rejectedCertStatuses.add(rejectedCertStatus);
    }

    public void setRejectedCertStatuses(Collection<Integer> rejectedCertStatuses) {
        this.rejectedCertStatuses.clear();
        if (rejectedCertStatuses == null) {
            return;
        }
        this.rejectedCertStatuses.addAll(rejectedCertStatuses);
    }

    public boolean isRejected(Integer certStatus) {
        return this.rejectedCertStatuses.contains(certStatus);
    }

    public void addIgnoredCertStatus(Integer ignoredCertStatus) {
        this.ignoredCertStatuses.add(ignoredCertStatus);
    }

    public void setIgnoredCertStatuses(Collection<Integer> ignoredCertStatuses) {
        this.ignoredCertStatuses.clear();
        if (ignoredCertStatuses == null) {
            return;
        }
        this.ignoredCertStatuses.addAll(ignoredCertStatuses);
    }

    public boolean isIgnored(Integer certStatus) {
        return this.ignoredCertStatuses.contains(certStatus);
    }

    public void setOutput(File output) {
        this.connection.setOutput(output);
    }

    @Override
    public void close() {
        this.connection.close();
    }
}

