/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.dogtagpki.tps.msg.TPSMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSConnection {
    public static final int MAX_MESSAGE_SIZE_DEFAULT = 9999;
    private static int maxMessageSize = 9999;
    public static Logger logger = LoggerFactory.getLogger(TPSConnection.class);
    public InputStream in;
    public PrintStream out;
    public boolean chunked;

    public TPSConnection(InputStream in, OutputStream out) {
        this(in, out, false);
    }

    public TPSConnection(InputStream in, OutputStream out, boolean chunked) {
        this.in = in;
        this.out = new PrintStream(out);
        this.chunked = chunked;
    }

    public TPSMessage read() throws IOException {
        char c;
        logger.debug("TPSConnection read()");
        StringBuilder sb = new StringBuilder();
        int maxMessageSizeNumDigits = 1;
        for (int i = maxMessageSize; i != 0; i /= 10) {
            ++maxMessageSizeNumDigits;
        }
        int b = this.in.read();
        if (b < 0) {
            throw new IOException("Unexpected end of stream");
        }
        sb.append((char)b);
        b = this.in.read();
        if (b != 61) {
            throw new IOException("Unexpected end of stream");
        }
        sb.append((char)b);
        while ((b = this.in.read()) >= 0 && maxMessageSizeNumDigits-- > 0 && (c = (char)b) != '&') {
            sb.append(c);
        }
        if (b < 0) {
            throw new IOException("Unexpected end of stream");
        }
        if (b != 38) {
            throw new IOException("Received message size is too large.");
        }
        String nvp = sb.toString();
        String[] s = nvp.split("=");
        int size = Integer.parseInt(s[1]);
        if (size > maxMessageSize) {
            throw new IOException("Received message size is too large.");
        }
        sb.append('&');
        for (int i = 0; i < size; ++i) {
            b = this.in.read();
            if (b < 0) {
                throw new IOException("Unexpected end of stream");
            }
            char c2 = (char)b;
            sb.append(c2);
        }
        if (size <= 38) {
            logger.debug("TPSConnection.read: Reading:  " + sb);
        } else {
            logger.debug("TPSConnection.read: Reading...");
        }
        return TPSMessage.createMessage(sb.toString());
    }

    public void write(TPSMessage message) throws IOException {
        String s = message.encode();
        int idx = s.lastIndexOf("pdu_data=");
        boolean debug = false;
        String toDebug = null;
        if (idx == -1 || debug) {
            logger.debug("TPSConnection.write: Writing: " + s);
        } else {
            toDebug = s.substring(0, idx - 1);
            logger.debug("TPSConnection.write: Writing: " + toDebug + "pdu_data=<do not print>");
        }
        this.out.print(s);
        this.out.flush();
    }

    public static int getMaxMessageSize() {
        return maxMessageSize;
    }

    public static void setMaxMessageSize(int maxSize) {
        if (maxSize > 0) {
            maxMessageSize = maxSize;
        } else {
            logger.debug("TPSConnection: Cannot set maxMessageSize to out-of-range value: " + maxSize);
        }
    }
}

