/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cms.authentication.DirBasedAuthentication;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.authentication.AuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UidPwdDirAuthentication
extends DirBasedAuthentication {
    public static Logger logger = LoggerFactory.getLogger(UidPwdDirAuthentication.class);
    public static final String CRED_UID = "uid";
    public static final String CRED_PWD = "pwd";
    protected static String[] mRequiredCreds = new String[]{"uid", "pwd"};
    protected static String[] mConfigParams = new String[]{"dnpattern", "ldapStringAttributes", "ldapByteAttributes", "ldap.ldapconn.host", "ldap.ldapconn.port", "ldap.ldapconn.secureConn", "ldap.ldapconn.version", "ldap.basedn", "ldap.minConns", "ldap.maxConns"};

    private String getGroupBaseDN() {
        return this.mGroups + "," + this.mGroupsBaseDN;
    }

    private ArrayList<String> listGroups(LDAPConnection ldapconn, String uid, String userdn) throws EUsrGrpException, LDAPException {
        String method = "UidPwdDirAuthentication: listGroups: ";
        logger.debug(method + " begins");
        String[] attrs = new String[]{};
        String k = null;
        if (this.mGroupObjectClass.equalsIgnoreCase("groupOfUniqueNames")) {
            k = "uniquemember";
        } else if (this.mGroupObjectClass.equalsIgnoreCase("groupOfNames")) {
            k = "member";
        } else {
            logger.warn("UidPwdDirAuthentication: isMemberOfLdapGroup: unrecognized mGroupObjectClass: " + this.mGroupObjectClass);
            return null;
        }
        String filter = null;
        filter = this.mSearchGroupUserByUserdn ? k + "=" + LDAPUtil.escapeFilter((Object)userdn) : k + "=" + this.mGroupUserIDName + "=" + LDAPUtil.escapeFilter((Object)uid);
        logger.debug(method + "searching " + this.getGroupBaseDN() + " for (&(objectclass=" + this.mGroupObjectClass + ")(" + filter + "))");
        LDAPSearchResults res = ldapconn.search(this.getGroupBaseDN(), 2, "(&(objectclass=" + this.mGroupObjectClass + ")(" + filter + "))", attrs, true);
        logger.debug(method + " ends");
        return this.buildGroups(res);
    }

    private ArrayList<String> buildGroups(LDAPSearchResults res) {
        ArrayList<String> v = new ArrayList<String>();
        while (res.hasMoreElements()) {
            LDAPEntry entry = (LDAPEntry)res.nextElement();
            String groupDN = entry.getDN();
            logger.debug("UidPwdDirAuthentication: Authenticate: Found group membership: " + groupDN);
            v.add(groupDN);
        }
        return v;
    }

    @Override
    protected String authenticate(LDAPConnection conn, AuthCredentials authCreds, AuthToken token) throws EBaseException {
        String uid = null;
        try {
            uid = (String)authCreds.get(CRED_UID);
            logger.info("Authenticating UID " + uid);
            if (uid == null) {
                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", CRED_UID));
            }
            String pwd = (String)authCreds.get(CRED_PWD);
            if (pwd == null) {
                throw new EMissingCredential(CMS.getUserMessage("CMS_AUTHENTICATION_NULL_CREDENTIAL", CRED_PWD));
            }
            if (pwd.equals("")) {
                logger.error("UidPwdDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_EMPTY_PASSWORD", uid));
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
            }
            String[] emptyAttrs = new String[]{};
            String[] groupAttrs = new String[]{"memberOf"};
            logger.info("UidPwdDirAuthentication: Searching for user " + uid);
            logger.info("UidPwdDirAuthentication: - base DN: " + this.mBaseDN);
            String filter = "(" + this.mUserIDName + "=" + LDAPUtil.escapeFilter((Object)uid) + ")";
            logger.info("UidPwdDirAuthentication: - filter: " + filter);
            String[] attrs = this.mGroupsEnable ? groupAttrs : emptyAttrs;
            logger.info("DirBasedAuthentication: - attributes:");
            for (String attr : attrs) {
                logger.info("DirBasedAuthentication:   - " + attr);
            }
            LDAPSearchResults results = conn.search(this.mBaseDN, 2, filter, attrs, false);
            if (!results.hasMoreElements()) {
                logger.error("UidPwdDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_USER_NOT_EXIST", uid));
                throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
            }
            LDAPEntry entry = results.next();
            String userdn = entry.getDN();
            logger.debug("UidPwdDirAuthentication: Found user " + userdn);
            conn.authenticate(userdn, pwd);
            LDAPAttribute attribute = entry.getAttribute("memberOf");
            if (attribute != null) {
                logger.debug("UidPwdDirAuthentication: Authenticate: Found memberOf attribute");
                String[] groups = attribute.getStringValueArray();
                token.set("groups", groups);
            } else if (this.mGroupsEnable) {
                logger.debug("UidPwdDirAuthentication: Authenticate: memberOf attribute not found.");
                ArrayList<String> groups = null;
                groups = this.listGroups(conn, uid, userdn);
                if (groups != null) {
                    String[] groupsArray = new String[groups.size()];
                    token.set("groups", groups.toArray(groupsArray));
                }
            }
            token.set(CRED_UID, uid);
            token.set("userid", uid);
            return userdn;
        }
        catch (LDAPException e) {
            logger.error("Authenticating: User authentication failure: " + e.getMessage(), (Throwable)e);
            logger.debug("Authenticating: closing bad connection");
            try {
                conn.disconnect();
            }
            catch (Exception f) {
                logger.warn("Authenticating: conn.disconnect() exception =" + f.getMessage(), (Throwable)e);
            }
            switch (e.getLDAPResultCode()) {
                case 9: 
                case 32: {
                    logger.error("UidPwdDirAuthentication: " + CMS.getLogMessage("USER_NOT_EXIST", uid));
                    throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                }
                case 49: {
                    logger.error("UidPwdDirAuthentication: " + CMS.getLogMessage("CMS_AUTH_BAD_PASSWORD", uid));
                    throw new EInvalidCredentials(CMS.getUserMessage("CMS_AUTHENTICATION_INVALID_CREDENTIAL", new String[0]));
                }
                case 81: {
                    logger.error("UidPwdDirAuthentication: " + CMS.getLogMessage("LDAP_SERVER_DOWN", new Object[0]));
                    throw new ELdapException(CMS.getUserMessage("CMS_LDAP_SERVER_UNAVAILABLE", conn.getHost(), "" + conn.getPort()));
                }
            }
            logger.error("UidPwdDirAuthentication: " + CMS.getLogMessage("OPERATION_ERROR", e.getMessage()));
            throw new ELdapException(CMS.getUserMessage("CMS_LDAP_OTHER_LDAP_EXCEPTION", e.errorCodeToString()));
        }
    }

    @Override
    public String[] getConfigParams() {
        return mConfigParams;
    }

    @Override
    public String[] getRequiredCreds() {
        return mRequiredCreds;
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_UID_NAME", new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_UID_TEXT", new String[0]);
    }

    @Override
    public Enumeration<String> getValueNames() {
        Vector<String> v = new Vector<String>();
        v.addElement(CRED_UID);
        v.addElement(CRED_PWD);
        return v.elements();
    }

    @Override
    public boolean isValueWriteable(String name) {
        if (name.equals(CRED_UID)) {
            return true;
        }
        if (name.equals(CRED_PWD)) {
            return false;
        }
        return false;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(CRED_UID)) {
            return new Descriptor("string", null, null, CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_UID", new String[0]));
        }
        if (name.equals(CRED_PWD)) {
            return new Descriptor("password", null, null, CMS.getUserMessage(locale, "CMS_AUTHENTICATION_LDAP_PWD", new String[0]));
        }
        return null;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
        request.setExtData("authenticatedName", token.getInString("userDN"));
    }

    @Override
    public boolean isSSLClientRequired() {
        return false;
    }

    static {
        mExtendedPluginInfo.add("HELP_TEXT;Authenticate the username and password provided by the user against an LDAP directory. Works with the Dir Based Enrollment HTML form");
        mExtendedPluginInfo.add("HELP_TOKEN;configuration-authrules-uidpwddirauth");
    }
}

