/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.logging;

import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.logging.SignedAuditEvent;
import com.netscape.cmscore.apps.CMS;
import java.util.Vector;

public class LogQueue {
    private static LogQueue INSTANCE = new LogQueue();
    protected Vector<LogEventListener> mListeners = new Vector();

    public static LogQueue getInstance() {
        return INSTANCE;
    }

    public void init() {
        this.mListeners.clear();
    }

    public void shutdown() {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            LogEventListener listener = this.mListeners.elementAt(i);
            listener.shutdown();
        }
    }

    public void addLogEventListener(LogEventListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.addElement(listener);
        }
    }

    public void removeLogEventListener(LogEventListener listener) {
        this.mListeners.removeElement(listener);
    }

    public void log(LogEvent event) {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            boolean isAudit = false;
            if (event instanceof SignedAuditEvent) {
                isAudit = true;
            }
            try {
                this.mListeners.elementAt(i).log(event);
                continue;
            }
            catch (Exception e) {
                if (!isAudit) continue;
                System.err.println(CMS.getUserMessage("CMS_LOG_WRITE_FAILED", event.getEventType(), e.toString(), "Audit Event Failure!"));
            }
        }
    }

    public void flush() {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.elementAt(i).flush();
        }
    }
}

