/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.event.ConfigRoleEvent;
import com.netscape.certsrv.usrgrp.CertUserLocator;
import com.netscape.certsrv.usrgrp.Certificates;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.ExactMatchCertUserLocator;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import com.netscape.cmsutil.json.JSONObject;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterUser
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(RegisterUser.class);
    private static final long serialVersionUID = -699307373400031138L;
    private static final String SUCCESS = "0";
    private static final String AUTH_FAILURE = "2";
    private String mGroupName = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        logger.debug("RegisterUser: initializing...");
        super.init(sc);
        logger.debug("RegisterUser: done initializing...");
        this.mGroupName = sc.getInitParameter("GroupName");
        logger.debug("RegisterUser: group name " + this.mGroupName);
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        logger.debug("RegisterUser: Processing request");
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        AuthToken authToken = null;
        try {
            logger.info("RegisterUser: Authenticating request");
            authToken = this.authenticate(cmsReq);
            logger.debug("RegisterUser: authentication successful");
        }
        catch (Exception e) {
            logger.error("Unable to authenticate request: " + e.getMessage(), (Throwable)e);
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        if (authToken == null) {
            logger.error("Unable to authenticate request");
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        AuthzToken authzToken = null;
        try {
            logger.info("RegisterUser: Authorizing request");
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "modify");
            logger.debug("RegisterUser: Authorization successful");
        }
        catch (EAuthzAccessDenied e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
            this.outputError(httpResp, "Error: Encountered problem during authorization.");
            return;
        }
        if (authzToken == null) {
            logger.error("Unable to authorize request");
            this.outputError(httpResp, "Error: Not authorized");
            return;
        }
        String uid = httpReq.getParameter("uid");
        String name = httpReq.getParameter("name");
        String certsString = httpReq.getParameter("certificate");
        logger.info("RegisterUser: uid: " + uid);
        logger.info("RegisterUser: name: " + name);
        logger.info("RegisterUser: cert: " + certsString);
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditParams = "Scope;;users+Operation;;OP_ADD+source;;RegisterUser+Resource;;" + uid + "+fullname;;" + name + "+state;;1+userType;;<null>+email;;<null>+password;;<null>+phone;;<null>";
        UGSubsystem ugsys = engine.getUGSubsystem();
        User user = null;
        boolean foundByCert = false;
        X509CertImpl cert = null;
        X509Certificate[] certs = new X509Certificate[1];
        try {
            logger.info("RegisterUser: Searching user by cert");
            byte[] bCert = Utils.base64decode((String)certsString);
            cert = new X509CertImpl(bCert);
            certs[0] = cert;
            ExactMatchCertUserLocator cul = new ExactMatchCertUserLocator();
            cul.setCMSEngine(engine);
            Certificates c = new Certificates(certs);
            user = ((CertUserLocator)cul).locateUser(c);
        }
        catch (Exception e) {
            logger.warn("Unable to find user: " + e.getMessage());
        }
        if (user == null) {
            logger.info("RegisterUser: Searching user by uid");
            try {
                user = ugsys.getUser(uid);
                logger.debug("RegisterUser: found user " + uid);
            }
            catch (Exception eee) {
                logger.warn("Unable to find user " + uid);
            }
        } else {
            logger.info("RegisterUser: Found user by cert");
            foundByCert = true;
        }
        try {
            if (user == null) {
                logger.info("RegisterUser: Creating user " + uid);
                user = ugsys.createUser(uid);
                user.setFullName(name);
                user.setState("1");
                user.setUserType("");
                user.setEmail("");
                user.setPhone("");
                user.setPassword("");
                ugsys.addUser(user);
                logger.debug("RegisterUser: created user " + uid);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", auditParams));
            }
            certsString = certsString.replace("\r", "").replace("\n", "");
            auditParams = "Scope;;certs+Operation;;OP_ADD+source;;RegisterUser+Resource;;" + uid + "+cert;;" + certsString;
            user.setX509Certificates(certs);
            if (!foundByCert) {
                logger.info("RegisterUser: Adding user certificate");
                ugsys.addUserCert(user.getUserID(), (X509Certificate)cert);
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", auditParams));
            } else {
                logger.debug("RegisterUser: No need to add user certificate");
            }
        }
        catch (Exception e) {
            logger.error("Unable to create user: " + e.getMessage(), (Throwable)e);
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", auditParams));
            this.outputError(httpResp, "Error: Certificate malformed");
            return;
        }
        logger.info("RegisterUser: Adding user to group " + this.mGroupName);
        auditParams = "Scope;;groups+Operation;;OP_MODIFY+source;;RegisterUser+Resource;;" + this.mGroupName;
        try {
            Enumeration<Group> groups = ugsys.findGroups(this.mGroupName);
            Group group = groups.nextElement();
            auditParams = auditParams + "+user;;";
            Enumeration<String> members = group.getMemberNames();
            while (members.hasMoreElements()) {
                auditParams = auditParams + members.nextElement();
                if (!members.hasMoreElements()) continue;
                auditParams = auditParams + ",";
            }
            if (!group.isMember(user.getUserID())) {
                auditParams = auditParams + "," + user.getUserID();
                group.addMemberName(user.getUserID());
                ugsys.modifyGroup(group);
                logger.debug("RegisterUser modified group");
                auditor.log(new ConfigRoleEvent(auditSubjectID, "Success", auditParams));
            }
        }
        catch (Exception e) {
            logger.warn("Unable to add user to group " + this.mGroupName + ": " + e.getMessage(), (Throwable)e);
            auditor.log(new ConfigRoleEvent(auditSubjectID, "Failure", auditParams));
        }
        try {
            JSONObject jsonObj = new JSONObject();
            ObjectNode responseNode = jsonObj.getMapper().createObjectNode();
            jsonObj.getRootNode().set("Response", (JsonNode)responseNode);
            responseNode.put("Status", SUCCESS);
            this.outputResult(httpResp, "application/json", jsonObj.toByteArray());
        }
        catch (Exception e) {
            logger.warn("RegisterUser: Failed to send the output: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setDefaultTemplates(ServletConfig sc) {
    }

    @Override
    protected void renderTemplate(CMSRequest cmsReq, String templateName, ICMSTemplateFiller filler) throws IOException {
    }

    @Override
    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    @Override
    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }
}

