/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.base;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.KeyGenInfo;
import com.netscape.cmscore.apps.CMS;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import org.dogtag.util.cert.CertUtil;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgBlock {
    public static Logger logger = LoggerFactory.getLogger(ArgBlock.class);
    private Hashtable<String, Object> mArgs = new Hashtable();
    private String mType = "unspecified-argblock";

    public ArgBlock(String realm, Hashtable<String, String> httpReq) {
        this.mType = realm;
        this.populate(httpReq);
    }

    public ArgBlock(Hashtable<String, String> httpReq) {
        this.populate(httpReq);
    }

    private void populate(Hashtable<String, String> httpReq) {
        Enumeration<String> e = httpReq.keys();
        if (e != null) {
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                String value = httpReq.get(name);
                this.addStringValue(name, value);
            }
        }
    }

    public ArgBlock() {
    }

    public boolean isValuePresent(String n) {
        logger.trace("GET r={},k={}", (Object)this.mType, (Object)n);
        return this.mArgs.get(n) != null;
    }

    public Object addStringValue(String n, String v) {
        return v == null ? this.mArgs.put(n, Character.valueOf('\u0000')) : this.mArgs.put(n, v);
    }

    public String getValueAsString(String n) throws EBaseException {
        String t = (String)this.mArgs.get(n);
        logger.trace("GET r={},k={},v={}", new Object[]{this.mType, n, CMS.isSensitive(n) ? ": (sensitive)" : t});
        if (t == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", n));
        }
        return t;
    }

    public String getValueAsString(String n, String def) {
        String val = (String)this.mArgs.get(n);
        logger.trace("GET r={},k={},v={},d={}", new Object[]{this.mType, n, CMS.isSensitive(n) ? ": (sensitive)" : val, def});
        return val == null ? def : val;
    }

    public int getValueAsInt(String n) throws EBaseException {
        if (this.mArgs.get(n) == null) {
            logger.trace("GET r={},k={},v={}", new Object[]{this.mType, n, "<notpresent>"});
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", n));
        }
        logger.trace("GET r={},k={},v={}", new Object[]{this.mType, n, this.mArgs.get(n)});
        try {
            return Integer.valueOf((String)this.mArgs.get(n));
        }
        catch (NumberFormatException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_TYPE", n, e.toString()));
        }
    }

    public int getValueAsInt(String n, int def) {
        logger.trace("GET r={},k={},v={},d={}", new Object[]{this.mType, n, this.mArgs.get(n), def});
        if (this.mArgs.get(n) == null) {
            return def;
        }
        try {
            return Integer.valueOf((String)this.mArgs.get(n));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public BigInteger getValueAsBigInteger(String n) throws EBaseException {
        String v = (String)this.mArgs.get(n);
        if (v == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", n));
        }
        try {
            return new BigInteger(v, 10);
        }
        catch (NumberFormatException e) {
            try {
                return new BigInteger(v, 16);
            }
            catch (NumberFormatException ex) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_TYPE", n, ex.toString()));
            }
        }
    }

    public BigInteger getValueAsBigInteger(String n, BigInteger def) {
        try {
            return this.getValueAsBigInteger(n);
        }
        catch (EBaseException e) {
            return def;
        }
    }

    public Object getValue(Object n) throws EBaseException {
        if (this.mArgs.get(n) == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", (String)n));
        }
        return this.mArgs.get(n);
    }

    public Object getValue(Object n, Object def) {
        return this.mArgs.get(n) == null ? def : this.mArgs.get(n);
    }

    public boolean getValueAsBoolean(String name) throws EBaseException {
        String val = (String)this.mArgs.get(name);
        logger.trace("GET r={},k={},v={}", new Object[]{this.mType, name, val});
        if (val == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", name));
        }
        return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("on");
    }

    public boolean getValueAsBoolean(String name, boolean def) {
        try {
            boolean val = this.getValueAsBoolean(name);
            return val;
        }
        catch (EBaseException e) {
            return def;
        }
    }

    public KeyGenInfo getValueAsKeyGenInfo(String name, KeyGenInfo def) throws EBaseException {
        KeyGenInfo keyGenInfo;
        logger.trace("GET r={},k={}", (Object)this.mType, (Object)name);
        if (this.mArgs.get(name) == null) {
            return def;
        }
        try {
            keyGenInfo = new KeyGenInfo((String)this.mArgs.get(name));
        }
        catch (IOException e) {
            return def;
        }
        return keyGenInfo;
    }

    public PKCS10 getValueAsRawPKCS10(String name) throws EBaseException {
        PKCS10 request;
        if (this.mArgs.get(name) == null) {
            logger.trace("GET r={},k={},v={}", new Object[]{this.mType, name, "<notpresent>"});
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", name));
        }
        logger.trace("GET r={},k={},v={}", new Object[]{this.mType, name, this.mArgs.get(name)});
        String tempStr = CertUtil.unwrapPKCS10((String)((String)this.mArgs.get(name)), (boolean)false);
        if (tempStr == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", name, "Empty Content"));
        }
        try {
            request = CertUtil.decodePKCS10((String)tempStr);
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", name, e.toString()));
        }
        return request;
    }

    public PKCS10 getValueAsRawPKCS10(String name, PKCS10 def) throws EBaseException {
        PKCS10 request;
        logger.trace("GET r={},k={}", (Object)this.mType, (Object)name);
        if (this.mArgs.get(name) == null) {
            return def;
        }
        String tempStr = CertUtil.unwrapPKCS10((String)((String)this.mArgs.get(name)), (boolean)false);
        if (tempStr == null) {
            return def;
        }
        try {
            request = CertUtil.decodePKCS10((String)tempStr);
        }
        catch (Exception e) {
            return def;
        }
        return request;
    }

    public PKCS10 getValueAsPKCS10(String name, boolean checkheader) throws EBaseException {
        PKCS10 request;
        logger.trace("GET r={},k={}", (Object)this.mType, (Object)name);
        if (this.mArgs.get(name) == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ATTRIBUTE_NOT_FOUND", name));
        }
        String tempStr = CertUtil.unwrapPKCS10((String)((String)this.mArgs.get(name)), (boolean)checkheader);
        if (tempStr == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", name, "Empty Content"));
        }
        try {
            request = CertUtil.decodePKCS10((String)tempStr);
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTR_VALUE", name, e.toString()));
        }
        return request;
    }

    public PKCS10 getValueAsPKCS10(String name, boolean checkheader, PKCS10 def) throws EBaseException {
        PKCS10 request;
        logger.trace("GET r={},k={}", (Object)this.mType, (Object)name);
        if (this.mArgs.get(name) == null) {
            return def;
        }
        String tempStr = CertUtil.unwrapPKCS10((String)((String)this.mArgs.get(name)), (boolean)checkheader);
        if (tempStr == null) {
            return def;
        }
        try {
            request = CertUtil.decodePKCS10((String)tempStr);
        }
        catch (Exception e) {
            return def;
        }
        return request;
    }

    public PKCS10 getValuePKCS10(String name, PKCS10 def) throws EBaseException {
        logger.trace("GET r={},k={}", (Object)this.mType, (Object)name);
        String p10b64 = (String)this.mArgs.get(name);
        if (p10b64 == null) {
            return def;
        }
        try {
            PKCS10 request = CertUtil.decodePKCS10((String)p10b64);
            return request;
        }
        catch (Exception e) {
            return def;
        }
    }

    public void set(String name, Object ob) {
        this.mArgs.put(name, ob);
    }

    public Object get(String name) {
        logger.trace("GET r={},k={}", (Object)this.mType, (Object)name);
        return this.mArgs.get(name);
    }

    public void delete(String name) {
        this.mArgs.remove(name);
    }

    public Enumeration<String> getElements() {
        return this.mArgs.keys();
    }

    public Enumeration<String> elements() {
        return this.mArgs.keys();
    }

    public Object addLongValue(String n, long v) {
        return this.mArgs.put(n, v);
    }

    public Object addIntegerValue(String n, int v) {
        return this.mArgs.put(n, v);
    }

    public Object addBooleanValue(String n, boolean v) {
        return this.mArgs.put(n, v);
    }

    public Object addBigIntegerValue(String n, BigInteger v, int radix) {
        return this.mArgs.put(n, v.toString(radix));
    }
}

