/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.connector;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.connector.IPKIMessage;
import com.netscape.certsrv.logging.event.ClientAccessSessionEstablishEvent;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.connector.HttpRequestEncoder;
import com.netscape.cmscore.connector.RemoteAuthority;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmsutil.http.HttpClient;
import com.netscape.cmsutil.http.HttpRequest;
import com.netscape.cmsutil.http.HttpResponse;
import com.netscape.cmsutil.net.ISocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection {
    private static Logger logger = LoggerFactory.getLogger(HttpConnection.class);
    protected CMSEngine engine;
    protected RemoteAuthority dest;
    protected ISocketFactory factory;
    protected HttpRequest mHttpreq = new HttpRequest();
    protected HttpRequestEncoder mReqEncoder;
    protected HttpClient mHttpClient = null;
    int timeout = 0;
    List<InetSocketAddress> targets;
    String localIP = "localhost";

    public HttpConnection(RemoteAuthority dest, ISocketFactory factory) {
        this(dest, factory, 0);
    }

    public HttpConnection(RemoteAuthority dest, ISocketFactory factory, int timeout) {
        this.dest = dest;
        this.factory = factory;
        this.timeout = timeout;
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void init() {
        logger.debug("HttpConnection: Creating HttpConnection with timeout=" + this.timeout);
        try {
            this.localIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.mReqEncoder = new HttpRequestEncoder();
        this.mHttpClient = new HttpClient(this.factory);
        this.targets = this.parseTarget(this.dest.getHost(), this.dest.getPort());
        try {
            String contentType;
            this.mHttpreq.setMethod("POST");
            if (this.dest.getURI() != null) {
                this.mHttpreq.setURI(this.dest.getURI());
            }
            if ((contentType = this.dest.getContentType()) != null) {
                logger.debug("HttpConnection: setting Content-Type");
                this.mHttpreq.setHeader("Content-Type", contentType);
            }
            this.mHttpreq.setHeader("Host", this.dest.getHost());
            logger.debug("HttpConnection: setting Host to " + this.dest.getHost());
            this.connect();
        }
        catch (IOException e) {
            logger.warn("HttpConnection: Unable to create connection: " + e.getMessage(), (Throwable)e);
        }
    }

    List<InetSocketAddress> parseTarget(String target, int port) {
        ArrayList<InetSocketAddress> results = new ArrayList<InetSocketAddress>();
        if (target == null || target.indexOf(32) < 0) {
            results.add(new InetSocketAddress(target, port));
            return results;
        }
        for (String hostnamePort : target.split(" ")) {
            String[] parts = hostnamePort.split(":");
            String hostname = parts[0];
            port = Integer.parseInt(parts[1]);
            results.add(new InetSocketAddress(hostname, port));
        }
        return results;
    }

    void connect() throws IOException {
        IOException exception = null;
        Auditor auditor = this.engine.getAuditor();
        for (InetSocketAddress target : this.targets) {
            String hostname = target.getHostString();
            int port = target.getPort();
            try {
                logger.debug("HttpConnection: Connecting to " + hostname + ":" + port + " with timeout " + this.timeout + "s");
                this.mHttpClient.connect(hostname, port, this.timeout * 1000);
                logger.debug("HttpConnection: Connected to " + hostname + ":" + port);
                return;
            }
            catch (IOException e) {
                exception = e;
                logger.warn("HttpConnection: Unable to connect to " + hostname + ":" + port + ": " + e.getMessage(), (Throwable)e);
                ClientAccessSessionEstablishEvent auditEvent = ClientAccessSessionEstablishEvent.createFailureEvent(this.localIP, hostname, Integer.toString(port), "SYSTEM", "connect:" + e.toString());
                auditor.log(auditEvent);
            }
        }
        throw exception;
    }

    public void setRequestURI(String uri) throws EBaseException {
        this.mHttpreq.setURI(uri);
    }

    public String getRequestURI() {
        return this.mHttpreq.getURI();
    }

    public IPKIMessage send(IPKIMessage tomsg) throws EBaseException {
        String url = "https://" + this.dest.getHost() + ":" + this.dest.getPort() + this.mHttpreq.getURI();
        logger.info("HttpConnection: Sending request to " + url);
        IPKIMessage replymsg = null;
        HttpResponse resp = null;
        logger.debug("in HttpConnection.send " + this);
        logger.trace("encoding request ");
        String content = null;
        try {
            content = this.mReqEncoder.encode(tomsg);
        }
        catch (IOException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTRIBUTE", "Could not encode request"));
        }
        logger.trace("encoded request");
        logger.trace("------ " + content.length() + "-----");
        logger.trace(content);
        logger.trace("--------------------------");
        resp = this.doSend(content);
        String pcontent = resp.getContent();
        logger.trace("Server returned");
        logger.trace("-------");
        logger.trace(pcontent);
        logger.trace("-------");
        if (pcontent != null && !pcontent.equals("")) {
            logger.debug("HttpConnection.send response: got content");
        } else {
            logger.debug("HttpConnection.send response: null or empty content");
        }
        try {
            replymsg = (IPKIMessage)this.mReqEncoder.decode(pcontent);
        }
        catch (IOException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTRIBUTE", "Could not decode content"));
        }
        logger.debug("HttpConn:decoded reply");
        return replymsg;
    }

    public HttpResponse send(String content) throws EBaseException {
        String url = "https://" + this.dest.getHost() + ":" + this.dest.getPort() + this.mHttpreq.getURI();
        logger.info("HttpConnection: Sending request to " + url);
        HttpResponse resp = null;
        if (content == null || content.equals("")) {
            logger.error("HttpConnection.send: with String content: null or empty");
            throw new EBaseException("HttpConnection.send: with String content: null or empty");
        }
        resp = this.doSend(content);
        return resp;
    }

    private HttpResponse doSend(String content) throws EBaseException {
        HttpResponse resp = null;
        boolean reconnected = false;
        Auditor auditor = this.engine.getAuditor();
        String localIP = "localhost";
        try {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (this.getRequestURI() == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTRIBUTE", "URI not set in HttpRequest"));
        }
        this.mHttpreq.setHeader("Content-Length", Integer.toString(content.length()));
        logger.debug("HttpConnection.doSend: with String content length: " + Integer.toString(content.length()));
        this.mHttpreq.setContent(content);
        try {
            if (!this.mHttpClient.connected()) {
                this.connect();
                reconnected = true;
            }
        }
        catch (IOException e) {
            logger.error("Unable to send HTTP request: " + e.getMessage(), (Throwable)e);
            if (e.getMessage().indexOf("Peer's certificate issuer has been marked as not trusted") != -1) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", "(This local authority cannot connect to the remote authority. The local authority's signing certificate must chain to a CA certificate trusted for client authentication in the certificate database. Use the certificate manager, or command line tool such as certutil to verify that the trust permissions of the local authority's issuer cert have 'CT' setting in the SSL client auth field.)"));
            }
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", "Couldn't reconnect " + e));
        }
        while (resp == null) {
            try {
                logger.debug("HttpConnection.doSend: sending request");
                resp = this.mHttpClient.send(this.mHttpreq);
            }
            catch (IOException e) {
                logger.error("Unable to send HTTP request: " + e.getMessage(), (Throwable)e);
                ClientAccessSessionEstablishEvent auditEvent = ClientAccessSessionEstablishEvent.createFailureEvent(localIP, this.mHttpClient.getHost(), this.mHttpClient.getPort(), "SYSTEM", "send:" + e.toString());
                auditor.log(auditEvent);
                if (reconnected) {
                    logger.error("HttpConnection.doSend: resend failed again.");
                    throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", "resend failed again: " + e), (Throwable)e);
                }
                try {
                    logger.warn("HttpConnection.doSend: trying a reconnect ");
                    this.connect();
                }
                catch (IOException ex) {
                    logger.error("HttpConnection.doSend: reconnect for resend failed: " + ex.getMessage(), (Throwable)ex);
                    throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", "reconnect for resend failed: " + ex), (Throwable)e);
                }
                reconnected = true;
            }
        }
        String statusStr = resp.getStatusCode();
        logger.debug("HttpConnection.doSend: server returned status " + statusStr);
        int statuscode = -1;
        try {
            statuscode = Integer.parseInt(statusStr);
        }
        catch (NumberFormatException e) {
            statuscode = -1;
        }
        if (statuscode != 200) {
            if (statuscode == 401) {
                String msg = "request no good " + statuscode + " " + resp.getReasonPhrase();
                logger.error("HttpConnection: " + msg);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_AUTHENTICATE_FAILED", msg));
            }
            String msg = "HttpConnection: request no good " + statuscode + " " + resp.getReasonPhrase();
            logger.error(msg);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_ATTRIBUTE", msg));
        }
        return resp;
    }
}

