/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.connector;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestEncoder {
    public static Logger logger = LoggerFactory.getLogger(HttpRequestEncoder.class);

    public String encode(Object r) throws IOException {
        String s = null;
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(ba);
        os.writeObject(r);
        byte[] serial = ba.toByteArray();
        s = Utils.base64encode((byte[])serial, (boolean)true);
        return s;
    }

    public Object decode(String s) throws IOException {
        Object result = null;
        byte[] serial = null;
        try {
            serial = Utils.base64decode((String)s);
            ByteArrayInputStream ba = new ByteArrayInputStream(serial);
            ObjectInputStream is = new ObjectInputStream(ba);
            result = is.readObject();
        }
        catch (ClassNotFoundException e) {
            logger.error("HttpRequestEncoder: " + e.getMessage(), (Throwable)e);
            throw new IOException("Class Not Found " + e.getMessage());
        }
        catch (OptionalDataException e) {
            if (e.eof) {
                logger.trace("done reading input stream " + result);
            }
            logger.trace(e.length + " more bytes of primitive data");
        }
        return result;
    }
}

