/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.security;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.security.ICryptoSubsystem;
import com.netscape.certsrv.security.KeyCertData;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.security.CASigningCert;
import com.netscape.cmscore.security.CertificateInfo;
import com.netscape.cmscore.security.JSSDatabaseCloser;
import com.netscape.cmscore.security.JssSubsystemConfig;
import com.netscape.cmscore.security.KeyCertUtil;
import com.netscape.cmscore.security.OCSPSigningCert;
import com.netscape.cmscore.security.PKISecureRandom;
import com.netscape.cmscore.security.Provider;
import com.netscape.cmscore.security.SSLCert;
import com.netscape.cmscore.security.SSLConfig;
import com.netscape.cmscore.security.SSLSelfSignedCert;
import com.netscape.cmscore.security.SecureRandomConfig;
import com.netscape.cmscore.security.SecureRandomFactory;
import com.netscape.cmscore.util.Debug;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.util.DN;
import org.dogtag.util.cert.CertUtil;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.NicknameConflictException;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.UserCertConflictException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenCertificate;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.extensions.AuthInfoAccessExtension;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgIdDSA;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.pkcs11.PK11SecureRandom;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.SignedData;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.NotImplementedException;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JssSubsystem
implements ICryptoSubsystem {
    public static final Logger logger = LoggerFactory.getLogger(JssSubsystem.class);
    public static final String ID = "jss";
    protected CMSEngine engine;
    protected JssSubsystemConfig config;
    private boolean mInited = false;
    private CryptoManager mCryptoManager = null;
    private SecureRandom random;
    private String obscureMethod = "zeroes";
    private Hashtable<String, X509Certificate[]> mNicknameMapCertsTable = new Hashtable();
    private Hashtable<String, X509Certificate[]> mNicknameMapUserCertsTable = new Hashtable();
    private FileInputStream devRandomInputStream = null;
    private SimpleDateFormat mFormatter = new SimpleDateFormat("MMMMM dd, yyyy HH:mm:ss");
    private SSLConfig sslConfig;
    private static final String PROP_SSL_CIPHERPREF = "cipherpref";
    private static Hashtable<String, Integer> mCipherNames = new Hashtable();
    private static final String DEFAULT_CIPHERPREF = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA,TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA";
    private static final SSLCipher[] ciphers = new SSLCipher[]{SSLCipher.SSL2_RC4_128_WITH_MD5, SSLCipher.SSL2_RC4_128_EXPORT40_WITH_MD5, SSLCipher.SSL2_RC2_128_CBC_WITH_MD5, SSLCipher.SSL2_RC2_128_CBC_EXPORT40_WITH_MD5, SSLCipher.SSL2_DES_64_CBC_WITH_MD5, SSLCipher.SSL2_DES_192_EDE3_CBC_WITH_MD5, SSLCipher.SSL3_RSA_EXPORT_WITH_RC4_40_MD5, SSLCipher.SSL3_RSA_WITH_RC4_128_MD5, SSLCipher.SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5, SSLCipher.SSL3_RSA_WITH_DES_CBC_SHA, SSLCipher.SSL3_RSA_WITH_3DES_EDE_CBC_SHA, SSLCipher.SSL3_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA, SSLCipher.SSL3_FORTEZZA_DMS_WITH_RC4_128_SHA, SSLCipher.TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA, SSLCipher.TLS_RSA_EXPORT1024_WITH_RC4_56_SHA};

    public String getId() {
        return ID;
    }

    public void setId(String id) throws EBaseException {
        throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_OPERATION", new String[0]));
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    @Override
    public void addEntropy(int bits) throws NotImplementedException, IOException, TokenException {
        int c;
        int read = 0;
        int bytes = (7 + bits) / 8;
        byte[] b = new byte[bytes];
        if (this.devRandomInputStream == null) {
            throw new IOException(CMS.getLogMessage("CMSCORE_SECURITY_NO_ENTROPY_STREAM", new Object[0]));
        }
        while ((read += (c = this.devRandomInputStream.read(b, read, bytes - read))) < bytes) {
        }
        logger.debug("JssSubsystem adding " + bits + " bits (" + bytes + " bytes) of entropy to default RNG token");
        logger.debug(Debug.dump(b));
        PK11SecureRandom sr = new PK11SecureRandom();
        sr.setSeed(b);
    }

    public void init(JssSubsystemConfig config) throws EBaseException {
        logger.debug("JssSubsystem: initializing JSS subsystem");
        if (this.mInited) {
            logger.debug("JssSubsystem: already initialized");
            return;
        }
        this.config = config;
        boolean enabled = config.isEnabled();
        logger.debug("JssSubsystem: enabled: " + enabled);
        if (!enabled) {
            return;
        }
        try {
            this.devRandomInputStream = new FileInputStream("/dev/urandom");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String certDir = config.getNSSDatabaseDir();
        logger.debug("JssSubsystem: NSS database: " + certDir);
        InitializationValues vals = new InitializationValues(certDir, "", "", "secmod.db");
        vals.removeSunProvider = false;
        vals.installJSSProvider = true;
        try {
            logger.debug("JssSubsystem: initializing CryptoManager");
            CryptoManager.initialize((InitializationValues)vals);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
        }
        catch (Exception e) {
            String[] params = new String[]{ID, e.toString()};
            EBaseException ex = new EBaseException(CMS.getUserMessage("CMS_BASE_CREATE_SERVICE_FAILED", params));
            String message = CMS.getLogMessage("CMSCORE_SECURITY_GENERAL_ERROR", ex.getMessage());
            logger.error("JssSubsystem: " + message, (Throwable)e);
            throw ex;
        }
        try {
            logger.debug("JssSubsystem: initializing SSL");
            this.mCryptoManager = CryptoManager.getInstance();
            this.initSSL();
        }
        catch (NotInitializedException e) {
            String[] params = new String[]{ID, e.toString()};
            EBaseException ex = new EBaseException(CMS.getUserMessage("CMS_BASE_CREATE_SERVICE_FAILED", params));
            String message = CMS.getLogMessage("CMSCORE_SECURITY_GENERAL_ERROR", ex.getMessage());
            logger.error("JssSubsystem: " + message, (Throwable)e);
            throw ex;
        }
        SecureRandomConfig secureRandomConfig = config.getSecureRandomConfig();
        try {
            SecureRandom random = SecureRandomFactory.create(secureRandomConfig);
            this.random = new PKISecureRandom(this.engine, random);
        }
        catch (GeneralSecurityException e) {
            throw new EBaseException((Exception)e);
        }
        this.obscureMethod = config.getObscureMethod();
        this.mInited = true;
        logger.debug("JssSubsystem: initialization complete");
    }

    public SecureRandom getRandomNumberGenerator() {
        return this.random;
    }

    public String generateSalt() {
        SecureRandom rnd = this.getRandomNumberGenerator();
        return Integer.toString(rnd.nextInt());
    }

    public void obscureBytes(byte[] memory) {
        this.obscureBytes(memory, null);
    }

    public void obscureBytes(byte[] memory, String method) {
        String methodName = "JssSubsystem.obscureBytes: ";
        if (memory == null || memory.length == 0) {
            logger.debug(methodName + " memory null, ok, will return... ");
            return;
        }
        SecureRandom rnd = this.getRandomNumberGenerator();
        String actualMethod = this.obscureMethod;
        if (method != null) {
            actualMethod = method;
        }
        if ("zeroes".equals(actualMethod)) {
            logger.debug(methodName + " filling with zeroes, numBytes: " + memory.length);
            Arrays.fill(memory, (byte)0);
        } else {
            logger.debug(methodName + " filling with random data, numBytes: " + memory.length);
            if (rnd == null) {
                rnd = new SecureRandom();
            }
            rnd.nextBytes(memory);
        }
    }

    public void obscureChars(char[] memory) {
        String methodName = "JssSubsystem.obscureBytes: ";
        if (memory == null || memory.length == 0) {
            return;
        }
        logger.debug(methodName + " filling with zeroes, numChars: " + memory.length);
        Arrays.fill(memory, '\u0000');
    }

    @Override
    public String getCipherVersion() throws EBaseException {
        return "cipherdomestic";
    }

    @Override
    public String getCipherPreferences() throws EBaseException {
        String cipherpref = "";
        if (this.sslConfig != null && (cipherpref = this.sslConfig.getCipherPreferences()).equals("")) {
            cipherpref = DEFAULT_CIPHERPREF;
        }
        return cipherpref;
    }

    public String getECType(String certType) throws EBaseException {
        return this.sslConfig == null ? "ECDHE" : this.sslConfig.getECType(certType);
    }

    @Override
    public String isCipherFortezza() throws EBaseException {
        return "true";
    }

    void installProvider() {
        int position = Security.insertProviderAt(new Provider(), 1);
        if (position == -1) {
            logger.warn("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_INSTALL_PROVIDER", new Object[0]));
        }
    }

    @Override
    public void setCipherPreferences(String cipherPrefs) throws EBaseException {
        if (this.sslConfig != null) {
            if (cipherPrefs.equals("")) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_NO_EMPTY_CIPHERPREFS", new String[0]));
            }
            this.sslConfig.setCipherPreferences(cipherPrefs);
        }
    }

    private void initSSL() throws EBaseException {
        try {
            SSLServerSocket.configServerSessionIDCache((int)10, (int)0, (int)0, null);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.sslConfig = this.config.getSSLConfig();
        String sslCiphers = null;
        if (this.sslConfig != null) {
            sslCiphers = this.getCipherPreferences();
        }
        logger.trace("configured ssl cipher prefs is " + sslCiphers);
        for (int i = ciphers.length - 1; i >= 0; --i) {
            try {
                SSLSocket.setCipherPreferenceDefault((int)ciphers[i].getID(), (boolean)false);
                continue;
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        if (sslCiphers != null && sslCiphers.length() != 0) {
            StringTokenizer ciphers = new StringTokenizer(sslCiphers, ",");
            if (!ciphers.hasMoreTokens()) {
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_INVALID_CIPHER", sslCiphers));
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_PROPERTY", PROP_SSL_CIPHERPREF));
            }
            while (ciphers.hasMoreTokens()) {
                String cipher = ciphers.nextToken();
                Integer sslcipher = mCipherNames.get(cipher);
                if (sslcipher == null) continue;
                String msg = "setting ssl cipher " + cipher;
                logger.info("JssSubsystem: " + msg);
                try {
                    SSLSocket.setCipherPreferenceDefault((int)sslcipher, (boolean)true);
                }
                catch (SocketException socketException) {}
            }
        }
    }

    public JssSubsystemConfig getConfigStore() {
        return this.config;
    }

    public void startup() throws EBaseException {
    }

    public void shutdown() {
        try {
            boolean isClosing = this.config.getCloseNSSDatabase();
            if (isClosing) {
                JSSDatabaseCloser closer = new JSSDatabaseCloser();
                closer.closeDatabases();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getInternalTokenName() throws EBaseException {
        CryptoToken c = this.mCryptoManager.getInternalKeyStorageToken();
        String name = "";
        try {
            name = c.getName();
        }
        catch (TokenException e) {
            String[] params = new String[]{ID, e.toString()};
            EBaseException ex = new EBaseException(CMS.getUserMessage("CMS_BASE_CREATE_SERVICE_FAILED", params));
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GENERAL_ERROR", ex.toString()), (Throwable)e);
            throw ex;
        }
        return name;
    }

    @Override
    public String getTokenList() throws EBaseException {
        StringBuffer tokenList = new StringBuffer();
        Enumeration tokens = this.mCryptoManager.getExternalTokens();
        int num = 0;
        try {
            while (tokens.hasMoreElements()) {
                CryptoToken c = (CryptoToken)tokens.nextElement();
                if (c.getName() != null && c.getName().equals("Builtin Object Token")) continue;
                if (num++ != 0) {
                    tokenList.append(",");
                }
                tokenList.append(c.getName());
            }
        }
        catch (TokenException e) {
            String[] params = new String[]{ID, e.toString()};
            EBaseException ex = new EBaseException(CMS.getUserMessage("CMS_BASE_CREATE_SERVICE_FAILED", params));
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GENERAL_ERROR", ex.toString()), (Throwable)e);
            throw ex;
        }
        if (tokenList.length() == 0) {
            return "internal";
        }
        return tokenList.append(",internal").toString();
    }

    @Override
    public boolean isTokenLoggedIn(String name) throws EBaseException {
        try {
            CryptoToken ctoken = CryptoUtil.getKeyStorageToken((String)name);
            return ctoken.isLoggedIn();
        }
        catch (Exception e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_TOKEN_LOGGED_IN", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_ERROR", new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loggedInToken(String tokenName, String pwd) throws EBaseException {
        Password clk = new Password(pwd.toCharArray());
        try {
            CryptoToken ctoken = CryptoUtil.getKeyStorageToken((String)tokenName);
            ctoken.login((PasswordCallback)clk);
        }
        catch (Exception e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_TOKEN_LOGGED_IN", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_ERROR", new String[0]), (Throwable)e);
        }
        finally {
            clk.clear();
        }
    }

    @Override
    public String getCertSubjectName(String tokenname, String nickname) throws EBaseException {
        try {
            return KeyCertUtil.getCertSubjectName(tokenname, nickname);
        }
        catch (NoSuchTokenException | TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_SUBJECT_NAME", e.toString()), e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_SUBJECT_NAME", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_SUBJECT_NAME", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", ""));
        }
    }

    @Override
    public String getAllCerts() throws EBaseException {
        StringBuffer certNames = new StringBuffer();
        try {
            Enumeration enums = this.mCryptoManager.getAllTokens();
            while (enums.hasMoreElements()) {
                CryptoToken token = (CryptoToken)enums.nextElement();
                CryptoStore store = token.getCryptoStore();
                X509Certificate[] list = store.getCertificates();
                for (int i = 0; i < list.length; ++i) {
                    String nickname = list[i].getNickname();
                    if (certNames.length() < 1) {
                        certNames.append(nickname);
                        continue;
                    }
                    certNames.append("," + nickname);
                }
            }
        }
        catch (TokenException e) {
            String[] params = new String[]{ID, e.toString()};
            EBaseException ex = new EBaseException(CMS.getUserMessage("CMS_BASE_CREATE_SERVICE_FAILED", params));
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GENERAL_ERROR", ex.toString()), (Throwable)e);
            throw ex;
        }
        return certNames.toString();
    }

    @Override
    public String getCertListWithoutTokenName(String name) throws EBaseException {
        CryptoToken c = null;
        StringBuffer certNames = new StringBuffer();
        try {
            c = CryptoUtil.getKeyStorageToken((String)name);
            if (c == null) {
                return "";
            }
            CryptoStore store = c.getCryptoStore();
            X509Certificate[] list = store.getCertificates();
            if (list == null) {
                return "";
            }
            for (int i = 0; i < list.length; ++i) {
                String nickname = list[i].getNickname();
                int index = nickname.indexOf(":");
                if (index != -1) {
                    nickname = nickname.substring(index + 1);
                }
                if (i != 0) {
                    certNames.append(",");
                }
                certNames.append(nickname);
            }
            return certNames.toString();
        }
        catch (Exception e) {
            String[] params = new String[]{ID, e.toString()};
            EBaseException ex = new EBaseException(CMS.getUserMessage("CMS_BASE_CREATE_SERVICE_FAILED", params));
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GENERAL_ERROR", ex.toString()), (Throwable)e);
            throw ex;
        }
    }

    public String getCertList(String name) throws EBaseException {
        CryptoToken c = null;
        StringBuffer certNames = new StringBuffer();
        try {
            c = CryptoUtil.getKeyStorageToken((String)name);
            if (c == null) {
                return "";
            }
            CryptoStore store = c.getCryptoStore();
            X509Certificate[] list = store.getCertificates();
            if (list == null) {
                return "";
            }
            for (int i = 0; i < list.length; ++i) {
                String nickname = list[i].getNickname();
                if (i != 0) {
                    certNames.append(",");
                }
                certNames.append(nickname);
            }
            return certNames.toString();
        }
        catch (Exception e) {
            String[] params = new String[]{ID, e.toString()};
            EBaseException ex = new EBaseException(CMS.getUserMessage("CMS_BASE_CREATE_SERVICE_FAILED", params));
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GENERAL_ERROR", ex.toString()), (Throwable)e);
            throw ex;
        }
    }

    @Override
    public AlgorithmId getAlgorithmId(String algname, ConfigStore store) throws EBaseException {
        try {
            if (algname.equals("DSA")) {
                byte[] p = store.getByteArray("ca.dsaP", null);
                byte[] q = store.getByteArray("ca.dsaQ", null);
                byte[] g = store.getByteArray("ca.dsaG", null);
                if (p != null && q != null && g != null) {
                    BigInteger P = new BigInteger(p);
                    BigInteger Q = new BigInteger(q);
                    BigInteger G = new BigInteger(g);
                    return new AlgIdDSA(P, Q, G);
                }
            }
            return AlgorithmId.get((String)algname);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ALG_NOT_SUPPORTED", ""));
        }
    }

    @Override
    public String getSignatureAlgorithm(String nickname) throws EBaseException {
        try {
            X509Certificate cert = CryptoManager.getInstance().findCertByNickname(nickname);
            X509CertImpl impl = new X509CertImpl(cert.getEncoded());
            return impl.getSigAlgName();
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_ALG", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (ObjectNotFoundException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_ALG", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_ALG", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_ALG", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", ""));
        }
    }

    @Override
    public KeyPair getKeyPair(String nickname) throws EBaseException {
        try {
            X509Certificate cert = CryptoManager.getInstance().findCertByNickname(nickname);
            org.mozilla.jss.crypto.PrivateKey priKey = CryptoManager.getInstance().findPrivKeyByCert(cert);
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, (PrivateKey)priKey);
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: Key Pair Error " + e.getMessage(), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (ObjectNotFoundException e) {
            logger.error("JssSubsystem: Key Pair Error " + e.getMessage(), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: Key Pair Error " + e.getMessage(), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
    }

    @Override
    public KeyPair getKeyPair(CryptoToken token, String alg, int keySize) throws EBaseException {
        return this.getKeyPair(token, alg, keySize, null);
    }

    @Override
    public KeyPair getKeyPair(CryptoToken token, String alg, int keySize, PQGParams pqg) throws EBaseException {
        KeyPairAlgorithm kpAlg = null;
        kpAlg = alg.equals("RSA") ? KeyPairAlgorithm.RSA : KeyPairAlgorithm.DSA;
        try {
            return KeyCertUtil.generateKeyPair(token, kpAlg, keySize, pqg);
        }
        catch (InvalidParameterException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_KEY_PAIR", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_KEYSIZE_PARAMS", "" + keySize));
        }
        catch (PQGParamGenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_KEY_PAIR", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_PQG_GEN_FAILED", new String[0]));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_KEY_PAIR", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ALG_NOT_SUPPORTED", kpAlg.toString()));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_KEY_PAIR", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_KEY_GEN_FAILED", new String[0]));
        }
        catch (InvalidAlgorithmParameterException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_KEY_PAIR", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ALG_NOT_SUPPORTED", "DSA"));
        }
    }

    @Override
    public void isX500DN(String dn) throws EBaseException {
        try {
            new X500Name(dn);
        }
        catch (IOException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_X500_NAME", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_X500_NAME", dn));
        }
    }

    @Override
    public String getCertRequest(String subjectName, KeyPair kp) throws EBaseException {
        try {
            PKCS10 pkcs = KeyCertUtil.getCertRequest(subjectName, kp);
            return CertUtil.toPEM((PKCS10)pkcs);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_CERT_REQUEST", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ALG_NOT_SUPPORTED", ""));
        }
        catch (NoSuchProviderException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_CERT_REQUEST", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_PROVIDER_NOT_SUPPORTED", new String[0]));
        }
        catch (InvalidKeyException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_CERT_REQUEST", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_KEY", new String[0]));
        }
        catch (IOException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_CERT_REQUEST", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_REQ_FAILED", new String[0]));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_CERT_REQUEST", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_CERT", e.toString()));
        }
        catch (SignatureException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_CERT_REQUEST", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_SIGNATURE", new String[0]));
        }
        catch (Exception e) {
            throw new EBaseException(e);
        }
    }

    @Override
    public void importCert(String b64E, String nickname, String certType) throws EBaseException {
        try {
            KeyCertUtil.importCert(b64E, nickname, certType);
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_DECODE_CERT_FAILED", new String[0]));
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            String eString = e.toString();
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            if (eString.contains("Failed to find certificate that was just imported")) {
                throw new EBaseException(eString);
            }
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (UserCertConflictException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_USERCERT_CONFLICT", new String[0]));
        }
        catch (NicknameConflictException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_NICKNAME_CONFLICT", new String[0]));
        }
        catch (NoSuchItemOnTokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ITEM_NOT_FOUND_ON_TOKEN", new String[0]));
        }
    }

    @Override
    public KeyPair getKeyPair(KeyCertData properties) throws EBaseException {
        CryptoToken token;
        String tokenName = "internal";
        String keyType = "RSA";
        int keyLength = 512;
        String tmp = (String)properties.get("tokenName");
        if (!CryptoUtil.isInternalToken((String)tmp)) {
            tokenName = tmp;
        }
        if ((tmp = (String)properties.get("keyType")) != null) {
            keyType = tmp;
        }
        if ((tmp = (String)properties.get("keyLength")) != null) {
            keyLength = Integer.parseInt(tmp);
        }
        try {
            token = CryptoUtil.getKeyStorageToken((String)tokenName);
        }
        catch (NoSuchTokenException | NotInitializedException e) {
            throw new EBaseException("Unable to find token: " + tokenName, e);
        }
        return this.getKeyPair(token, keyType, keyLength);
    }

    @Override
    public KeyPair getECCKeyPair(KeyCertData properties) throws EBaseException {
        CryptoToken token;
        String tokenName = "internal";
        String keyCurve = "nistp521";
        String tmp = (String)properties.get("tokenName");
        if (tmp != null) {
            tokenName = tmp;
        }
        if ((tmp = (String)properties.get("keyCurveName")) != null) {
            keyCurve = tmp;
        }
        String certType = (String)properties.get("RS_ID");
        try {
            token = CryptoUtil.getKeyStorageToken((String)tokenName);
        }
        catch (NoSuchTokenException | NotInitializedException e) {
            throw new EBaseException("Unable to find token: " + tokenName, e);
        }
        return this.getECCKeyPair(token, keyCurve, certType);
    }

    @Override
    public KeyPair getECCKeyPair(CryptoToken token, String keyCurve, String certType) throws EBaseException {
        KeyPair pair = null;
        if (keyCurve == null || keyCurve.equals("")) {
            keyCurve = "nistp521";
        }
        String ectype = this.getECType(certType);
        try {
            KeyPairGeneratorSpi.Usage[] usages = null;
            KeyPairGeneratorSpi.Usage[] usagesMask = ectype.equals("ECDHE") ? CryptoUtil.ECDHE_USAGES_MASK : CryptoUtil.ECDH_USAGES_MASK;
            pair = CryptoUtil.generateECCKeyPair((CryptoToken)token, (String)keyCurve, usages, (KeyPairGeneratorSpi.Usage[])usagesMask);
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_ECC_KEY", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (NoSuchTokenException | TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_ECC_KEY", e.toString()), e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_ECC_KEY", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_NO_SUCH_ALGORITHM", e.toString()));
        }
        catch (Exception e) {
            throw new EBaseException(e);
        }
        return pair;
    }

    @Override
    public void importCert(X509CertImpl signedCert, String nickname, String certType) throws EBaseException {
        try {
            KeyCertUtil.importCert(signedCert, nickname, certType);
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ENCODE_CERT_FAILED", new String[0]));
        }
        catch (UserCertConflictException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_USERCERT_CONFLICT", new String[0]));
        }
        catch (NicknameConflictException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_NICKNAME_CONFLICT", new String[0]));
        }
        catch (NoSuchItemOnTokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_IMPORT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ITEM_NOT_FOUND_ON_TOKEN", new String[0]));
        }
    }

    public NameValuePairs getCertInfo(String b64E) throws EBaseException {
        try {
            byte[] b = KeyCertUtil.convertB64EToByteArray(b64E);
            X509CertImpl impl = new X509CertImpl(b);
            NameValuePairs results = new NameValuePairs();
            results.put((Object)"certSubjectName", (Object)impl.getSubjectName().getName());
            results.put((Object)"issuerName", (Object)impl.getIssuerName().getName());
            results.put((Object)"serialNumber", (Object)impl.getSerialNumber().toString());
            results.put((Object)"beforeValidDate", (Object)impl.getNotBefore().toString());
            results.put((Object)"afterValidDate", (Object)impl.getNotAfter().toString());
            return results;
        }
        catch (IOException | CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_CERT_INFO", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_DECODE_CERT_FAILED", new String[0]));
        }
    }

    @Override
    public void deleteUserCert(String nickname, String serialno, String issuername) throws EBaseException {
        try {
            X509Certificate cert = this.getCertificate(nickname, serialno, issuername);
            if (cert instanceof TokenCertificate) {
                TokenCertificate tcert = (TokenCertificate)cert;
                logger.debug("*** deleting this token cert");
                tcert.getOwningToken().getCryptoStore().deleteCert((X509Certificate)tcert);
                logger.debug("*** finish deleting this token cert");
            } else {
                CryptoToken token = CryptoManager.getInstance().getInternalKeyStorageToken();
                CryptoStore store = token.getCryptoStore();
                logger.debug("*** deleting this interna cert");
                store.deleteCert(cert);
                logger.debug("*** removing this interna cert");
            }
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (NoSuchItemOnTokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ITEM_NOT_FOUND_ON_TOKEN", new String[0]));
        }
    }

    @Override
    public void deleteRootCert(String nickname, String serialno, String issuername) throws EBaseException {
        int index = nickname.indexOf(":");
        String tokenname = nickname.substring(0, index);
        if (CryptoUtil.isInternalToken((String)tokenname)) {
            nickname = nickname.substring(index + 1);
        }
        try {
            X509Certificate[] certs = this.mNicknameMapCertsTable.get(nickname);
            if (certs == null) {
                EBaseException e = new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CA_CERT", e.toString()));
                throw e;
            }
            for (int i = 0; i < certs.length; ++i) {
                X509Certificate cert = certs[i];
                X509CertImpl impl = new X509CertImpl(cert.getEncoded());
                String num = impl.getSerialNumber().toString();
                String issuer = impl.getIssuerName().toString();
                logger.debug("*** num " + num);
                logger.debug("*** issuer " + issuer);
                if (!num.equals(serialno) || !issuername.equals(issuer)) continue;
                logger.debug("*** removing root cert");
                if (cert instanceof TokenCertificate) {
                    TokenCertificate tcert = (TokenCertificate)cert;
                    logger.debug("*** deleting this token cert");
                    tcert.getOwningToken().getCryptoStore().deleteCert((X509Certificate)tcert);
                    logger.debug("*** finish deleting this token cert");
                } else {
                    CryptoToken token = CryptoManager.getInstance().getInternalKeyStorageToken();
                    CryptoStore store = token.getCryptoStore();
                    logger.debug("*** deleting this interna cert");
                    store.deleteCert(cert);
                    logger.debug("*** removing this interna cert");
                }
                this.mNicknameMapCertsTable.remove(nickname);
                break;
            }
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (NoSuchItemOnTokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ITEM_NOT_FOUND_ON_TOKEN", new String[0]));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
        }
    }

    @Override
    public NameValuePairs getRootCerts() throws EBaseException {
        NameValuePairs nvps = new NameValuePairs();
        try {
            Enumeration enums = this.mCryptoManager.getAllTokens();
            this.mNicknameMapCertsTable.clear();
            Hashtable<Object, Vector> vecTable = new Hashtable<Object, Vector>();
            while (enums.hasMoreElements()) {
                Object key;
                CryptoToken token = (CryptoToken)enums.nextElement();
                String tokenName = token.getName();
                CryptoStore store = token.getCryptoStore();
                X509Certificate[] list = store.getCertificates();
                for (int i = 0; i < list.length; ++i) {
                    try {
                        key = CryptoManager.getInstance().findPrivKeyByCert(list[i]);
                        logger.trace("JssSubsystem getRootCerts: find private key " + list[i].getNickname());
                        continue;
                    }
                    catch (ObjectNotFoundException e) {
                        Object nickname = list[i].getNickname();
                        if (CryptoUtil.isInternalToken((String)tokenName)) {
                            nickname = "internal:" + (String)nickname;
                        }
                        X509CertImpl impl = null;
                        try {
                            Vector v = vecTable.containsKey(nickname) ? (Vector)vecTable.get(nickname) : new Vector();
                            v.addElement(list[i]);
                            vecTable.put(nickname, v);
                            impl = new X509CertImpl(list[i].getEncoded());
                        }
                        catch (CertificateException ex) {
                            logger.warn("bad certificate - " + (String)nickname);
                            continue;
                        }
                        String serialno = impl.getSerialNumber().toString();
                        String issuer = impl.getIssuerName().toString();
                        nvps.put((Object)((String)nickname + "," + serialno), (Object)issuer);
                        logger.trace("getRootCerts: nickname=" + (String)nickname + ", serialno=" + serialno + ", issuer=" + issuer);
                        continue;
                    }
                    catch (NotInitializedException e) {
                        // empty catch block
                    }
                }
                Enumeration elms = vecTable.keys();
                while (elms.hasMoreElements()) {
                    key = (String)elms.nextElement();
                    Vector v = (Vector)vecTable.get(key);
                    Object[] a = new X509Certificate[v.size()];
                    v.copyInto(a);
                    this.mNicknameMapCertsTable.put((String)key, (X509Certificate[])a);
                }
            }
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_ALL_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", ""));
        }
        return nvps;
    }

    @Override
    public NameValuePairs getUserCerts() throws EBaseException {
        NameValuePairs nvps = new NameValuePairs();
        try {
            Enumeration enums = this.mCryptoManager.getAllTokens();
            while (enums.hasMoreElements()) {
                CryptoToken token = (CryptoToken)enums.nextElement();
                String tokenName = token.getName();
                CryptoStore store = token.getCryptoStore();
                X509Certificate[] list = store.getCertificates();
                for (int i = 0; i < list.length; ++i) {
                    try {
                        org.mozilla.jss.crypto.PrivateKey key = CryptoManager.getInstance().findPrivKeyByCert(list[i]);
                        Object nickname = list[i].getNickname();
                        if (CryptoUtil.isInternalToken((String)tokenName)) {
                            nickname = "internal:" + (String)nickname;
                        }
                        X509CertImpl impl = null;
                        try {
                            impl = new X509CertImpl(list[i].getEncoded());
                        }
                        catch (CertificateException e) {
                            logger.warn("bad certificate - " + (String)nickname);
                            continue;
                        }
                        String serialno = impl.getSerialNumber().toString();
                        String issuer = impl.getIssuerName().toString();
                        nvps.put((Object)((String)nickname + "," + serialno), (Object)issuer);
                        logger.trace("getUserCerts: nickname=" + (String)nickname + ", serialno=" + serialno + ", issuer=" + issuer);
                        continue;
                    }
                    catch (ObjectNotFoundException e) {
                        logger.trace("JssSubsystem getUserCerts: cant find private key " + list[i].getNickname());
                        continue;
                    }
                    catch (NotInitializedException notInitializedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_ALL_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", ""));
        }
        return nvps;
    }

    @Override
    public NameValuePairs getAllCertsManage() throws EBaseException {
        NameValuePairs pairs = this.getCACerts();
        this.mNicknameMapUserCertsTable.clear();
        try {
            Enumeration enums = this.mCryptoManager.getAllTokens();
            while (enums.hasMoreElements()) {
                CryptoToken token = (CryptoToken)enums.nextElement();
                CryptoStore store = token.getCryptoStore();
                X509Certificate[] list = store.getCertificates();
                for (int i = 0; i < list.length; ++i) {
                    String nickname = list[i].getNickname();
                    X509Certificate[] certificates = CryptoManager.getInstance().findCertsByNickname(nickname);
                    this.mNicknameMapUserCertsTable.put(nickname, certificates);
                    X509CertImpl impl = null;
                    try {
                        impl = new X509CertImpl(list[i].getEncoded());
                    }
                    catch (CertificateException e) {
                        logger.warn("bad certificate - " + nickname);
                        continue;
                    }
                    Date date = impl.getNotAfter();
                    String dateStr = this.mFormatter.format(date);
                    String vvalue = (String)pairs.get((Object)nickname);
                    String certValue = dateStr + ",u";
                    if (vvalue == null) {
                        pairs.put((Object)nickname, (Object)certValue);
                        continue;
                    }
                    if (!vvalue.endsWith(",u")) continue;
                    pairs.put((Object)nickname, (Object)(vvalue + ";" + certValue));
                }
            }
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_ALL_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_ALL_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", ""));
        }
        return pairs;
    }

    @Override
    public NameValuePairs getCACerts() throws EBaseException {
        Vector v;
        X509Certificate[] certs;
        NameValuePairs pairs = new NameValuePairs();
        try {
            certs = CryptoManager.getInstance().getCACerts();
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_CA_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        this.mNicknameMapCertsTable.clear();
        Hashtable<String, Vector> vecTable = new Hashtable<String, Vector>();
        for (int i = 0; i < certs.length; ++i) {
            String nickname = certs[i].getNickname();
            v = vecTable.containsKey(nickname) ? (Vector)vecTable.get(nickname) : new Vector();
            v.addElement(certs[i]);
            vecTable.put(nickname, v);
        }
        Enumeration elms = vecTable.keys();
        while (elms.hasMoreElements()) {
            String key = (String)elms.nextElement();
            v = (Vector)vecTable.get(key);
            Object[] a = new X509Certificate[v.size()];
            v.copyInto(a);
            this.mNicknameMapCertsTable.put(key, (X509Certificate[])a);
        }
        Enumeration<String> keys = this.mNicknameMapCertsTable.keys();
        while (keys.hasMoreElements()) {
            String nickname = keys.nextElement();
            X509Certificate[] value = this.mNicknameMapCertsTable.get(nickname);
            for (int i = 0; i < value.length; ++i) {
                X509Certificate x509Certificate = value[i];
                if (!(x509Certificate instanceof InternalCertificate)) {
                    logger.trace("cert is not an InternalCertificate");
                    logger.trace("nickname: " + nickname + "  index " + i);
                    logger.trace("cert: " + value[i]);
                    continue;
                }
                InternalCertificate icert = (InternalCertificate)x509Certificate;
                int flag = icert.getSSLTrust();
                String trust = "U";
                if ((0x80 & flag) == 128) {
                    trust = "T";
                }
                X509CertImpl impl = null;
                try {
                    impl = new X509CertImpl(icert.getEncoded());
                    Date date = impl.getNotAfter();
                    String dateStr = this.mFormatter.format(date);
                    String vvalue = (String)pairs.get((Object)nickname);
                    String certValue = dateStr + "," + trust;
                    if (vvalue == null) {
                        pairs.put((Object)nickname, (Object)certValue);
                        continue;
                    }
                    pairs.put((Object)nickname, (Object)(vvalue + ";" + certValue));
                    continue;
                }
                catch (CertificateException e) {
                    logger.warn("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_CA_CERT_FOR", nickname, e.toString()), (Throwable)e);
                }
            }
        }
        return pairs;
    }

    @Override
    public void trustCert(String nickname, String date, String trust) throws EBaseException {
        try {
            X509Certificate[] certs = this.mNicknameMapCertsTable.get(nickname);
            if (certs == null) {
                EBaseException e = new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_TRUST_CERT", e.toString()));
                throw e;
            }
            for (int i = 0; i < certs.length; ++i) {
                Date qualifier;
                X509Certificate cert = certs[i];
                X509CertImpl certImpl = new X509CertImpl(cert.getEncoded());
                Date notAfter = certImpl.getNotAfter();
                if (!notAfter.equals(qualifier = this.mFormatter.parse(date))) continue;
                if (cert instanceof InternalCertificate) {
                    InternalCertificate internalCertificate = (InternalCertificate)cert;
                    if (trust.equals("Trust")) {
                        int trustflag = 152;
                        internalCertificate.setSSLTrust(trustflag);
                    } else {
                        internalCertificate.setSSLTrust(8);
                    }
                    break;
                }
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", ""));
            }
        }
        catch (CertificateException | ParseException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_TRUST_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
        }
    }

    public void deleteCACert(String nickname, String notAfterTime) throws EBaseException {
        try {
            X509Certificate[] certs = this.mNicknameMapCertsTable.get(nickname);
            if (certs == null) {
                EBaseException e = new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CA_CERT", e.toString()));
                throw e;
            }
            for (int i = 0; i < certs.length; ++i) {
                Date qualifier;
                X509Certificate cert = certs[i];
                X509CertImpl certImpl = new X509CertImpl(cert.getEncoded());
                Date notAfter = certImpl.getNotAfter();
                if (!notAfter.equals(qualifier = this.mFormatter.parse(notAfterTime))) continue;
                if (cert instanceof TokenCertificate) {
                    TokenCertificate tcert = (TokenCertificate)cert;
                    tcert.getOwningToken().getCryptoStore().deleteCert((X509Certificate)tcert);
                } else {
                    CryptoToken token = CryptoManager.getInstance().getInternalKeyStorageToken();
                    CryptoStore store = token.getCryptoStore();
                    store.deleteCert(cert);
                }
                this.mNicknameMapCertsTable.remove(nickname);
                break;
            }
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (NoSuchItemOnTokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ITEM_NOT_FOUND_ON_TOKEN", new String[0]));
        }
        catch (CertificateException | ParseException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
        }
    }

    @Override
    public void deleteCert(String nickname, String notAfterTime) throws EBaseException {
        boolean isUserCert = false;
        X509Certificate[] certs = null;
        try {
            certs = this.mNicknameMapCertsTable.get(nickname);
            if (certs == null && (certs = this.mNicknameMapUserCertsTable.get(nickname)) != null) {
                logger.debug("in mNicknameMapUserCertsTable, isUserCert is true");
                isUserCert = true;
            }
            if (certs == null) {
                EBaseException e = new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()));
                throw e;
            }
            for (int i = 0; i < certs.length; ++i) {
                Date qualifier;
                X509Certificate cert = certs[i];
                X509CertImpl certImpl = new X509CertImpl(cert.getEncoded());
                Date notAfter = certImpl.getNotAfter();
                if (!notAfter.equals(qualifier = this.mFormatter.parse(notAfterTime))) continue;
                if (cert instanceof TokenCertificate) {
                    TokenCertificate tcert = (TokenCertificate)cert;
                    tcert.getOwningToken().getCryptoStore().deleteCert((X509Certificate)tcert);
                } else {
                    CryptoToken token = CryptoManager.getInstance().getInternalKeyStorageToken();
                    CryptoStore store = token.getCryptoStore();
                    store.deleteCert(cert);
                }
                if (isUserCert) {
                    this.mNicknameMapUserCertsTable.remove(nickname);
                } else {
                    this.mNicknameMapCertsTable.remove(nickname);
                }
                break;
            }
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (NoSuchItemOnTokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_ITEM_NOT_FOUND_ON_TOKEN", new String[0]));
        }
        catch (CertificateException | ParseException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
        }
    }

    @Override
    public void deleteTokenCertificate(String nickname, String pathname) throws EBaseException {
        block14: {
            String suffix = "." + System.currentTimeMillis();
            try (PrintStream stream = new PrintStream(new FileOutputStream(pathname + suffix));){
                X509Certificate cert = CryptoManager.getInstance().findCertByNickname(nickname);
                Principal principal = cert.getSubjectDN();
                DN dn = new DN(principal.getName());
                BigInteger serialno = cert.getSerialNumber();
                String b64E = Utils.base64encode((byte[])cert.getEncoded(), (boolean)true);
                stream.println("-----BEGIN CERTIFICATE-----");
                stream.print(b64E);
                stream.println("-----END CERTIFICATE-----");
                if (!(cert instanceof TokenCertificate)) {
                    throw new EBaseException(CMS.getUserMessage("CMS_BASE_NOT_TOKEN_CERT", new String[0]));
                }
                TokenCertificate tcert = (TokenCertificate)cert;
                tcert.getOwningToken().getCryptoStore().deleteCert((X509Certificate)tcert);
                int index = nickname.indexOf(":");
                if (index <= 0) break block14;
                CryptoToken cToken = CryptoManager.getInstance().getInternalKeyStorageToken();
                CryptoStore store = cToken.getCryptoStore();
                X509Certificate[] allcerts = CryptoManager.getInstance().getCACerts();
                for (int i = 0; i < allcerts.length; ++i) {
                    try {
                        X509CertImpl certImpl = new X509CertImpl(allcerts[i].getEncoded());
                        X500Name certPrincipal = certImpl.getSubjectName();
                        DN certdn = new DN(certPrincipal.getName());
                        BigInteger certSerialNo = certImpl.getSerialNumber();
                        if (!dn.equals(certdn) || certSerialNo.compareTo(serialno) != 0) continue;
                        store.deleteCert(allcerts[i]);
                        break;
                    }
                    catch (Exception ee) {
                        logger.error("JssSubsystem: deleteTokenCertificate: " + ee.getMessage(), (Throwable)ee);
                    }
                }
            }
            catch (TokenException e) {
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
            }
            catch (NoSuchItemOnTokenException | ObjectNotFoundException e) {
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_ITEM_NOT_FOUND_ON_TOKEN", new String[0]));
            }
            catch (NotInitializedException e) {
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
            }
            catch (IOException | CertificateEncodingException e) {
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_DELETE_CERT", e.toString()), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
            }
        }
    }

    @Override
    public String getSubjectDN(String nickname) throws EBaseException {
        try {
            X509Certificate cert = CryptoManager.getInstance().findCertByNickname(nickname);
            X509CertImpl impl = new X509CertImpl(cert.getEncoded());
            return impl.getSubjectName().getName();
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_SUBJECT_NAME", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_SUBJECT_NAME", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (ObjectNotFoundException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_SUBJECT_NAME", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_SUBJECT_NAME", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
        }
    }

    @Override
    public void setRootCertTrust(String nickname, String serialno, String issuerName, String trust) throws EBaseException {
        X509Certificate cert = this.getCertificate(nickname, serialno, issuerName);
        if (cert instanceof InternalCertificate) {
            InternalCertificate internalCertificate = (InternalCertificate)cert;
            if (trust.equals("trust")) {
                int trustflag = 152;
                internalCertificate.setSSLTrust(trustflag);
            } else {
                internalCertificate.setSSLTrust(8);
            }
        }
    }

    public X509Certificate getCertificate(String nickname, String serialno, String issuerName) throws EBaseException {
        block7: {
            int index = nickname.indexOf(":");
            String tokenname = nickname.substring(0, index);
            if (CryptoUtil.isInternalToken((String)tokenname)) {
                nickname = nickname.substring(index + 1);
            }
            try {
                X509Certificate[] certs = CryptoManager.getInstance().findCertsByNickname(nickname);
                X509CertImpl impl = null;
                if (certs != null && certs.length > 0) {
                    for (int i = 0; i < certs.length; ++i) {
                        impl = new X509CertImpl(certs[i].getEncoded());
                        if (!impl.getIssuerName().toString().equals(issuerName) || !impl.getSerialNumber().toString().equals(serialno)) continue;
                        return certs[i];
                    }
                    break block7;
                }
                EBaseException e = new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()));
                throw e;
            }
            catch (NotInitializedException e) {
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
            }
            catch (TokenException e) {
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
            }
            catch (CertificateException e) {
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
            }
        }
        return null;
    }

    @Override
    public String getRootCertTrustBit(String nickname, String serialno, String issuerName) throws EBaseException {
        int index = nickname.indexOf(":");
        String tokenname = nickname.substring(0, index);
        if (CryptoUtil.isInternalToken((String)tokenname)) {
            nickname = nickname.substring(index + 1);
        }
        try {
            int i;
            X509Certificate[] certs = CryptoManager.getInstance().findCertsByNickname(nickname);
            X509CertImpl impl = null;
            if (certs != null && certs.length > 0) {
                for (i = 0; !(i >= certs.length || (impl = new X509CertImpl(certs[i].getEncoded())).getIssuerName().toString().equals(issuerName) && impl.getSerialNumber().toString().equals(serialno)); ++i) {
                }
            } else {
                EBaseException e = new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()));
                throw e;
            }
            String trust = "U";
            X509Certificate x509Certificate = certs[i];
            if (x509Certificate instanceof InternalCertificate) {
                InternalCertificate icert = (InternalCertificate)x509Certificate;
                int flag = icert.getSSLTrust();
                if ((0x80 & flag) == 128) {
                    trust = "T";
                }
            } else {
                trust = "N/A";
            }
            return trust;
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
        }
    }

    @Override
    public String getCertPrettyPrint(String nickname, String serialno, String issuerName, Locale locale) throws EBaseException {
        int index = nickname.indexOf(":");
        String tokenname = nickname.substring(0, index);
        if (CryptoUtil.isInternalToken((String)tokenname)) {
            nickname = nickname.substring(index + 1);
        }
        try {
            X509Certificate[] certs = CryptoManager.getInstance().findCertsByNickname(nickname);
            X509CertImpl impl = null;
            if (certs != null && certs.length > 0) {
                for (int i = 0; !(i >= certs.length || (impl = new X509CertImpl(certs[i].getEncoded())).getIssuerName().toString().equals(issuerName) && impl.getSerialNumber().toString().equals(serialno)); ++i) {
                }
            } else {
                EBaseException e = new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()));
                throw e;
            }
            CertPrettyPrint print = null;
            if (impl != null) {
                print = new CertPrettyPrint((java.security.cert.Certificate)impl);
            }
            return print == null ? null : print.toString(locale);
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
        }
    }

    @Override
    public String getCertPrettyPrintAndFingerPrint(String nickname, String serialno, String issuerName, Locale locale) throws EBaseException {
        int index = nickname.indexOf(":");
        String tokenname = nickname.substring(0, index);
        if (CryptoUtil.isInternalToken((String)tokenname)) {
            nickname = nickname.substring(index + 1);
        }
        try {
            X509Certificate[] certs = CryptoManager.getInstance().findCertsByNickname(nickname);
            X509CertImpl impl = null;
            if (certs != null && certs.length > 0) {
                for (int i = 0; !(i >= certs.length || (impl = new X509CertImpl(certs[i].getEncoded())).getIssuerName().toString().equals(issuerName) && impl.getSerialNumber().toString().equals(serialno)); ++i) {
                }
            } else {
                EBaseException e = new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()));
                throw e;
            }
            CertPrettyPrint print = null;
            String fingerPrint = "";
            if (impl != null) {
                print = new CertPrettyPrint((java.security.cert.Certificate)impl);
                fingerPrint = CertUtils.getFingerPrints(impl.getEncoded());
            }
            if (print == null || fingerPrint.isEmpty()) {
                return null;
            }
            return print.toString(locale) + "\nCertificate Fingerprints:\n" + fingerPrint;
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_NO_SUCH_ALGORITHM", e.toString()));
        }
    }

    @Override
    public String getCertPrettyPrint(String nickname, String date, Locale locale) throws EBaseException {
        try {
            Date d;
            X509Certificate[] certs = CryptoManager.getInstance().findCertsByNickname(nickname);
            if (certs == null || certs.length == 0) {
                certs = this.mNicknameMapCertsTable.get(nickname);
            }
            if (certs == null) {
                EBaseException e = new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
                logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()));
                throw e;
            }
            X509CertImpl impl = null;
            Date qualifier = this.mFormatter.parse(date);
            for (int i = 0; i < certs.length && !(d = (impl = new X509CertImpl(certs[i].getEncoded())).getNotAfter()).equals(qualifier); ++i) {
            }
            CertPrettyPrint print = null;
            if (impl != null) {
                print = new CertPrettyPrint((java.security.cert.Certificate)impl);
            }
            return print == null ? null : print.toString(locale);
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (CertificateException | ParseException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getCertPrettyPrint(String b64E, Locale locale) throws EBaseException {
        try {
            try {
                byte[] b = KeyCertUtil.convertB64EToByteArray(b64E);
                X509CertImpl impl = new X509CertImpl(b);
                CertPrettyPrint print = new CertPrettyPrint((java.security.cert.Certificate)impl);
                return print.toString(locale);
            }
            catch (CertificateException e) {
                try {
                    StringBuffer content = new StringBuffer();
                    String noHeader = CertUtils.stripCertBrackets(b64E);
                    String normalized = CertUtils.normalizeCertStr(noHeader);
                    byte[] data = Utils.base64decode((String)normalized);
                    ContentInfo ci = (ContentInfo)ASN1Util.decode((ASN1Template)ContentInfo.getTemplate(), (byte[])data);
                    if (!ci.getContentType().equals((Object)ContentInfo.SIGNED_DATA)) {
                        throw new CertificateException("PKCS #7 structure is not a SignedData");
                    }
                    SignedData sd = (SignedData)ci.getInterpretedContent();
                    if (!sd.hasCertificates()) {
                        throw new CertificateException("No certificates in PKCS #7 structure");
                    }
                    SET certs = sd.getCertificates();
                    int i = 0;
                    while (true) {
                        if (i >= certs.size()) {
                            return content.toString();
                        }
                        Certificate cert = (Certificate)certs.elementAt(i);
                        X509CertImpl certImpl = new X509CertImpl(ASN1Util.encode((ASN1Value)cert));
                        CertPrettyPrint print = new CertPrettyPrint((java.security.cert.Certificate)certImpl);
                        content.append(print.toString(Locale.getDefault()));
                        ++i;
                    }
                }
                catch (CertificateException e2) {
                    logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e2.toString()), (Throwable)e2);
                    throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e2.getMessage()));
                }
            }
        }
        catch (InvalidBERException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", "Failed to decode"));
        }
        catch (IOException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_PRINT_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", ""));
        }
    }

    public X509CertImpl signCert(PrivateKey privateKey, X509CertInfo certInfo, SignatureAlgorithm sigAlg) throws NoSuchTokenException, EBaseException, NotInitializedException {
        X509CertImpl x509CertImpl;
        DerOutputStream out = new DerOutputStream();
        try {
            X509CertImpl signedCert;
            CertificateAlgorithmId sId = (CertificateAlgorithmId)certInfo.get("algorithmID");
            AlgorithmId sigAlgId = (AlgorithmId)sId.get("algorithm");
            org.mozilla.jss.crypto.PrivateKey priKey = (org.mozilla.jss.crypto.PrivateKey)privateKey;
            CryptoToken token = priKey.getOwningToken();
            DerOutputStream tmp = new DerOutputStream();
            certInfo.encode((OutputStream)tmp);
            Signature signer = token.getSignatureContext(sigAlg);
            signer.initSign(priKey);
            signer.update(tmp.toByteArray());
            byte[] signed = signer.sign();
            sigAlgId.encode(tmp);
            tmp.putBitString(signed);
            out.write((byte)48, tmp);
            x509CertImpl = signedCert = new X509CertImpl(out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_SIGNED_FAILED", e.toString()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_ALG_NOT_SUPPORTED", e.toString()));
            }
            catch (TokenException e) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_ERROR_1", e.toString()));
            }
            catch (SignatureException e) {
                logger.error("JssSubsystem: " + e.getMessage(), (Throwable)e);
                this.engine.checkForAndAutoShutdown();
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_SIGNED_FAILED", e.toString()));
            }
            catch (InvalidKeyException e) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_INVALID_KEY_1", e.toString()));
            }
            catch (CertificateException e) {
                throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", e.toString()));
            }
        }
        out.close();
        return x509CertImpl;
    }

    public void setAuthInfoAccess(CertificateExtensions ext, KeyCertData properties) throws Exception {
        String aia = properties.getAIA();
        if (aia == null || !aia.equals("true")) {
            return;
        }
        EngineConfig config = this.engine.getConfig();
        String hostname = config.getHostname();
        String port = this.engine.getEENonSSLPort();
        AuthInfoAccessExtension aiaExt = new AuthInfoAccessExtension(false);
        if (hostname != null && port != null) {
            String location = "http://" + hostname + ":" + port + "/ca/ocsp";
            GeneralName ocspName = new GeneralName((GeneralNameInterface)new URIName(location));
            aiaExt.addAccessDescription(AuthInfoAccessExtension.METHOD_OCSP, ocspName);
        }
        ext.set("AuthInfoAccessExtension", (Object)aiaExt);
    }

    @Override
    public X509CertImpl getSignedCert(KeyCertData data, String certType, PrivateKey priKey) throws EBaseException {
        CertificateInfo cert = null;
        if (certType.equals("caSigningCert")) {
            cert = new CASigningCert(data);
        } else if (certType.equals("ocspSigningCert")) {
            cert = new OCSPSigningCert(data);
        } else if (certType.equals("serverCert")) {
            cert = new SSLCert(data);
        } else if (certType.equals("serverCertRadm")) {
            cert = new SSLSelfSignedCert(data);
        }
        if (cert == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", ""));
        }
        X509CertInfo certInfo = null;
        X509CertImpl signedCert = null;
        try {
            certInfo = cert.getCertInfo();
            CertificateExtensions exts = (CertificateExtensions)certInfo.get("extensions");
            KeyCertData keyCertData = cert.getProperties();
            this.setAuthInfoAccess(exts, keyCertData);
            SignatureAlgorithm sigAlg = (SignatureAlgorithm)data.get("signatureAlg");
            signedCert = this.signCert(priKey, certInfo, sigAlg);
        }
        catch (NoSuchTokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_SIGN_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_NOT_FOUND", ""));
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_SIGN_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (PQGParamGenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_SIGN_CERT", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_PQG_GEN_FAILED", new String[0]));
        }
        catch (Exception e) {
            logger.error("JssSubsystem: Unable to sign certificate: " + e.getMessage(), (Throwable)e);
            throw new EBaseException("Unable to sign certificate: " + e.getMessage(), (Throwable)e);
        }
        return signedCert;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isCACert(String fullNickname) throws EBaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CertificateExtensions getExtensions(String tokenname, String nickname) throws EBaseException {
        try {
            return KeyCertUtil.getExtensions(tokenname, nickname);
        }
        catch (NotInitializedException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_EXTENSIONS", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", new String[0]));
        }
        catch (TokenException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_EXTENSIONS", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_TOKEN_ERROR", new String[0]));
        }
        catch (ObjectNotFoundException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_EXTENSIONS", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_NOT_FOUND", new String[0]));
        }
        catch (IOException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_EXTENSIONS", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_DECODE_CERT_FAILED", new String[0]));
        }
        catch (CertificateException e) {
            logger.error("JssSubsystem: " + CMS.getLogMessage("CMSCORE_SECURITY_GET_EXTENSIONS", e.toString()), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CERT_ERROR", ""));
        }
    }

    @Override
    public void checkCertificateExt(String ext) throws EBaseException {
        KeyCertUtil.checkCertificateExt(ext);
    }

    public void checkKeyLength(String keyType, int keyLength, String certType, int minRSAKeyLen) throws EBaseException {
    }

    @Override
    public PQGParams getPQG(int keysize) {
        return KeyCertUtil.getPQG(keysize);
    }

    @Override
    public PQGParams getCAPQG(int keysize, ConfigStore store) throws EBaseException {
        return KeyCertUtil.getCAPQG(keysize, store);
    }

    @Override
    public CertificateExtensions getCertExtensions(String tokenname, String nickname) throws NotInitializedException, TokenException, ObjectNotFoundException, IOException, CertificateException {
        return KeyCertUtil.getExtensions(tokenname, nickname);
    }

    public static void main(String[] args) throws Exception {
        int i;
        JssSubsystem jss = new JssSubsystem();
        byte[] test = new byte[]{1, 1, 1, 1, 1};
        for (i = 0; i < 5; ++i) {
            System.out.println("test[" + i + "] : value before: " + test[i]);
        }
        jss.obscureBytes(test, "random");
        System.out.println("******************");
        for (i = 0; i < 5; ++i) {
            System.out.println("test[" + i + "] : value now: " + test[i]);
        }
    }

    static {
        mCipherNames.put("rsa_null_md5", 1);
        mCipherNames.put("rsa_rc4_40_md5", 3);
        mCipherNames.put("rsa_rc4_128_md5", 4);
        mCipherNames.put("rsa_rc2_40_md5", 6);
        mCipherNames.put("rsa_des_sha", 9);
        mCipherNames.put("rsa_3des_sha", 10);
        mCipherNames.put("fortezza", 29);
        mCipherNames.put("fortezza_rc4_128_sha", 30);
        mCipherNames.put("rsa_fips_3des_sha", 65279);
        mCipherNames.put("rsa_fips_des_sha", 65278);
        mCipherNames.put("tls_rsa_rc4_56_sha", 100);
        mCipherNames.put("tls_rsa_des_sha", 98);
    }
}

