/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.security;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mozilla.jss.SecretDecoderRing.Decryptor;
import org.mozilla.jss.SecretDecoderRing.Encryptor;
import org.mozilla.jss.SecretDecoderRing.KeyManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.util.Base64OutputStream;
import org.mozilla.jss.util.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PWsdrCache {
    public static Logger logger = LoggerFactory.getLogger(PWsdrCache.class);
    public static final String PROP_PWC_TOKEN_NAME = "pwcTokenname";
    public static final String PROP_PWC_KEY_ID = "pwcKeyid";
    public static final String PROP_PWC_NICKNAME = "sso_key";
    protected EngineConfig engineConfig;
    private String mPWcachedb = null;
    private boolean mIsTool = false;
    private byte[] mKeyID = null;
    private String mTokenName = null;
    private CryptoToken mToken = null;

    public PWsdrCache() {
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public void setEngineConfig(EngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    public void init() throws EBaseException {
        try {
            this.mPWcachedb = this.engineConfig.getString("pwCache");
            logger.debug("PWsdrCache: got pwCache file path from configstore");
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage("CMSCORE_SECURITY_GET_CONFIG", new Object[0]), (Throwable)e);
        }
        this.initToken();
        this.initKey();
    }

    private void initToken() throws EBaseException {
        if (this.mToken == null) {
            try {
                this.mTokenName = this.engineConfig.getString(PROP_PWC_TOKEN_NAME);
                logger.debug("PWsdrCache: pwcTokenname specified.  Use token for SDR key. tokenname= " + this.mTokenName);
                this.mToken = CryptoUtil.getKeyStorageToken((String)this.mTokenName);
            }
            catch (Exception e) {
                logger.error("PWsdrCache: " + e.getMessage(), (Throwable)e);
                throw new EBaseException(e);
            }
        }
    }

    private void initKey() throws EBaseException {
        if (this.mKeyID == null) {
            try {
                String keyID = this.engineConfig.getString(PROP_PWC_KEY_ID);
                logger.debug("PWsdrCache: retrieved PWC SDR key");
                this.mKeyID = this.base64Decode(keyID);
            }
            catch (Exception e) {
                logger.error("PWsdrCache: no pwcSDRKey specified", (Throwable)e);
                throw new EBaseException(e);
            }
        }
    }

    public PWsdrCache(String pwCache, String pwcTokenname, byte[] keyId, boolean isTool) throws Exception {
        this.mPWcachedb = pwCache;
        this.mIsTool = isTool;
        this.mTokenName = pwcTokenname;
        if (keyId != null) {
            this.mKeyID = keyId;
        }
        this.mToken = CryptoUtil.getKeyStorageToken((String)this.mTokenName);
        logger.debug("PWsdrCache: token: " + this.mToken.getName());
    }

    public byte[] getKeyId() {
        return this.mKeyID;
    }

    public String getTokenName() {
        return this.mTokenName;
    }

    public void deleteUniqueNamedKey(String nickName) throws Exception {
        KeyManager km = new KeyManager(this.mToken);
        km.deleteUniqueNamedKey(nickName);
    }

    public byte[] generateSDRKey() throws Exception {
        return this.generateSDRKeyWithNickName(PROP_PWC_NICKNAME);
    }

    public byte[] generateSDRKeyWithNickName(String nickName) throws Exception {
        block5: {
            try {
                if (this.mIsTool) break block5;
                KeyManager km = new KeyManager(this.mToken);
                try {
                    if (!km.uniqueNamedKeyExists(nickName)) {
                        this.mKeyID = km.generateUniqueNamedKey(nickName);
                    }
                }
                catch (TokenException e) {
                    logger.error("PWsdrCache: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            catch (Exception e) {
                logger.error("PWsdrCache: " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return this.mKeyID;
    }

    public byte[] base64Decode(String s) throws IOException {
        byte[] d = Utils.base64decode((String)s);
        return d;
    }

    public static String base64Encode(byte[] bytes) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (Base64OutputStream b64 = new Base64OutputStream(new PrintStream(new FilterOutputStream(output)));){
            b64.write(bytes);
            b64.flush();
            String string = output.toString("8859_1");
            return string;
        }
    }

    public PWsdrCache(String pwCache) throws EBaseException {
        this.mPWcachedb = pwCache;
        this.initToken();
        this.initKey();
    }

    public void addEntry(String tag, String pwd) throws EBaseException {
        this.addEntry(tag, pwd, null);
    }

    public void addEntry(Hashtable<String, String> ht) throws EBaseException {
        this.addEntry(null, null, ht);
    }

    public void addEntry(String tag, String pwd, Hashtable<String, String> tagPwds) throws EBaseException {
        StringBuffer stringToAdd = new StringBuffer();
        String bufs = null;
        if (tagPwds == null) {
            stringToAdd.append(tag + ":" + pwd + "\n");
        } else {
            Enumeration<String> enum1 = tagPwds.keys();
            while (enum1.hasMoreElements()) {
                tag = enum1.nextElement();
                pwd = tagPwds.get(tag);
                logger.debug("PWsdrCache: password tag: " + tag + " stored in " + this.mPWcachedb);
                stringToAdd.append(tag + ":" + pwd + "\n");
            }
        }
        String dcrypts = this.readPWcache();
        if (dcrypts != null) {
            Hashtable<String, String> ht = this.string2Hashtable(dcrypts);
            if (!ht.containsKey(tag)) {
                logger.debug("PWsdrCache: adding new tag: " + tag);
                ht.put(tag, pwd);
            } else {
                logger.debug("PWsdrCache: replacing tag: " + tag);
                ht.put(tag, pwd);
            }
            bufs = this.hashtable2String(ht);
        } else {
            logger.debug("PWsdrCache: adding new tag: " + tag);
            bufs = stringToAdd.toString();
        }
        this.writePWcache(bufs);
    }

    public void deleteEntry(String tag) throws EBaseException {
        Hashtable<String, String> ht;
        String bufs = null;
        String dcrypts = this.readPWcache();
        if (dcrypts != null) {
            ht = this.string2Hashtable(dcrypts);
            if (!ht.containsKey(tag)) {
                logger.debug("PWsdrCache: tag: " + tag + " does not exist");
                return;
            }
        } else {
            logger.debug("PWsdrCache: password cache contains no tags");
            return;
        }
        logger.debug("PWsdrCache: deleting tag: " + tag);
        ht.remove(tag);
        bufs = this.hashtable2String(ht);
        this.writePWcache(bufs);
    }

    public String readPWcache() throws EBaseException {
        logger.debug("PWsdrCache: about to read password cache");
        String dcrypts = null;
        Decryptor sdr = new Decryptor(this.mToken);
        int totalRead = 0;
        FileInputStream inputs = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            inputs = new FileInputStream(this.mPWcachedb);
            byte[] readbuf = new byte[2048];
            int numRead = 0;
            while ((numRead = inputs.read(readbuf)) != -1) {
                bos.write(readbuf, 0, numRead);
                totalRead += numRead;
            }
        }
        catch (FileNotFoundException e) {
            logger.error(CMS.getLogMessage("CMSCORE_SECURITY_PW_FILE", this.mPWcachedb, e.toString()), (Throwable)e);
            throw new EBaseException(e.toString() + ": " + this.mPWcachedb);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSCORE_SECURITY_PW_FILE", this.mPWcachedb, e.toString()), (Throwable)e);
            throw new EBaseException(e.toString() + ": " + this.mPWcachedb);
        }
        finally {
            if (inputs != null) {
                try {
                    inputs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (totalRead > 0) {
            try {
                byte[] dcryptb = sdr.decrypt(bos.toByteArray());
                dcrypts = new String(dcryptb, "UTF-8");
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage("CMSCORE_SECURITY_PW_DECRYPT", e.toString()), (Throwable)e);
                throw new EBaseException("password cache decrypt failed");
            }
        }
        return dcrypts;
    }

    public void writePWcache(String bufs) throws EBaseException {
        block24: {
            FileOutputStream outstream = null;
            try {
                Encryptor sdr = new Encryptor(this.mToken, this.mKeyID, Encryptor.DEFAULT_ENCRYPTION_ALG);
                byte[] writebuf = null;
                try {
                    writebuf = sdr.encrypt(bufs.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    logger.error(CMS.getLogMessage("CMSCORE_SECURITY_PW_ENCRYPT", e.toString()), (Throwable)e);
                    throw new EBaseException("password cache encrypt failed", (Throwable)e);
                }
                File tmpPWcache = new File(this.mPWcachedb + ".tmp");
                if (tmpPWcache.exists()) {
                    if (!tmpPWcache.delete()) {
                        logger.warn("PWsdrCache: Could not delete the existing " + this.mPWcachedb + ".tmp file.");
                    }
                    tmpPWcache = new File(this.mPWcachedb + ".tmp");
                }
                outstream = new FileOutputStream(this.mPWcachedb + ".tmp");
                outstream.write(writebuf);
                File origFile = new File(this.mPWcachedb);
                try {
                    if (Utils.isNT()) {
                        Utils.exec((String)("copy " + tmpPWcache.getAbsolutePath().replace('/', '\\') + " " + origFile.getAbsolutePath().replace('/', '\\')));
                    } else {
                        Utils.exec((String)("cp -p " + tmpPWcache.getAbsolutePath() + " " + origFile.getAbsolutePath()));
                    }
                    if (!origFile.exists()) break block24;
                    if (!Utils.isNT()) {
                        try {
                            Utils.exec((String)("chmod 00660 " + origFile.getCanonicalPath()));
                        }
                        catch (IOException e) {
                            logger.warn("PWsdrCache: Unable to change file permissions: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!tmpPWcache.delete()) {
                        logger.warn("PWsdrCache: Could not delete the existing " + this.mPWcachedb + ".tmp file.");
                    }
                    logger.debug("PWsdrCache: operation completed for " + this.mPWcachedb);
                }
                catch (Exception exx) {
                    logger.error(CMS.getLogMessage("CMSCORE_SECURITY_PW_CACHE", exx.toString()), (Throwable)exx);
                    throw new EBaseException(exx.toString() + ": " + this.mPWcachedb, (Throwable)exx);
                }
            }
            catch (FileNotFoundException e) {
                logger.error(CMS.getLogMessage("CMSCORE_SECURITY_PW_FILE", this.mPWcachedb, e.toString()), (Throwable)e);
                throw new EBaseException(e.toString() + ": " + this.mPWcachedb, (Throwable)e);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage("CMSCORE_SECURITY_PW_FILE", this.mPWcachedb, e.toString()), (Throwable)e);
                throw new EBaseException(e.toString() + ": " + this.mPWcachedb, (Throwable)e);
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage("CMSCORE_SECURITY_PW_FILE", this.mPWcachedb, e.toString()), (Throwable)e);
                throw new EBaseException(e.toString() + ": " + this.mPWcachedb, (Throwable)e);
            }
            finally {
                if (outstream != null) {
                    try {
                        outstream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String hashtable2String(Hashtable<String, String> ht) {
        Enumeration<String> enum1 = ht.keys();
        StringBuffer returnString = new StringBuffer();
        while (enum1.hasMoreElements()) {
            String tag = enum1.nextElement();
            String pwd = ht.get(tag);
            returnString.append(tag + ":" + pwd + "\n");
        }
        return returnString.toString();
    }

    public Hashtable<String, String> string2Hashtable(String cache) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(cache, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int colonIdx = line.indexOf(":");
            if (colonIdx == -1) continue;
            String tag = line.substring(0, colonIdx);
            String passwd = line.substring(colonIdx + 1, line.length());
            ht.put(tag.trim(), passwd.trim());
        }
        return ht;
    }

    public Password getEntry(String fileName, String tag) {
        this.mPWcachedb = fileName;
        return this.getEntry(tag);
    }

    public Password getEntry(String tag) {
        Hashtable<String, String> pwTable = null;
        String pw = null;
        logger.debug("PWsdrCache: in getEntry, tag=" + tag);
        if (this.mPWcachedb == null) {
            logger.warn("PWsdrCache: mPWcachedb file path name is not initialized");
            return null;
        }
        String dcrypts = null;
        try {
            dcrypts = this.readPWcache();
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage("CMSCORE_SECURITY_PW_READ", e.toString()), (Throwable)e);
            return null;
        }
        if (dcrypts != null) {
            String cache = dcrypts;
            pwTable = this.string2Hashtable(cache);
            logger.debug("PWsdrCache: in getEntry, pw cache parsed");
            pw = pwTable.get(tag);
        }
        if (pw == null) {
            logger.warn(CMS.getLogMessage("CMSCORE_SECURITY_PW_TAG", tag));
            return null;
        }
        logger.debug("PWsdrCache: getEntry gotten password for " + tag);
        return new Password(pw.toCharArray());
    }

    public static boolean isNT() {
        return File.separator.equals("\\");
    }

    public static boolean exec(String cmd) throws IOException {
        String[] cmds = null;
        cmds = PWsdrCache.isNT() ? new String[]{"cmd", "/c", cmd} : new String[]{"/bin/sh", "-c", cmd};
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmds);
            process.waitFor();
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return process.exitValue() == 0;
    }

    public boolean pprint() {
        String dcrypts = null;
        try {
            dcrypts = this.readPWcache();
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage("CMSCORE_SECURITY_PW_READ", e.toString()), (Throwable)e);
            return false;
        }
        logger.debug("PWsdrCache: ----- Password Cache Content -----");
        if (dcrypts != null) {
            StringTokenizer st = new StringTokenizer(dcrypts, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int colonIdx = line.indexOf(":");
                if (colonIdx != -1) {
                    String tag = line.substring(0, colonIdx);
                    String passwd = line.substring(colonIdx + 1, line.length());
                    logger.debug("PWsdrCache: " + tag.trim() + " : " + passwd.trim());
                    continue;
                }
                logger.warn("PWsdrCache: invalid format");
            }
        }
        return true;
    }
}

