/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.logging;

import com.netscape.certsrv.logging.AuditClient;
import com.netscape.certsrv.logging.AuditConfig;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.logging.AuditCLI;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditModifyCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(AuditModifyCLI.class);
    public AuditCLI auditCLI;

    public AuditModifyCLI(AuditCLI auditCLI) {
        super("mod", "Modify audit configuration", (CLI)auditCLI);
        this.auditCLI = auditCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "action", true, "Action: enable, disable.");
        option.setArgName("action");
        this.options.addOption(option);
        option = new Option(null, "input", true, "Input file containing audit configuration.");
        option.setArgName("file");
        this.options.addOption(option);
        option = new Option(null, "output", true, "Output file to store audit configuration.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        AuditConfig auditConfig;
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String action = cmd.getOptionValue("action");
        String input = cmd.getOptionValue("input");
        String output = cmd.getOptionValue("output");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        AuditClient auditClient = this.auditCLI.getAuditClient();
        if (action == null) {
            if (input == null) {
                throw new Exception("Missing action or input file.");
            }
            try (BufferedReader in = new BufferedReader(new FileReader(input));
                 StringWriter sw = new StringWriter();
                 PrintWriter out = new PrintWriter((Writer)sw, true);){
                String line;
                while ((line = in.readLine()) != null) {
                    out.println(line);
                }
                auditConfig = (AuditConfig)JSONSerializer.fromJSON((String)sw.toString(), AuditConfig.class);
            }
            auditConfig = auditClient.updateAuditConfig(auditConfig);
        } else {
            if (input != null) {
                throw new Exception("Action and input file are mutually exclusive.");
            }
            auditConfig = auditClient.changeAuditStatus(action);
        }
        MainCLI.printMessage("Modified audit configuration");
        if (output == null) {
            AuditCLI.printAuditConfig(auditConfig);
        } else {
            try (PrintWriter out = new PrintWriter(new FileWriter(output));){
                out.println(auditConfig.toJSON());
            }
        }
    }
}

