/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs11;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs11.PKCS11CertCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.provider.java.security.JSSLoadStoreParameter;

public class PKCS11CertFindCLI
extends CommandCLI {
    public PKCS11CertCLI certCLI;

    public PKCS11CertFindCLI(PKCS11CertCLI certCLI) {
        super("find", "Find PKCS #11 certificates", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        String tokenName = this.getConfig().getTokenName();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
        KeyStore ks = KeyStore.getInstance("pkcs11");
        ks.load((KeyStore.LoadStoreParameter)new JSSLoadStoreParameter(token));
        Enumeration<String> aliases = ks.aliases();
        boolean first = true;
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (cert == null) continue;
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            PKCS11CertCLI.printCertInfo(alias, cert);
        }
    }
}

