/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.user.UserCertData;
import com.netscape.certsrv.user.UserClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.user.UserCertCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URLEncoder;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCertShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(UserCertShowCLI.class);
    public UserCertCLI userCertCLI;

    public UserCertShowCLI(UserCertCLI userCertCLI) {
        super("show", "Show user certificate", (CLI)userCertCLI);
        this.userCertCLI = userCertCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <User ID> <Cert ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output file");
        option.setArgName("file");
        this.options.addOption(option);
        this.options.addOption(null, "pretty", false, "Pretty print");
        this.options.addOption(null, "encoded", false, "Base-64 encoded");
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 2) {
            throw new Exception("Incorrect number of arguments specified.");
        }
        boolean showPrettyPrint = cmd.hasOption("pretty");
        boolean showEncoded = cmd.hasOption("encoded");
        String userID = cmdArgs[0];
        String certID = cmdArgs[1];
        String file = cmd.getOptionValue("output");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        UserClient userClient = this.userCertCLI.getUserClient();
        UserCertData userCertData = userClient.getUserCert(userID, URLEncoder.encode(certID, "UTF-8"));
        String encoded = userCertData.getEncoded();
        if (encoded != null && file != null) {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            out.print(encoded);
            out.close();
        }
        MainCLI.printMessage("Certificate \"" + userCertData.getID() + "\"");
        UserCertCLI.printCert(userCertData, showPrettyPrint, showEncoded);
    }
}

