/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBAttrMapper;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.dbs.BigIntegerMapper;
import com.netscape.cmscore.dbs.ByteArrayMapper;
import com.netscape.cmscore.dbs.DBRegistry;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DBSearchResults;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.DateArrayMapper;
import com.netscape.cmscore.dbs.DateMapper;
import com.netscape.cmscore.dbs.IntegerMapper;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRecordList;
import com.netscape.cmscore.dbs.KeyStateMapper;
import com.netscape.cmscore.dbs.MetaInfoMapper;
import com.netscape.cmscore.dbs.PublicKeyMapper;
import com.netscape.cmscore.dbs.Repository;
import com.netscape.cmscore.dbs.StringMapper;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRepository
extends Repository {
    public static Logger logger = LoggerFactory.getLogger(KeyRepository.class);
    public static final String PROP_KEY_ID_GENERATOR = "key.id.generator";
    public static final String DEFAULT_KEY_ID_GENERATOR = "legacy";
    public static final String PROP_KEY_ID_LENGTH = "key.id.length";

    public KeyRepository(SecureRandom secureRandom, DBSubsystem dbSubsystem) {
        super(dbSubsystem, 16);
        this.secureRandom = secureRandom;
    }

    public void init() throws Exception {
        logger.info("KeyRepository: Initializing key repository");
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        this.mBaseDN = dbConfig.getSerialDN() + "," + this.dbSubsystem.getBaseDN();
        logger.info("KeyRepository: - base DN: " + this.mBaseDN);
        String value = dbConfig.getString(PROP_KEY_ID_GENERATOR, DEFAULT_KEY_ID_GENERATOR);
        logger.info("KeyRepository: - key ID generator: " + value);
        this.setIDGenerator(value);
        if (this.idGenerator == Repository.IDGenerator.RANDOM) {
            this.idLength = dbConfig.getInteger(PROP_KEY_ID_LENGTH);
            logger.info("KeyRepository: - key ID length: " + this.idLength);
        } else {
            this.initLegacyGenerator();
        }
        DBRegistry reg = this.dbSubsystem.getRegistry();
        String[] keyRecordOC = new String[]{"top", "keyRecord"};
        if (!reg.isObjectClassRegistered(KeyRecord.class.getName())) {
            reg.registerObjectClass(KeyRecord.class.getName(), keyRecordOC);
        }
        if (!reg.isAttributeRegistered("keySerialNumber")) {
            reg.registerAttribute("keySerialNumber", (DBAttrMapper)new BigIntegerMapper("serialno"));
        }
        if (!reg.isAttributeRegistered("algorithm")) {
            reg.registerAttribute("algorithm", (DBAttrMapper)new StringMapper("algorithm"));
        }
        if (!reg.isAttributeRegistered("keyState")) {
            reg.registerAttribute("keyState", (DBAttrMapper)new KeyStateMapper("keyState"));
        }
        if (!reg.isAttributeRegistered("keySize")) {
            reg.registerAttribute("keySize", (DBAttrMapper)new IntegerMapper("keySize"));
        }
        if (!reg.isAttributeRegistered("keyOwnerName")) {
            reg.registerAttribute("keyOwnerName", (DBAttrMapper)new StringMapper("ownerName"));
        }
        if (!reg.isAttributeRegistered("privateKey")) {
            reg.registerAttribute("privateKey", (DBAttrMapper)new ByteArrayMapper("privateKeyData"));
        }
        if (!reg.isAttributeRegistered("publicKey")) {
            reg.registerAttribute("publicKey", (DBAttrMapper)new PublicKeyMapper("publicKeyData"));
        }
        if (!reg.isAttributeRegistered("dateOfRecovery")) {
            reg.registerAttribute("dateOfRecovery", (DBAttrMapper)new DateArrayMapper("dateOfRecovery"));
        }
        if (!reg.isAttributeRegistered("keyCreateTime")) {
            reg.registerAttribute("keyCreateTime", (DBAttrMapper)new DateMapper("dateOfCreate"));
        }
        if (!reg.isAttributeRegistered("keyModifyTime")) {
            reg.registerAttribute("keyModifyTime", (DBAttrMapper)new DateMapper("dateOfModify"));
        }
        if (!reg.isAttributeRegistered("keyMetaInfo")) {
            reg.registerAttribute("keyMetaInfo", (DBAttrMapper)new MetaInfoMapper("metaInfo"));
        }
        if (!reg.isAttributeRegistered("keyArchivedBy")) {
            reg.registerAttribute("keyArchivedBy", (DBAttrMapper)new StringMapper("archivedBy"));
        }
        if (!reg.isAttributeRegistered("clientId")) {
            reg.registerAttribute("clientId", (DBAttrMapper)new StringMapper("clientId"));
        }
        if (!reg.isAttributeRegistered("status")) {
            reg.registerAttribute("status", (DBAttrMapper)new StringMapper("status"));
        }
        if (!reg.isAttributeRegistered("dataType")) {
            reg.registerAttribute("dataType", (DBAttrMapper)new StringMapper("dataType"));
        }
        if (!reg.isAttributeRegistered("realm")) {
            reg.registerAttribute("realm", (DBAttrMapper)new StringMapper("realm"));
        }
    }

    public void initLegacyGenerator() throws Exception {
        String incrementNo;
        DatabaseConfig dbConfig = this.dbSubsystem.getDBConfigStore();
        this.rangeDN = dbConfig.getSerialRangeDN() + "," + this.dbSubsystem.getBaseDN();
        logger.info("KeyRepository: - range DN: " + this.rangeDN);
        this.minSerialName = "beginSerialNumber";
        String minSerial = dbConfig.getBeginSerialNumber();
        if (minSerial != null) {
            this.mMinSerialNo = new BigInteger(minSerial, this.mRadix);
        }
        logger.info("KeyRepository: - min serial: " + this.mMinSerialNo);
        this.maxSerialName = "endSerialNumber";
        String maxSerial = dbConfig.getEndSerialNumber();
        if (maxSerial != null) {
            this.mMaxSerialNo = new BigInteger(maxSerial, this.mRadix);
        }
        logger.info("KeyRepository: - max serial: " + this.mMaxSerialNo);
        this.nextMinSerialName = "nextBeginSerialNumber";
        String nextMinSerial = dbConfig.getNextBeginSerialNumber();
        this.mNextMinSerialNo = nextMinSerial == null || nextMinSerial.equals("-1") ? null : new BigInteger(nextMinSerial, this.mRadix);
        logger.info("KeyRepository: - next min serial: " + this.mNextMinSerialNo);
        this.nextMaxSerialName = "nextEndSerialNumber";
        String nextMaxSerial = dbConfig.getNextEndSerialNumber();
        this.mNextMaxSerialNo = nextMaxSerial == null || nextMaxSerial.equals("-1") ? null : new BigInteger(nextMaxSerial, this.mRadix);
        logger.info("KeyRepository: - next max serial: " + this.mNextMaxSerialNo);
        String lowWaterMark = dbConfig.getSerialLowWaterMark();
        if (lowWaterMark != null) {
            this.mLowWaterMarkNo = new BigInteger(lowWaterMark, this.mRadix);
        }
        if ((incrementNo = dbConfig.getSerialIncrement()) != null) {
            this.mIncrementNo = new BigInteger(incrementNo, this.mRadix);
        }
    }

    public DBSubsystem getDBSubsystem() {
        return this.dbSubsystem;
    }

    public String getDN() {
        return this.mBaseDN;
    }

    public void removeAllObjects() throws EBaseException {
        String filter = "(keyOwnerName=*)";
        KeyRecordList list = this.findKeyRecordsInList(filter, null, "serialno", 10);
        int size = list.getSize();
        Enumeration e = list.getKeyRecords(0, size - 1);
        while (e.hasMoreElements()) {
            KeyRecord rec = (KeyRecord)e.nextElement();
            this.deleteKeyRecord(rec.getSerialNumber());
        }
    }

    public void addKeyRecord(KeyRecord record) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + record.getSerialNumber().toString() + "," + this.getDN();
            if (s != null) {
                s.add(name, (IDBObj)record);
            }
        }
    }

    public KeyRecord readKeyRecord(BigInteger serialNo) throws EBaseException {
        if (serialNo == null) {
            throw new EBaseException("Invalid Serial Number.");
        }
        KeyRecord rec = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + serialNo.toString() + "," + this.getDN();
            if (s != null) {
                rec = (KeyRecord)s.read(name);
            }
        }
        if (rec == null) {
            throw new EBaseException("Failed to recover Key for Serial Number " + serialNo);
        }
        return rec;
    }

    public KeyRecord readKeyRecord(X500Name ownerName) throws EBaseException {
        KeyRecord keyRec = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            if (ownerName != null) {
                String filter = "(keyOwnerName=" + ownerName.toString() + ")";
                DBSearchResults res = s.search(this.getDN(), filter);
                keyRec = (KeyRecord)res.nextElement();
            }
        }
        return keyRec;
    }

    public KeyRecord readKeyRecord(PublicKey publicKey) throws EBaseException {
        byte[] data = publicKey.getEncoded();
        if (data == null) {
            throw new EBaseException("null data");
        }
        KeyRecord rec = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String filter = "(publicKey=" + KeyRepository.escapeBinaryData(data) + ")";
            if (s != null) {
                DBSearchResults res = s.search(this.getDN(), filter);
                rec = (KeyRecord)res.nextElement();
            }
        }
        return rec;
    }

    public KeyRecord readKeyRecord(String cert) throws EBaseException {
        KeyRecord rec = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String filter = "(publicKey=x509cert#\"" + cert + "\")";
            logger.debug("filter= " + filter);
            if (s != null) {
                DBSearchResults res = s.search(this.getDN(), filter);
                rec = (KeyRecord)res.nextElement();
            }
        }
        return rec;
    }

    public void modifyKeyRecord(BigInteger serialNo, ModificationSet mods) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + serialNo.toString() + "," + this.getDN();
            mods.add("keyModifyTime", 2, (Object)new Date());
            if (s != null) {
                s.modify(name, mods);
            }
        }
    }

    public void deleteKeyRecord(BigInteger serialNo) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + serialNo.toString() + "," + this.getDN();
            if (s != null) {
                s.delete(name);
            }
        }
    }

    public static String escapeBinaryData(byte[] data) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            result.append("\\" + Integer.toHexString(data[i]));
        }
        return result.toString();
    }

    public Enumeration<KeyRecord> searchKeys(String filter, int maxSize) throws EBaseException {
        Vector<KeyRecord> v = new Vector<KeyRecord>();
        try (DBSSession s = this.dbSubsystem.createSession();){
            DBSearchResults sr = s.search(this.getDN(), filter, maxSize);
            while (sr.hasMoreElements()) {
                v.add((KeyRecord)sr.nextElement());
            }
        }
        return v.elements();
    }

    public Enumeration<KeyRecord> searchKeys(String filter, int maxSize, int timeLimit) throws EBaseException {
        Vector<KeyRecord> v = new Vector<KeyRecord>();
        try (DBSSession s = this.dbSubsystem.createSession();){
            DBSearchResults sr = s.search(this.getDN(), filter, maxSize, timeLimit);
            while (sr.hasMoreElements()) {
                v.add((KeyRecord)sr.nextElement());
            }
        }
        return v.elements();
    }

    public KeyRecordList findKeyRecordsInList(String filter, String[] attrs, int pageSize) throws EBaseException {
        return this.findKeyRecordsInList(filter, attrs, "keySerialNumber", pageSize);
    }

    public KeyRecordList findKeyRecordsInList(String filter, String[] attrs, String sortKey, int pageSize) throws EBaseException {
        KeyRecordList list = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            if (s != null) {
                list = new KeyRecordList(s.createVirtualList(this.getDN(), "(&(objectclass=" + KeyRecord.class.getName() + ")" + filter + ")", attrs, sortKey, pageSize));
            }
        }
        return list;
    }

    public KeyRecordList findKeyRecordsInList(String filter, String[] attrs, String jumpTo, String sortKey, int pageSize) throws EBaseException {
        KeyRecordList list = null;
        int len = jumpTo.length();
        String jumpToVal = null;
        jumpToVal = len > 9 ? Integer.toString(len) + jumpTo : "0" + Integer.toString(len) + jumpTo;
        try (DBSSession s = this.dbSubsystem.createSession();){
            if (s != null) {
                list = new KeyRecordList(s.createVirtualList(this.getDN(), "(&(objectclass=" + KeyRecord.class.getName() + ")" + filter + ")", attrs, jumpToVal, sortKey, pageSize));
            }
        }
        return list;
    }

    public BigInteger getLastSerialNumberInRange(BigInteger serial_low_bound, BigInteger serial_upper_bound) throws EBaseException {
        logger.debug("KeyRepository:  in getLastSerialNumberInRange: low " + serial_low_bound + " high " + serial_upper_bound);
        if (serial_low_bound == null || serial_upper_bound == null || serial_low_bound.compareTo(serial_upper_bound) >= 0) {
            return null;
        }
        String ldapfilter = "(serialno=*)";
        String[] attrs = null;
        KeyRecordList recList = this.findKeyRecordsInList(ldapfilter, attrs, serial_upper_bound.toString(10), "serialno", -5);
        int size = -1;
        if (recList != null) {
            size = recList.getSize();
        }
        logger.debug("KeyRepository: getLastSerialNumberInRange: recList size " + size);
        if (size <= 0) {
            logger.debug("KeyRepository: getLastSerialNumberInRange: index may be empty");
            BigInteger ret = new BigInteger(serial_low_bound.toString(10));
            ret = ret.add(new BigInteger("-1"));
            logger.debug("KeyRepository: getLastSerialNumberInRange returning: " + ret);
            return ret;
        }
        int ltSize = recList.getSizeBeforeJumpTo();
        logger.debug("KeyRepository:getLastSerialNumberInRange: ltSize " + ltSize);
        KeyRecord curRec = null;
        for (int i = 0; i < 5; ++i) {
            curRec = recList.getKeyRecord(i);
            if (curRec != null) {
                BigInteger serial = curRec.getSerialNumber();
                logger.debug("KeyRepository:  getLastCertRecordSerialNo:  serialno  " + serial);
                if (serial.compareTo(serial_low_bound) != 0 && serial.compareTo(serial_low_bound) != 1 || serial.compareTo(serial_upper_bound) != 0 && serial.compareTo(serial_upper_bound) != -1) continue;
                logger.debug("KeyRepository: getLastSerialNumberInRange returning: " + serial);
                return serial;
            }
            logger.debug("KeyRepository:  getLastSerialNumberInRange:found null from getCertRecord");
        }
        BigInteger ret = new BigInteger(serial_low_bound.toString(10));
        ret = ret.add(new BigInteger("-1"));
        logger.debug("KeyRepository: getLastSerialNumberInRange returning: " + ret);
        return ret;
    }

    public void shutdown() {
    }
}

