/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.ocsp.IDefStore;
import com.netscape.cms.ocsp.CRLUpdater;
import com.netscape.cms.ocsp.TempCRLIssuingPointRecord;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.RepositoryRecord;
import com.netscape.cmsutil.ocsp.CertID;
import com.netscape.cmsutil.ocsp.CertStatus;
import com.netscape.cmsutil.ocsp.GoodInfo;
import com.netscape.cmsutil.ocsp.Request;
import com.netscape.cmsutil.ocsp.RevokedInfo;
import com.netscape.cmsutil.ocsp.SingleResponse;
import com.netscape.cmsutil.ocsp.UnknownInfo;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPStore
implements IDefStore,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LDAPStore.class);
    private static final String PROP_NUM_CONNS = "numConns";
    private static final String PROP_REFRESH_IN_SEC = "refreshInSec";
    private static final int DEF_REFRESH_IN_SEC = 86400;
    private static final String PROP_BASE_DN = "baseDN";
    private static final String PROP_BY_NAME = "byName";
    private static final String PROP_CRL_ATTR = "crlAttr";
    private static final String DEF_CRL_ATTR = "certificateRevocationList;binary";
    private static final String PROP_CA_CERT_ATTR = "caCertAttr";
    private static final String DEF_CA_CERT_ATTR = "cACertificate;binary";
    private static final String PROP_HOST = "host";
    private static final String PROP_PORT = "port";
    private static final String PROP_NOT_FOUND_GOOD = "notFoundAsGood";
    private static final String PROP_INCLUDE_NEXT_UPDATE = "includeNextUpdate";
    private ConfigStore mConfig;
    private String mId = null;
    private String mCRLAttr = null;
    private boolean mByName = true;
    private String mCACertAttr = null;
    protected Hashtable<String, Long> mReqCounts = new Hashtable();
    private Hashtable<X509CertImpl, X509CRLImpl> mCRLs = new Hashtable();

    @Override
    public boolean isByName() {
        return this.mByName;
    }

    public String[] getExtendedPluginInfo() {
        return this.getExtendedPluginInfo(Locale.getDefault());
    }

    public String[] getExtendedPluginInfo(Locale locale) {
        Vector<Object> v = new Vector<Object>();
        v.addElement("notFoundAsGood;boolean; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_LDAPSTORE_PROP_NOT_FOUND_GOOD", (String[])new String[0]));
        v.addElement("includeNextUpdate;boolean; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_LDAPSTORE_PROP_INCLUDE_NEXT_UPDATE", (String[])new String[0]));
        v.addElement("numConns;number; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_LDAPSTORE_PROP_NUM_CONNS", (String[])new String[0]));
        v.addElement("byName;boolean; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_LDAPSTORE_PROP_BY_NAME", (String[])new String[0]));
        v.addElement("crlAttr;string; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_LDAPSTORE_PROP_CRL_ATTR", (String[])new String[0]));
        v.addElement("caCertAttr;string; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_LDAPSTORE_PROP_CA_CERT_ATTR", (String[])new String[0]));
        v.addElement("HELP_TEXT; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_LDAPSTORE_DESC", (String[])new String[0]));
        v.addElement("HELP_TOKEN;configuration-ocspstores-ldapstore");
        return Utils.getStringArrayFromVector(v);
    }

    @Override
    public void init(ConfigStore config, DBSubsystem dbSubsystem) throws EBaseException {
        this.mConfig = config;
        this.mCRLAttr = this.mConfig.getString(PROP_CRL_ATTR, DEF_CRL_ATTR);
        this.mCACertAttr = this.mConfig.getString(PROP_CA_CERT_ATTR, DEF_CA_CERT_ATTR);
        this.mByName = this.mConfig.getBoolean(PROP_BY_NAME, true);
    }

    public X509CertImpl locateCACert(LDAPConnection conn, String baseDN) throws EBaseException {
        try {
            String filter = this.mCACertAttr + "=*";
            logger.info("LDAPStore: Searching " + baseDN + " for " + filter);
            LDAPSearchResults results = conn.search(baseDN, 2, filter, null, false);
            if (!results.hasMoreElements()) {
                logger.warn("Unable to find entries with CA cert under " + baseDN);
                return null;
            }
            LDAPEntry entry = results.next();
            logger.info("LDAPStore: Getting " + this.mCACertAttr + " attribute from " + entry.getDN());
            LDAPAttribute caCerts = entry.getAttribute(this.mCACertAttr);
            if (caCerts == null) {
                logger.warn("Unable to find " + this.mCACertAttr + " attribute in " + entry.getDN());
                return null;
            }
            Enumeration vals = caCerts.getByteValues();
            if (!vals.hasMoreElements()) {
                logger.warn("Unable to find values of " + this.mCACertAttr + " attribute in " + entry.getDN());
                return null;
            }
            byte[] caCertData = (byte[])vals.nextElement();
            X509CertImpl caCert = new X509CertImpl(caCertData);
            return caCert;
        }
        catch (Exception e) {
            logger.warn("Unable to locate CA certificate: " + e.getMessage(), (Throwable)e);
            logger.warn(CMS.getLogMessage((String)"OCSP_LOCATE_CA", (Object[])new Object[]{e.toString()}));
            return null;
        }
    }

    public X509CRLImpl locateCRL(LDAPConnection conn, String baseDN) throws EBaseException {
        try {
            String filter = this.mCRLAttr + "=*";
            logger.info("LDAPStore: Searching " + baseDN + " for " + filter);
            LDAPSearchResults results = conn.search(baseDN, 2, filter, null, false);
            if (!results.hasMoreElements()) {
                logger.warn("Unable to find entries with CRL under " + baseDN);
                return null;
            }
            LDAPEntry entry = results.next();
            logger.info("LDAPStore: Getting " + this.mCRLAttr + " attribute from " + entry.getDN());
            LDAPAttribute crls = entry.getAttribute(this.mCRLAttr);
            if (crls == null) {
                logger.warn("Unable to find " + this.mCRLAttr + " attribute in " + entry.getDN());
                return null;
            }
            Enumeration vals = crls.getByteValues();
            if (!vals.hasMoreElements()) {
                logger.warn("Unable to find values of " + this.mCRLAttr + " attribute in " + entry.getDN());
                return null;
            }
            byte[] crlData = (byte[])vals.nextElement();
            X509CRLImpl crl = new X509CRLImpl(crlData);
            return crl;
        }
        catch (Exception e) {
            logger.warn("LDAPStore: locateCRL " + e.getMessage(), (Throwable)e);
            logger.warn(CMS.getLogMessage((String)"OCSP_LOCATE_CRL", (Object[])new Object[]{e.toString()}));
            return null;
        }
    }

    public void updateCRLHash(X509CertImpl caCert, X509CRLImpl crl) throws EBaseException {
        X509CRLImpl oldCRL = this.mCRLs.get(caCert);
        if (oldCRL != null && oldCRL.getThisUpdate().getTime() >= crl.getThisUpdate().getTime()) {
            logger.info("LDAPStore: no update, received CRL is older than current CRL");
            return;
        }
        logger.debug("Added '" + caCert.getSubjectName() + "' into CRL hash");
        this.mCRLs.put(caCert, crl);
    }

    @Override
    public void startup() throws EBaseException {
        int num = this.mConfig.getInteger(PROP_NUM_CONNS, 0);
        for (int i = 0; i < num; ++i) {
            String host = this.mConfig.getString(PROP_HOST + Integer.toString(i), null);
            int port = this.mConfig.getInteger(PROP_PORT + Integer.toString(i), 0);
            LDAPConnection c = new LDAPConnection();
            try {
                c.connect(host, port);
            }
            catch (LDAPException e) {
                throw new EBaseException("LDAP " + e);
            }
            String baseDN = this.mConfig.getString(PROP_BASE_DN + Integer.toString(i), null);
            CRLUpdater updater = new CRLUpdater(this, c, baseDN, this.mConfig.getInteger(PROP_REFRESH_IN_SEC + Integer.toString(i), 86400));
            updater.start();
        }
    }

    @Override
    public void shutdown() {
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    public String getId() {
        return this.mId;
    }

    @Override
    public int getStateCount() {
        return 0;
    }

    @Override
    public long getReqCount(String id) {
        Long c = this.mReqCounts.get(id);
        return c == null ? 0L : c;
    }

    @Override
    public RepositoryRecord createRepositoryRecord() {
        return null;
    }

    @Override
    public void addRepository(String name, String thisUpdate, RepositoryRecord rec) throws EBaseException {
        throw new EBaseException("NOT SUPPORTED");
    }

    @Override
    public boolean waitOnCRLUpdate() {
        return false;
    }

    @Override
    public void updateCRL(X509CRL crl) throws EBaseException {
        throw new EBaseException("NOT SUPPORTED");
    }

    @Override
    public CRLIssuingPointRecord readCRLIssuingPoint(String name) throws EBaseException {
        throw new EBaseException("NOT SUPPORTED");
    }

    @Override
    public Enumeration<CRLIssuingPointRecord> searchAllCRLIssuingPointRecord(int maxSize) throws EBaseException {
        Vector<TempCRLIssuingPointRecord> recs = new Vector<TempCRLIssuingPointRecord>();
        Enumeration<X509CertImpl> keys = this.mCRLs.keys();
        while (keys.hasMoreElements()) {
            X509CertImpl caCert = keys.nextElement();
            X509CRLImpl crl = this.mCRLs.get(caCert);
            recs.addElement(new TempCRLIssuingPointRecord(caCert, crl));
        }
        return recs.elements();
    }

    @Override
    public Enumeration<CRLIssuingPointRecord> searchCRLIssuingPointRecord(String filter, int maxSize) throws EBaseException {
        return null;
    }

    @Override
    public CRLIssuingPointRecord createCRLIssuingPointRecord(String name, BigInteger crlNumber, Long crlSize, Date thisUpdate, Date nextUpdate) {
        return null;
    }

    @Override
    public void addCRLIssuingPoint(String name, CRLIssuingPointRecord rec) throws EBaseException {
        throw new EBaseException("NOT SUPPORTED");
    }

    @Override
    public void deleteCRLIssuingPointRecord(String id) throws EBaseException {
        throw new EBaseException("NOT SUPPORTED");
    }

    @Override
    public boolean isNotFoundGood() {
        try {
            return this.isNotFoundGood1();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean includeNextUpdate() throws EBaseException {
        return this.mConfig.getBoolean(PROP_INCLUDE_NEXT_UPDATE, false);
    }

    public boolean isNotFoundGood1() throws EBaseException {
        return this.mConfig.getBoolean(PROP_NOT_FOUND_GOOD, true);
    }

    public void incReqCount(String id) {
        this.mReqCounts.put(id, this.getReqCount(id) + 1L);
    }

    @Override
    public SingleResponse processRequest(Request req) throws Exception {
        CertID cid = req.getCertID();
        INTEGER serialNo = cid.getSerialNumber();
        logger.info("LDAPStore: Processing request for cert 0x" + serialNo.toString(16));
        X509CertImpl theCert = null;
        X509CRLImpl theCRL = null;
        logger.info("LDAPStore: Checking against " + this.mCRLs.size() + " CA cert(s)");
        Enumeration<X509CertImpl> caCerts = this.mCRLs.keys();
        while (caCerts.hasMoreElements()) {
            byte[] keyhsh;
            X509CertImpl caCert = caCerts.nextElement();
            logger.info("LDAPStore: Checking against " + caCert.getSubjectName());
            MessageDigest md = MessageDigest.getInstance(cid.getDigestName());
            X509Key key = (X509Key)caCert.getPublicKey();
            if (key == null) {
                throw new Exception("Missing issuer key");
            }
            byte[] digest = md.digest(key.getKey());
            if (!Arrays.equals(digest, keyhsh = cid.getIssuerKeyHash().toByteArray())) continue;
            theCert = caCert;
            this.incReqCount(caCert.getSubjectName().toString());
            theCRL = this.mCRLs.get(caCert);
            break;
        }
        if (theCert == null) {
            throw new Exception("Missing issuer certificate");
        }
        if (theCRL == null) {
            throw new Exception("Missing CRL data");
        }
        GeneralizedTime thisUpdate = new GeneralizedTime(theCRL.getThisUpdate());
        GeneralizedTime nextUpdate = null;
        if (this.includeNextUpdate()) {
            nextUpdate = new GeneralizedTime(theCRL.getNextUpdate());
        }
        Object certStatus = null;
        X509CRLEntry entry = theCRL.getRevokedCertificate((BigInteger)cid.getSerialNumber());
        certStatus = entry == null ? (this.isNotFoundGood1() ? new GoodInfo() : new UnknownInfo()) : new RevokedInfo(new GeneralizedTime(entry.getRevocationDate()));
        return new SingleResponse(cid, (CertStatus)certStatus, thisUpdate, nextUpdate);
    }

    @Override
    public NameValuePairs getConfigParameters() {
        try {
            NameValuePairs params = new NameValuePairs();
            params.put((Object)"implName", (Object)this.mConfig.getString("class"));
            int num = this.mConfig.getInteger(PROP_NUM_CONNS, 0);
            params.put((Object)PROP_NUM_CONNS, (Object)Integer.toString(num));
            for (int i = 0; i < num; ++i) {
                params.put((Object)(PROP_HOST + Integer.toString(i)), (Object)this.mConfig.getString(PROP_HOST + Integer.toString(i), ""));
                params.put((Object)(PROP_PORT + Integer.toString(i)), (Object)this.mConfig.getString(PROP_PORT + Integer.toString(i), "389"));
                params.put((Object)(PROP_BASE_DN + Integer.toString(i)), (Object)this.mConfig.getString(PROP_BASE_DN + Integer.toString(i), ""));
                params.put((Object)(PROP_REFRESH_IN_SEC + Integer.toString(i)), (Object)this.mConfig.getString(PROP_REFRESH_IN_SEC + Integer.toString(i), Integer.toString(86400)));
            }
            params.put((Object)PROP_BY_NAME, (Object)this.mConfig.getString(PROP_BY_NAME, "true"));
            params.put((Object)PROP_CA_CERT_ATTR, (Object)this.mConfig.getString(PROP_CA_CERT_ATTR, DEF_CA_CERT_ATTR));
            params.put((Object)PROP_CRL_ATTR, (Object)this.mConfig.getString(PROP_CRL_ATTR, DEF_CRL_ATTR));
            params.put((Object)PROP_NOT_FOUND_GOOD, (Object)this.mConfig.getString(PROP_NOT_FOUND_GOOD, "true"));
            params.put((Object)PROP_INCLUDE_NEXT_UPDATE, (Object)this.mConfig.getString(PROP_INCLUDE_NEXT_UPDATE, "false"));
            return params;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setConfigParameters(NameValuePairs pairs) throws EBaseException {
        for (String key : pairs.keySet()) {
            this.mConfig.put(key, (String)pairs.get((Object)key));
        }
    }
}

