/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.channel;

import com.netscape.certsrv.base.EBaseException;
import java.io.IOException;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.channel.PlatformAndSecChannelProtoInfo;
import org.dogtagpki.server.tps.channel.SecureChannelProtocol;
import org.dogtagpki.server.tps.processor.TPSProcessor;
import org.dogtagpki.tps.apdu.APDU;
import org.dogtagpki.tps.apdu.APDUResponse;
import org.dogtagpki.tps.apdu.ClearKeySlotsAPDU;
import org.dogtagpki.tps.apdu.CreateObjectAPDU;
import org.dogtagpki.tps.apdu.CreatePinAPDU;
import org.dogtagpki.tps.apdu.DeleteFileAPDU;
import org.dogtagpki.tps.apdu.DeleteFileGP211APDU;
import org.dogtagpki.tps.apdu.ExternalAuthenticateAPDU;
import org.dogtagpki.tps.apdu.ExternalAuthenticateAPDUGP211;
import org.dogtagpki.tps.apdu.GenerateKeyAPDU;
import org.dogtagpki.tps.apdu.GenerateKeyECCAPDU;
import org.dogtagpki.tps.apdu.ImportKeyEncAPDU;
import org.dogtagpki.tps.apdu.InstallAppletAPDU;
import org.dogtagpki.tps.apdu.InstallAppletAPDUGP211;
import org.dogtagpki.tps.apdu.InstallLoadAPDU;
import org.dogtagpki.tps.apdu.InstallLoadGP211APDU;
import org.dogtagpki.tps.apdu.LifecycleAPDU;
import org.dogtagpki.tps.apdu.LoadFileAPDU;
import org.dogtagpki.tps.apdu.LoadFileAPDUGP211;
import org.dogtagpki.tps.apdu.PutKeyAPDU;
import org.dogtagpki.tps.apdu.ReadObjectAPDU;
import org.dogtagpki.tps.apdu.SetIssuerInfoAPDU;
import org.dogtagpki.tps.apdu.SetPinAPDU;
import org.dogtagpki.tps.apdu.WriteObjectAPDU;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.TPSException;
import org.dogtagpki.tps.main.Util;
import org.dogtagpki.tps.msg.EndOpMsg;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannel {
    public static Logger logger = LoggerFactory.getLogger(SecureChannel.class);
    public TPSProcessor processor;
    private PK11SymKey sessionKey;
    private PK11SymKey encSessionKey;
    private PK11SymKey cmacSessionKey;
    private PK11SymKey rmacSessionKey;
    private PK11SymKey dekSessionKey;
    private PK11SymKey macSessionKey;
    private TPSBuffer dekSessionKeyWrapped;
    private TPSBuffer drmDesKey;
    private TPSBuffer kekDesKey;
    private TPSBuffer keyCheck;
    private TPSBuffer keyDiversificationData;
    private TPSBuffer cardChallenge;
    private TPSBuffer cardCryptogram;
    private TPSBuffer hostChallenge;
    private TPSBuffer hostCryptogram;
    private TPSBuffer icv;
    private TPSBuffer keyInfoData;
    private TPSBuffer sequenceCounter;
    private ExternalAuthenticateAPDU.SecurityLevel secLevel;
    private PlatformAndSecChannelProtoInfo platProtInfo;
    private ExternalAuthenticateAPDUGP211.SecurityLevel secLevelGP211;
    public static final byte GP211_SCP02_IMPL_15 = 21;
    public static final String GP201 = "2.0.1";
    public static final String GP211 = "2.1.1";
    public static final byte SECURE_PROTO_01 = 1;
    public static final byte SECURE_PROTO_02 = 2;
    public static final byte SECURE_PROTO_03 = 3;
    public static final byte[] GP211_GET_DATA_CARD_DATA = new byte[]{0, 102};
    public static final byte[] GP211_GET_DATA_KEY_INFO = new byte[]{0, -32};
    public static final byte[] GP201_GET_DATA_CPLC_WHOLE_CPLC = new byte[]{-97, 127};
    public static final byte[] GP211_GET_DATA_CPLC_WHOLE_CPLC = new byte[]{-97, 127};
    public static final byte[] C_MACDerivationConstant = new byte[]{1, 1};
    public static final byte[] ENCDerivationConstant = new byte[]{1, -126};
    public static final byte[] DEKDerivationConstant = new byte[]{1, -127};
    public static final byte[] R_MACDerivationConstant = new byte[]{1, 2};
    private TPSBuffer encryptionCounter;

    public SecureChannel(TPSProcessor processor, PK11SymKey encSessionKey, PK11SymKey macSessionKey, PK11SymKey dekSessionKey, TPSBuffer drmDesKey, TPSBuffer kekDesKey, TPSBuffer keyCheck, TPSBuffer keyDiversificationData, TPSBuffer cardChallenge, TPSBuffer cardCryptogram, TPSBuffer hostChallenge, TPSBuffer hostCryptogram, TPSBuffer keyInfoData, PlatformAndSecChannelProtoInfo platformInfo) throws TPSException {
        if (processor == null || encSessionKey == null || keyDiversificationData == null || cardChallenge == null || cardCryptogram == null || hostChallenge == null || hostCryptogram == null || keyInfoData == null) {
            throw new TPSException("SecureChannel.SecureChannel: Invalid data in constructor!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("SecureChannel.SecureChannel: For SCP03. :  ");
        this.platProtInfo = platformInfo;
        this.processor = processor;
        this.encSessionKey = encSessionKey;
        this.macSessionKey = macSessionKey;
        this.dekSessionKey = dekSessionKey;
        this.drmDesKey = drmDesKey;
        this.setKekDesKey(kekDesKey);
        this.keyCheck = keyCheck;
        this.keyDiversificationData = keyDiversificationData;
        this.cardChallenge = cardChallenge;
        this.cardCryptogram = cardCryptogram;
        this.hostChallenge = hostChallenge;
        this.hostCryptogram = hostCryptogram;
        this.icv = new TPSBuffer(16);
        this.keyInfoData = keyInfoData;
        this.secLevel = ExternalAuthenticateAPDU.SecurityLevel.SECURE_MSG_NONE;
        this.secLevelGP211 = ExternalAuthenticateAPDUGP211.SecurityLevel.CDEC_CMAC;
        this.encryptionCounter = new TPSBuffer(16);
    }

    public SecureChannel(TPSProcessor processor, PK11SymKey sessionKey, PK11SymKey encSessionKey, TPSBuffer drmDesKey, TPSBuffer kekDesKey, TPSBuffer keyCheck, TPSBuffer keyDiversificationData, TPSBuffer cardChallenge, TPSBuffer cardCryptogram, TPSBuffer hostChallenge, TPSBuffer hostCryptogram, TPSBuffer keyInfoData, PlatformAndSecChannelProtoInfo platformInfo) throws TPSException {
        if (processor == null || sessionKey == null | encSessionKey == null || keyDiversificationData == null || cardChallenge == null || cardCryptogram == null || hostChallenge == null || hostCryptogram == null || keyInfoData == null) {
            throw new TPSException("SecureChannel.SecureChannel: Invalid data in constructor!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("SecureChannel.SecureChannel: For SCP01. ");
        this.platProtInfo = platformInfo;
        this.processor = processor;
        this.sessionKey = sessionKey;
        this.encSessionKey = encSessionKey;
        this.drmDesKey = drmDesKey;
        this.setKekDesKey(kekDesKey);
        this.keyCheck = keyCheck;
        this.keyDiversificationData = keyDiversificationData;
        this.cardChallenge = cardChallenge;
        this.cardCryptogram = cardCryptogram;
        this.hostChallenge = hostChallenge;
        this.hostCryptogram = hostCryptogram;
        this.icv = new TPSBuffer(8);
        this.keyInfoData = keyInfoData;
        this.secLevel = ExternalAuthenticateAPDU.SecurityLevel.SECURE_MSG_MAC_ENC;
    }

    public SecureChannel(TPSProcessor processor, PK11SymKey encSessionKey, PK11SymKey cmacSessionKey, PK11SymKey rmacSessionKey, PK11SymKey dekSessionKey, TPSBuffer drmDesKey, TPSBuffer kekDesKey, TPSBuffer keyCheck, TPSBuffer keyDiversificationData, TPSBuffer keyInfoData, TPSBuffer sequenceCounter, TPSBuffer hostChallenge, TPSBuffer cardChallenge, TPSBuffer cardCryptogram, PlatformAndSecChannelProtoInfo platformInfo) throws TPSException {
        if (processor == null || encSessionKey == null | cmacSessionKey == null || rmacSessionKey == null || dekSessionKey == null || keyDiversificationData == null || hostChallenge == null || cardChallenge == null || cardCryptogram == null || keyInfoData == null || platformInfo == null) {
            throw new TPSException("SecureChannel.SecureChannel: Invalid data in constructor!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        this.sequenceCounter = sequenceCounter;
        this.platProtInfo = platformInfo;
        this.processor = processor;
        this.encSessionKey = encSessionKey;
        this.cmacSessionKey = cmacSessionKey;
        this.setRmacSessionKey(rmacSessionKey);
        this.keyDiversificationData = keyDiversificationData;
        this.icv = new TPSBuffer(8);
        this.keyInfoData = keyInfoData;
        this.cardChallenge = cardChallenge;
        this.cardCryptogram = cardCryptogram;
        this.hostChallenge = hostChallenge;
        this.drmDesKey = drmDesKey;
        this.kekDesKey = kekDesKey;
        this.secLevelGP211 = ExternalAuthenticateAPDUGP211.SecurityLevel.CDEC_CMAC;
        this.keyCheck = keyCheck;
        byte finalKeyIndex = this.gp211CalculateLatestKeySet(platformInfo.getKeysetInfoData());
        logger.debug("SecureChannel.SecureChannel: For SCP02: calculated latest key index: " + finalKeyIndex);
    }

    private byte gp211CalculateLatestKeySet(TPSBuffer keysetInfoData) throws TPSException {
        if (keysetInfoData == null) {
            throw new TPSException("SecureChannel.gp211calculateKeyInfoData invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("SecureChannel.gp211calculateKeyInfoData: input keysetInfoData: " + keysetInfoData.toHexString());
        int pos = 0;
        byte next = keysetInfoData.at(pos++);
        if (next != -32) {
            throw new TPSException("SecureChannel.gp211calculateKeyInfoData: malformed input data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        next = keysetInfoData.at(pos++);
        int numKeys = next / 6;
        int remainder = next % 6;
        if (remainder != 0) {
            throw new TPSException("SecureChannel.gp211calculateKeyInfoData: malformed input data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("SecureChannel.gp211calculateKeyInfoData: number of keys: " + numKeys);
        int numKeySets = numKeys / 3;
        logger.debug("SecureChannel.gp211calculateKeyInfoData: number of keysets: " + numKeySets);
        int offset = (numKeySets - 1) * 6 * 3 + 3;
        logger.debug("SecureChannel.gp211calculateKeyInfoData: offset " + offset);
        if ((offset += pos) > keysetInfoData.size()) {
            throw new TPSException("SecureChannel.gp211calculateKeyInfoData: malformed input data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        byte finalKeyIndex = keysetInfoData.at(offset);
        return finalKeyIndex;
    }

    public void appendPKCS11Attribute(TPSBuffer buffer, long type, TPSBuffer attribute) {
        buffer.addLong4Bytes(type);
        buffer.addInt2Bytes(attribute.size());
        buffer.add(attribute);
    }

    public void appendKeyCapabilities(TPSBuffer buffer, String keyTypePrefix, String keyType) throws TPSException {
        if (buffer == null || keyTypePrefix == null || keyType == null) {
            throw new TPSException("SecureChannel.appdndKeyCabalities: Invalid input datat.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String keyCapabilities = "keyCapabilities";
        try {
            boolean value = false;
            String configName = keyTypePrefix + "." + keyType + ".keyCapabilities.encrypt";
            value = configStore.getBoolean(configName);
            TPSBuffer attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 260L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.sign";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 264L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.signRecover";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 265L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.decrypt";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 261L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.derive";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 268L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.unwrap";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 263L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.wrap";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 262L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.verifyRecover";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 267L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.verify";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 266L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.sensitive";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 259L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.private";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 2L, attr);
            configName = keyTypePrefix + "." + keyType + ".keyCapabilities.token";
            value = configStore.getBoolean(configName);
            attr = new TPSBuffer(Util.bool2Byte((boolean)value));
            this.appendPKCS11Attribute(buffer, 1L, attr);
            logger.debug("SecureChannel.appendKeyCapabilities: returning");
        }
        catch (EBaseException e) {
            throw new TPSException("SecureChannel.appentKeyCapabilities. Can't obtain config value!", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
    }

    public void externalAuthenticate() throws TPSException, IOException {
        APDUResponse response;
        ExternalAuthenticateAPDUGP211 externalAuth;
        String method = "SecureChannel.externalAuthenticate.";
        logger.debug(method + ": entering. &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        TPSBuffer calculatedCardCryptogram = null;
        if (this.platProtInfo.isSCP03()) {
            logger.debug("SecureChannel.externalAuthenticate: Attempting an External Authenticate for SCP03!");
            TPSBuffer context = new TPSBuffer(this.hostChallenge);
            context.add(this.cardChallenge);
            try {
                calculatedCardCryptogram = SecureChannelProtocol.compute_AES_CMAC_Cryptogram((SymmetricKey)this.macSessionKey, context, (byte)0);
            }
            catch (EBaseException e) {
                throw new TPSException(method + "Failed to calculate card cryptogram!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            externalAuth = new ExternalAuthenticateAPDUGP211(this.hostCryptogram, this.secLevelGP211);
            this.computeAPDUMacSCP03((APDU)externalAuth);
            response = this.processor.handleAPDURequest((APDU)externalAuth);
            if (!response.checkResult()) {
                throw new TPSException("SecureChannel.eternalAuthenticate SCP03. Failed to external authenticate to token.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
        }
        if (this.platProtInfo.isSCP02()) {
            TPSBuffer calculatedHostCryptogram;
            logger.debug("SecureChannel.externalAuthenticate: Attempting an External Authenticate for SCP02!");
            calculatedCardCryptogram = this.computeCardCryptogramSCP02(this.encSessionKey);
            if (!this.cardCryptogram.equals(calculatedCardCryptogram)) {
                logger.error("SecureChannel.eternalAuthenticate. Failed to match calculated to returned card cryptogram!. cardCryptogram: " + this.cardCryptogram.toHexString() + " calculatedCardCrytpogram: " + calculatedCardCryptogram.toHexString());
                throw new TPSException("SecureChannel.eternalAuthenticate. Failed to match calculated to returned card cryptogram!.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            this.hostCryptogram = calculatedHostCryptogram = this.computeHostCryptogramSCP02(this.encSessionKey);
            externalAuth = new ExternalAuthenticateAPDUGP211(this.hostCryptogram, this.secLevelGP211);
            logger.debug("SecureChannel.externalAuthenticate: about to call computeAPDUMacSCP02. &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
            this.computeAPDUMacSCP02((APDU)externalAuth);
            response = this.processor.handleAPDURequest((APDU)externalAuth);
            if (!response.checkResult()) {
                throw new TPSException("SecureChannel.eternalAuthenticate SCP02. Failed to external authenticate to token.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            logger.debug("SecureChannel.externalAuthenticate: SCP02 external authenticate returns Success!!!");
        } else if (this.platProtInfo.isSCP01()) {
            ExternalAuthenticateAPDU externalAuth2 = new ExternalAuthenticateAPDU(this.hostCryptogram, ExternalAuthenticateAPDU.SecurityLevel.SECURE_MSG_MAC_ENC);
            logger.debug("SecureChannel.externalAuthenticate: about to call computeAPDUMac. &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
            this.computeAPDUMac((APDU)externalAuth2);
            APDUResponse response2 = this.processor.handleAPDURequest((APDU)externalAuth2);
            if (!response2.checkResult()) {
                throw new TPSException("SecureChannel.externalAuthenticate SCP01. Failed to external authenticate to token.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
        }
        logger.debug("SecureChannel.externalAuthenticate: Successfully completed, exiting ...");
    }

    private void computeAPDU(APDU apdu) throws TPSException {
        logger.debug("SecureChannel.computeAPDU: entering..");
        if (apdu == null) {
            throw new TPSException("SecureChannel.computeAPDU: bad input apdu!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        if (this.isSCP02()) {
            this.computeAPDU_SCP02(apdu);
            return;
        }
        if (this.isSCP03()) {
            this.computeAPDU_SCP03(apdu);
            return;
        }
        this.computeAPDUMac(apdu);
        if (this.secLevel == ExternalAuthenticateAPDU.SecurityLevel.SECURE_MSG_MAC_ENC) {
            try {
                apdu.secureMessage(this.encSessionKey, (byte)1);
            }
            catch (EBaseException e) {
                throw new TPSException("SecureChannel.computeAPDU: Can't encrypt outgoing data! " + e, EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            logger.debug("SecureChannel.computeAPDU: Successfully encrypted apdu data.");
        }
    }

    private void computeAPDU_SCP03(APDU apdu) throws TPSException {
        String method = "SecureChannel.computeAPDU_SCP03:";
        logger.debug(method + "entering..");
        if (apdu == null) {
            throw new TPSException(method + " bad input apdu!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        if (this.secLevelGP211 == ExternalAuthenticateAPDUGP211.SecurityLevel.CDEC_CMAC) {
            try {
                this.incrementBuffer(this.encryptionCounter);
                TPSBuffer currentEncryptionCounter = new TPSBuffer(this.encryptionCounter);
                apdu.secureMessageSCP03(this.encSessionKey, currentEncryptionCounter);
            }
            catch (EBaseException e) {
                throw new TPSException("SecureChannel.computeAPDU_SCP03: Can't encrypt outgoing data! " + e, EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            logger.debug("SecureChannel.computeAPDU_SCP03: Successfully encrypted apdu data.");
        }
        this.computeAPDUMacSCP03(apdu);
    }

    public void incrementBuffer(TPSBuffer buffer) {
        if (buffer == null) {
            return;
        }
        int len = buffer.size();
        if (len < 1) {
            return;
        }
        short offset = 0;
        for (short i = (short)(offset + len - 1); i >= offset; i = (short)(i - 1)) {
            byte cur = buffer.at((int)i);
            if (cur != -1) {
                cur = (byte)(cur + 1);
                buffer.setAt((int)i, cur);
                break;
            }
            buffer.setAt((int)i, (byte)0);
        }
        System.out.println("enc buffer: " + buffer.toHexString());
    }

    private void computeAPDU_SCP02(APDU apdu) throws TPSException {
        logger.debug("SecureChannel.computeAPDU_SCP02: entering..");
        if (apdu == null) {
            throw new TPSException("SecureChannel.computeAPDU_SCP02: bad input apdu!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        this.computeAPDUMacSCP02(apdu);
        if (this.secLevelGP211 == ExternalAuthenticateAPDUGP211.SecurityLevel.CDEC_CMAC) {
            try {
                apdu.secureMessageSCP02(this.encSessionKey);
            }
            catch (EBaseException e) {
                throw new TPSException("SecureChannel.computeAPDU_SCP02: Can't encrypt outgoing data! " + e, EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            logger.debug("SecureChannel.computeAPDU_SCP02: Successfully encrypted apdu data.");
        }
    }

    private void computeAPDUMacSCP03(APDU apdu) throws TPSException {
        TPSBuffer newMac = null;
        TPSBuffer data = null;
        if (apdu == null) {
            throw new TPSException("SecureChannel.computeAPDUMacSCP03: bad input apdu!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        data = apdu.getDataToMAC();
        try {
            logger.debug("SecureChannel.computeAPDUMacSCP03: No ecnrypton of ICV.");
            TPSBuffer dataToMac = new TPSBuffer(this.icv);
            dataToMac.add(data);
            newMac = SecureChannelProtocol.computeAES_CMAC((SymmetricKey)this.macSessionKey, dataToMac);
        }
        catch (EBaseException e) {
            logger.error("SecureChannel.computeAPDUMacSCP03: Can't compute mac: " + e.getMessage(), (Throwable)e);
            throw new TPSException("SecureChannel.compuatAPDUMacSCP03: Can't compute mac.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("SecureChannel.computeAPDUMacSCP03: computed MAC: ");
        apdu.setMAC(newMac.substr(0, 8));
        this.icv.set(newMac);
    }

    private void computeAPDUMacSCP02(APDU apdu) throws TPSException {
        TPSBuffer newMac = null;
        TPSBuffer data = null;
        TPSBuffer singleDes = null;
        if (apdu == null) {
            throw new TPSException("SecureChannel.computeAPDUMacSCP02: bad input apdu!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        data = apdu.getDataToMAC();
        logger.debug("SecureChannel.computeAPDUMacSCP02: data To MAC: " + data.toHexString() + " incoming icv: " + this.icv.toHexString());
        try {
            if (apdu.getType() != APDU.Type.APDU_EXTERNAL_AUTHENTICATE && (this.secLevelGP211 == ExternalAuthenticateAPDUGP211.SecurityLevel.CMAC || this.secLevelGP211 == ExternalAuthenticateAPDUGP211.SecurityLevel.CDEC_CMAC)) {
                logger.debug("SecureChannel.computeAPDUMacSCP02: data To MAC, calcuating single des encyption before mac.");
                singleDes = Util.computeEncEcbDes((PK11SymKey)this.cmacSessionKey, (TPSBuffer)this.icv);
                logger.debug("SecureChannel.computeAPDUMacSCP02: data To MAC, calcuating single des encyption before mac. result: " + singleDes.toHexString());
                newMac = Util.computeMACdes3des((PK11SymKey)this.cmacSessionKey, (TPSBuffer)data, (TPSBuffer)singleDes);
            } else {
                logger.debug("SecureChannel.computeAPDUMacSCP02: No ecnrypton of ICV.");
                newMac = Util.computeMACdes3des((PK11SymKey)this.cmacSessionKey, (TPSBuffer)data, (TPSBuffer)this.icv);
            }
        }
        catch (EBaseException e) {
            logger.error("SecureChannel.computeAPDUMacSCP02: Can't compute mac: " + e.getMessage(), (Throwable)e);
            throw new TPSException("SecureChannel.compuatAPDUMacSCP02: Can't compute mac.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("SecureChannel.computeAPDUMacSCP02: computed MAC: " + newMac.toHexString());
        apdu.setMAC(newMac);
        this.icv.set(newMac);
    }

    private void computeAPDUMac(APDU apdu) throws TPSException {
        TPSBuffer newMac = null;
        TPSBuffer data = null;
        if (apdu == null) {
            throw new TPSException("SecureChannel.computeAPDUMac: bad input apdu!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        data = apdu.getDataToMAC();
        logger.debug("SecureChannel.computeAPDUMac: got data To MAC");
        try {
            newMac = Util.computeMAC((PK11SymKey)this.sessionKey, (TPSBuffer)data, (TPSBuffer)this.icv);
        }
        catch (EBaseException e) {
            logger.error("SecureChannel.compuatAPDUMac: Can't compute mac: " + e.getMessage(), (Throwable)e);
            throw new TPSException("SecureChannel.compuatAPDUMac: Can't compute mac.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("SecureChannel.computeAPDUMac: MAC computed");
        apdu.setMAC(newMac);
        this.icv.set(newMac);
    }

    public void deleteFileX(TPSBuffer aid) throws TPSException, IOException {
        logger.debug("SecureChannel.deleteFileX: entering...");
        if (aid == null) {
            throw new TPSException("SecureChannel.deleteFileX: no input aid!", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        if (this.isGP211()) {
            logger.debug("SecureChannel.deleteFileX: attempting gp211...");
            DeleteFileGP211APDU deleteFile = new DeleteFileGP211APDU(aid);
            this.computeAPDU((APDU)deleteFile);
            this.processor.handleAPDURequest((APDU)deleteFile);
        } else {
            logger.debug("SecureChannel.deleteFileX: attempting gp201...");
            DeleteFileAPDU deleteFile = new DeleteFileAPDU(aid);
            this.computeAPDU((APDU)deleteFile);
            this.processor.handleAPDURequest((APDU)deleteFile);
        }
    }

    public void installLoad(TPSBuffer packageAID, TPSBuffer sdAID, int fileLength) throws TPSException, IOException {
        logger.debug("SecureChannel.installLoad: entering ... packageAID: " + packageAID.toHexString() + " sdAID: " + sdAID.toHexString() + " fileLength: " + fileLength);
        if (packageAID == null || sdAID == null || fileLength <= 0) {
            throw new TPSException("SecureChannel.insallLoad bad input parameters!", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        TPSBuffer emptySDAID = new TPSBuffer();
        if (this.isGP211()) {
            TPSBuffer cardMgrGP211AIDBuff = new TPSBuffer("A000000003000000");
            this.installLoadGP211(packageAID, cardMgrGP211AIDBuff, fileLength);
            return;
        }
        InstallLoadAPDU install = new InstallLoadAPDU(packageAID, emptySDAID, fileLength);
        logger.debug("SecureChannel.installLoad: Pre computed apdu: " + install.getEncoding().toHexString());
        this.computeAPDU((APDU)install);
        APDUResponse response = this.processor.handleAPDURequest((APDU)install);
        if (!response.checkResult()) {
            throw new TPSException("SecureChannel.installLoad. Failed to perform installLoad operation.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
    }

    public void installLoadGP211(TPSBuffer packageAID, TPSBuffer sdAID, int fileLength) throws TPSException, IOException {
        logger.debug("SecureChannel.installLoadGP211: entering ...");
        if (packageAID == null || sdAID == null || fileLength <= 0) {
            throw new TPSException("SecureChannel.insallLoadGP211 bad input parameters!", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        InstallLoadGP211APDU install = new InstallLoadGP211APDU(packageAID, sdAID, fileLength);
        this.computeAPDU((APDU)install);
        APDUResponse response = this.processor.handleAPDURequest((APDU)install);
        if (!response.checkResult()) {
            throw new TPSException("SecureChannel.installLoadGP211. Failed to perform installLoadGP211 operation.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
    }

    public void loadFile(TPSBuffer programFile, int blockSize, int startProgress, int endProgress) throws TPSException, IOException {
        int totalLen;
        logger.debug("SecureChannel.loadFile entering... blockSize: " + blockSize);
        if (programFile == null || blockSize <= 0) {
            throw new TPSException("ScureChannel.loadFile. Bad input data.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        TPSBuffer length = null;
        TPSBuffer tag = new TPSBuffer(1, -60);
        int progSize = programFile.size();
        if (progSize < 128) {
            length = new TPSBuffer(1, (byte)progSize);
        } else if (progSize <= 255) {
            length = new TPSBuffer(1, -127);
            length.add((byte)progSize);
        } else {
            length = new TPSBuffer(1, -126);
            length.add((byte)(progSize >> 8 & 0xFF));
            length.add((byte)(progSize & 0xFF));
        }
        TPSBuffer tbsProgramFile = new TPSBuffer(tag);
        tbsProgramFile.add(length);
        tbsProgramFile.add(programFile);
        int sizeToSend = totalLen = tbsProgramFile.size();
        int finalBlockSize = 0;
        float progressBlockSize = 0.0f;
        finalBlockSize = this.secLevel == ExternalAuthenticateAPDU.SecurityLevel.SECURE_MSG_MAC_ENC ? blockSize - 16 : blockSize - 8;
        int numLoops = sizeToSend / blockSize;
        if (numLoops == 0) {
            throw new TPSException("SecureChannel.loadFile. Bad input data.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        progressBlockSize = (float)(endProgress - startProgress) / (float)numLoops;
        int count = 0;
        byte refControl = 0;
        do {
            if (sizeToSend < finalBlockSize) {
                finalBlockSize = sizeToSend;
                refControl = -128;
            }
            logger.debug("SecureChannel.loadFile: taking data substring from: " + (totalLen - sizeToSend) + " size: " + finalBlockSize + " to: " + (totalLen - sizeToSend + finalBlockSize));
            TPSBuffer piece = tbsProgramFile.substr(totalLen - sizeToSend, finalBlockSize);
            logger.debug("SecureChannel.loadFile: attempting to send piece: " + sizeToSend);
            this.loadFileSegment(refControl, count, piece);
            if (this.processor.requiresStatusUpdate()) {
                this.processor.statusUpdate(startProgress + (int)((float)count * progressBlockSize), "PROGRESS_APPLET_BLOCK");
            }
            ++count;
        } while ((sizeToSend -= finalBlockSize) > 0);
    }

    private void loadFileSegment(byte refControl, int count, TPSBuffer piece) throws TPSException, IOException {
        logger.debug("SecureChannel.loadFileSegment: begins");
        if (piece == null || count < 0) {
            throw new TPSException("SecureChannel.loadFileSegment: invalid input data.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        APDUResponse response = null;
        if (this.isGP211()) {
            LoadFileAPDUGP211 loadFile = new LoadFileAPDUGP211(refControl, (byte)count, piece);
            this.computeAPDU((APDU)loadFile);
            response = this.processor.handleAPDURequest((APDU)loadFile);
        } else {
            logger.debug("SecureChannel.loadFileSegment: gp211.");
            LoadFileAPDU loadFile = new LoadFileAPDU(refControl, (byte)count, piece);
            this.computeAPDU((APDU)loadFile);
            response = this.processor.handleAPDURequest((APDU)loadFile);
        }
        if (!response.checkResult()) {
            throw new TPSException("SecureChannel.loadFileSegment. Failed to perform loadFileSegmentInstallLoad operation.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        logger.debug("SecureChannel.loadFileSegment: ends");
    }

    public void installApplet(TPSBuffer netkeyPAIDBuff, TPSBuffer netkeyAIDBuff, byte appPrivileges, int channelInstanceSize, int channelAppletMemSize) throws TPSException, IOException {
        logger.debug("SecureChannel.installApplet: entering...");
        if (netkeyPAIDBuff == null || netkeyAIDBuff == null || channelInstanceSize < 0 || channelAppletMemSize < 0) {
            throw new TPSException("SecureChannel.installApplet. Invalid input parameters!", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        APDUResponse response = null;
        if (this.isGP211()) {
            InstallAppletAPDUGP211 install = new InstallAppletAPDUGP211(netkeyPAIDBuff, netkeyAIDBuff, appPrivileges, channelInstanceSize, channelAppletMemSize);
            this.computeAPDU((APDU)install);
            response = this.processor.handleAPDURequest((APDU)install);
        } else {
            InstallAppletAPDU install = new InstallAppletAPDU(netkeyPAIDBuff, netkeyAIDBuff, appPrivileges, channelInstanceSize, channelAppletMemSize);
            this.computeAPDU((APDU)install);
            response = this.processor.handleAPDURequest((APDU)install);
        }
        if (!response.checkResult()) {
            throw new TPSException("SecureChannel.installApplett. Failed installApplet operation.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
    }

    public void setIssuerInfo(TPSBuffer issuerInfoBuff) throws TPSException, IOException {
        logger.debug("SecureChannel.setIssuerInfo entering...");
        int finalIssuerLength = 224;
        int approxMinUrlSize = 5;
        if (issuerInfoBuff == null || issuerInfoBuff.size() < 5) {
            throw new TPSException("SecureChannel.setIssuerInfo: Invalid input data.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        int issuerLen = issuerInfoBuff.size();
        int paddingLen = 224 - issuerLen;
        TPSBuffer paddingBuff = new TPSBuffer(paddingLen, 0);
        TPSBuffer finalIssuerBuff = new TPSBuffer(issuerInfoBuff);
        finalIssuerBuff.add(paddingBuff);
        logger.debug("finalIssuerBuff len: " + finalIssuerBuff.size() + " issuerInfo: " + finalIssuerBuff.toString());
        SetIssuerInfoAPDU setIssuer = new SetIssuerInfoAPDU(0, 0, finalIssuerBuff);
        this.computeAPDU((APDU)setIssuer);
        APDUResponse response = this.processor.handleAPDURequest((APDU)setIssuer);
        if (!response.checkResult()) {
            throw new TPSException("SecureChannel.setIssuerInfo. Failed to set issuer info!", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        logger.debug("SecureChannel.setIssuerInfo: leaving...");
    }

    public TPSBuffer getKeyDiversificationData() {
        return this.keyDiversificationData;
    }

    public TPSBuffer getCardChallenge() {
        return this.cardChallenge;
    }

    public TPSBuffer getHostChallenge() {
        return this.hostChallenge;
    }

    public TPSBuffer getHostCryptogram() {
        return this.hostCryptogram;
    }

    public TPSBuffer getCardCryptogram() {
        return this.cardCryptogram;
    }

    public TPSBuffer getKeyInfoData() {
        return this.keyInfoData;
    }

    public void clearAppletKeySlotData(TPSBuffer data) {
        APDUResponse response;
        String method = "SecureChannel.clearAppletKeySlotData: ";
        logger.debug(method + " entering ...");
        if (data == null) {
            logger.warn(method + " Invalid input data returning...");
            return;
        }
        try {
            ClearKeySlotsAPDU clearKey = new ClearKeySlotsAPDU(data.toBytesArray());
            this.computeAPDU((APDU)clearKey);
            response = this.processor.handleAPDURequest((APDU)clearKey);
        }
        catch (IOException | TPSException e) {
            logger.warn(method + " bad apdu return: " + e.getMessage(), e);
            return;
        }
        if (!response.checkResult()) {
            logger.debug(method + " bad apdu return!");
        }
        logger.debug(method + " Successful applet key data cleanup operation completed.");
    }

    public void writeObject(TPSBuffer objectID, TPSBuffer objectData) throws TPSException, IOException {
        logger.debug("SecureChannel.writeObject: entering ...");
        if (objectID == null || objectData == null) {
            throw new TPSException("SecureChannel.writeObject: invalid input data.", EndOpMsg.TPSStatus.STATUS_ERROR_CANNOT_PERFORM_OPERATION);
        }
        int MAX_WRITE_SIZE = 208;
        int offset = 0;
        int toSend = objectData.size();
        int blockSize = 0;
        boolean moreToGo = true;
        do {
            blockSize = toSend > 208 ? 208 : toSend;
            TPSBuffer blockToSend = objectData.substr(offset, blockSize);
            WriteObjectAPDU write = new WriteObjectAPDU(objectID.toBytesArray(), offset, blockToSend);
            this.computeAPDU((APDU)write);
            APDUResponse response = this.processor.handleAPDURequest((APDU)write);
            if (!response.checkResult()) {
                logger.error("SecureChannel.writeObject: bad apdu return!");
                throw new TPSException("SecureChannel.writeObject. Failed in middle of writeObject.", EndOpMsg.TPSStatus.STATUS_ERROR_CANNOT_PERFORM_OPERATION);
            }
            offset += blockSize;
            if ((toSend -= blockSize) > 0) continue;
            moreToGo = false;
        } while (moreToGo);
    }

    public TPSBuffer readObject(TPSBuffer objectID, int offset, int len) throws TPSException, IOException {
        logger.debug("SecureChannel.readObject: entering ...");
        if (objectID == null || len == 0) {
            throw new TPSException("SecureChannel.readObject: invalid input data.", EndOpMsg.TPSStatus.STATUS_ERROR_CANNOT_PERFORM_OPERATION);
        }
        int MAX_READ_BUFFER_SIZE = 208;
        ReadObjectAPDU read = null;
        TPSBuffer result = new TPSBuffer();
        int cur_read = 0;
        int cur_offset = 0;
        int sum = 0;
        if (len > 208) {
            cur_offset = offset;
            cur_read = 208;
        } else {
            cur_offset = offset;
            cur_read = len;
        }
        while (sum < len) {
            read = new ReadObjectAPDU(objectID.toBytesArray(), cur_offset, cur_read);
            this.computeAPDU((APDU)read);
            APDUResponse response = this.processor.handleAPDURequest((APDU)read);
            if (!response.checkResult()) {
                logger.error("SecureChannel.readObject: bad apdu return!");
                throw new TPSException("SecureChannel.installApplett. Failed in middle of readObject.", EndOpMsg.TPSStatus.STATUS_ERROR_CANNOT_PERFORM_OPERATION);
            }
            TPSBuffer resp = response.getResultDataNoCode();
            result.add(resp);
            cur_offset += resp.size();
            if (len - (sum += resp.size()) < 208) {
                cur_read = len - sum;
                continue;
            }
            cur_read = 208;
        }
        return result;
    }

    public void createObject(TPSBuffer objectID, TPSBuffer permissions, TPSBuffer object) throws TPSException, IOException {
        logger.debug("SecureChannel.createObject: with full object. entering...");
        if (objectID == null || permissions == null || object == null) {
            throw new TPSException("SecureChannel.createObject, with full object. Bad input data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        this.createObject(objectID, permissions, object.size());
        this.writeObject(objectID, object);
    }

    public void createCertificate(TPSBuffer objectID, TPSBuffer cert) throws TPSException, IOException {
        logger.debug("SecureChannel.createCertificate: entering...");
        if (objectID == null || cert == null) {
            throw new TPSException("SecureChannel.createCertificate. Bad input data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        byte[] perms = new byte[]{-1, -1, 64, 0, 64, 0};
        TPSBuffer permissions = new TPSBuffer(perms);
        this.createObject(objectID, permissions, cert);
    }

    public void createPKCS11CertAttrs(TokenKeyType keyType, String id, String label, TPSBuffer keyid) throws TPSException, IOException {
        TPSBuffer buffer = this.createPKCS11CertAttrsBuffer(keyType, id, label, keyid);
        byte[] perms = new byte[]{-1, -1, 64, 0, 64, 0};
        TPSBuffer permissions = new TPSBuffer(perms);
        this.createObject(new TPSBuffer(id), permissions, buffer);
    }

    public TPSBuffer createPKCS11PriKeyAttrsBuffer(String id, String label, TPSBuffer keyid, TPSBuffer modulus, String keyTypePrefix) throws TPSException {
        TPSBuffer result = new TPSBuffer();
        if (id == null || label == null || keyid == null || modulus == null || keyTypePrefix == null) {
            throw new TPSException("SecureChannel.craetePKCS11PriKeyAttrsBuffer: invalid input data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        byte[] keytype = new byte[]{0, 0, 0, 0};
        byte[] p11class = new byte[]{3, 0, 0, 0};
        this.appendPKCS11Attribute(result, 288L, modulus);
        this.appendPKCS11Attribute(result, 256L, new TPSBuffer(keytype));
        this.appendPKCS11Attribute(result, 0L, new TPSBuffer(p11class));
        this.appendPKCS11Attribute(result, 258L, keyid);
        this.appendKeyCapabilities(result, keyTypePrefix, "private");
        this.finalizeObjectBuffer(result, id);
        logger.debug("SecureChannel.createPKCS11PriKeyAttrsBuffer: returing");
        return result;
    }

    public void createPKCS11PriKeyAttrs(String id, String label, TPSBuffer keyid, TPSBuffer modulus, String keyTypePrefix) throws TPSException, IOException {
        logger.debug("SecureChannel.createPKCS11PriKeyAttrsBuffer: entering...");
        if (id == null || label == null || keyid == null || modulus == null || keyTypePrefix == null) {
            throw new TPSException("SecureChannel.craetePKCS11PriKeyAttrsBuffer: invalid input data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSBuffer buffer = this.createPKCS11PriKeyAttrsBuffer(id, label, keyid, modulus, keyTypePrefix);
        byte[] perms = new byte[]{-1, -1, 64, 0, 64, 0};
        TPSBuffer permissions = new TPSBuffer(perms);
        this.createObject(new TPSBuffer(id), permissions, buffer);
    }

    public TPSBuffer createPKCS11PublicKeyAttrsBuffer(String id, String label, TPSBuffer keyid, TPSBuffer modulus, TPSBuffer exponent, String keyTypePrefix) throws TPSException {
        TPSBuffer result = new TPSBuffer();
        logger.debug("SecureChannel.createPKCS11PublicKeyAttrsBuffer: entering...");
        if (id == null || label == null || keyid == null || modulus == null || exponent == null || keyTypePrefix == null) {
            throw new TPSException("SecureChannel.craetePKCS11PublicKeyAttrsBuffer: invalid input data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        byte[] p11class = new byte[]{2, 0, 0, 0};
        this.appendPKCS11Attribute(result, 290L, exponent);
        this.appendPKCS11Attribute(result, 288L, modulus);
        this.appendPKCS11Attribute(result, 258L, keyid);
        this.appendPKCS11Attribute(result, 0L, new TPSBuffer(p11class));
        this.appendKeyCapabilities(result, keyTypePrefix, "public");
        this.finalizeObjectBuffer(result, id);
        logger.debug("SecureChannel.createPKCS11PublicKeyAttrsBuffer: returing");
        return result;
    }

    public void createPKCS11PublicKeyAttrs(String id, String label, TPSBuffer keyid, TPSBuffer modulus, TPSBuffer exponent, String keyTypePrefix) throws TPSException, IOException {
        logger.debug("SecureChannel.createPKCS11PublicKeyAttrsBuffer: entering...");
        if (id == null || label == null || keyid == null || modulus == null || exponent == null || keyTypePrefix == null) {
            throw new TPSException("SecureChannel.craetePKCS11PriKeyAttrsBuffer: invalid input data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        TPSBuffer buffer = this.createPKCS11PriKeyAttrsBuffer(id, label, keyid, modulus, keyTypePrefix);
        byte[] perms = new byte[]{-1, -1, 64, 0, 64, 0};
        TPSBuffer permissions = new TPSBuffer(perms);
        this.createObject(new TPSBuffer(id), permissions, buffer);
    }

    public void finalizeObjectBuffer(TPSBuffer buffer, String id) {
        TPSBuffer header = new TPSBuffer();
        header.add((byte)0);
        header.add((byte)id.charAt(0));
        header.add((byte)id.charAt(1));
        header.add((byte)0);
        header.add((byte)0);
        header.add((byte)(buffer.size() / 256));
        header.add((byte)(buffer.size() % 256));
        buffer.prepend(header);
    }

    public TPSBuffer createPKCS11CertAttrsBuffer(TokenKeyType keyType, String id, String label, TPSBuffer keyid) throws TPSException {
        if (keyType == null || id == null || label == null || keyid == null) {
            throw new TPSException("SecureChannel.createPKCS11CertAttrsBuffer. Bad input data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        byte[] type = new byte[]{0, 0, 0, 0};
        byte[] p11class = new byte[]{1, 0, 0, 0};
        byte[] tokenFlag = new byte[]{1};
        TPSBuffer result = new TPSBuffer();
        this.appendPKCS11Attribute(result, 3L, new TPSBuffer(label.getBytes()));
        this.appendPKCS11Attribute(result, 258L, keyid);
        this.appendPKCS11Attribute(result, 128L, new TPSBuffer(type));
        this.appendPKCS11Attribute(result, 0L, new TPSBuffer(p11class));
        this.appendPKCS11Attribute(result, 1L, new TPSBuffer(tokenFlag));
        this.finalizeObjectBuffer(result, id);
        logger.debug("SecureChannel.createPKCS11CertAttrsBuffer: returing");
        return result;
    }

    public void createObject(TPSBuffer objectID, TPSBuffer permissions, int len) throws TPSException, IOException {
        logger.debug("SecureChannel.createObject: entering...");
        if (objectID == null || permissions == null || len <= 0) {
            throw new TPSException("SecureChannel.createObject. Bad input data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        CreateObjectAPDU create = new CreateObjectAPDU(objectID.toBytesArray(), permissions.toBytesArray(), len);
        this.computeAPDU((APDU)create);
        APDUResponse response = this.processor.handleAPDURequest((APDU)create);
        if (!response.checkResult()) {
            throw new TPSException("SecureChannel.createObject. Failed to create object on token.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
    }

    public int startEnrollment(int pe1, int pe2, TPSBuffer wrappedChallenge, TPSBuffer keyCheck, int algorithm, int keySize, int option) throws TPSException, IOException {
        if (wrappedChallenge == null) {
            throw new TPSException("SecureChannel.startEnrollment. Bad input data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        logger.debug("SecureChannel.startEnrollment: entering ...");
        boolean isECC = TPSEngine.getInstance().isAlgorithmECC(algorithm);
        GenerateKeyAPDU generate_key_apdu = null;
        GenerateKeyECCAPDU generate_ecc_key_apdu = null;
        APDUResponse response = null;
        if (isECC) {
            generate_ecc_key_apdu = new GenerateKeyECCAPDU((byte)pe1, (byte)pe2, (byte)algorithm, keySize, (byte)option, 0, wrappedChallenge, keyCheck);
            this.computeAPDU((APDU)generate_ecc_key_apdu);
            response = this.processor.handleAPDURequest((APDU)generate_ecc_key_apdu);
            if (!response.checkResult()) {
                throw new TPSException("SecureChannel.startEnrollment. Failed generate key on token.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
        } else {
            generate_key_apdu = new GenerateKeyAPDU((byte)pe1, (byte)pe2, (byte)algorithm, keySize, (byte)option, 0, wrappedChallenge, keyCheck);
            this.computeAPDU((APDU)generate_key_apdu);
            response = this.processor.handleAPDURequest((APDU)generate_key_apdu);
            if (!response.checkResult()) {
                throw new TPSException("SecureChannel.startEnrollment. Failed generate key on token.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
            }
        }
        TPSBuffer data = response.getData();
        int size = data.getIntFrom2Bytes(0);
        logger.debug("SecureChannel.startEnrollment: returning key size: " + size);
        return size;
    }

    public int tokenTypeToInt(TokenKeyType type) {
        if (type == TokenKeyType.KEY_TYPE_ENCRYPTION) {
            return 0;
        }
        return type == TokenKeyType.KEY_TYPE_SIGNING ? 1 : 2;
    }

    public void setLifecycleState(byte flag) throws TPSException, IOException {
        String method = "SecureChannel.setLifecycleState: ";
        logger.debug(method + "flage: " + flag);
        LifecycleAPDU life = new LifecycleAPDU(flag);
        this.computeAPDU((APDU)life);
        APDUResponse response = this.processor.handleAPDURequest((APDU)life);
        if (!response.checkResult()) {
            logger.error(method + "result.checkResult() returns false; Throwing exception!");
            throw new TPSException("SecureChannel.setLifecycleState. Failed to set Lifecycle State!.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_LIFECYCLE_PDU);
        }
        logger.debug(method + "ends");
    }

    public void createPin(int pinNumber, int maxRetries, String pin) throws TPSException, IOException {
        logger.debug("SecureChannel.createPin:  entering...");
        if (pin == null) {
            throw new TPSException("SecureChannel.createPin: invalid intput data.", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_RESET_PIN_PDU);
        }
        TPSBuffer pinBuf = new TPSBuffer(pin.getBytes());
        CreatePinAPDU create = new CreatePinAPDU((byte)pinNumber, (byte)maxRetries, pinBuf);
        this.computeAPDU((APDU)create);
        APDUResponse response = this.processor.handleAPDURequest((APDU)create);
    }

    public void resetPin(int pinNumber, String new_pin) throws TPSException, IOException {
        logger.debug("SecureChannel.resetPin");
        if (new_pin == null) {
            throw new TPSException("SecureChannel.resetPin: invalid intput data.", EndOpMsg.TPSStatus.STATUS_ERROR_TOKEN_RESET_PIN_FAILED);
        }
        TPSBuffer newPinBuf = new TPSBuffer(new_pin.getBytes());
        SetPinAPDU reset = new SetPinAPDU(0, 0, newPinBuf);
        this.computeAPDU((APDU)reset);
        APDUResponse response = this.processor.handleAPDURequest((APDU)reset);
        if (!response.checkResult()) {
            throw new TPSException("SecureChannel.resetPin: failed to reset pin.", EndOpMsg.TPSStatus.STATUS_ERROR_TOKEN_RESET_PIN_FAILED);
        }
    }

    public void putKeys(byte curVersion, byte curIndex, TPSBuffer keySetData) throws TPSException, IOException {
        logger.debug("SecureChannel.putKeys: entering.. curVersion: " + curVersion + " curIndex:  " + curIndex + " keySetData: " + keySetData);
        if (keySetData == null) {
            throw new TPSException("SecureChannel.putKeys: Invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_KEY_CHANGE_OVER);
        }
        byte keyVersion = curVersion;
        if (curVersion == -1) {
            logger.debug("Setting keyVersion to 0");
            keyVersion = 0;
        }
        logger.debug("keyVersion now set to: " + keyVersion);
        PutKeyAPDU putKey = new PutKeyAPDU(keyVersion, -127, keySetData);
        if (this.isSCP02() || this.isSCP03()) {
            logger.debug("SecureChannel.putKeys: adding trailing 0 byte");
            TPSBuffer trailer = new TPSBuffer(1);
            putKey.setTrailer(trailer);
        }
        this.computeAPDU((APDU)putKey);
        APDUResponse response = this.processor.handleAPDURequest((APDU)putKey);
        if (!response.checkResult()) {
            throw new TPSException("SecureChannel.putKeys: failed to upgrade key set!", EndOpMsg.TPSStatus.STATUS_ERROR_KEY_CHANGE_OVER);
        }
    }

    public TPSBuffer getDRMWrappedDesKey() {
        return this.drmDesKey;
    }

    public void setDRMWrappedDesKey(TPSBuffer drmDesKey) {
        this.drmDesKey = drmDesKey;
    }

    public TPSBuffer getKeyCheck() {
        return this.keyCheck;
    }

    public void setKeyCheck(TPSBuffer theKeyCheck) {
        this.keyCheck = theKeyCheck;
    }

    public void importKeyEnc(int pe1, int pe2, TPSBuffer data) throws TPSException, IOException {
        logger.debug("SecureChannel.importKeyEnc entering...");
        if (data == null) {
            throw new TPSException("SecureChannel.importKeyEnc: Invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        ImportKeyEncAPDU importKeyEnc = new ImportKeyEncAPDU((byte)pe1, (byte)pe2, data);
        this.computeAPDU((APDU)importKeyEnc);
        APDUResponse response = this.processor.handleAPDURequest((APDU)importKeyEnc);
        if (!response.checkResult()) {
            throw new TPSException("SecureChannel.importKeyEnc: failed to import private key!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
    }

    public TPSBuffer getKekDesKey() {
        return this.kekDesKey;
    }

    public void setKekDesKey(TPSBuffer kekDesKey) {
        this.kekDesKey = kekDesKey;
    }

    public TPSBuffer getSequenceCounter() {
        return this.sequenceCounter;
    }

    public PlatformAndSecChannelProtoInfo getChannelPlatformAndProtocolInfo() {
        return this.platProtInfo;
    }

    protected TPSBuffer computeCardCryptogramSCP02(PK11SymKey encSessionKey) throws TPSException {
        if (encSessionKey == null) {
            throw new TPSException("TPSProcessor.computeCardCryptogramSCP02: invalide input data", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        TPSBuffer data = new TPSBuffer(this.hostChallenge);
        data.add(this.sequenceCounter);
        data.add(this.cardChallenge);
        if (data.size() != 16) {
            throw new TPSException("calculateCardCryptogramSCP02: card cyrptogram source data incorrect size.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        TPSBuffer cardCryptogram = null;
        try {
            cardCryptogram = Util.computeMAC((PK11SymKey)encSessionKey, (TPSBuffer)data, (TPSBuffer)this.icv);
        }
        catch (EBaseException e) {
            throw new TPSException("calculateCardCryptogramSCP02: card cyrptogram: Error calculating the MAC value", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("TPSProcessor.calculateCardCrytogramSCP02: returning calculated card cryptogram; " + cardCryptogram.toHexString());
        return cardCryptogram;
    }

    protected TPSBuffer computeHostCryptogramSCP02(PK11SymKey encSessionKey) throws TPSException {
        if (encSessionKey == null) {
            throw new TPSException("TPSProcessor.computeHostCryptogramSCP02: invalide input data", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        TPSBuffer hostCryptogramSCP02 = null;
        TPSBuffer data = new TPSBuffer(this.sequenceCounter);
        data.add(this.cardChallenge);
        data.add(this.hostChallenge);
        if (data.size() != 16) {
            throw new TPSException("calculateHostCryptogramSCP02: host cyrptogram source data incorrect size.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        try {
            hostCryptogramSCP02 = Util.computeMAC((PK11SymKey)encSessionKey, (TPSBuffer)data, (TPSBuffer)this.icv);
        }
        catch (EBaseException e) {
            throw new TPSException("calculateHostCryptogramSCP02: host cyrptogram: Error calculating the MAC value", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("TPSProcessor.calculateHostCrytogramSCP02: returning calculated host cryptogram; " + hostCryptogramSCP02.toHexString());
        return hostCryptogramSCP02;
    }

    public boolean isSCP03() {
        return this.platProtInfo.isSCP03();
    }

    public boolean isSCP02() {
        return this.platProtInfo.isGP211() && this.platProtInfo.isSCP02();
    }

    private boolean isGP211() {
        return this.platProtInfo.isGP211();
    }

    public TPSBuffer getDekSessionKeyWrapped() {
        return this.dekSessionKeyWrapped;
    }

    public void setDekSessionKeyWrapped(TPSBuffer dekSessionKeyWrapped) {
        this.dekSessionKeyWrapped = dekSessionKeyWrapped;
    }

    public PK11SymKey getDekSessionKey() {
        return this.dekSessionKey;
    }

    public void setDekSessionKey(PK11SymKey dekSessionKey) {
        this.dekSessionKey = dekSessionKey;
    }

    public PK11SymKey getRmacSessionKey() {
        return this.rmacSessionKey;
    }

    public void setRmacSessionKey(PK11SymKey rmacSessionKey) {
        this.rmacSessionKey = rmacSessionKey;
    }

    public static enum TokenKeyType {
        KEY_TYPE_ENCRYPTION,
        KEY_TYPE_SIGNING,
        KEY_TYPE_SIGNING_AND_ENCRYPTION;

    }
}

